/*
 * Copyright (C) 2013-2023 Federico Iosue (federico@iosue.it)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package it.feio.android.omninotes.models.views;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.LinearLayout;
import it.feio.android.omninotes.models.listeners.OnViewTouchedListener;


public class InterceptorLinearLayout extends LinearLayout {

  private OnViewTouchedListener mOnViewTouchedListener;


  public InterceptorLinearLayout(Context context) {
    super(context);
  }


  public InterceptorLinearLayout(Context context, AttributeSet attrs) {
    super(context, attrs);
  }


  @Override
  public boolean onInterceptTouchEvent(MotionEvent ev) {
    if (mOnViewTouchedListener != null) {
      mOnViewTouchedListener.onViewTouchOccurred(ev);
    }
    return super.onInterceptTouchEvent(ev);
  }


  public void setOnViewTouchedListener(OnViewTouchedListener mOnViewTouchedListener) {
    this.mOnViewTouchedListener = mOnViewTouchedListener;
  }

}
