/*
 * Copyright (C) 2013-2023 Federico Iosue (federico@iosue.it)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package it.feio.android.omninotes.models.adapters;

import android.content.Context;
import android.widget.ArrayAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import it.feio.android.omninotes.utils.GeocodeHelper;
import java.util.List;


public class PlacesAutoCompleteAdapter extends ArrayAdapter<String> implements Filterable {

  private static final int MIN_CHARS = 7;

  private List<String> resultList;


  public PlacesAutoCompleteAdapter(Context context, int textViewResourceId) {
    super(context, textViewResourceId);
  }


  @Override
  public int getCount() {
    return resultList.size();
  }


  @Override
  public String getItem(int index) {
    return resultList.get(index);
  }


  @Override
  public Filter getFilter() {
    return new Filter() {
      @Override
      protected FilterResults performFiltering(CharSequence constraint) {
        FilterResults filterResults = new FilterResults();
        if (constraint != null && constraint.length() > MIN_CHARS) {
          // Retrieve the autocomplete results.
          resultList = GeocodeHelper.autocomplete(constraint.toString());
          // Assign the data to the FilterResults
          filterResults.values = resultList;
          filterResults.count = resultList.size();
        }
        return filterResults;
      }


      @Override
      protected void publishResults(CharSequence constraint, FilterResults results) {
        if (results != null && results.count > 0) {
          notifyDataSetChanged();
        } else {
          notifyDataSetInvalidated();
        }
      }
    };
  }
}
