//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.14

use sea_orm::entity::prelude::*;

#[derive(Clone, Debug, PartialEq, DeriveEntityModel, Eq)]
#[sea_orm(table_name = "character")]
pub struct Model {
    #[sea_orm(primary_key)]
    pub id: i32,
    pub name: String,
    pub age: i32,
    #[sea_orm(column_type = "custom(\"enum_text\")")]
    pub culture: String,
    #[sea_orm(column_type = "custom(\"enum_text\")")]
    pub calling: String,
    pub distinctive_features: String,
    pub flaws: String,
    pub items_treasure_total: i32,
    pub items_treasure_carrying: i32,
    #[sea_orm(column_type = "Binary(72)")]
    pub characteristics_skills: Vec<u8>,
    #[sea_orm(column_type = "Binary(16)")]
    pub characteristics_combat_skills: Vec<u8>,
    pub characteristics_attributes_strength: i32,
    pub characteristics_attributes_heart: i32,
    pub characteristics_attributes_wits: i32,
    pub characteristics_attributes_endurance_current: i32,
    pub characteristics_attributes_endurance_max: i32,
    pub characteristics_attributes_hope_current: i32,
    pub characteristics_attributes_hope_max: i32,
    pub characteristics_attributes_parry: i32,
    pub characteristics_attributes_shadow_current: i32,
    pub characteristics_attributes_shadow_scars: i32,
    pub characteristics_attributes_shadow_path: String,
    pub characteristics_attributes_fatigue: i32,
    pub characteristics_adventure_experience_current: i32,
    pub characteristics_adventure_experience_total: i32,
    pub characteristics_skill_experience_current: i32,
    pub characteristics_skill_experience_total: i32,
    pub characteristics_valor: i32,
    pub characteristics_wisdom: i32,
    pub injury_duration: i32,
    #[sea_orm(column_type = "Text")]
    pub injury_description: String,
    #[sea_orm(column_type = "Text")]
    pub notes: String,
    pub one_shot_rules: bool,
    pub strider_mode: bool,
    pub owner_id: i32,
    #[sea_orm(column_type = "custom(\"enum_text\")")]
    pub char_type: String,
    pub player_name: String,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {
    #[sea_orm(has_many = "super::armor::Entity")]
    Armor,
    #[sea_orm(has_many = "super::equipment::Entity")]
    Equipment,
    #[sea_orm(has_many = "super::favoured_skill::Entity")]
    FavouredSkill,
    #[sea_orm(has_many = "super::fellowship_character::Entity")]
    FellowshipCharacter,
    #[sea_orm(has_many = "super::reward::Entity")]
    Reward,
    #[sea_orm(has_many = "super::shield::Entity")]
    Shield,
    #[sea_orm(
        belongs_to = "super::user::Entity",
        from = "Column::OwnerId",
        to = "super::user::Column::Id",
        on_update = "NoAction",
        on_delete = "NoAction"
    )]
    User,
    #[sea_orm(has_many = "super::virtue::Entity")]
    Virtue,
    #[sea_orm(has_many = "super::weapon::Entity")]
    Weapon,
}

impl Related<super::armor::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Armor.def()
    }
}

impl Related<super::equipment::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Equipment.def()
    }
}

impl Related<super::favoured_skill::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::FavouredSkill.def()
    }
}

impl Related<super::fellowship_character::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::FellowshipCharacter.def()
    }
}

impl Related<super::reward::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Reward.def()
    }
}

impl Related<super::shield::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Shield.def()
    }
}

impl Related<super::user::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::User.def()
    }
}

impl Related<super::virtue::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Virtue.def()
    }
}

impl Related<super::weapon::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Weapon.def()
    }
}

impl Related<super::fellowship::Entity> for Entity {
    fn to() -> RelationDef {
        super::fellowship_character::Relation::Fellowship.def()
    }
    fn via() -> Option<RelationDef> {
        Some(super::fellowship_character::Relation::Character.def().rev())
    }
}

impl ActiveModelBehavior for ActiveModel {}
