use serde::{Deserialize, Serialize};
use ts_rs::TS;

#[derive(Serialize, Deserialize, Clone, Copy, Debug, TS, Default)]
pub struct ComputedValue<Value> {
    pub value: Value,
    #[serde(default)]
    pub computed_value: Value,
}

impl<T> ComputedValue<T>
where
    T: Clone + Copy,
{
    pub fn new(value: T) -> Self {
        Self {
            value,
            computed_value: value,
        }
    }

    pub fn set_computed_value(&mut self, value: T) {
        self.computed_value = value;
    }
}
