const express = require("express");
const app = express();
const narvi = require("./google_sheet");
const mapping = require("./google_sheet_mapping.json");
const cors = require("cors");

narvi.initiate(null, console.log, console.log);

app.use(express.json());
app.use(cors({ origin: "*" }));

app.post("/", async (req, res, _) => {
    const body = req.body;
    if (body == null) {
        return;
    }
    const key = body.key;
    narvi.loadCharacter(key, null, (_keytype, _repositorykey, err) => {
        console.log("Failed to load character", err);
    });

    const character = {};
    for (const attribute of [
        ...Object.keys(mapping),
        ...narvi.skillList,
        ...narvi.combatSkillList,
    ]) {
        const value = await narvi.cacheDataFetch(key, attribute, "");
        character[attribute] = value;
    }

    for (const attribute of ["helm", "shield", "armour"]) {
        const value = await narvi.cacheDataFetch(key, "", attribute);
        character[attribute] = value;
    }
    res.send(character);
});

app.listen(3000, () => {
    console.log("Server is running on port 3000");
});
