import { getTauriVersion } from '@tauri-apps/api/app';
import { store_init } from './store';
import { sleep } from 'the-one-app-api/utils/utils';

class Tauri {
    is_tauri: boolean | null = $state(null);

    is_set(): boolean {
        return this.is_tauri != null;
    }
    async wait_tauri(): Promise<void> {
        let time = 0;
        const wait = 100;
        const max_wait = 2000;
        while (!this.is_set() && time < max_wait) {
            await sleep(wait);
            time += wait;
        }
        if (!this.is_set()) {
            throw new Error('Tauri is still not discovered');
        }
    }

    async init(): Promise<void> {
        try {
            const version = await getTauriVersion();
            console.log('With tauri', version);
            await store_init();
            this.is_tauri = true;
        } catch (error) {
            console.log(`Without tauri: ${error}`);
            this.is_tauri = false;
        }
        console.log('Setting variables');
    }
}

export const tauri = new Tauri();
