import type { WrapperMiddleware } from '@tolgee/core';
/**
 * LF character to separate messages (when they are right next to each other)
 *
 * We can use the fact that `\n` characters get escaped inside the JSON strings and we don't need them with numbers
 * so we can safely use newlines to separate strings
 *
 * WARNING: don't encode formatted json like this (because then there are newlines):
 * {
 *   "a": "b"
 * }
 * this is correct:
 * {"a":"b"}
 */
export declare const MESSAGE_END = "\n";
type Props = {
    fullKeyEncode: boolean;
};
export declare function InvisibleWrapper({ fullKeyEncode }: Props): WrapperMiddleware;
export {};
