import { CacheDescriptor, CacheDescriptorInternal, NsFallback, TranslationValue, TreeTranslationsData, BackendGetRecordInternal, LoadOptions, CacheInternalRecord } from '../../types';
import { TolgeeStaticDataProp } from '../State/initState';
import { ValueObserverInstance } from '../ValueObserver';
import { EventsInstance } from '../Events/Events';
export declare function Cache(events: EventsInstance, backendGetRecord: BackendGetRecordInternal, backendGetDevRecord: BackendGetRecordInternal, withDefaultNs: (descriptor: CacheDescriptor) => CacheDescriptorInternal, isInitialLoading: () => boolean, fetchingObserver: ValueObserverInstance<boolean>, loadingObserver: ValueObserverInstance<boolean>): Readonly<{
    addStaticData(data: TolgeeStaticDataProp | undefined): void;
    invalidate(): void;
    addRecord(descriptor: CacheDescriptorInternal, data: TreeTranslationsData): void;
    exists(descriptor: CacheDescriptorInternal, strict?: boolean): boolean;
    getRecord(descriptor: CacheDescriptor): CacheInternalRecord | undefined;
    getAllRecords(): (CacheInternalRecord | undefined)[];
    getTranslation(descriptor: CacheDescriptorInternal, key: string): TranslationValue;
    getTranslationNs(namespaces: string[], languages: string[], key: string): string[];
    getTranslationFallback(namespaces: string[], languages: string[], key: string): string | undefined;
    changeTranslation(descriptor: CacheDescriptorInternal, key: string, value: TranslationValue): void;
    isFetching(ns?: NsFallback): boolean;
    isLoading(language: string, ns?: NsFallback): boolean;
    loadRecords(descriptors: CacheDescriptor[], options?: LoadOptions): Promise<CacheInternalRecord[]>;
}>;
export type CacheInstance = ReturnType<typeof Cache>;
