var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { VUE_SCRIPT_REGULAR, VUE_SCRIPT_SETUP, VUE_COMPONENT_CONFIG, } from './contextConstants.js';
/*
 * We get this
 *
 * `(item) {item, item}`
 *
 * so we put the expression insides one level up (never mind the arguments):
 *
 * `item, item, item`
 */
function flattenOneLevel(nodes) {
    const result = [];
    nodes.forEach((node) => {
        if (node.type === 'expr') {
            result.push(...node.values);
        }
        else {
            result.push(node);
        }
    });
    return result;
}
/*
 * We get structure like this
 * {
 *   setup(item) {
 *      item, item
 *   }
 * }
 * and setup content should be on top level
 */
function bringSetupToTopLevel(context, node) {
    const setupContent = [];
    for (const item of node.values) {
        if (item.type === 'dict' && item.context === VUE_COMPONENT_CONFIG) {
            const _a = item.value, { setup } = _a, rest = __rest(_a, ["setup"]);
            if (setup.type === 'expr') {
                if (setup.values.length === 0) {
                    context.warnings.push({
                        line: setup.line,
                        warning: 'W_VUE_SETUP_IS_A_REFERENCE',
                    });
                }
                setupContent.push(...flattenOneLevel(setup.values));
                item.value = Object.assign({}, rest);
            }
        }
    }
    return [node, ...setupContent];
}
/**
 * Putting scripts to the top and extracting setup function, so:
 *
 * ```
 * <template>
 *  <div>{t('key1')}</div>
 * <template>
 * <script>
 * export default {
 *   setup() {
 *     const {t} = useTranslate('namespace')
 *   },
 *   ...
 * }
 * </script>
 * ```
 *
 * transforming essentially to this:
 *
 * ```
 * export default {
 *   ...
 * }
 * const {t} = useTranslate('namespace')
 * <template>
 *  <div>{{ t('key1') }}</div>
 * <template>
 * ```
 */
export const vueTreeTransform = (root) => {
    if (root.type !== 'expr') {
        return { tree: root };
    }
    const context = {
        keys: [],
        warnings: [],
    };
    const scripts = [];
    const other = [];
    for (const node of root.values) {
        if (node.type === 'expr' &&
            (node.context === VUE_SCRIPT_REGULAR || node.context === VUE_SCRIPT_SETUP)) {
            if (node.context === VUE_SCRIPT_REGULAR) {
                // we need to dig deeper for the `setup` function
                scripts.push(...bringSetupToTopLevel(context, node));
            }
            else {
                scripts.push(...node.values);
            }
        }
        else {
            other.push(node);
        }
    }
    // put scripts to top
    // and other to bottom
    root.values = [...scripts, ...other];
    return { tree: root, report: context };
};
