var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { join, dirname } from 'path';
import { mkdir, readFile, writeFile } from 'fs/promises';
import { warn } from '../utils/logger.js';
import { CONFIG_PATH } from '../constants.js';
const API_TOKENS_FILE = join(CONFIG_PATH, 'authentication.json');
function ensureConfigPath() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            yield mkdir(dirname(API_TOKENS_FILE));
        }
        catch (e) {
            if (e.code !== 'EEXIST') {
                throw e;
            }
        }
    });
}
export function loadStore() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            yield ensureConfigPath();
            const storeData = yield readFile(API_TOKENS_FILE, 'utf8');
            return JSON.parse(storeData);
        }
        catch (e) {
            if (e.code !== 'ENOENT') {
                throw e;
            }
        }
        return {};
    });
}
function saveStore(store) {
    return __awaiter(this, void 0, void 0, function* () {
        const blob = JSON.stringify(store);
        yield writeFile(API_TOKENS_FILE, blob, {
            mode: 0o600,
            encoding: 'utf8',
        });
    });
}
function storePat(store, instance, pat) {
    return __awaiter(this, void 0, void 0, function* () {
        return saveStore(Object.assign(Object.assign({}, store), { [instance.hostname]: Object.assign(Object.assign({}, (store[instance.hostname] || {})), { user: pat }) }));
    });
}
function storePak(store, instance, project, pak) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b;
        return saveStore(Object.assign(Object.assign({}, store), { [instance.hostname]: Object.assign(Object.assign({}, (store[instance.hostname] || {})), { projects: Object.assign(Object.assign({}, (((_a = store[instance.hostname]) === null || _a === void 0 ? void 0 : _a.projects) || {})), { [project.id.toString(10)]: pak }), projectDetails: Object.assign(Object.assign({}, (((_b = store[instance.hostname]) === null || _b === void 0 ? void 0 : _b.projectDetails) || {})), { [project.id.toString(10)]: { name: project.name } }) }) }));
    });
}
function removePak(store, instance, projectId) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b;
        (_a = store[instance.hostname].projects) === null || _a === void 0 ? true : delete _a[projectId.toString(10)];
        (_b = store[instance.hostname].projectDetails) === null || _b === void 0 ? true : delete _b[projectId.toString(10)];
        return saveStore(store);
    });
}
export function savePat(instance, pat) {
    return __awaiter(this, void 0, void 0, function* () {
        const store = yield loadStore();
        return storePat(store, instance, pat);
    });
}
export function savePak(instance, project, pak) {
    return __awaiter(this, void 0, void 0, function* () {
        const store = yield loadStore();
        return storePak(store, instance, project, pak);
    });
}
export function getApiKey(instance, projectId) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        const store = yield loadStore();
        if (!store[instance.hostname]) {
            return null;
        }
        const scopedStore = store[instance.hostname];
        if (scopedStore.user) {
            if (scopedStore.user.expires !== 0 &&
                Date.now() > scopedStore.user.expires) {
                warn(`Your personal access token for ${instance.hostname} expired.`);
                yield storePat(store, instance, undefined);
                return null;
            }
            return scopedStore.user.token;
        }
        if (projectId <= 0) {
            return null;
        }
        const pak = (_a = scopedStore.projects) === null || _a === void 0 ? void 0 : _a[projectId.toString(10)];
        if (pak) {
            if (pak.expires !== 0 && Date.now() > pak.expires) {
                warn(`Your project API key for project #${projectId} on ${instance.hostname} expired.`);
                yield removePak(store, instance, projectId);
                return null;
            }
            return pak.token;
        }
        return null;
    });
}
export function saveApiKey(instance, token) {
    return __awaiter(this, void 0, void 0, function* () {
        const store = yield loadStore();
        if (token.type === 'PAT') {
            return storePat(store, instance, {
                token: token.key,
                expires: token.expires,
            });
        }
        return storePak(store, instance, token.project, {
            token: token.key,
            expires: token.expires,
        });
    });
}
export function removeApiKeys(api) {
    return __awaiter(this, void 0, void 0, function* () {
        const store = yield loadStore();
        delete store[api.hostname];
        return saveStore(store);
    });
}
export function clearAuthStore() {
    return __awaiter(this, void 0, void 0, function* () {
        return saveStore({});
    });
}
