var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
export const createExportClient = ({ apiClient }) => {
    return {
        export(req) {
            return __awaiter(this, void 0, void 0, function* () {
                const body = Object.assign(Object.assign({}, req), { zip: true });
                const loadable = yield apiClient.POST('/v2/projects/{projectId}/export', {
                    params: { path: { projectId: apiClient.getProjectId() } },
                    body: body,
                    parseAs: 'blob',
                });
                return Object.assign(Object.assign({}, loadable), { data: loadable.data });
            });
        },
        exportSingle(req) {
            return __awaiter(this, void 0, void 0, function* () {
                return apiClient.POST('/v2/projects/{projectId}/export', {
                    params: { path: { projectId: apiClient.getProjectId() } },
                    body: Object.assign(Object.assign({}, req), { zip: false }),
                });
            });
        },
    };
};
