use enums::skill::SkillEnum;
use sea_orm_migration::{prelude::*, sea_orm::Iterable};

use crate::m20220101_000001_create_table::Equipment;

#[derive(DeriveMigrationName)]
pub struct Migration;

const SKILL: &str = "skill";

#[async_trait::async_trait]
impl MigrationTrait for Migration {
    async fn up(&self, manager: &SchemaManager) -> Result<(), DbErr> {
        manager
            .alter_table(
                Table::alter()
                    .table(Equipment::Table)
                    .add_column(
                        ColumnDef::new(Alias::new(SKILL))
                            .enumeration(Alias::new(SKILL), SkillEnum::iter())
                            .to_owned(),
                    )
                    .to_owned(),
            )
            .await
    }

    async fn down(&self, manager: &SchemaManager) -> Result<(), DbErr> {
        manager
            .alter_table(
                Table::alter()
                    .table(Equipment::Table)
                    .drop_column(Alias::new(SKILL))
                    .to_owned(),
            )
            .await
    }
}
