import type { Message } from 'the-one-app-api/the_one_app/bindings/Message';
import { get_role_dependend_backend } from './queries.svelte';
import { data } from './utils.svelte';
import { fellowship_data } from './fellowship_auth.svelte';

let messages: Message[] = $state([]);

export function get_messages(): Message[] {
    return messages;
}

function convert_date_to_rfc_3339(date: Date): string {
    return date.toISOString().replace('Z', '');
}

function get_player(player: null | string): string | null {
    if (data.is_player) {
        const f = fellowship_data.auth;
        if (f == null) {
            console.log('fellowship is null => skipping load messages');
            return null;
        }
        return f.player;
    } else {
        return player;
    }
}

export async function load_messages(player: null | string = null) {
    const resolved_player = get_player(player);
    const fellowship_id = fellowship_data.get_fellowship_id();
    const backend = await get_role_dependend_backend();
    messages = (await backend.get_messages(fellowship_id, resolved_player)).expect(
        'Failed to load messages'
    );
}

export async function add_message(player: string, text: string) {
    const message: Message = {
        player: player,
        to_loremaster: data.is_player,
        text: text,
        date: convert_date_to_rfc_3339(new Date())
    };
    const fellowship_id = fellowship_data.get_fellowship_id();
    const backend = await get_role_dependend_backend();
    (await backend.send_message(fellowship_id, message)).expect('Failed to send message');
    await load_messages();
}
