import js from '@eslint/js';
import globals from 'globals';
import tseslint from 'typescript-eslint';
import { defineConfig, globalIgnores } from 'eslint/config';

export default defineConfig([
    {
        files: ['**/*.{js,mjs,cjs,ts,mts,cts}'],
        plugins: { js, tseslint },
        extends: ['js/recommended'],
        languageOptions: { globals: globals.browser, parser: tseslint.parser }
    },
    globalIgnores(['build/']),
    js.configs.recommended,
    tseslint.configs.recommended,
    tseslint.configs.strict
]);
