var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { mkdir, rm } from 'fs/promises';
import { existsSync } from 'fs';
export function prepareDir(path, emptyDir) {
    return __awaiter(this, void 0, void 0, function* () {
        const exists = existsSync(path);
        if (emptyDir && exists) {
            yield rm(path, { recursive: true });
        }
        if (!exists || emptyDir) {
            // Create the directory
            yield mkdir(path, { recursive: true });
        }
    });
}
