var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { pathToFileURL } from 'url';
let jiti;
// https://github.com/eslint/eslint/blob/6f37b0747a14dfa9a9e3bdebc5caed1f39b6b0e2/lib/config/config-loader.js#L164-L197
function importTypeScript(file) {
    return __awaiter(this, void 0, void 0, function* () {
        // @ts-ignore
        if (!!globalThis.Bun || !!globalThis.Deno) {
            // We're in an env that natively supports TS
            return import(file);
        }
        if (!jiti) {
            const { createJiti } = yield import('jiti').catch(() => {
                throw new Error("The 'jiti' library is required for loading TypeScript extractors. Make sure to install it.");
            });
            jiti = createJiti(import.meta.url);
        }
        return jiti.import(file);
    });
}
export function loadModule(module) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        if (module.endsWith('.ts')) {
            return importTypeScript(module);
        }
        const fileUrl = pathToFileURL(module);
        const mdl = yield import(fileUrl.href);
        if ((_a = mdl.default) === null || _a === void 0 ? void 0 : _a.default) {
            return mdl.default;
        }
        return mdl;
    });
}
