import { pipeMachines } from '../parser/mergerMachine.js';
import { DEFAULT_BLOCKS, DEFAULT_MERGERS, Parser } from '../parser/parser.js';
import { svelteMapper } from './svelteMapper.js';
import { generalMapper } from '../parser/generalMapper.js';
import { tFunctionMerger } from './tokenMergers/tFunctionMerger.js';
import { getTranslateMerger } from './tokenMergers/getTranslateMerger.js';
import { scriptTagMerger } from './tokenMergers/scriptTagMerger.js';
import { tComponentMerger } from './tokenMergers/tComponentMerger.js';
import { tFunction } from './rules/tFunction.js';
import { getTranslate } from './rules/useTranslate.js';
import { tComponent } from './rules/tComponent.js';
import { scriptTag } from './rules/scriptTag.js';
import { svelteTreeTransform } from './svelteTreeTransform.js';
import { globalTFunction } from '../parser/rules/globalTFunction.js';
const svelteMappers = [generalMapper, svelteMapper];
export const svelteMergers = pipeMachines([
    ...DEFAULT_MERGERS,
    tFunctionMerger,
    getTranslateMerger,
    tComponentMerger,
    scriptTagMerger,
]);
export const ParserSvelte = () => {
    return Parser({
        mappers: svelteMappers,
        blocks: Object.assign({}, DEFAULT_BLOCKS),
        rules: [globalTFunction, tFunction, getTranslate, tComponent, scriptTag],
        treeTransform: svelteTreeTransform,
        merger: svelteMergers,
    });
};
