import { pipeMachines } from '../parser/mergerMachine.js';
import { DEFAULT_BLOCKS, DEFAULT_MERGERS, Parser } from '../parser/parser.js';
import { generalMapper } from '../parser/generalMapper.js';
import { reactMapper } from './jsxMapper.js';
import { createElementMerger } from './tokenMergers/createElementMerger.js';
import { tComponentMerger } from './tokenMergers/tComponentMerger.js';
import { tFunctionMerger } from './tokenMergers/tFunctionMerger.js';
import { useTranslateMerger } from './tokenMergers/useTranslateMerger.js';
import { reactCreateElement } from './rules/createElement.js';
import { tComponent } from './rules/tComponent.js';
import { tFunction } from './rules/tFunction.js';
import { useTranslate } from './rules/useTranslate.js';
import { globalTFunction } from '../parser/rules/globalTFunction.js';
const reactMappers = [generalMapper, reactMapper];
export const reactMergers = pipeMachines([
    ...DEFAULT_MERGERS,
    createElementMerger,
    useTranslateMerger,
    tFunctionMerger,
    tComponentMerger,
]);
export const ParserReact = () => {
    return Parser({
        mappers: reactMappers,
        blocks: Object.assign({}, DEFAULT_BLOCKS),
        rules: [
            globalTFunction,
            reactCreateElement,
            tComponent,
            tFunction,
            useTranslate,
        ],
        merger: reactMergers,
    });
};
