import { extractString, isString } from '../nodeUtils.js';
import { parseGeneral } from './parseGeneral.js';
// { key: 'value', ... }
// ^-------------------^
export function parseObject(context) {
    const { tokens, getCurrentLine } = context;
    const line = getCurrentLine();
    const result = { type: 'dict', line, value: {}, unknown: [] };
    tokens.next();
    let token;
    let state = 0 /* S.ExpectProperty */;
    let lastKey;
    function fallbackToBlock() {
        const combinedResult = {
            type: 'expr',
            line,
            values: [...Object.values(result.value), ...result.unknown],
        };
        const parsedContent = parseGeneral(context, {
            end: ['block.end'],
        });
        tokens.next();
        if (parsedContent.type === 'expr') {
            // avoid nesting
            combinedResult.values.push(...parsedContent.values);
        }
        else {
            combinedResult.values.push(parsedContent);
        }
        return combinedResult;
    }
    loop: while ((token = tokens.current())) {
        const type = token.customType;
        if (type === 'block.end') {
            tokens.next();
            break loop;
        }
        switch (state) {
            case 0 /* S.ExpectProperty */:
                if (type === 'object.key' || type === 'string') {
                    state = 1 /* S.ExpectDoubleColon */;
                    lastKey = token.token;
                }
                else if (type === 'variable') {
                    result.value[token.token] = {
                        type: 'expr',
                        line: getCurrentLine(),
                        values: [],
                    };
                    state = 3 /* S.ExpectComma */;
                }
                else if (type === 'list.begin') {
                    // dynamic key name '[value]: ...'
                    tokens.next();
                    const inside = parseGeneral(context, {
                        end: ['list.end'],
                    });
                    if (isString(inside)) {
                        lastKey = extractString(inside);
                    }
                    else {
                        // dynamic keyname
                        result.unknown.push(inside);
                        lastKey = undefined;
                    }
                    state = 1 /* S.ExpectDoubleColon */;
                }
                else if (type === 'kw.async') {
                    // there might be async function call,
                    // we can just ignore this keyword
                }
                else if (type === 'function.call') {
                    // shorthand for function definition, treat as dynamic value
                    result.value[token.token] = parseGeneral(context, {
                        end: ['separator.comma', 'block.end'],
                    });
                    state = 3 /* S.ExpectComma */;
                    // don't load next token, it was loaded by extract
                    continue;
                }
                else {
                    // it's not object, but block
                    // just somehow stich together already loaded values
                    // and the rest
                    return fallbackToBlock();
                }
                break;
            case 1 /* S.ExpectDoubleColon */:
                if (type === 'acessor.doublecolon') {
                    state = 2 /* S.ExpectValue */;
                }
                else {
                    // it's not object, but block
                    // just somehow stich together already loaded values
                    // and the rest
                    return fallbackToBlock();
                }
                break;
            case 2 /* S.ExpectValue */: {
                const value = parseGeneral(context, {
                    end: ['separator.comma', 'block.end'],
                });
                if (lastKey) {
                    result.value[lastKey] = value;
                }
                else {
                    // unknown key name
                    result.unknown.push(value);
                }
                lastKey = undefined;
                state = 3 /* S.ExpectComma */;
                // don't load next token, it was loaded by extract
                continue;
            }
            case 3 /* S.ExpectComma */:
                if (type === 'separator.comma') {
                    state = 0 /* S.ExpectProperty */;
                }
                else {
                    // it's not object, but block
                    // just somehow stich together already loaded values
                    // and the rest
                    return fallbackToBlock();
                }
                break;
        }
        tokens.next();
    }
    return result;
}
