var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import tokenizer from './tokenizer.js';
import { ParserReact } from './parserReact/ParserReact.js';
import { tokensList } from './visualizers/printTokens.js';
import { visualizeRules } from './visualizers/visualizeRules.js';
import { ParserVue } from './parserVue/ParserVue.js';
import { ParserNgx } from './parserNgx/ParserNgx.js';
import { ParserSvelte } from './parserSvelte/ParserSvelte.js';
function pickParser(format) {
    switch (format) {
        case 'react':
            return ParserReact();
        case 'vue':
            return ParserVue();
        case 'svelte':
            return ParserSvelte();
        case 'ngx':
            return ParserNgx();
    }
}
export function extractTreeAndReport(code, fileName, parserType, options) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        const debug = (_a = options.verbose) === null || _a === void 0 ? void 0 : _a.includes('extractor');
        const tokens = (yield tokenizer(code, fileName));
        const parser = pickParser(parserType);
        const tokensMerged = [];
        const tokensWithRules = [];
        let onAccept = undefined;
        if (debug) {
            onAccept = (token, type) => {
                tokensMerged.push(token);
                tokensWithRules.push(Object.assign(Object.assign({}, token), { customType: type }));
            };
        }
        const result = parser.parse({
            tokens,
            onAccept,
            options,
        });
        if (debug) {
            console.log(JSON.stringify(result.tree, null, 2) +
                '\n' +
                tokensList(tokensMerged) +
                '\n' +
                visualizeRules(tokensMerged, code) +
                '\n' +
                visualizeRules(tokensWithRules, code) +
                '\n');
        }
        return result;
    });
}
export default function extractor(code, fileName, parserType, options) {
    return __awaiter(this, void 0, void 0, function* () {
        const result = yield extractTreeAndReport(code, fileName, parserType, options);
        return result.report;
    });
}
