var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { Command } from 'commander';
import ansi from 'ansi-colors';
import { saveApiKey, removeApiKeys, clearAuthStore, } from '../config/credentials.js';
import { exitWithError, success } from '../utils/logger.js';
import { createTolgeeClient } from '../client/TolgeeClient.js';
import { printApiKeyLists } from '../utils/apiKeyList.js';
function loginHandler(key) {
    return __awaiter(this, void 0, void 0, function* () {
        const opts = this.optsWithGlobals();
        if (opts.list) {
            printApiKeyLists();
            return;
        }
        else if (!key) {
            exitWithError('Missing argument [API Key]');
        }
        const keyInfo = yield createTolgeeClient({
            baseUrl: opts.apiUrl.toString(),
            apiKey: key,
        }).getApiKeyInfo();
        yield saveApiKey(opts.apiUrl, keyInfo);
        success(keyInfo.type === 'PAK'
            ? `Logged in as ${keyInfo.username} on ${ansi.blue(opts.apiUrl.hostname)} for project ${ansi.blue(String(keyInfo.project.id))} (${keyInfo.project.name}). Welcome back!`
            : `Logged in as ${keyInfo.username} on ${ansi.blue(opts.apiUrl.hostname)}. Welcome back!`);
    });
}
function logoutHandler() {
    return __awaiter(this, void 0, void 0, function* () {
        const opts = this.optsWithGlobals();
        if (opts.all) {
            yield clearAuthStore();
            success("You've been logged out of all Tolgee instances you were logged in.");
            return;
        }
        yield removeApiKeys(opts.apiUrl);
        success(`You're now logged out of ${opts.apiUrl.hostname}.`);
    });
}
export const Login = new Command()
    .name('login')
    .description('Login to Tolgee with an API key. You can be logged into multiple Tolgee instances at the same time by using --api-url')
    .option('-l, --list', 'List existing api keys')
    .argument('[API Key]', 'The API key. Can be either a personal access token, or a project key')
    .action(loginHandler);
export const Logout = new Command()
    .name('logout')
    .description('Logs out of Tolgee')
    .option('--all', "Log out of *ALL* Tolgee instances you're logged into")
    .action(logoutHandler);
