var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { relative } from 'path';
import { Command } from 'commander';
import { extractKeysOfFiles } from '../../extractor/runner.js';
import { WarningMessages } from '../../extractor/warnings.js';
import { loading } from '../../utils/logger.js';
const printHandler = (config) => function () {
    return __awaiter(this, void 0, void 0, function* () {
        const opts = this.optsWithGlobals();
        const extracted = yield loading('Analyzing code...', extractKeysOfFiles(opts));
        let warningCount = 0;
        const keySet = new Set();
        for (const [file, { keys, warnings }] of extracted) {
            if (keys.length) {
                const relFile = relative(process.cwd(), file);
                console.log('%d key%s found in %s:', keys.length, keys.length !== 1 ? 's' : '', relFile);
                for (const key of keys) {
                    keySet.add(key);
                    console.log('\tline %d: %s', key.line, key.keyName);
                    if (key.namespace) {
                        console.log('\t\tnamespace: %s', key.namespace);
                    }
                    if (key.defaultValue) {
                        console.log('\t\tdefault: %s', key.defaultValue);
                    }
                }
            }
            if (warnings === null || warnings === void 0 ? void 0 : warnings.length) {
                warningCount += warnings.length;
                console.log('%d warning%s %s emitted during extraction:', warnings.length, warnings.length !== 1 ? 's' : '', warnings.length !== 1 ? 'were' : 'was');
                for (const warning of warnings) {
                    if (warning.warning in WarningMessages) {
                        const warn = warning.warning;
                        const { name } = WarningMessages[warn];
                        console.log('\tline %d: %s', warning.line, name);
                    }
                    else {
                        console.log('\tline %d: %s', warning.line, warning.warning);
                    }
                }
            }
            if (keys.length || (warnings === null || warnings === void 0 ? void 0 : warnings.length)) {
                console.log();
            }
        }
        console.log('Total unique keys found: %d', keySet.size);
        console.log('Total warnings: %d', warningCount);
    });
};
export default (config) => new Command('print')
    .description('Prints extracted data to the console')
    .action(printHandler(config));
