import { getUnresolvedConflictsMessage } from '../utils/printFailedKeys.js';
export const addErrorDetails = (loadable, showBeError = true) => {
    var _a, _b, _c, _d, _e;
    let additionalInfo = '';
    const items = [];
    items.push(`status: ${loadable.response.status}`);
    if (showBeError && ((_a = loadable.error) === null || _a === void 0 ? void 0 : _a.code)) {
        items.push(`code: ${loadable.error.code}`);
    }
    if (loadable.response.status === 403 && ((_c = (_b = loadable.error) === null || _b === void 0 ? void 0 : _b.params) === null || _c === void 0 ? void 0 : _c[0])) {
        items.push(`missing scope: ${loadable.error.params[0]}`);
    }
    if (((_d = loadable.error) === null || _d === void 0 ? void 0 : _d.code) === 'conflict_is_not_resolved' &&
        typeof ((_e = loadable.error.params) === null || _e === void 0 ? void 0 : _e[0]) === 'object') {
        additionalInfo += getUnresolvedConflictsMessage(loadable.error.params, true);
    }
    return `[${items.join(', ')}]${additionalInfo ? '\n' + additionalInfo : ''}`;
};
export const errorFromLoadable = (loadable) => {
    switch (loadable.response.status) {
        // Unauthorized
        case 400:
            return `Invalid request data ${addErrorDetails(loadable)}`;
        // Unauthorized
        case 401:
            return `Missing or invalid authentication token ${addErrorDetails(loadable)}`;
        // Forbidden
        case 403:
            return `You are not allowed to perform this operation ${addErrorDetails(loadable)}`;
        // Rate limited
        case 429:
            return `You've been rate limited. Please try again later ${addErrorDetails(loadable)}`;
        // Service Unavailable
        case 503:
            return `API is temporarily unavailable. Please try again later ${addErrorDetails(loadable)}`;
        // Server error
        case 500:
            return `API reported a server error. Please try again later ${addErrorDetails(loadable)}`;
        default:
            return `Unknown error ${addErrorDetails(loadable)}`;
    }
};
