import { exitWithError } from './../utils/logger.js';
import { createApiClient } from './ApiClient.js';
import { createExportClient } from './ExportClient.js';
import { createImportClient } from './ImportClient.js';
import { errorFromLoadable } from './errorFromLoadable.js';
export function createTolgeeClient(props) {
    const apiClient = createApiClient(props);
    return Object.assign(Object.assign({}, apiClient), { import: createImportClient({ apiClient }), export: createExportClient({ apiClient }) });
}
export const handleLoadableError = (loadable) => {
    if (loadable.error) {
        exitWithError(errorFromLoadable(loadable));
    }
};
