use std::cmp::max;

use sea_orm::DeriveIden;
use serde::{Deserialize, Serialize};
use strum::{EnumCount, EnumIter};
use ts_rs::TS;

use crate::combat_skill::CombatSkillEnum;

#[derive(Serialize, Deserialize, Default, Clone, EnumIter, TS, DeriveIden, Debug)]
#[ts(export)]
pub enum CombatProficiency {
    #[default]
    Brawling = 0,
    Swords = 1,
    Spears = 2,
    Axes = 3,
    Bows = 4,
}

impl CombatProficiency {
    pub fn get_skill_value(&self, combat_skills: [u32; CombatSkillEnum::COUNT]) -> u32 {
        match self {
            Self::Brawling => max(
                0,
                combat_skills.iter().max().expect("Failed to get max") - 1,
            ),
            Self::Swords => combat_skills[CombatSkillEnum::Swords as usize],
            Self::Spears => combat_skills[CombatSkillEnum::Spears as usize],
            Self::Axes => combat_skills[CombatSkillEnum::Axes as usize],
            Self::Bows => combat_skills[CombatSkillEnum::Bows as usize],
        }
    }
}
