use std::{
    collections::BTreeMap,
    fs::{File, read_to_string},
    io::Write,
};

pub const TRANSLATION_FILE: &str = "frontend/src/lib/i18n/en.json";

pub fn get_translations() -> BTreeMap<String, String> {
    let data = read_to_string(TRANSLATION_FILE).expect("Failed to open translations");
    serde_json::from_str(&data).expect("Failed to deserialize")
}

pub fn write_translations(translations: &BTreeMap<String, String>) {
    let translations = serde_json::to_string_pretty(&translations).expect("Failed to serialize");
    let mut file = File::create(TRANSLATION_FILE).expect("Failed to open translation file");
    write!(file, "{}", translations).expect("Failed to write translations");
}
