use anyhow::anyhow;
use axum::{extract::FromRequestParts, http::request::Parts};
use serde::Serialize;
use tracing::error;

use super::Fellowship;
use crate::{
    error::OwnError,
    server::{backend::AppState, users::User},
};

#[derive(Serialize, Debug, Clone)]
pub struct FellowshipRequest {
    pub fellowship: Fellowship,
    pub loremaster: User,
}

impl FellowshipRequest {
    pub fn new(fellowship: Fellowship, loremaster: User) -> Self {
        Self {
            fellowship,
            loremaster,
        }
    }
}

impl FromRequestParts<AppState> for FellowshipRequest {
    type Rejection = OwnError;

    async fn from_request_parts(
        parts: &mut Parts,
        state: &AppState,
    ) -> Result<Self, Self::Rejection> {
        let data = Fellowship::check_request(&state.db, parts)
            .await
            .map_err(|err| {
                error!(?err, "Unauthorized");
                anyhow!("Unauthorized")
            })?;
        Ok(FellowshipRequest::new(data.0, data.1))
    }
}
