//! `SeaORM` Entity, @generated by sea-orm-codegen 1.1.14

use sea_orm::entity::prelude::*;

#[derive(Clone, Debug, PartialEq, DeriveEntityModel, Eq)]
#[sea_orm(table_name = "armor")]
pub struct Model {
    #[sea_orm(primary_key)]
    pub id: i32,
    pub name: String,
    pub protection: i32,
    pub load: i32,
    pub wearing: bool,
    #[sea_orm(column_type = "Text")]
    pub notes: String,
    pub character_id: i32,
    pub famous: bool,
    #[sea_orm(column_type = "custom(\"enum_text\")", nullable)]
    pub enum_value: Option<String>,
}

#[derive(Copy, Clone, Debug, EnumIter, DeriveRelation)]
pub enum Relation {
    #[sea_orm(
        belongs_to = "super::character::Entity",
        from = "Column::CharacterId",
        to = "super::character::Column::Id",
        on_update = "NoAction",
        on_delete = "NoAction"
    )]
    Character,
    #[sea_orm(has_many = "super::reward_armor::Entity")]
    RewardArmor,
}

impl Related<super::character::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::Character.def()
    }
}

impl Related<super::reward_armor::Entity> for Entity {
    fn to() -> RelationDef {
        Relation::RewardArmor.def()
    }
}

impl Related<super::reward::Entity> for Entity {
    fn to() -> RelationDef {
        super::reward_armor::Relation::Reward.def()
    }
    fn via() -> Option<RelationDef> {
        Some(super::reward_armor::Relation::Armor.def().rev())
    }
}

impl ActiveModelBehavior for ActiveModel {}
