use std::fmt::Debug;

use anyhow::Result;
use sea_orm::ConnectionTrait;
use std::future::Future;

pub trait AdvantageTrait: Sized + Clone + Debug {
    type Enum;
    fn set_id(&mut self, id: Option<i32>);
    fn get_title(&self) -> &str;
    fn from_enum(value: Self::Enum) -> Self;
    fn get_enum(&self) -> Option<Self::Enum>;
    // TODO delete (compatibility)
    fn find_enum(&mut self) -> bool;
    fn get_id(&self) -> Option<i32>;
    fn is_available_at_creation(&self) -> bool;
    fn is_available(&self) -> bool {
        true
    }
    fn from_db_model<C: ConnectionTrait>(
        db: &C,
        character_id: i32,
    ) -> impl Future<Output = Result<Vec<Self>>> + Send;
    fn save<C: ConnectionTrait>(
        &self,
        db: &C,
        character_id: i32,
    ) -> impl Future<Output = Result<()>> + Send;

    fn delete_by_character_id<C: ConnectionTrait>(
        db: &C,
        character_id: i32,
    ) -> impl Future<Output = Result<()>> + Send;

    fn delete_by_id<C: ConnectionTrait>(
        db: &C,
        character_id: i32,
        id: i32,
    ) -> impl Future<Output = Result<()>> + Send;
}
