use enums::{armor::ArmorEnum, shield::ShieldEnum, weapon::WeaponEnum};
use sea_orm_migration::{prelude::*, sea_orm::Iterable};

use crate::m20220101_000001_create_table::{Armor, Shield, Weapon};

#[derive(DeriveMigrationName)]
pub struct Migration;

const ENUM: &str = "enum_value";

#[async_trait::async_trait]
impl MigrationTrait for Migration {
    async fn up(&self, manager: &SchemaManager) -> Result<(), DbErr> {
        manager
            .alter_table(
                Table::alter()
                    .table(Weapon::Table)
                    .add_column(
                        ColumnDef::new(Alias::new(ENUM))
                            .enumeration(Alias::new(ENUM), WeaponEnum::iter())
                            .to_owned(),
                    )
                    .to_owned(),
            )
            .await?;
        manager
            .alter_table(
                Table::alter()
                    .table(Armor::Table)
                    .add_column(
                        ColumnDef::new(Alias::new(ENUM))
                            .enumeration(Alias::new(ENUM), ArmorEnum::iter())
                            .to_owned(),
                    )
                    .to_owned(),
            )
            .await?;
        manager
            .alter_table(
                Table::alter()
                    .table(Shield::Table)
                    .add_column(
                        ColumnDef::new(Alias::new(ENUM))
                            .enumeration(Alias::new(ENUM), ShieldEnum::iter())
                            .to_owned(),
                    )
                    .to_owned(),
            )
            .await
    }

    async fn down(&self, manager: &SchemaManager) -> Result<(), DbErr> {
        manager
            .alter_table(
                Table::alter()
                    .table(Weapon::Table)
                    .drop_column(Alias::new(ENUM))
                    .to_owned(),
            )
            .await?;
        manager
            .alter_table(
                Table::alter()
                    .table(Armor::Table)
                    .drop_column(Alias::new(ENUM))
                    .to_owned(),
            )
            .await?;
        manager
            .alter_table(
                Table::alter()
                    .table(Shield::Table)
                    .drop_column(Alias::new(ENUM))
                    .to_owned(),
            )
            .await
    }
}
