use enums::fell_ability::FellAbilityEnum;
use sea_orm_migration::{prelude::*, sea_orm::Iterable};

use crate::m20220101_000001_create_table::FellAbility;

#[derive(DeriveMigrationName)]
pub struct Migration;

const ENUM: &str = "enum_value";

#[async_trait::async_trait]
impl MigrationTrait for Migration {
    async fn up(&self, manager: &SchemaManager) -> Result<(), DbErr> {
        manager
            .alter_table(
                Table::alter()
                    .table(FellAbility::Table)
                    .add_column(
                        ColumnDef::new(Alias::new(ENUM))
                            .enumeration(Alias::new(ENUM), FellAbilityEnum::iter())
                            .to_owned(),
                    )
                    .to_owned(),
            )
            .await
    }

    async fn down(&self, manager: &SchemaManager) -> Result<(), DbErr> {
        manager
            .alter_table(
                Table::alter()
                    .table(FellAbility::Table)
                    .drop_column(Alias::new(ENUM))
                    .to_owned(),
            )
            .await
    }
}
