use sea_orm_migration::{prelude::*, schema::*};

use crate::m20220101_000001_create_table::{Armor, Equipment, Reward, Shield, Weapon};

#[derive(DeriveMigrationName)]
pub struct Migration;

#[async_trait::async_trait]
impl MigrationTrait for Migration {
    async fn up(&self, manager: &SchemaManager) -> Result<(), DbErr> {
        // Weapon
        manager
            .create_table(
                Table::create()
                    .table(RewardWeapon::Table)
                    .if_not_exists()
                    .primary_key(
                        Index::create()
                            .col(RewardWeapon::WeaponId)
                            .col(RewardWeapon::RewardId),
                    )
                    .col(integer(RewardWeapon::WeaponId))
                    .foreign_key(
                        ForeignKey::create()
                            .name("weapon")
                            .from(RewardWeapon::Table, RewardWeapon::WeaponId)
                            .to(Weapon::Table, Weapon::Id),
                    )
                    .col(integer(RewardWeapon::RewardId).unique_key())
                    .foreign_key(
                        ForeignKey::create()
                            .name("reward")
                            .from(RewardWeapon::Table, RewardWeapon::RewardId)
                            .to(Reward::Table, Reward::Id),
                    )
                    .to_owned(),
            )
            .await?;

        // Armor
        manager
            .create_table(
                Table::create()
                    .table(RewardArmor::Table)
                    .if_not_exists()
                    .primary_key(
                        Index::create()
                            .col(RewardArmor::ArmorId)
                            .col(RewardArmor::RewardId),
                    )
                    .col(integer(RewardArmor::ArmorId))
                    .foreign_key(
                        ForeignKey::create()
                            .name("armor")
                            .from(RewardArmor::Table, RewardArmor::ArmorId)
                            .to(Armor::Table, Armor::Id),
                    )
                    .col(integer(RewardArmor::RewardId).unique_key())
                    .foreign_key(
                        ForeignKey::create()
                            .name("reward")
                            .from(RewardArmor::Table, RewardArmor::RewardId)
                            .to(Reward::Table, Reward::Id),
                    )
                    .to_owned(),
            )
            .await?;

        // Shield
        manager
            .create_table(
                Table::create()
                    .table(RewardShield::Table)
                    .if_not_exists()
                    .primary_key(
                        Index::create()
                            .col(RewardShield::ShieldId)
                            .col(RewardShield::RewardId),
                    )
                    .col(integer(RewardShield::ShieldId))
                    .foreign_key(
                        ForeignKey::create()
                            .name("shield")
                            .from(RewardShield::Table, RewardShield::ShieldId)
                            .to(Shield::Table, Shield::Id),
                    )
                    .col(integer(RewardShield::RewardId).unique_key())
                    .foreign_key(
                        ForeignKey::create()
                            .name("reward")
                            .from(RewardShield::Table, RewardShield::RewardId)
                            .to(Reward::Table, Reward::Id),
                    )
                    .to_owned(),
            )
            .await?;

        // Equipment
        manager
            .create_table(
                Table::create()
                    .table(RewardEquipment::Table)
                    .if_not_exists()
                    .primary_key(
                        Index::create()
                            .col(RewardEquipment::EquipmentId)
                            .col(RewardEquipment::RewardId),
                    )
                    .col(integer(RewardEquipment::EquipmentId))
                    .foreign_key(
                        ForeignKey::create()
                            .name("equipment")
                            .from(RewardEquipment::Table, RewardEquipment::EquipmentId)
                            .to(Equipment::Table, Equipment::Id),
                    )
                    .col(integer(RewardEquipment::RewardId).unique_key())
                    .foreign_key(
                        ForeignKey::create()
                            .name("reward")
                            .from(RewardEquipment::Table, RewardEquipment::RewardId)
                            .to(Reward::Table, Reward::Id),
                    )
                    .to_owned(),
            )
            .await
    }

    async fn down(&self, manager: &SchemaManager) -> Result<(), DbErr> {
        manager
            .drop_table(Table::drop().table(RewardEquipment::Table).to_owned())
            .await?;
        manager
            .drop_table(Table::drop().table(RewardShield::Table).to_owned())
            .await?;
        manager
            .drop_table(Table::drop().table(RewardArmor::Table).to_owned())
            .await?;
        manager
            .drop_table(Table::drop().table(RewardWeapon::Table).to_owned())
            .await
    }
}

#[derive(DeriveIden)]
enum RewardWeapon {
    Table,
    WeaponId,
    RewardId,
}

#[derive(DeriveIden)]
enum RewardArmor {
    Table,
    ArmorId,
    RewardId,
}

#[derive(DeriveIden)]
enum RewardShield {
    Table,
    ShieldId,
    RewardId,
}

#[derive(DeriveIden)]
enum RewardEquipment {
    Table,
    EquipmentId,
    RewardId,
}
