use sea_orm_migration::prelude::*;

use crate::m20220101_000001_create_table::{Armor, Equipment, Shield, Weapon};

#[derive(DeriveMigrationName)]
pub struct Migration;

const FAMOUS: &str = "famous";

#[async_trait::async_trait]
impl MigrationTrait for Migration {
    async fn up(&self, manager: &SchemaManager) -> Result<(), DbErr> {
        manager
            .alter_table(
                Table::alter()
                    .table(Armor::Table)
                    .add_column(
                        ColumnDef::new(Alias::new(FAMOUS))
                            .boolean()
                            .not_null()
                            .default(false)
                            .to_owned(),
                    )
                    .to_owned(),
            )
            .await?;
        manager
            .alter_table(
                Table::alter()
                    .table(Equipment::Table)
                    .add_column(
                        ColumnDef::new(Alias::new(FAMOUS))
                            .boolean()
                            .not_null()
                            .default(false)
                            .to_owned(),
                    )
                    .to_owned(),
            )
            .await?;
        manager
            .alter_table(
                Table::alter()
                    .table(Shield::Table)
                    .add_column(
                        ColumnDef::new(Alias::new(FAMOUS))
                            .boolean()
                            .not_null()
                            .default(false)
                            .to_owned(),
                    )
                    .to_owned(),
            )
            .await?;
        manager
            .alter_table(
                Table::alter()
                    .table(Weapon::Table)
                    .add_column(
                        ColumnDef::new(Alias::new(FAMOUS))
                            .boolean()
                            .not_null()
                            .default(false)
                            .to_owned(),
                    )
                    .to_owned(),
            )
            .await
    }

    async fn down(&self, manager: &SchemaManager) -> Result<(), DbErr> {
        manager
            .alter_table(
                Table::alter()
                    .table(Armor::Table)
                    .drop_column(Alias::new(FAMOUS))
                    .to_owned(),
            )
            .await?;
        manager
            .alter_table(
                Table::alter()
                    .table(Equipment::Table)
                    .drop_column(Alias::new(FAMOUS))
                    .to_owned(),
            )
            .await?;
        manager
            .alter_table(
                Table::alter()
                    .table(Shield::Table)
                    .drop_column(Alias::new(FAMOUS))
                    .to_owned(),
            )
            .await?;
        manager
            .alter_table(
                Table::alter()
                    .table(Weapon::Table)
                    .drop_column(Alias::new(FAMOUS))
                    .to_owned(),
            )
            .await
    }
}
