use enums::{reward::RewardEnum, virtue::VirtueEnum};
use sea_orm::Iterable;
use sea_orm_migration::prelude::*;

use crate::m20220101_000001_create_table::{Reward, Virtue};

#[derive(DeriveMigrationName)]
pub struct Migration;

const COLUMN_ENUM: &str = "enum_value";

#[async_trait::async_trait]
impl MigrationTrait for Migration {
    async fn up(&self, manager: &SchemaManager) -> Result<(), DbErr> {
        manager
            .alter_table(
                Table::alter()
                    .table(Virtue::Table)
                    .add_column(
                        ColumnDef::new(Alias::new(COLUMN_ENUM))
                            .enumeration(Alias::new("virtue"), VirtueEnum::iter())
                            .to_owned(),
                    )
                    .to_owned(),
            )
            .await?;
        manager
            .alter_table(
                Table::alter()
                    .table(Reward::Table)
                    .add_column(
                        ColumnDef::new(Alias::new(COLUMN_ENUM))
                            .enumeration(Alias::new("reward"), RewardEnum::iter())
                            .to_owned(),
                    )
                    .to_owned(),
            )
            .await
    }

    async fn down(&self, manager: &SchemaManager) -> Result<(), DbErr> {
        manager
            .alter_table(
                Table::alter()
                    .table(Virtue::Table)
                    .drop_column(Alias::new(COLUMN_ENUM))
                    .to_owned(),
            )
            .await?;
        manager
            .alter_table(
                Table::alter()
                    .table(Reward::Table)
                    .drop_column(Alias::new(COLUMN_ENUM))
                    .to_owned(),
            )
            .await
    }
}
