import type { Adversary } from 'the-one-app-api/the_one_app/bindings/Adversary';
import type { Item } from 'the-one-app-api/the_one_app/bindings/Item';
import type { Patron } from 'the-one-app-api/the_one_app/bindings/Patron';

export function translate_adversary(adv: Adversary, t: (_: string) => string): Adversary {
    if (adv.id != null) {
        return adv;
    }

    adv.combat_proficiencies = adv.combat_proficiencies.map((x) => {
        x.special_damages = x.special_damages.map((x) => t(x));

        x.weapon = t(x.weapon);
        return x;
    });

    adv.abilities = adv.abilities.map((x) => {
        x.description = t(x.description);
        x.title = t(x.title);
        return x;
    });

    adv.features = adv.features.map((x) => t(x));
    adv.name = t(adv.name);
    return adv;
}

export function translate_item(item: Item, t: (_: string) => string): Item {
    item.name = t(item.name);
    item.notes = t(item.notes);
    return item;
}

export function translate_patron(patron: Patron, t: (_: string) => string): Patron {
    patron.advantage = t(patron.advantage);
    patron.name = t(patron.name);
    return patron;
}
