import { Socket, SocketMessage } from 'the-one-app-api/the_one_app/socket';
import { fellowship_data } from './fellowship_auth.svelte';
import { toast } from '@zerodevx/svelte-toast';
import { load_messages } from './chat.svelte';
import { get_role_dependend_backend } from './queries.svelte';
import { FellowshipAuth } from 'the-one-app-api/the_one_app/queries';
import { data } from './utils.svelte';

let socket: Socket | null = null;

export function get_socket(): Socket | null {
    return socket;
}

export async function setup_socket() {
    console.log('Setting up sockets');

    const backend = await get_role_dependend_backend();
    const auth =
        fellowship_data.auth == null
            ? new FellowshipAuth('', '', new URL('http://localhost'), '')
            : fellowship_data.auth;
    socket = new Socket(backend, auth, handle_event);
    socket.setup_socket(data.is_player);
}

export async function handle_event(event: MessageEvent) {
    await process_async_socket(event, SocketMessage.UpdateFellowship, async () => {
        await fellowship_data.update_fellowship();
    });

    await process_async_socket(event, SocketMessage.UpdateMessage, async () => {
        toast.push('New message');
        await load_messages();
    });

    // Not parsable case
    process_socket_error(event);
}

// Process a received message from socket (async)
async function process_async_socket<T>(
    event: MessageEvent,
    data_type: SocketMessage,
    func: (_: T) => Promise<void>
): Promise<void> {
    try {
        if (event.data.includes('{')) {
            const data = JSON.parse(event.data);
            if (data_type in data) {
                await func(data[data_type]);
            }
        } else {
            const data = event.data.replaceAll('"', '');
            console.log('Process socket async', data, data_type);
            if (data == data_type) {
                await func(data);
            }
        }
    } catch (error) {
        console.log('Socket error', error);
        console.log('data: ', event.data);
        toast.push(`Failed to communicate on the websocket: ${event.data}`);
    }
}

// Simple error process with a toast
function process_socket_error(event: MessageEvent) {
    if (event.data.includes('error') || event.data.includes('Error')) {
        toast.push(`Error: ${event.data}`);
    }
}
