import { expect, test } from 'vitest';
import { fetch_narvi } from './narvi';
import { narvi_to_the_one_app } from 'the-one-app-api/utils/convert';

test('narvi', async () => {
    const narvi = await fetch_narvi(
        'http://localhost:3000/',
        '1R0LKF6pnT2Fsf2DbcCYYmP4RD6AhCJG9JYkO4zUUGP8'
    );
    const character = narvi_to_the_one_app(narvi);

    // Summary
    expect(character.name).eq('Bob');
    expect(character.culture).eq('HobbitOfBree');
    expect(character.calling).eq('Scholar');
    expect(character.age).eq(34);
    expect(character.distinctive_features).toEqual(['Faithful', 'Eager', 'Rhymes of Lore']);
    expect(character.id).eq(null);
    expect(character.player_name).eq('');
    expect(character.flaws).toEqual([]);
    expect(character.notes).eq('');
    expect(character.one_shot_rules).eq(false);
    expect(character.strider_mode).eq(false);
    expect(character.char_type).eq('Internal');

    // Injury
    expect(character.injury.description).eq('');
    expect(character.injury.duration).eq(10);

    // Treasure
    expect(character.items.treasure.carrying).eq(15);
    expect(character.items.treasure.total).eq(10);

    // Skill points
    expect(character.characteristics.skill_experience.current).eq(4);
    expect(character.characteristics.skill_experience.total).eq(14);

    // Adventure points
    expect(character.characteristics.adventure_experience.current).eq(5);
    expect(character.characteristics.adventure_experience.total).eq(17);

    // Attributes
    expect(character.characteristics.attributes.strength.value).eq(4);
    expect(character.characteristics.attributes.heart.value).eq(5);
    expect(character.characteristics.attributes.wits.value).eq(6);
    expect(character.characteristics.attributes.endurance.current).eq(18);
    expect(character.characteristics.attributes.endurance.max).eq(22);
    expect(character.characteristics.attributes.fatigue).eq(1);
    expect(character.characteristics.attributes.hope.current).eq(10);
    expect(character.characteristics.attributes.hope.max).eq(15);
    expect(character.characteristics.attributes.shadow.current).eq(2);
    expect(character.characteristics.attributes.shadow.scars).eq(1);
    expect(character.characteristics.attributes.shadow.path).eq('Wandering-madness');
    expect(character.characteristics.attributes.parry.value).eq(18);

    // Skills
    expect(character.characteristics.skills.favoured).toEqual(['Hunting', 'Insight', 'Riddle']);
    expect(character.characteristics.skills.skills).toEqual([
        0, 2, 1, 1, 1, 2, 2, 1, 2, 0, 3, 0, 2, 1, 1, 1, 2, 0
    ]);

    // Combat skills
    expect(character.characteristics.combat_skills.skills).toEqual([0, 2, 1, 0]);

    // Valor
    expect(character.characteristics.valor.advantages.map((x) => x.title)).toEqual(['Test']);
    expect(character.characteristics.valor.value).eq(1);

    // Wisdom
    expect(character.characteristics.wisdom.advantages.map((x) => x.title)).toEqual([
        'Hobbit-sense',
        'Test2'
    ]);
    expect(character.characteristics.wisdom.value).eq(1);

    // Weapons
    expect(character.items.weapons.length).eq(2);

    // Weapon 0
    expect(character.items.weapons[0].id).eq(null);
    expect(character.items.weapons[0].name).eq('aersdaf');
    expect(character.items.weapons[0].damage).eq(4);
    expect(character.items.weapons[0].injury).eq(3);
    expect(character.items.weapons[0].two_hand_injury).eq(null);
    expect(character.items.weapons[0].combat_proficiency).eq('Bows');
    expect(character.items.weapons[0].load).eq(2);
    expect(character.items.weapons[0].wearing).eq(false);
    expect(character.items.weapons[0].famous).eq(false);
    expect(character.items.weapons[0].rewards).toEqual([]);
    expect(character.items.weapons[0].notes).eq(
        'Elven, Grievous, Mithril Weapon, Superior Grievous, Wolves'
    );

    // Weapon 1
    expect(character.items.weapons[1].id).eq(null);
    expect(character.items.weapons[1].name).eq('Short sword');
    expect(character.items.weapons[1].damage).eq(3);
    expect(character.items.weapons[1].injury).eq(16);
    expect(character.items.weapons[1].two_hand_injury).eq(null);
    expect(character.items.weapons[1].combat_proficiency).eq('Swords');
    expect(character.items.weapons[1].load).eq(1);
    expect(character.items.weapons[1].wearing).eq(true);
    expect(character.items.weapons[1].famous).eq(false);
    expect(character.items.weapons[1].rewards).toEqual([]);
    expect(character.items.weapons[1].notes).eq('Wolves');

    // Armors
    expect(character.items.armors.length).eq(2);

    // Armor 0
    expect(character.items.armors[0].id).eq(null);
    expect(character.items.armors[0].name).eq('daf');
    expect(character.items.armors[0].protection).eq(1);
    expect(character.items.armors[0].load).eq(3);
    expect(character.items.armors[0].wearing).eq(true);
    expect(character.items.armors[0].famous).eq(false);
    expect(character.items.armors[0].rewards).toEqual([]);
    expect(character.items.armors[0].notes).toEqual('Dwarven, Close-Fitting');

    // Armor 1
    expect(character.items.armors[1].id).eq(null);
    expect(character.items.armors[1].name).eq('Coat of mail');
    expect(character.items.armors[1].protection).eq(4);
    expect(character.items.armors[1].load).eq(12);
    expect(character.items.armors[1].wearing).eq(false);
    expect(character.items.armors[1].famous).eq(false);
    expect(character.items.armors[1].rewards).toEqual([]);
    expect(character.items.armors[1].notes).eq('Shadow Taint');

    // Shield
    expect(character.items.shields.length).eq(1);
    expect(character.items.shields[0].id).eq(null);
    expect(character.items.shields[0].name).eq('Shield');
    expect(character.items.shields[0].parry).eq(2);
    expect(character.items.shields[0].load).eq(4);
    expect(character.items.shields[0].wearing).eq(true);
    expect(character.items.shields[0].famous).toEqual(false);
    expect(character.items.shields[0].rewards).toEqual([]);
    expect(character.items.shields[0].notes).eq('Númenórean');

    // Equipment
    expect(character.items.equipments.length).eq(5);

    // Equipment 0
    expect(character.items.equipments[0].id).eq(null);
    expect(character.items.equipments[0].name).eq('adf');
    expect(character.items.equipments[0].notes).eq('Awareness');
    expect(character.items.equipments[0].wearing).eq(true);
    expect(character.items.equipments[0].famous).eq(false);
    expect(character.items.equipments[0].rewards).toEqual([]);
    expect(character.items.equipments[0].load).eq(0);

    // Equipment 1
    expect(character.items.equipments[1].id).eq(null);
    expect(character.items.equipments[1].name).eq('adfad');
    expect(character.items.equipments[1].notes).eq('');
    expect(character.items.equipments[1].wearing).eq(true);
    expect(character.items.equipments[1].famous).eq(false);
    expect(character.items.equipments[1].rewards).toEqual([]);
    expect(character.items.equipments[1].load).eq(0);

    // Equipment 2
    expect(character.items.equipments[2].id).eq(null);
    expect(character.items.equipments[2].name).eq('aospqwr');
    expect(character.items.equipments[2].notes).eq('');
    expect(character.items.equipments[2].wearing).eq(true);
    expect(character.items.equipments[2].famous).eq(false);
    expect(character.items.equipments[2].rewards).toEqual([]);
    expect(character.items.equipments[2].load).eq(0);

    // Equipment 3
    expect(character.items.equipments[3].id).eq(null);
    expect(character.items.equipments[3].name).eq('dqsrfqae');
    expect(character.items.equipments[3].notes).eq('Awareness, Craft');
    expect(character.items.equipments[3].wearing).eq(true);
    expect(character.items.equipments[3].famous).eq(false);
    expect(character.items.equipments[3].rewards).toEqual([]);
    expect(character.items.equipments[3].load).eq(0);

    // Equipment 4
    expect(character.items.equipments[4].id).eq(null);
    expect(character.items.equipments[4].name).eq('ads213123');
    expect(character.items.equipments[4].notes).eq('Riddle');
    expect(character.items.equipments[4].wearing).eq(true);
    expect(character.items.equipments[4].famous).eq(false);
    expect(character.items.equipments[4].rewards).toEqual([]);
    expect(character.items.equipments[4].load).eq(0);
});
