import type { StateCap } from 'the-one-app-api/the_one_app/bindings/StateCap';
import type { Adversary } from 'the-one-app-api/the_one_app/bindings/Adversary';
import type { Choices } from 'the-one-app-api/the_one_app/bindings/Choices';
import type { Character } from 'the-one-app-api/the_one_app/bindings/Character';
import type { CombatSkills } from 'the-one-app-api/the_one_app/bindings/CombatSkills';
import type { Culture } from 'the-one-app-api/the_one_app/bindings/Culture';
import type { DerivedStats } from 'the-one-app-api/the_one_app/bindings/DerivedStats';
import type { Improvements } from 'the-one-app-api/the_one_app/bindings/Improvements';
import type { Items } from 'the-one-app-api/the_one_app/bindings/Items';
import type { ItemsDerived } from 'the-one-app-api/the_one_app/bindings/ItemsDerived';
import type { Reward } from 'the-one-app-api/the_one_app/bindings/Reward';
import type { Roll } from 'the-one-app-api/the_one_app/bindings/Roll';
import type { RollStatistics } from 'the-one-app-api/the_one_app/bindings/RollStatistics';
import type { Treasure } from 'the-one-app-api/the_one_app/bindings/Treasure';
import type { TreasureDerived } from 'the-one-app-api/the_one_app/bindings/TreasureDerived';
import type { Virtue } from 'the-one-app-api/the_one_app/bindings/Virtue';
import type { Patron } from 'the-one-app-api/the_one_app/bindings/Patron';
import type { Fellowship } from 'the-one-app-api/the_one_app/bindings/Fellowship';
import type { AddToFellowship } from 'the-one-app-api/the_one_app/bindings/AddToFellowship';
import { get_username } from './queries.svelte';
import type { Equipment } from 'the-one-app-api/the_one_app/bindings/Equipment';
import type { Calling } from 'the-one-app-api/the_one_app/bindings/Calling';

export function get_default_items_derived(): ItemsDerived {
    return {
        protection: 0,
        parry: 0,
        load: 0
    };
}

export function get_default_treasure_derived(): TreasureDerived {
    return {
        standard_of_living: 'Frugal'
    };
}

export function get_default_treasure(): Treasure {
    return {
        total: 0,
        carrying: 0,
        derived: get_default_treasure_derived()
    };
}

export function get_default_items(): Items {
    return {
        weapons: [],
        armors: [],
        shields: [],
        equipments: [],
        treasure: get_default_treasure(),
        derived: get_default_items_derived()
    };
}

export function get_default_reward(): Reward {
    return {
        id: 0,
        title: '',
        enum_value: null,
        description: '',
        available_at_creation: true,
        linked_item: null,
        implemented: false
    };
}

export function get_default_virtue(): Virtue {
    return {
        id: 0,
        title: '',
        enum_value: null,
        description: '',
        text_input: '',
        available: true,
        available_at_creation: true,
        restricted_to: null,
        implemented: false
    };
}

export function get_default_improvements(): Improvements {
    return {
        skills: {},
        combat: {}
    };
}

export function get_default_choices(): Choices {
    return {
        character_name: '',
        culture: 'Barding',
        calling: 'Warden',
        attributes: 0,
        culture_skill: null,
        calling_skills: [],
        distinctive_features: [],
        all_combat_skill: null,
        available_combat_skill: null,
        items: get_default_items(),
        reward: get_default_reward(),
        virtue: get_default_virtue(),
        previous_experience: 0,
        improvements: get_default_improvements(),
        one_shot_rules: false,
        strider_mode: false
    };
}

export function get_default_combat_skills(): CombatSkills {
    return {
        skills: [0, 0, 0, 0]
    };
}

export function get_default_derived_stats(): DerivedStats {
    return {
        endurance: 0,
        hope: 0,
        parry: 0
    };
}

export function get_default_culture(): Culture {
    return {
        attributes: [],
        treasures: 0,
        blessings: [],
        derived_stats: get_default_derived_stats(),
        favoured_skills: [],
        skills: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        combat_skills: [],
        distinctive_features: []
    };
}

export function get_default_calling(): Calling {
    return {
        distinctive_feature: '',
        favoured_skills: [],
        shadow_path: ''
    };
}

export function get_default_roll_statistics(): RollStatistics {
    return {
        average_value: 0,
        average_tengwar: 0,
        number_gandalf: 0,
        probabilities: []
    };
}

export function get_default_patron(): Patron {
    return {
        id: null,
        name: '',
        fellowship_points: 0,
        advantage: ''
    };
}

export function get_default_fellowship(): Fellowship {
    return {
        id: null,
        patron: get_default_patron(),
        characters: [],
        adversaries: [],
        name: '',
        points: 0,
        eye: 0
    };
}

export function get_default_roll(): Roll {
    return {
        success_dices: [],
        feat_dice: { Normal: 0 },
        total: null
    };
}

export function get_default_add_to_fellowship(character: Character): AddToFellowship {
    const username = get_username();
    return {
        character: character,
        fellowship: '',
        loremaster: '',
        user: username == null ? '' : username,
        origin: 'Local'
    };
}

function get_default_state_cap(): StateCap {
    return {
        computed_max: 0,
        current: 0,
        max: 0
    };
}

export function get_default_equipment(): Equipment {
    return {
        id: 0,
        load: { value: 0, computed_value: 0 },
        name: '',
        notes: '',
        wearing: true,
        famous: false,
        rewards: [],
        skill: null
    };
}

export function get_default_adversary(): Adversary {
    return {
        id: null,
        name: '',
        features: [],
        attribute_level: 0,
        endurance: get_default_state_cap(),
        might: 0,
        hate: get_default_state_cap(),
        hate_type: 'Hate',
        parry: 0,
        armour: 0,
        combat_proficiencies: [],
        abilities: []
    };
}
