import { data } from '$lib/utils.svelte';
import type { Armor } from 'the-one-app-api/the_one_app/bindings/Armor';
import type { AttributeField } from 'the-one-app-api/the_one_app/bindings/AttributeField';
import type { Character } from 'the-one-app-api/the_one_app/bindings/Character';
import type { Equipment } from 'the-one-app-api/the_one_app/bindings/Equipment';
import type { Reward } from 'the-one-app-api/the_one_app/bindings/Reward';
import type { SecondaryAttribute } from 'the-one-app-api/the_one_app/bindings/SecondaryAttribute';
import type { Shield } from 'the-one-app-api/the_one_app/bindings/Shield';
import type { Virtue } from 'the-one-app-api/the_one_app/bindings/Virtue';
import type { Weapon } from 'the-one-app-api/the_one_app/bindings/Weapon';
import { ItemTypes } from 'the-one-app-api/the_one_app/queries';
import { type SecondaryAttributeEnum } from 'the-one-app-api/the_one_app/bindings/SecondaryAttributeEnum';
import { get_backend } from '$lib/queries.svelte';
import { toast } from '@zerodevx/svelte-toast';

export enum NavPages {
    Description,
    Notes,
    Strength,
    Heart,
    Wits,
    Combat,
    Rewards,
    Virtues,
    Weapon,
    Armor,
    Shield,
    Equipment
}

export enum Attributes {
    Strength = 'strength',
    Heart = 'heart',
    Wits = 'wits'
}

export enum AttributeSecondaryLabel {
    Hope = 'hope',
    Endurance = 'endurance',
    Parry = 'parry'
}

export function get_attribute(char: Character, attribute: Attributes): AttributeField {
    switch (attribute) {
        case Attributes.Heart:
            return char.characteristics.attributes.heart;
        case Attributes.Strength:
            return char.characteristics.attributes.strength;
        case Attributes.Wits:
            return char.characteristics.attributes.wits;
    }
}

export function get_secondary_attribute(
    char: Character,
    attribute: SecondaryAttributeEnum
): SecondaryAttribute<Reward | Virtue> {
    switch (attribute) {
        case 'Valor':
            return char.characteristics.valor;
        case 'Wisdom':
            return char.characteristics.wisdom;
    }
}

export function get_items(
    char: Character,
    items: ItemTypes
): Weapon[] | Armor[] | Shield[] | Equipment[] {
    switch (items) {
        case ItemTypes.Armor:
            return char.items.armors;
        case ItemTypes.Equipment:
            return char.items.equipments;
        case ItemTypes.Shield:
            return char.items.shields;
        case ItemTypes.Weapon:
            return char.items.weapons;
    }
}
export async function increase_endurance_hope(
    character: Character,
    field: 'endurance' | 'hope',
    increase: number
): Promise<void> {
    if (data.character_id === null) {
        toast.push('Character name is null, should not happen');
        return;
    }
    const new_value = (
        await (await get_backend()).loose(data.character_id, field, -increase)
    ).expect(`Failed to remove ${field}`);
    if (field == 'endurance') {
        character.characteristics.attributes.endurance.current = new_value;
    } else {
        character.characteristics.attributes.hope.current = new_value;
    }
}
