"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g = Object.create((typeof Iterator === "function" ? Iterator : Object).prototype);
    return g.next = verb(0), g["throw"] = verb(1), g["return"] = verb(2), typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AsyncOption = void 0;
var asyncresult_js_1 = require("./asyncresult.js");
var option_js_1 = require("./option.js");
/**
 * An async-aware `Option` counterpart.
 *
 * Can be combined with asynchronous code without having to ``await`` anything right until
 * the moment when you're ready to extract the final ``Option`` out of it.
 *
 * Can also be combined with synchronous code for convenience.
 */
var AsyncOption = /** @class */ (function () {
    /**
     * Constructs an `AsyncOption` from an `Option` or a `Promise` of an `Option`.
     *
     * @example
     * ```typescript
     * const option = new AsyncOption(Promise.resolve(Some('username')))
     * ```
     */
    function AsyncOption(start) {
        this.promise = Promise.resolve(start);
    }
    /**
     * Calls `mapper` if the option is `Some`, otherwise keeps the `None` value intact.
     * This function can be used for control flow based on `Option` values.
     *
     * @example
     * ```typescript
     * let hasValue = Some(1).toAsyncOption()
     * let noValue = None.toAsyncOption()
     *
     * await hasValue.andThen(async (value) => Some(value * 2)).promise // Some(2)
     * await hasValue.andThen(async (value) => None).promise // None
     * await noValue.andThen(async (value) => Ok(value * 2)).promise // None
     * ```
     */
    AsyncOption.prototype.andThen = function (mapper) {
        var _this = this;
        return this.thenInternal(function (option) { return __awaiter(_this, void 0, void 0, function () {
            var mapped;
            return __generator(this, function (_a) {
                if (option.isNone()) {
                    return [2 /*return*/, option];
                }
                mapped = mapper(option.value);
                return [2 /*return*/, mapped instanceof AsyncOption ? mapped.promise : mapped];
            });
        }); });
    };
    /**
     * Maps an `AsyncOption<T>` to `AsyncOption<U>` by applying a function to a contained
     * `Some` value, leaving a `None` value untouched.
     *
     * This function can be used to compose the results of two functions.
     *
     * @example
     * ```typescript
     * let hasValue = Ok(1).toAsyncOption()
     * let noValue = None.toAsyncOption()
     *
     * await hasValue.map(async (value) => value * 2).promise // Some(2)
     * await noValue.map(async (value) => value * 2).promise // None
     * ```
     */
    AsyncOption.prototype.map = function (mapper) {
        var _this = this;
        return this.thenInternal(function (option) { return __awaiter(_this, void 0, void 0, function () {
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        if (option.isNone()) {
                            return [2 /*return*/, option];
                        }
                        _a = option_js_1.Some;
                        return [4 /*yield*/, mapper(option.value)];
                    case 1: return [2 /*return*/, _a.apply(void 0, [_b.sent()])];
                }
            });
        }); });
    };
    /**
     * Returns the value from `other` if this `AsyncOption` contains `None`, otherwise returns self.
     *
     * If `other` is a result of a function call consider using `orElse` instead, it will
     * only evaluate the function when needed.
     *
     * @example
     * ```
     * const noValue = new AsyncOption(None)
     * const hasValue = new AsyncOption(Some(1))
     *
     * await noValue.or(Some(123)).promise // Some(123)
     * await hasValue.or(Some(123)).promise // Some(1)
     * ```
     */
    AsyncOption.prototype.or = function (other) {
        return this.orElse(function () { return other; });
    };
    /**
     * Returns the value obtained by calling `other` if this `AsyncOption` contains `None`, otherwise
     * returns self.
     *
     * @example
     * ```
     * const noValue = new AsyncOption(None)
     * const hasValue = new AsyncOption(Some(1))
     *
     * await noValue.orElse(() => Some(123)).promise // Some(123)
     * await hasValue.orElse(() => Some(123)).promise // Some(1)
     * ```
     */
    AsyncOption.prototype.orElse = function (other) {
        var _this = this;
        return this.thenInternal(function (option) { return __awaiter(_this, void 0, void 0, function () {
            var otherValue;
            return __generator(this, function (_a) {
                if (option.isSome()) {
                    return [2 /*return*/, option];
                }
                otherValue = other();
                return [2 /*return*/, otherValue instanceof AsyncOption ? otherValue.promise : otherValue];
            });
        }); });
    };
    /**
     * Converts an `AsyncOption<T>` to an `AsyncResult<T, E>` so that `None` is converted to
     * `Err(error)` and `Some` is converted to `Ok`.
     */
    AsyncOption.prototype.toResult = function (error) {
        return new asyncresult_js_1.AsyncResult(this.promise.then(function (option) { return option.toResult(error); }));
    };
    AsyncOption.prototype.thenInternal = function (mapper) {
        return new AsyncOption(this.promise.then(mapper));
    };
    return AsyncOption;
}());
exports.AsyncOption = AsyncOption;
//# sourceMappingURL=asyncoption.js.map