import type { fade, fly, scale, slide } from "svelte/transition";
import type { Coords, Middleware, Placement, Strategy } from "@floating-ui/dom";
import type { ClassValue } from "clsx";
import type { Component, Snippet } from "svelte";
import type { HTMLAnchorAttributes, HTMLAttributes, HTMLBlockquoteAttributes, HTMLButtonAttributes, HTMLDialogAttributes, HTMLImgAttributes, HTMLInputAttributes, HTMLLabelAttributes, HTMLLiAttributes, HTMLOlAttributes, HTMLSelectAttributes, HTMLSourceAttributes, HTMLTableAttributes, HTMLTdAttributes, HTMLTextareaAttributes, HTMLThAttributes, HTMLTrackAttributes, HTMLVideoAttributes, SVGAttributes, FullAutoFill } from "svelte/elements";
import { type Writable } from "svelte/store";
import type { BlurParams, EasingFunction, FadeParams, FlyParams, ScaleParams, SlideParams, TransitionConfig } from "svelte/transition";
import { tv, type VariantProps } from "tailwind-variants";
import type { CheckboxVariants } from "./forms/checkbox/theme";
import type { FileuploadViariants } from "./forms/fileupload/theme";
import type { FloatingLabelInputVaratiants } from "./forms/floating-label/theme";
import type { HelperVariants } from "./forms/helper/theme";
import type { InputVariants } from "./forms/input-field/theme";
import type { LabelVariants } from "./forms/label/theme";
import type { RadioVariants } from "./forms/radio/theme";
import type { RangeVariants } from "./forms/range/theme";
import type { SearchVariants } from "./forms/search/theme";
import type { MultiSelectVariants, SelectVariants } from "./forms/select/theme";
import type { ToggleVariants } from "./forms/toggle/theme";
import type { IndicatorVariants } from "./indicator/theme";
import type { ListgroupItemVariants, ListgroupVariants } from "./list-group/theme";
import type { ModalVariants } from "./modal/theme";
import type { PopoverVariants } from "./popover/theme";
import type { SidebarVariants } from "./sidebar/theme";
import type { CardPlaceholderVariants, ImagePlaceholderVariants, ListPlaceholderVariants, SkeletonVariants, TextPlaceholderVariants, VideoPlaceholderVariants } from "./skeleton/theme";
import type { SpinnerVaraiants } from "./spinner/theme";
import type { StepperVariants, ProgressStepperVariants, DetailedStepperVariants, VerticalStepperVariants, BreadcrumbStepperVariants, TimelineStepperVariants } from "./stepper/theme";
import type { TableVariants } from "./table/theme";
import type { TabsVaraints } from "./tabs/theme";
import type { PaginationItemVariants, PaginationVariants } from "./pagination/theme";
import type { ProgressbarVariants, ProgressradialVariants } from "./progress/theme";
import { baseThemes } from "./theme";
import { timeline } from "./timeline/theme";
import type { ToastVaraints } from "./toast/theme";
import type { ToolbarButtonVariants, ToolbarGroupVariants, ToolbarVariants } from "./toolbar/theme";
import type { TooltipVariants } from "./tooltip/theme";
import type { ApexOptions } from "apexcharts";
import type { AlertVariants } from "./alert/theme";
import type { BadgeVariants } from "./badge/theme";
import type { BannerVariants } from "./banner/theme";
import type { ButtonVariants, GradientButtonVariantes, gradientButton } from "./buttons/theme";
import type { CardVariants } from "./card/theme";
import type Slide from "./carousel/Slide.svelte";
import type { CarouselVariants } from "./carousel/theme";
import type { DrawerVariants } from "./drawer/theme";
import type { closeButtonVariants } from "./utils/theme";
import type { ButtonToggleVariants } from "./forms/button-toggle/theme";
import type { AnchorVariants } from "./typography/anchor/theme";
import type { BlockquoteVariants } from "./typography/blockquote/theme";
import type { DescriptionListVariants } from "./typography/descriptionlist/theme";
import type { HeadingVariants } from "./typography/heading/theme";
import type { ImgVariants } from "./typography/img/theme";
import type { ListVariants } from "./typography/list/theme";
import type { ParagraphVariants } from "./typography/paragraph/theme";
import type { SpanVariants } from "./typography/span/theme";
import type { ClipboardVariants } from "./clipboard/theme";
export interface ThemeConfig {
    slots?: Record<string, object | string>;
    variants?: Record<string, object>;
    compoundVariants?: Array<Record<string, object>>;
    defaultVariants?: Record<string, object>;
}
export interface ThemeType {
    [key: string]: ReturnType<typeof tv>;
}
export declare const xs = "xs";
export declare const sm = "sm";
export declare const md = "md";
export declare const lg = "lg";
export declare const xl = "xl";
export interface drawerTransitionParamTypes {
    amount?: number;
    delay?: number;
    duration?: number;
    easing?: (t: number) => number;
    opacity?: number;
    x?: number;
    y?: number;
}
export type FormSizeType = "sm" | "md" | "lg";
export type CloseButtonVariants = VariantProps<typeof closeButtonVariants>;
export type CloseButtonProps = CloseButtonVariants & AnchorButtonAttributes & {
    onclick?: (ev: MouseEvent) => void;
    name?: string;
    ariaLabel?: string;
    class?: string;
    svgClass?: string;
};
export type NavbarType = {
    navStatus?: boolean;
    breakPoint: "md" | "lg" | "xl" | "xxl";
    activeClass?: string | null;
    nonActiveClass?: string | null;
    closeNav: () => void;
};
export type DeviceVariantType = "default" | "ios" | "android" | "tablet" | "laptop" | "desktop" | "smartwatch";
export declare type SizeType = typeof xs | typeof sm | typeof md | typeof lg | typeof xl;
export type TransitionTypes = "fade" | "fly" | "slide" | "blur" | "in:fly" | "out:fly" | "in:slide" | "out:slide" | "in:fade" | "out:fade" | "in:blur" | "out:blur";
export interface TransitionParamTypes {
    delay?: number;
    duration?: number;
    easing?: (t: number) => number;
    css?: (t: number, u: number) => string | null;
    tick?: (t: number, u: number) => void;
}
export type ParamsType = FadeParams | BlurParams | FlyParams | SlideParams | ScaleParams | undefined;
export type TransitionFunc = (node: HTMLElement, params: ParamsType) => TransitionConfig;
export type ModalPlacementType = "top-left" | "top-center" | "top-right" | "center-left" | "center" | "center-right" | "bottom-left" | "bottom-center" | "bottom-right";
export interface LinkType {
    name: string;
    href?: string;
    rel?: string;
    active?: boolean;
    [propName: string]: any;
}
export type AnchorButtonAttributes = ({
    href: string;
} & HTMLAnchorAttributes) | ({
    href?: undefined;
} & HTMLButtonAttributes);
export type AnchorDivAttributes = ({
    href: string;
} & HTMLAnchorAttributes) | ({
    href?: undefined;
} & HTMLAttributes<HTMLDivElement>);
export type AnchorButtonDivAttributes = ({
    href: string;
} & HTMLAnchorAttributes) | ({
    href?: undefined;
    onclick: Function;
} & HTMLButtonAttributes) | ({
    href?: undefined;
    onclick?: undefined;
} & HTMLAttributes<HTMLDivElement>);
export interface AccordionCtxType {
    flush: boolean;
    activeClass?: string | null;
    inactiveClass?: string | null;
    selected?: Writable<object>;
    classActive?: string;
    classInactive?: string;
    multiple?: boolean;
}
export interface AccordionProps extends HTMLAttributes<HTMLDivElement> {
    children: Snippet;
    flush?: boolean;
    multiple?: boolean;
    activeClass?: string;
    inactiveClass?: string;
    defaultClass?: string;
    classActive?: string;
    classInactive?: string;
    transitionType?: TransitionFunc | "none";
}
export interface AccordionItemProps extends HTMLAttributes<HTMLDivElement> {
    children: Snippet;
    header?: Snippet;
    arrowup?: Snippet;
    arrowdown?: Snippet;
    open?: boolean;
    activeClass?: string;
    inactiveClass?: string;
    transitionType?: TransitionFunc | "none";
    transitionParams?: ParamsType;
    headerClass?: string;
    contentClass?: string;
}
export interface AlertProps extends Omit<AlertVariants, "icon">, Omit<HTMLAttributes<HTMLDivElement>, "color"> {
    children: Snippet;
    icon?: Snippet;
    alertStatus?: boolean;
    closeIcon?: Component;
    transition?: TransitionFunc;
    params?: ParamsType;
    onclick?: () => void;
}
export interface AvatarProps extends HTMLAttributes<HTMLDivElement> {
    children?: Snippet;
    indicator?: Snippet;
    href?: HTMLAnchorAttributes["href"];
    target?: HTMLAnchorAttributes["target"];
    src?: string;
    cornerStyle?: "rounded" | "circular";
    stacked?: boolean;
    dot?: object;
    alt?: string;
    size?: "xs" | "sm" | "md" | "lg" | "xl";
    onclick?: () => void;
    border?: boolean;
}
export interface BadgeProps extends BadgeVariants, Omit<HTMLAttributes<HTMLDivElement>, "color"> {
    children: Snippet;
    icon?: Snippet;
    badgeStatus?: boolean;
    large?: boolean;
    dismissable?: boolean;
    href?: HTMLAnchorAttributes["href"];
    target?: HTMLAnchorAttributes["target"];
    transition?: TransitionFunc;
    params?: ParamsType;
    onclose?: (ev: Event) => void;
    aClass?: ClassValue;
}
export interface BannerProps extends BannerVariants, HTMLAttributes<HTMLDivElement> {
    header?: Snippet;
    open?: boolean;
    dismissable?: boolean;
    color?: BannerVariants["color"];
    innerClass?: ClassValue;
    transition?: TransitionFunc;
    params?: object;
    closeClass?: ClassValue;
}
export type BottomNavVariantType = "border" | "application" | "group" | "default" | "pagination" | "card" | "meeting" | "video" | undefined;
export type PositionType = "static" | "fixed" | "absolute" | "relative" | "sticky" | undefined;
export type BottomNavContextType = {
    activeClass?: string | null;
};
export type AppBtnPositionType = "middle" | "left" | "right" | undefined;
export interface BottomNavProps extends HTMLAttributes<HTMLDivElement> {
    children: Snippet;
    header?: Snippet;
    activeUrl?: string;
    position?: PositionType;
    navType?: BottomNavVariantType;
    outerClass?: ClassValue;
    innerClass?: ClassValue;
    activeClass?: ClassValue;
}
export interface BottomNavItemProps {
    children: Snippet;
    btnName?: string;
    appBtnPosition?: AppBtnPositionType;
    activeClass?: ClassValue;
    btnClass?: ClassValue;
    spanClass?: ClassValue;
    active?: boolean;
    id?: string;
    style?: string;
    tabindex?: number;
    title?: string;
    role?: string;
    "aria-label"?: string;
    "data-testid"?: string;
    href?: string;
    target?: string;
    rel?: string;
    download?: string | boolean;
    type?: "button" | "submit" | "reset";
    disabled?: boolean;
    name?: string;
    value?: string | number | string[];
    [key: string]: any;
}
export interface BottomNavHeaderProps {
    children: Snippet;
    outerClass?: ClassValue;
    innerClass?: ClassValue;
}
export interface BottomNavHeaderItemProps extends HTMLButtonAttributes {
    itemName: string;
    active?: boolean;
}
export interface BreadcrumbProps extends HTMLAttributes<HTMLElement> {
    children: Snippet;
    solid?: boolean;
    olClass?: ClassValue;
    ariaLabel?: string;
}
export interface BreadcrumbItemProps extends HTMLLiAttributes {
    children: Snippet;
    icon?: Snippet;
    home?: boolean;
    href?: string;
    linkClass?: ClassValue;
    spanClass?: ClassValue;
    homeClass?: ClassValue;
}
export interface ButtonGroupProps extends HTMLAttributes<HTMLDivElement> {
    children: Snippet;
    size?: ButtonGroupSizeType;
    disabled?: boolean;
}
export type ButtonGroupSizeType = "sm" | "md" | "lg" | undefined;
export type GradientButtonColor = NonNullable<VariantProps<typeof gradientButton>["color"]>;
export type HTMLButtonOrAnchorAttributes = Omit<HTMLButtonAttributes & HTMLAnchorAttributes, "color">;
export type ButtonProps = ButtonVariants & AnchorButtonAttributes & {
    tag?: string;
    disabled?: boolean;
    outline?: boolean;
    shadow?: boolean;
};
export interface GradientButtonProps extends GradientButtonVariantes, HTMLButtonOrAnchorAttributes {
    tag?: string;
    disabled?: boolean;
    href?: string;
    btnClass?: ClassValue;
}
export type ButtonToggleGroupProps = HTMLAttributes<HTMLDivElement> & {
    multiSelect?: boolean;
    name?: string;
    value?: string | null | string[];
    color?: ButtonToggleVariants["color"];
    size?: ButtonToggleVariants["size"];
    roundedSize?: ButtonToggleVariants["roundedSize"];
    onSelect?: (val: any) => void;
    children: Snippet;
    ctxIconClass?: ClassValue;
    ctxBtnClass?: ClassValue;
};
export type ButtonToggleProps = HTMLButtonAttributes & {
    value: string;
    selected?: boolean;
    children: Snippet;
    iconSlot?: Snippet;
    color?: ButtonToggleVariants["color"];
    iconClass?: ClassValue;
    contentClass?: ClassValue;
    txtClass?: ClassValue;
};
export interface ButtonToggleContext {
    toggleSelected: (toggleValue: string) => void;
    isSelected: (toggleValue: string) => boolean;
}
export interface CheckIconProps extends SVGAttributes<SVGSVGElement> {
}
export type CardProps = Omit<CardVariants, "href"> & AnchorDivAttributes & {
    children: Snippet;
    img?: string;
    imgClass?: ClassValue;
    contentClass?: string;
};
export type State = {
    images: HTMLImgAttributes[];
    index: number;
    lastSlideChange: Date;
    slideDuration: number;
    forward: boolean;
};
export interface CarouselProps extends CarouselVariants, Omit<HTMLAttributes<HTMLDivElement>, "children" | "onchange"> {
    children?: Snippet<[number]>;
    slide?: Snippet<[{
        index: number;
        Slide: typeof Slide;
    }]>;
    images: HTMLImgAttributes[];
    index?: number;
    slideDuration?: number;
    transition?: TransitionFunc;
    duration?: number;
    disableSwipe?: boolean;
    imgClass?: ClassValue;
    onchange?: (x: HTMLImgAttributes) => {};
    divClass?: ClassValue;
}
export interface IndicatorsProps extends Omit<HTMLAttributes<HTMLDivElement>, "children"> {
    children?: Snippet<[{
        selected: boolean;
        index: number;
    }]>;
    activeClass?: ClassValue;
    inactiveClass?: ClassValue;
    position?: "top" | "bottom" | "withThumbnails";
}
export interface ControlButtonProps extends HTMLButtonAttributes {
    forward: boolean;
    name?: string | null;
    spanClass?: ClassValue;
}
export interface ControlsProps extends Omit<HTMLButtonAttributes, "children"> {
    children?: Snippet<[(forward: boolean) => void]>;
}
export interface ThumbnailProps extends HTMLImgAttributes {
    selected?: boolean;
}
export interface ThumbnailsProps extends Omit<HTMLAttributes<HTMLDivElement>, "children"> {
    children?: Snippet<[{
        image: HTMLImgAttributes;
        selected: boolean;
        imgClass: string;
        Thumbnail: Component;
    }]>;
    images: HTMLImgAttributes[];
    index: number;
    ariaLabel?: string;
    imgClass?: ClassValue;
    throttleDelay?: number;
}
export interface SlideProps extends HTMLImgAttributes {
    image: HTMLImgAttributes;
    transition?: TransitionFunc;
}
export interface ChartProps {
    options: ApexOptions;
    class?: ClassValue;
}
export interface ClipboardProps extends ClipboardVariants, ButtonVariants, Omit<HTMLButtonAttributes, "children" | "color" | "disabled"> {
    children: Snippet<[boolean]>;
    value?: string;
    success?: boolean;
    showLabel?: boolean;
    embedded?: boolean;
}
export interface DarkmodeProps extends HTMLButtonAttributes {
    lightIcon?: Snippet;
    darkIcon?: Snippet;
    size?: "sm" | "md" | "lg";
    ariaLabel?: string;
}
export type DateOrRange = Date | {
    from?: Date;
    to?: Date;
};
export interface DatepickerProps extends Omit<HTMLAttributes<HTMLDivElement>, "onselect"> {
    value?: Date;
    defaultDate?: Date | null;
    range?: boolean;
    rangeFrom?: Date;
    rangeTo?: Date;
    locale?: string;
    firstDayOfWeek?: number;
    dateFormat?: Intl.DateTimeFormatOptions;
    placeholder?: string;
    disabled?: boolean;
    required?: boolean;
    inputClass?: ClassValue;
    color?: ButtonProps["color"];
    inline?: boolean;
    autohide?: boolean;
    showActionButtons?: boolean;
    title?: string;
    onselect?: (x: DateOrRange) => void;
    onclear?: () => void;
    onapply?: (x: DateOrRange) => void;
    btnClass?: ClassValue;
}
export interface DeviceMockupProps {
    children: Snippet;
    device?: DeviceVariantType;
}
export interface MockupBaseProps extends HTMLAttributes<HTMLElement> {
    children?: Snippet;
    divClass?: ClassValue;
    div2Class?: ClassValue;
    div3Class?: ClassValue;
    div4Class?: ClassValue;
}
export interface AndroidProps extends HTMLAttributes<HTMLDivElement> {
    children?: Snippet;
    divClass?: ClassValue;
    div2Class?: ClassValue;
    div3Class?: ClassValue;
    div4Class?: ClassValue;
    div5Class?: ClassValue;
    div6Class?: ClassValue;
    div7Class?: ClassValue;
}
export interface DefaultMockupProps {
    children?: Snippet;
    divClass?: ClassValue;
    div2Class?: ClassValue;
    div3Class?: ClassValue;
    div4Class?: ClassValue;
    div5Class?: ClassValue;
    div6Class?: ClassValue;
}
export interface IosProps {
    children?: Snippet;
    divClass?: ClassValue;
    div2Class?: ClassValue;
    div3Class?: ClassValue;
    div4Class?: ClassValue;
    div5Class?: ClassValue;
    div6Class?: ClassValue;
}
export interface SmartwatchProps {
    children?: Snippet;
    divClass?: ClassValue;
    div2Class?: ClassValue;
    div3Class?: ClassValue;
    div4Class?: ClassValue;
    div5Class?: ClassValue;
    div6Class?: ClassValue;
}
export interface TabletProps {
    children?: Snippet;
    divClass?: ClassValue;
    div2Class?: ClassValue;
    div3Class?: ClassValue;
    div4Class?: ClassValue;
    div5Class?: ClassValue;
    div6Class?: ClassValue;
}
export interface DrawerProps extends DrawerVariants, HTMLAttributes<HTMLDivElement> {
    hidden: boolean;
    closeDrawer?: () => void;
    activateClickOutside?: boolean;
    backdrop?: boolean;
    backdropClass?: ClassValue;
    transitionParams?: ParamsType;
    transitionType?: TransitionFunc;
}
export interface DrawerheadProps extends HTMLButtonAttributes {
    closeIcon?: Snippet;
    buttonClass?: ClassValue;
    svgClass?: ClassValue;
}
export interface DropdownProps extends PopperProps {
    simple?: boolean;
    activeUrl?: string;
    isOpen?: boolean;
}
export interface DropdownDividerProps extends HTMLAttributes<HTMLDivElement> {
}
export interface DropdownHeaderProps extends HTMLAttributes<HTMLDivElement> {
    children: Snippet;
}
export type DropdownItemAnchorButtonAttributes = HTMLAnchorAttributes & Omit<HTMLButtonAttributes, keyof HTMLAnchorAttributes | "type">;
export type DropdownItemProps = AnchorButtonDivAttributes & {
    children: Snippet;
    aClass?: ClassValue;
    activeClass?: ClassValue;
    liClass?: ClassValue;
};
export interface DropdownGroupProps extends HTMLAttributes<HTMLUListElement> {
    children: Snippet;
}
export type FooterType = "default" | "sticky" | "sitemap" | "socialmedia" | "logo" | undefined;
export interface FooterProps extends HTMLAttributes<HTMLElement> {
    children: Snippet;
    footerType?: FooterType;
}
export interface FooterBrandProps extends HTMLAnchorAttributes {
    children?: Snippet;
    aClass?: ClassValue;
    spanClass?: ClassValue;
    imgClass?: ClassValue;
    href?: string;
    src?: string;
    alt?: string;
    name?: string;
}
export interface FooterCopyrightProps extends HTMLAnchorAttributes {
    spanClass?: ClassValue;
    aClass?: ClassValue;
    href?: string;
    by?: string;
    copyrightMessage?: string;
    year?: number;
    bySpanClass?: ClassValue;
}
export interface FooterIconProps extends HTMLAnchorAttributes {
    children: Snippet;
    href?: string;
    ariaLabel?: string;
}
export interface FooterLinkGroupProps extends HTMLAttributes<HTMLUListElement> {
    children: Snippet;
}
export interface FooterLinkProps extends HTMLAnchorAttributes {
    children: Snippet;
    liClass?: ClassValue;
    aClass?: ClassValue;
    href?: string;
}
export interface CheckboxItem {
    value: string | number;
    label?: string;
    checked?: boolean | null;
    [key: string]: any;
}
export interface CheckboxProps extends CheckboxVariants, Omit<HTMLInputAttributes, "children" | "color" | "disabled"> {
    children?: Snippet<[
        {
            value?: string | number;
            checked: boolean;
        } | CheckboxItem
    ]>;
    custom?: boolean;
    inline?: boolean;
    tinted?: boolean;
    rounded?: boolean;
    group?: (string | number)[];
    choices?: CheckboxItem[];
    indeterminate?: boolean;
    divClass?: ClassValue;
    labelProps?: Record<string, any>;
}
export interface CheckboxButtonProps extends Omit<HTMLInputAttributes, "size"> {
    group?: (string | number)[];
    value?: string | number;
    checked?: boolean;
    inline?: boolean;
    pill?: boolean;
    outline?: boolean;
    size?: ButtonProps["size"];
    color?: ButtonProps["color"];
    shadow?: boolean;
}
export interface DropzoneProps extends HTMLInputAttributes {
    children: Snippet;
    files?: FileList | null;
}
export interface FileuploadProps extends Omit<HTMLInputAttributes, "size"> {
    files?: FileList | null;
    size?: FileuploadViariants["size"];
    color?: InputProps<never>["color"];
    elementRef?: HTMLInputElement;
    clearable?: boolean;
    clearableSvgClass?: ClassValue;
    clearableColor?: CloseButtonVariants["color"];
    clearableOnClick?: () => void;
    clearableClass?: ClassValue;
    wrapperClass?: ClassValue;
}
export interface FloatingLabelInputProps extends Omit<HTMLInputAttributes, "size"> {
    children: Snippet;
    id?: string;
    value?: string | number | readonly string[];
    elementRef?: HTMLInputElement;
    "aria-describedby"?: string;
    variant?: FloatingLabelInputVaratiants["variant"];
    size?: FloatingLabelInputVaratiants["size"];
    color?: FloatingLabelInputVaratiants["color"];
    inputClass?: ClassValue;
    labelClass?: ClassValue;
    clearable?: boolean;
    clearableSvgClass?: ClassValue;
    clearableColor?: CloseButtonVariants["color"];
    clearableClass?: ClassValue;
    clearableOnClick?: () => void;
    data?: string[];
    maxSuggestions?: number;
    onSelect?: (item: string) => void;
    comboClass?: ClassValue;
}
export interface HelperProps extends HelperVariants, Omit<HTMLAttributes<HTMLParagraphElement>, "color"> {
}
export type InputValue = string | number | string[] | undefined;
export interface InputProps<T extends InputValue = string> extends Omit<HTMLInputAttributes, "size" | "children" | "value"> {
    children?: Snippet<[{
        class: string;
    } & Omit<InputProps<T>, "children" | "left" | "right" | "size">]>;
    left?: Snippet;
    right?: Snippet;
    size?: InputVariants["size"];
    value?: T;
    elementRef?: HTMLInputElement;
    color?: InputVariants["color"];
    leftClass?: ClassValue;
    rightClass?: ClassValue;
    divClass?: ClassValue;
    wrapperClass?: ClassValue;
    clearable?: boolean;
    clearableSvgClass?: ClassValue;
    clearableColor?: CloseButtonVariants["color"];
    clearableClass?: ClassValue;
    clearableOnClick?: () => void;
    data?: string[];
    maxSuggestions?: number;
    onSelect?: (item: string) => void;
    comboClass?: ClassValue;
    comboItemClass?: ClassValue;
    onInput?: (event: Event) => void;
    onFocus?: (event: FocusEvent) => void;
    onBlur?: (event: FocusEvent) => void;
    onKeydown?: (event: KeyboardEvent) => void;
}
export interface InputAddonProps extends HTMLAttributes<HTMLDivElement> {
    children: Snippet;
    size?: "sm" | "md" | "lg";
}
export interface LabelProps extends HTMLLabelAttributes {
    children: Snippet;
    color?: LabelVariants["color"];
    show?: boolean;
}
export interface RadioProps<T> extends RadioVariants, Omit<HTMLInputAttributes, "color"> {
    group?: T;
    value?: T;
    inputClass?: ClassValue;
    labelClass?: ClassValue;
}
export interface RadioButtonProps<T> extends Omit<HTMLInputAttributes, "size"> {
    group?: T;
    value?: T;
    inline?: boolean;
    pill?: boolean;
    outline?: boolean;
    size?: ButtonProps["size"];
    color?: ButtonProps["color"];
    shadow?: boolean;
    checkedClass?: ClassValue;
}
export interface RangeProps extends RangeVariants, Omit<HTMLInputAttributes, "size" | "color"> {
    value?: number | string;
    inputClass?: ClassValue;
}
export interface SearchProps extends SearchVariants, Omit<HTMLInputAttributes, "size"> {
    children?: Snippet;
    value?: string;
    elementRef?: HTMLInputElement;
    clearable?: boolean;
    clearableSvgClass?: ClassValue;
    clearableColor?: CloseButtonVariants["color"];
    clearableClass?: ClassValue;
    clearableOnClick?: () => void;
    inputClass?: ClassValue;
}
export type SelectOptionType<T> = {
    name: string | number;
    value: T;
    disabled?: boolean;
    [key: string]: any;
};
export interface SelectProps<T> extends SelectVariants, Omit<HTMLSelectAttributes, "size" | "disabled"> {
    children?: Snippet;
    items?: SelectOptionType<T>[];
    elementRef?: HTMLSelectElement;
    placeholder?: string;
    selectClass?: ClassValue;
    clearable?: boolean;
    clearableSvgClass?: ClassValue;
    clearableColor?: CloseButtonVariants["color"];
    clearableClass?: ClassValue;
    clearableOnClick?: () => void;
    disabled?: boolean;
}
export interface MultiSelectProps<T> extends MultiSelectVariants, Omit<HTMLAttributes<HTMLDivElement>, "size" | "children" | "onchange" | "onblur"> {
    children?: Snippet<[{
        item: SelectOptionType<T>;
        clear: () => void;
    }]>;
    items: SelectOptionType<T>[];
    value: T[];
    dropdownClass?: ClassValue;
    placeholder?: string;
    disabled?: boolean | undefined;
    size?: "sm" | "md" | "lg";
    name?: string | undefined | null;
    form?: string | undefined | null;
    required?: boolean | undefined | null;
    autocomplete?: FullAutoFill | undefined | null;
    onchange?: (event: Event) => void;
    onblur?: (event: FocusEvent) => void;
}
export interface TagsProps extends HTMLAttributes<HTMLDivElement> {
    value: string[];
    itemClass?: ClassValue;
    placeholder?: string;
    spanClass?: ClassValue;
    closeClass?: ClassValue;
    inputClass?: ClassValue;
    closeBtnSize?: CloseButtonVariants["size"];
}
export type TimePickerType = "default" | "dropdown" | "select" | "range" | "timerange-dropdown" | "timerange-toggle" | "inline-buttons";
export type ColumnCount = 1 | 2 | 3 | 4;
export type TimePickerOption = {
    name: string;
    value: string;
};
export interface TimepickerProps {
    id?: string;
    endId?: string;
    value?: string;
    endValue?: string;
    min?: string;
    max?: string;
    required?: boolean;
    disabled?: boolean;
    inputColor?: InputProps["color"];
    buttonColor?: ButtonProps["color"];
    Icon?: Component;
    type?: TimePickerType;
    optionLabel?: string;
    options?: TimePickerOption[];
    size?: ButtonGroupSizeType;
    divClass?: ClassValue;
    inputClass?: ClassValue;
    selectClass?: ClassValue;
    timerangeLabel?: string;
    timerangeButtonLabel?: string;
    timeIntervals?: string[];
    columns?: ColumnCount;
    onselect?: (data: {
        time: string;
        endTime: string;
        [key: string]: string;
    }) => void;
}
export interface TextareaProps extends HTMLTextareaAttributes {
    header?: Snippet;
    footer?: Snippet;
    addon?: Snippet;
    value?: string;
    elementRef?: HTMLTextAreaElement;
    wrapped?: boolean;
    divClass?: ClassValue;
    innerClass?: ClassValue;
    headerClass?: ClassValue;
    footerClass?: ClassValue;
    addonClass?: ClassValue;
    cols?: number;
    clearable?: boolean;
    clearableSvgClass?: ClassValue;
    clearableColor?: CloseButtonVariants["color"];
    clearableClass?: ClassValue;
    clearableOnClick?: () => void;
    textareaClass?: ClassValue;
}
export interface ToggleProps extends Omit<ToggleVariants, "off_state_label">, Omit<HTMLInputAttributes, "size" | "color"> {
    offLabel?: Snippet;
    value?: string | number;
    checked?: boolean;
    disabled?: boolean;
    spanClass?: ClassValue;
    inputClass?: ClassValue;
}
export type ImgType = {
    src?: string;
    alt?: string;
};
export interface GalleryProps extends HTMLAttributes<HTMLDivElement> {
    children?: Snippet;
    figure?: Snippet<[item: ImgType]>;
    items?: HTMLImgAttributes[];
    imgClass?: ClassValue;
    height?: string;
    rowHeight?: number;
    columns?: number;
}
export interface IndicatorProps extends HTMLAttributes<HTMLDivElement> {
    children?: Snippet;
    color?: IndicatorVariants["color"];
    cornerStyle?: IndicatorVariants["cornerStyle"];
    size?: IndicatorVariants["size"];
    border?: boolean;
    placement?: IndicatorVariants["placement"];
    offset?: boolean;
}
export interface KbdProps extends HTMLAttributes<HTMLElement> {
    children: Snippet;
}
export interface ListGroupItemType {
    name?: string;
    Icon?: Component;
    onclick?: () => void;
    href?: string;
    active?: boolean;
    current?: boolean;
    disabled?: boolean;
    img?: {
        src: string;
        alt: string;
    };
    comment?: string;
    message?: string;
    [key: string]: any;
}
export interface ListgroupProps extends ListgroupVariants, Omit<HTMLAttributes<HTMLUListElement>, "children"> {
    children?: Snippet<[item?: ListGroupItemType | string]>;
    items?: (ListGroupItemType | string)[];
    active?: boolean;
    onclick?: (event?: MouseEvent) => void;
    itemClass?: ClassValue;
    aClasss?: ClassValue;
    btnClass?: ClassValue;
    iconClass?: ClassValue;
}
export type ListgroupItemProps = Omit<ListgroupItemVariants, "state"> & AnchorButtonAttributes & {
    current?: boolean;
    disabled?: boolean;
    Icon?: Component;
    iconClass?: ClassValue;
    name?: string;
    children?: Snippet;
};
export interface MegaMenuProps extends Omit<PopperProps, "children"> {
    children: Snippet<[{
        item: LinkType;
        index: number;
    }]>;
    extra?: Snippet;
    items?: LinkType[];
    full?: boolean;
    ulClass?: ClassValue;
    extraClass?: ClassValue;
    isOpen?: boolean;
}
export interface ModalProps extends ModalVariants, HTMLDialogAttributes {
    header?: Snippet;
    footer?: Snippet;
    modal?: boolean;
    autoclose?: boolean;
    outsideclose?: boolean;
    dismissable?: boolean;
    permanent?: boolean;
    transition?: TransitionFunc;
    params?: ParamsType;
    headerClass?: ClassValue;
    bodyClass?: ClassValue;
    footerClass?: ClassValue;
    closeBtnClass?: ClassValue;
    onclose?: () => void;
}
export interface MenuProps extends SVGAttributes<SVGSVGElement> {
    size?: string;
    color?: string;
    variation?: "solid" | "outline";
    ariaLabel?: string;
}
export type NavbarState = {
    hidden: boolean;
    activeClass?: string;
    nonActiveClass?: string;
};
export interface NavbarProps extends Omit<HTMLAttributes<HTMLDivElement>, "children"> {
    children: Snippet<[{
        hidden: boolean;
        toggle: () => void;
        NavContainer: Component;
    }]>;
    fluid?: boolean;
    navContainerClass?: ClassValue;
    closeOnClickOutside?: boolean;
}
export interface NavBrandProps extends HTMLAnchorAttributes {
}
export interface NavContainerProps extends HTMLAttributes<HTMLDivElement> {
    fluid?: boolean;
}
export type NavHamburgerProps = ToolbarButtonProps & {
    href?: undefined;
    menuClass?: ClassValue;
};
export interface NavUlProps extends Omit<HTMLAttributes<HTMLDivElement>, "class"> {
    activeUrl?: string;
    ulClass?: ClassValue;
    hidden?: boolean;
    slideParams?: SlideParams;
    transition?: typeof slide | typeof fly | typeof fade | typeof scale;
    transitionParams?: SlideParams | FlyParams | FadeParams | ScaleParams;
    activeClass?: ClassValue;
    nonActiveClass?: ClassValue;
    respectMotionPreference?: boolean;
    class?: ClassValue;
}
export type NavLiProps = AnchorButtonAttributes & {
    activeClass?: ClassValue;
    nonActiveClass?: ClassValue;
};
export interface ToolbarProps extends ToolbarVariants, Omit<HTMLAttributes<HTMLDivElement>, "color"> {
    end?: Snippet;
}
export interface ToolbarGroupProps extends ToolbarGroupVariants, HTMLAttributes<HTMLDivElement> {
}
export type ToolbarButtonProps = ToolbarButtonVariants & AnchorButtonAttributes & {
    name?: string;
};
export type PaginationItemType = {
    size?: "default" | "large";
    active?: boolean | null;
    group?: boolean | null;
    table?: boolean | null;
};
export interface PaginationItemSpecificProps {
    children?: Snippet;
    name?: string;
    href?: string;
    active?: boolean;
    rel?: string;
    size?: "default" | "large";
}
export type PaginationHTMLButtonOrAnchorAttributes = HTMLButtonAttributes & HTMLAnchorAttributes;
export interface PaginationButtonProps extends PaginationItemVariants, PaginationHTMLButtonOrAnchorAttributes {
    children?: Snippet;
    onclick?: () => void;
    disabled?: boolean;
}
export interface PaginationNavProps extends HTMLAttributes<HTMLElement>, PaginationVariants {
    prevContent?: Snippet;
    nextContent?: Snippet;
    prevClass?: ClassValue;
    nextClass?: ClassValue;
    currentPage: number;
    totalPages: number;
    visiblePages?: number;
    onPageChange: (page: number) => void;
    layout?: "navigation" | "pagination" | "table";
    previousLabel?: string;
    nextLabel?: string;
    showIcons?: boolean;
    ariaLabel?: string;
    size?: "default" | "large";
    spanClass?: ClassValue;
    tableDivClass?: ClassValue;
}
export interface PaginationItemProps extends PaginationItemVariants, PaginationHTMLButtonOrAnchorAttributes {
    children?: Snippet;
}
export interface PaginationProps extends PaginationVariants, HTMLLiAttributes {
    prevContent?: Snippet;
    nextContent?: Snippet;
    pages?: PaginationItemProps[];
    previous?: () => void;
    next?: () => void;
    ariaLabel?: string;
}
export interface PopoverProps extends Omit<PopperProps, "title"> {
    title?: Snippet | string;
    color?: PopoverVariants["color"];
    params?: ParamsType;
    defaultClass?: ClassValue;
    transition?: TransitionFunc;
    isOpen?: boolean;
}
export interface ProgressbarProps extends ProgressbarVariants, Omit<HTMLAttributes<HTMLDivElement>, "color"> {
    progress?: string | number;
    precision?: number;
    tweenDuration?: number;
    animate?: boolean;
    size?: string;
    labelInside?: boolean;
    labelOutside?: string;
    easing?: EasingFunction;
}
export interface ProgressradialProps extends ProgressradialVariants, Omit<HTMLAttributes<HTMLDivElement>, "color"> {
    progress?: number | string;
    radius?: number;
    startingPosition?: "top" | "right" | "bottom" | "left";
    precision?: number;
    tweenDuration?: number;
    animate?: boolean;
    size?: string;
    thickness?: number | string;
    labelInside?: boolean;
    labelOutside?: string;
    easing?: (t: number) => number;
}
export type RatingItem = {
    label: string | null | undefined;
    rating: number;
};
export interface AdvancedRatingProps {
    rating?: Snippet;
    globalText?: Snippet;
    ratings: RatingItem[];
    divClass?: ClassValue;
    spanClass?: ClassValue;
    div2Class?: ClassValue;
    div3Class?: ClassValue;
    span2Class?: ClassValue;
    unit?: string;
}
export interface RatingProps extends HTMLAttributes<HTMLDivElement> {
    children?: Snippet;
    text?: Snippet;
    size?: number;
    total?: number;
    rating?: number;
    icon?: Component;
    count?: boolean;
    pClass?: ClassValue;
}
export interface RatingCommentProps {
    children: Snippet;
    evaluation?: Snippet;
    helpfullink?: string;
    abuselink?: string;
    comment: {
        id?: string;
        user: {
            name?: string;
            img: {
                src: string | undefined | null;
                alt?: string;
            };
            joined?: string;
        };
        total?: number;
        rating: number;
        heading?: string;
        address?: string;
        datetime?: string;
    };
}
export type ReviewType = {
    name?: string;
    imgSrc?: string;
    imgAlt?: string;
    address?: string;
    reviewDate?: string;
    title?: string;
    rating?: number;
    item1?: string;
    item2?: string;
    item3?: string;
};
export interface ReviewProps extends HTMLAttributes<HTMLElement> {
    children: Snippet;
    address?: Snippet;
    item1?: Snippet;
    item2?: Snippet;
    item3?: Snippet;
    review?: ReviewType;
    articleClass?: ClassValue;
    divClass?: ClassValue;
    div2Class?: ClassValue;
    div3Class?: ClassValue;
    imgClass?: ClassValue;
    ulClass?: ClassValue;
    liClass?: ClassValue;
}
export interface ScoreRatingProps {
    ratings?: {
        label: string | undefined | null;
        rating: number;
    }[];
    ratings2?: {
        label: string | undefined | null;
        rating: number;
    }[];
    headerLabel?: {
        desc1?: string;
        desc2?: string;
        desc3?: string;
        link?: {
            label: string | undefined | null;
            url: string;
        };
    };
}
export interface RatingIconProps extends SVGAttributes<SVGSVGElement> {
    fillPercent?: number;
    fillColor?: string;
    strokeColor?: string;
    size?: number;
    ariaLabel?: string;
    role?: string;
    svgClass?: ClassValue;
    iconIndex?: number;
    groupId?: string;
    pathd?: string;
}
export type SidebarCtxType = {
    closeSidebar?: () => void;
    activeClass?: string;
    nonActiveClass?: string;
    isSingle?: boolean;
    selected?: Writable<object>;
    activeUrl?: string;
};
export interface SidebarProps extends SidebarVariants, HTMLAttributes<HTMLElement> {
    children: Snippet;
    isOpen?: boolean;
    closeSidebar?: () => void;
    activateClickOutside?: boolean;
    isSingle?: boolean;
    ariaLabel?: string;
    divClass?: ClassValue;
    nonActiveClass?: ClassValue;
    activeClass?: ClassValue;
    params?: ParamsType;
    transition?: TransitionFunc;
    backdrop?: boolean;
    backdropClass?: ClassValue;
    activeUrl?: string;
    alwaysOpen?: boolean;
}
export interface SidebarButtonProps extends HTMLButtonAttributes {
    breakpoint?: SidebarVariants["breakpoint"];
}
export interface SidebarCtaProps extends HTMLAttributes<HTMLDivElement> {
    icon?: Snippet;
    divClass?: ClassValue;
    spanClass?: ClassValue;
    label: string;
}
export interface SiteType {
    name?: string;
    href?: string;
    img?: string;
}
export interface SidebarBrandProps extends HTMLAnchorAttributes {
    site?: SiteType;
    imgClass?: ClassValue;
    spanClass?: ClassValue;
}
export interface SidebarDropdownWrapperProps extends HTMLButtonAttributes {
    children: Snippet;
    arrowup?: Snippet;
    arrowdown?: Snippet;
    icon?: Snippet;
    isOpen?: boolean;
    btnClass?: ClassValue;
    label?: string;
    spanClass?: ClassValue;
    ulClass?: ClassValue;
    params?: ParamsType;
    transition?: TransitionFunc;
    svgClass?: ClassValue;
    onclick?: () => void;
    isSingle?: boolean;
}
export interface SidebarGroupProps extends HTMLAttributes<HTMLUListElement> {
    children: Snippet;
    borderClass?: ClassValue;
    border?: boolean;
}
export interface SidebarItemProps extends HTMLAnchorAttributes {
    icon?: Snippet;
    subtext?: Snippet;
    label?: string;
    spanClass?: ClassValue;
    activeClass?: ClassValue;
    nonActiveClass?: ClassValue;
    aClass?: ClassValue;
    active?: boolean;
}
export interface CardPlaceholderProps extends HTMLAttributes<HTMLDivElement> {
    size?: CardPlaceholderVariants["size"];
}
export interface ImagePlaceholderProps extends HTMLAttributes<HTMLDivElement> {
    size?: ImagePlaceholderVariants["size"];
    rounded?: ImagePlaceholderVariants["rounded"];
    imgOnly?: boolean;
}
export interface ListPlaceholderProps extends HTMLAttributes<HTMLDivElement> {
    itemNumber?: number;
    size?: ListPlaceholderVariants["size"];
    rounded?: ListPlaceholderVariants["rounded"];
}
export interface SkeletonProps extends HTMLAttributes<HTMLDivElement> {
    size?: SkeletonVariants["size"];
}
export interface TestimonialPlaceholderProps extends HTMLAttributes<HTMLDivElement> {
}
export interface TextPlaceholderProps extends HTMLAttributes<HTMLDivElement> {
    size?: TextPlaceholderVariants["size"];
}
export interface VideoPlaceholderProps extends HTMLAttributes<HTMLDivElement> {
    size?: VideoPlaceholderVariants["size"];
}
export interface WidgetPlaceholderProps extends HTMLAttributes<HTMLDivElement> {
}
export interface SpeedCtxType {
    pill: boolean;
    tooltip: Placement | "none";
    textOutside: boolean;
}
type BaseSpeedDialTriggerProps = {
    children?: any;
    name?: string;
    pill?: boolean;
    icon?: Snippet;
    class?: string;
    [key: string]: any;
};
export type RegularSpeedDialTriggerProps = BaseSpeedDialTriggerProps & {
    gradient?: false;
    color?: ButtonVariants["color"];
};
export type GradientSpeedDialTriggerProps = BaseSpeedDialTriggerProps & {
    gradient: true;
    color?: GradientButtonColor;
};
export type SpeedDialTriggerProps = RegularSpeedDialTriggerProps | GradientSpeedDialTriggerProps;
export type SpeedDialProps = PopperProps & {
    children: Snippet;
    button?: Snippet;
    popperClass?: ClassValue;
    placement?: Placement;
    tooltip?: Placement | "none";
    trigger?: PopperProps["trigger"];
    textOutside?: boolean;
    pill?: boolean;
    ontoggle?: PopperProps["ontoggle"];
    onbeforetoggle?: PopperProps["onbeforetoggle"];
    isOpen?: boolean;
};
export type SpeedDialButtonProps = ButtonProps & {
    name?: string;
    tooltip?: Placement | "none";
    pill?: boolean;
    textOutside?: boolean;
    textClass?: ClassValue;
};
export interface SpinnerProps extends SVGAttributes<SVGSVGElement> {
    color?: SpinnerVaraiants["color"];
    size?: SpinnerVaraiants["size"];
    currentFill?: string;
    currentColor?: string;
}
export interface StepIndicatorProps extends HTMLAttributes<HTMLElement> {
    steps: string[];
    currentStep: number;
    size?: string;
    glow?: boolean;
    hideLabel?: boolean;
    completedCustom?: string;
    currentCustom?: string;
}
export interface Step {
    id?: number;
    label: string;
    description?: string;
    status?: "completed" | "current" | "pending";
    icon?: Component;
    iconClass?: ClassValue;
    descriptionClass?: ClassValue;
}
export interface StepperProps extends StepperVariants {
    children?: Snippet;
    steps?: Step[];
}
export interface ProgressStep {
    status?: "completed" | "current" | "pending";
    icon?: Component;
    iconClass?: ClassValue;
}
export interface ProgressStepperProps extends ProgressStepperVariants {
    children?: Snippet;
    steps?: ProgressStep[];
}
export interface DetailedStep {
    id: number;
    label: string;
    description?: string;
    status?: "completed" | "current" | "pending";
    icon?: Component;
    iconClass?: ClassValue;
}
export interface DetailedStepperProps extends DetailedStepperVariants {
    children?: Snippet;
    steps?: DetailedStep[];
    contentClass?: ClassValue;
}
export interface VerticalStep {
    id: number;
    label: string;
    status?: "completed" | "current" | "pending";
    icon?: Component;
    iconClass?: ClassValue;
}
export interface VerticalStepperProps extends VerticalStepperVariants {
    children?: Snippet;
    steps?: VerticalStep[];
    liClass?: ClassValue;
}
export interface BreadcrumbStep {
    id: number;
    label: string;
    shortLabel?: string;
    status?: "completed" | "current" | "pending";
    icon?: Component;
    iconClass?: ClassValue;
}
export interface BreadcrumbStepperProps extends BreadcrumbStepperVariants {
    children?: Snippet;
    steps?: BreadcrumbStep[];
}
export interface TimelineStep {
    label: string;
    description?: string;
    status?: "completed" | "current" | "pending";
    icon?: Component;
    iconClass?: ClassValue;
}
export interface TimelineStepperProps extends TimelineStepperVariants {
    children?: Snippet;
    steps?: TimelineStep[];
    contentClass?: ClassValue;
}
export type TableCtxType = {
    striped?: boolean;
    hoverable?: boolean;
    border?: boolean;
    color?: TableVariants["color"];
};
export type HeadItemType = string | number | {
    text: string;
    [key: string]: string | number | boolean;
};
export interface TableHeadProps extends HTMLAttributes<HTMLTableSectionElement> {
    children?: Snippet;
    headerSlot?: Snippet;
    defaultRow?: boolean;
    headItems?: HeadItemType[];
    striped?: boolean;
    border?: boolean;
    color?: TableVariants["color"];
}
export type TableItemType = Record<string, string | number | boolean>;
export interface TableProps extends Omit<HTMLTableAttributes, "border"> {
    children?: Snippet;
    footerSlot?: Snippet;
    captionSlot?: Snippet;
    divClass?: ClassValue;
    striped?: boolean;
    hoverable?: boolean;
    border?: boolean;
    shadow?: boolean;
    color?: TableVariants["color"];
    items?: TableItemType[];
}
export interface TableBodyRowProps extends HTMLAttributes<HTMLTableRowElement> {
    children?: Snippet;
    striped?: boolean;
    hoverable?: boolean;
    border?: boolean;
    color?: TableVariants["color"];
}
export interface TableBodyCellProps extends HTMLTdAttributes {
    children?: Snippet;
    colspan?: number;
    color?: TableVariants["color"];
    onclick?: () => void;
}
export type CellValue = string | number | boolean | null | undefined;
export type BodyRow = CellValue[] | Record<string, CellValue>;
export interface TableBodyProps extends HTMLAttributes<HTMLTableSectionElement> {
    children?: Snippet;
    bodyItems?: BodyRow[];
}
export interface TableHeadCellProps<T = any> extends HTMLThAttributes {
    children?: Snippet;
    padding?: string;
    sort?: ((a: T, b: T) => number) | null;
    defaultDirection?: "asc" | "desc";
    defaultSort?: boolean;
    direction?: "asc" | "desc" | null;
}
export type TableSearchType = {
    striped?: boolean;
    hoverable?: boolean;
    color?: string;
};
export interface TableSearchProps extends HTMLTableAttributes {
    children?: Snippet;
    header?: Snippet;
    footer?: Snippet;
    divClass?: ClassValue;
    inputValue?: string;
    striped?: boolean;
    hoverable?: boolean;
    customColor?: string;
    color?: string;
    innerDivClass?: ClassValue;
    inputClass?: ClassValue;
    searchClass?: ClassValue;
    svgDivClass?: ClassValue;
    svgClass?: ClassValue;
    tableClass?: ClassValue;
    placeholder?: string;
}
export interface TabsProps extends HTMLAttributes<HTMLUListElement> {
    children: Snippet;
    tabStyle?: TabsVaraints["tabStyle"];
    ulClass?: ClassValue;
    contentClass?: ClassValue;
    divider?: boolean;
}
export interface TabitemProps extends HTMLLiAttributes {
    children?: Snippet;
    titleSlot?: Snippet;
    open?: boolean;
    title?: string;
    activeClass?: ClassValue;
    inactiveClass?: ClassValue;
    disabled?: boolean;
    tabStyle?: TabsVaraints["tabStyle"];
}
export interface TabCtxType {
    activeClass?: string;
    inactiveClass?: string;
    tabStyle?: TabsVaraints["tabStyle"];
    selected: Writable<HTMLElement>;
    panelId: string;
}
export type BaseThemes = typeof baseThemes;
export interface ThemeProps {
    children: Snippet;
    theme?: BaseThemes;
}
export type TimelineVariants = VariantProps<typeof timeline>;
export interface ActivityType {
    title: HTMLElement | string;
    date: Date | string;
    src: string;
    alt: string;
    text?: HTMLElement | string;
}
export interface GroupTimelineType {
    name?: string | HTMLElement;
    src?: string;
    alt?: string;
    href?: string;
    isPrivate?: boolean;
    comment?: string | HTMLElement;
}
export interface ActivityProps extends HTMLOlAttributes {
    children: Snippet;
}
export interface ActivityItemProps extends HTMLLiAttributes {
    activities: ActivityType[];
    liClass?: string;
    spanClass?: string;
    imgClass?: string;
    outerDivClass?: string;
    innerDivClass?: string;
    timeClass?: string;
    titleClass?: string;
    textClass?: string;
}
export interface GroupProps extends HTMLOlAttributes {
    children: Snippet;
    divClass?: string;
    timeClass?: string;
    date?: Date | string;
    olClass?: string;
}
export interface GroupItemProps extends HTMLLiAttributes {
    timelines: GroupTimelineType[];
    aClass?: string;
    imgClass?: string;
    divClass?: string;
    titleClass?: string;
    spanClass?: string;
}
export type DateFormat = "year" | "month-year" | "full-date";
export interface TimelineProps extends HTMLOlAttributes {
    children: Snippet;
    order?: TimelineVariants["order"];
}
export interface TimelineItemProps extends HTMLLiAttributes {
    children: Snippet;
    orientationSlot?: Snippet;
    title: string;
    date: string;
    svgClass?: string;
    liClass?: string;
    divClass?: string;
    timeClass?: string;
    h3Class?: string;
    dateFormat?: DateFormat;
}
export interface ToastProps extends HTMLAttributes<HTMLDivElement> {
    children: Snippet;
    icon?: Snippet;
    toastStatus?: boolean;
    dismissable?: boolean;
    color?: ToastVaraints["color"];
    position?: ToastVaraints["position"];
    iconClass?: string;
    contentClass?: string;
    align?: boolean;
    params?: ParamsType;
    transition?: TransitionFunc;
    class?: string;
}
export interface TooltipProps extends PopperProps {
    type?: "light" | "dark" | "auto";
    color?: TooltipVariants["color"];
    isOpen?: boolean;
}
export interface AnchorProps {
    children: Snippet;
    color?: AnchorVariants["color"];
    asButton?: boolean;
    onclick?: (event: MouseEvent) => void;
    id?: string;
    class?: string;
    style?: string;
    tabindex?: number;
    title?: string;
    role?: string;
    "aria-label"?: string;
    "data-testid"?: string;
    href?: string;
    target?: string;
    rel?: string;
    download?: string | boolean;
    type?: "button" | "submit" | "reset";
    disabled?: boolean;
    name?: string;
    value?: string | number | string[];
    [key: string]: any;
}
export interface BlockquoteProps extends HTMLBlockquoteAttributes {
    children: Snippet;
    border?: boolean;
    italic?: boolean;
    bg?: boolean;
    alignment?: BlockquoteVariants["alignment"];
    size?: BlockquoteVariants["size"];
}
export interface DescriptionListProps extends HTMLAttributes<HTMLElement> {
    children: Snippet;
    tag: DescriptionListVariants["tag"];
}
export interface HeadingProps extends HTMLAttributes<HTMLElement> {
    children: Snippet;
    tag?: HeadingVariants["tag"];
}
export interface HrProps extends HTMLAttributes<HTMLElement> {
    children?: Snippet;
    divClass?: string;
    iconDivClass?: string;
    textSpanClass?: string;
    innerDivClass?: string;
}
export type EnhancedImgAttributes = Omit<HTMLImgAttributes, "src"> & {
    src: string;
};
export interface ImgProps extends HTMLImgAttributes {
    size?: ImgVariants["size"];
    effect?: ImgVariants["effect"];
    caption?: string;
    figClass?: string;
    captionClass?: string;
    href?: HTMLAnchorElement["href"];
}
export interface EnhandedImgProps extends EnhancedImgAttributes {
    size?: ImgVariants["size"];
    multiple?: boolean;
    transform?: string;
    effect?: ImgVariants["effect"];
    caption?: string;
    figClass?: string;
    captionClass?: string;
    href?: HTMLAnchorElement["href"];
}
export interface LayoutProps extends HTMLAttributes<HTMLElement> {
    children: Snippet;
}
export interface ListProps extends HTMLOlAttributes {
    children: Snippet;
    tag?: ListVariants["tag"];
    position?: ListVariants["position"];
    ctxClass?: string;
    isContenteditable?: boolean;
}
export interface LiProps extends HTMLLiAttributes {
    children: Snippet;
    icon?: boolean;
}
export interface MarkProps extends HTMLAttributes<HTMLElement> {
    children: Snippet;
}
export interface ParagraphProps extends ParagraphVariants, HTMLAttributes<HTMLParagraphElement> {
    children: Snippet;
    italic?: boolean;
    firstUpper?: boolean;
    justify?: boolean;
}
export interface SecondaryProps extends HTMLAttributes<HTMLElement> {
    children: Snippet;
}
export interface SpanProps extends SpanVariants, HTMLAttributes<HTMLSpanElement> {
    children?: Snippet;
    italic?: boolean;
    underline?: boolean;
    linethrough?: boolean;
    uppercase?: boolean;
}
export interface VideoProps extends HTMLVideoAttributes {
    type?: HTMLSourceAttributes["type"];
    src?: HTMLSourceAttributes["src"];
    trackSrc?: HTMLTrackAttributes["src"];
    srclang?: HTMLTrackAttributes["lang"];
    label?: HTMLTrackAttributes["label"];
}
export interface TriggeredToggleEvent extends ToggleEvent {
    trigger: HTMLElement;
}
export interface PopperProps extends Omit<HTMLAttributes<HTMLDivElement>, "onbeforetoggle" | "ontoggle"> {
    triggeredBy?: string;
    triggerDelay?: number;
    trigger?: "hover" | "click";
    placement?: Placement;
    arrow?: boolean;
    arrowClass?: string;
    offset?: number;
    yOnly?: boolean;
    strategy?: Strategy;
    reference?: string;
    middlewares?: Middleware[];
    children: Snippet;
    onbeforetoggle?: (ev: TriggeredToggleEvent) => void;
    ontoggle?: (ev: TriggeredToggleEvent) => void;
    transition?: TransitionFunc;
    transitionParams?: ParamsType;
    isOpen?: boolean;
}
export interface ArrowProps {
    placement?: Placement;
    cords: Partial<Coords>;
    strategy?: "absolute" | "fixed";
    class?: ClassValue | null;
}
export {};
