import type { TableSearchProps } from "../types";
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Type
 * [TableSearchProps](https://github.com/themesberg/flowbite-svelte/blob/main/src/lib/types.ts#L1667)
 * ## Props
 * @prop children
 * @prop header
 * @prop footer
 * @prop divClass = "relative overflow-x-auto shadow-md sm:rounded-lg"
 * @prop inputValue = $bindable()
 * @prop striped
 * @prop hoverable
 * @prop customColor = ""
 * @prop color = "default"
 * @prop innerDivClass = "p-4"
 * @prop inputClass
 * @prop searchClass = "relative mt-1"
 * @prop svgDivClass
 * @prop svgClass = "w-5 h-5 text-gray-500 dark:text-gray-400"
 * @prop tableClass = "w-full text-left text-sm"
 * @prop class: className
 * @prop placeholder = "Search"
 * @prop ...restProps
 */
declare const TableSearch: import("svelte").Component<TableSearchProps, {}, "inputValue">;
type TableSearch = ReturnType<typeof TableSearch>;
export default TableSearch;
