import { type TextareaProps } from "../..";
/**
 * [Go to docs](https://flowbite-svelte.com/)
 * ## Type
 * [TextareaProps](https://github.com/themesberg/flowbite-svelte/blob/main/src/lib/types.ts#L922)
 * ## Props
 * @prop header
 * @prop footer
 * @prop addon
 * @prop value = $bindable()
 * @prop elementRef = $bindable()
 * @prop divClass
 * @prop innerClass
 * @prop headerClass
 * @prop footerClass
 * @prop addonClass
 * @prop disabled
 * @prop class: className
 * @prop cols
 * @prop clearable
 * @prop clearableSvgClass
 * @prop clearableColor = "none"
 * @prop clearableClass
 * @prop clearableOnClick
 * @prop textareaClass
 * @prop ...restProps
 */
declare const Textarea: import("svelte").Component<TextareaProps, {}, "value" | "elementRef">;
type Textarea = ReturnType<typeof Textarea>;
export default Textarea;
