/// <reference types="react" />
import { UiProps } from '@tolgee/core';
export type KeyInScreenshot = {
    keyId: number;
    keyName: string;
    keyNamespace?: string | undefined;
    position?: {
        x: number;
        y: number;
        width: number;
        height: number;
    };
};
export interface ScreenshotInterface {
    id: number;
    filename: string;
    fileUrl: string;
    width?: number | undefined;
    height?: number | undefined;
    createdAt?: string;
    justUploaded: boolean;
    keyReferences?: KeyInScreenshot[];
}
export declare const useGallery: (uiProps: UiProps) => {
    error: import("../../client/HttpError").HttpError;
    screenshotsUploading: boolean;
    takingScreenshot: boolean;
    screenshots: ScreenshotInterface[];
    setScreenshots: import("react").Dispatch<import("react").SetStateAction<ScreenshotInterface[]>>;
    screenshotDetail: ScreenshotInterface;
    setScreenshotDetail: import("react").Dispatch<import("react").SetStateAction<ScreenshotInterface>>;
    handleUploadImages: (files: File[]) => Promise<void>;
    handleTakeScreenshot: (key: string, ns: string, changes: [language: string, value: string][]) => Promise<void>;
    handleRemoveScreenshot: (id: number) => void;
    deleteImages: (ids: number[]) => void;
    canTakeScreenshots: boolean;
};
