/// <reference types="react" />
import { UiProps } from '@tolgee/core';
import { TolgeeFormat } from '@tginternal/editor';
import { StateType } from '../State/translationStates';
import { HttpError } from '../../client/HttpError';
type FormTranslations = {
    [key: string]: {
        value: TolgeeFormat;
        state: StateType;
    };
};
type DialogProps = {
    keyName: string;
    defaultValue: string;
    onClose: () => void;
    uiProps: UiProps;
    fallbackNamespaces: string[];
    namespace: string;
    children: React.ReactNode;
};
export declare const DialogProvider: ({ children, ...props }: import("react").PropsWithChildren<DialogProps>) => import("react/jsx-runtime").JSX.Element, useDialogActions: () => {
    onInputChange: (key: string, value: TolgeeFormat) => void;
    onStateChange: (key: string, value: StateType) => void;
    handleUploadImages: (files: File[]) => Promise<void>;
    handleTakeScreenshot: () => void;
    handleRemoveScreenshot: (id: number) => void;
    onSave: () => Promise<void>;
    onClose: () => void;
    onSelectedLanguagesChange: (languages: string[]) => void;
    setContainer: import("react").Dispatch<import("react").SetStateAction<Element>>;
    setUseBrowserWindow: import("react").Dispatch<import("react").SetStateAction<boolean>>;
    setScreenshotDetail: import("react").Dispatch<import("react").SetStateAction<import("./useGallery").ScreenshotInterface>>;
    setSelectedNs: import("react").Dispatch<import("react").SetStateAction<string>>;
    setTags: import("react").Dispatch<import("react").SetStateAction<string[]>>;
    setIsPlural: import("react").Dispatch<import("react").SetStateAction<boolean>>;
    setPluralArgName: import("react").Dispatch<import("react").SetStateAction<string>>;
}, useDialogContext: <SelectorReturn>(selector: (state: {
    readonly input: string;
    readonly fallbackNamespaces: string[];
    readonly uiProps: UiProps;
    readonly selectedNs: string;
    readonly loading: boolean;
    readonly saving: boolean;
    readonly success: boolean;
    readonly error: Error;
    readonly availableLanguages: {
        id: number;
        name: string;
        tag: string;
        originalName?: string;
        flagEmoji?: string;
        base: boolean;
    }[];
    readonly selectedLanguages: string[];
    readonly formDisabled: boolean;
    readonly keyData: {
        keyId: number;
        keyName: string;
        keyIsPlural: boolean;
        keyPluralArgName?: string;
        keyNamespaceId?: number;
        keyNamespace?: string;
        keyDescription?: string;
        keyTags: {
            id: number;
            name: string;
        }[];
        screenshotCount: number;
        screenshots?: {
            id: number;
            filename: string;
            thumbnail: string;
            fileUrl: string;
            thumbnailUrl: string;
            createdAt?: string;
            keyReferences: {
                keyId: number;
                position?: {
                    x: number;
                    y: number;
                    width: number;
                    height: number;
                };
                keyName: string;
                keyNamespace?: string;
                originalText?: string;
            }[];
            location?: string;
            width?: number;
            height?: number;
        }[];
        contextPresent: boolean;
        translations: {
            [key: string]: {
                id: number;
                text?: string;
                state: "TRANSLATED" | "REVIEWED" | "UNTRANSLATED" | "DISABLED";
                outdated: boolean;
                auto: boolean;
                mtProvider?: "GOOGLE" | "AWS" | "DEEPL" | "AZURE" | "BAIDU" | "TOLGEE";
                commentCount: number;
                unresolvedCommentCount: number;
                fromTranslationMemory: boolean;
            };
        };
        tasks?: {
            number: number;
            languageId: number;
            languageTag: string;
            done: boolean;
            userAssigned: boolean;
            type: "TRANSLATE" | "REVIEW";
        }[];
    };
    readonly translationsForm: FormTranslations;
    readonly container: Element;
    readonly useBrowserWindow: boolean;
    readonly takingScreenshot: boolean;
    readonly screenshotsUploading: boolean;
    readonly screenshots: import("./useGallery").ScreenshotInterface[];
    readonly screenshotDetail: import("./useGallery").ScreenshotInterface;
    readonly linkToPlatform: string;
    readonly keyExists: boolean;
    readonly tags: string[];
    readonly permissions: {
        canEditTags: boolean;
        canViewScreenshots: boolean;
        canUploadScreenshots: boolean;
        canDeleteScreenshots: boolean;
        canSubmitForm: true | {
            number: number;
            languageId: number;
            languageTag: string;
            done: boolean;
            userAssigned: boolean;
            type: "TRANSLATE" | "REVIEW";
        };
        canSendBigMeta: boolean;
        canEditPlural: boolean;
        canEditState: (language: string) => boolean;
        canEditTranslation: (language: string) => boolean;
    };
    readonly canTakeScreenshots: boolean;
    readonly isPlural: boolean;
    readonly _pluralArgName: string;
    readonly pluralArgName: string;
    readonly pluralsSupported: boolean;
    readonly icuPlaceholders: boolean;
    readonly submitError: HttpError;
    readonly filterTagMissing: boolean;
}) => SelectorReturn) => SelectorReturn;
export {};
