export type StateType = 'UNTRANSLATED' | 'TRANSLATED' | 'REVIEWED' | 'DISABLED';
export type StateInType = Exclude<StateType, 'UNTRANSLATED' | 'DISABLED'>;
type StateStruct = Record<StateType, {
    name: string;
    color: string;
    next: StateInType | null;
}>;
export declare const TRANSLATION_STATES: StateStruct;
export declare const STATES_FOR_UPDATE: string[];
export {};
