import { NsFallback, ObserverOptionsInternal } from '@tolgee/core';
import { TranslationOnClick } from '@tolgee/core';
import { ElementMeta, NodeMeta, TolgeeElement } from '../../types';
import { ElementStoreType } from './ElementStore';
export declare function ElementRegistry(options: ObserverOptionsInternal, elementStore: ElementStoreType, onClick: TranslationOnClick): Readonly<{
    isRestricted: (element: Element) => boolean;
    register(element: Element, node: Node, nodeMeta: NodeMeta): void;
    forEachElement: (callback: (el: TolgeeElement, meta: ElementMeta) => void) => void;
    cleanupLingeringKeyAttributes(): void;
    cleanupRemovedNodes(removedNodes: Set<Node>): void;
    findAll(key?: string, ns?: NsFallback): ElementMeta[];
    run(mouseHighlight: boolean): void;
    stop(): void;
}>;
export type ElementRegistryInstance = ReturnType<typeof ElementRegistry>;
