(function(global2, factory) {
  typeof exports === "object" && typeof module !== "undefined" ? factory(exports) : typeof define === "function" && define.amd ? define(["exports"], factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, factory(global2["@tolgee/web"] = {}));
})(this, function(exports2) {
  "use strict";var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};

  var _a2;
  function _mergeNamespaces(n, m2) {
    for (var i2 = 0; i2 < m2.length; i2++) {
      const e = m2[i2];
      if (typeof e !== "string" && !Array.isArray(e)) {
        for (const k in e) {
          if (k !== "default" && !(k in n)) {
            const d = Object.getOwnPropertyDescriptor(e, k);
            if (d) {
              Object.defineProperty(n, k, d.get ? d : {
                enumerable: true,
                get: () => e[k]
              });
            }
          }
        }
      }
    }
    return Object.freeze(Object.defineProperty(n, Symbol.toStringTag, { value: "Module" }));
  }
  function isPromise(value) {
    return Boolean(value && typeof value.then === "function");
  }
  function valueOrPromise(value, callback) {
    if (isPromise(value)) {
      return Promise.resolve(value).then(callback);
    } else {
      return callback(value);
    }
  }
  function handleRegularOrAsyncErr(onError, createError, callback) {
    function handle(e) {
      const error = createError(e);
      onError.emit(error);
      console.error(error);
      throw error;
    }
    try {
      const result = callback();
      if (isPromise(result)) {
        return result.catch(handle);
      }
      return result;
    } catch (e) {
      handle(e);
    }
  }
  function missingOptionError(option) {
    const options = (Array.isArray(option) ? option : [option]).map((val) => `'${val}'`);
    const lastPart = options.slice(-2).join(" or ");
    const firstPart = options.slice(0, -2);
    const stringifiedOptions = [...firstPart, lastPart].join(", ");
    return `Tolgee: You need to specify ${stringifiedOptions} option`;
  }
  function isObject(item) {
    return typeof item === "object" && !Array.isArray(item) && item !== null;
  }
  function getFallback(value) {
    if (typeof value === "string") {
      return [value];
    }
    if (Array.isArray(value)) {
      return value;
    }
    return void 0;
  }
  function getFallbackArray(value) {
    return getFallback(value) || [];
  }
  function getFallbackFromStruct(language2, fallbackLanguage) {
    if (isObject(fallbackLanguage)) {
      return getFallbackArray(fallbackLanguage === null || fallbackLanguage === void 0 ? void 0 : fallbackLanguage[language2]);
    } else {
      return getFallbackArray(fallbackLanguage);
    }
  }
  function unique(arr) {
    return Array.from(new Set(arr));
  }
  function sanitizeUrl(url) {
    return url ? url.replace(/\/+$/, "") : url;
  }
  function getErrorMessage$1(error) {
    if (typeof error === "string") {
      return error;
    } else if (typeof (error === null || error === void 0 ? void 0 : error.message) === "string") {
      return error.message;
    }
  }
  const defaultFetchFunction = (input, options) => fetch(input, options);
  function headersInitToRecord(headersInit) {
    return Object.fromEntries(new Headers(headersInit).entries());
  }
  const createFetchFunction = (fetchFn2 = defaultFetchFunction) => {
    return (input, init) => {
      let headers = headersInitToRecord(init === null || init === void 0 ? void 0 : init.headers);
      if (headers["x-api-key"]) {
        headers = Object.assign({ "x-tolgee-sdk-type": "JS", "x-tolgee-sdk-version": "prerelease" }, headers);
      }
      return fetchFn2(input, Object.assign(Object.assign({}, init), { headers }));
    };
  };
  const EventEmitter = (type, isActive) => {
    let handlers2 = [];
    return {
      listen(handler) {
        const handlerWrapper = (e) => {
          handler(e);
        };
        handlers2.push(handlerWrapper);
        return {
          unsubscribe() {
            handlers2 = handlers2.filter((i2) => handlerWrapper !== i2);
          }
        };
      },
      emit(data) {
        if (isActive()) {
          handlers2.forEach((handler) => handler({ type, value: data }));
        }
      }
    };
  };
  function EventEmitterCombined(isActive) {
    let handlers2 = [];
    let queue = [];
    function solveQueue() {
      if (queue.length === 0) {
        return;
      }
      const queueCopy = queue;
      queue = [];
      handlers2.forEach((handler) => {
        handler(queueCopy);
      });
    }
    return Object.freeze({
      listen(handler) {
        const handlerWrapper = (events) => {
          handler(events);
        };
        handlers2.push(handlerWrapper);
        return {
          unsubscribe() {
            handlers2 = handlers2.filter((i2) => handlerWrapper !== i2);
          }
        };
      },
      emit(e, delayed) {
        if (isActive()) {
          if (isActive()) {
            queue.push(e);
            if (!delayed) {
              solveQueue();
            } else {
              setTimeout(solveQueue, 0);
            }
          }
        }
      }
    });
  }
  function Events() {
    let emitterActive = true;
    function isActive() {
      return emitterActive;
    }
    const self2 = Object.freeze({
      onPendingLanguageChange: EventEmitter("pendingLanguage", isActive),
      onLanguageChange: EventEmitter("language", isActive),
      onLoadingChange: EventEmitter("loading", isActive),
      onFetchingChange: EventEmitter("fetching", isActive),
      onInitialLoaded: EventEmitter("initialLoad", isActive),
      onRunningChange: EventEmitter("running", isActive),
      onCacheChange: EventEmitter("cache", isActive),
      onPermanentChange: EventEmitter("permanentChange", isActive),
      onError: EventEmitter("error", isActive),
      onUpdate: EventEmitterCombined(isActive),
      setEmitterActive(active) {
        emitterActive = active;
      },
      on: (event, handler) => {
        switch (event) {
          case "pendingLanguage":
            return self2.onPendingLanguageChange.listen(handler);
          case "language":
            return self2.onLanguageChange.listen(handler);
          case "loading":
            return self2.onLoadingChange.listen(handler);
          case "fetching":
            return self2.onFetchingChange.listen(handler);
          case "initialLoad":
            return self2.onInitialLoaded.listen(handler);
          case "running":
            return self2.onRunningChange.listen(handler);
          case "cache":
            return self2.onCacheChange.listen(handler);
          case "update":
            return self2.onUpdate.listen(handler);
          case "permanentChange":
            return self2.onPermanentChange.listen(handler);
          case "error":
            return self2.onError.listen(handler);
        }
      }
    });
    self2.onInitialLoaded.listen((e) => self2.onUpdate.emit(e, false));
    self2.onLanguageChange.listen((e) => self2.onUpdate.emit(e, false));
    self2.onCacheChange.listen((e) => self2.onUpdate.emit(e, true));
    return self2;
  }
  class RecordFetchError extends Error {
    constructor(descriptor, cause, isDev = false) {
      const { language: language2, namespace } = descriptor;
      super(`Tolgee: Failed to fetch record for "${language2}"${namespace && ` and "${namespace}"`}`);
      this.cause = cause;
      this.isDev = isDev;
      this.name = "RecordFetchError";
      this.language = language2;
      this.namespace = namespace;
    }
  }
  class LanguageDetectorError extends Error {
    constructor(message, cause) {
      super(message);
      this.cause = cause;
      this.name = "LanguageDetectorError";
    }
  }
  class LanguageStorageError extends Error {
    constructor(message, cause) {
      super(message);
      this.cause = cause;
      this.name = "LanguageStorageError";
    }
  }
  const flattenTranslationsToMap = (data) => {
    const result = /* @__PURE__ */ new Map();
    Object.entries(data).forEach(([key, value]) => {
      if (value === void 0 || value === null) {
        return;
      }
      if (typeof value === "object") {
        flattenTranslationsToMap(value).forEach((flatValue, flatKey) => {
          result.set(key + "." + flatKey, flatValue);
        });
        return;
      }
      result.set(key, value);
    });
    return result;
  };
  const flattenTranslations = (data) => {
    return Object.fromEntries(flattenTranslationsToMap(data).entries());
  };
  const decodeCacheKey = (key) => {
    const [firstPart, ...rest] = key.split(":");
    const secondPart = rest.join(":");
    return { language: firstPart, namespace: secondPart || "" };
  };
  const encodeCacheKey = ({ language: language2, namespace }) => {
    if (namespace) {
      return `${language2}:${namespace}`;
    } else {
      return language2;
    }
  };
  function Cache(events, backendGetRecord, backendGetDevRecord, withDefaultNs, isInitialLoading, fetchingObserver, loadingObserver) {
    const asyncRequests = /* @__PURE__ */ new Map();
    const cache2 = /* @__PURE__ */ new Map();
    let staticData = {};
    let version = 0;
    function addRecordInternal(descriptor, data, recordVersion) {
      const cacheKey = encodeCacheKey(descriptor);
      cache2.set(cacheKey, {
        data: flattenTranslations(data),
        version: recordVersion
      });
      events.onCacheChange.emit(decodeCacheKey(cacheKey));
    }
    async function fetchProd(keyObject) {
      function handleError(e) {
        const error = new RecordFetchError(keyObject, e);
        events.onError.emit(error);
        console.error(error);
        throw error;
      }
      const dataFromBackend = backendGetRecord(keyObject);
      if (isPromise(dataFromBackend)) {
        const result = await dataFromBackend.catch(handleError);
        if (result !== void 0) {
          return result;
        }
      }
      const staticDataValue = staticData[encodeCacheKey(keyObject)];
      if (typeof staticDataValue === "function") {
        try {
          return await staticDataValue();
        } catch (e) {
          handleError(e);
        }
      } else {
        return staticDataValue;
      }
    }
    async function fetchData(keyObject, isDev) {
      let result = void 0;
      if (isDev) {
        try {
          result = await backendGetDevRecord(keyObject);
        } catch (e) {
          const error = new RecordFetchError(keyObject, e, true);
          events.onError.emit(error);
          console.warn(error);
        }
      }
      if (!result) {
        result = await fetchProd(keyObject);
      }
      return result;
    }
    const self2 = Object.freeze({
      addStaticData(data) {
        if (Array.isArray(data)) {
          for (const record of data) {
            const key = encodeCacheKey(record);
            const existing = cache2.get(key);
            if (!existing || existing.version === 0) {
              addRecordInternal(record, flattenTranslations(record.data), 0);
            }
          }
        } else if (data) {
          staticData = Object.assign(Object.assign({}, staticData), data);
          Object.entries(data).forEach(([key, value]) => {
            if (typeof value !== "function") {
              const descriptor = decodeCacheKey(key);
              const existing = cache2.get(key);
              if (!existing || existing.version === 0) {
                addRecordInternal(descriptor, flattenTranslations(value), 0);
              }
            }
          });
        }
      },
      invalidate() {
        asyncRequests.clear();
        version += 1;
      },
      addRecord(descriptor, data) {
        addRecordInternal(descriptor, flattenTranslations(data), version);
      },
      exists(descriptor, strict = false) {
        const record = cache2.get(encodeCacheKey(descriptor));
        if (record && strict) {
          return record.version === version;
        }
        return Boolean(record);
      },
      getRecord(descriptor) {
        const descriptorWithNs = withDefaultNs(descriptor);
        const cacheKey = encodeCacheKey(descriptorWithNs);
        const cacheRecord = cache2.get(cacheKey);
        if (!cacheRecord) {
          return void 0;
        }
        return Object.assign(Object.assign({}, descriptorWithNs), { cacheKey, data: cacheRecord.data });
      },
      getAllRecords() {
        const entries = Array.from(cache2.entries());
        return entries.map(([key]) => self2.getRecord(decodeCacheKey(key)));
      },
      getTranslation(descriptor, key) {
        var _a3;
        return (_a3 = cache2.get(encodeCacheKey(descriptor))) === null || _a3 === void 0 ? void 0 : _a3.data[key];
      },
      getTranslationNs(namespaces, languages, key) {
        var _a3;
        for (const namespace of namespaces) {
          for (const language2 of languages) {
            const value = (_a3 = cache2.get(encodeCacheKey({ language: language2, namespace }))) === null || _a3 === void 0 ? void 0 : _a3.data[key];
            if (value !== void 0 && value !== null) {
              return [namespace];
            }
          }
        }
        return unique(namespaces);
      },
      getTranslationFallback(namespaces, languages, key) {
        var _a3;
        for (const namespace of namespaces) {
          for (const language2 of languages) {
            const value = (_a3 = cache2.get(encodeCacheKey({ language: language2, namespace }))) === null || _a3 === void 0 ? void 0 : _a3.data[key];
            if (value !== void 0 && value !== null) {
              return value;
            }
          }
        }
        return void 0;
      },
      changeTranslation(descriptor, key, value) {
        var _a3;
        const record = (_a3 = cache2.get(encodeCacheKey(descriptor))) === null || _a3 === void 0 ? void 0 : _a3.data;
        if (record) {
          record[key] = value;
          events.onCacheChange.emit(Object.assign(Object.assign({}, descriptor), { key }));
        }
      },
      isFetching(ns2) {
        if (isInitialLoading()) {
          return true;
        }
        if (ns2 === void 0) {
          return asyncRequests.size > 0;
        }
        const namespaces = getFallbackArray(ns2);
        return Boolean(Array.from(asyncRequests.keys()).find((key) => namespaces.includes(decodeCacheKey(key).namespace)));
      },
      isLoading(language2, ns2) {
        const namespaces = getFallbackArray(ns2);
        if (isInitialLoading()) {
          return true;
        }
        const pendingCacheKeys = Array.from(asyncRequests.keys());
        return Boolean(pendingCacheKeys.find((key) => {
          const descriptor = decodeCacheKey(key);
          return (!namespaces.length || namespaces.includes(descriptor.namespace)) && !self2.exists({
            namespace: descriptor.namespace,
            language: language2
          });
        }));
      },
      async loadRecords(descriptors, options) {
        const withPromises = descriptors.map((descriptor) => {
          const keyObject = withDefaultNs(descriptor);
          const cacheKey = encodeCacheKey(keyObject);
          if (options === null || options === void 0 ? void 0 : options.useCache) {
            const exists = self2.exists(keyObject, true);
            if (exists) {
              return Object.assign(Object.assign({}, keyObject), { new: false, cacheKey, data: self2.getRecord(keyObject).data });
            }
          }
          const existingPromise = asyncRequests.get(cacheKey);
          if (existingPromise) {
            return Object.assign(Object.assign({}, keyObject), { new: false, promise: existingPromise, cacheKey });
          }
          const dataPromise = fetchData(keyObject, !(options === null || options === void 0 ? void 0 : options.noDev)) || Promise.resolve(void 0);
          asyncRequests.set(cacheKey, dataPromise);
          return Object.assign(Object.assign({}, keyObject), { new: true, promise: dataPromise, cacheKey });
        });
        fetchingObserver.notify();
        loadingObserver.notify();
        const promisesToWait = withPromises.map((val) => val.promise).filter(Boolean);
        const fetchedData = await Promise.all(promisesToWait);
        withPromises.forEach((value) => {
          var _a3;
          if (value.promise) {
            value.data = flattenTranslations((_a3 = fetchedData[0]) !== null && _a3 !== void 0 ? _a3 : {});
            fetchedData.shift();
          }
          const promiseChanged = asyncRequests.get(value.cacheKey) !== value.promise;
          if (value.new && !promiseChanged) {
            asyncRequests.delete(value.cacheKey);
            if (value.data) {
              self2.addRecord(value, value.data);
            } else if (!self2.getRecord(value)) {
              self2.addRecord(value, {});
            }
          }
        });
        fetchingObserver.notify();
        loadingObserver.notify();
        return withPromises.map((val) => {
          var _a3;
          return {
            language: val.language,
            namespace: val.namespace,
            data: (_a3 = val.data) !== null && _a3 !== void 0 ? _a3 : {},
            cacheKey: val.cacheKey
          };
        });
      }
    });
    return self2;
  }
  function __rest(s, e) {
    var t2 = {};
    for (var p2 in s)
      if (Object.prototype.hasOwnProperty.call(s, p2) && e.indexOf(p2) < 0)
        t2[p2] = s[p2];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
      for (var i2 = 0, p2 = Object.getOwnPropertySymbols(s); i2 < p2.length; i2++) {
        if (e.indexOf(p2[i2]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p2[i2]))
          t2[p2[i2]] = s[p2[i2]];
      }
    return t2;
  }
  const defaultObserverOptions = {
    tagAttributes: {
      textarea: ["placeholder"],
      input: ["value", "placeholder"],
      img: ["alt"],
      "*": ["aria-label", "title"]
    },
    restrictedElements: ["script", "style"],
    highlightKeys: ["Alt"],
    highlightColor: "rgb(255, 0, 0)",
    highlightWidth: 5,
    inputPrefix: "%-%tolgee:",
    inputSuffix: "%-%",
    passToParent: ["option", "optgroup"],
    fullKeyEncode: false
  };
  const DEFAULT_FORMAT_ERROR = "invalid";
  const DEFAULT_API_URL = "https://app.tolgee.io";
  const DEFAULT_MISSING_TRANSLATION = ({ key }) => key;
  const defaultValues = {
    observerOptions: defaultObserverOptions,
    observerType: "invisible",
    onFormatError: DEFAULT_FORMAT_ERROR,
    apiUrl: DEFAULT_API_URL,
    autoLoadRequiredData: true,
    fetch: createFetchFunction(),
    onTranslationMissing: DEFAULT_MISSING_TRANSLATION
  };
  const combineOptions = (...states) => {
    let result = {};
    states.forEach((state) => {
      result = Object.assign(Object.assign(Object.assign({}, result), state), { observerOptions: Object.assign(Object.assign({}, result.observerOptions), state === null || state === void 0 ? void 0 : state.observerOptions) });
    });
    return result;
  };
  function initState(options, previousState) {
    const initialOptions = combineOptions(defaultValues, previousState === null || previousState === void 0 ? void 0 : previousState.initialOptions, options);
    initialOptions.apiUrl = sanitizeUrl(initialOptions.apiUrl);
    if (options === null || options === void 0 ? void 0 : options.fetch) {
      initialOptions.fetch = createFetchFunction(options.fetch);
    }
    return {
      initialOptions,
      activeNamespaces: (previousState === null || previousState === void 0 ? void 0 : previousState.activeNamespaces) || /* @__PURE__ */ new Map(),
      language: previousState === null || previousState === void 0 ? void 0 : previousState.language,
      pendingLanguage: previousState === null || previousState === void 0 ? void 0 : previousState.language,
      isInitialLoading: false,
      isRunning: false
    };
  }
  function Plugins(getLanguage, getInitialOptions, getAvailableLanguages, getFallbackNamespaces, getTranslationNs, getTranslation, changeTranslation, events) {
    const plugins = {
      ui: void 0
    };
    const instances = {
      formatters: [],
      finalFormatter: void 0,
      observer: void 0,
      devBackend: void 0,
      backends: [],
      ui: void 0,
      languageDetector: void 0,
      languageStorage: void 0
    };
    const onClick = async ({ keysAndDefaults, target }) => {
      var _a3;
      const withNs = keysAndDefaults.map(({ key, ns: ns2, defaultValue }) => {
        return {
          key,
          defaultValue,
          fallbackNamespaces: getFallbackNamespaces(ns2),
          namespace: getTranslationNs({ key, ns: ns2 })[0],
          translation: getTranslation({
            key,
            ns: ns2
          })
        };
      });
      (_a3 = instances.ui) === null || _a3 === void 0 ? void 0 : _a3.handleElementClick(withNs, target);
    };
    const findPositions = (key, ns2) => {
      var _a3;
      return ((_a3 = instances.observer) === null || _a3 === void 0 ? void 0 : _a3.findPositions(key, ns2)) || [];
    };
    function translate(props) {
      const translation = getTranslation({
        key: props.key,
        ns: props.ns
      });
      return self2.formatTranslation(Object.assign(Object.assign({}, props), { translation, formatEnabled: true }));
    }
    function getCommonProps() {
      return { fetch: getInitialOptions().fetch };
    }
    function setObserver(observer) {
      instances.observer = observer === null || observer === void 0 ? void 0 : observer();
    }
    function hasObserver() {
      return Boolean(instances.observer);
    }
    function addFormatter(formatter2) {
      if (formatter2) {
        instances.formatters.push(formatter2);
      }
    }
    function setFinalFormatter(formatter2) {
      instances.finalFormatter = formatter2;
    }
    function setUi(ui2) {
      plugins.ui = ui2;
    }
    function hasUi() {
      return Boolean(plugins.ui);
    }
    function setLanguageStorage(storage) {
      instances.languageStorage = storage;
    }
    function setLanguageDetector(detector) {
      instances.languageDetector = detector;
    }
    function storageLoadLanguage() {
      return handleRegularOrAsyncErr(events.onError, (e) => new LanguageStorageError("Tolgee: Failed to load language", e), () => {
        var _a3;
        return (_a3 = instances.languageStorage) === null || _a3 === void 0 ? void 0 : _a3.getLanguage(getCommonProps());
      });
    }
    function detectLanguage2() {
      if (!instances.languageDetector) {
        return void 0;
      }
      const availableLanguages = getAvailableLanguages();
      return handleRegularOrAsyncErr(events.onError, (e) => new LanguageDetectorError("Tolgee: Failed to detect language", e), () => {
        var _a3;
        return (_a3 = instances.languageDetector) === null || _a3 === void 0 ? void 0 : _a3.getLanguage(Object.assign({ availableLanguages }, getCommonProps()));
      });
    }
    function addBackend(backend) {
      if (backend) {
        instances.backends.push(backend);
      }
    }
    function setDevBackend(backend) {
      instances.devBackend = backend;
    }
    function addPlugin(tolgeeInstance, plugin) {
      const pluginTools = Object.freeze({
        setFinalFormatter,
        addFormatter,
        setObserver,
        hasObserver,
        setUi,
        hasUi,
        setDevBackend,
        addBackend,
        setLanguageDetector,
        setLanguageStorage
      });
      plugin(tolgeeInstance, pluginTools);
    }
    const self2 = Object.freeze({
      addPlugin,
      findPositions,
      run() {
        var _a3, _b;
        const { apiKey, apiUrl, projectId, observerOptions, tagNewKeys, filterTag } = getInitialOptions();
        instances.ui = (_a3 = plugins.ui) === null || _a3 === void 0 ? void 0 : _a3.call(plugins, {
          apiKey,
          apiUrl,
          projectId,
          highlight: self2.highlight,
          changeTranslation,
          findPositions,
          onPermanentChange: (data) => events.onPermanentChange.emit(data),
          tagNewKeys,
          filterTag
        });
        (_b = instances.observer) === null || _b === void 0 ? void 0 : _b.run({
          mouseHighlight: Boolean(instances.ui),
          options: observerOptions,
          translate,
          onClick
        });
      },
      stop() {
        var _a3;
        instances.ui = void 0;
        (_a3 = instances.observer) === null || _a3 === void 0 ? void 0 : _a3.stop();
      },
      getLanguageStorage() {
        return instances.languageStorage;
      },
      getInitialLanguage() {
        const availableLanguages = getAvailableLanguages();
        const languageOrPromise = storageLoadLanguage();
        return valueOrPromise(languageOrPromise, (language2) => {
          if ((!availableLanguages || availableLanguages.includes(language2)) && language2) {
            return language2;
          }
          return detectLanguage2();
        });
      },
      setStoredLanguage(language2) {
        return handleRegularOrAsyncErr(events.onError, (e) => new LanguageStorageError("Tolgee: Failed to store language", e), () => {
          var _a3;
          return (_a3 = instances.languageStorage) === null || _a3 === void 0 ? void 0 : _a3.setLanguage(language2, getCommonProps());
        });
      },
      getDevBackend() {
        return instances.devBackend;
      },
      getBackendRecord: async ({ language: language2, namespace }) => {
        for (const backend of instances.backends) {
          const data = await backend.getRecord(Object.assign({
            language: language2,
            namespace
          }, getCommonProps()));
          if (data !== void 0) {
            return data;
          }
        }
        return void 0;
      },
      getBackendDevRecord: async ({ language: language2, namespace }) => {
        var _a3;
        const { apiKey, apiUrl, projectId, filterTag } = getInitialOptions();
        if (!apiKey || !apiUrl || !self2.hasDevBackend()) {
          return void 0;
        }
        return (_a3 = instances.devBackend) === null || _a3 === void 0 ? void 0 : _a3.getRecord(Object.assign({
          apiKey,
          apiUrl,
          projectId,
          language: language2,
          namespace,
          filterTag
        }, getCommonProps()));
      },
      getLanguageDetector() {
        return instances.languageDetector;
      },
      retranslate() {
        var _a3;
        (_a3 = instances.observer) === null || _a3 === void 0 ? void 0 : _a3.retranslate();
      },
      highlight: (key, ns2) => {
        var _a3, _b;
        return ((_b = (_a3 = instances.observer) === null || _a3 === void 0 ? void 0 : _a3.highlight) === null || _b === void 0 ? void 0 : _b.call(_a3, key, ns2)) || { unhighlight() {
        } };
      },
      unwrap(text) {
        var _a3;
        if (instances.observer) {
          return (_a3 = instances.observer) === null || _a3 === void 0 ? void 0 : _a3.unwrap(text);
        }
        return { text, keys: [] };
      },
      wrap(params) {
        var _a3;
        if (instances.observer) {
          return (_a3 = instances.observer) === null || _a3 === void 0 ? void 0 : _a3.wrap(params);
        }
        return params.translation;
      },
      hasDevBackend() {
        return Boolean(self2.getDevBackend());
      },
      formatTranslation(_a3) {
        var _b;
        var { formatEnabled } = _a3, props = __rest(_a3, ["formatEnabled"]);
        const { key, translation, defaultValue, noWrap, params, ns: ns2, orEmpty } = props;
        const formattableTranslation = translation !== null && translation !== void 0 ? translation : defaultValue;
        let translationMissingResult = "";
        if (translation === void 0 || translation === null) {
          translationMissingResult = getInitialOptions().onTranslationMissing(props);
        }
        let result = formattableTranslation !== null && formattableTranslation !== void 0 ? formattableTranslation : orEmpty ? "" : translationMissingResult;
        const language2 = getLanguage();
        const isFormatEnabled = formatEnabled || !((_b = instances.observer) === null || _b === void 0 ? void 0 : _b.outputNotFormattable);
        const wrap = (result2) => {
          if (instances.observer && !noWrap) {
            return instances.observer.wrap({
              key,
              translation: result2,
              defaultValue,
              params,
              ns: ns2
            });
          }
          return result2;
        };
        result = wrap(result);
        try {
          if (formattableTranslation && language2 && isFormatEnabled) {
            for (const formatter2 of instances.formatters) {
              result = formatter2.format({
                translation: result,
                language: language2,
                params
              });
            }
          }
          if (instances.finalFormatter && formattableTranslation && language2 && isFormatEnabled) {
            result = instances.finalFormatter.format({
              translation: result,
              language: language2,
              params
            });
          }
        } catch (e) {
          console.error(e);
          const errorMessage = getErrorMessage$1(e) || DEFAULT_FORMAT_ERROR;
          const onFormatError = getInitialOptions().onFormatError;
          const formatErrorType = typeof onFormatError;
          if (formatErrorType === "string") {
            result = onFormatError;
          } else if (formatErrorType === "function") {
            result = onFormatError(errorMessage, props);
          } else {
            result = DEFAULT_FORMAT_ERROR;
          }
          result = wrap(result);
        }
        return result;
      }
    });
    return self2;
  }
  const ValueObserver = (initialValue, valueGetter, handler) => {
    let previousValue = initialValue;
    return Object.freeze({
      init(value) {
        previousValue = value;
      },
      notify() {
        const value = valueGetter();
        if (previousValue !== value) {
          handler(value);
        }
        previousValue = value;
      }
    });
  };
  function State(onLanguageChange, onPendingLanguageChange, onRunningChange) {
    let state = initState();
    let devCredentials = void 0;
    const self2 = Object.freeze({
      init(options) {
        state = initState(options, state);
      },
      isRunning() {
        return state.isRunning;
      },
      setRunning(value) {
        if (state.isRunning !== value) {
          state.isRunning = value;
          onRunningChange.emit(value);
        }
      },
      isInitialLoading() {
        return state.isInitialLoading;
      },
      setInitialLoading(value) {
        state.isInitialLoading = value;
      },
      getLanguage() {
        return state.language || state.initialOptions.language;
      },
      setLanguage(language2) {
        if (state.language !== language2) {
          state.language = language2;
          onLanguageChange.emit(language2);
        }
      },
      getPendingLanguage() {
        return state.pendingLanguage || self2.getLanguage();
      },
      setPendingLanguage(language2) {
        if (state.pendingLanguage !== language2) {
          state.pendingLanguage = language2;
          onPendingLanguageChange.emit(language2);
        }
      },
      getInitialOptions() {
        return Object.assign(Object.assign({}, state.initialOptions), devCredentials);
      },
      addActiveNs(ns2) {
        const namespaces = getFallbackArray(ns2);
        namespaces.forEach((namespace) => {
          const value = state.activeNamespaces.get(namespace);
          if (value !== void 0) {
            state.activeNamespaces.set(namespace, value + 1);
          } else {
            state.activeNamespaces.set(namespace, 1);
          }
        });
      },
      removeActiveNs(ns2) {
        const namespaces = getFallbackArray(ns2);
        namespaces.forEach((namespace) => {
          const value = state.activeNamespaces.get(namespace);
          if (value !== void 0 && value > 1) {
            state.activeNamespaces.set(namespace, value - 1);
          } else {
            state.activeNamespaces.delete(namespace);
          }
        });
      },
      getRequiredNamespaces() {
        return unique([
          self2.getDefaultNs(),
          ...state.initialOptions.ns || [],
          ...getFallbackArray(state.initialOptions.fallbackNs),
          ...state.activeNamespaces.keys()
        ]);
      },
      getFallbackLangs(lang) {
        const language2 = lang || self2.getLanguage();
        if (!language2) {
          return [];
        }
        return unique([
          language2,
          ...getFallbackFromStruct(language2, state.initialOptions.fallbackLanguage)
        ]);
      },
      getFallbackNs() {
        return getFallbackArray(state.initialOptions.fallbackNs);
      },
      getNs() {
        var _a3, _b;
        return ((_a3 = state.initialOptions.ns) === null || _a3 === void 0 ? void 0 : _a3.length) ? state.initialOptions.ns : [(_b = state.initialOptions.defaultNs) !== null && _b !== void 0 ? _b : ""];
      },
      getDefaultNs(ns2) {
        var _a3, _b, _c;
        return ns2 === void 0 ? (_c = (_a3 = state.initialOptions.defaultNs) !== null && _a3 !== void 0 ? _a3 : (_b = state.initialOptions.ns) === null || _b === void 0 ? void 0 : _b[0]) !== null && _c !== void 0 ? _c : "" : ns2;
      },
      getAvailableLanguages() {
        if (state.initialOptions.availableLanguages) {
          return state.initialOptions.availableLanguages;
        } else if (state.initialOptions.staticData) {
          const languagesFromStaticData = Object.keys(state.initialOptions.staticData).map((key) => decodeCacheKey(key).language);
          return Array.from(new Set(languagesFromStaticData));
        }
      },
      getAvailableNs() {
        return state.initialOptions.availableNs;
      },
      withDefaultNs(descriptor) {
        return {
          namespace: descriptor.namespace === void 0 ? self2.getDefaultNs() : descriptor.namespace,
          language: descriptor.language
        };
      },
      overrideCredentials(credentials) {
        if (credentials) {
          devCredentials = Object.assign(Object.assign({}, credentials), { apiUrl: sanitizeUrl(credentials.apiUrl) });
        } else {
          devCredentials = void 0;
        }
      }
    });
    return self2;
  }
  function parseCombinedOptions(_a3) {
    var { ns: ns2, noWrap, orEmpty, params, language: language2 } = _a3, rest = __rest(_a3, ["ns", "noWrap", "orEmpty", "params", "language"]);
    const options = {
      ns: ns2,
      noWrap,
      orEmpty,
      language: language2
    };
    return Object.assign(Object.assign({}, options), { params: Object.assign({}, rest) });
  }
  const getTranslateProps = (keyOrProps, ...params) => {
    let result = {};
    let options;
    if (typeof keyOrProps === "object") {
      result = keyOrProps;
    } else {
      result.key = keyOrProps;
      if (typeof params[0] === "string") {
        result.defaultValue = params[0];
        options = params[1];
      } else if (typeof params[0] === "object") {
        options = params[0];
      }
    }
    if (options) {
      result = Object.assign(Object.assign({}, parseCombinedOptions(options)), result);
    }
    return result;
  };
  function Controller({ options }) {
    const events = Events();
    const fetchingObserver = ValueObserver(false, () => cache2.isFetching(), events.onFetchingChange.emit);
    const loadingObserver = ValueObserver(false, () => self2.isLoading(), events.onLoadingChange.emit);
    const state = State(events.onLanguageChange, events.onPendingLanguageChange, events.onRunningChange);
    const pluginService = Plugins(state.getLanguage, state.getInitialOptions, state.getAvailableLanguages, getDefaultAndFallbackNs, getTranslationNs, getTranslation, changeTranslation, events);
    const cache2 = Cache(events, pluginService.getBackendRecord, pluginService.getBackendDevRecord, state.withDefaultNs, state.isInitialLoading, fetchingObserver, loadingObserver);
    if (options) {
      init(options);
    }
    let runPromise;
    events.onUpdate.listen(() => {
      if (state.isRunning()) {
        pluginService.retranslate();
      }
    });
    function getFallbackNs() {
      return state.getFallbackNs();
    }
    function getDefaultNs(ns2) {
      return state.getDefaultNs(ns2);
    }
    function getDefaultAndFallbackNs(ns2) {
      return unique([...getFallbackArray(getDefaultNs(ns2)), ...getFallbackNs()]);
    }
    function getRequiredNamespaces(ns2) {
      return unique([
        ...getFallbackArray(ns2 !== null && ns2 !== void 0 ? ns2 : getDefaultNs()),
        ...state.getRequiredNamespaces()
      ]);
    }
    function changeTranslation(descriptor, key, value) {
      const keyObject = state.withDefaultNs(descriptor);
      const previousValue = cache2.getTranslation(keyObject, key);
      cache2.changeTranslation(keyObject, key, value);
      return {
        revert() {
          cache2.changeTranslation(keyObject, key, previousValue);
        }
      };
    }
    function init(options2) {
      state.init(options2);
      cache2.addStaticData(state.getInitialOptions().staticData);
    }
    function getRequiredDescriptors(lang, ns2) {
      const languages = state.getFallbackLangs(lang);
      const namespaces = getRequiredNamespaces(ns2);
      const result = [];
      languages.forEach((language2) => {
        namespaces.forEach((namespace) => {
          result.push({ language: language2, namespace });
        });
      });
      return result;
    }
    function getMissingDescriptors(lang, ns2) {
      return getRequiredDescriptors(lang, ns2).filter((descriptor) => !cache2.exists(descriptor, true));
    }
    function getMatrixRecords(options2) {
      let languages = [];
      let namespaces = [];
      if (Array.isArray(options2.languages)) {
        languages = options2.languages;
      } else if (options2.languages === "all") {
        const availableLanguages = self2.getAvailableLanguages();
        if (!availableLanguages) {
          throw new Error(missingOptionError("availableLanguages"));
        }
        languages = availableLanguages;
      }
      if (Array.isArray(options2.namespaces)) {
        namespaces = options2.namespaces;
      } else if (options2.namespaces === "all") {
        const availableNs = self2.getAvailableNs();
        if (!availableNs) {
          throw new Error(missingOptionError("availableNs"));
        }
        namespaces = availableNs;
      }
      const records = [];
      languages.forEach((language2) => {
        namespaces.forEach((namespace) => {
          records.push({ language: language2, namespace });
        });
      });
      return records;
    }
    function getTranslationNs({ key, ns: ns2 }) {
      const languages = state.getFallbackLangs();
      const namespaces = getDefaultAndFallbackNs(ns2 !== null && ns2 !== void 0 ? ns2 : void 0);
      return cache2.getTranslationNs(namespaces, languages, key);
    }
    function getTranslation({ key, ns: ns2, language: language2 }) {
      const namespaces = getDefaultAndFallbackNs(ns2 !== null && ns2 !== void 0 ? ns2 : void 0);
      const languages = state.getFallbackLangs(language2);
      return cache2.getTranslationFallback(namespaces, languages, key);
    }
    function loadInitial() {
      const data = valueOrPromise(initializeLanguage(), () => {
        const missingDescriptors = getMissingDescriptors();
        if (missingDescriptors.length && state.getInitialOptions().autoLoadRequiredData) {
          return cache2.loadRecords(missingDescriptors, { useCache: true });
        }
      });
      if (isPromise(data)) {
        state.setInitialLoading(true);
        fetchingObserver.notify();
        loadingObserver.notify();
        return Promise.resolve(data).then(() => {
          state.setInitialLoading(false);
          fetchingObserver.notify();
          loadingObserver.notify();
          events.onInitialLoaded.emit();
        });
      } else {
        events.onInitialLoaded.emit();
      }
    }
    function initializeLanguage() {
      const existingLanguage = state.getLanguage();
      if (existingLanguage) {
        return;
      }
      const languageOrPromise = pluginService.getInitialLanguage();
      return valueOrPromise(languageOrPromise, (lang) => {
        const language2 = lang || state.getInitialOptions().defaultLanguage;
        language2 && state.setLanguage(language2);
      });
    }
    function checkCorrectConfiguration() {
      const languageComputable = pluginService.getLanguageDetector() || pluginService.getLanguageStorage();
      if (languageComputable) {
        const availableLanguages = state.getAvailableLanguages();
        if (!availableLanguages) {
          throw new Error(missingOptionError("availableLanguages"));
        }
      }
      if (!state.getLanguage() && !state.getInitialOptions().defaultLanguage) {
        throw new Error(missingOptionError(["defaultLanguage", "language"]));
      }
    }
    const self2 = Object.freeze(Object.assign(Object.assign(Object.assign(Object.assign(Object.assign({}, events), state), pluginService), cache2), {
      init,
      getTranslation,
      changeTranslation,
      getTranslationNs,
      getDefaultAndFallbackNs,
      findPositions: pluginService.findPositions,
      getRequiredDescriptors,
      async changeLanguage(language2) {
        if (state.getPendingLanguage() === language2 && state.getLanguage() === language2) {
          return;
        }
        state.setPendingLanguage(language2);
        if (state.isRunning() && state.getInitialOptions().autoLoadRequiredData) {
          await cache2.loadRecords(getRequiredDescriptors(language2), {
            useCache: true
          });
        }
        if (language2 === state.getPendingLanguage()) {
          state.setLanguage(language2);
          await pluginService.setStoredLanguage(language2);
        }
      },
      async addActiveNs(ns2, forget) {
        if (!forget) {
          state.addActiveNs(ns2);
        }
        if (state.isRunning()) {
          await cache2.loadRecords(getRequiredDescriptors(void 0, ns2), {
            useCache: true
          });
        }
      },
      async loadRecord(descriptor, options2) {
        var _a3;
        return (_a3 = (await self2.loadRecords([descriptor], options2))[0]) === null || _a3 === void 0 ? void 0 : _a3.data;
      },
      isLoading(ns2) {
        return cache2.isLoading(state.getLanguage(), ns2);
      },
      isLoaded(ns2) {
        const language2 = state.getLanguage();
        if (!language2) {
          return false;
        }
        const languages = state.getFallbackLangs(language2);
        const namespaces = getRequiredNamespaces(ns2);
        const result = [];
        languages.forEach((language3) => {
          namespaces.forEach((namespace) => {
            if (!cache2.exists({ language: language3, namespace })) {
              result.push({ language: language3, namespace });
            }
          });
        });
        return result.length === 0;
      },
      t: (...args) => {
        const params = getTranslateProps(...args);
        const translation = getTranslation(params);
        return pluginService.formatTranslation(Object.assign(Object.assign({}, params), { translation }));
      },
      isDev() {
        return Boolean(state.getInitialOptions().apiKey && state.getInitialOptions().apiUrl);
      },
      async loadRequired(options2) {
        if (!(options2 === null || options2 === void 0 ? void 0 : options2.language)) {
          await initializeLanguage();
        }
        const requiredRecords = getRequiredDescriptors(options2 === null || options2 === void 0 ? void 0 : options2.language);
        return self2.loadRecords(requiredRecords, options2);
      },
      async loadMatrix(options2) {
        const records = getMatrixRecords(options2);
        return self2.loadRecords(records, options2);
      },
      run() {
        checkCorrectConfiguration();
        if (!state.isRunning()) {
          state.setRunning(true);
          pluginService.run();
          runPromise = loadInitial();
        }
        return Promise.resolve(runPromise);
      },
      stop() {
        if (state.isRunning()) {
          pluginService.stop();
          state.setRunning(false);
        }
      }
    }));
    return self2;
  }
  function createTolgee(options) {
    const controller = Controller({
      options
    });
    if (controller.isDev()) {
      controller.invalidate();
    }
    function withRestart(callback) {
      const wasRunning = controller.isRunning();
      wasRunning && controller.stop();
      callback();
      controller.isDev() && controller.invalidate();
      wasRunning && controller.run();
    }
    const self2 = Object.freeze({
      /**
       * Listen to tolgee events.
       */
      on: controller.on,
      /**
       * Turn off/on events emitting. Is on by default.
       */
      setEmitterActive: controller.setEmitterActive,
      /**
       * @return current language if set.
       */
      getLanguage: controller.getLanguage,
      /**
       * `pendingLanguage` represents language which is currently being loaded.
       * @return current `pendingLanguage` if set.
       */
      getPendingLanguage: controller.getPendingLanguage,
      /**
       * Change current language.
       * - if not running sets `pendingLanguage`, `language` to the new value
       * - if running sets `pendingLanguage` to the value, fetches necessary data and then changes `language`
       *
       * @return Promise which is resolved when `language` is changed.
       */
      changeLanguage: controller.changeLanguage,
      /**
       * Temporarily change translation in cache.
       * @return object with revert method.
       */
      changeTranslation: controller.changeTranslation,
      /**
       * Adds namespace(s) list of active namespaces. And if tolgee is running, loads required data.
       */
      addActiveNs: controller.addActiveNs,
      /**
       * Remove namespace(s) from active namespaces.
       *
       * Tolgee internally counts how many times was each active namespace added,
       * so this method will remove namespace only if the counter goes down to 0.
       */
      removeActiveNs: controller.removeActiveNs,
      /**
       * Load records which would be loaded by `run` function
       *
       * You can provide language if not previously set on tolgee instance
       */
      loadRequired: controller.loadRequired,
      /**
       * Load records in matrix (languages x namespaces)
       */
      loadMatrix: controller.loadMatrix,
      /**
       * Manually load multiple records from `Backend` (or `DevBackend` when in dev mode)
       *
       * It loads data together and adds them to cache in one operation, to prevent partly loaded state.
       */
      loadRecords: controller.loadRecords,
      /**
       * Manually load record from `Backend` (or `DevBackend` when in dev mode)
       */
      loadRecord: controller.loadRecord,
      /**
       * Prefill static data
       */
      addStaticData: controller.addStaticData,
      /**
       * Get record from cache.
       */
      getRecord: controller.getRecord,
      /**
       * Get all records from cache.
       */
      getAllRecords: controller.getAllRecords,
      /**
       * @param ns optional list of namespaces that you are interested in
       * @return `true` if there are data that need to be fetched.
       */
      isLoaded: controller.isLoaded,
      /**
       * Returns descriptors of records needed for instance to be `loaded`
       */
      getRequiredDescriptors: controller.getRequiredDescriptors,
      /**
       * @return `true` if tolgee is loading initial data (triggered by `run`).
       */
      isInitialLoading: controller.isInitialLoading,
      /**
       * @param ns optional list of namespaces that you are interested in
       * @return `true` if tolgee is loading some translations for the first time.
       */
      isLoading: controller.isLoading,
      /**
       * @param ns optional list of namespaces that you are interested in
       * @return `true` if tolgee is fetching some translations.
       */
      isFetching: controller.isFetching,
      /**
       * @return `true` if tolgee is running.
       */
      isRunning: controller.isRunning,
      /**
       * Changes internal state to running: true and loads initial files.
       * Runs runnable plugins mainly Observer if present.
       */
      run: controller.run,
      /**
       * Changes internal state to running: false and stops runnable plugins.
       */
      stop: controller.stop,
      /**
       * Returns translated and formatted key.
       * If Observer is present and tolgee is running, wraps result to be identifiable in the DOM.
       */
      t: controller.t,
      /**
       * Highlight keys that match selection.
       */
      highlight: controller.highlight,
      /**
       * Find positions of keys in the DOM.
       */
      findPositions: controller.findPositions,
      /**
       * @return current Tolgee options.
       */
      getInitialOptions: controller.getInitialOptions,
      /**
       * Tolgee is in dev mode if `DevTools` plugin is used and `apiKey` + `apiUrl` are specified.
       * @return `true` if tolgee is in dev mode.
       */
      isDev: controller.isDev,
      /**
       * Wraps translation if there is `Observer` plugin
       */
      wrap: controller.wrap,
      /**
       * Unwrap translation
       */
      unwrap: controller.unwrap,
      /**
       * Override creadentials passed on initialization.
       *
       * When called in running state, tolgee stops and runs again.
       */
      overrideCredentials(credentials) {
        withRestart(() => controller.overrideCredentials(credentials));
      },
      /**
       * Add tolgee plugin after initialization.
       *
       * When called in running state, tolgee stops and runs again.
       */
      addPlugin(plugin) {
        if (plugin) {
          withRestart(() => controller.addPlugin(self2, plugin));
        }
      },
      /**
       * Updates options after instance creation. Extends existing options,
       * so it only changes the fields, that are listed.
       *
       * When called in running state, tolgee stops and runs again.
       */
      updateOptions(options2) {
        if (options2) {
          withRestart(() => controller.init(options2));
        }
      }
    });
    return self2;
  }
  const TolgeeCore = () => {
    const state = {
      plugins: [],
      options: {}
    };
    const tolgeeChain = Object.freeze({
      use(plugin) {
        state.plugins.push(plugin);
        return tolgeeChain;
      },
      updateDefaults(options) {
        state.options = combineOptions(state.options, options);
        return tolgeeChain;
      },
      init(options) {
        const tolgee = createTolgee(combineOptions(state.options, options));
        state.plugins.forEach(tolgee.addPlugin);
        return tolgee;
      }
    });
    return tolgeeChain;
  };
  const ERROR_PARAM_EMPTY = 0, ERROR_UNEXPECTED_CHAR = 1, ERROR_UNEXPECTED_END = 2;
  class FormatError extends Error {
    constructor(code2, index, text) {
      let error;
      let hint = "";
      if (code2 === ERROR_PARAM_EMPTY) {
        error = "Empty parameter";
      } else if (code2 === ERROR_UNEXPECTED_CHAR) {
        error = "Unexpected character";
        hint = "Did you forget to use FormatIcu to render ICU message syntax?";
      } else {
        error = "Unexpected end";
      }
      super(`Tolgee parser: ${error} at ${index} in "${text}"` + (hint ? "\n" + hint : ""));
      this.code = code2;
      this.index = index;
    }
  }
  function isWhitespace(ch) {
    return /\s/.test(ch);
  }
  const STATE_TEXT = 0, STATE_ESCAPE_MAYBE = 1, STATE_ESCAPE = 2, STATE_PARAM = 3, STATE_PARAM_AFTER = 4;
  const END_STATES = /* @__PURE__ */ new Set([
    STATE_ESCAPE,
    STATE_ESCAPE_MAYBE,
    STATE_TEXT
  ]);
  const CHAR_ESCAPE = "'";
  const ESCAPABLE = /* @__PURE__ */ new Set(["{", "}", CHAR_ESCAPE]);
  const isAllowedInParam = (char2) => {
    return /[0-9a-zA-Z_]/.test(char2);
  };
  function formatParser(translation) {
    let state = STATE_TEXT;
    let text = "";
    let param = "";
    let ch = "";
    const texts = [];
    const params = [];
    let i2 = 0;
    function parsingError(code2) {
      throw new FormatError(code2, i2, translation);
    }
    const addText = () => {
      texts.push(text);
      text = "";
    };
    const addParamChar = () => {
      if (!isAllowedInParam(ch)) {
        parsingError(ERROR_UNEXPECTED_CHAR);
      }
      param += ch;
    };
    const addParam = () => {
      if (param === "") {
        parsingError(ERROR_PARAM_EMPTY);
      }
      params.push(param);
      param = "";
    };
    for (i2 = 0; i2 < translation.length; i2++) {
      ch = translation[i2];
      switch (state) {
        case STATE_TEXT:
          if (ch === CHAR_ESCAPE) {
            text += ch;
            state = STATE_ESCAPE_MAYBE;
          } else if (ch === "{") {
            addText();
            state = STATE_PARAM;
          } else {
            text += ch;
            state = STATE_TEXT;
          }
          break;
        case STATE_ESCAPE_MAYBE:
          if (ESCAPABLE.has(ch)) {
            text = text.slice(0, -1) + ch;
            state = STATE_ESCAPE;
          } else {
            text += ch;
            state = STATE_TEXT;
          }
          break;
        case STATE_ESCAPE:
          if (ch === CHAR_ESCAPE) {
            state = STATE_TEXT;
          } else {
            text += ch;
            state = STATE_ESCAPE;
          }
          break;
        case STATE_PARAM:
          if (ch === "}") {
            addParam();
            state = STATE_TEXT;
          } else if (!isWhitespace(ch)) {
            addParamChar();
            state = STATE_PARAM;
          } else if (param !== "") {
            addParam();
            state = STATE_PARAM_AFTER;
          }
          break;
        case STATE_PARAM_AFTER:
          if (ch == "}") {
            state = STATE_TEXT;
          } else if (isWhitespace(ch)) {
            state = STATE_PARAM_AFTER;
          } else {
            parsingError(ERROR_UNEXPECTED_CHAR);
          }
      }
    }
    if (!END_STATES.has(state)) {
      parsingError(ERROR_UNEXPECTED_END);
    }
    addText();
    return [texts, params];
  }
  function formatter(translation, params) {
    const [texts, pars] = formatParser(translation);
    const result = [texts[0]];
    for (let i2 = 1; i2 < texts.length; i2++) {
      const parameter = params === null || params === void 0 ? void 0 : params[pars[i2 - 1]];
      if (parameter === void 0) {
        throw new Error(`Missing parameter "${pars[i2 - 1]}" in "${translation}"`);
      }
      result.push(String(parameter));
      result.push(texts[i2]);
    }
    return result.join("");
  }
  function createFormatSimple() {
    return {
      format: ({ translation, params }) => formatter(translation, params)
    };
  }
  const FormatSimple = () => (tolgee, tools) => {
    tools.setFinalFormatter(createFormatSimple());
    return tolgee;
  };
  const DEVTOOLS_ID = "__tolgee_dev_tools";
  const DEVTOOLS_Z_INDEX = 2147483e3;
  const CHROME_EXTENSION_LINK = "https://chrome.google.com/webstore/detail/tolgee-tools/hacnbapajkkfohnonhbmegojnddagfnj";
  const PREFERRED_LANGUAGES_LOCAL_STORAGE_KEY = "__tolgee_preferredLanguages";
  const MAX_LANGUAGES_SELECTED = 5;
  const TOLGEE_WRAPPED_ONLY_DATA_ATTRIBUTE = "data-tolgee-key-only";
  const TOLGEE_RESTRICT_ATTRIBUTE = "data-tolgee-restricted";
  const TOLGEE_ATTRIBUTE_NAME = "_tolgee";
  const TOLGEE_HIGHLIGHTER_CLASS = "_tolgee-highlighter";
  function isSSR$1() {
    var _a3, _b;
    return typeof ((_b = (_a3 = globalThis.window) == null ? void 0 : _a3.document) == null ? void 0 : _b.createElement) === "undefined";
  }
  function throwIfSSR(origin) {
    if (isSSR$1()) {
      throw new Error(`${origin}: Can't run on the server`);
    }
  }
  function DomHelper(options) {
    function getParentElement(node2) {
      if (node2.parentElement) {
        return node2.parentElement;
      }
      if (node2.ownerElement) {
        return node2.ownerElement || void 0;
      }
    }
    const self2 = Object.freeze({
      getSuitableParent(node2) {
        const domParent = getParentElement(node2);
        if (domParent === void 0) {
          console.error(node2);
          throw new Error("No suitable parent found for node above.");
        }
        if (!options.passToParent) {
          return domParent;
        }
        if (Array.isArray(options.passToParent)) {
          const tagNameEquals = (elementTagName) => domParent.tagName.toLowerCase() === elementTagName.toLowerCase();
          if (options.passToParent.findIndex(tagNameEquals) === -1) {
            return domParent;
          }
        }
        if (typeof options.passToParent === "function") {
          if (!options.passToParent(domParent)) {
            return domParent;
          }
        }
        return self2.getSuitableParent(domParent);
      }
    });
    return self2;
  }
  function initElementMeta(element) {
    return {
      element,
      nodes: /* @__PURE__ */ new Map()
    };
  }
  function initNodeMeta(oldTextContent, keys) {
    return {
      oldTextContent,
      keys
    };
  }
  function getNodeText(node2) {
    return node2.textContent;
  }
  function setNodeText(node2, text) {
    node2.textContent = text;
  }
  function compareDescriptors(descriptor, criteria) {
    var _a3;
    const keyMatches = descriptor.key === void 0 || criteria.key === void 0 || criteria.key === descriptor.key;
    const nsMatches = descriptor.ns === void 0 || criteria.ns === void 0 || ((_a3 = descriptor.ns) == null ? void 0 : _a3.findIndex((ns2) => {
      var _a4;
      return (_a4 = criteria.ns) == null ? void 0 : _a4.includes(ns2);
    })) !== -1;
    return keyMatches && nsMatches;
  }
  function elementClickable(el) {
    while (el) {
      if (el.getAttribute("disabled") !== null) {
        return false;
      }
      el = el.parentElement;
    }
    return true;
  }
  const HIGHLIGHTER_BASE_STYLE = {
    position: "fixed",
    boxSizing: "content-box",
    zIndex: String(Number.MAX_SAFE_INTEGER),
    contain: "layout",
    display: "block",
    borderStyle: "solid",
    borderRadius: "4px"
  };
  function ElementHighlighter({ highlightColor, highlightWidth }) {
    function initHighlightFunction(element, elementMeta) {
      elementMeta.highlight = () => {
        if (!element.isConnected) {
          return;
        }
        const clickable = elementClickable(element);
        let highlightEl = elementMeta.highlightEl;
        if (!highlightEl) {
          highlightEl = document.createElement("div");
          highlightEl.classList.add(TOLGEE_HIGHLIGHTER_CLASS);
          Object.entries(HIGHLIGHTER_BASE_STYLE).forEach(([key, value]) => {
            highlightEl.style[key] = value;
          });
          highlightEl.style.borderColor = highlightColor;
          elementMeta.highlightEl = highlightEl;
          document.body.appendChild(highlightEl);
        }
        const shape2 = element.getBoundingClientRect();
        highlightEl.style.pointerEvents = clickable ? "none" : "auto";
        highlightEl.style.borderWidth = highlightWidth + "px";
        highlightEl.style.top = shape2.top - highlightWidth + "px";
        highlightEl.style.left = shape2.left - highlightWidth + "px";
        highlightEl.style.width = shape2.width + "px";
        highlightEl.style.height = shape2.height + "px";
      };
    }
    function initUnhighlightFunction(element, elementMeta) {
      elementMeta.unhighlight = () => {
        var _a3;
        (_a3 = elementMeta.highlightEl) == null ? void 0 : _a3.remove();
        elementMeta.highlightEl = void 0;
      };
    }
    return Object.freeze({
      initHighlighter(element, elementMeta) {
        initHighlightFunction(element, elementMeta);
        initUnhighlightFunction(element, elementMeta);
      }
    });
  }
  const eCapture = {
    capture: true
  };
  const ePassive = {
    capture: true,
    passive: true
  };
  const MODIFIER_MAP = /* @__PURE__ */ new Map([
    ["Control", "ctrlKey"],
    ["Alt", "altKey"],
    ["Meta", "metaKey"],
    ["Shift", "shiftKey"]
  ]);
  function MouseEventHandler({
    highlightKeys,
    elementStore,
    onClick,
    options
  }) {
    var _a3, _b;
    const keysDown = /* @__PURE__ */ new Set();
    let highlighted;
    let cursorPosition2;
    let subscribedEvents = [];
    const documentOrShadowRoot = ((_a3 = options.targetElement) == null ? void 0 : _a3.getRootNode()) || document;
    const targetDocument = ((_b = options.targetElement) == null ? void 0 : _b.ownerDocument) || document;
    function highlight(el) {
      var _a4;
      if (highlighted !== el) {
        unhighlight();
        const meta2 = elementStore.get(el);
        if (meta2) {
          meta2.preventClean = true;
          (_a4 = meta2.highlight) == null ? void 0 : _a4.call(meta2);
          highlighted = el;
        }
      }
    }
    function unhighlight() {
      var _a4;
      const meta2 = elementStore.get(highlighted);
      if (meta2) {
        meta2.preventClean = false;
        (_a4 = meta2.unhighlight) == null ? void 0 : _a4.call(meta2);
        highlighted = void 0;
      }
    }
    function updateHighlight() {
      const position2 = cursorPosition2;
      let newHighlighted;
      if (position2 && areKeysDown()) {
        const elements = documentOrShadowRoot.elementsFromPoint(position2.x, position2.y) || [];
        newHighlighted = getClosestTolgeeElement(elements);
      }
      highlight(newHighlighted);
    }
    function updateCursorPosition(position2) {
      cursorPosition2 = position2;
      updateHighlight();
    }
    function updateModifiers(e) {
      for (const [modifier, modifierProperty] of MODIFIER_MAP.entries()) {
        if (keysDown.has(modifier) && !e[modifierProperty]) {
          keysDown.delete(modifier);
        } else if (!keysDown.has(modifier) && e[modifierProperty]) {
          keysDown.add(modifier);
        }
      }
    }
    function blockEvents(e) {
      updateModifiers(e);
      if (areKeysDown() && !isInUiDialog(e.target)) {
        e.stopPropagation();
        e.preventDefault();
      }
    }
    function onMouseMove(e) {
      updateModifiers(e);
      updateCursorPosition({ x: e.clientX, y: e.clientY });
    }
    function onKeyDown(e) {
      updateModifiers(e);
      updateHighlight();
    }
    function onKeyUp(e) {
      updateModifiers(e);
      updateHighlight();
    }
    function onScroll() {
      var _a4;
      const meta2 = elementStore.get(highlighted);
      (_a4 = meta2 == null ? void 0 : meta2.highlight) == null ? void 0 : _a4.call(meta2);
    }
    function handleClick(e) {
      blockEvents(e);
      updateModifiers(e);
      updateCursorPosition({ x: e.clientX, y: e.clientY });
      if (areKeysDown() && highlighted) {
        onClick(highlighted);
        unhighlight();
      }
    }
    function subscribe(type, listener, options2) {
      targetDocument.addEventListener(type, listener, options2);
      subscribedEvents.push([type, listener, options2]);
    }
    function initEventListeners() {
      subscribe("keydown", onKeyDown, eCapture);
      subscribe("keyup", onKeyUp, eCapture);
      subscribe("mousemove", onMouseMove, ePassive);
      subscribe("scroll", onScroll, ePassive);
      subscribe("click", handleClick, eCapture);
      subscribe("mouseenter", blockEvents, eCapture);
      subscribe("mouseover", blockEvents, eCapture);
      subscribe("mouseout", blockEvents, eCapture);
      subscribe("mouseleave", blockEvents, eCapture);
      subscribe("mousedown", blockEvents, eCapture);
      subscribe("mouseup", blockEvents, eCapture);
    }
    function removeEventListeners() {
      for (const params of subscribedEvents) {
        targetDocument.removeEventListener(...params);
      }
      subscribedEvents = [];
    }
    function isInUiDialog(element) {
      return Boolean(findAncestor(element, (el) => el.id === DEVTOOLS_ID));
    }
    function getClosestTolgeeElement(elements) {
      for (const element of elements) {
        const result = findAncestor(
          element,
          (el) => elementStore.get(el)
        );
        if (result !== void 0) {
          return result || void 0;
        }
      }
    }
    function findAncestor(element, func) {
      if (element.id === DEVTOOLS_ID) {
        return null;
      }
      if (func(element)) {
        return element;
      }
      if (element == null ? void 0 : element.parentElement) {
        return findAncestor(element.parentElement, func);
      }
      return void 0;
    }
    function areKeysDown() {
      for (const key of highlightKeys) {
        if (!keysDown.has(key)) {
          return false;
        }
      }
      return true;
    }
    return Object.freeze({
      stop() {
        removeEventListeners();
      },
      run() {
        initEventListeners();
      }
    });
  }
  function ElementRegistry(options, elementStore, onClick) {
    const elementHighlighter = ElementHighlighter({
      highlightColor: options.highlightColor,
      highlightWidth: options.highlightWidth
    });
    const eventHandler = MouseEventHandler({
      highlightKeys: options.highlightKeys,
      elementStore,
      onClick(el) {
        const meta2 = elementStore.get(el);
        onClick({
          target: el,
          keysAndDefaults: getKeysAndDefaults(meta2)
        });
      },
      options
    });
    function isRestricted(element) {
      const restrictedElements = options.restrictedElements;
      return restrictedElements.indexOf(element.tagName.toLowerCase()) !== -1 || element.closest(`[${TOLGEE_RESTRICT_ATTRIBUTE}]`) !== null;
    }
    function cleanElementInactiveNodes(meta2, removedNodes) {
      for (const [key] of meta2.nodes) {
        if (removedNodes.has(key)) {
          meta2.nodes.delete(key);
        }
      }
    }
    function cleanElement(element, meta2) {
      var _a3;
      if (meta2.highlightEl) {
        (_a3 = meta2.unhighlight) == null ? void 0 : _a3.call(meta2);
      }
      element.removeAttribute(TOLGEE_ATTRIBUTE_NAME);
      elementStore.remove(element);
    }
    function getKeyOptions(meta2) {
      const nodes = Array.from(meta2.nodes.values());
      return nodes.reduce(
        (acc, curr) => [
          ...acc,
          ...curr.keys.map((k) => ({
            key: k.key,
            defaultValue: k.defaultValue,
            ns: k.ns
          }))
        ],
        []
      );
    }
    function getKeysAndDefaults(meta2) {
      return getKeyOptions(meta2);
    }
    return Object.freeze({
      isRestricted,
      register(element, node2, nodeMeta) {
        if (isRestricted(element)) {
          return;
        }
        const tolgeeElement = element;
        let elementMeta = elementStore.get(tolgeeElement);
        if (!elementMeta) {
          elementMeta = initElementMeta(tolgeeElement);
          elementStore.set(tolgeeElement, elementMeta);
          tolgeeElement.setAttribute(TOLGEE_ATTRIBUTE_NAME, "true");
        }
        elementMeta.nodes.set(node2, nodeMeta);
        elementHighlighter.initHighlighter(tolgeeElement, elementMeta);
      },
      forEachElement: elementStore.forEachElement,
      cleanupLingeringKeyAttributes() {
        elementStore.forEachElement((element, meta2) => {
          if (meta2.preventClean) {
            return;
          }
          for (const [node2] of meta2.nodes) {
            if (node2.nodeType === Node.ATTRIBUTE_NODE) {
              const attr = node2;
              if (attr.name === TOLGEE_WRAPPED_ONLY_DATA_ATTRIBUTE && attr.ownerElement === null) {
                meta2.nodes.delete(attr);
              }
            }
          }
          if (meta2.nodes.size === 0) {
            cleanElement(element, meta2);
          }
        });
      },
      cleanupRemovedNodes(removedNodes) {
        elementStore.forEachElement((element, meta2) => {
          if (meta2.preventClean) {
            return;
          }
          if (!removedNodes.has(element)) {
            cleanElementInactiveNodes(meta2, removedNodes);
          }
          if (removedNodes.has(element) || meta2.nodes.size === 0) {
            cleanElement(element, meta2);
          }
        });
      },
      findAll(key, ns2) {
        const result = [];
        elementStore.forEachElement((_2, meta2) => {
          for (const nodeMeta of meta2.nodes.values()) {
            const fits = nodeMeta.keys.find(
              (val) => compareDescriptors(
                { key, ns: getFallback(ns2) },
                { key: val.key, ns: getFallback(val.ns) }
              )
            );
            if (fits) {
              result.push(meta2);
              break;
            }
          }
        });
        return result;
      },
      run(mouseHighlight) {
        if (mouseHighlight) {
          eventHandler.run();
        }
      },
      stop() {
        eventHandler.stop();
        elementStore.forEachElement((_2, meta2) => {
          var _a3;
          if (meta2.highlightEl) {
            (_a3 = meta2.unhighlight) == null ? void 0 : _a3.call(meta2);
          }
        });
      }
    });
  }
  function ElementStore() {
    const registredElements = /* @__PURE__ */ new Map();
    return Object.freeze({
      set(el, meta2) {
        registredElements.set(el, meta2);
      },
      get(el) {
        return el && registredElements.get(el);
      },
      remove(el) {
        return registredElements.delete(el);
      },
      forEachElement(callback) {
        registredElements.forEach((value, key) => callback(key, value));
      }
    });
  }
  function NodeHandler(options, wrapper) {
    const self2 = Object.freeze({
      handleAttributes(node2, includeChild = true) {
        var _a3, _b;
        const result = [];
        const tagAttributes = Object.fromEntries(
          Object.entries(options.tagAttributes).map(([tag, attributes]) => [
            tag.toUpperCase(),
            attributes
          ])
        );
        if (node2.nodeType === Node.ELEMENT_NODE) {
          const element = node2;
          let attributes = (_a3 = tagAttributes[element.tagName.toUpperCase()]) != null ? _a3 : [];
          if ("*" in tagAttributes) {
            attributes = attributes.concat(tagAttributes["*"]);
          }
          result.push(
            ...attributes.filter((attrName) => element.hasAttribute(attrName)).map((attrName) => element.getAttributeNode(attrName)).filter(
              (attrNode) => wrapper.testAttribute(attrNode)
            )
          );
        }
        if (includeChild) {
          const walker = document.createTreeWalker(
            node2,
            NodeFilter.SHOW_ELEMENT,
            (f) => {
              var _a4, _b2;
              return ((_a4 = tagAttributes[f.tagName.toUpperCase()]) == null ? void 0 : _a4.some(
                (t2) => f.hasAttribute(t2)
              )) || ((_b2 = tagAttributes["*"]) == null ? void 0 : _b2.some((t2) => f.hasAttribute(t2))) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
            }
          );
          while (walker.nextNode()) {
            const element = walker.currentNode;
            let attributes = (_b = tagAttributes[element.tagName.toUpperCase()]) != null ? _b : [];
            if ("*" in tagAttributes) {
              attributes = attributes.concat(tagAttributes["*"]);
            }
            result.push(
              ...attributes.filter((attrName) => element.hasAttribute(attrName)).map((attrName) => element.getAttributeNode(attrName)).filter(
                (attrNode) => wrapper.testAttribute(attrNode)
              )
            );
          }
        }
        return result;
      },
      handleChildList(node2) {
        const result = [];
        result.push(...node2.flatMap((n) => self2.handleAttributes(n, true)));
        result.push(...node2.flatMap((n) => self2.handleText(n)));
        return result;
      },
      handleText(node2) {
        if (node2.nodeType === Node.TEXT_NODE) {
          return wrapper.testTextNode(node2) ? [node2] : [];
        }
        const nodes = [];
        const walker = document.createTreeWalker(
          node2,
          NodeFilter.SHOW_TEXT,
          (f) => wrapper.testTextNode(f) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP
        );
        while (walker.nextNode()) {
          nodes.push(walker.currentNode);
        }
        return nodes;
      }
    });
    return self2;
  }
  function GeneralObserver() {
    let isObserving = false;
    let instance;
    const elementStore = ElementStore();
    function createRunningInstance({
      mouseHighlight,
      options,
      wrapper,
      onClick
    }) {
      if (isSSR$1()) {
        return {
          stop() {
            isObserving = false;
          },
          wrapper
        };
      }
      const domHelper = DomHelper(options);
      const nodeHandler = NodeHandler(options, wrapper);
      const elementRegistry = ElementRegistry(options, elementStore, onClick);
      function handleNodes(nodes) {
        for (const textNode of nodes) {
          const parent = textNode.parentElement;
          if (parent && elementRegistry.isRestricted(parent)) {
            continue;
          }
          const oldTextContent = getNodeText(textNode);
          const result = oldTextContent ? wrapper.unwrap(oldTextContent) : null;
          if (result) {
            const { text, keys } = result;
            setNodeText(textNode, text);
            const nodeMeta = initNodeMeta(oldTextContent, keys);
            const parentElement = domHelper.getSuitableParent(textNode);
            elementRegistry.register(parentElement, textNode, nodeMeta);
          }
        }
      }
      function handleKeyAttributeAttr(attr) {
        const parentElement = domHelper.getSuitableParent(attr);
        elementRegistry.register(parentElement, attr, {
          oldTextContent: "",
          keys: [{ key: getNodeText(attr) }],
          keyAttributeOnly: true
        });
      }
      function handleKeyAttribute(node2, includeChild) {
        if (node2.nodeType === Node.ATTRIBUTE_NODE) {
          const attr = node2;
          if (attr.name === TOLGEE_WRAPPED_ONLY_DATA_ATTRIBUTE) {
            handleKeyAttributeAttr(attr);
            return;
          }
        }
        if (node2.nodeType === Node.ELEMENT_NODE) {
          const element = node2;
          const attr = element.getAttributeNode(
            TOLGEE_WRAPPED_ONLY_DATA_ATTRIBUTE
          );
          if (attr) {
            handleKeyAttributeAttr(attr);
          }
        }
        if (!includeChild) {
          return;
        }
        const walker = document.createTreeWalker(
          node2,
          NodeFilter.SHOW_ELEMENT,
          (e) => e.hasAttribute(TOLGEE_WRAPPED_ONLY_DATA_ATTRIBUTE) ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP
        );
        while (walker.nextNode()) {
          const attr = walker.currentNode.getAttributeNode(
            TOLGEE_WRAPPED_ONLY_DATA_ATTRIBUTE
          );
          handleKeyAttributeAttr(attr);
        }
      }
      const observer = new MutationObserver((mutationsList) => {
        if (!isObserving) {
          return;
        }
        const removedNodes = mutationsList.filter((m2) => m2.type === "childList").flatMap((m2) => Array.from(m2.removedNodes));
        const removedNodesSet = new Set(removedNodes);
        for (const node2 of removedNodes) {
          if (node2.nodeType === Node.ELEMENT_NODE) {
            for (let i2 = 0; i2 < node2.attributes.length; i2++) {
              removedNodesSet.add(node2.attributes[i2]);
            }
          }
          const treeWalker = document.createTreeWalker(
            node2,
            NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_TEXT
          );
          while (treeWalker.nextNode()) {
            const currentNode = treeWalker.currentNode;
            if (currentNode.nodeType === Node.ELEMENT_NODE) {
              const element = currentNode;
              for (let i2 = 0; i2 < element.attributes.length; i2++) {
                removedNodesSet.add(element.attributes[i2]);
              }
            }
            removedNodesSet.add(currentNode);
          }
        }
        if (removedNodesSet.size > 0) {
          elementRegistry.cleanupRemovedNodes(removedNodesSet);
        }
        if (mutationsList.some(
          (m2) => m2.type === "attributes" && m2.attributeName === TOLGEE_WRAPPED_ONLY_DATA_ATTRIBUTE
        )) {
          elementRegistry.cleanupLingeringKeyAttributes();
        }
        const result = /* @__PURE__ */ new Set();
        for (const mutation of mutationsList) {
          switch (mutation.type) {
            case "characterData":
              nodeHandler.handleText(mutation.target).forEach((t2) => result.add(t2));
              break;
            case "childList":
              handleKeyAttribute(mutation.target, true);
              if (mutation.addedNodes.length > 0) {
                nodeHandler.handleChildList(Array.from(mutation.addedNodes)).forEach((t2) => result.add(t2));
              }
              if (mutation.removedNodes.length > 0) {
                nodeHandler.handleChildList(Array.from(mutation.removedNodes)).forEach((t2) => result.delete(t2));
              }
              break;
            case "attributes":
              if (mutation.attributeName === TOLGEE_WRAPPED_ONLY_DATA_ATTRIBUTE) {
                handleKeyAttribute(mutation.target, false);
              }
              nodeHandler.handleAttributes(mutation.target, false).forEach((t2) => result.add(t2));
              break;
          }
        }
        handleNodes([...result]);
      });
      const targetElement = options.targetElement || document;
      isObserving = true;
      elementRegistry.run(mouseHighlight);
      handleKeyAttribute(targetElement, true);
      handleNodes(nodeHandler.handleChildList([targetElement]));
      const monitorAttributeList = /* @__PURE__ */ new Set();
      monitorAttributeList.add(TOLGEE_WRAPPED_ONLY_DATA_ATTRIBUTE);
      Object.values(options.tagAttributes).forEach(
        (attrs) => attrs.forEach((attr) => monitorAttributeList.add(attr.toLowerCase()))
      );
      observer.observe(targetElement, {
        attributes: true,
        attributeFilter: [...monitorAttributeList],
        childList: true,
        subtree: true,
        characterData: true
      });
      return {
        stop() {
          isObserving = false;
          elementRegistry.stop();
          observer.disconnect();
        },
        elementRegistry,
        wrapper
      };
    }
    const self2 = Object.freeze({
      run(props) {
        instance = createRunningInstance(props);
      },
      stop() {
        instance == null ? void 0 : instance.stop();
      },
      forEachElement(callback) {
        var _a3, _b;
        (_b = (_a3 = instance == null ? void 0 : instance.elementRegistry) == null ? void 0 : _a3.forEachElement) == null ? void 0 : _b.call(_a3, callback);
      },
      highlight(key, ns2) {
        var _a3;
        const elements = ((_a3 = instance == null ? void 0 : instance.elementRegistry) == null ? void 0 : _a3.findAll(key, ns2)) || [];
        elements.forEach((el) => {
          var _a4;
          return (_a4 = el.highlight) == null ? void 0 : _a4.call(el);
        });
        return {
          unhighlight() {
            elements.forEach((el) => {
              var _a4;
              return (_a4 = el.unhighlight) == null ? void 0 : _a4.call(el);
            });
          }
        };
      },
      findPositions(key, ns2) {
        var _a3;
        const elements = ((_a3 = instance == null ? void 0 : instance.elementRegistry) == null ? void 0 : _a3.findAll(key, ns2)) || [];
        const result = [];
        elements.sort((a2, b) => {
          if (a2.element.compareDocumentPosition(b.element) & Node.DOCUMENT_POSITION_FOLLOWING) {
            return -1;
          } else {
            return 1;
          }
        });
        elements.forEach((meta2) => {
          const shape2 = meta2.element.getBoundingClientRect();
          meta2.nodes.forEach((node2) => {
            node2.keys.forEach((val) => {
              if (compareDescriptors(
                { key, ns: getFallback(ns2) },
                { key: val.key, ns: getFallback(val.ns) }
              ))
                result.push({
                  position: {
                    x: shape2.x,
                    y: shape2.y,
                    width: shape2.width,
                    height: shape2.height
                  },
                  keyName: val.key,
                  keyNamespace: val.ns || ""
                });
            });
          });
        });
        return result;
      },
      unwrap(text) {
        if (instance) {
          return instance.wrapper.unwrap(text);
        }
        return {
          text,
          keys: []
        };
      },
      wrap(props) {
        if (instance) {
          return instance.wrapper.wrap(props);
        }
        return props.translation || "";
      }
    });
    return self2;
  }
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  function getDefaultExportFromCjs(x2) {
    return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
  }
  function getAugmentedNamespace(n) {
    if (n.__esModule)
      return n;
    var f = n.default;
    if (typeof f == "function") {
      var a2 = function a3() {
        if (this instanceof a3) {
          return Reflect.construct(f, arguments, this.constructor);
        }
        return f.apply(this, arguments);
      };
      a2.prototype = f.prototype;
    } else
      a2 = {};
    Object.defineProperty(a2, "__esModule", { value: true });
    Object.keys(n).forEach(function(k) {
      var d = Object.getOwnPropertyDescriptor(n, k);
      Object.defineProperty(a2, k, d.get ? d : {
        enumerable: true,
        get: function() {
          return n[k];
        }
      });
    });
    return a2;
  }
  var text_min = {};
  (function(scope) {
    function B(r2, e) {
      var f;
      return r2 instanceof Buffer ? f = r2 : f = Buffer.from(r2.buffer, r2.byteOffset, r2.byteLength), f.toString(e);
    }
    var w = function(r2) {
      return Buffer.from(r2);
    };
    function h(r2) {
      for (var e = 0, f = Math.min(256 * 256, r2.length + 1), n = new Uint16Array(f), i2 = [], o2 = 0; ; ) {
        var t2 = e < r2.length;
        if (!t2 || o2 >= f - 1) {
          var s = n.subarray(0, o2), m2 = s;
          if (i2.push(String.fromCharCode.apply(null, m2)), !t2)
            return i2.join("");
          r2 = r2.subarray(e), e = 0, o2 = 0;
        }
        var a2 = r2[e++];
        if ((a2 & 128) === 0)
          n[o2++] = a2;
        else if ((a2 & 224) === 192) {
          var d = r2[e++] & 63;
          n[o2++] = (a2 & 31) << 6 | d;
        } else if ((a2 & 240) === 224) {
          var d = r2[e++] & 63, l = r2[e++] & 63;
          n[o2++] = (a2 & 31) << 12 | d << 6 | l;
        } else if ((a2 & 248) === 240) {
          var d = r2[e++] & 63, l = r2[e++] & 63, R = r2[e++] & 63, c2 = (a2 & 7) << 18 | d << 12 | l << 6 | R;
          c2 > 65535 && (c2 -= 65536, n[o2++] = c2 >>> 10 & 1023 | 55296, c2 = 56320 | c2 & 1023), n[o2++] = c2;
        }
      }
    }
    function F(r2) {
      for (var e = 0, f = r2.length, n = 0, i2 = Math.max(32, f + (f >>> 1) + 7), o2 = new Uint8Array(i2 >>> 3 << 3); e < f; ) {
        var t2 = r2.charCodeAt(e++);
        if (t2 >= 55296 && t2 <= 56319) {
          if (e < f) {
            var s = r2.charCodeAt(e);
            (s & 64512) === 56320 && (++e, t2 = ((t2 & 1023) << 10) + (s & 1023) + 65536);
          }
          if (t2 >= 55296 && t2 <= 56319)
            continue;
        }
        if (n + 4 > o2.length) {
          i2 += 8, i2 *= 1 + e / r2.length * 2, i2 = i2 >>> 3 << 3;
          var m2 = new Uint8Array(i2);
          m2.set(o2), o2 = m2;
        }
        if ((t2 & 4294967168) === 0) {
          o2[n++] = t2;
          continue;
        } else if ((t2 & 4294965248) === 0)
          o2[n++] = t2 >>> 6 & 31 | 192;
        else if ((t2 & 4294901760) === 0)
          o2[n++] = t2 >>> 12 & 15 | 224, o2[n++] = t2 >>> 6 & 63 | 128;
        else if ((t2 & 4292870144) === 0)
          o2[n++] = t2 >>> 18 & 7 | 240, o2[n++] = t2 >>> 12 & 63 | 128, o2[n++] = t2 >>> 6 & 63 | 128;
        else
          continue;
        o2[n++] = t2 & 63 | 128;
      }
      return o2.slice ? o2.slice(0, n) : o2.subarray(0, n);
    }
    var u = "Failed to ", p2 = function(r2, e, f) {
      if (r2)
        throw new Error("".concat(u).concat(e, ": the '").concat(f, "' option is unsupported."));
    };
    var x2 = typeof Buffer == "function" && Buffer.from;
    var A2 = x2 ? w : F;
    function v2() {
      this.encoding = "utf-8";
    }
    v2.prototype.encode = function(r2, e) {
      return p2(e && e.stream, "encode", "stream"), A2(r2);
    };
    function U2(r2) {
      var e;
      try {
        var f = new Blob([r2], { type: "text/plain;charset=UTF-8" });
        e = URL.createObjectURL(f);
        var n = new XMLHttpRequest();
        return n.open("GET", e, false), n.send(), n.responseText;
      } finally {
        e && URL.revokeObjectURL(e);
      }
    }
    var O = !x2 && typeof Blob == "function" && typeof URL == "function" && typeof URL.createObjectURL == "function", S = ["utf-8", "utf8", "unicode-1-1-utf-8"], T = h;
    x2 ? T = B : O && (T = function(r2) {
      try {
        return U2(r2);
      } catch (e) {
        return h(r2);
      }
    });
    var y = "construct 'TextDecoder'", E2 = "".concat(u, " ").concat(y, ": the ");
    function g(r2, e) {
      p2(e && e.fatal, y, "fatal"), r2 = r2 || "utf-8";
      var f;
      if (x2 ? f = Buffer.isEncoding(r2) : f = S.indexOf(r2.toLowerCase()) !== -1, !f)
        throw new RangeError("".concat(E2, " encoding label provided ('").concat(r2, "') is invalid."));
      this.encoding = r2, this.fatal = false, this.ignoreBOM = false;
    }
    g.prototype.decode = function(r2, e) {
      p2(e && e.stream, "decode", "stream");
      var f;
      return r2 instanceof Uint8Array ? f = r2 : r2.buffer instanceof ArrayBuffer ? f = new Uint8Array(r2.buffer) : f = new Uint8Array(r2), T(f, this.encoding);
    };
    scope.TextEncoder = scope.TextEncoder || v2;
    scope.TextDecoder = scope.TextDecoder || g;
  })(typeof window !== "undefined" ? window : typeof commonjsGlobal !== "undefined" ? commonjsGlobal : commonjsGlobal);
  const FastTextEncoding = /* @__PURE__ */ _mergeNamespaces({
    __proto__: null,
    default: text_min
  }, [text_min]);
  (_a2 = console.assert) == null ? void 0 : _a2.call(console, FastTextEncoding);
  const INVISIBLE_CHARACTERS = ["‌", "‍"];
  const INVISIBLE_REGEX = RegExp(
    `([${INVISIBLE_CHARACTERS.join("")}]{9})+`,
    "gu"
  );
  function toBytes(text) {
    return Array.from(new TextEncoder().encode(text));
  }
  function fromBytes(bytes) {
    return new TextDecoder().decode(new Uint8Array(bytes));
  }
  function padToWholeBytes(binary) {
    const needsToAdd = 8 - binary.length;
    return "0".repeat(needsToAdd) + binary;
  }
  function encodeMessage(text) {
    const bytes = toBytes(text).map(Number);
    const binary = bytes.map((byte) => padToWholeBytes(byte.toString(2)) + "0").join("");
    const result = Array.from(binary).map((b) => INVISIBLE_CHARACTERS[Number(b)]).join("");
    return result;
  }
  function decodeMessage(message) {
    const binary = Array.from(message).map((character2) => {
      return INVISIBLE_CHARACTERS.indexOf(character2);
    }).map(String).join("");
    const textBytes = binary.match(/(.{9})/g);
    const codes = Uint8Array.from(
      (textBytes == null ? void 0 : textBytes.map((byte) => parseInt(byte.slice(0, 8), 2))) || []
    );
    return fromBytes(codes);
  }
  function decodeFromText(text) {
    var _a3;
    const invisibleMessages = (_a3 = text.match(INVISIBLE_REGEX)) == null ? void 0 : _a3.filter((m2) => m2.length > 8);
    return (invisibleMessages == null ? void 0 : invisibleMessages.map(decodeMessage)) || [];
  }
  function removeSecrets(text) {
    return text.replace(INVISIBLE_REGEX, "");
  }
  function ValueMemory() {
    const values2 = [];
    return Object.freeze({
      valueToNumber(key) {
        let index = values2.indexOf(key);
        if (index === -1) {
          index = values2.length;
          values2.push(key);
        }
        return index;
      },
      numberToValue(num) {
        return values2[num];
      }
    });
  }
  const MESSAGE_END = "\n";
  function InvisibleWrapper({ fullKeyEncode }) {
    const keyMemory = ValueMemory();
    function encodeValue(data) {
      const value = {
        k: data.key,
        n: data.ns || void 0,
        d: data.defaultValue
      };
      return JSON.stringify(value);
    }
    function decodeValue(value) {
      try {
        return JSON.parse(value || "{}");
      } catch (e) {
        console.error(e);
        return void 0;
      }
    }
    function retrieveMessages(text) {
      return text.split(MESSAGE_END).filter((m2) => m2.length).map((message) => {
        if (message[0] === "{") {
          return message;
        } else {
          const valueCode = Number(message);
          return keyMemory.numberToValue(valueCode);
        }
      });
    }
    function encodeWithSeparator(message) {
      return encodeMessage(message + MESSAGE_END);
    }
    return Object.freeze({
      unwrap(text) {
        const keysAndParams = [];
        const texts = decodeFromText(text);
        texts.forEach((encodedValue) => {
          const messages = retrieveMessages(encodedValue);
          messages.forEach((message) => {
            const decodedVal = decodeValue(message);
            if (decodedVal) {
              const { k: key, d: defaultValue, n: ns2 } = decodedVal;
              keysAndParams.push({
                key,
                defaultValue,
                ns: ns2
              });
            }
          });
        });
        const result = removeSecrets(text);
        return { text: result, keys: keysAndParams };
      },
      wrap({ key, defaultValue, translation, ns: ns2 }) {
        let invisibleMark;
        if (fullKeyEncode) {
          const encodedValue = encodeValue({ key, ns: ns2 });
          invisibleMark = encodeWithSeparator(encodedValue);
        } else {
          const encodedValue = encodeValue({ key, ns: ns2, defaultValue });
          const code2 = keyMemory.valueToNumber(encodedValue);
          invisibleMark = encodeWithSeparator(String(code2));
        }
        const value = translation || "";
        return typeof value === "string" ? value + invisibleMark : value;
      },
      testTextNode(textNode) {
        var _a3, _b, _c;
        return (_c = ((_a3 = textNode.textContent) == null ? void 0 : _a3.includes(
          `${INVISIBLE_CHARACTERS[0]}${INVISIBLE_CHARACTERS[0]}`
        )) || ((_b = textNode.textContent) == null ? void 0 : _b.includes(
          `${INVISIBLE_CHARACTERS[1]}${INVISIBLE_CHARACTERS[0]}`
        ))) != null ? _c : false;
      },
      testAttribute(attribute) {
        return attribute.value.includes(
          `${INVISIBLE_CHARACTERS[0]}${INVISIBLE_CHARACTERS[0]}`
        ) || attribute.value.includes(
          `${INVISIBLE_CHARACTERS[1]}${INVISIBLE_CHARACTERS[0]}`
        );
      }
    });
  }
  const InvisibleObserver = () => () => {
    const observer = GeneralObserver();
    const self2 = Object.freeze(__spreadProps(__spreadValues({}, observer), {
      run(props) {
        const wrapper = InvisibleWrapper({
          fullKeyEncode: props.options.fullKeyEncode
        });
        observer.run(__spreadProps(__spreadValues({}, props), { wrapper }));
      },
      retranslate() {
      },
      outputNotFormattable: false
    }));
    return self2;
  };
  function isCharEscaped(position2, fullString) {
    let escapeCharsCount = 0;
    while (position2 > -1 && fullString[position2 - 1] === "\\") {
      escapeCharsCount++;
      position2--;
    }
    return escapeCharsCount % 2 == 1;
  }
  function TextWrapper({
    inputPrefix,
    inputSuffix,
    translate
  }) {
    function getRawUnWrapRegex() {
      const escapedPrefix = escapeForRegExp(inputPrefix);
      const escapedSuffix = escapeForRegExp(inputSuffix);
      return `(\\\\?)(${escapedPrefix}(.*?)${escapedSuffix})`;
    }
    function parseUnwrapped(unwrappedString) {
      let escaped = false;
      let actual = "";
      let paramName = "";
      let readingState = "KEY";
      const result = {
        key: "",
        ns: void 0,
        params: {},
        defaultValue: void 0
      };
      const addNamespace = (ns2) => {
        result.ns = ns2;
      };
      for (const char2 of unwrappedString) {
        if (char2 === "\\" && !escaped) {
          escaped = true;
          continue;
        }
        if (escaped) {
          escaped = false;
          actual += char2;
          continue;
        }
        if (readingState === "KEY" && char2 === ",") {
          readingState = "DEFAULT_VALUE";
          result.key = actual;
          actual = "";
          continue;
        }
        if (readingState === "KEY" && char2 === "|") {
          readingState = "NAMESPACE";
          result.key = actual;
          actual = "";
          continue;
        }
        if (readingState === "NAMESPACE" && char2 === ",") {
          readingState = "DEFAULT_VALUE";
          addNamespace(actual);
          actual = "";
          continue;
        }
        if (readingState === "KEY" && char2 === ":") {
          readingState = "PARAM_NAME";
          result.key = actual;
          actual = "";
          continue;
        }
        if (readingState === "DEFAULT_VALUE" && char2 === ":") {
          readingState = "PARAM_NAME";
          result.defaultValue = actual;
          actual = "";
          continue;
        }
        if (readingState === "PARAM_NAME" && char2 === ":") {
          readingState = "PARAM_VALUE";
          paramName = actual;
          actual = "";
          continue;
        }
        if (readingState === "PARAM_VALUE" && char2 === ",") {
          readingState = "PARAM_NAME";
          result.params[paramName] = actual;
          actual = "";
          continue;
        }
        actual += char2;
      }
      if (readingState === "KEY") {
        result.key = actual;
      }
      if (readingState === "DEFAULT_VALUE") {
        result.defaultValue = actual;
      }
      if (readingState === "PARAM_VALUE") {
        result.params[paramName] = actual;
      }
      if (readingState === "NAMESPACE") {
        addNamespace(actual);
      }
      return result;
    }
    function getTranslatedWithMetadata(text) {
      const { key, params, defaultValue, ns: ns2 } = parseUnwrapped(text);
      const translated = translate({
        key,
        params,
        defaultValue,
        ns: ns2,
        noWrap: true
      });
      return { translated, key, params, defaultValue, ns: ns2 };
    }
    function escapeForRegExp(string2) {
      return string2.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
    }
    function escapeParam(param) {
      if (typeof param === "string") {
        return param.replace(new RegExp("[,:|\\\\]", "gs"), "\\$&");
      }
      if (typeof param === "number" || typeof param === "bigint") {
        return param.toString();
      }
      console.warn(
        `Parameters of type "${typeof param}" are not supported in "text" wrapper mode.`
      );
      return param;
    }
    return Object.freeze({
      wrap({ key, params, defaultValue, ns: ns2 }) {
        let paramString = Object.entries(params || {}).map(
          ([name2, value]) => `${escapeParam(name2)}:${escapeParam(value)}`
        ).join(",");
        paramString = paramString.length ? `:${paramString}` : "";
        const defaultString = defaultValue !== void 0 ? `,${escapeParam(defaultValue)}` : "";
        const nsArray = typeof ns2 === "string" ? [ns2] : ns2;
        const namespaces = (nsArray == null ? void 0 : nsArray.length) ? `|${nsArray.map((ns22) => escapeParam(ns22)).join("|")}` : "";
        return `${inputPrefix}${escapeParam(
          key
        )}${namespaces}${defaultString}${paramString}${inputSuffix}`;
      },
      unwrap(text) {
        const matchRegexp = new RegExp(getRawUnWrapRegex(), "gs");
        const keysAndParams = [];
        let matched = false;
        let match2;
        let start2 = 0;
        let result = "";
        while ((match2 = matchRegexp.exec(text)) !== null) {
          let pre = match2[1];
          const [fullMatch, _2, wrapped, unwrapped] = match2;
          const { index, input } = match2;
          result += input.substr(start2, index - start2);
          start2 = index + fullMatch.length;
          if (pre === "\\") {
            if (!isCharEscaped(index, text)) {
              result += wrapped;
              continue;
            }
            pre = "";
          }
          const translated = getTranslatedWithMetadata(unwrapped);
          keysAndParams.push({
            key: translated.key,
            params: translated.params,
            defaultValue: translated.defaultValue,
            ns: translated.ns
          });
          matched = true;
          result += pre + translated.translated;
        }
        result += text.substring(start2);
        if (matched) {
          return { text: result, keys: keysAndParams };
        }
        return { text, keys: [] };
      },
      testTextNode(textNode) {
        var _a3, _b, _c;
        return (_c = ((_a3 = textNode.textContent) == null ? void 0 : _a3.includes(inputPrefix)) && ((_b = textNode.textContent) == null ? void 0 : _b.includes(inputSuffix))) != null ? _c : false;
      },
      testAttribute(attribute) {
        return attribute.value.includes(inputPrefix) && attribute.value.includes(inputSuffix);
      }
    });
  }
  const TextObserver = () => () => {
    const observer = GeneralObserver();
    const self2 = Object.freeze(__spreadProps(__spreadValues({}, observer), {
      run(props) {
        const wrapper = TextWrapper({
          inputPrefix: props.options.inputPrefix,
          inputSuffix: props.options.inputSuffix,
          translate: props.translate
        });
        observer.run(__spreadProps(__spreadValues({}, props), { wrapper }));
      },
      retranslate() {
        observer.forEachElement((_2, elMeta) => {
          for (const [node2, nodeMeta] of elMeta.nodes.entries()) {
            if (nodeMeta.keyAttributeOnly) {
              return;
            }
            const result = observer.unwrap(nodeMeta.oldTextContent);
            if (result) {
              setNodeText(node2, result.text);
            }
          }
        });
      },
      outputNotFormattable: true
    }));
    return self2;
  };
  const ObserverPlugin = () => (tolgee, tools) => {
    if (tolgee.getInitialOptions().observerType === "text") {
      tools.setObserver(TextObserver());
    } else {
      tools.setObserver(InvisibleObserver());
    }
    return tolgee;
  };
  const alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
  function readChar(char2) {
    const idx = alphabet.indexOf(char2);
    if (idx === -1) {
      throw new Error("Invalid character found: " + char2);
    }
    return idx;
  }
  function arrayBufferToString(buffer) {
    const bufView = new Uint8Array(buffer);
    const length2 = bufView.length;
    let result = "";
    let addition = Math.pow(2, 16) - 1;
    for (let i2 = 0; i2 < length2; i2 += addition) {
      if (i2 + addition > length2) {
        addition = length2 - i2;
      }
      result += String.fromCharCode.apply(
        null,
        // @ts-ignore
        bufView.subarray(i2, i2 + addition)
      );
    }
    return result;
  }
  function base32Decode(input) {
    input = input.toUpperCase();
    const length2 = input.length;
    let bits = 0;
    let value = 0;
    let index = 0;
    const output = new Uint8Array(length2 * 5 / 8 | 0);
    for (let i2 = 0; i2 < length2; i2++) {
      value = value << 5 | readChar(input[i2]);
      bits += 5;
      if (bits >= 8) {
        output[index++] = value >>> bits - 8 & 255;
        bits -= 8;
      }
    }
    return arrayBufferToString(output.buffer);
  }
  function getProjectIdFromApiKey(key) {
    if (!key) {
      return void 0;
    }
    try {
      const [prefix2, rest] = key.split("_");
      if (prefix2 === "tgpak") {
        const [projectId] = base32Decode(rest).split("_");
        return Number(projectId);
      }
    } catch (e) {
      console.warn("Tolgee: Api key can't be parsed");
    }
    return void 0;
  }
  function getApiKeyType(key) {
    if (!key) {
      return void 0;
    }
    const [prefix2] = key.split("_");
    if (prefix2 === "tgpak") {
      return "tgpak";
    } else if (prefix2 === "tgpat") {
      return "tgpat";
    }
    return "legacy";
  }
  function composeUrl(base2, path) {
    base2 = base2.replace(/\/+$/, "");
    path = path.replace(/^\/+/, "");
    return `${base2}/${path}`;
  }
  function joinUrls(...parts) {
    let result = parts[0];
    parts.slice(1).forEach((part) => {
      result = composeUrl(result, part);
    });
    return result;
  }
  function createUrl(...parts) {
    const base2 = typeof window === "undefined" ? void 0 : window.location.origin;
    return new URL(joinUrls(...parts), base2);
  }
  function createDevBackend() {
    return {
      getRecord({
        apiUrl,
        apiKey,
        language: language2,
        namespace,
        projectId,
        filterTag,
        fetch: fetch2
      }) {
        var _a3;
        const pId = (_a3 = getProjectIdFromApiKey(apiKey)) != null ? _a3 : projectId;
        let url;
        if (pId !== void 0) {
          url = createUrl(apiUrl, `/v2/projects/${pId}/translations/${language2}`);
        } else {
          url = createUrl(apiUrl, `/v2/projects/translations/${language2}`);
        }
        if (namespace) {
          url.searchParams.append("ns", namespace);
        }
        filterTag == null ? void 0 : filterTag.forEach((tag) => {
          url.searchParams.append("filterTag", tag);
        });
        if (getApiKeyType(apiKey) === "tgpat" && projectId === void 0) {
          throw new Error("You need to specify 'projectId' when using PAT key");
        }
        return fetch2(url.toString(), {
          headers: {
            "X-API-Key": apiKey || "",
            "Content-Type": "application/json"
          },
          // @ts-ignore - tell next.js to not use cache
          next: { revalidate: 0 }
        }).then((r2) => {
          if (r2.ok) {
            return r2.json().then((data) => data[language2]);
          } else {
            throw new Error(r2.statusText);
          }
        });
      }
    };
  }
  const DevBackend = () => (tolgee, tools) => {
    tools.setDevBackend(createDevBackend());
    return tolgee;
  };
  function listen(type, callback) {
    const handler = (e) => {
      var _a3, _b;
      if (type.includes((_a3 = e.data) == null ? void 0 : _a3.type)) {
        callback((_b = e.data) == null ? void 0 : _b.data);
      }
    };
    window.addEventListener("message", handler, false);
    return {
      unsubscribe() {
        window.removeEventListener("message", handler);
      }
    };
  }
  function sendAndRecieve({
    message,
    recievingMessage,
    data,
    attempts = 1,
    timeout = 300
  }) {
    let cancelled = false;
    const makeAttempt = () => new Promise((resolve, reject) => {
      const listener = listen(recievingMessage, handler);
      window.postMessage({ type: message, data }, window.origin);
      const timer = setTimeout(expire, timeout);
      function handler(data2) {
        clearTimeout(timer);
        removeEventListener();
        resolve(data2);
      }
      function removeEventListener() {
        listener.unsubscribe();
      }
      function expire() {
        removeEventListener();
        reject();
      }
    });
    const getData = async () => {
      for (let i2 = 0; i2 < attempts; i2++) {
        if (cancelled) {
          return new Promise(() => {
          });
        }
        try {
          const result = await makeAttempt();
          return result;
        } catch (e) {
          continue;
        }
      }
      if (!cancelled) {
        throw `Didn't recieve ${recievingMessage.join(" or ")} in time.`;
      }
      return new Promise(() => {
      });
    };
    return {
      cancel() {
        cancelled = true;
      },
      promise: getData()
    };
  }
  function takeScreenshot() {
    return sendAndRecieve({
      message: "TOLGEE_TAKE_SCREENSHOT",
      recievingMessage: ["TOLGEE_SCREENSHOT_TAKEN"],
      timeout: 3e3
    }).promise;
  }
  async function detectExtension() {
    try {
      await sendAndRecieve({
        message: "TOLGEE_PING",
        recievingMessage: ["TOLGEE_PONG"],
        attempts: 2
      }).promise;
      return true;
    } catch (e) {
      return false;
    }
  }
  function Handshaker() {
    let cancelLast = void 0;
    async function update(data) {
      cancelLast == null ? void 0 : cancelLast();
      const { cancel, promise } = sendAndRecieve({
        message: "TOLGEE_READY",
        recievingMessage: ["TOLGEE_PLUGIN_READY", "TOLGEE_PLUGIN_UPDATED"],
        data,
        attempts: 4
      });
      cancelLast = cancel;
      return promise;
    }
    return {
      update
    };
  }
  const IN_CONTEXT_FILE = "tolgee-in-context-tools.umd.min.js";
  const IN_CONTEXT_UMD_NAME = "@tolgee/in-context-tools";
  const IN_CONTEXT_EXPORT_NAME = "InContextTools";
  const CDN_URL = "https://cdn.jsdelivr.net/npm";
  function injectScript(src) {
    return new Promise((resolve, reject) => {
      const script = document.createElement("script");
      script.src = src;
      script.addEventListener("load", () => resolve());
      script.addEventListener("error", (e) => reject(e.error));
      document.head.appendChild(script);
    });
  }
  let injectPromise = null;
  function loadInContextLib(version) {
    if (!injectPromise) {
      injectPromise = injectScript(
        `${CDN_URL}/@tolgee/web@${version}/dist/${IN_CONTEXT_FILE}`
      ).then(() => {
        return window[IN_CONTEXT_UMD_NAME][IN_CONTEXT_EXPORT_NAME];
      });
    }
    return injectPromise;
  }
  const API_KEY_LOCAL_STORAGE = "__tolgee_apiKey";
  const API_URL_LOCAL_STORAGE = "__tolgee_apiUrl";
  function getCredentials() {
    const apiKey = sessionStorage.getItem(API_KEY_LOCAL_STORAGE) || void 0;
    const apiUrl = sessionStorage.getItem(API_URL_LOCAL_STORAGE) || void 0;
    if (!apiKey || !apiUrl) {
      return void 0;
    }
    return {
      apiKey,
      apiUrl
    };
  }
  function clearSessionStorage() {
    sessionStorage.removeItem(API_KEY_LOCAL_STORAGE);
    sessionStorage.removeItem(API_URL_LOCAL_STORAGE);
  }
  function onDocumentReady(callback) {
    if (document.readyState !== "loading") {
      Promise.resolve().then(() => {
        callback();
      });
    } else if (document.addEventListener) {
      document.addEventListener("DOMContentLoaded", callback);
    }
  }
  exports2.BrowserExtensionPlugin = () => (tolgee) => tolgee;
  const sessionStorageAvailable = () => {
    if (typeof window === "undefined") {
      return false;
    }
    try {
      return typeof sessionStorage !== "undefined" && sessionStorage;
    } catch (err) {
      console.error("sessionStorage not available", err);
      return false;
    }
  };
  if (sessionStorageAvailable()) {
    exports2.BrowserExtensionPlugin = () => (tolgee) => {
      const handshaker = Handshaker();
      const getConfig2 = () => ({
        // prevent extension downloading ui library
        uiPresent: true,
        uiVersion: void 0,
        // tolgee mode
        mode: tolgee.isDev() ? "development" : "production",
        // pass credentials
        config: {
          apiUrl: tolgee.getInitialOptions().apiUrl || "",
          apiKey: tolgee.getInitialOptions().apiKey || ""
        }
      });
      const getTolgeePlugin = async () => {
        const InContextTools2 = await loadInContextLib(
          "prerelease"
        );
        return (tolgee2) => {
          const credentials2 = getCredentials();
          tolgee2.addPlugin(InContextTools2({ credentials: credentials2 }));
          return tolgee2;
        };
      };
      tolgee.on("running", ({ value: isRunning }) => {
        if (isRunning) {
          onDocumentReady(() => {
            handshaker.update(getConfig2()).catch(clearSessionStorage);
          });
        }
      });
      const credentials = getCredentials();
      if (credentials) {
        getTolgeePlugin().then((plugin) => {
          tolgee.addPlugin(plugin);
        }).catch((e) => {
          console.error("Tolgee: Failed to load in-context tools");
          console.error(e);
        });
      }
      return tolgee;
    };
  }
  const CURRENT_LANGUAGE_LOCAL_STORAGE_KEY = "__tolgee_currentLanguage";
  function createLanguageStorage() {
    return {
      getLanguage() {
        throwIfSSR("LanguageStorage");
        const storedLanguage = localStorage.getItem(
          CURRENT_LANGUAGE_LOCAL_STORAGE_KEY
        );
        return storedLanguage || void 0;
      },
      setLanguage(language2) {
        throwIfSSR("LanguageStorage");
        localStorage.setItem(CURRENT_LANGUAGE_LOCAL_STORAGE_KEY, language2);
      }
    };
  }
  const LanguageStorage = () => (tolgee, tools) => {
    tools.setLanguageStorage(createLanguageStorage());
    return tolgee;
  };
  function detectLanguage(language2, availableLanguages) {
    const exactMatch = availableLanguages.find((l) => l === language2);
    if (exactMatch) {
      return exactMatch;
    }
    const getTwoLetters = (fullTag) => fullTag.replace(/^(.+?)(-.*)?$/, "$1");
    const preferredTwoLetter = getTwoLetters(language2);
    const twoLetterMatch = availableLanguages.find(
      (l) => getTwoLetters(l) === preferredTwoLetter
    );
    if (twoLetterMatch) {
      return twoLetterMatch;
    }
    return void 0;
  }
  function createLanguageDetector() {
    return {
      getLanguage({ availableLanguages }) {
        throwIfSSR("LanguageDetector");
        const preferred = window.navigator.language;
        return detectLanguage(preferred, availableLanguages);
      }
    };
  }
  const LanguageDetector = () => (tolgee, tools) => {
    tools.setLanguageDetector(createLanguageDetector());
    return tolgee;
  };
  function getHeaderLanguages(headers) {
    const acceptLanguageHeader = headers.get("Accept-Language");
    if (!acceptLanguageHeader) {
      return [];
    }
    const locales = acceptLanguageHeader.split(",").map((locale) => {
      const [localePart] = locale.trim().split(";");
      return localePart;
    });
    return [...new Set(locales.filter((locale) => locale && locale !== "*"))];
  }
  const detectLanguageFromHeaders = (headers, availableLanguages) => {
    const languages = getHeaderLanguages(headers);
    return languages[0] && detectLanguage(languages[0], availableLanguages);
  };
  const fetchWithTimeout = (fetch2, url, ms, _b) => {
    var _c = _b, { signal } = _c, options = __objRest(_c, ["signal"]);
    const controller = new AbortController();
    return new Promise((_resolve, _reject) => {
      const promise = fetch2(url, __spreadValues({ signal: controller.signal }, options));
      let done = false;
      function resolve(data) {
        !done && _resolve(data);
        done = true;
      }
      function reject(data) {
        !done && _reject(data);
        done = true;
      }
      function rejectWithTimout() {
        const error = new Error(`TIMEOUT: ${url}`);
        controller.abort(error);
        reject(error);
      }
      if (signal) {
        signal.addEventListener("abort", rejectWithTimout);
      }
      if (ms !== void 0) {
        const timeout = setTimeout(rejectWithTimout, ms);
        promise.finally(() => clearTimeout(timeout));
      }
      promise.catch(reject).then(resolve);
    });
  };
  function trimSlashes(path) {
    if (path.endsWith("/")) {
      return path.slice(0, -1);
    }
    return path;
  }
  const defaultGetPath = ({ namespace, language: language2, prefix: prefix2 }) => {
    if (namespace) {
      return `${trimSlashes(prefix2)}/${namespace}/${language2}.json`;
    } else {
      return `${trimSlashes(prefix2)}/${language2}.json`;
    }
  };
  function defaultGetData(r2) {
    return r2.json();
  }
  const DEFAULT_OPTIONS$1 = {
    prefix: "/i18n",
    getPath: defaultGetPath,
    getData: defaultGetData,
    headers: {
      Accept: "application/json"
    },
    timeout: void 0,
    fallbackOnFail: false
  };
  function createBackendFetch(options) {
    const _a3 = __spreadProps(__spreadValues(__spreadValues({}, DEFAULT_OPTIONS$1), options), {
      headers: __spreadValues(__spreadValues({}, DEFAULT_OPTIONS$1.headers), options == null ? void 0 : options.headers)
    }), {
      prefix: prefix2,
      getPath: getPath2,
      getData,
      headers,
      timeout,
      fallbackOnFail
    } = _a3, fetchOptions = __objRest(_a3, [
      "prefix",
      "getPath",
      "getData",
      "headers",
      "timeout",
      "fallbackOnFail"
    ]);
    return {
      async getRecord({ namespace, language: language2, fetch: fetch2 }) {
        const path = getPath2({
          namespace,
          language: language2,
          prefix: prefix2
        });
        try {
          const r2 = await fetchWithTimeout(fetch2, path, timeout, __spreadValues({
            headers
          }, fetchOptions));
          if (!r2.ok) {
            throw new Error(`${r2.url} ${r2.status}`);
          }
          return await getData(r2);
        } catch (e) {
          if (fallbackOnFail) {
            return void 0;
          } else {
            throw e;
          }
        }
      }
    };
  }
  const BackendFetch = (options) => (tolgee, tools) => {
    tools.addBackend(createBackendFetch(options));
    return tolgee;
  };
  function Tolgee() {
    return TolgeeCore().use(exports2.BrowserExtensionPlugin());
  }
  var jsxRuntime = { exports: {} };
  var reactJsxRuntime_production_min = {};
  var react = { exports: {} };
  var react_production_min = {};
  /**
   * @license React
   * react.production.min.js
   *
   * Copyright (c) Facebook, Inc. and its affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var hasRequiredReact_production_min;
  function requireReact_production_min() {
    if (hasRequiredReact_production_min)
      return react_production_min;
    hasRequiredReact_production_min = 1;
    var l = Symbol.for("react.element"), n = Symbol.for("react.portal"), p2 = Symbol.for("react.fragment"), q2 = Symbol.for("react.strict_mode"), r2 = Symbol.for("react.profiler"), t2 = Symbol.for("react.provider"), u = Symbol.for("react.context"), v2 = Symbol.for("react.forward_ref"), w = Symbol.for("react.suspense"), x2 = Symbol.for("react.memo"), y = Symbol.for("react.lazy"), z = Symbol.iterator;
    function A2(a2) {
      if (null === a2 || "object" !== typeof a2)
        return null;
      a2 = z && a2[z] || a2["@@iterator"];
      return "function" === typeof a2 ? a2 : null;
    }
    var B = { isMounted: function() {
      return false;
    }, enqueueForceUpdate: function() {
    }, enqueueReplaceState: function() {
    }, enqueueSetState: function() {
    } }, C2 = Object.assign, D = {};
    function E2(a2, b, e) {
      this.props = a2;
      this.context = b;
      this.refs = D;
      this.updater = e || B;
    }
    E2.prototype.isReactComponent = {};
    E2.prototype.setState = function(a2, b) {
      if ("object" !== typeof a2 && "function" !== typeof a2 && null != a2)
        throw Error("setState(...): takes an object of state variables to update or a function which returns an object of state variables.");
      this.updater.enqueueSetState(this, a2, b, "setState");
    };
    E2.prototype.forceUpdate = function(a2) {
      this.updater.enqueueForceUpdate(this, a2, "forceUpdate");
    };
    function F() {
    }
    F.prototype = E2.prototype;
    function G2(a2, b, e) {
      this.props = a2;
      this.context = b;
      this.refs = D;
      this.updater = e || B;
    }
    var H2 = G2.prototype = new F();
    H2.constructor = G2;
    C2(H2, E2.prototype);
    H2.isPureReactComponent = true;
    var I = Array.isArray, J = Object.prototype.hasOwnProperty, K = { current: null }, L2 = { key: true, ref: true, __self: true, __source: true };
    function M2(a2, b, e) {
      var d, c2 = {}, k = null, h = null;
      if (null != b)
        for (d in void 0 !== b.ref && (h = b.ref), void 0 !== b.key && (k = "" + b.key), b)
          J.call(b, d) && !L2.hasOwnProperty(d) && (c2[d] = b[d]);
      var g = arguments.length - 2;
      if (1 === g)
        c2.children = e;
      else if (1 < g) {
        for (var f = Array(g), m2 = 0; m2 < g; m2++)
          f[m2] = arguments[m2 + 2];
        c2.children = f;
      }
      if (a2 && a2.defaultProps)
        for (d in g = a2.defaultProps, g)
          void 0 === c2[d] && (c2[d] = g[d]);
      return { $$typeof: l, type: a2, key: k, ref: h, props: c2, _owner: K.current };
    }
    function N(a2, b) {
      return { $$typeof: l, type: a2.type, key: b, ref: a2.ref, props: a2.props, _owner: a2._owner };
    }
    function O(a2) {
      return "object" === typeof a2 && null !== a2 && a2.$$typeof === l;
    }
    function escape(a2) {
      var b = { "=": "=0", ":": "=2" };
      return "$" + a2.replace(/[=:]/g, function(a3) {
        return b[a3];
      });
    }
    var P2 = /\/+/g;
    function Q2(a2, b) {
      return "object" === typeof a2 && null !== a2 && null != a2.key ? escape("" + a2.key) : b.toString(36);
    }
    function R(a2, b, e, d, c2) {
      var k = typeof a2;
      if ("undefined" === k || "boolean" === k)
        a2 = null;
      var h = false;
      if (null === a2)
        h = true;
      else
        switch (k) {
          case "string":
          case "number":
            h = true;
            break;
          case "object":
            switch (a2.$$typeof) {
              case l:
              case n:
                h = true;
            }
        }
      if (h)
        return h = a2, c2 = c2(h), a2 = "" === d ? "." + Q2(h, 0) : d, I(c2) ? (e = "", null != a2 && (e = a2.replace(P2, "$&/") + "/"), R(c2, b, e, "", function(a3) {
          return a3;
        })) : null != c2 && (O(c2) && (c2 = N(c2, e + (!c2.key || h && h.key === c2.key ? "" : ("" + c2.key).replace(P2, "$&/") + "/") + a2)), b.push(c2)), 1;
      h = 0;
      d = "" === d ? "." : d + ":";
      if (I(a2))
        for (var g = 0; g < a2.length; g++) {
          k = a2[g];
          var f = d + Q2(k, g);
          h += R(k, b, e, f, c2);
        }
      else if (f = A2(a2), "function" === typeof f)
        for (a2 = f.call(a2), g = 0; !(k = a2.next()).done; )
          k = k.value, f = d + Q2(k, g++), h += R(k, b, e, f, c2);
      else if ("object" === k)
        throw b = String(a2), Error("Objects are not valid as a React child (found: " + ("[object Object]" === b ? "object with keys {" + Object.keys(a2).join(", ") + "}" : b) + "). If you meant to render a collection of children, use an array instead.");
      return h;
    }
    function S(a2, b, e) {
      if (null == a2)
        return a2;
      var d = [], c2 = 0;
      R(a2, d, "", "", function(a3) {
        return b.call(e, a3, c2++);
      });
      return d;
    }
    function T(a2) {
      if (-1 === a2._status) {
        var b = a2._result;
        b = b();
        b.then(function(b2) {
          if (0 === a2._status || -1 === a2._status)
            a2._status = 1, a2._result = b2;
        }, function(b2) {
          if (0 === a2._status || -1 === a2._status)
            a2._status = 2, a2._result = b2;
        });
        -1 === a2._status && (a2._status = 0, a2._result = b);
      }
      if (1 === a2._status)
        return a2._result.default;
      throw a2._result;
    }
    var U2 = { current: null }, V2 = { transition: null }, W2 = { ReactCurrentDispatcher: U2, ReactCurrentBatchConfig: V2, ReactCurrentOwner: K };
    function X2() {
      throw Error("act(...) is not supported in production builds of React.");
    }
    react_production_min.Children = { map: S, forEach: function(a2, b, e) {
      S(a2, function() {
        b.apply(this, arguments);
      }, e);
    }, count: function(a2) {
      var b = 0;
      S(a2, function() {
        b++;
      });
      return b;
    }, toArray: function(a2) {
      return S(a2, function(a3) {
        return a3;
      }) || [];
    }, only: function(a2) {
      if (!O(a2))
        throw Error("React.Children.only expected to receive a single React element child.");
      return a2;
    } };
    react_production_min.Component = E2;
    react_production_min.Fragment = p2;
    react_production_min.Profiler = r2;
    react_production_min.PureComponent = G2;
    react_production_min.StrictMode = q2;
    react_production_min.Suspense = w;
    react_production_min.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED = W2;
    react_production_min.act = X2;
    react_production_min.cloneElement = function(a2, b, e) {
      if (null === a2 || void 0 === a2)
        throw Error("React.cloneElement(...): The argument must be a React element, but you passed " + a2 + ".");
      var d = C2({}, a2.props), c2 = a2.key, k = a2.ref, h = a2._owner;
      if (null != b) {
        void 0 !== b.ref && (k = b.ref, h = K.current);
        void 0 !== b.key && (c2 = "" + b.key);
        if (a2.type && a2.type.defaultProps)
          var g = a2.type.defaultProps;
        for (f in b)
          J.call(b, f) && !L2.hasOwnProperty(f) && (d[f] = void 0 === b[f] && void 0 !== g ? g[f] : b[f]);
      }
      var f = arguments.length - 2;
      if (1 === f)
        d.children = e;
      else if (1 < f) {
        g = Array(f);
        for (var m2 = 0; m2 < f; m2++)
          g[m2] = arguments[m2 + 2];
        d.children = g;
      }
      return { $$typeof: l, type: a2.type, key: c2, ref: k, props: d, _owner: h };
    };
    react_production_min.createContext = function(a2) {
      a2 = { $$typeof: u, _currentValue: a2, _currentValue2: a2, _threadCount: 0, Provider: null, Consumer: null, _defaultValue: null, _globalName: null };
      a2.Provider = { $$typeof: t2, _context: a2 };
      return a2.Consumer = a2;
    };
    react_production_min.createElement = M2;
    react_production_min.createFactory = function(a2) {
      var b = M2.bind(null, a2);
      b.type = a2;
      return b;
    };
    react_production_min.createRef = function() {
      return { current: null };
    };
    react_production_min.forwardRef = function(a2) {
      return { $$typeof: v2, render: a2 };
    };
    react_production_min.isValidElement = O;
    react_production_min.lazy = function(a2) {
      return { $$typeof: y, _payload: { _status: -1, _result: a2 }, _init: T };
    };
    react_production_min.memo = function(a2, b) {
      return { $$typeof: x2, type: a2, compare: void 0 === b ? null : b };
    };
    react_production_min.startTransition = function(a2) {
      var b = V2.transition;
      V2.transition = {};
      try {
        a2();
      } finally {
        V2.transition = b;
      }
    };
    react_production_min.unstable_act = X2;
    react_production_min.useCallback = function(a2, b) {
      return U2.current.useCallback(a2, b);
    };
    react_production_min.useContext = function(a2) {
      return U2.current.useContext(a2);
    };
    react_production_min.useDebugValue = function() {
    };
    react_production_min.useDeferredValue = function(a2) {
      return U2.current.useDeferredValue(a2);
    };
    react_production_min.useEffect = function(a2, b) {
      return U2.current.useEffect(a2, b);
    };
    react_production_min.useId = function() {
      return U2.current.useId();
    };
    react_production_min.useImperativeHandle = function(a2, b, e) {
      return U2.current.useImperativeHandle(a2, b, e);
    };
    react_production_min.useInsertionEffect = function(a2, b) {
      return U2.current.useInsertionEffect(a2, b);
    };
    react_production_min.useLayoutEffect = function(a2, b) {
      return U2.current.useLayoutEffect(a2, b);
    };
    react_production_min.useMemo = function(a2, b) {
      return U2.current.useMemo(a2, b);
    };
    react_production_min.useReducer = function(a2, b, e) {
      return U2.current.useReducer(a2, b, e);
    };
    react_production_min.useRef = function(a2) {
      return U2.current.useRef(a2);
    };
    react_production_min.useState = function(a2) {
      return U2.current.useState(a2);
    };
    react_production_min.useSyncExternalStore = function(a2, b, e) {
      return U2.current.useSyncExternalStore(a2, b, e);
    };
    react_production_min.useTransition = function() {
      return U2.current.useTransition();
    };
    react_production_min.version = "18.3.1";
    return react_production_min;
  }
  var hasRequiredReact;
  function requireReact() {
    if (hasRequiredReact)
      return react.exports;
    hasRequiredReact = 1;
    {
      react.exports = requireReact_production_min();
    }
    return react.exports;
  }
  /**
   * @license React
   * react-jsx-runtime.production.min.js
   *
   * Copyright (c) Facebook, Inc. and its affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var hasRequiredReactJsxRuntime_production_min;
  function requireReactJsxRuntime_production_min() {
    if (hasRequiredReactJsxRuntime_production_min)
      return reactJsxRuntime_production_min;
    hasRequiredReactJsxRuntime_production_min = 1;
    var f = requireReact(), k = Symbol.for("react.element"), l = Symbol.for("react.fragment"), m2 = Object.prototype.hasOwnProperty, n = f.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner, p2 = { key: true, ref: true, __self: true, __source: true };
    function q2(c2, a2, g) {
      var b, d = {}, e = null, h = null;
      void 0 !== g && (e = "" + g);
      void 0 !== a2.key && (e = "" + a2.key);
      void 0 !== a2.ref && (h = a2.ref);
      for (b in a2)
        m2.call(a2, b) && !p2.hasOwnProperty(b) && (d[b] = a2[b]);
      if (c2 && c2.defaultProps)
        for (b in a2 = c2.defaultProps, a2)
          void 0 === d[b] && (d[b] = a2[b]);
      return { $$typeof: k, type: c2, key: e, ref: h, props: d, _owner: n.current };
    }
    reactJsxRuntime_production_min.Fragment = l;
    reactJsxRuntime_production_min.jsx = q2;
    reactJsxRuntime_production_min.jsxs = q2;
    return reactJsxRuntime_production_min;
  }
  {
    jsxRuntime.exports = requireReactJsxRuntime_production_min();
  }
  var jsxRuntimeExports = jsxRuntime.exports;
  var reactExports = requireReact();
  const React$1 = /* @__PURE__ */ getDefaultExportFromCjs(reactExports);
  const React$2 = /* @__PURE__ */ _mergeNamespaces({
    __proto__: null,
    default: React$1
  }, [reactExports]);
  function _setPrototypeOf$1(o2, p2) {
    _setPrototypeOf$1 = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o3, p3) {
      o3.__proto__ = p3;
      return o3;
    };
    return _setPrototypeOf$1(o2, p2);
  }
  function _inheritsLoose$1(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    _setPrototypeOf$1(subClass, superClass);
  }
  var Subscribable = /* @__PURE__ */ function() {
    function Subscribable2() {
      this.listeners = [];
    }
    var _proto = Subscribable2.prototype;
    _proto.subscribe = function subscribe(listener) {
      var _this = this;
      var callback = listener || function() {
        return void 0;
      };
      this.listeners.push(callback);
      this.onSubscribe();
      return function() {
        _this.listeners = _this.listeners.filter(function(x2) {
          return x2 !== callback;
        });
        _this.onUnsubscribe();
      };
    };
    _proto.hasListeners = function hasListeners() {
      return this.listeners.length > 0;
    };
    _proto.onSubscribe = function onSubscribe() {
    };
    _proto.onUnsubscribe = function onUnsubscribe() {
    };
    return Subscribable2;
  }();
  function _extends$3() {
    _extends$3 = Object.assign ? Object.assign.bind() : function(target) {
      for (var i2 = 1; i2 < arguments.length; i2++) {
        var source = arguments[i2];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends$3.apply(this, arguments);
  }
  var isServer = typeof window === "undefined";
  function noop$1() {
    return void 0;
  }
  function functionalUpdate(updater, input) {
    return typeof updater === "function" ? updater(input) : updater;
  }
  function isValidTimeout(value) {
    return typeof value === "number" && value >= 0 && value !== Infinity;
  }
  function ensureQueryKeyArray(value) {
    return Array.isArray(value) ? value : [value];
  }
  function timeUntilStale(updatedAt, staleTime) {
    return Math.max(updatedAt + (staleTime || 0) - Date.now(), 0);
  }
  function parseQueryArgs(arg1, arg2, arg3) {
    if (!isQueryKey(arg1)) {
      return arg1;
    }
    if (typeof arg2 === "function") {
      return _extends$3({}, arg3, {
        queryKey: arg1,
        queryFn: arg2
      });
    }
    return _extends$3({}, arg2, {
      queryKey: arg1
    });
  }
  function parseMutationArgs(arg1, arg2, arg3) {
    if (isQueryKey(arg1)) {
      if (typeof arg2 === "function") {
        return _extends$3({}, arg3, {
          mutationKey: arg1,
          mutationFn: arg2
        });
      }
      return _extends$3({}, arg2, {
        mutationKey: arg1
      });
    }
    if (typeof arg1 === "function") {
      return _extends$3({}, arg2, {
        mutationFn: arg1
      });
    }
    return _extends$3({}, arg1);
  }
  function parseFilterArgs(arg1, arg2, arg3) {
    return isQueryKey(arg1) ? [_extends$3({}, arg2, {
      queryKey: arg1
    }), arg3] : [arg1 || {}, arg2];
  }
  function mapQueryStatusFilter(active, inactive) {
    if (active === true && inactive === true || active == null && inactive == null) {
      return "all";
    } else if (active === false && inactive === false) {
      return "none";
    } else {
      var isActive = active != null ? active : !inactive;
      return isActive ? "active" : "inactive";
    }
  }
  function matchQuery(filters, query) {
    var active = filters.active, exact = filters.exact, fetching = filters.fetching, inactive = filters.inactive, predicate = filters.predicate, queryKey = filters.queryKey, stale = filters.stale;
    if (isQueryKey(queryKey)) {
      if (exact) {
        if (query.queryHash !== hashQueryKeyByOptions(queryKey, query.options)) {
          return false;
        }
      } else if (!partialMatchKey(query.queryKey, queryKey)) {
        return false;
      }
    }
    var queryStatusFilter = mapQueryStatusFilter(active, inactive);
    if (queryStatusFilter === "none") {
      return false;
    } else if (queryStatusFilter !== "all") {
      var isActive = query.isActive();
      if (queryStatusFilter === "active" && !isActive) {
        return false;
      }
      if (queryStatusFilter === "inactive" && isActive) {
        return false;
      }
    }
    if (typeof stale === "boolean" && query.isStale() !== stale) {
      return false;
    }
    if (typeof fetching === "boolean" && query.isFetching() !== fetching) {
      return false;
    }
    if (predicate && !predicate(query)) {
      return false;
    }
    return true;
  }
  function matchMutation(filters, mutation) {
    var exact = filters.exact, fetching = filters.fetching, predicate = filters.predicate, mutationKey = filters.mutationKey;
    if (isQueryKey(mutationKey)) {
      if (!mutation.options.mutationKey) {
        return false;
      }
      if (exact) {
        if (hashQueryKey(mutation.options.mutationKey) !== hashQueryKey(mutationKey)) {
          return false;
        }
      } else if (!partialMatchKey(mutation.options.mutationKey, mutationKey)) {
        return false;
      }
    }
    if (typeof fetching === "boolean" && mutation.state.status === "loading" !== fetching) {
      return false;
    }
    if (predicate && !predicate(mutation)) {
      return false;
    }
    return true;
  }
  function hashQueryKeyByOptions(queryKey, options) {
    var hashFn = (options == null ? void 0 : options.queryKeyHashFn) || hashQueryKey;
    return hashFn(queryKey);
  }
  function hashQueryKey(queryKey) {
    var asArray2 = ensureQueryKeyArray(queryKey);
    return stableValueHash(asArray2);
  }
  function stableValueHash(value) {
    return JSON.stringify(value, function(_2, val) {
      return isPlainObject$1(val) ? Object.keys(val).sort().reduce(function(result, key) {
        result[key] = val[key];
        return result;
      }, {}) : val;
    });
  }
  function partialMatchKey(a2, b) {
    return partialDeepEqual(ensureQueryKeyArray(a2), ensureQueryKeyArray(b));
  }
  function partialDeepEqual(a2, b) {
    if (a2 === b) {
      return true;
    }
    if (typeof a2 !== typeof b) {
      return false;
    }
    if (a2 && b && typeof a2 === "object" && typeof b === "object") {
      return !Object.keys(b).some(function(key) {
        return !partialDeepEqual(a2[key], b[key]);
      });
    }
    return false;
  }
  function replaceEqualDeep(a2, b) {
    if (a2 === b) {
      return a2;
    }
    var array = Array.isArray(a2) && Array.isArray(b);
    if (array || isPlainObject$1(a2) && isPlainObject$1(b)) {
      var aSize = array ? a2.length : Object.keys(a2).length;
      var bItems = array ? b : Object.keys(b);
      var bSize = bItems.length;
      var copy2 = array ? [] : {};
      var equalItems = 0;
      for (var i2 = 0; i2 < bSize; i2++) {
        var key = array ? i2 : bItems[i2];
        copy2[key] = replaceEqualDeep(a2[key], b[key]);
        if (copy2[key] === a2[key]) {
          equalItems++;
        }
      }
      return aSize === bSize && equalItems === aSize ? a2 : copy2;
    }
    return b;
  }
  function shallowEqualObjects(a2, b) {
    if (a2 && !b || b && !a2) {
      return false;
    }
    for (var key in a2) {
      if (a2[key] !== b[key]) {
        return false;
      }
    }
    return true;
  }
  function isPlainObject$1(o2) {
    if (!hasObjectPrototype(o2)) {
      return false;
    }
    var ctor = o2.constructor;
    if (typeof ctor === "undefined") {
      return true;
    }
    var prot = ctor.prototype;
    if (!hasObjectPrototype(prot)) {
      return false;
    }
    if (!prot.hasOwnProperty("isPrototypeOf")) {
      return false;
    }
    return true;
  }
  function hasObjectPrototype(o2) {
    return Object.prototype.toString.call(o2) === "[object Object]";
  }
  function isQueryKey(value) {
    return typeof value === "string" || Array.isArray(value);
  }
  function sleep$1(timeout) {
    return new Promise(function(resolve) {
      setTimeout(resolve, timeout);
    });
  }
  function scheduleMicrotask(callback) {
    Promise.resolve().then(callback).catch(function(error) {
      return setTimeout(function() {
        throw error;
      });
    });
  }
  function getAbortController() {
    if (typeof AbortController === "function") {
      return new AbortController();
    }
  }
  var FocusManager = /* @__PURE__ */ function(_Subscribable) {
    _inheritsLoose$1(FocusManager2, _Subscribable);
    function FocusManager2() {
      var _this;
      _this = _Subscribable.call(this) || this;
      _this.setup = function(onFocus) {
        var _window;
        if (!isServer && ((_window = window) == null ? void 0 : _window.addEventListener)) {
          var listener = function listener2() {
            return onFocus();
          };
          window.addEventListener("visibilitychange", listener, false);
          window.addEventListener("focus", listener, false);
          return function() {
            window.removeEventListener("visibilitychange", listener);
            window.removeEventListener("focus", listener);
          };
        }
      };
      return _this;
    }
    var _proto = FocusManager2.prototype;
    _proto.onSubscribe = function onSubscribe() {
      if (!this.cleanup) {
        this.setEventListener(this.setup);
      }
    };
    _proto.onUnsubscribe = function onUnsubscribe() {
      if (!this.hasListeners()) {
        var _this$cleanup;
        (_this$cleanup = this.cleanup) == null ? void 0 : _this$cleanup.call(this);
        this.cleanup = void 0;
      }
    };
    _proto.setEventListener = function setEventListener(setup) {
      var _this$cleanup2, _this2 = this;
      this.setup = setup;
      (_this$cleanup2 = this.cleanup) == null ? void 0 : _this$cleanup2.call(this);
      this.cleanup = setup(function(focused) {
        if (typeof focused === "boolean") {
          _this2.setFocused(focused);
        } else {
          _this2.onFocus();
        }
      });
    };
    _proto.setFocused = function setFocused(focused) {
      this.focused = focused;
      if (focused) {
        this.onFocus();
      }
    };
    _proto.onFocus = function onFocus() {
      this.listeners.forEach(function(listener) {
        listener();
      });
    };
    _proto.isFocused = function isFocused() {
      if (typeof this.focused === "boolean") {
        return this.focused;
      }
      if (typeof document === "undefined") {
        return true;
      }
      return [void 0, "visible", "prerender"].includes(document.visibilityState);
    };
    return FocusManager2;
  }(Subscribable);
  var focusManager = new FocusManager();
  var OnlineManager = /* @__PURE__ */ function(_Subscribable) {
    _inheritsLoose$1(OnlineManager2, _Subscribable);
    function OnlineManager2() {
      var _this;
      _this = _Subscribable.call(this) || this;
      _this.setup = function(onOnline) {
        var _window;
        if (!isServer && ((_window = window) == null ? void 0 : _window.addEventListener)) {
          var listener = function listener2() {
            return onOnline();
          };
          window.addEventListener("online", listener, false);
          window.addEventListener("offline", listener, false);
          return function() {
            window.removeEventListener("online", listener);
            window.removeEventListener("offline", listener);
          };
        }
      };
      return _this;
    }
    var _proto = OnlineManager2.prototype;
    _proto.onSubscribe = function onSubscribe() {
      if (!this.cleanup) {
        this.setEventListener(this.setup);
      }
    };
    _proto.onUnsubscribe = function onUnsubscribe() {
      if (!this.hasListeners()) {
        var _this$cleanup;
        (_this$cleanup = this.cleanup) == null ? void 0 : _this$cleanup.call(this);
        this.cleanup = void 0;
      }
    };
    _proto.setEventListener = function setEventListener(setup) {
      var _this$cleanup2, _this2 = this;
      this.setup = setup;
      (_this$cleanup2 = this.cleanup) == null ? void 0 : _this$cleanup2.call(this);
      this.cleanup = setup(function(online) {
        if (typeof online === "boolean") {
          _this2.setOnline(online);
        } else {
          _this2.onOnline();
        }
      });
    };
    _proto.setOnline = function setOnline(online) {
      this.online = online;
      if (online) {
        this.onOnline();
      }
    };
    _proto.onOnline = function onOnline() {
      this.listeners.forEach(function(listener) {
        listener();
      });
    };
    _proto.isOnline = function isOnline() {
      if (typeof this.online === "boolean") {
        return this.online;
      }
      if (typeof navigator === "undefined" || typeof navigator.onLine === "undefined") {
        return true;
      }
      return navigator.onLine;
    };
    return OnlineManager2;
  }(Subscribable);
  var onlineManager = new OnlineManager();
  function defaultRetryDelay(failureCount) {
    return Math.min(1e3 * Math.pow(2, failureCount), 3e4);
  }
  function isCancelable(value) {
    return typeof (value == null ? void 0 : value.cancel) === "function";
  }
  var CancelledError = function CancelledError2(options) {
    this.revert = options == null ? void 0 : options.revert;
    this.silent = options == null ? void 0 : options.silent;
  };
  function isCancelledError(value) {
    return value instanceof CancelledError;
  }
  var Retryer = function Retryer2(config2) {
    var _this = this;
    var cancelRetry = false;
    var cancelFn;
    var continueFn;
    var promiseResolve;
    var promiseReject;
    this.abort = config2.abort;
    this.cancel = function(cancelOptions) {
      return cancelFn == null ? void 0 : cancelFn(cancelOptions);
    };
    this.cancelRetry = function() {
      cancelRetry = true;
    };
    this.continueRetry = function() {
      cancelRetry = false;
    };
    this.continue = function() {
      return continueFn == null ? void 0 : continueFn();
    };
    this.failureCount = 0;
    this.isPaused = false;
    this.isResolved = false;
    this.isTransportCancelable = false;
    this.promise = new Promise(function(outerResolve, outerReject) {
      promiseResolve = outerResolve;
      promiseReject = outerReject;
    });
    var resolve = function resolve2(value) {
      if (!_this.isResolved) {
        _this.isResolved = true;
        config2.onSuccess == null ? void 0 : config2.onSuccess(value);
        continueFn == null ? void 0 : continueFn();
        promiseResolve(value);
      }
    };
    var reject = function reject2(value) {
      if (!_this.isResolved) {
        _this.isResolved = true;
        config2.onError == null ? void 0 : config2.onError(value);
        continueFn == null ? void 0 : continueFn();
        promiseReject(value);
      }
    };
    var pause = function pause2() {
      return new Promise(function(continueResolve) {
        continueFn = continueResolve;
        _this.isPaused = true;
        config2.onPause == null ? void 0 : config2.onPause();
      }).then(function() {
        continueFn = void 0;
        _this.isPaused = false;
        config2.onContinue == null ? void 0 : config2.onContinue();
      });
    };
    var run = function run2() {
      if (_this.isResolved) {
        return;
      }
      var promiseOrValue;
      try {
        promiseOrValue = config2.fn();
      } catch (error) {
        promiseOrValue = Promise.reject(error);
      }
      cancelFn = function cancelFn2(cancelOptions) {
        if (!_this.isResolved) {
          reject(new CancelledError(cancelOptions));
          _this.abort == null ? void 0 : _this.abort();
          if (isCancelable(promiseOrValue)) {
            try {
              promiseOrValue.cancel();
            } catch (_unused) {
            }
          }
        }
      };
      _this.isTransportCancelable = isCancelable(promiseOrValue);
      Promise.resolve(promiseOrValue).then(resolve).catch(function(error) {
        var _config$retry, _config$retryDelay;
        if (_this.isResolved) {
          return;
        }
        var retry = (_config$retry = config2.retry) != null ? _config$retry : 3;
        var retryDelay = (_config$retryDelay = config2.retryDelay) != null ? _config$retryDelay : defaultRetryDelay;
        var delay = typeof retryDelay === "function" ? retryDelay(_this.failureCount, error) : retryDelay;
        var shouldRetry = retry === true || typeof retry === "number" && _this.failureCount < retry || typeof retry === "function" && retry(_this.failureCount, error);
        if (cancelRetry || !shouldRetry) {
          reject(error);
          return;
        }
        _this.failureCount++;
        config2.onFail == null ? void 0 : config2.onFail(_this.failureCount, error);
        sleep$1(delay).then(function() {
          if (!focusManager.isFocused() || !onlineManager.isOnline()) {
            return pause();
          }
        }).then(function() {
          if (cancelRetry) {
            reject(error);
          } else {
            run2();
          }
        });
      });
    };
    run();
  };
  var NotifyManager = /* @__PURE__ */ function() {
    function NotifyManager2() {
      this.queue = [];
      this.transactions = 0;
      this.notifyFn = function(callback) {
        callback();
      };
      this.batchNotifyFn = function(callback) {
        callback();
      };
    }
    var _proto = NotifyManager2.prototype;
    _proto.batch = function batch(callback) {
      var result;
      this.transactions++;
      try {
        result = callback();
      } finally {
        this.transactions--;
        if (!this.transactions) {
          this.flush();
        }
      }
      return result;
    };
    _proto.schedule = function schedule(callback) {
      var _this = this;
      if (this.transactions) {
        this.queue.push(callback);
      } else {
        scheduleMicrotask(function() {
          _this.notifyFn(callback);
        });
      }
    };
    _proto.batchCalls = function batchCalls(callback) {
      var _this2 = this;
      return function() {
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }
        _this2.schedule(function() {
          callback.apply(void 0, args);
        });
      };
    };
    _proto.flush = function flush() {
      var _this3 = this;
      var queue = this.queue;
      this.queue = [];
      if (queue.length) {
        scheduleMicrotask(function() {
          _this3.batchNotifyFn(function() {
            queue.forEach(function(callback) {
              _this3.notifyFn(callback);
            });
          });
        });
      }
    };
    _proto.setNotifyFunction = function setNotifyFunction(fn) {
      this.notifyFn = fn;
    };
    _proto.setBatchNotifyFunction = function setBatchNotifyFunction(fn) {
      this.batchNotifyFn = fn;
    };
    return NotifyManager2;
  }();
  var notifyManager = new NotifyManager();
  var logger$1 = console;
  function getLogger() {
    return logger$1;
  }
  function setLogger(newLogger) {
    logger$1 = newLogger;
  }
  var Query = /* @__PURE__ */ function() {
    function Query2(config2) {
      this.abortSignalConsumed = false;
      this.hadObservers = false;
      this.defaultOptions = config2.defaultOptions;
      this.setOptions(config2.options);
      this.observers = [];
      this.cache = config2.cache;
      this.queryKey = config2.queryKey;
      this.queryHash = config2.queryHash;
      this.initialState = config2.state || this.getDefaultState(this.options);
      this.state = this.initialState;
      this.meta = config2.meta;
      this.scheduleGc();
    }
    var _proto = Query2.prototype;
    _proto.setOptions = function setOptions(options) {
      var _this$options$cacheTi;
      this.options = _extends$3({}, this.defaultOptions, options);
      this.meta = options == null ? void 0 : options.meta;
      this.cacheTime = Math.max(this.cacheTime || 0, (_this$options$cacheTi = this.options.cacheTime) != null ? _this$options$cacheTi : 5 * 60 * 1e3);
    };
    _proto.setDefaultOptions = function setDefaultOptions(options) {
      this.defaultOptions = options;
    };
    _proto.scheduleGc = function scheduleGc() {
      var _this = this;
      this.clearGcTimeout();
      if (isValidTimeout(this.cacheTime)) {
        this.gcTimeout = setTimeout(function() {
          _this.optionalRemove();
        }, this.cacheTime);
      }
    };
    _proto.clearGcTimeout = function clearGcTimeout() {
      if (this.gcTimeout) {
        clearTimeout(this.gcTimeout);
        this.gcTimeout = void 0;
      }
    };
    _proto.optionalRemove = function optionalRemove() {
      if (!this.observers.length) {
        if (this.state.isFetching) {
          if (this.hadObservers) {
            this.scheduleGc();
          }
        } else {
          this.cache.remove(this);
        }
      }
    };
    _proto.setData = function setData(updater, options) {
      var _this$options$isDataE, _this$options;
      var prevData = this.state.data;
      var data = functionalUpdate(updater, prevData);
      if ((_this$options$isDataE = (_this$options = this.options).isDataEqual) == null ? void 0 : _this$options$isDataE.call(_this$options, prevData, data)) {
        data = prevData;
      } else if (this.options.structuralSharing !== false) {
        data = replaceEqualDeep(prevData, data);
      }
      this.dispatch({
        data,
        type: "success",
        dataUpdatedAt: options == null ? void 0 : options.updatedAt
      });
      return data;
    };
    _proto.setState = function setState(state, setStateOptions) {
      this.dispatch({
        type: "setState",
        state,
        setStateOptions
      });
    };
    _proto.cancel = function cancel(options) {
      var _this$retryer;
      var promise = this.promise;
      (_this$retryer = this.retryer) == null ? void 0 : _this$retryer.cancel(options);
      return promise ? promise.then(noop$1).catch(noop$1) : Promise.resolve();
    };
    _proto.destroy = function destroy() {
      this.clearGcTimeout();
      this.cancel({
        silent: true
      });
    };
    _proto.reset = function reset() {
      this.destroy();
      this.setState(this.initialState);
    };
    _proto.isActive = function isActive() {
      return this.observers.some(function(observer) {
        return observer.options.enabled !== false;
      });
    };
    _proto.isFetching = function isFetching() {
      return this.state.isFetching;
    };
    _proto.isStale = function isStale2() {
      return this.state.isInvalidated || !this.state.dataUpdatedAt || this.observers.some(function(observer) {
        return observer.getCurrentResult().isStale;
      });
    };
    _proto.isStaleByTime = function isStaleByTime(staleTime) {
      if (staleTime === void 0) {
        staleTime = 0;
      }
      return this.state.isInvalidated || !this.state.dataUpdatedAt || !timeUntilStale(this.state.dataUpdatedAt, staleTime);
    };
    _proto.onFocus = function onFocus() {
      var _this$retryer2;
      var observer = this.observers.find(function(x2) {
        return x2.shouldFetchOnWindowFocus();
      });
      if (observer) {
        observer.refetch();
      }
      (_this$retryer2 = this.retryer) == null ? void 0 : _this$retryer2.continue();
    };
    _proto.onOnline = function onOnline() {
      var _this$retryer3;
      var observer = this.observers.find(function(x2) {
        return x2.shouldFetchOnReconnect();
      });
      if (observer) {
        observer.refetch();
      }
      (_this$retryer3 = this.retryer) == null ? void 0 : _this$retryer3.continue();
    };
    _proto.addObserver = function addObserver(observer) {
      if (this.observers.indexOf(observer) === -1) {
        this.observers.push(observer);
        this.hadObservers = true;
        this.clearGcTimeout();
        this.cache.notify({
          type: "observerAdded",
          query: this,
          observer
        });
      }
    };
    _proto.removeObserver = function removeObserver(observer) {
      if (this.observers.indexOf(observer) !== -1) {
        this.observers = this.observers.filter(function(x2) {
          return x2 !== observer;
        });
        if (!this.observers.length) {
          if (this.retryer) {
            if (this.retryer.isTransportCancelable || this.abortSignalConsumed) {
              this.retryer.cancel({
                revert: true
              });
            } else {
              this.retryer.cancelRetry();
            }
          }
          if (this.cacheTime) {
            this.scheduleGc();
          } else {
            this.cache.remove(this);
          }
        }
        this.cache.notify({
          type: "observerRemoved",
          query: this,
          observer
        });
      }
    };
    _proto.getObserversCount = function getObserversCount() {
      return this.observers.length;
    };
    _proto.invalidate = function invalidate() {
      if (!this.state.isInvalidated) {
        this.dispatch({
          type: "invalidate"
        });
      }
    };
    _proto.fetch = function fetch2(options, fetchOptions) {
      var _this2 = this, _this$options$behavio, _context$fetchOptions, _abortController$abor;
      if (this.state.isFetching) {
        if (this.state.dataUpdatedAt && (fetchOptions == null ? void 0 : fetchOptions.cancelRefetch)) {
          this.cancel({
            silent: true
          });
        } else if (this.promise) {
          var _this$retryer4;
          (_this$retryer4 = this.retryer) == null ? void 0 : _this$retryer4.continueRetry();
          return this.promise;
        }
      }
      if (options) {
        this.setOptions(options);
      }
      if (!this.options.queryFn) {
        var observer = this.observers.find(function(x2) {
          return x2.options.queryFn;
        });
        if (observer) {
          this.setOptions(observer.options);
        }
      }
      var queryKey = ensureQueryKeyArray(this.queryKey);
      var abortController = getAbortController();
      var queryFnContext = {
        queryKey,
        pageParam: void 0,
        meta: this.meta
      };
      Object.defineProperty(queryFnContext, "signal", {
        enumerable: true,
        get: function get() {
          if (abortController) {
            _this2.abortSignalConsumed = true;
            return abortController.signal;
          }
          return void 0;
        }
      });
      var fetchFn2 = function fetchFn3() {
        if (!_this2.options.queryFn) {
          return Promise.reject("Missing queryFn");
        }
        _this2.abortSignalConsumed = false;
        return _this2.options.queryFn(queryFnContext);
      };
      var context = {
        fetchOptions,
        options: this.options,
        queryKey,
        state: this.state,
        fetchFn: fetchFn2,
        meta: this.meta
      };
      if ((_this$options$behavio = this.options.behavior) == null ? void 0 : _this$options$behavio.onFetch) {
        var _this$options$behavio2;
        (_this$options$behavio2 = this.options.behavior) == null ? void 0 : _this$options$behavio2.onFetch(context);
      }
      this.revertState = this.state;
      if (!this.state.isFetching || this.state.fetchMeta !== ((_context$fetchOptions = context.fetchOptions) == null ? void 0 : _context$fetchOptions.meta)) {
        var _context$fetchOptions2;
        this.dispatch({
          type: "fetch",
          meta: (_context$fetchOptions2 = context.fetchOptions) == null ? void 0 : _context$fetchOptions2.meta
        });
      }
      this.retryer = new Retryer({
        fn: context.fetchFn,
        abort: abortController == null ? void 0 : (_abortController$abor = abortController.abort) == null ? void 0 : _abortController$abor.bind(abortController),
        onSuccess: function onSuccess(data) {
          _this2.setData(data);
          _this2.cache.config.onSuccess == null ? void 0 : _this2.cache.config.onSuccess(data, _this2);
          if (_this2.cacheTime === 0) {
            _this2.optionalRemove();
          }
        },
        onError: function onError(error) {
          if (!(isCancelledError(error) && error.silent)) {
            _this2.dispatch({
              type: "error",
              error
            });
          }
          if (!isCancelledError(error)) {
            _this2.cache.config.onError == null ? void 0 : _this2.cache.config.onError(error, _this2);
            getLogger().error(error);
          }
          if (_this2.cacheTime === 0) {
            _this2.optionalRemove();
          }
        },
        onFail: function onFail() {
          _this2.dispatch({
            type: "failed"
          });
        },
        onPause: function onPause() {
          _this2.dispatch({
            type: "pause"
          });
        },
        onContinue: function onContinue() {
          _this2.dispatch({
            type: "continue"
          });
        },
        retry: context.options.retry,
        retryDelay: context.options.retryDelay
      });
      this.promise = this.retryer.promise;
      return this.promise;
    };
    _proto.dispatch = function dispatch(action) {
      var _this3 = this;
      this.state = this.reducer(this.state, action);
      notifyManager.batch(function() {
        _this3.observers.forEach(function(observer) {
          observer.onQueryUpdate(action);
        });
        _this3.cache.notify({
          query: _this3,
          type: "queryUpdated",
          action
        });
      });
    };
    _proto.getDefaultState = function getDefaultState2(options) {
      var data = typeof options.initialData === "function" ? options.initialData() : options.initialData;
      var hasInitialData = typeof options.initialData !== "undefined";
      var initialDataUpdatedAt = hasInitialData ? typeof options.initialDataUpdatedAt === "function" ? options.initialDataUpdatedAt() : options.initialDataUpdatedAt : 0;
      var hasData = typeof data !== "undefined";
      return {
        data,
        dataUpdateCount: 0,
        dataUpdatedAt: hasData ? initialDataUpdatedAt != null ? initialDataUpdatedAt : Date.now() : 0,
        error: null,
        errorUpdateCount: 0,
        errorUpdatedAt: 0,
        fetchFailureCount: 0,
        fetchMeta: null,
        isFetching: false,
        isInvalidated: false,
        isPaused: false,
        status: hasData ? "success" : "idle"
      };
    };
    _proto.reducer = function reducer2(state, action) {
      var _action$meta, _action$dataUpdatedAt;
      switch (action.type) {
        case "failed":
          return _extends$3({}, state, {
            fetchFailureCount: state.fetchFailureCount + 1
          });
        case "pause":
          return _extends$3({}, state, {
            isPaused: true
          });
        case "continue":
          return _extends$3({}, state, {
            isPaused: false
          });
        case "fetch":
          return _extends$3({}, state, {
            fetchFailureCount: 0,
            fetchMeta: (_action$meta = action.meta) != null ? _action$meta : null,
            isFetching: true,
            isPaused: false
          }, !state.dataUpdatedAt && {
            error: null,
            status: "loading"
          });
        case "success":
          return _extends$3({}, state, {
            data: action.data,
            dataUpdateCount: state.dataUpdateCount + 1,
            dataUpdatedAt: (_action$dataUpdatedAt = action.dataUpdatedAt) != null ? _action$dataUpdatedAt : Date.now(),
            error: null,
            fetchFailureCount: 0,
            isFetching: false,
            isInvalidated: false,
            isPaused: false,
            status: "success"
          });
        case "error":
          var error = action.error;
          if (isCancelledError(error) && error.revert && this.revertState) {
            return _extends$3({}, this.revertState);
          }
          return _extends$3({}, state, {
            error,
            errorUpdateCount: state.errorUpdateCount + 1,
            errorUpdatedAt: Date.now(),
            fetchFailureCount: state.fetchFailureCount + 1,
            isFetching: false,
            isPaused: false,
            status: "error"
          });
        case "invalidate":
          return _extends$3({}, state, {
            isInvalidated: true
          });
        case "setState":
          return _extends$3({}, state, action.state);
        default:
          return state;
      }
    };
    return Query2;
  }();
  var QueryCache = /* @__PURE__ */ function(_Subscribable) {
    _inheritsLoose$1(QueryCache2, _Subscribable);
    function QueryCache2(config2) {
      var _this;
      _this = _Subscribable.call(this) || this;
      _this.config = config2 || {};
      _this.queries = [];
      _this.queriesMap = {};
      return _this;
    }
    var _proto = QueryCache2.prototype;
    _proto.build = function build(client2, options, state) {
      var _options$queryHash;
      var queryKey = options.queryKey;
      var queryHash = (_options$queryHash = options.queryHash) != null ? _options$queryHash : hashQueryKeyByOptions(queryKey, options);
      var query = this.get(queryHash);
      if (!query) {
        query = new Query({
          cache: this,
          queryKey,
          queryHash,
          options: client2.defaultQueryOptions(options),
          state,
          defaultOptions: client2.getQueryDefaults(queryKey),
          meta: options.meta
        });
        this.add(query);
      }
      return query;
    };
    _proto.add = function add(query) {
      if (!this.queriesMap[query.queryHash]) {
        this.queriesMap[query.queryHash] = query;
        this.queries.push(query);
        this.notify({
          type: "queryAdded",
          query
        });
      }
    };
    _proto.remove = function remove2(query) {
      var queryInMap = this.queriesMap[query.queryHash];
      if (queryInMap) {
        query.destroy();
        this.queries = this.queries.filter(function(x2) {
          return x2 !== query;
        });
        if (queryInMap === query) {
          delete this.queriesMap[query.queryHash];
        }
        this.notify({
          type: "queryRemoved",
          query
        });
      }
    };
    _proto.clear = function clear() {
      var _this2 = this;
      notifyManager.batch(function() {
        _this2.queries.forEach(function(query) {
          _this2.remove(query);
        });
      });
    };
    _proto.get = function get(queryHash) {
      return this.queriesMap[queryHash];
    };
    _proto.getAll = function getAll() {
      return this.queries;
    };
    _proto.find = function find2(arg1, arg2) {
      var _parseFilterArgs = parseFilterArgs(arg1, arg2), filters = _parseFilterArgs[0];
      if (typeof filters.exact === "undefined") {
        filters.exact = true;
      }
      return this.queries.find(function(query) {
        return matchQuery(filters, query);
      });
    };
    _proto.findAll = function findAll(arg1, arg2) {
      var _parseFilterArgs2 = parseFilterArgs(arg1, arg2), filters = _parseFilterArgs2[0];
      return Object.keys(filters).length > 0 ? this.queries.filter(function(query) {
        return matchQuery(filters, query);
      }) : this.queries;
    };
    _proto.notify = function notify(event) {
      var _this3 = this;
      notifyManager.batch(function() {
        _this3.listeners.forEach(function(listener) {
          listener(event);
        });
      });
    };
    _proto.onFocus = function onFocus() {
      var _this4 = this;
      notifyManager.batch(function() {
        _this4.queries.forEach(function(query) {
          query.onFocus();
        });
      });
    };
    _proto.onOnline = function onOnline() {
      var _this5 = this;
      notifyManager.batch(function() {
        _this5.queries.forEach(function(query) {
          query.onOnline();
        });
      });
    };
    return QueryCache2;
  }(Subscribable);
  var Mutation = /* @__PURE__ */ function() {
    function Mutation2(config2) {
      this.options = _extends$3({}, config2.defaultOptions, config2.options);
      this.mutationId = config2.mutationId;
      this.mutationCache = config2.mutationCache;
      this.observers = [];
      this.state = config2.state || getDefaultState();
      this.meta = config2.meta;
    }
    var _proto = Mutation2.prototype;
    _proto.setState = function setState(state) {
      this.dispatch({
        type: "setState",
        state
      });
    };
    _proto.addObserver = function addObserver(observer) {
      if (this.observers.indexOf(observer) === -1) {
        this.observers.push(observer);
      }
    };
    _proto.removeObserver = function removeObserver(observer) {
      this.observers = this.observers.filter(function(x2) {
        return x2 !== observer;
      });
    };
    _proto.cancel = function cancel() {
      if (this.retryer) {
        this.retryer.cancel();
        return this.retryer.promise.then(noop$1).catch(noop$1);
      }
      return Promise.resolve();
    };
    _proto.continue = function _continue() {
      if (this.retryer) {
        this.retryer.continue();
        return this.retryer.promise;
      }
      return this.execute();
    };
    _proto.execute = function execute() {
      var _this = this;
      var data;
      var restored = this.state.status === "loading";
      var promise = Promise.resolve();
      if (!restored) {
        this.dispatch({
          type: "loading",
          variables: this.options.variables
        });
        promise = promise.then(function() {
          _this.mutationCache.config.onMutate == null ? void 0 : _this.mutationCache.config.onMutate(_this.state.variables, _this);
        }).then(function() {
          return _this.options.onMutate == null ? void 0 : _this.options.onMutate(_this.state.variables);
        }).then(function(context) {
          if (context !== _this.state.context) {
            _this.dispatch({
              type: "loading",
              context,
              variables: _this.state.variables
            });
          }
        });
      }
      return promise.then(function() {
        return _this.executeMutation();
      }).then(function(result) {
        data = result;
        _this.mutationCache.config.onSuccess == null ? void 0 : _this.mutationCache.config.onSuccess(data, _this.state.variables, _this.state.context, _this);
      }).then(function() {
        return _this.options.onSuccess == null ? void 0 : _this.options.onSuccess(data, _this.state.variables, _this.state.context);
      }).then(function() {
        return _this.options.onSettled == null ? void 0 : _this.options.onSettled(data, null, _this.state.variables, _this.state.context);
      }).then(function() {
        _this.dispatch({
          type: "success",
          data
        });
        return data;
      }).catch(function(error) {
        _this.mutationCache.config.onError == null ? void 0 : _this.mutationCache.config.onError(error, _this.state.variables, _this.state.context, _this);
        getLogger().error(error);
        return Promise.resolve().then(function() {
          return _this.options.onError == null ? void 0 : _this.options.onError(error, _this.state.variables, _this.state.context);
        }).then(function() {
          return _this.options.onSettled == null ? void 0 : _this.options.onSettled(void 0, error, _this.state.variables, _this.state.context);
        }).then(function() {
          _this.dispatch({
            type: "error",
            error
          });
          throw error;
        });
      });
    };
    _proto.executeMutation = function executeMutation() {
      var _this2 = this, _this$options$retry;
      this.retryer = new Retryer({
        fn: function fn() {
          if (!_this2.options.mutationFn) {
            return Promise.reject("No mutationFn found");
          }
          return _this2.options.mutationFn(_this2.state.variables);
        },
        onFail: function onFail() {
          _this2.dispatch({
            type: "failed"
          });
        },
        onPause: function onPause() {
          _this2.dispatch({
            type: "pause"
          });
        },
        onContinue: function onContinue() {
          _this2.dispatch({
            type: "continue"
          });
        },
        retry: (_this$options$retry = this.options.retry) != null ? _this$options$retry : 0,
        retryDelay: this.options.retryDelay
      });
      return this.retryer.promise;
    };
    _proto.dispatch = function dispatch(action) {
      var _this3 = this;
      this.state = reducer(this.state, action);
      notifyManager.batch(function() {
        _this3.observers.forEach(function(observer) {
          observer.onMutationUpdate(action);
        });
        _this3.mutationCache.notify(_this3);
      });
    };
    return Mutation2;
  }();
  function getDefaultState() {
    return {
      context: void 0,
      data: void 0,
      error: null,
      failureCount: 0,
      isPaused: false,
      status: "idle",
      variables: void 0
    };
  }
  function reducer(state, action) {
    switch (action.type) {
      case "failed":
        return _extends$3({}, state, {
          failureCount: state.failureCount + 1
        });
      case "pause":
        return _extends$3({}, state, {
          isPaused: true
        });
      case "continue":
        return _extends$3({}, state, {
          isPaused: false
        });
      case "loading":
        return _extends$3({}, state, {
          context: action.context,
          data: void 0,
          error: null,
          isPaused: false,
          status: "loading",
          variables: action.variables
        });
      case "success":
        return _extends$3({}, state, {
          data: action.data,
          error: null,
          status: "success",
          isPaused: false
        });
      case "error":
        return _extends$3({}, state, {
          data: void 0,
          error: action.error,
          failureCount: state.failureCount + 1,
          isPaused: false,
          status: "error"
        });
      case "setState":
        return _extends$3({}, state, action.state);
      default:
        return state;
    }
  }
  var MutationCache = /* @__PURE__ */ function(_Subscribable) {
    _inheritsLoose$1(MutationCache2, _Subscribable);
    function MutationCache2(config2) {
      var _this;
      _this = _Subscribable.call(this) || this;
      _this.config = config2 || {};
      _this.mutations = [];
      _this.mutationId = 0;
      return _this;
    }
    var _proto = MutationCache2.prototype;
    _proto.build = function build(client2, options, state) {
      var mutation = new Mutation({
        mutationCache: this,
        mutationId: ++this.mutationId,
        options: client2.defaultMutationOptions(options),
        state,
        defaultOptions: options.mutationKey ? client2.getMutationDefaults(options.mutationKey) : void 0,
        meta: options.meta
      });
      this.add(mutation);
      return mutation;
    };
    _proto.add = function add(mutation) {
      this.mutations.push(mutation);
      this.notify(mutation);
    };
    _proto.remove = function remove2(mutation) {
      this.mutations = this.mutations.filter(function(x2) {
        return x2 !== mutation;
      });
      mutation.cancel();
      this.notify(mutation);
    };
    _proto.clear = function clear() {
      var _this2 = this;
      notifyManager.batch(function() {
        _this2.mutations.forEach(function(mutation) {
          _this2.remove(mutation);
        });
      });
    };
    _proto.getAll = function getAll() {
      return this.mutations;
    };
    _proto.find = function find2(filters) {
      if (typeof filters.exact === "undefined") {
        filters.exact = true;
      }
      return this.mutations.find(function(mutation) {
        return matchMutation(filters, mutation);
      });
    };
    _proto.findAll = function findAll(filters) {
      return this.mutations.filter(function(mutation) {
        return matchMutation(filters, mutation);
      });
    };
    _proto.notify = function notify(mutation) {
      var _this3 = this;
      notifyManager.batch(function() {
        _this3.listeners.forEach(function(listener) {
          listener(mutation);
        });
      });
    };
    _proto.onFocus = function onFocus() {
      this.resumePausedMutations();
    };
    _proto.onOnline = function onOnline() {
      this.resumePausedMutations();
    };
    _proto.resumePausedMutations = function resumePausedMutations() {
      var pausedMutations = this.mutations.filter(function(x2) {
        return x2.state.isPaused;
      });
      return notifyManager.batch(function() {
        return pausedMutations.reduce(function(promise, mutation) {
          return promise.then(function() {
            return mutation.continue().catch(noop$1);
          });
        }, Promise.resolve());
      });
    };
    return MutationCache2;
  }(Subscribable);
  function infiniteQueryBehavior() {
    return {
      onFetch: function onFetch(context) {
        context.fetchFn = function() {
          var _context$fetchOptions, _context$fetchOptions2, _context$fetchOptions3, _context$fetchOptions4, _context$state$data, _context$state$data2;
          var refetchPage = (_context$fetchOptions = context.fetchOptions) == null ? void 0 : (_context$fetchOptions2 = _context$fetchOptions.meta) == null ? void 0 : _context$fetchOptions2.refetchPage;
          var fetchMore = (_context$fetchOptions3 = context.fetchOptions) == null ? void 0 : (_context$fetchOptions4 = _context$fetchOptions3.meta) == null ? void 0 : _context$fetchOptions4.fetchMore;
          var pageParam = fetchMore == null ? void 0 : fetchMore.pageParam;
          var isFetchingNextPage = (fetchMore == null ? void 0 : fetchMore.direction) === "forward";
          var isFetchingPreviousPage = (fetchMore == null ? void 0 : fetchMore.direction) === "backward";
          var oldPages = ((_context$state$data = context.state.data) == null ? void 0 : _context$state$data.pages) || [];
          var oldPageParams = ((_context$state$data2 = context.state.data) == null ? void 0 : _context$state$data2.pageParams) || [];
          var abortController = getAbortController();
          var abortSignal = abortController == null ? void 0 : abortController.signal;
          var newPageParams = oldPageParams;
          var cancelled = false;
          var queryFn = context.options.queryFn || function() {
            return Promise.reject("Missing queryFn");
          };
          var buildNewPages = function buildNewPages2(pages, param2, page, previous) {
            newPageParams = previous ? [param2].concat(newPageParams) : [].concat(newPageParams, [param2]);
            return previous ? [page].concat(pages) : [].concat(pages, [page]);
          };
          var fetchPage = function fetchPage2(pages, manual2, param2, previous) {
            if (cancelled) {
              return Promise.reject("Cancelled");
            }
            if (typeof param2 === "undefined" && !manual2 && pages.length) {
              return Promise.resolve(pages);
            }
            var queryFnContext = {
              queryKey: context.queryKey,
              signal: abortSignal,
              pageParam: param2,
              meta: context.meta
            };
            var queryFnResult = queryFn(queryFnContext);
            var promise2 = Promise.resolve(queryFnResult).then(function(page) {
              return buildNewPages(pages, param2, page, previous);
            });
            if (isCancelable(queryFnResult)) {
              var promiseAsAny = promise2;
              promiseAsAny.cancel = queryFnResult.cancel;
            }
            return promise2;
          };
          var promise;
          if (!oldPages.length) {
            promise = fetchPage([]);
          } else if (isFetchingNextPage) {
            var manual = typeof pageParam !== "undefined";
            var param = manual ? pageParam : getNextPageParam(context.options, oldPages);
            promise = fetchPage(oldPages, manual, param);
          } else if (isFetchingPreviousPage) {
            var _manual = typeof pageParam !== "undefined";
            var _param = _manual ? pageParam : getPreviousPageParam(context.options, oldPages);
            promise = fetchPage(oldPages, _manual, _param, true);
          } else {
            (function() {
              newPageParams = [];
              var manual2 = typeof context.options.getNextPageParam === "undefined";
              var shouldFetchFirstPage = refetchPage && oldPages[0] ? refetchPage(oldPages[0], 0, oldPages) : true;
              promise = shouldFetchFirstPage ? fetchPage([], manual2, oldPageParams[0]) : Promise.resolve(buildNewPages([], oldPageParams[0], oldPages[0]));
              var _loop = function _loop2(i3) {
                promise = promise.then(function(pages) {
                  var shouldFetchNextPage = refetchPage && oldPages[i3] ? refetchPage(oldPages[i3], i3, oldPages) : true;
                  if (shouldFetchNextPage) {
                    var _param2 = manual2 ? oldPageParams[i3] : getNextPageParam(context.options, pages);
                    return fetchPage(pages, manual2, _param2);
                  }
                  return Promise.resolve(buildNewPages(pages, oldPageParams[i3], oldPages[i3]));
                });
              };
              for (var i2 = 1; i2 < oldPages.length; i2++) {
                _loop(i2);
              }
            })();
          }
          var finalPromise = promise.then(function(pages) {
            return {
              pages,
              pageParams: newPageParams
            };
          });
          var finalPromiseAsAny = finalPromise;
          finalPromiseAsAny.cancel = function() {
            cancelled = true;
            abortController == null ? void 0 : abortController.abort();
            if (isCancelable(promise)) {
              promise.cancel();
            }
          };
          return finalPromise;
        };
      }
    };
  }
  function getNextPageParam(options, pages) {
    return options.getNextPageParam == null ? void 0 : options.getNextPageParam(pages[pages.length - 1], pages);
  }
  function getPreviousPageParam(options, pages) {
    return options.getPreviousPageParam == null ? void 0 : options.getPreviousPageParam(pages[0], pages);
  }
  var QueryClient = /* @__PURE__ */ function() {
    function QueryClient2(config2) {
      if (config2 === void 0) {
        config2 = {};
      }
      this.queryCache = config2.queryCache || new QueryCache();
      this.mutationCache = config2.mutationCache || new MutationCache();
      this.defaultOptions = config2.defaultOptions || {};
      this.queryDefaults = [];
      this.mutationDefaults = [];
    }
    var _proto = QueryClient2.prototype;
    _proto.mount = function mount() {
      var _this = this;
      this.unsubscribeFocus = focusManager.subscribe(function() {
        if (focusManager.isFocused() && onlineManager.isOnline()) {
          _this.mutationCache.onFocus();
          _this.queryCache.onFocus();
        }
      });
      this.unsubscribeOnline = onlineManager.subscribe(function() {
        if (focusManager.isFocused() && onlineManager.isOnline()) {
          _this.mutationCache.onOnline();
          _this.queryCache.onOnline();
        }
      });
    };
    _proto.unmount = function unmount() {
      var _this$unsubscribeFocu, _this$unsubscribeOnli;
      (_this$unsubscribeFocu = this.unsubscribeFocus) == null ? void 0 : _this$unsubscribeFocu.call(this);
      (_this$unsubscribeOnli = this.unsubscribeOnline) == null ? void 0 : _this$unsubscribeOnli.call(this);
    };
    _proto.isFetching = function isFetching(arg1, arg2) {
      var _parseFilterArgs = parseFilterArgs(arg1, arg2), filters = _parseFilterArgs[0];
      filters.fetching = true;
      return this.queryCache.findAll(filters).length;
    };
    _proto.isMutating = function isMutating(filters) {
      return this.mutationCache.findAll(_extends$3({}, filters, {
        fetching: true
      })).length;
    };
    _proto.getQueryData = function getQueryData(queryKey, filters) {
      var _this$queryCache$find;
      return (_this$queryCache$find = this.queryCache.find(queryKey, filters)) == null ? void 0 : _this$queryCache$find.state.data;
    };
    _proto.getQueriesData = function getQueriesData(queryKeyOrFilters) {
      return this.getQueryCache().findAll(queryKeyOrFilters).map(function(_ref) {
        var queryKey = _ref.queryKey, state = _ref.state;
        var data = state.data;
        return [queryKey, data];
      });
    };
    _proto.setQueryData = function setQueryData(queryKey, updater, options) {
      var parsedOptions = parseQueryArgs(queryKey);
      var defaultedOptions = this.defaultQueryOptions(parsedOptions);
      return this.queryCache.build(this, defaultedOptions).setData(updater, options);
    };
    _proto.setQueriesData = function setQueriesData(queryKeyOrFilters, updater, options) {
      var _this2 = this;
      return notifyManager.batch(function() {
        return _this2.getQueryCache().findAll(queryKeyOrFilters).map(function(_ref2) {
          var queryKey = _ref2.queryKey;
          return [queryKey, _this2.setQueryData(queryKey, updater, options)];
        });
      });
    };
    _proto.getQueryState = function getQueryState(queryKey, filters) {
      var _this$queryCache$find2;
      return (_this$queryCache$find2 = this.queryCache.find(queryKey, filters)) == null ? void 0 : _this$queryCache$find2.state;
    };
    _proto.removeQueries = function removeQueries(arg1, arg2) {
      var _parseFilterArgs2 = parseFilterArgs(arg1, arg2), filters = _parseFilterArgs2[0];
      var queryCache = this.queryCache;
      notifyManager.batch(function() {
        queryCache.findAll(filters).forEach(function(query) {
          queryCache.remove(query);
        });
      });
    };
    _proto.resetQueries = function resetQueries(arg1, arg2, arg3) {
      var _this3 = this;
      var _parseFilterArgs3 = parseFilterArgs(arg1, arg2, arg3), filters = _parseFilterArgs3[0], options = _parseFilterArgs3[1];
      var queryCache = this.queryCache;
      var refetchFilters = _extends$3({}, filters, {
        active: true
      });
      return notifyManager.batch(function() {
        queryCache.findAll(filters).forEach(function(query) {
          query.reset();
        });
        return _this3.refetchQueries(refetchFilters, options);
      });
    };
    _proto.cancelQueries = function cancelQueries(arg1, arg2, arg3) {
      var _this4 = this;
      var _parseFilterArgs4 = parseFilterArgs(arg1, arg2, arg3), filters = _parseFilterArgs4[0], _parseFilterArgs4$ = _parseFilterArgs4[1], cancelOptions = _parseFilterArgs4$ === void 0 ? {} : _parseFilterArgs4$;
      if (typeof cancelOptions.revert === "undefined") {
        cancelOptions.revert = true;
      }
      var promises = notifyManager.batch(function() {
        return _this4.queryCache.findAll(filters).map(function(query) {
          return query.cancel(cancelOptions);
        });
      });
      return Promise.all(promises).then(noop$1).catch(noop$1);
    };
    _proto.invalidateQueries = function invalidateQueries(arg1, arg2, arg3) {
      var _ref3, _filters$refetchActiv, _filters$refetchInact, _this5 = this;
      var _parseFilterArgs5 = parseFilterArgs(arg1, arg2, arg3), filters = _parseFilterArgs5[0], options = _parseFilterArgs5[1];
      var refetchFilters = _extends$3({}, filters, {
        // if filters.refetchActive is not provided and filters.active is explicitly false,
        // e.g. invalidateQueries({ active: false }), we don't want to refetch active queries
        active: (_ref3 = (_filters$refetchActiv = filters.refetchActive) != null ? _filters$refetchActiv : filters.active) != null ? _ref3 : true,
        inactive: (_filters$refetchInact = filters.refetchInactive) != null ? _filters$refetchInact : false
      });
      return notifyManager.batch(function() {
        _this5.queryCache.findAll(filters).forEach(function(query) {
          query.invalidate();
        });
        return _this5.refetchQueries(refetchFilters, options);
      });
    };
    _proto.refetchQueries = function refetchQueries(arg1, arg2, arg3) {
      var _this6 = this;
      var _parseFilterArgs6 = parseFilterArgs(arg1, arg2, arg3), filters = _parseFilterArgs6[0], options = _parseFilterArgs6[1];
      var promises = notifyManager.batch(function() {
        return _this6.queryCache.findAll(filters).map(function(query) {
          return query.fetch(void 0, _extends$3({}, options, {
            meta: {
              refetchPage: filters == null ? void 0 : filters.refetchPage
            }
          }));
        });
      });
      var promise = Promise.all(promises).then(noop$1);
      if (!(options == null ? void 0 : options.throwOnError)) {
        promise = promise.catch(noop$1);
      }
      return promise;
    };
    _proto.fetchQuery = function fetchQuery(arg1, arg2, arg3) {
      var parsedOptions = parseQueryArgs(arg1, arg2, arg3);
      var defaultedOptions = this.defaultQueryOptions(parsedOptions);
      if (typeof defaultedOptions.retry === "undefined") {
        defaultedOptions.retry = false;
      }
      var query = this.queryCache.build(this, defaultedOptions);
      return query.isStaleByTime(defaultedOptions.staleTime) ? query.fetch(defaultedOptions) : Promise.resolve(query.state.data);
    };
    _proto.prefetchQuery = function prefetchQuery(arg1, arg2, arg3) {
      return this.fetchQuery(arg1, arg2, arg3).then(noop$1).catch(noop$1);
    };
    _proto.fetchInfiniteQuery = function fetchInfiniteQuery(arg1, arg2, arg3) {
      var parsedOptions = parseQueryArgs(arg1, arg2, arg3);
      parsedOptions.behavior = infiniteQueryBehavior();
      return this.fetchQuery(parsedOptions);
    };
    _proto.prefetchInfiniteQuery = function prefetchInfiniteQuery(arg1, arg2, arg3) {
      return this.fetchInfiniteQuery(arg1, arg2, arg3).then(noop$1).catch(noop$1);
    };
    _proto.cancelMutations = function cancelMutations() {
      var _this7 = this;
      var promises = notifyManager.batch(function() {
        return _this7.mutationCache.getAll().map(function(mutation) {
          return mutation.cancel();
        });
      });
      return Promise.all(promises).then(noop$1).catch(noop$1);
    };
    _proto.resumePausedMutations = function resumePausedMutations() {
      return this.getMutationCache().resumePausedMutations();
    };
    _proto.executeMutation = function executeMutation(options) {
      return this.mutationCache.build(this, options).execute();
    };
    _proto.getQueryCache = function getQueryCache() {
      return this.queryCache;
    };
    _proto.getMutationCache = function getMutationCache() {
      return this.mutationCache;
    };
    _proto.getDefaultOptions = function getDefaultOptions() {
      return this.defaultOptions;
    };
    _proto.setDefaultOptions = function setDefaultOptions(options) {
      this.defaultOptions = options;
    };
    _proto.setQueryDefaults = function setQueryDefaults(queryKey, options) {
      var result = this.queryDefaults.find(function(x2) {
        return hashQueryKey(queryKey) === hashQueryKey(x2.queryKey);
      });
      if (result) {
        result.defaultOptions = options;
      } else {
        this.queryDefaults.push({
          queryKey,
          defaultOptions: options
        });
      }
    };
    _proto.getQueryDefaults = function getQueryDefaults(queryKey) {
      var _this$queryDefaults$f;
      return queryKey ? (_this$queryDefaults$f = this.queryDefaults.find(function(x2) {
        return partialMatchKey(queryKey, x2.queryKey);
      })) == null ? void 0 : _this$queryDefaults$f.defaultOptions : void 0;
    };
    _proto.setMutationDefaults = function setMutationDefaults(mutationKey, options) {
      var result = this.mutationDefaults.find(function(x2) {
        return hashQueryKey(mutationKey) === hashQueryKey(x2.mutationKey);
      });
      if (result) {
        result.defaultOptions = options;
      } else {
        this.mutationDefaults.push({
          mutationKey,
          defaultOptions: options
        });
      }
    };
    _proto.getMutationDefaults = function getMutationDefaults(mutationKey) {
      var _this$mutationDefault;
      return mutationKey ? (_this$mutationDefault = this.mutationDefaults.find(function(x2) {
        return partialMatchKey(mutationKey, x2.mutationKey);
      })) == null ? void 0 : _this$mutationDefault.defaultOptions : void 0;
    };
    _proto.defaultQueryOptions = function defaultQueryOptions(options) {
      if (options == null ? void 0 : options._defaulted) {
        return options;
      }
      var defaultedOptions = _extends$3({}, this.defaultOptions.queries, this.getQueryDefaults(options == null ? void 0 : options.queryKey), options, {
        _defaulted: true
      });
      if (!defaultedOptions.queryHash && defaultedOptions.queryKey) {
        defaultedOptions.queryHash = hashQueryKeyByOptions(defaultedOptions.queryKey, defaultedOptions);
      }
      return defaultedOptions;
    };
    _proto.defaultQueryObserverOptions = function defaultQueryObserverOptions(options) {
      return this.defaultQueryOptions(options);
    };
    _proto.defaultMutationOptions = function defaultMutationOptions(options) {
      if (options == null ? void 0 : options._defaulted) {
        return options;
      }
      return _extends$3({}, this.defaultOptions.mutations, this.getMutationDefaults(options == null ? void 0 : options.mutationKey), options, {
        _defaulted: true
      });
    };
    _proto.clear = function clear() {
      this.queryCache.clear();
      this.mutationCache.clear();
    };
    return QueryClient2;
  }();
  var QueryObserver = /* @__PURE__ */ function(_Subscribable) {
    _inheritsLoose$1(QueryObserver2, _Subscribable);
    function QueryObserver2(client2, options) {
      var _this;
      _this = _Subscribable.call(this) || this;
      _this.client = client2;
      _this.options = options;
      _this.trackedProps = [];
      _this.selectError = null;
      _this.bindMethods();
      _this.setOptions(options);
      return _this;
    }
    var _proto = QueryObserver2.prototype;
    _proto.bindMethods = function bindMethods() {
      this.remove = this.remove.bind(this);
      this.refetch = this.refetch.bind(this);
    };
    _proto.onSubscribe = function onSubscribe() {
      if (this.listeners.length === 1) {
        this.currentQuery.addObserver(this);
        if (shouldFetchOnMount(this.currentQuery, this.options)) {
          this.executeFetch();
        }
        this.updateTimers();
      }
    };
    _proto.onUnsubscribe = function onUnsubscribe() {
      if (!this.listeners.length) {
        this.destroy();
      }
    };
    _proto.shouldFetchOnReconnect = function shouldFetchOnReconnect() {
      return shouldFetchOn(this.currentQuery, this.options, this.options.refetchOnReconnect);
    };
    _proto.shouldFetchOnWindowFocus = function shouldFetchOnWindowFocus() {
      return shouldFetchOn(this.currentQuery, this.options, this.options.refetchOnWindowFocus);
    };
    _proto.destroy = function destroy() {
      this.listeners = [];
      this.clearTimers();
      this.currentQuery.removeObserver(this);
    };
    _proto.setOptions = function setOptions(options, notifyOptions) {
      var prevOptions = this.options;
      var prevQuery = this.currentQuery;
      this.options = this.client.defaultQueryObserverOptions(options);
      if (typeof this.options.enabled !== "undefined" && typeof this.options.enabled !== "boolean") {
        throw new Error("Expected enabled to be a boolean");
      }
      if (!this.options.queryKey) {
        this.options.queryKey = prevOptions.queryKey;
      }
      this.updateQuery();
      var mounted = this.hasListeners();
      if (mounted && shouldFetchOptionally(this.currentQuery, prevQuery, this.options, prevOptions)) {
        this.executeFetch();
      }
      this.updateResult(notifyOptions);
      if (mounted && (this.currentQuery !== prevQuery || this.options.enabled !== prevOptions.enabled || this.options.staleTime !== prevOptions.staleTime)) {
        this.updateStaleTimeout();
      }
      var nextRefetchInterval = this.computeRefetchInterval();
      if (mounted && (this.currentQuery !== prevQuery || this.options.enabled !== prevOptions.enabled || nextRefetchInterval !== this.currentRefetchInterval)) {
        this.updateRefetchInterval(nextRefetchInterval);
      }
    };
    _proto.getOptimisticResult = function getOptimisticResult(options) {
      var defaultedOptions = this.client.defaultQueryObserverOptions(options);
      var query = this.client.getQueryCache().build(this.client, defaultedOptions);
      return this.createResult(query, defaultedOptions);
    };
    _proto.getCurrentResult = function getCurrentResult() {
      return this.currentResult;
    };
    _proto.trackResult = function trackResult(result, defaultedOptions) {
      var _this2 = this;
      var trackedResult = {};
      var trackProp = function trackProp2(key) {
        if (!_this2.trackedProps.includes(key)) {
          _this2.trackedProps.push(key);
        }
      };
      Object.keys(result).forEach(function(key) {
        Object.defineProperty(trackedResult, key, {
          configurable: false,
          enumerable: true,
          get: function get() {
            trackProp(key);
            return result[key];
          }
        });
      });
      if (defaultedOptions.useErrorBoundary || defaultedOptions.suspense) {
        trackProp("error");
      }
      return trackedResult;
    };
    _proto.getNextResult = function getNextResult(options) {
      var _this3 = this;
      return new Promise(function(resolve, reject) {
        var unsubscribe = _this3.subscribe(function(result) {
          if (!result.isFetching) {
            unsubscribe();
            if (result.isError && (options == null ? void 0 : options.throwOnError)) {
              reject(result.error);
            } else {
              resolve(result);
            }
          }
        });
      });
    };
    _proto.getCurrentQuery = function getCurrentQuery() {
      return this.currentQuery;
    };
    _proto.remove = function remove2() {
      this.client.getQueryCache().remove(this.currentQuery);
    };
    _proto.refetch = function refetch(options) {
      return this.fetch(_extends$3({}, options, {
        meta: {
          refetchPage: options == null ? void 0 : options.refetchPage
        }
      }));
    };
    _proto.fetchOptimistic = function fetchOptimistic(options) {
      var _this4 = this;
      var defaultedOptions = this.client.defaultQueryObserverOptions(options);
      var query = this.client.getQueryCache().build(this.client, defaultedOptions);
      return query.fetch().then(function() {
        return _this4.createResult(query, defaultedOptions);
      });
    };
    _proto.fetch = function fetch2(fetchOptions) {
      var _this5 = this;
      return this.executeFetch(fetchOptions).then(function() {
        _this5.updateResult();
        return _this5.currentResult;
      });
    };
    _proto.executeFetch = function executeFetch(fetchOptions) {
      this.updateQuery();
      var promise = this.currentQuery.fetch(this.options, fetchOptions);
      if (!(fetchOptions == null ? void 0 : fetchOptions.throwOnError)) {
        promise = promise.catch(noop$1);
      }
      return promise;
    };
    _proto.updateStaleTimeout = function updateStaleTimeout() {
      var _this6 = this;
      this.clearStaleTimeout();
      if (isServer || this.currentResult.isStale || !isValidTimeout(this.options.staleTime)) {
        return;
      }
      var time = timeUntilStale(this.currentResult.dataUpdatedAt, this.options.staleTime);
      var timeout = time + 1;
      this.staleTimeoutId = setTimeout(function() {
        if (!_this6.currentResult.isStale) {
          _this6.updateResult();
        }
      }, timeout);
    };
    _proto.computeRefetchInterval = function computeRefetchInterval() {
      var _this$options$refetch;
      return typeof this.options.refetchInterval === "function" ? this.options.refetchInterval(this.currentResult.data, this.currentQuery) : (_this$options$refetch = this.options.refetchInterval) != null ? _this$options$refetch : false;
    };
    _proto.updateRefetchInterval = function updateRefetchInterval(nextInterval) {
      var _this7 = this;
      this.clearRefetchInterval();
      this.currentRefetchInterval = nextInterval;
      if (isServer || this.options.enabled === false || !isValidTimeout(this.currentRefetchInterval) || this.currentRefetchInterval === 0) {
        return;
      }
      this.refetchIntervalId = setInterval(function() {
        if (_this7.options.refetchIntervalInBackground || focusManager.isFocused()) {
          _this7.executeFetch();
        }
      }, this.currentRefetchInterval);
    };
    _proto.updateTimers = function updateTimers() {
      this.updateStaleTimeout();
      this.updateRefetchInterval(this.computeRefetchInterval());
    };
    _proto.clearTimers = function clearTimers() {
      this.clearStaleTimeout();
      this.clearRefetchInterval();
    };
    _proto.clearStaleTimeout = function clearStaleTimeout() {
      if (this.staleTimeoutId) {
        clearTimeout(this.staleTimeoutId);
        this.staleTimeoutId = void 0;
      }
    };
    _proto.clearRefetchInterval = function clearRefetchInterval() {
      if (this.refetchIntervalId) {
        clearInterval(this.refetchIntervalId);
        this.refetchIntervalId = void 0;
      }
    };
    _proto.createResult = function createResult(query, options) {
      var prevQuery = this.currentQuery;
      var prevOptions = this.options;
      var prevResult = this.currentResult;
      var prevResultState = this.currentResultState;
      var prevResultOptions = this.currentResultOptions;
      var queryChange = query !== prevQuery;
      var queryInitialState = queryChange ? query.state : this.currentQueryInitialState;
      var prevQueryResult = queryChange ? this.currentResult : this.previousQueryResult;
      var state = query.state;
      var dataUpdatedAt = state.dataUpdatedAt, error = state.error, errorUpdatedAt = state.errorUpdatedAt, isFetching = state.isFetching, status = state.status;
      var isPreviousData = false;
      var isPlaceholderData = false;
      var data;
      if (options.optimisticResults) {
        var mounted = this.hasListeners();
        var fetchOnMount = !mounted && shouldFetchOnMount(query, options);
        var fetchOptionally = mounted && shouldFetchOptionally(query, prevQuery, options, prevOptions);
        if (fetchOnMount || fetchOptionally) {
          isFetching = true;
          if (!dataUpdatedAt) {
            status = "loading";
          }
        }
      }
      if (options.keepPreviousData && !state.dataUpdateCount && (prevQueryResult == null ? void 0 : prevQueryResult.isSuccess) && status !== "error") {
        data = prevQueryResult.data;
        dataUpdatedAt = prevQueryResult.dataUpdatedAt;
        status = prevQueryResult.status;
        isPreviousData = true;
      } else if (options.select && typeof state.data !== "undefined") {
        if (prevResult && state.data === (prevResultState == null ? void 0 : prevResultState.data) && options.select === this.selectFn) {
          data = this.selectResult;
        } else {
          try {
            this.selectFn = options.select;
            data = options.select(state.data);
            if (options.structuralSharing !== false) {
              data = replaceEqualDeep(prevResult == null ? void 0 : prevResult.data, data);
            }
            this.selectResult = data;
            this.selectError = null;
          } catch (selectError) {
            getLogger().error(selectError);
            this.selectError = selectError;
          }
        }
      } else {
        data = state.data;
      }
      if (typeof options.placeholderData !== "undefined" && typeof data === "undefined" && (status === "loading" || status === "idle")) {
        var placeholderData;
        if ((prevResult == null ? void 0 : prevResult.isPlaceholderData) && options.placeholderData === (prevResultOptions == null ? void 0 : prevResultOptions.placeholderData)) {
          placeholderData = prevResult.data;
        } else {
          placeholderData = typeof options.placeholderData === "function" ? options.placeholderData() : options.placeholderData;
          if (options.select && typeof placeholderData !== "undefined") {
            try {
              placeholderData = options.select(placeholderData);
              if (options.structuralSharing !== false) {
                placeholderData = replaceEqualDeep(prevResult == null ? void 0 : prevResult.data, placeholderData);
              }
              this.selectError = null;
            } catch (selectError) {
              getLogger().error(selectError);
              this.selectError = selectError;
            }
          }
        }
        if (typeof placeholderData !== "undefined") {
          status = "success";
          data = placeholderData;
          isPlaceholderData = true;
        }
      }
      if (this.selectError) {
        error = this.selectError;
        data = this.selectResult;
        errorUpdatedAt = Date.now();
        status = "error";
      }
      var result = {
        status,
        isLoading: status === "loading",
        isSuccess: status === "success",
        isError: status === "error",
        isIdle: status === "idle",
        data,
        dataUpdatedAt,
        error,
        errorUpdatedAt,
        failureCount: state.fetchFailureCount,
        errorUpdateCount: state.errorUpdateCount,
        isFetched: state.dataUpdateCount > 0 || state.errorUpdateCount > 0,
        isFetchedAfterMount: state.dataUpdateCount > queryInitialState.dataUpdateCount || state.errorUpdateCount > queryInitialState.errorUpdateCount,
        isFetching,
        isRefetching: isFetching && status !== "loading",
        isLoadingError: status === "error" && state.dataUpdatedAt === 0,
        isPlaceholderData,
        isPreviousData,
        isRefetchError: status === "error" && state.dataUpdatedAt !== 0,
        isStale: isStale(query, options),
        refetch: this.refetch,
        remove: this.remove
      };
      return result;
    };
    _proto.shouldNotifyListeners = function shouldNotifyListeners(result, prevResult) {
      if (!prevResult) {
        return true;
      }
      var _this$options = this.options, notifyOnChangeProps = _this$options.notifyOnChangeProps, notifyOnChangePropsExclusions = _this$options.notifyOnChangePropsExclusions;
      if (!notifyOnChangeProps && !notifyOnChangePropsExclusions) {
        return true;
      }
      if (notifyOnChangeProps === "tracked" && !this.trackedProps.length) {
        return true;
      }
      var includedProps = notifyOnChangeProps === "tracked" ? this.trackedProps : notifyOnChangeProps;
      return Object.keys(result).some(function(key) {
        var typedKey = key;
        var changed = result[typedKey] !== prevResult[typedKey];
        var isIncluded = includedProps == null ? void 0 : includedProps.some(function(x2) {
          return x2 === key;
        });
        var isExcluded = notifyOnChangePropsExclusions == null ? void 0 : notifyOnChangePropsExclusions.some(function(x2) {
          return x2 === key;
        });
        return changed && !isExcluded && (!includedProps || isIncluded);
      });
    };
    _proto.updateResult = function updateResult(notifyOptions) {
      var prevResult = this.currentResult;
      this.currentResult = this.createResult(this.currentQuery, this.options);
      this.currentResultState = this.currentQuery.state;
      this.currentResultOptions = this.options;
      if (shallowEqualObjects(this.currentResult, prevResult)) {
        return;
      }
      var defaultNotifyOptions = {
        cache: true
      };
      if ((notifyOptions == null ? void 0 : notifyOptions.listeners) !== false && this.shouldNotifyListeners(this.currentResult, prevResult)) {
        defaultNotifyOptions.listeners = true;
      }
      this.notify(_extends$3({}, defaultNotifyOptions, notifyOptions));
    };
    _proto.updateQuery = function updateQuery() {
      var query = this.client.getQueryCache().build(this.client, this.options);
      if (query === this.currentQuery) {
        return;
      }
      var prevQuery = this.currentQuery;
      this.currentQuery = query;
      this.currentQueryInitialState = query.state;
      this.previousQueryResult = this.currentResult;
      if (this.hasListeners()) {
        prevQuery == null ? void 0 : prevQuery.removeObserver(this);
        query.addObserver(this);
      }
    };
    _proto.onQueryUpdate = function onQueryUpdate(action) {
      var notifyOptions = {};
      if (action.type === "success") {
        notifyOptions.onSuccess = true;
      } else if (action.type === "error" && !isCancelledError(action.error)) {
        notifyOptions.onError = true;
      }
      this.updateResult(notifyOptions);
      if (this.hasListeners()) {
        this.updateTimers();
      }
    };
    _proto.notify = function notify(notifyOptions) {
      var _this8 = this;
      notifyManager.batch(function() {
        if (notifyOptions.onSuccess) {
          _this8.options.onSuccess == null ? void 0 : _this8.options.onSuccess(_this8.currentResult.data);
          _this8.options.onSettled == null ? void 0 : _this8.options.onSettled(_this8.currentResult.data, null);
        } else if (notifyOptions.onError) {
          _this8.options.onError == null ? void 0 : _this8.options.onError(_this8.currentResult.error);
          _this8.options.onSettled == null ? void 0 : _this8.options.onSettled(void 0, _this8.currentResult.error);
        }
        if (notifyOptions.listeners) {
          _this8.listeners.forEach(function(listener) {
            listener(_this8.currentResult);
          });
        }
        if (notifyOptions.cache) {
          _this8.client.getQueryCache().notify({
            query: _this8.currentQuery,
            type: "observerResultsUpdated"
          });
        }
      });
    };
    return QueryObserver2;
  }(Subscribable);
  function shouldLoadOnMount(query, options) {
    return options.enabled !== false && !query.state.dataUpdatedAt && !(query.state.status === "error" && options.retryOnMount === false);
  }
  function shouldFetchOnMount(query, options) {
    return shouldLoadOnMount(query, options) || query.state.dataUpdatedAt > 0 && shouldFetchOn(query, options, options.refetchOnMount);
  }
  function shouldFetchOn(query, options, field) {
    if (options.enabled !== false) {
      var value = typeof field === "function" ? field(query) : field;
      return value === "always" || value !== false && isStale(query, options);
    }
    return false;
  }
  function shouldFetchOptionally(query, prevQuery, options, prevOptions) {
    return options.enabled !== false && (query !== prevQuery || prevOptions.enabled === false) && (!options.suspense || query.state.status !== "error") && isStale(query, options);
  }
  function isStale(query, options) {
    return query.isStaleByTime(options.staleTime);
  }
  var MutationObserver$1 = /* @__PURE__ */ function(_Subscribable) {
    _inheritsLoose$1(MutationObserver2, _Subscribable);
    function MutationObserver2(client2, options) {
      var _this;
      _this = _Subscribable.call(this) || this;
      _this.client = client2;
      _this.setOptions(options);
      _this.bindMethods();
      _this.updateResult();
      return _this;
    }
    var _proto = MutationObserver2.prototype;
    _proto.bindMethods = function bindMethods() {
      this.mutate = this.mutate.bind(this);
      this.reset = this.reset.bind(this);
    };
    _proto.setOptions = function setOptions(options) {
      this.options = this.client.defaultMutationOptions(options);
    };
    _proto.onUnsubscribe = function onUnsubscribe() {
      if (!this.listeners.length) {
        var _this$currentMutation;
        (_this$currentMutation = this.currentMutation) == null ? void 0 : _this$currentMutation.removeObserver(this);
      }
    };
    _proto.onMutationUpdate = function onMutationUpdate(action) {
      this.updateResult();
      var notifyOptions = {
        listeners: true
      };
      if (action.type === "success") {
        notifyOptions.onSuccess = true;
      } else if (action.type === "error") {
        notifyOptions.onError = true;
      }
      this.notify(notifyOptions);
    };
    _proto.getCurrentResult = function getCurrentResult() {
      return this.currentResult;
    };
    _proto.reset = function reset() {
      this.currentMutation = void 0;
      this.updateResult();
      this.notify({
        listeners: true
      });
    };
    _proto.mutate = function mutate(variables, options) {
      this.mutateOptions = options;
      if (this.currentMutation) {
        this.currentMutation.removeObserver(this);
      }
      this.currentMutation = this.client.getMutationCache().build(this.client, _extends$3({}, this.options, {
        variables: typeof variables !== "undefined" ? variables : this.options.variables
      }));
      this.currentMutation.addObserver(this);
      return this.currentMutation.execute();
    };
    _proto.updateResult = function updateResult() {
      var state = this.currentMutation ? this.currentMutation.state : getDefaultState();
      var result = _extends$3({}, state, {
        isLoading: state.status === "loading",
        isSuccess: state.status === "success",
        isError: state.status === "error",
        isIdle: state.status === "idle",
        mutate: this.mutate,
        reset: this.reset
      });
      this.currentResult = result;
    };
    _proto.notify = function notify(options) {
      var _this2 = this;
      notifyManager.batch(function() {
        if (_this2.mutateOptions) {
          if (options.onSuccess) {
            _this2.mutateOptions.onSuccess == null ? void 0 : _this2.mutateOptions.onSuccess(_this2.currentResult.data, _this2.currentResult.variables, _this2.currentResult.context);
            _this2.mutateOptions.onSettled == null ? void 0 : _this2.mutateOptions.onSettled(_this2.currentResult.data, null, _this2.currentResult.variables, _this2.currentResult.context);
          } else if (options.onError) {
            _this2.mutateOptions.onError == null ? void 0 : _this2.mutateOptions.onError(_this2.currentResult.error, _this2.currentResult.variables, _this2.currentResult.context);
            _this2.mutateOptions.onSettled == null ? void 0 : _this2.mutateOptions.onSettled(void 0, _this2.currentResult.error, _this2.currentResult.variables, _this2.currentResult.context);
          }
        }
        if (options.listeners) {
          _this2.listeners.forEach(function(listener) {
            listener(_this2.currentResult);
          });
        }
      });
    };
    return MutationObserver2;
  }(Subscribable);
  var reactDom = { exports: {} };
  var reactDom_production_min = {};
  var scheduler$1 = { exports: {} };
  var scheduler_production_min = {};
  /**
   * @license React
   * scheduler.production.min.js
   *
   * Copyright (c) Facebook, Inc. and its affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var hasRequiredScheduler_production_min;
  function requireScheduler_production_min() {
    if (hasRequiredScheduler_production_min)
      return scheduler_production_min;
    hasRequiredScheduler_production_min = 1;
    (function(exports3) {
      function f(a2, b) {
        var c2 = a2.length;
        a2.push(b);
        a:
          for (; 0 < c2; ) {
            var d = c2 - 1 >>> 1, e = a2[d];
            if (0 < g(e, b))
              a2[d] = b, a2[c2] = e, c2 = d;
            else
              break a;
          }
      }
      function h(a2) {
        return 0 === a2.length ? null : a2[0];
      }
      function k(a2) {
        if (0 === a2.length)
          return null;
        var b = a2[0], c2 = a2.pop();
        if (c2 !== b) {
          a2[0] = c2;
          a:
            for (var d = 0, e = a2.length, w = e >>> 1; d < w; ) {
              var m2 = 2 * (d + 1) - 1, C2 = a2[m2], n = m2 + 1, x2 = a2[n];
              if (0 > g(C2, c2))
                n < e && 0 > g(x2, C2) ? (a2[d] = x2, a2[n] = c2, d = n) : (a2[d] = C2, a2[m2] = c2, d = m2);
              else if (n < e && 0 > g(x2, c2))
                a2[d] = x2, a2[n] = c2, d = n;
              else
                break a;
            }
        }
        return b;
      }
      function g(a2, b) {
        var c2 = a2.sortIndex - b.sortIndex;
        return 0 !== c2 ? c2 : a2.id - b.id;
      }
      if ("object" === typeof performance && "function" === typeof performance.now) {
        var l = performance;
        exports3.unstable_now = function() {
          return l.now();
        };
      } else {
        var p2 = Date, q2 = p2.now();
        exports3.unstable_now = function() {
          return p2.now() - q2;
        };
      }
      var r2 = [], t2 = [], u = 1, v2 = null, y = 3, z = false, A2 = false, B = false, D = "function" === typeof setTimeout ? setTimeout : null, E2 = "function" === typeof clearTimeout ? clearTimeout : null, F = "undefined" !== typeof setImmediate ? setImmediate : null;
      "undefined" !== typeof navigator && void 0 !== navigator.scheduling && void 0 !== navigator.scheduling.isInputPending && navigator.scheduling.isInputPending.bind(navigator.scheduling);
      function G2(a2) {
        for (var b = h(t2); null !== b; ) {
          if (null === b.callback)
            k(t2);
          else if (b.startTime <= a2)
            k(t2), b.sortIndex = b.expirationTime, f(r2, b);
          else
            break;
          b = h(t2);
        }
      }
      function H2(a2) {
        B = false;
        G2(a2);
        if (!A2)
          if (null !== h(r2))
            A2 = true, I(J);
          else {
            var b = h(t2);
            null !== b && K(H2, b.startTime - a2);
          }
      }
      function J(a2, b) {
        A2 = false;
        B && (B = false, E2(L2), L2 = -1);
        z = true;
        var c2 = y;
        try {
          G2(b);
          for (v2 = h(r2); null !== v2 && (!(v2.expirationTime > b) || a2 && !M2()); ) {
            var d = v2.callback;
            if ("function" === typeof d) {
              v2.callback = null;
              y = v2.priorityLevel;
              var e = d(v2.expirationTime <= b);
              b = exports3.unstable_now();
              "function" === typeof e ? v2.callback = e : v2 === h(r2) && k(r2);
              G2(b);
            } else
              k(r2);
            v2 = h(r2);
          }
          if (null !== v2)
            var w = true;
          else {
            var m2 = h(t2);
            null !== m2 && K(H2, m2.startTime - b);
            w = false;
          }
          return w;
        } finally {
          v2 = null, y = c2, z = false;
        }
      }
      var N = false, O = null, L2 = -1, P2 = 5, Q2 = -1;
      function M2() {
        return exports3.unstable_now() - Q2 < P2 ? false : true;
      }
      function R() {
        if (null !== O) {
          var a2 = exports3.unstable_now();
          Q2 = a2;
          var b = true;
          try {
            b = O(true, a2);
          } finally {
            b ? S() : (N = false, O = null);
          }
        } else
          N = false;
      }
      var S;
      if ("function" === typeof F)
        S = function() {
          F(R);
        };
      else if ("undefined" !== typeof MessageChannel) {
        var T = new MessageChannel(), U2 = T.port2;
        T.port1.onmessage = R;
        S = function() {
          U2.postMessage(null);
        };
      } else
        S = function() {
          D(R, 0);
        };
      function I(a2) {
        O = a2;
        N || (N = true, S());
      }
      function K(a2, b) {
        L2 = D(function() {
          a2(exports3.unstable_now());
        }, b);
      }
      exports3.unstable_IdlePriority = 5;
      exports3.unstable_ImmediatePriority = 1;
      exports3.unstable_LowPriority = 4;
      exports3.unstable_NormalPriority = 3;
      exports3.unstable_Profiling = null;
      exports3.unstable_UserBlockingPriority = 2;
      exports3.unstable_cancelCallback = function(a2) {
        a2.callback = null;
      };
      exports3.unstable_continueExecution = function() {
        A2 || z || (A2 = true, I(J));
      };
      exports3.unstable_forceFrameRate = function(a2) {
        0 > a2 || 125 < a2 ? console.error("forceFrameRate takes a positive int between 0 and 125, forcing frame rates higher than 125 fps is not supported") : P2 = 0 < a2 ? Math.floor(1e3 / a2) : 5;
      };
      exports3.unstable_getCurrentPriorityLevel = function() {
        return y;
      };
      exports3.unstable_getFirstCallbackNode = function() {
        return h(r2);
      };
      exports3.unstable_next = function(a2) {
        switch (y) {
          case 1:
          case 2:
          case 3:
            var b = 3;
            break;
          default:
            b = y;
        }
        var c2 = y;
        y = b;
        try {
          return a2();
        } finally {
          y = c2;
        }
      };
      exports3.unstable_pauseExecution = function() {
      };
      exports3.unstable_requestPaint = function() {
      };
      exports3.unstable_runWithPriority = function(a2, b) {
        switch (a2) {
          case 1:
          case 2:
          case 3:
          case 4:
          case 5:
            break;
          default:
            a2 = 3;
        }
        var c2 = y;
        y = a2;
        try {
          return b();
        } finally {
          y = c2;
        }
      };
      exports3.unstable_scheduleCallback = function(a2, b, c2) {
        var d = exports3.unstable_now();
        "object" === typeof c2 && null !== c2 ? (c2 = c2.delay, c2 = "number" === typeof c2 && 0 < c2 ? d + c2 : d) : c2 = d;
        switch (a2) {
          case 1:
            var e = -1;
            break;
          case 2:
            e = 250;
            break;
          case 5:
            e = 1073741823;
            break;
          case 4:
            e = 1e4;
            break;
          default:
            e = 5e3;
        }
        e = c2 + e;
        a2 = { id: u++, callback: b, priorityLevel: a2, startTime: c2, expirationTime: e, sortIndex: -1 };
        c2 > d ? (a2.sortIndex = c2, f(t2, a2), null === h(r2) && a2 === h(t2) && (B ? (E2(L2), L2 = -1) : B = true, K(H2, c2 - d))) : (a2.sortIndex = e, f(r2, a2), A2 || z || (A2 = true, I(J)));
        return a2;
      };
      exports3.unstable_shouldYield = M2;
      exports3.unstable_wrapCallback = function(a2) {
        var b = y;
        return function() {
          var c2 = y;
          y = b;
          try {
            return a2.apply(this, arguments);
          } finally {
            y = c2;
          }
        };
      };
    })(scheduler_production_min);
    return scheduler_production_min;
  }
  var hasRequiredScheduler;
  function requireScheduler() {
    if (hasRequiredScheduler)
      return scheduler$1.exports;
    hasRequiredScheduler = 1;
    {
      scheduler$1.exports = requireScheduler_production_min();
    }
    return scheduler$1.exports;
  }
  /**
   * @license React
   * react-dom.production.min.js
   *
   * Copyright (c) Facebook, Inc. and its affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */
  var hasRequiredReactDom_production_min;
  function requireReactDom_production_min() {
    if (hasRequiredReactDom_production_min)
      return reactDom_production_min;
    hasRequiredReactDom_production_min = 1;
    var aa = requireReact(), ca = requireScheduler();
    function p2(a2) {
      for (var b = "https://reactjs.org/docs/error-decoder.html?invariant=" + a2, c2 = 1; c2 < arguments.length; c2++)
        b += "&args[]=" + encodeURIComponent(arguments[c2]);
      return "Minified React error #" + a2 + "; visit " + b + " for the full message or use the non-minified dev environment for full errors and additional helpful warnings.";
    }
    var da = /* @__PURE__ */ new Set(), ea = {};
    function fa(a2, b) {
      ha(a2, b);
      ha(a2 + "Capture", b);
    }
    function ha(a2, b) {
      ea[a2] = b;
      for (a2 = 0; a2 < b.length; a2++)
        da.add(b[a2]);
    }
    var ia = !("undefined" === typeof window || "undefined" === typeof window.document || "undefined" === typeof window.document.createElement), ja = Object.prototype.hasOwnProperty, ka = /^[:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD][:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*$/, la = {}, ma = {};
    function oa(a2) {
      if (ja.call(ma, a2))
        return true;
      if (ja.call(la, a2))
        return false;
      if (ka.test(a2))
        return ma[a2] = true;
      la[a2] = true;
      return false;
    }
    function pa(a2, b, c2, d) {
      if (null !== c2 && 0 === c2.type)
        return false;
      switch (typeof b) {
        case "function":
        case "symbol":
          return true;
        case "boolean":
          if (d)
            return false;
          if (null !== c2)
            return !c2.acceptsBooleans;
          a2 = a2.toLowerCase().slice(0, 5);
          return "data-" !== a2 && "aria-" !== a2;
        default:
          return false;
      }
    }
    function qa(a2, b, c2, d) {
      if (null === b || "undefined" === typeof b || pa(a2, b, c2, d))
        return true;
      if (d)
        return false;
      if (null !== c2)
        switch (c2.type) {
          case 3:
            return !b;
          case 4:
            return false === b;
          case 5:
            return isNaN(b);
          case 6:
            return isNaN(b) || 1 > b;
        }
      return false;
    }
    function v2(a2, b, c2, d, e, f, g) {
      this.acceptsBooleans = 2 === b || 3 === b || 4 === b;
      this.attributeName = d;
      this.attributeNamespace = e;
      this.mustUseProperty = c2;
      this.propertyName = a2;
      this.type = b;
      this.sanitizeURL = f;
      this.removeEmptyString = g;
    }
    var z = {};
    "children dangerouslySetInnerHTML defaultValue defaultChecked innerHTML suppressContentEditableWarning suppressHydrationWarning style".split(" ").forEach(function(a2) {
      z[a2] = new v2(a2, 0, false, a2, null, false, false);
    });
    [["acceptCharset", "accept-charset"], ["className", "class"], ["htmlFor", "for"], ["httpEquiv", "http-equiv"]].forEach(function(a2) {
      var b = a2[0];
      z[b] = new v2(b, 1, false, a2[1], null, false, false);
    });
    ["contentEditable", "draggable", "spellCheck", "value"].forEach(function(a2) {
      z[a2] = new v2(a2, 2, false, a2.toLowerCase(), null, false, false);
    });
    ["autoReverse", "externalResourcesRequired", "focusable", "preserveAlpha"].forEach(function(a2) {
      z[a2] = new v2(a2, 2, false, a2, null, false, false);
    });
    "allowFullScreen async autoFocus autoPlay controls default defer disabled disablePictureInPicture disableRemotePlayback formNoValidate hidden loop noModule noValidate open playsInline readOnly required reversed scoped seamless itemScope".split(" ").forEach(function(a2) {
      z[a2] = new v2(a2, 3, false, a2.toLowerCase(), null, false, false);
    });
    ["checked", "multiple", "muted", "selected"].forEach(function(a2) {
      z[a2] = new v2(a2, 3, true, a2, null, false, false);
    });
    ["capture", "download"].forEach(function(a2) {
      z[a2] = new v2(a2, 4, false, a2, null, false, false);
    });
    ["cols", "rows", "size", "span"].forEach(function(a2) {
      z[a2] = new v2(a2, 6, false, a2, null, false, false);
    });
    ["rowSpan", "start"].forEach(function(a2) {
      z[a2] = new v2(a2, 5, false, a2.toLowerCase(), null, false, false);
    });
    var ra = /[\-:]([a-z])/g;
    function sa(a2) {
      return a2[1].toUpperCase();
    }
    "accent-height alignment-baseline arabic-form baseline-shift cap-height clip-path clip-rule color-interpolation color-interpolation-filters color-profile color-rendering dominant-baseline enable-background fill-opacity fill-rule flood-color flood-opacity font-family font-size font-size-adjust font-stretch font-style font-variant font-weight glyph-name glyph-orientation-horizontal glyph-orientation-vertical horiz-adv-x horiz-origin-x image-rendering letter-spacing lighting-color marker-end marker-mid marker-start overline-position overline-thickness paint-order panose-1 pointer-events rendering-intent shape-rendering stop-color stop-opacity strikethrough-position strikethrough-thickness stroke-dasharray stroke-dashoffset stroke-linecap stroke-linejoin stroke-miterlimit stroke-opacity stroke-width text-anchor text-decoration text-rendering underline-position underline-thickness unicode-bidi unicode-range units-per-em v-alphabetic v-hanging v-ideographic v-mathematical vector-effect vert-adv-y vert-origin-x vert-origin-y word-spacing writing-mode xmlns:xlink x-height".split(" ").forEach(function(a2) {
      var b = a2.replace(
        ra,
        sa
      );
      z[b] = new v2(b, 1, false, a2, null, false, false);
    });
    "xlink:actuate xlink:arcrole xlink:role xlink:show xlink:title xlink:type".split(" ").forEach(function(a2) {
      var b = a2.replace(ra, sa);
      z[b] = new v2(b, 1, false, a2, "http://www.w3.org/1999/xlink", false, false);
    });
    ["xml:base", "xml:lang", "xml:space"].forEach(function(a2) {
      var b = a2.replace(ra, sa);
      z[b] = new v2(b, 1, false, a2, "http://www.w3.org/XML/1998/namespace", false, false);
    });
    ["tabIndex", "crossOrigin"].forEach(function(a2) {
      z[a2] = new v2(a2, 1, false, a2.toLowerCase(), null, false, false);
    });
    z.xlinkHref = new v2("xlinkHref", 1, false, "xlink:href", "http://www.w3.org/1999/xlink", true, false);
    ["src", "href", "action", "formAction"].forEach(function(a2) {
      z[a2] = new v2(a2, 1, false, a2.toLowerCase(), null, true, true);
    });
    function ta(a2, b, c2, d) {
      var e = z.hasOwnProperty(b) ? z[b] : null;
      if (null !== e ? 0 !== e.type : d || !(2 < b.length) || "o" !== b[0] && "O" !== b[0] || "n" !== b[1] && "N" !== b[1])
        qa(b, c2, e, d) && (c2 = null), d || null === e ? oa(b) && (null === c2 ? a2.removeAttribute(b) : a2.setAttribute(b, "" + c2)) : e.mustUseProperty ? a2[e.propertyName] = null === c2 ? 3 === e.type ? false : "" : c2 : (b = e.attributeName, d = e.attributeNamespace, null === c2 ? a2.removeAttribute(b) : (e = e.type, c2 = 3 === e || 4 === e && true === c2 ? "" : "" + c2, d ? a2.setAttributeNS(d, b, c2) : a2.setAttribute(b, c2)));
    }
    var ua = aa.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED, va = Symbol.for("react.element"), wa = Symbol.for("react.portal"), ya = Symbol.for("react.fragment"), za = Symbol.for("react.strict_mode"), Aa = Symbol.for("react.profiler"), Ba = Symbol.for("react.provider"), Ca = Symbol.for("react.context"), Da = Symbol.for("react.forward_ref"), Ea = Symbol.for("react.suspense"), Fa = Symbol.for("react.suspense_list"), Ga = Symbol.for("react.memo"), Ha = Symbol.for("react.lazy");
    var Ia = Symbol.for("react.offscreen");
    var Ja = Symbol.iterator;
    function Ka(a2) {
      if (null === a2 || "object" !== typeof a2)
        return null;
      a2 = Ja && a2[Ja] || a2["@@iterator"];
      return "function" === typeof a2 ? a2 : null;
    }
    var A2 = Object.assign, La;
    function Ma(a2) {
      if (void 0 === La)
        try {
          throw Error();
        } catch (c2) {
          var b = c2.stack.trim().match(/\n( *(at )?)/);
          La = b && b[1] || "";
        }
      return "\n" + La + a2;
    }
    var Na = false;
    function Oa(a2, b) {
      if (!a2 || Na)
        return "";
      Na = true;
      var c2 = Error.prepareStackTrace;
      Error.prepareStackTrace = void 0;
      try {
        if (b)
          if (b = function() {
            throw Error();
          }, Object.defineProperty(b.prototype, "props", { set: function() {
            throw Error();
          } }), "object" === typeof Reflect && Reflect.construct) {
            try {
              Reflect.construct(b, []);
            } catch (l) {
              var d = l;
            }
            Reflect.construct(a2, [], b);
          } else {
            try {
              b.call();
            } catch (l) {
              d = l;
            }
            a2.call(b.prototype);
          }
        else {
          try {
            throw Error();
          } catch (l) {
            d = l;
          }
          a2();
        }
      } catch (l) {
        if (l && d && "string" === typeof l.stack) {
          for (var e = l.stack.split("\n"), f = d.stack.split("\n"), g = e.length - 1, h = f.length - 1; 1 <= g && 0 <= h && e[g] !== f[h]; )
            h--;
          for (; 1 <= g && 0 <= h; g--, h--)
            if (e[g] !== f[h]) {
              if (1 !== g || 1 !== h) {
                do
                  if (g--, h--, 0 > h || e[g] !== f[h]) {
                    var k = "\n" + e[g].replace(" at new ", " at ");
                    a2.displayName && k.includes("<anonymous>") && (k = k.replace("<anonymous>", a2.displayName));
                    return k;
                  }
                while (1 <= g && 0 <= h);
              }
              break;
            }
        }
      } finally {
        Na = false, Error.prepareStackTrace = c2;
      }
      return (a2 = a2 ? a2.displayName || a2.name : "") ? Ma(a2) : "";
    }
    function Pa(a2) {
      switch (a2.tag) {
        case 5:
          return Ma(a2.type);
        case 16:
          return Ma("Lazy");
        case 13:
          return Ma("Suspense");
        case 19:
          return Ma("SuspenseList");
        case 0:
        case 2:
        case 15:
          return a2 = Oa(a2.type, false), a2;
        case 11:
          return a2 = Oa(a2.type.render, false), a2;
        case 1:
          return a2 = Oa(a2.type, true), a2;
        default:
          return "";
      }
    }
    function Qa(a2) {
      if (null == a2)
        return null;
      if ("function" === typeof a2)
        return a2.displayName || a2.name || null;
      if ("string" === typeof a2)
        return a2;
      switch (a2) {
        case ya:
          return "Fragment";
        case wa:
          return "Portal";
        case Aa:
          return "Profiler";
        case za:
          return "StrictMode";
        case Ea:
          return "Suspense";
        case Fa:
          return "SuspenseList";
      }
      if ("object" === typeof a2)
        switch (a2.$$typeof) {
          case Ca:
            return (a2.displayName || "Context") + ".Consumer";
          case Ba:
            return (a2._context.displayName || "Context") + ".Provider";
          case Da:
            var b = a2.render;
            a2 = a2.displayName;
            a2 || (a2 = b.displayName || b.name || "", a2 = "" !== a2 ? "ForwardRef(" + a2 + ")" : "ForwardRef");
            return a2;
          case Ga:
            return b = a2.displayName || null, null !== b ? b : Qa(a2.type) || "Memo";
          case Ha:
            b = a2._payload;
            a2 = a2._init;
            try {
              return Qa(a2(b));
            } catch (c2) {
            }
        }
      return null;
    }
    function Ra(a2) {
      var b = a2.type;
      switch (a2.tag) {
        case 24:
          return "Cache";
        case 9:
          return (b.displayName || "Context") + ".Consumer";
        case 10:
          return (b._context.displayName || "Context") + ".Provider";
        case 18:
          return "DehydratedFragment";
        case 11:
          return a2 = b.render, a2 = a2.displayName || a2.name || "", b.displayName || ("" !== a2 ? "ForwardRef(" + a2 + ")" : "ForwardRef");
        case 7:
          return "Fragment";
        case 5:
          return b;
        case 4:
          return "Portal";
        case 3:
          return "Root";
        case 6:
          return "Text";
        case 16:
          return Qa(b);
        case 8:
          return b === za ? "StrictMode" : "Mode";
        case 22:
          return "Offscreen";
        case 12:
          return "Profiler";
        case 21:
          return "Scope";
        case 13:
          return "Suspense";
        case 19:
          return "SuspenseList";
        case 25:
          return "TracingMarker";
        case 1:
        case 0:
        case 17:
        case 2:
        case 14:
        case 15:
          if ("function" === typeof b)
            return b.displayName || b.name || null;
          if ("string" === typeof b)
            return b;
      }
      return null;
    }
    function Sa(a2) {
      switch (typeof a2) {
        case "boolean":
        case "number":
        case "string":
        case "undefined":
          return a2;
        case "object":
          return a2;
        default:
          return "";
      }
    }
    function Ta(a2) {
      var b = a2.type;
      return (a2 = a2.nodeName) && "input" === a2.toLowerCase() && ("checkbox" === b || "radio" === b);
    }
    function Ua(a2) {
      var b = Ta(a2) ? "checked" : "value", c2 = Object.getOwnPropertyDescriptor(a2.constructor.prototype, b), d = "" + a2[b];
      if (!a2.hasOwnProperty(b) && "undefined" !== typeof c2 && "function" === typeof c2.get && "function" === typeof c2.set) {
        var e = c2.get, f = c2.set;
        Object.defineProperty(a2, b, { configurable: true, get: function() {
          return e.call(this);
        }, set: function(a3) {
          d = "" + a3;
          f.call(this, a3);
        } });
        Object.defineProperty(a2, b, { enumerable: c2.enumerable });
        return { getValue: function() {
          return d;
        }, setValue: function(a3) {
          d = "" + a3;
        }, stopTracking: function() {
          a2._valueTracker = null;
          delete a2[b];
        } };
      }
    }
    function Va(a2) {
      a2._valueTracker || (a2._valueTracker = Ua(a2));
    }
    function Wa(a2) {
      if (!a2)
        return false;
      var b = a2._valueTracker;
      if (!b)
        return true;
      var c2 = b.getValue();
      var d = "";
      a2 && (d = Ta(a2) ? a2.checked ? "true" : "false" : a2.value);
      a2 = d;
      return a2 !== c2 ? (b.setValue(a2), true) : false;
    }
    function Xa(a2) {
      a2 = a2 || ("undefined" !== typeof document ? document : void 0);
      if ("undefined" === typeof a2)
        return null;
      try {
        return a2.activeElement || a2.body;
      } catch (b) {
        return a2.body;
      }
    }
    function Ya(a2, b) {
      var c2 = b.checked;
      return A2({}, b, { defaultChecked: void 0, defaultValue: void 0, value: void 0, checked: null != c2 ? c2 : a2._wrapperState.initialChecked });
    }
    function Za(a2, b) {
      var c2 = null == b.defaultValue ? "" : b.defaultValue, d = null != b.checked ? b.checked : b.defaultChecked;
      c2 = Sa(null != b.value ? b.value : c2);
      a2._wrapperState = { initialChecked: d, initialValue: c2, controlled: "checkbox" === b.type || "radio" === b.type ? null != b.checked : null != b.value };
    }
    function ab(a2, b) {
      b = b.checked;
      null != b && ta(a2, "checked", b, false);
    }
    function bb(a2, b) {
      ab(a2, b);
      var c2 = Sa(b.value), d = b.type;
      if (null != c2)
        if ("number" === d) {
          if (0 === c2 && "" === a2.value || a2.value != c2)
            a2.value = "" + c2;
        } else
          a2.value !== "" + c2 && (a2.value = "" + c2);
      else if ("submit" === d || "reset" === d) {
        a2.removeAttribute("value");
        return;
      }
      b.hasOwnProperty("value") ? cb(a2, b.type, c2) : b.hasOwnProperty("defaultValue") && cb(a2, b.type, Sa(b.defaultValue));
      null == b.checked && null != b.defaultChecked && (a2.defaultChecked = !!b.defaultChecked);
    }
    function db(a2, b, c2) {
      if (b.hasOwnProperty("value") || b.hasOwnProperty("defaultValue")) {
        var d = b.type;
        if (!("submit" !== d && "reset" !== d || void 0 !== b.value && null !== b.value))
          return;
        b = "" + a2._wrapperState.initialValue;
        c2 || b === a2.value || (a2.value = b);
        a2.defaultValue = b;
      }
      c2 = a2.name;
      "" !== c2 && (a2.name = "");
      a2.defaultChecked = !!a2._wrapperState.initialChecked;
      "" !== c2 && (a2.name = c2);
    }
    function cb(a2, b, c2) {
      if ("number" !== b || Xa(a2.ownerDocument) !== a2)
        null == c2 ? a2.defaultValue = "" + a2._wrapperState.initialValue : a2.defaultValue !== "" + c2 && (a2.defaultValue = "" + c2);
    }
    var eb = Array.isArray;
    function fb(a2, b, c2, d) {
      a2 = a2.options;
      if (b) {
        b = {};
        for (var e = 0; e < c2.length; e++)
          b["$" + c2[e]] = true;
        for (c2 = 0; c2 < a2.length; c2++)
          e = b.hasOwnProperty("$" + a2[c2].value), a2[c2].selected !== e && (a2[c2].selected = e), e && d && (a2[c2].defaultSelected = true);
      } else {
        c2 = "" + Sa(c2);
        b = null;
        for (e = 0; e < a2.length; e++) {
          if (a2[e].value === c2) {
            a2[e].selected = true;
            d && (a2[e].defaultSelected = true);
            return;
          }
          null !== b || a2[e].disabled || (b = a2[e]);
        }
        null !== b && (b.selected = true);
      }
    }
    function gb(a2, b) {
      if (null != b.dangerouslySetInnerHTML)
        throw Error(p2(91));
      return A2({}, b, { value: void 0, defaultValue: void 0, children: "" + a2._wrapperState.initialValue });
    }
    function hb(a2, b) {
      var c2 = b.value;
      if (null == c2) {
        c2 = b.children;
        b = b.defaultValue;
        if (null != c2) {
          if (null != b)
            throw Error(p2(92));
          if (eb(c2)) {
            if (1 < c2.length)
              throw Error(p2(93));
            c2 = c2[0];
          }
          b = c2;
        }
        null == b && (b = "");
        c2 = b;
      }
      a2._wrapperState = { initialValue: Sa(c2) };
    }
    function ib(a2, b) {
      var c2 = Sa(b.value), d = Sa(b.defaultValue);
      null != c2 && (c2 = "" + c2, c2 !== a2.value && (a2.value = c2), null == b.defaultValue && a2.defaultValue !== c2 && (a2.defaultValue = c2));
      null != d && (a2.defaultValue = "" + d);
    }
    function jb(a2) {
      var b = a2.textContent;
      b === a2._wrapperState.initialValue && "" !== b && null !== b && (a2.value = b);
    }
    function kb(a2) {
      switch (a2) {
        case "svg":
          return "http://www.w3.org/2000/svg";
        case "math":
          return "http://www.w3.org/1998/Math/MathML";
        default:
          return "http://www.w3.org/1999/xhtml";
      }
    }
    function lb(a2, b) {
      return null == a2 || "http://www.w3.org/1999/xhtml" === a2 ? kb(b) : "http://www.w3.org/2000/svg" === a2 && "foreignObject" === b ? "http://www.w3.org/1999/xhtml" : a2;
    }
    var mb, nb = function(a2) {
      return "undefined" !== typeof MSApp && MSApp.execUnsafeLocalFunction ? function(b, c2, d, e) {
        MSApp.execUnsafeLocalFunction(function() {
          return a2(b, c2, d, e);
        });
      } : a2;
    }(function(a2, b) {
      if ("http://www.w3.org/2000/svg" !== a2.namespaceURI || "innerHTML" in a2)
        a2.innerHTML = b;
      else {
        mb = mb || document.createElement("div");
        mb.innerHTML = "<svg>" + b.valueOf().toString() + "</svg>";
        for (b = mb.firstChild; a2.firstChild; )
          a2.removeChild(a2.firstChild);
        for (; b.firstChild; )
          a2.appendChild(b.firstChild);
      }
    });
    function ob(a2, b) {
      if (b) {
        var c2 = a2.firstChild;
        if (c2 && c2 === a2.lastChild && 3 === c2.nodeType) {
          c2.nodeValue = b;
          return;
        }
      }
      a2.textContent = b;
    }
    var pb = {
      animationIterationCount: true,
      aspectRatio: true,
      borderImageOutset: true,
      borderImageSlice: true,
      borderImageWidth: true,
      boxFlex: true,
      boxFlexGroup: true,
      boxOrdinalGroup: true,
      columnCount: true,
      columns: true,
      flex: true,
      flexGrow: true,
      flexPositive: true,
      flexShrink: true,
      flexNegative: true,
      flexOrder: true,
      gridArea: true,
      gridRow: true,
      gridRowEnd: true,
      gridRowSpan: true,
      gridRowStart: true,
      gridColumn: true,
      gridColumnEnd: true,
      gridColumnSpan: true,
      gridColumnStart: true,
      fontWeight: true,
      lineClamp: true,
      lineHeight: true,
      opacity: true,
      order: true,
      orphans: true,
      tabSize: true,
      widows: true,
      zIndex: true,
      zoom: true,
      fillOpacity: true,
      floodOpacity: true,
      stopOpacity: true,
      strokeDasharray: true,
      strokeDashoffset: true,
      strokeMiterlimit: true,
      strokeOpacity: true,
      strokeWidth: true
    }, qb = ["Webkit", "ms", "Moz", "O"];
    Object.keys(pb).forEach(function(a2) {
      qb.forEach(function(b) {
        b = b + a2.charAt(0).toUpperCase() + a2.substring(1);
        pb[b] = pb[a2];
      });
    });
    function rb(a2, b, c2) {
      return null == b || "boolean" === typeof b || "" === b ? "" : c2 || "number" !== typeof b || 0 === b || pb.hasOwnProperty(a2) && pb[a2] ? ("" + b).trim() : b + "px";
    }
    function sb(a2, b) {
      a2 = a2.style;
      for (var c2 in b)
        if (b.hasOwnProperty(c2)) {
          var d = 0 === c2.indexOf("--"), e = rb(c2, b[c2], d);
          "float" === c2 && (c2 = "cssFloat");
          d ? a2.setProperty(c2, e) : a2[c2] = e;
        }
    }
    var tb = A2({ menuitem: true }, { area: true, base: true, br: true, col: true, embed: true, hr: true, img: true, input: true, keygen: true, link: true, meta: true, param: true, source: true, track: true, wbr: true });
    function ub(a2, b) {
      if (b) {
        if (tb[a2] && (null != b.children || null != b.dangerouslySetInnerHTML))
          throw Error(p2(137, a2));
        if (null != b.dangerouslySetInnerHTML) {
          if (null != b.children)
            throw Error(p2(60));
          if ("object" !== typeof b.dangerouslySetInnerHTML || !("__html" in b.dangerouslySetInnerHTML))
            throw Error(p2(61));
        }
        if (null != b.style && "object" !== typeof b.style)
          throw Error(p2(62));
      }
    }
    function vb(a2, b) {
      if (-1 === a2.indexOf("-"))
        return "string" === typeof b.is;
      switch (a2) {
        case "annotation-xml":
        case "color-profile":
        case "font-face":
        case "font-face-src":
        case "font-face-uri":
        case "font-face-format":
        case "font-face-name":
        case "missing-glyph":
          return false;
        default:
          return true;
      }
    }
    var wb = null;
    function xb(a2) {
      a2 = a2.target || a2.srcElement || window;
      a2.correspondingUseElement && (a2 = a2.correspondingUseElement);
      return 3 === a2.nodeType ? a2.parentNode : a2;
    }
    var yb = null, zb = null, Ab = null;
    function Bb(a2) {
      if (a2 = Cb(a2)) {
        if ("function" !== typeof yb)
          throw Error(p2(280));
        var b = a2.stateNode;
        b && (b = Db(b), yb(a2.stateNode, a2.type, b));
      }
    }
    function Eb(a2) {
      zb ? Ab ? Ab.push(a2) : Ab = [a2] : zb = a2;
    }
    function Fb() {
      if (zb) {
        var a2 = zb, b = Ab;
        Ab = zb = null;
        Bb(a2);
        if (b)
          for (a2 = 0; a2 < b.length; a2++)
            Bb(b[a2]);
      }
    }
    function Gb(a2, b) {
      return a2(b);
    }
    function Hb() {
    }
    var Ib = false;
    function Jb(a2, b, c2) {
      if (Ib)
        return a2(b, c2);
      Ib = true;
      try {
        return Gb(a2, b, c2);
      } finally {
        if (Ib = false, null !== zb || null !== Ab)
          Hb(), Fb();
      }
    }
    function Kb(a2, b) {
      var c2 = a2.stateNode;
      if (null === c2)
        return null;
      var d = Db(c2);
      if (null === d)
        return null;
      c2 = d[b];
      a:
        switch (b) {
          case "onClick":
          case "onClickCapture":
          case "onDoubleClick":
          case "onDoubleClickCapture":
          case "onMouseDown":
          case "onMouseDownCapture":
          case "onMouseMove":
          case "onMouseMoveCapture":
          case "onMouseUp":
          case "onMouseUpCapture":
          case "onMouseEnter":
            (d = !d.disabled) || (a2 = a2.type, d = !("button" === a2 || "input" === a2 || "select" === a2 || "textarea" === a2));
            a2 = !d;
            break a;
          default:
            a2 = false;
        }
      if (a2)
        return null;
      if (c2 && "function" !== typeof c2)
        throw Error(p2(231, b, typeof c2));
      return c2;
    }
    var Lb = false;
    if (ia)
      try {
        var Mb = {};
        Object.defineProperty(Mb, "passive", { get: function() {
          Lb = true;
        } });
        window.addEventListener("test", Mb, Mb);
        window.removeEventListener("test", Mb, Mb);
      } catch (a2) {
        Lb = false;
      }
    function Nb(a2, b, c2, d, e, f, g, h, k) {
      var l = Array.prototype.slice.call(arguments, 3);
      try {
        b.apply(c2, l);
      } catch (m2) {
        this.onError(m2);
      }
    }
    var Ob = false, Pb = null, Qb = false, Rb = null, Sb = { onError: function(a2) {
      Ob = true;
      Pb = a2;
    } };
    function Tb(a2, b, c2, d, e, f, g, h, k) {
      Ob = false;
      Pb = null;
      Nb.apply(Sb, arguments);
    }
    function Ub(a2, b, c2, d, e, f, g, h, k) {
      Tb.apply(this, arguments);
      if (Ob) {
        if (Ob) {
          var l = Pb;
          Ob = false;
          Pb = null;
        } else
          throw Error(p2(198));
        Qb || (Qb = true, Rb = l);
      }
    }
    function Vb(a2) {
      var b = a2, c2 = a2;
      if (a2.alternate)
        for (; b.return; )
          b = b.return;
      else {
        a2 = b;
        do
          b = a2, 0 !== (b.flags & 4098) && (c2 = b.return), a2 = b.return;
        while (a2);
      }
      return 3 === b.tag ? c2 : null;
    }
    function Wb(a2) {
      if (13 === a2.tag) {
        var b = a2.memoizedState;
        null === b && (a2 = a2.alternate, null !== a2 && (b = a2.memoizedState));
        if (null !== b)
          return b.dehydrated;
      }
      return null;
    }
    function Xb(a2) {
      if (Vb(a2) !== a2)
        throw Error(p2(188));
    }
    function Yb(a2) {
      var b = a2.alternate;
      if (!b) {
        b = Vb(a2);
        if (null === b)
          throw Error(p2(188));
        return b !== a2 ? null : a2;
      }
      for (var c2 = a2, d = b; ; ) {
        var e = c2.return;
        if (null === e)
          break;
        var f = e.alternate;
        if (null === f) {
          d = e.return;
          if (null !== d) {
            c2 = d;
            continue;
          }
          break;
        }
        if (e.child === f.child) {
          for (f = e.child; f; ) {
            if (f === c2)
              return Xb(e), a2;
            if (f === d)
              return Xb(e), b;
            f = f.sibling;
          }
          throw Error(p2(188));
        }
        if (c2.return !== d.return)
          c2 = e, d = f;
        else {
          for (var g = false, h = e.child; h; ) {
            if (h === c2) {
              g = true;
              c2 = e;
              d = f;
              break;
            }
            if (h === d) {
              g = true;
              d = e;
              c2 = f;
              break;
            }
            h = h.sibling;
          }
          if (!g) {
            for (h = f.child; h; ) {
              if (h === c2) {
                g = true;
                c2 = f;
                d = e;
                break;
              }
              if (h === d) {
                g = true;
                d = f;
                c2 = e;
                break;
              }
              h = h.sibling;
            }
            if (!g)
              throw Error(p2(189));
          }
        }
        if (c2.alternate !== d)
          throw Error(p2(190));
      }
      if (3 !== c2.tag)
        throw Error(p2(188));
      return c2.stateNode.current === c2 ? a2 : b;
    }
    function Zb(a2) {
      a2 = Yb(a2);
      return null !== a2 ? $b(a2) : null;
    }
    function $b(a2) {
      if (5 === a2.tag || 6 === a2.tag)
        return a2;
      for (a2 = a2.child; null !== a2; ) {
        var b = $b(a2);
        if (null !== b)
          return b;
        a2 = a2.sibling;
      }
      return null;
    }
    var ac = ca.unstable_scheduleCallback, bc = ca.unstable_cancelCallback, cc = ca.unstable_shouldYield, dc = ca.unstable_requestPaint, B = ca.unstable_now, ec = ca.unstable_getCurrentPriorityLevel, fc = ca.unstable_ImmediatePriority, gc = ca.unstable_UserBlockingPriority, hc = ca.unstable_NormalPriority, ic = ca.unstable_LowPriority, jc = ca.unstable_IdlePriority, kc = null, lc = null;
    function mc(a2) {
      if (lc && "function" === typeof lc.onCommitFiberRoot)
        try {
          lc.onCommitFiberRoot(kc, a2, void 0, 128 === (a2.current.flags & 128));
        } catch (b) {
        }
    }
    var oc = Math.clz32 ? Math.clz32 : nc, pc = Math.log, qc = Math.LN2;
    function nc(a2) {
      a2 >>>= 0;
      return 0 === a2 ? 32 : 31 - (pc(a2) / qc | 0) | 0;
    }
    var rc = 64, sc = 4194304;
    function tc(a2) {
      switch (a2 & -a2) {
        case 1:
          return 1;
        case 2:
          return 2;
        case 4:
          return 4;
        case 8:
          return 8;
        case 16:
          return 16;
        case 32:
          return 32;
        case 64:
        case 128:
        case 256:
        case 512:
        case 1024:
        case 2048:
        case 4096:
        case 8192:
        case 16384:
        case 32768:
        case 65536:
        case 131072:
        case 262144:
        case 524288:
        case 1048576:
        case 2097152:
          return a2 & 4194240;
        case 4194304:
        case 8388608:
        case 16777216:
        case 33554432:
        case 67108864:
          return a2 & 130023424;
        case 134217728:
          return 134217728;
        case 268435456:
          return 268435456;
        case 536870912:
          return 536870912;
        case 1073741824:
          return 1073741824;
        default:
          return a2;
      }
    }
    function uc(a2, b) {
      var c2 = a2.pendingLanes;
      if (0 === c2)
        return 0;
      var d = 0, e = a2.suspendedLanes, f = a2.pingedLanes, g = c2 & 268435455;
      if (0 !== g) {
        var h = g & ~e;
        0 !== h ? d = tc(h) : (f &= g, 0 !== f && (d = tc(f)));
      } else
        g = c2 & ~e, 0 !== g ? d = tc(g) : 0 !== f && (d = tc(f));
      if (0 === d)
        return 0;
      if (0 !== b && b !== d && 0 === (b & e) && (e = d & -d, f = b & -b, e >= f || 16 === e && 0 !== (f & 4194240)))
        return b;
      0 !== (d & 4) && (d |= c2 & 16);
      b = a2.entangledLanes;
      if (0 !== b)
        for (a2 = a2.entanglements, b &= d; 0 < b; )
          c2 = 31 - oc(b), e = 1 << c2, d |= a2[c2], b &= ~e;
      return d;
    }
    function vc(a2, b) {
      switch (a2) {
        case 1:
        case 2:
        case 4:
          return b + 250;
        case 8:
        case 16:
        case 32:
        case 64:
        case 128:
        case 256:
        case 512:
        case 1024:
        case 2048:
        case 4096:
        case 8192:
        case 16384:
        case 32768:
        case 65536:
        case 131072:
        case 262144:
        case 524288:
        case 1048576:
        case 2097152:
          return b + 5e3;
        case 4194304:
        case 8388608:
        case 16777216:
        case 33554432:
        case 67108864:
          return -1;
        case 134217728:
        case 268435456:
        case 536870912:
        case 1073741824:
          return -1;
        default:
          return -1;
      }
    }
    function wc(a2, b) {
      for (var c2 = a2.suspendedLanes, d = a2.pingedLanes, e = a2.expirationTimes, f = a2.pendingLanes; 0 < f; ) {
        var g = 31 - oc(f), h = 1 << g, k = e[g];
        if (-1 === k) {
          if (0 === (h & c2) || 0 !== (h & d))
            e[g] = vc(h, b);
        } else
          k <= b && (a2.expiredLanes |= h);
        f &= ~h;
      }
    }
    function xc(a2) {
      a2 = a2.pendingLanes & -1073741825;
      return 0 !== a2 ? a2 : a2 & 1073741824 ? 1073741824 : 0;
    }
    function yc() {
      var a2 = rc;
      rc <<= 1;
      0 === (rc & 4194240) && (rc = 64);
      return a2;
    }
    function zc(a2) {
      for (var b = [], c2 = 0; 31 > c2; c2++)
        b.push(a2);
      return b;
    }
    function Ac(a2, b, c2) {
      a2.pendingLanes |= b;
      536870912 !== b && (a2.suspendedLanes = 0, a2.pingedLanes = 0);
      a2 = a2.eventTimes;
      b = 31 - oc(b);
      a2[b] = c2;
    }
    function Bc(a2, b) {
      var c2 = a2.pendingLanes & ~b;
      a2.pendingLanes = b;
      a2.suspendedLanes = 0;
      a2.pingedLanes = 0;
      a2.expiredLanes &= b;
      a2.mutableReadLanes &= b;
      a2.entangledLanes &= b;
      b = a2.entanglements;
      var d = a2.eventTimes;
      for (a2 = a2.expirationTimes; 0 < c2; ) {
        var e = 31 - oc(c2), f = 1 << e;
        b[e] = 0;
        d[e] = -1;
        a2[e] = -1;
        c2 &= ~f;
      }
    }
    function Cc(a2, b) {
      var c2 = a2.entangledLanes |= b;
      for (a2 = a2.entanglements; c2; ) {
        var d = 31 - oc(c2), e = 1 << d;
        e & b | a2[d] & b && (a2[d] |= b);
        c2 &= ~e;
      }
    }
    var C2 = 0;
    function Dc(a2) {
      a2 &= -a2;
      return 1 < a2 ? 4 < a2 ? 0 !== (a2 & 268435455) ? 16 : 536870912 : 4 : 1;
    }
    var Ec, Fc, Gc, Hc, Ic, Jc = false, Kc = [], Lc = null, Mc = null, Nc = null, Oc = /* @__PURE__ */ new Map(), Pc = /* @__PURE__ */ new Map(), Qc = [], Rc = "mousedown mouseup touchcancel touchend touchstart auxclick dblclick pointercancel pointerdown pointerup dragend dragstart drop compositionend compositionstart keydown keypress keyup input textInput copy cut paste click change contextmenu reset submit".split(" ");
    function Sc(a2, b) {
      switch (a2) {
        case "focusin":
        case "focusout":
          Lc = null;
          break;
        case "dragenter":
        case "dragleave":
          Mc = null;
          break;
        case "mouseover":
        case "mouseout":
          Nc = null;
          break;
        case "pointerover":
        case "pointerout":
          Oc.delete(b.pointerId);
          break;
        case "gotpointercapture":
        case "lostpointercapture":
          Pc.delete(b.pointerId);
      }
    }
    function Tc(a2, b, c2, d, e, f) {
      if (null === a2 || a2.nativeEvent !== f)
        return a2 = { blockedOn: b, domEventName: c2, eventSystemFlags: d, nativeEvent: f, targetContainers: [e] }, null !== b && (b = Cb(b), null !== b && Fc(b)), a2;
      a2.eventSystemFlags |= d;
      b = a2.targetContainers;
      null !== e && -1 === b.indexOf(e) && b.push(e);
      return a2;
    }
    function Uc(a2, b, c2, d, e) {
      switch (b) {
        case "focusin":
          return Lc = Tc(Lc, a2, b, c2, d, e), true;
        case "dragenter":
          return Mc = Tc(Mc, a2, b, c2, d, e), true;
        case "mouseover":
          return Nc = Tc(Nc, a2, b, c2, d, e), true;
        case "pointerover":
          var f = e.pointerId;
          Oc.set(f, Tc(Oc.get(f) || null, a2, b, c2, d, e));
          return true;
        case "gotpointercapture":
          return f = e.pointerId, Pc.set(f, Tc(Pc.get(f) || null, a2, b, c2, d, e)), true;
      }
      return false;
    }
    function Vc(a2) {
      var b = Wc(a2.target);
      if (null !== b) {
        var c2 = Vb(b);
        if (null !== c2) {
          if (b = c2.tag, 13 === b) {
            if (b = Wb(c2), null !== b) {
              a2.blockedOn = b;
              Ic(a2.priority, function() {
                Gc(c2);
              });
              return;
            }
          } else if (3 === b && c2.stateNode.current.memoizedState.isDehydrated) {
            a2.blockedOn = 3 === c2.tag ? c2.stateNode.containerInfo : null;
            return;
          }
        }
      }
      a2.blockedOn = null;
    }
    function Xc(a2) {
      if (null !== a2.blockedOn)
        return false;
      for (var b = a2.targetContainers; 0 < b.length; ) {
        var c2 = Yc(a2.domEventName, a2.eventSystemFlags, b[0], a2.nativeEvent);
        if (null === c2) {
          c2 = a2.nativeEvent;
          var d = new c2.constructor(c2.type, c2);
          wb = d;
          c2.target.dispatchEvent(d);
          wb = null;
        } else
          return b = Cb(c2), null !== b && Fc(b), a2.blockedOn = c2, false;
        b.shift();
      }
      return true;
    }
    function Zc(a2, b, c2) {
      Xc(a2) && c2.delete(b);
    }
    function $c() {
      Jc = false;
      null !== Lc && Xc(Lc) && (Lc = null);
      null !== Mc && Xc(Mc) && (Mc = null);
      null !== Nc && Xc(Nc) && (Nc = null);
      Oc.forEach(Zc);
      Pc.forEach(Zc);
    }
    function ad(a2, b) {
      a2.blockedOn === b && (a2.blockedOn = null, Jc || (Jc = true, ca.unstable_scheduleCallback(ca.unstable_NormalPriority, $c)));
    }
    function bd(a2) {
      function b(b2) {
        return ad(b2, a2);
      }
      if (0 < Kc.length) {
        ad(Kc[0], a2);
        for (var c2 = 1; c2 < Kc.length; c2++) {
          var d = Kc[c2];
          d.blockedOn === a2 && (d.blockedOn = null);
        }
      }
      null !== Lc && ad(Lc, a2);
      null !== Mc && ad(Mc, a2);
      null !== Nc && ad(Nc, a2);
      Oc.forEach(b);
      Pc.forEach(b);
      for (c2 = 0; c2 < Qc.length; c2++)
        d = Qc[c2], d.blockedOn === a2 && (d.blockedOn = null);
      for (; 0 < Qc.length && (c2 = Qc[0], null === c2.blockedOn); )
        Vc(c2), null === c2.blockedOn && Qc.shift();
    }
    var cd = ua.ReactCurrentBatchConfig, dd = true;
    function ed(a2, b, c2, d) {
      var e = C2, f = cd.transition;
      cd.transition = null;
      try {
        C2 = 1, fd(a2, b, c2, d);
      } finally {
        C2 = e, cd.transition = f;
      }
    }
    function gd(a2, b, c2, d) {
      var e = C2, f = cd.transition;
      cd.transition = null;
      try {
        C2 = 4, fd(a2, b, c2, d);
      } finally {
        C2 = e, cd.transition = f;
      }
    }
    function fd(a2, b, c2, d) {
      if (dd) {
        var e = Yc(a2, b, c2, d);
        if (null === e)
          hd(a2, b, d, id, c2), Sc(a2, d);
        else if (Uc(e, a2, b, c2, d))
          d.stopPropagation();
        else if (Sc(a2, d), b & 4 && -1 < Rc.indexOf(a2)) {
          for (; null !== e; ) {
            var f = Cb(e);
            null !== f && Ec(f);
            f = Yc(a2, b, c2, d);
            null === f && hd(a2, b, d, id, c2);
            if (f === e)
              break;
            e = f;
          }
          null !== e && d.stopPropagation();
        } else
          hd(a2, b, d, null, c2);
      }
    }
    var id = null;
    function Yc(a2, b, c2, d) {
      id = null;
      a2 = xb(d);
      a2 = Wc(a2);
      if (null !== a2)
        if (b = Vb(a2), null === b)
          a2 = null;
        else if (c2 = b.tag, 13 === c2) {
          a2 = Wb(b);
          if (null !== a2)
            return a2;
          a2 = null;
        } else if (3 === c2) {
          if (b.stateNode.current.memoizedState.isDehydrated)
            return 3 === b.tag ? b.stateNode.containerInfo : null;
          a2 = null;
        } else
          b !== a2 && (a2 = null);
      id = a2;
      return null;
    }
    function jd(a2) {
      switch (a2) {
        case "cancel":
        case "click":
        case "close":
        case "contextmenu":
        case "copy":
        case "cut":
        case "auxclick":
        case "dblclick":
        case "dragend":
        case "dragstart":
        case "drop":
        case "focusin":
        case "focusout":
        case "input":
        case "invalid":
        case "keydown":
        case "keypress":
        case "keyup":
        case "mousedown":
        case "mouseup":
        case "paste":
        case "pause":
        case "play":
        case "pointercancel":
        case "pointerdown":
        case "pointerup":
        case "ratechange":
        case "reset":
        case "resize":
        case "seeked":
        case "submit":
        case "touchcancel":
        case "touchend":
        case "touchstart":
        case "volumechange":
        case "change":
        case "selectionchange":
        case "textInput":
        case "compositionstart":
        case "compositionend":
        case "compositionupdate":
        case "beforeblur":
        case "afterblur":
        case "beforeinput":
        case "blur":
        case "fullscreenchange":
        case "focus":
        case "hashchange":
        case "popstate":
        case "select":
        case "selectstart":
          return 1;
        case "drag":
        case "dragenter":
        case "dragexit":
        case "dragleave":
        case "dragover":
        case "mousemove":
        case "mouseout":
        case "mouseover":
        case "pointermove":
        case "pointerout":
        case "pointerover":
        case "scroll":
        case "toggle":
        case "touchmove":
        case "wheel":
        case "mouseenter":
        case "mouseleave":
        case "pointerenter":
        case "pointerleave":
          return 4;
        case "message":
          switch (ec()) {
            case fc:
              return 1;
            case gc:
              return 4;
            case hc:
            case ic:
              return 16;
            case jc:
              return 536870912;
            default:
              return 16;
          }
        default:
          return 16;
      }
    }
    var kd = null, ld = null, md = null;
    function nd() {
      if (md)
        return md;
      var a2, b = ld, c2 = b.length, d, e = "value" in kd ? kd.value : kd.textContent, f = e.length;
      for (a2 = 0; a2 < c2 && b[a2] === e[a2]; a2++)
        ;
      var g = c2 - a2;
      for (d = 1; d <= g && b[c2 - d] === e[f - d]; d++)
        ;
      return md = e.slice(a2, 1 < d ? 1 - d : void 0);
    }
    function od(a2) {
      var b = a2.keyCode;
      "charCode" in a2 ? (a2 = a2.charCode, 0 === a2 && 13 === b && (a2 = 13)) : a2 = b;
      10 === a2 && (a2 = 13);
      return 32 <= a2 || 13 === a2 ? a2 : 0;
    }
    function pd() {
      return true;
    }
    function qd() {
      return false;
    }
    function rd(a2) {
      function b(b2, d, e, f, g) {
        this._reactName = b2;
        this._targetInst = e;
        this.type = d;
        this.nativeEvent = f;
        this.target = g;
        this.currentTarget = null;
        for (var c2 in a2)
          a2.hasOwnProperty(c2) && (b2 = a2[c2], this[c2] = b2 ? b2(f) : f[c2]);
        this.isDefaultPrevented = (null != f.defaultPrevented ? f.defaultPrevented : false === f.returnValue) ? pd : qd;
        this.isPropagationStopped = qd;
        return this;
      }
      A2(b.prototype, { preventDefault: function() {
        this.defaultPrevented = true;
        var a3 = this.nativeEvent;
        a3 && (a3.preventDefault ? a3.preventDefault() : "unknown" !== typeof a3.returnValue && (a3.returnValue = false), this.isDefaultPrevented = pd);
      }, stopPropagation: function() {
        var a3 = this.nativeEvent;
        a3 && (a3.stopPropagation ? a3.stopPropagation() : "unknown" !== typeof a3.cancelBubble && (a3.cancelBubble = true), this.isPropagationStopped = pd);
      }, persist: function() {
      }, isPersistent: pd });
      return b;
    }
    var sd = { eventPhase: 0, bubbles: 0, cancelable: 0, timeStamp: function(a2) {
      return a2.timeStamp || Date.now();
    }, defaultPrevented: 0, isTrusted: 0 }, td = rd(sd), ud = A2({}, sd, { view: 0, detail: 0 }), vd = rd(ud), wd, xd, yd, Ad = A2({}, ud, { screenX: 0, screenY: 0, clientX: 0, clientY: 0, pageX: 0, pageY: 0, ctrlKey: 0, shiftKey: 0, altKey: 0, metaKey: 0, getModifierState: zd, button: 0, buttons: 0, relatedTarget: function(a2) {
      return void 0 === a2.relatedTarget ? a2.fromElement === a2.srcElement ? a2.toElement : a2.fromElement : a2.relatedTarget;
    }, movementX: function(a2) {
      if ("movementX" in a2)
        return a2.movementX;
      a2 !== yd && (yd && "mousemove" === a2.type ? (wd = a2.screenX - yd.screenX, xd = a2.screenY - yd.screenY) : xd = wd = 0, yd = a2);
      return wd;
    }, movementY: function(a2) {
      return "movementY" in a2 ? a2.movementY : xd;
    } }), Bd = rd(Ad), Cd = A2({}, Ad, { dataTransfer: 0 }), Dd = rd(Cd), Ed = A2({}, ud, { relatedTarget: 0 }), Fd = rd(Ed), Gd = A2({}, sd, { animationName: 0, elapsedTime: 0, pseudoElement: 0 }), Hd = rd(Gd), Id = A2({}, sd, { clipboardData: function(a2) {
      return "clipboardData" in a2 ? a2.clipboardData : window.clipboardData;
    } }), Jd = rd(Id), Kd = A2({}, sd, { data: 0 }), Ld = rd(Kd), Md = {
      Esc: "Escape",
      Spacebar: " ",
      Left: "ArrowLeft",
      Up: "ArrowUp",
      Right: "ArrowRight",
      Down: "ArrowDown",
      Del: "Delete",
      Win: "OS",
      Menu: "ContextMenu",
      Apps: "ContextMenu",
      Scroll: "ScrollLock",
      MozPrintableKey: "Unidentified"
    }, Nd = {
      8: "Backspace",
      9: "Tab",
      12: "Clear",
      13: "Enter",
      16: "Shift",
      17: "Control",
      18: "Alt",
      19: "Pause",
      20: "CapsLock",
      27: "Escape",
      32: " ",
      33: "PageUp",
      34: "PageDown",
      35: "End",
      36: "Home",
      37: "ArrowLeft",
      38: "ArrowUp",
      39: "ArrowRight",
      40: "ArrowDown",
      45: "Insert",
      46: "Delete",
      112: "F1",
      113: "F2",
      114: "F3",
      115: "F4",
      116: "F5",
      117: "F6",
      118: "F7",
      119: "F8",
      120: "F9",
      121: "F10",
      122: "F11",
      123: "F12",
      144: "NumLock",
      145: "ScrollLock",
      224: "Meta"
    }, Od = { Alt: "altKey", Control: "ctrlKey", Meta: "metaKey", Shift: "shiftKey" };
    function Pd(a2) {
      var b = this.nativeEvent;
      return b.getModifierState ? b.getModifierState(a2) : (a2 = Od[a2]) ? !!b[a2] : false;
    }
    function zd() {
      return Pd;
    }
    var Qd = A2({}, ud, { key: function(a2) {
      if (a2.key) {
        var b = Md[a2.key] || a2.key;
        if ("Unidentified" !== b)
          return b;
      }
      return "keypress" === a2.type ? (a2 = od(a2), 13 === a2 ? "Enter" : String.fromCharCode(a2)) : "keydown" === a2.type || "keyup" === a2.type ? Nd[a2.keyCode] || "Unidentified" : "";
    }, code: 0, location: 0, ctrlKey: 0, shiftKey: 0, altKey: 0, metaKey: 0, repeat: 0, locale: 0, getModifierState: zd, charCode: function(a2) {
      return "keypress" === a2.type ? od(a2) : 0;
    }, keyCode: function(a2) {
      return "keydown" === a2.type || "keyup" === a2.type ? a2.keyCode : 0;
    }, which: function(a2) {
      return "keypress" === a2.type ? od(a2) : "keydown" === a2.type || "keyup" === a2.type ? a2.keyCode : 0;
    } }), Rd = rd(Qd), Sd = A2({}, Ad, { pointerId: 0, width: 0, height: 0, pressure: 0, tangentialPressure: 0, tiltX: 0, tiltY: 0, twist: 0, pointerType: 0, isPrimary: 0 }), Td = rd(Sd), Ud = A2({}, ud, { touches: 0, targetTouches: 0, changedTouches: 0, altKey: 0, metaKey: 0, ctrlKey: 0, shiftKey: 0, getModifierState: zd }), Vd = rd(Ud), Wd = A2({}, sd, { propertyName: 0, elapsedTime: 0, pseudoElement: 0 }), Xd = rd(Wd), Yd = A2({}, Ad, {
      deltaX: function(a2) {
        return "deltaX" in a2 ? a2.deltaX : "wheelDeltaX" in a2 ? -a2.wheelDeltaX : 0;
      },
      deltaY: function(a2) {
        return "deltaY" in a2 ? a2.deltaY : "wheelDeltaY" in a2 ? -a2.wheelDeltaY : "wheelDelta" in a2 ? -a2.wheelDelta : 0;
      },
      deltaZ: 0,
      deltaMode: 0
    }), Zd = rd(Yd), $d = [9, 13, 27, 32], ae2 = ia && "CompositionEvent" in window, be2 = null;
    ia && "documentMode" in document && (be2 = document.documentMode);
    var ce2 = ia && "TextEvent" in window && !be2, de2 = ia && (!ae2 || be2 && 8 < be2 && 11 >= be2), ee2 = String.fromCharCode(32), fe2 = false;
    function ge2(a2, b) {
      switch (a2) {
        case "keyup":
          return -1 !== $d.indexOf(b.keyCode);
        case "keydown":
          return 229 !== b.keyCode;
        case "keypress":
        case "mousedown":
        case "focusout":
          return true;
        default:
          return false;
      }
    }
    function he2(a2) {
      a2 = a2.detail;
      return "object" === typeof a2 && "data" in a2 ? a2.data : null;
    }
    var ie2 = false;
    function je2(a2, b) {
      switch (a2) {
        case "compositionend":
          return he2(b);
        case "keypress":
          if (32 !== b.which)
            return null;
          fe2 = true;
          return ee2;
        case "textInput":
          return a2 = b.data, a2 === ee2 && fe2 ? null : a2;
        default:
          return null;
      }
    }
    function ke2(a2, b) {
      if (ie2)
        return "compositionend" === a2 || !ae2 && ge2(a2, b) ? (a2 = nd(), md = ld = kd = null, ie2 = false, a2) : null;
      switch (a2) {
        case "paste":
          return null;
        case "keypress":
          if (!(b.ctrlKey || b.altKey || b.metaKey) || b.ctrlKey && b.altKey) {
            if (b.char && 1 < b.char.length)
              return b.char;
            if (b.which)
              return String.fromCharCode(b.which);
          }
          return null;
        case "compositionend":
          return de2 && "ko" !== b.locale ? null : b.data;
        default:
          return null;
      }
    }
    var le2 = { color: true, date: true, datetime: true, "datetime-local": true, email: true, month: true, number: true, password: true, range: true, search: true, tel: true, text: true, time: true, url: true, week: true };
    function me2(a2) {
      var b = a2 && a2.nodeName && a2.nodeName.toLowerCase();
      return "input" === b ? !!le2[a2.type] : "textarea" === b ? true : false;
    }
    function ne2(a2, b, c2, d) {
      Eb(d);
      b = oe2(b, "onChange");
      0 < b.length && (c2 = new td("onChange", "change", null, c2, d), a2.push({ event: c2, listeners: b }));
    }
    var pe2 = null, qe2 = null;
    function re2(a2) {
      se(a2, 0);
    }
    function te2(a2) {
      var b = ue2(a2);
      if (Wa(b))
        return a2;
    }
    function ve2(a2, b) {
      if ("change" === a2)
        return b;
    }
    var we2 = false;
    if (ia) {
      var xe2;
      if (ia) {
        var ye2 = "oninput" in document;
        if (!ye2) {
          var ze2 = document.createElement("div");
          ze2.setAttribute("oninput", "return;");
          ye2 = "function" === typeof ze2.oninput;
        }
        xe2 = ye2;
      } else
        xe2 = false;
      we2 = xe2 && (!document.documentMode || 9 < document.documentMode);
    }
    function Ae2() {
      pe2 && (pe2.detachEvent("onpropertychange", Be2), qe2 = pe2 = null);
    }
    function Be2(a2) {
      if ("value" === a2.propertyName && te2(qe2)) {
        var b = [];
        ne2(b, qe2, a2, xb(a2));
        Jb(re2, b);
      }
    }
    function Ce2(a2, b, c2) {
      "focusin" === a2 ? (Ae2(), pe2 = b, qe2 = c2, pe2.attachEvent("onpropertychange", Be2)) : "focusout" === a2 && Ae2();
    }
    function De(a2) {
      if ("selectionchange" === a2 || "keyup" === a2 || "keydown" === a2)
        return te2(qe2);
    }
    function Ee2(a2, b) {
      if ("click" === a2)
        return te2(b);
    }
    function Fe2(a2, b) {
      if ("input" === a2 || "change" === a2)
        return te2(b);
    }
    function Ge2(a2, b) {
      return a2 === b && (0 !== a2 || 1 / a2 === 1 / b) || a2 !== a2 && b !== b;
    }
    var He2 = "function" === typeof Object.is ? Object.is : Ge2;
    function Ie2(a2, b) {
      if (He2(a2, b))
        return true;
      if ("object" !== typeof a2 || null === a2 || "object" !== typeof b || null === b)
        return false;
      var c2 = Object.keys(a2), d = Object.keys(b);
      if (c2.length !== d.length)
        return false;
      for (d = 0; d < c2.length; d++) {
        var e = c2[d];
        if (!ja.call(b, e) || !He2(a2[e], b[e]))
          return false;
      }
      return true;
    }
    function Je2(a2) {
      for (; a2 && a2.firstChild; )
        a2 = a2.firstChild;
      return a2;
    }
    function Ke2(a2, b) {
      var c2 = Je2(a2);
      a2 = 0;
      for (var d; c2; ) {
        if (3 === c2.nodeType) {
          d = a2 + c2.textContent.length;
          if (a2 <= b && d >= b)
            return { node: c2, offset: b - a2 };
          a2 = d;
        }
        a: {
          for (; c2; ) {
            if (c2.nextSibling) {
              c2 = c2.nextSibling;
              break a;
            }
            c2 = c2.parentNode;
          }
          c2 = void 0;
        }
        c2 = Je2(c2);
      }
    }
    function Le2(a2, b) {
      return a2 && b ? a2 === b ? true : a2 && 3 === a2.nodeType ? false : b && 3 === b.nodeType ? Le2(a2, b.parentNode) : "contains" in a2 ? a2.contains(b) : a2.compareDocumentPosition ? !!(a2.compareDocumentPosition(b) & 16) : false : false;
    }
    function Me2() {
      for (var a2 = window, b = Xa(); b instanceof a2.HTMLIFrameElement; ) {
        try {
          var c2 = "string" === typeof b.contentWindow.location.href;
        } catch (d) {
          c2 = false;
        }
        if (c2)
          a2 = b.contentWindow;
        else
          break;
        b = Xa(a2.document);
      }
      return b;
    }
    function Ne2(a2) {
      var b = a2 && a2.nodeName && a2.nodeName.toLowerCase();
      return b && ("input" === b && ("text" === a2.type || "search" === a2.type || "tel" === a2.type || "url" === a2.type || "password" === a2.type) || "textarea" === b || "true" === a2.contentEditable);
    }
    function Oe2(a2) {
      var b = Me2(), c2 = a2.focusedElem, d = a2.selectionRange;
      if (b !== c2 && c2 && c2.ownerDocument && Le2(c2.ownerDocument.documentElement, c2)) {
        if (null !== d && Ne2(c2)) {
          if (b = d.start, a2 = d.end, void 0 === a2 && (a2 = b), "selectionStart" in c2)
            c2.selectionStart = b, c2.selectionEnd = Math.min(a2, c2.value.length);
          else if (a2 = (b = c2.ownerDocument || document) && b.defaultView || window, a2.getSelection) {
            a2 = a2.getSelection();
            var e = c2.textContent.length, f = Math.min(d.start, e);
            d = void 0 === d.end ? f : Math.min(d.end, e);
            !a2.extend && f > d && (e = d, d = f, f = e);
            e = Ke2(c2, f);
            var g = Ke2(
              c2,
              d
            );
            e && g && (1 !== a2.rangeCount || a2.anchorNode !== e.node || a2.anchorOffset !== e.offset || a2.focusNode !== g.node || a2.focusOffset !== g.offset) && (b = b.createRange(), b.setStart(e.node, e.offset), a2.removeAllRanges(), f > d ? (a2.addRange(b), a2.extend(g.node, g.offset)) : (b.setEnd(g.node, g.offset), a2.addRange(b)));
          }
        }
        b = [];
        for (a2 = c2; a2 = a2.parentNode; )
          1 === a2.nodeType && b.push({ element: a2, left: a2.scrollLeft, top: a2.scrollTop });
        "function" === typeof c2.focus && c2.focus();
        for (c2 = 0; c2 < b.length; c2++)
          a2 = b[c2], a2.element.scrollLeft = a2.left, a2.element.scrollTop = a2.top;
      }
    }
    var Pe2 = ia && "documentMode" in document && 11 >= document.documentMode, Qe2 = null, Re2 = null, Se = null, Te = false;
    function Ue2(a2, b, c2) {
      var d = c2.window === c2 ? c2.document : 9 === c2.nodeType ? c2 : c2.ownerDocument;
      Te || null == Qe2 || Qe2 !== Xa(d) || (d = Qe2, "selectionStart" in d && Ne2(d) ? d = { start: d.selectionStart, end: d.selectionEnd } : (d = (d.ownerDocument && d.ownerDocument.defaultView || window).getSelection(), d = { anchorNode: d.anchorNode, anchorOffset: d.anchorOffset, focusNode: d.focusNode, focusOffset: d.focusOffset }), Se && Ie2(Se, d) || (Se = d, d = oe2(Re2, "onSelect"), 0 < d.length && (b = new td("onSelect", "select", null, b, c2), a2.push({ event: b, listeners: d }), b.target = Qe2)));
    }
    function Ve2(a2, b) {
      var c2 = {};
      c2[a2.toLowerCase()] = b.toLowerCase();
      c2["Webkit" + a2] = "webkit" + b;
      c2["Moz" + a2] = "moz" + b;
      return c2;
    }
    var We = { animationend: Ve2("Animation", "AnimationEnd"), animationiteration: Ve2("Animation", "AnimationIteration"), animationstart: Ve2("Animation", "AnimationStart"), transitionend: Ve2("Transition", "TransitionEnd") }, Xe2 = {}, Ye2 = {};
    ia && (Ye2 = document.createElement("div").style, "AnimationEvent" in window || (delete We.animationend.animation, delete We.animationiteration.animation, delete We.animationstart.animation), "TransitionEvent" in window || delete We.transitionend.transition);
    function Ze2(a2) {
      if (Xe2[a2])
        return Xe2[a2];
      if (!We[a2])
        return a2;
      var b = We[a2], c2;
      for (c2 in b)
        if (b.hasOwnProperty(c2) && c2 in Ye2)
          return Xe2[a2] = b[c2];
      return a2;
    }
    var $e2 = Ze2("animationend"), af = Ze2("animationiteration"), bf = Ze2("animationstart"), cf = Ze2("transitionend"), df = /* @__PURE__ */ new Map(), ef = "abort auxClick cancel canPlay canPlayThrough click close contextMenu copy cut drag dragEnd dragEnter dragExit dragLeave dragOver dragStart drop durationChange emptied encrypted ended error gotPointerCapture input invalid keyDown keyPress keyUp load loadedData loadedMetadata loadStart lostPointerCapture mouseDown mouseMove mouseOut mouseOver mouseUp paste pause play playing pointerCancel pointerDown pointerMove pointerOut pointerOver pointerUp progress rateChange reset resize seeked seeking stalled submit suspend timeUpdate touchCancel touchEnd touchStart volumeChange scroll toggle touchMove waiting wheel".split(" ");
    function ff(a2, b) {
      df.set(a2, b);
      fa(b, [a2]);
    }
    for (var gf = 0; gf < ef.length; gf++) {
      var hf = ef[gf], jf = hf.toLowerCase(), kf = hf[0].toUpperCase() + hf.slice(1);
      ff(jf, "on" + kf);
    }
    ff($e2, "onAnimationEnd");
    ff(af, "onAnimationIteration");
    ff(bf, "onAnimationStart");
    ff("dblclick", "onDoubleClick");
    ff("focusin", "onFocus");
    ff("focusout", "onBlur");
    ff(cf, "onTransitionEnd");
    ha("onMouseEnter", ["mouseout", "mouseover"]);
    ha("onMouseLeave", ["mouseout", "mouseover"]);
    ha("onPointerEnter", ["pointerout", "pointerover"]);
    ha("onPointerLeave", ["pointerout", "pointerover"]);
    fa("onChange", "change click focusin focusout input keydown keyup selectionchange".split(" "));
    fa("onSelect", "focusout contextmenu dragend focusin keydown keyup mousedown mouseup selectionchange".split(" "));
    fa("onBeforeInput", ["compositionend", "keypress", "textInput", "paste"]);
    fa("onCompositionEnd", "compositionend focusout keydown keypress keyup mousedown".split(" "));
    fa("onCompositionStart", "compositionstart focusout keydown keypress keyup mousedown".split(" "));
    fa("onCompositionUpdate", "compositionupdate focusout keydown keypress keyup mousedown".split(" "));
    var lf = "abort canplay canplaythrough durationchange emptied encrypted ended error loadeddata loadedmetadata loadstart pause play playing progress ratechange resize seeked seeking stalled suspend timeupdate volumechange waiting".split(" "), mf = new Set("cancel close invalid load scroll toggle".split(" ").concat(lf));
    function nf(a2, b, c2) {
      var d = a2.type || "unknown-event";
      a2.currentTarget = c2;
      Ub(d, b, void 0, a2);
      a2.currentTarget = null;
    }
    function se(a2, b) {
      b = 0 !== (b & 4);
      for (var c2 = 0; c2 < a2.length; c2++) {
        var d = a2[c2], e = d.event;
        d = d.listeners;
        a: {
          var f = void 0;
          if (b)
            for (var g = d.length - 1; 0 <= g; g--) {
              var h = d[g], k = h.instance, l = h.currentTarget;
              h = h.listener;
              if (k !== f && e.isPropagationStopped())
                break a;
              nf(e, h, l);
              f = k;
            }
          else
            for (g = 0; g < d.length; g++) {
              h = d[g];
              k = h.instance;
              l = h.currentTarget;
              h = h.listener;
              if (k !== f && e.isPropagationStopped())
                break a;
              nf(e, h, l);
              f = k;
            }
        }
      }
      if (Qb)
        throw a2 = Rb, Qb = false, Rb = null, a2;
    }
    function D(a2, b) {
      var c2 = b[of];
      void 0 === c2 && (c2 = b[of] = /* @__PURE__ */ new Set());
      var d = a2 + "__bubble";
      c2.has(d) || (pf(b, a2, 2, false), c2.add(d));
    }
    function qf(a2, b, c2) {
      var d = 0;
      b && (d |= 4);
      pf(c2, a2, d, b);
    }
    var rf = "_reactListening" + Math.random().toString(36).slice(2);
    function sf(a2) {
      if (!a2[rf]) {
        a2[rf] = true;
        da.forEach(function(b2) {
          "selectionchange" !== b2 && (mf.has(b2) || qf(b2, false, a2), qf(b2, true, a2));
        });
        var b = 9 === a2.nodeType ? a2 : a2.ownerDocument;
        null === b || b[rf] || (b[rf] = true, qf("selectionchange", false, b));
      }
    }
    function pf(a2, b, c2, d) {
      switch (jd(b)) {
        case 1:
          var e = ed;
          break;
        case 4:
          e = gd;
          break;
        default:
          e = fd;
      }
      c2 = e.bind(null, b, c2, a2);
      e = void 0;
      !Lb || "touchstart" !== b && "touchmove" !== b && "wheel" !== b || (e = true);
      d ? void 0 !== e ? a2.addEventListener(b, c2, { capture: true, passive: e }) : a2.addEventListener(b, c2, true) : void 0 !== e ? a2.addEventListener(b, c2, { passive: e }) : a2.addEventListener(b, c2, false);
    }
    function hd(a2, b, c2, d, e) {
      var f = d;
      if (0 === (b & 1) && 0 === (b & 2) && null !== d)
        a:
          for (; ; ) {
            if (null === d)
              return;
            var g = d.tag;
            if (3 === g || 4 === g) {
              var h = d.stateNode.containerInfo;
              if (h === e || 8 === h.nodeType && h.parentNode === e)
                break;
              if (4 === g)
                for (g = d.return; null !== g; ) {
                  var k = g.tag;
                  if (3 === k || 4 === k) {
                    if (k = g.stateNode.containerInfo, k === e || 8 === k.nodeType && k.parentNode === e)
                      return;
                  }
                  g = g.return;
                }
              for (; null !== h; ) {
                g = Wc(h);
                if (null === g)
                  return;
                k = g.tag;
                if (5 === k || 6 === k) {
                  d = f = g;
                  continue a;
                }
                h = h.parentNode;
              }
            }
            d = d.return;
          }
      Jb(function() {
        var d2 = f, e2 = xb(c2), g2 = [];
        a: {
          var h2 = df.get(a2);
          if (void 0 !== h2) {
            var k2 = td, n = a2;
            switch (a2) {
              case "keypress":
                if (0 === od(c2))
                  break a;
              case "keydown":
              case "keyup":
                k2 = Rd;
                break;
              case "focusin":
                n = "focus";
                k2 = Fd;
                break;
              case "focusout":
                n = "blur";
                k2 = Fd;
                break;
              case "beforeblur":
              case "afterblur":
                k2 = Fd;
                break;
              case "click":
                if (2 === c2.button)
                  break a;
              case "auxclick":
              case "dblclick":
              case "mousedown":
              case "mousemove":
              case "mouseup":
              case "mouseout":
              case "mouseover":
              case "contextmenu":
                k2 = Bd;
                break;
              case "drag":
              case "dragend":
              case "dragenter":
              case "dragexit":
              case "dragleave":
              case "dragover":
              case "dragstart":
              case "drop":
                k2 = Dd;
                break;
              case "touchcancel":
              case "touchend":
              case "touchmove":
              case "touchstart":
                k2 = Vd;
                break;
              case $e2:
              case af:
              case bf:
                k2 = Hd;
                break;
              case cf:
                k2 = Xd;
                break;
              case "scroll":
                k2 = vd;
                break;
              case "wheel":
                k2 = Zd;
                break;
              case "copy":
              case "cut":
              case "paste":
                k2 = Jd;
                break;
              case "gotpointercapture":
              case "lostpointercapture":
              case "pointercancel":
              case "pointerdown":
              case "pointermove":
              case "pointerout":
              case "pointerover":
              case "pointerup":
                k2 = Td;
            }
            var t2 = 0 !== (b & 4), J = !t2 && "scroll" === a2, x2 = t2 ? null !== h2 ? h2 + "Capture" : null : h2;
            t2 = [];
            for (var w = d2, u; null !== w; ) {
              u = w;
              var F = u.stateNode;
              5 === u.tag && null !== F && (u = F, null !== x2 && (F = Kb(w, x2), null != F && t2.push(tf(w, F, u))));
              if (J)
                break;
              w = w.return;
            }
            0 < t2.length && (h2 = new k2(h2, n, null, c2, e2), g2.push({ event: h2, listeners: t2 }));
          }
        }
        if (0 === (b & 7)) {
          a: {
            h2 = "mouseover" === a2 || "pointerover" === a2;
            k2 = "mouseout" === a2 || "pointerout" === a2;
            if (h2 && c2 !== wb && (n = c2.relatedTarget || c2.fromElement) && (Wc(n) || n[uf]))
              break a;
            if (k2 || h2) {
              h2 = e2.window === e2 ? e2 : (h2 = e2.ownerDocument) ? h2.defaultView || h2.parentWindow : window;
              if (k2) {
                if (n = c2.relatedTarget || c2.toElement, k2 = d2, n = n ? Wc(n) : null, null !== n && (J = Vb(n), n !== J || 5 !== n.tag && 6 !== n.tag))
                  n = null;
              } else
                k2 = null, n = d2;
              if (k2 !== n) {
                t2 = Bd;
                F = "onMouseLeave";
                x2 = "onMouseEnter";
                w = "mouse";
                if ("pointerout" === a2 || "pointerover" === a2)
                  t2 = Td, F = "onPointerLeave", x2 = "onPointerEnter", w = "pointer";
                J = null == k2 ? h2 : ue2(k2);
                u = null == n ? h2 : ue2(n);
                h2 = new t2(F, w + "leave", k2, c2, e2);
                h2.target = J;
                h2.relatedTarget = u;
                F = null;
                Wc(e2) === d2 && (t2 = new t2(x2, w + "enter", n, c2, e2), t2.target = u, t2.relatedTarget = J, F = t2);
                J = F;
                if (k2 && n)
                  b: {
                    t2 = k2;
                    x2 = n;
                    w = 0;
                    for (u = t2; u; u = vf(u))
                      w++;
                    u = 0;
                    for (F = x2; F; F = vf(F))
                      u++;
                    for (; 0 < w - u; )
                      t2 = vf(t2), w--;
                    for (; 0 < u - w; )
                      x2 = vf(x2), u--;
                    for (; w--; ) {
                      if (t2 === x2 || null !== x2 && t2 === x2.alternate)
                        break b;
                      t2 = vf(t2);
                      x2 = vf(x2);
                    }
                    t2 = null;
                  }
                else
                  t2 = null;
                null !== k2 && wf(g2, h2, k2, t2, false);
                null !== n && null !== J && wf(g2, J, n, t2, true);
              }
            }
          }
          a: {
            h2 = d2 ? ue2(d2) : window;
            k2 = h2.nodeName && h2.nodeName.toLowerCase();
            if ("select" === k2 || "input" === k2 && "file" === h2.type)
              var na = ve2;
            else if (me2(h2))
              if (we2)
                na = Fe2;
              else {
                na = De;
                var xa = Ce2;
              }
            else
              (k2 = h2.nodeName) && "input" === k2.toLowerCase() && ("checkbox" === h2.type || "radio" === h2.type) && (na = Ee2);
            if (na && (na = na(a2, d2))) {
              ne2(g2, na, c2, e2);
              break a;
            }
            xa && xa(a2, h2, d2);
            "focusout" === a2 && (xa = h2._wrapperState) && xa.controlled && "number" === h2.type && cb(h2, "number", h2.value);
          }
          xa = d2 ? ue2(d2) : window;
          switch (a2) {
            case "focusin":
              if (me2(xa) || "true" === xa.contentEditable)
                Qe2 = xa, Re2 = d2, Se = null;
              break;
            case "focusout":
              Se = Re2 = Qe2 = null;
              break;
            case "mousedown":
              Te = true;
              break;
            case "contextmenu":
            case "mouseup":
            case "dragend":
              Te = false;
              Ue2(g2, c2, e2);
              break;
            case "selectionchange":
              if (Pe2)
                break;
            case "keydown":
            case "keyup":
              Ue2(g2, c2, e2);
          }
          var $a;
          if (ae2)
            b: {
              switch (a2) {
                case "compositionstart":
                  var ba = "onCompositionStart";
                  break b;
                case "compositionend":
                  ba = "onCompositionEnd";
                  break b;
                case "compositionupdate":
                  ba = "onCompositionUpdate";
                  break b;
              }
              ba = void 0;
            }
          else
            ie2 ? ge2(a2, c2) && (ba = "onCompositionEnd") : "keydown" === a2 && 229 === c2.keyCode && (ba = "onCompositionStart");
          ba && (de2 && "ko" !== c2.locale && (ie2 || "onCompositionStart" !== ba ? "onCompositionEnd" === ba && ie2 && ($a = nd()) : (kd = e2, ld = "value" in kd ? kd.value : kd.textContent, ie2 = true)), xa = oe2(d2, ba), 0 < xa.length && (ba = new Ld(ba, a2, null, c2, e2), g2.push({ event: ba, listeners: xa }), $a ? ba.data = $a : ($a = he2(c2), null !== $a && (ba.data = $a))));
          if ($a = ce2 ? je2(a2, c2) : ke2(a2, c2))
            d2 = oe2(d2, "onBeforeInput"), 0 < d2.length && (e2 = new Ld("onBeforeInput", "beforeinput", null, c2, e2), g2.push({ event: e2, listeners: d2 }), e2.data = $a);
        }
        se(g2, b);
      });
    }
    function tf(a2, b, c2) {
      return { instance: a2, listener: b, currentTarget: c2 };
    }
    function oe2(a2, b) {
      for (var c2 = b + "Capture", d = []; null !== a2; ) {
        var e = a2, f = e.stateNode;
        5 === e.tag && null !== f && (e = f, f = Kb(a2, c2), null != f && d.unshift(tf(a2, f, e)), f = Kb(a2, b), null != f && d.push(tf(a2, f, e)));
        a2 = a2.return;
      }
      return d;
    }
    function vf(a2) {
      if (null === a2)
        return null;
      do
        a2 = a2.return;
      while (a2 && 5 !== a2.tag);
      return a2 ? a2 : null;
    }
    function wf(a2, b, c2, d, e) {
      for (var f = b._reactName, g = []; null !== c2 && c2 !== d; ) {
        var h = c2, k = h.alternate, l = h.stateNode;
        if (null !== k && k === d)
          break;
        5 === h.tag && null !== l && (h = l, e ? (k = Kb(c2, f), null != k && g.unshift(tf(c2, k, h))) : e || (k = Kb(c2, f), null != k && g.push(tf(c2, k, h))));
        c2 = c2.return;
      }
      0 !== g.length && a2.push({ event: b, listeners: g });
    }
    var xf = /\r\n?/g, yf = /\u0000|\uFFFD/g;
    function zf(a2) {
      return ("string" === typeof a2 ? a2 : "" + a2).replace(xf, "\n").replace(yf, "");
    }
    function Af(a2, b, c2) {
      b = zf(b);
      if (zf(a2) !== b && c2)
        throw Error(p2(425));
    }
    function Bf() {
    }
    var Cf = null, Df = null;
    function Ef(a2, b) {
      return "textarea" === a2 || "noscript" === a2 || "string" === typeof b.children || "number" === typeof b.children || "object" === typeof b.dangerouslySetInnerHTML && null !== b.dangerouslySetInnerHTML && null != b.dangerouslySetInnerHTML.__html;
    }
    var Ff = "function" === typeof setTimeout ? setTimeout : void 0, Gf = "function" === typeof clearTimeout ? clearTimeout : void 0, Hf = "function" === typeof Promise ? Promise : void 0, Jf = "function" === typeof queueMicrotask ? queueMicrotask : "undefined" !== typeof Hf ? function(a2) {
      return Hf.resolve(null).then(a2).catch(If);
    } : Ff;
    function If(a2) {
      setTimeout(function() {
        throw a2;
      });
    }
    function Kf(a2, b) {
      var c2 = b, d = 0;
      do {
        var e = c2.nextSibling;
        a2.removeChild(c2);
        if (e && 8 === e.nodeType)
          if (c2 = e.data, "/$" === c2) {
            if (0 === d) {
              a2.removeChild(e);
              bd(b);
              return;
            }
            d--;
          } else
            "$" !== c2 && "$?" !== c2 && "$!" !== c2 || d++;
        c2 = e;
      } while (c2);
      bd(b);
    }
    function Lf(a2) {
      for (; null != a2; a2 = a2.nextSibling) {
        var b = a2.nodeType;
        if (1 === b || 3 === b)
          break;
        if (8 === b) {
          b = a2.data;
          if ("$" === b || "$!" === b || "$?" === b)
            break;
          if ("/$" === b)
            return null;
        }
      }
      return a2;
    }
    function Mf(a2) {
      a2 = a2.previousSibling;
      for (var b = 0; a2; ) {
        if (8 === a2.nodeType) {
          var c2 = a2.data;
          if ("$" === c2 || "$!" === c2 || "$?" === c2) {
            if (0 === b)
              return a2;
            b--;
          } else
            "/$" === c2 && b++;
        }
        a2 = a2.previousSibling;
      }
      return null;
    }
    var Nf = Math.random().toString(36).slice(2), Of = "__reactFiber$" + Nf, Pf = "__reactProps$" + Nf, uf = "__reactContainer$" + Nf, of = "__reactEvents$" + Nf, Qf = "__reactListeners$" + Nf, Rf = "__reactHandles$" + Nf;
    function Wc(a2) {
      var b = a2[Of];
      if (b)
        return b;
      for (var c2 = a2.parentNode; c2; ) {
        if (b = c2[uf] || c2[Of]) {
          c2 = b.alternate;
          if (null !== b.child || null !== c2 && null !== c2.child)
            for (a2 = Mf(a2); null !== a2; ) {
              if (c2 = a2[Of])
                return c2;
              a2 = Mf(a2);
            }
          return b;
        }
        a2 = c2;
        c2 = a2.parentNode;
      }
      return null;
    }
    function Cb(a2) {
      a2 = a2[Of] || a2[uf];
      return !a2 || 5 !== a2.tag && 6 !== a2.tag && 13 !== a2.tag && 3 !== a2.tag ? null : a2;
    }
    function ue2(a2) {
      if (5 === a2.tag || 6 === a2.tag)
        return a2.stateNode;
      throw Error(p2(33));
    }
    function Db(a2) {
      return a2[Pf] || null;
    }
    var Sf = [], Tf = -1;
    function Uf(a2) {
      return { current: a2 };
    }
    function E2(a2) {
      0 > Tf || (a2.current = Sf[Tf], Sf[Tf] = null, Tf--);
    }
    function G2(a2, b) {
      Tf++;
      Sf[Tf] = a2.current;
      a2.current = b;
    }
    var Vf = {}, H2 = Uf(Vf), Wf = Uf(false), Xf = Vf;
    function Yf(a2, b) {
      var c2 = a2.type.contextTypes;
      if (!c2)
        return Vf;
      var d = a2.stateNode;
      if (d && d.__reactInternalMemoizedUnmaskedChildContext === b)
        return d.__reactInternalMemoizedMaskedChildContext;
      var e = {}, f;
      for (f in c2)
        e[f] = b[f];
      d && (a2 = a2.stateNode, a2.__reactInternalMemoizedUnmaskedChildContext = b, a2.__reactInternalMemoizedMaskedChildContext = e);
      return e;
    }
    function Zf(a2) {
      a2 = a2.childContextTypes;
      return null !== a2 && void 0 !== a2;
    }
    function $f() {
      E2(Wf);
      E2(H2);
    }
    function ag(a2, b, c2) {
      if (H2.current !== Vf)
        throw Error(p2(168));
      G2(H2, b);
      G2(Wf, c2);
    }
    function bg(a2, b, c2) {
      var d = a2.stateNode;
      b = b.childContextTypes;
      if ("function" !== typeof d.getChildContext)
        return c2;
      d = d.getChildContext();
      for (var e in d)
        if (!(e in b))
          throw Error(p2(108, Ra(a2) || "Unknown", e));
      return A2({}, c2, d);
    }
    function cg(a2) {
      a2 = (a2 = a2.stateNode) && a2.__reactInternalMemoizedMergedChildContext || Vf;
      Xf = H2.current;
      G2(H2, a2);
      G2(Wf, Wf.current);
      return true;
    }
    function dg(a2, b, c2) {
      var d = a2.stateNode;
      if (!d)
        throw Error(p2(169));
      c2 ? (a2 = bg(a2, b, Xf), d.__reactInternalMemoizedMergedChildContext = a2, E2(Wf), E2(H2), G2(H2, a2)) : E2(Wf);
      G2(Wf, c2);
    }
    var eg = null, fg = false, gg = false;
    function hg(a2) {
      null === eg ? eg = [a2] : eg.push(a2);
    }
    function ig(a2) {
      fg = true;
      hg(a2);
    }
    function jg() {
      if (!gg && null !== eg) {
        gg = true;
        var a2 = 0, b = C2;
        try {
          var c2 = eg;
          for (C2 = 1; a2 < c2.length; a2++) {
            var d = c2[a2];
            do
              d = d(true);
            while (null !== d);
          }
          eg = null;
          fg = false;
        } catch (e) {
          throw null !== eg && (eg = eg.slice(a2 + 1)), ac(fc, jg), e;
        } finally {
          C2 = b, gg = false;
        }
      }
      return null;
    }
    var kg = [], lg = 0, mg = null, ng = 0, og = [], pg = 0, qg = null, rg = 1, sg = "";
    function tg(a2, b) {
      kg[lg++] = ng;
      kg[lg++] = mg;
      mg = a2;
      ng = b;
    }
    function ug(a2, b, c2) {
      og[pg++] = rg;
      og[pg++] = sg;
      og[pg++] = qg;
      qg = a2;
      var d = rg;
      a2 = sg;
      var e = 32 - oc(d) - 1;
      d &= ~(1 << e);
      c2 += 1;
      var f = 32 - oc(b) + e;
      if (30 < f) {
        var g = e - e % 5;
        f = (d & (1 << g) - 1).toString(32);
        d >>= g;
        e -= g;
        rg = 1 << 32 - oc(b) + e | c2 << e | d;
        sg = f + a2;
      } else
        rg = 1 << f | c2 << e | d, sg = a2;
    }
    function vg(a2) {
      null !== a2.return && (tg(a2, 1), ug(a2, 1, 0));
    }
    function wg(a2) {
      for (; a2 === mg; )
        mg = kg[--lg], kg[lg] = null, ng = kg[--lg], kg[lg] = null;
      for (; a2 === qg; )
        qg = og[--pg], og[pg] = null, sg = og[--pg], og[pg] = null, rg = og[--pg], og[pg] = null;
    }
    var xg = null, yg = null, I = false, zg = null;
    function Ag(a2, b) {
      var c2 = Bg(5, null, null, 0);
      c2.elementType = "DELETED";
      c2.stateNode = b;
      c2.return = a2;
      b = a2.deletions;
      null === b ? (a2.deletions = [c2], a2.flags |= 16) : b.push(c2);
    }
    function Cg(a2, b) {
      switch (a2.tag) {
        case 5:
          var c2 = a2.type;
          b = 1 !== b.nodeType || c2.toLowerCase() !== b.nodeName.toLowerCase() ? null : b;
          return null !== b ? (a2.stateNode = b, xg = a2, yg = Lf(b.firstChild), true) : false;
        case 6:
          return b = "" === a2.pendingProps || 3 !== b.nodeType ? null : b, null !== b ? (a2.stateNode = b, xg = a2, yg = null, true) : false;
        case 13:
          return b = 8 !== b.nodeType ? null : b, null !== b ? (c2 = null !== qg ? { id: rg, overflow: sg } : null, a2.memoizedState = { dehydrated: b, treeContext: c2, retryLane: 1073741824 }, c2 = Bg(18, null, null, 0), c2.stateNode = b, c2.return = a2, a2.child = c2, xg = a2, yg = null, true) : false;
        default:
          return false;
      }
    }
    function Dg(a2) {
      return 0 !== (a2.mode & 1) && 0 === (a2.flags & 128);
    }
    function Eg(a2) {
      if (I) {
        var b = yg;
        if (b) {
          var c2 = b;
          if (!Cg(a2, b)) {
            if (Dg(a2))
              throw Error(p2(418));
            b = Lf(c2.nextSibling);
            var d = xg;
            b && Cg(a2, b) ? Ag(d, c2) : (a2.flags = a2.flags & -4097 | 2, I = false, xg = a2);
          }
        } else {
          if (Dg(a2))
            throw Error(p2(418));
          a2.flags = a2.flags & -4097 | 2;
          I = false;
          xg = a2;
        }
      }
    }
    function Fg(a2) {
      for (a2 = a2.return; null !== a2 && 5 !== a2.tag && 3 !== a2.tag && 13 !== a2.tag; )
        a2 = a2.return;
      xg = a2;
    }
    function Gg(a2) {
      if (a2 !== xg)
        return false;
      if (!I)
        return Fg(a2), I = true, false;
      var b;
      (b = 3 !== a2.tag) && !(b = 5 !== a2.tag) && (b = a2.type, b = "head" !== b && "body" !== b && !Ef(a2.type, a2.memoizedProps));
      if (b && (b = yg)) {
        if (Dg(a2))
          throw Hg(), Error(p2(418));
        for (; b; )
          Ag(a2, b), b = Lf(b.nextSibling);
      }
      Fg(a2);
      if (13 === a2.tag) {
        a2 = a2.memoizedState;
        a2 = null !== a2 ? a2.dehydrated : null;
        if (!a2)
          throw Error(p2(317));
        a: {
          a2 = a2.nextSibling;
          for (b = 0; a2; ) {
            if (8 === a2.nodeType) {
              var c2 = a2.data;
              if ("/$" === c2) {
                if (0 === b) {
                  yg = Lf(a2.nextSibling);
                  break a;
                }
                b--;
              } else
                "$" !== c2 && "$!" !== c2 && "$?" !== c2 || b++;
            }
            a2 = a2.nextSibling;
          }
          yg = null;
        }
      } else
        yg = xg ? Lf(a2.stateNode.nextSibling) : null;
      return true;
    }
    function Hg() {
      for (var a2 = yg; a2; )
        a2 = Lf(a2.nextSibling);
    }
    function Ig() {
      yg = xg = null;
      I = false;
    }
    function Jg(a2) {
      null === zg ? zg = [a2] : zg.push(a2);
    }
    var Kg = ua.ReactCurrentBatchConfig;
    function Lg(a2, b, c2) {
      a2 = c2.ref;
      if (null !== a2 && "function" !== typeof a2 && "object" !== typeof a2) {
        if (c2._owner) {
          c2 = c2._owner;
          if (c2) {
            if (1 !== c2.tag)
              throw Error(p2(309));
            var d = c2.stateNode;
          }
          if (!d)
            throw Error(p2(147, a2));
          var e = d, f = "" + a2;
          if (null !== b && null !== b.ref && "function" === typeof b.ref && b.ref._stringRef === f)
            return b.ref;
          b = function(a3) {
            var b2 = e.refs;
            null === a3 ? delete b2[f] : b2[f] = a3;
          };
          b._stringRef = f;
          return b;
        }
        if ("string" !== typeof a2)
          throw Error(p2(284));
        if (!c2._owner)
          throw Error(p2(290, a2));
      }
      return a2;
    }
    function Mg(a2, b) {
      a2 = Object.prototype.toString.call(b);
      throw Error(p2(31, "[object Object]" === a2 ? "object with keys {" + Object.keys(b).join(", ") + "}" : a2));
    }
    function Ng(a2) {
      var b = a2._init;
      return b(a2._payload);
    }
    function Og(a2) {
      function b(b2, c3) {
        if (a2) {
          var d2 = b2.deletions;
          null === d2 ? (b2.deletions = [c3], b2.flags |= 16) : d2.push(c3);
        }
      }
      function c2(c3, d2) {
        if (!a2)
          return null;
        for (; null !== d2; )
          b(c3, d2), d2 = d2.sibling;
        return null;
      }
      function d(a3, b2) {
        for (a3 = /* @__PURE__ */ new Map(); null !== b2; )
          null !== b2.key ? a3.set(b2.key, b2) : a3.set(b2.index, b2), b2 = b2.sibling;
        return a3;
      }
      function e(a3, b2) {
        a3 = Pg(a3, b2);
        a3.index = 0;
        a3.sibling = null;
        return a3;
      }
      function f(b2, c3, d2) {
        b2.index = d2;
        if (!a2)
          return b2.flags |= 1048576, c3;
        d2 = b2.alternate;
        if (null !== d2)
          return d2 = d2.index, d2 < c3 ? (b2.flags |= 2, c3) : d2;
        b2.flags |= 2;
        return c3;
      }
      function g(b2) {
        a2 && null === b2.alternate && (b2.flags |= 2);
        return b2;
      }
      function h(a3, b2, c3, d2) {
        if (null === b2 || 6 !== b2.tag)
          return b2 = Qg(c3, a3.mode, d2), b2.return = a3, b2;
        b2 = e(b2, c3);
        b2.return = a3;
        return b2;
      }
      function k(a3, b2, c3, d2) {
        var f2 = c3.type;
        if (f2 === ya)
          return m2(a3, b2, c3.props.children, d2, c3.key);
        if (null !== b2 && (b2.elementType === f2 || "object" === typeof f2 && null !== f2 && f2.$$typeof === Ha && Ng(f2) === b2.type))
          return d2 = e(b2, c3.props), d2.ref = Lg(a3, b2, c3), d2.return = a3, d2;
        d2 = Rg(c3.type, c3.key, c3.props, null, a3.mode, d2);
        d2.ref = Lg(a3, b2, c3);
        d2.return = a3;
        return d2;
      }
      function l(a3, b2, c3, d2) {
        if (null === b2 || 4 !== b2.tag || b2.stateNode.containerInfo !== c3.containerInfo || b2.stateNode.implementation !== c3.implementation)
          return b2 = Sg(c3, a3.mode, d2), b2.return = a3, b2;
        b2 = e(b2, c3.children || []);
        b2.return = a3;
        return b2;
      }
      function m2(a3, b2, c3, d2, f2) {
        if (null === b2 || 7 !== b2.tag)
          return b2 = Tg(c3, a3.mode, d2, f2), b2.return = a3, b2;
        b2 = e(b2, c3);
        b2.return = a3;
        return b2;
      }
      function q2(a3, b2, c3) {
        if ("string" === typeof b2 && "" !== b2 || "number" === typeof b2)
          return b2 = Qg("" + b2, a3.mode, c3), b2.return = a3, b2;
        if ("object" === typeof b2 && null !== b2) {
          switch (b2.$$typeof) {
            case va:
              return c3 = Rg(b2.type, b2.key, b2.props, null, a3.mode, c3), c3.ref = Lg(a3, null, b2), c3.return = a3, c3;
            case wa:
              return b2 = Sg(b2, a3.mode, c3), b2.return = a3, b2;
            case Ha:
              var d2 = b2._init;
              return q2(a3, d2(b2._payload), c3);
          }
          if (eb(b2) || Ka(b2))
            return b2 = Tg(b2, a3.mode, c3, null), b2.return = a3, b2;
          Mg(a3, b2);
        }
        return null;
      }
      function r2(a3, b2, c3, d2) {
        var e2 = null !== b2 ? b2.key : null;
        if ("string" === typeof c3 && "" !== c3 || "number" === typeof c3)
          return null !== e2 ? null : h(a3, b2, "" + c3, d2);
        if ("object" === typeof c3 && null !== c3) {
          switch (c3.$$typeof) {
            case va:
              return c3.key === e2 ? k(a3, b2, c3, d2) : null;
            case wa:
              return c3.key === e2 ? l(a3, b2, c3, d2) : null;
            case Ha:
              return e2 = c3._init, r2(
                a3,
                b2,
                e2(c3._payload),
                d2
              );
          }
          if (eb(c3) || Ka(c3))
            return null !== e2 ? null : m2(a3, b2, c3, d2, null);
          Mg(a3, c3);
        }
        return null;
      }
      function y(a3, b2, c3, d2, e2) {
        if ("string" === typeof d2 && "" !== d2 || "number" === typeof d2)
          return a3 = a3.get(c3) || null, h(b2, a3, "" + d2, e2);
        if ("object" === typeof d2 && null !== d2) {
          switch (d2.$$typeof) {
            case va:
              return a3 = a3.get(null === d2.key ? c3 : d2.key) || null, k(b2, a3, d2, e2);
            case wa:
              return a3 = a3.get(null === d2.key ? c3 : d2.key) || null, l(b2, a3, d2, e2);
            case Ha:
              var f2 = d2._init;
              return y(a3, b2, c3, f2(d2._payload), e2);
          }
          if (eb(d2) || Ka(d2))
            return a3 = a3.get(c3) || null, m2(b2, a3, d2, e2, null);
          Mg(b2, d2);
        }
        return null;
      }
      function n(e2, g2, h2, k2) {
        for (var l2 = null, m3 = null, u = g2, w = g2 = 0, x2 = null; null !== u && w < h2.length; w++) {
          u.index > w ? (x2 = u, u = null) : x2 = u.sibling;
          var n2 = r2(e2, u, h2[w], k2);
          if (null === n2) {
            null === u && (u = x2);
            break;
          }
          a2 && u && null === n2.alternate && b(e2, u);
          g2 = f(n2, g2, w);
          null === m3 ? l2 = n2 : m3.sibling = n2;
          m3 = n2;
          u = x2;
        }
        if (w === h2.length)
          return c2(e2, u), I && tg(e2, w), l2;
        if (null === u) {
          for (; w < h2.length; w++)
            u = q2(e2, h2[w], k2), null !== u && (g2 = f(u, g2, w), null === m3 ? l2 = u : m3.sibling = u, m3 = u);
          I && tg(e2, w);
          return l2;
        }
        for (u = d(e2, u); w < h2.length; w++)
          x2 = y(u, e2, w, h2[w], k2), null !== x2 && (a2 && null !== x2.alternate && u.delete(null === x2.key ? w : x2.key), g2 = f(x2, g2, w), null === m3 ? l2 = x2 : m3.sibling = x2, m3 = x2);
        a2 && u.forEach(function(a3) {
          return b(e2, a3);
        });
        I && tg(e2, w);
        return l2;
      }
      function t2(e2, g2, h2, k2) {
        var l2 = Ka(h2);
        if ("function" !== typeof l2)
          throw Error(p2(150));
        h2 = l2.call(h2);
        if (null == h2)
          throw Error(p2(151));
        for (var u = l2 = null, m3 = g2, w = g2 = 0, x2 = null, n2 = h2.next(); null !== m3 && !n2.done; w++, n2 = h2.next()) {
          m3.index > w ? (x2 = m3, m3 = null) : x2 = m3.sibling;
          var t3 = r2(e2, m3, n2.value, k2);
          if (null === t3) {
            null === m3 && (m3 = x2);
            break;
          }
          a2 && m3 && null === t3.alternate && b(e2, m3);
          g2 = f(t3, g2, w);
          null === u ? l2 = t3 : u.sibling = t3;
          u = t3;
          m3 = x2;
        }
        if (n2.done)
          return c2(
            e2,
            m3
          ), I && tg(e2, w), l2;
        if (null === m3) {
          for (; !n2.done; w++, n2 = h2.next())
            n2 = q2(e2, n2.value, k2), null !== n2 && (g2 = f(n2, g2, w), null === u ? l2 = n2 : u.sibling = n2, u = n2);
          I && tg(e2, w);
          return l2;
        }
        for (m3 = d(e2, m3); !n2.done; w++, n2 = h2.next())
          n2 = y(m3, e2, w, n2.value, k2), null !== n2 && (a2 && null !== n2.alternate && m3.delete(null === n2.key ? w : n2.key), g2 = f(n2, g2, w), null === u ? l2 = n2 : u.sibling = n2, u = n2);
        a2 && m3.forEach(function(a3) {
          return b(e2, a3);
        });
        I && tg(e2, w);
        return l2;
      }
      function J(a3, d2, f2, h2) {
        "object" === typeof f2 && null !== f2 && f2.type === ya && null === f2.key && (f2 = f2.props.children);
        if ("object" === typeof f2 && null !== f2) {
          switch (f2.$$typeof) {
            case va:
              a: {
                for (var k2 = f2.key, l2 = d2; null !== l2; ) {
                  if (l2.key === k2) {
                    k2 = f2.type;
                    if (k2 === ya) {
                      if (7 === l2.tag) {
                        c2(a3, l2.sibling);
                        d2 = e(l2, f2.props.children);
                        d2.return = a3;
                        a3 = d2;
                        break a;
                      }
                    } else if (l2.elementType === k2 || "object" === typeof k2 && null !== k2 && k2.$$typeof === Ha && Ng(k2) === l2.type) {
                      c2(a3, l2.sibling);
                      d2 = e(l2, f2.props);
                      d2.ref = Lg(a3, l2, f2);
                      d2.return = a3;
                      a3 = d2;
                      break a;
                    }
                    c2(a3, l2);
                    break;
                  } else
                    b(a3, l2);
                  l2 = l2.sibling;
                }
                f2.type === ya ? (d2 = Tg(f2.props.children, a3.mode, h2, f2.key), d2.return = a3, a3 = d2) : (h2 = Rg(f2.type, f2.key, f2.props, null, a3.mode, h2), h2.ref = Lg(a3, d2, f2), h2.return = a3, a3 = h2);
              }
              return g(a3);
            case wa:
              a: {
                for (l2 = f2.key; null !== d2; ) {
                  if (d2.key === l2)
                    if (4 === d2.tag && d2.stateNode.containerInfo === f2.containerInfo && d2.stateNode.implementation === f2.implementation) {
                      c2(a3, d2.sibling);
                      d2 = e(d2, f2.children || []);
                      d2.return = a3;
                      a3 = d2;
                      break a;
                    } else {
                      c2(a3, d2);
                      break;
                    }
                  else
                    b(a3, d2);
                  d2 = d2.sibling;
                }
                d2 = Sg(f2, a3.mode, h2);
                d2.return = a3;
                a3 = d2;
              }
              return g(a3);
            case Ha:
              return l2 = f2._init, J(a3, d2, l2(f2._payload), h2);
          }
          if (eb(f2))
            return n(a3, d2, f2, h2);
          if (Ka(f2))
            return t2(a3, d2, f2, h2);
          Mg(a3, f2);
        }
        return "string" === typeof f2 && "" !== f2 || "number" === typeof f2 ? (f2 = "" + f2, null !== d2 && 6 === d2.tag ? (c2(a3, d2.sibling), d2 = e(d2, f2), d2.return = a3, a3 = d2) : (c2(a3, d2), d2 = Qg(f2, a3.mode, h2), d2.return = a3, a3 = d2), g(a3)) : c2(a3, d2);
      }
      return J;
    }
    var Ug = Og(true), Vg = Og(false), Wg = Uf(null), Xg = null, Yg = null, Zg = null;
    function $g() {
      Zg = Yg = Xg = null;
    }
    function ah(a2) {
      var b = Wg.current;
      E2(Wg);
      a2._currentValue = b;
    }
    function bh(a2, b, c2) {
      for (; null !== a2; ) {
        var d = a2.alternate;
        (a2.childLanes & b) !== b ? (a2.childLanes |= b, null !== d && (d.childLanes |= b)) : null !== d && (d.childLanes & b) !== b && (d.childLanes |= b);
        if (a2 === c2)
          break;
        a2 = a2.return;
      }
    }
    function ch(a2, b) {
      Xg = a2;
      Zg = Yg = null;
      a2 = a2.dependencies;
      null !== a2 && null !== a2.firstContext && (0 !== (a2.lanes & b) && (dh = true), a2.firstContext = null);
    }
    function eh(a2) {
      var b = a2._currentValue;
      if (Zg !== a2)
        if (a2 = { context: a2, memoizedValue: b, next: null }, null === Yg) {
          if (null === Xg)
            throw Error(p2(308));
          Yg = a2;
          Xg.dependencies = { lanes: 0, firstContext: a2 };
        } else
          Yg = Yg.next = a2;
      return b;
    }
    var fh = null;
    function gh(a2) {
      null === fh ? fh = [a2] : fh.push(a2);
    }
    function hh(a2, b, c2, d) {
      var e = b.interleaved;
      null === e ? (c2.next = c2, gh(b)) : (c2.next = e.next, e.next = c2);
      b.interleaved = c2;
      return ih(a2, d);
    }
    function ih(a2, b) {
      a2.lanes |= b;
      var c2 = a2.alternate;
      null !== c2 && (c2.lanes |= b);
      c2 = a2;
      for (a2 = a2.return; null !== a2; )
        a2.childLanes |= b, c2 = a2.alternate, null !== c2 && (c2.childLanes |= b), c2 = a2, a2 = a2.return;
      return 3 === c2.tag ? c2.stateNode : null;
    }
    var jh = false;
    function kh(a2) {
      a2.updateQueue = { baseState: a2.memoizedState, firstBaseUpdate: null, lastBaseUpdate: null, shared: { pending: null, interleaved: null, lanes: 0 }, effects: null };
    }
    function lh(a2, b) {
      a2 = a2.updateQueue;
      b.updateQueue === a2 && (b.updateQueue = { baseState: a2.baseState, firstBaseUpdate: a2.firstBaseUpdate, lastBaseUpdate: a2.lastBaseUpdate, shared: a2.shared, effects: a2.effects });
    }
    function mh(a2, b) {
      return { eventTime: a2, lane: b, tag: 0, payload: null, callback: null, next: null };
    }
    function nh(a2, b, c2) {
      var d = a2.updateQueue;
      if (null === d)
        return null;
      d = d.shared;
      if (0 !== (K & 2)) {
        var e = d.pending;
        null === e ? b.next = b : (b.next = e.next, e.next = b);
        d.pending = b;
        return ih(a2, c2);
      }
      e = d.interleaved;
      null === e ? (b.next = b, gh(d)) : (b.next = e.next, e.next = b);
      d.interleaved = b;
      return ih(a2, c2);
    }
    function oh(a2, b, c2) {
      b = b.updateQueue;
      if (null !== b && (b = b.shared, 0 !== (c2 & 4194240))) {
        var d = b.lanes;
        d &= a2.pendingLanes;
        c2 |= d;
        b.lanes = c2;
        Cc(a2, c2);
      }
    }
    function ph(a2, b) {
      var c2 = a2.updateQueue, d = a2.alternate;
      if (null !== d && (d = d.updateQueue, c2 === d)) {
        var e = null, f = null;
        c2 = c2.firstBaseUpdate;
        if (null !== c2) {
          do {
            var g = { eventTime: c2.eventTime, lane: c2.lane, tag: c2.tag, payload: c2.payload, callback: c2.callback, next: null };
            null === f ? e = f = g : f = f.next = g;
            c2 = c2.next;
          } while (null !== c2);
          null === f ? e = f = b : f = f.next = b;
        } else
          e = f = b;
        c2 = { baseState: d.baseState, firstBaseUpdate: e, lastBaseUpdate: f, shared: d.shared, effects: d.effects };
        a2.updateQueue = c2;
        return;
      }
      a2 = c2.lastBaseUpdate;
      null === a2 ? c2.firstBaseUpdate = b : a2.next = b;
      c2.lastBaseUpdate = b;
    }
    function qh(a2, b, c2, d) {
      var e = a2.updateQueue;
      jh = false;
      var f = e.firstBaseUpdate, g = e.lastBaseUpdate, h = e.shared.pending;
      if (null !== h) {
        e.shared.pending = null;
        var k = h, l = k.next;
        k.next = null;
        null === g ? f = l : g.next = l;
        g = k;
        var m2 = a2.alternate;
        null !== m2 && (m2 = m2.updateQueue, h = m2.lastBaseUpdate, h !== g && (null === h ? m2.firstBaseUpdate = l : h.next = l, m2.lastBaseUpdate = k));
      }
      if (null !== f) {
        var q2 = e.baseState;
        g = 0;
        m2 = l = k = null;
        h = f;
        do {
          var r2 = h.lane, y = h.eventTime;
          if ((d & r2) === r2) {
            null !== m2 && (m2 = m2.next = {
              eventTime: y,
              lane: 0,
              tag: h.tag,
              payload: h.payload,
              callback: h.callback,
              next: null
            });
            a: {
              var n = a2, t2 = h;
              r2 = b;
              y = c2;
              switch (t2.tag) {
                case 1:
                  n = t2.payload;
                  if ("function" === typeof n) {
                    q2 = n.call(y, q2, r2);
                    break a;
                  }
                  q2 = n;
                  break a;
                case 3:
                  n.flags = n.flags & -65537 | 128;
                case 0:
                  n = t2.payload;
                  r2 = "function" === typeof n ? n.call(y, q2, r2) : n;
                  if (null === r2 || void 0 === r2)
                    break a;
                  q2 = A2({}, q2, r2);
                  break a;
                case 2:
                  jh = true;
              }
            }
            null !== h.callback && 0 !== h.lane && (a2.flags |= 64, r2 = e.effects, null === r2 ? e.effects = [h] : r2.push(h));
          } else
            y = { eventTime: y, lane: r2, tag: h.tag, payload: h.payload, callback: h.callback, next: null }, null === m2 ? (l = m2 = y, k = q2) : m2 = m2.next = y, g |= r2;
          h = h.next;
          if (null === h)
            if (h = e.shared.pending, null === h)
              break;
            else
              r2 = h, h = r2.next, r2.next = null, e.lastBaseUpdate = r2, e.shared.pending = null;
        } while (1);
        null === m2 && (k = q2);
        e.baseState = k;
        e.firstBaseUpdate = l;
        e.lastBaseUpdate = m2;
        b = e.shared.interleaved;
        if (null !== b) {
          e = b;
          do
            g |= e.lane, e = e.next;
          while (e !== b);
        } else
          null === f && (e.shared.lanes = 0);
        rh |= g;
        a2.lanes = g;
        a2.memoizedState = q2;
      }
    }
    function sh(a2, b, c2) {
      a2 = b.effects;
      b.effects = null;
      if (null !== a2)
        for (b = 0; b < a2.length; b++) {
          var d = a2[b], e = d.callback;
          if (null !== e) {
            d.callback = null;
            d = c2;
            if ("function" !== typeof e)
              throw Error(p2(191, e));
            e.call(d);
          }
        }
    }
    var th = {}, uh = Uf(th), vh = Uf(th), wh = Uf(th);
    function xh(a2) {
      if (a2 === th)
        throw Error(p2(174));
      return a2;
    }
    function yh(a2, b) {
      G2(wh, b);
      G2(vh, a2);
      G2(uh, th);
      a2 = b.nodeType;
      switch (a2) {
        case 9:
        case 11:
          b = (b = b.documentElement) ? b.namespaceURI : lb(null, "");
          break;
        default:
          a2 = 8 === a2 ? b.parentNode : b, b = a2.namespaceURI || null, a2 = a2.tagName, b = lb(b, a2);
      }
      E2(uh);
      G2(uh, b);
    }
    function zh() {
      E2(uh);
      E2(vh);
      E2(wh);
    }
    function Ah(a2) {
      xh(wh.current);
      var b = xh(uh.current);
      var c2 = lb(b, a2.type);
      b !== c2 && (G2(vh, a2), G2(uh, c2));
    }
    function Bh(a2) {
      vh.current === a2 && (E2(uh), E2(vh));
    }
    var L2 = Uf(0);
    function Ch(a2) {
      for (var b = a2; null !== b; ) {
        if (13 === b.tag) {
          var c2 = b.memoizedState;
          if (null !== c2 && (c2 = c2.dehydrated, null === c2 || "$?" === c2.data || "$!" === c2.data))
            return b;
        } else if (19 === b.tag && void 0 !== b.memoizedProps.revealOrder) {
          if (0 !== (b.flags & 128))
            return b;
        } else if (null !== b.child) {
          b.child.return = b;
          b = b.child;
          continue;
        }
        if (b === a2)
          break;
        for (; null === b.sibling; ) {
          if (null === b.return || b.return === a2)
            return null;
          b = b.return;
        }
        b.sibling.return = b.return;
        b = b.sibling;
      }
      return null;
    }
    var Dh = [];
    function Eh() {
      for (var a2 = 0; a2 < Dh.length; a2++)
        Dh[a2]._workInProgressVersionPrimary = null;
      Dh.length = 0;
    }
    var Fh = ua.ReactCurrentDispatcher, Gh = ua.ReactCurrentBatchConfig, Hh = 0, M2 = null, N = null, O = null, Ih = false, Jh = false, Kh = 0, Lh = 0;
    function P2() {
      throw Error(p2(321));
    }
    function Mh(a2, b) {
      if (null === b)
        return false;
      for (var c2 = 0; c2 < b.length && c2 < a2.length; c2++)
        if (!He2(a2[c2], b[c2]))
          return false;
      return true;
    }
    function Nh(a2, b, c2, d, e, f) {
      Hh = f;
      M2 = b;
      b.memoizedState = null;
      b.updateQueue = null;
      b.lanes = 0;
      Fh.current = null === a2 || null === a2.memoizedState ? Oh : Ph;
      a2 = c2(d, e);
      if (Jh) {
        f = 0;
        do {
          Jh = false;
          Kh = 0;
          if (25 <= f)
            throw Error(p2(301));
          f += 1;
          O = N = null;
          b.updateQueue = null;
          Fh.current = Qh;
          a2 = c2(d, e);
        } while (Jh);
      }
      Fh.current = Rh;
      b = null !== N && null !== N.next;
      Hh = 0;
      O = N = M2 = null;
      Ih = false;
      if (b)
        throw Error(p2(300));
      return a2;
    }
    function Sh() {
      var a2 = 0 !== Kh;
      Kh = 0;
      return a2;
    }
    function Th() {
      var a2 = { memoizedState: null, baseState: null, baseQueue: null, queue: null, next: null };
      null === O ? M2.memoizedState = O = a2 : O = O.next = a2;
      return O;
    }
    function Uh() {
      if (null === N) {
        var a2 = M2.alternate;
        a2 = null !== a2 ? a2.memoizedState : null;
      } else
        a2 = N.next;
      var b = null === O ? M2.memoizedState : O.next;
      if (null !== b)
        O = b, N = a2;
      else {
        if (null === a2)
          throw Error(p2(310));
        N = a2;
        a2 = { memoizedState: N.memoizedState, baseState: N.baseState, baseQueue: N.baseQueue, queue: N.queue, next: null };
        null === O ? M2.memoizedState = O = a2 : O = O.next = a2;
      }
      return O;
    }
    function Vh(a2, b) {
      return "function" === typeof b ? b(a2) : b;
    }
    function Wh(a2) {
      var b = Uh(), c2 = b.queue;
      if (null === c2)
        throw Error(p2(311));
      c2.lastRenderedReducer = a2;
      var d = N, e = d.baseQueue, f = c2.pending;
      if (null !== f) {
        if (null !== e) {
          var g = e.next;
          e.next = f.next;
          f.next = g;
        }
        d.baseQueue = e = f;
        c2.pending = null;
      }
      if (null !== e) {
        f = e.next;
        d = d.baseState;
        var h = g = null, k = null, l = f;
        do {
          var m2 = l.lane;
          if ((Hh & m2) === m2)
            null !== k && (k = k.next = { lane: 0, action: l.action, hasEagerState: l.hasEagerState, eagerState: l.eagerState, next: null }), d = l.hasEagerState ? l.eagerState : a2(d, l.action);
          else {
            var q2 = {
              lane: m2,
              action: l.action,
              hasEagerState: l.hasEagerState,
              eagerState: l.eagerState,
              next: null
            };
            null === k ? (h = k = q2, g = d) : k = k.next = q2;
            M2.lanes |= m2;
            rh |= m2;
          }
          l = l.next;
        } while (null !== l && l !== f);
        null === k ? g = d : k.next = h;
        He2(d, b.memoizedState) || (dh = true);
        b.memoizedState = d;
        b.baseState = g;
        b.baseQueue = k;
        c2.lastRenderedState = d;
      }
      a2 = c2.interleaved;
      if (null !== a2) {
        e = a2;
        do
          f = e.lane, M2.lanes |= f, rh |= f, e = e.next;
        while (e !== a2);
      } else
        null === e && (c2.lanes = 0);
      return [b.memoizedState, c2.dispatch];
    }
    function Xh(a2) {
      var b = Uh(), c2 = b.queue;
      if (null === c2)
        throw Error(p2(311));
      c2.lastRenderedReducer = a2;
      var d = c2.dispatch, e = c2.pending, f = b.memoizedState;
      if (null !== e) {
        c2.pending = null;
        var g = e = e.next;
        do
          f = a2(f, g.action), g = g.next;
        while (g !== e);
        He2(f, b.memoizedState) || (dh = true);
        b.memoizedState = f;
        null === b.baseQueue && (b.baseState = f);
        c2.lastRenderedState = f;
      }
      return [f, d];
    }
    function Yh() {
    }
    function Zh(a2, b) {
      var c2 = M2, d = Uh(), e = b(), f = !He2(d.memoizedState, e);
      f && (d.memoizedState = e, dh = true);
      d = d.queue;
      $h(ai2.bind(null, c2, d, a2), [a2]);
      if (d.getSnapshot !== b || f || null !== O && O.memoizedState.tag & 1) {
        c2.flags |= 2048;
        bi2(9, ci2.bind(null, c2, d, e, b), void 0, null);
        if (null === Q2)
          throw Error(p2(349));
        0 !== (Hh & 30) || di2(c2, b, e);
      }
      return e;
    }
    function di2(a2, b, c2) {
      a2.flags |= 16384;
      a2 = { getSnapshot: b, value: c2 };
      b = M2.updateQueue;
      null === b ? (b = { lastEffect: null, stores: null }, M2.updateQueue = b, b.stores = [a2]) : (c2 = b.stores, null === c2 ? b.stores = [a2] : c2.push(a2));
    }
    function ci2(a2, b, c2, d) {
      b.value = c2;
      b.getSnapshot = d;
      ei2(b) && fi2(a2);
    }
    function ai2(a2, b, c2) {
      return c2(function() {
        ei2(b) && fi2(a2);
      });
    }
    function ei2(a2) {
      var b = a2.getSnapshot;
      a2 = a2.value;
      try {
        var c2 = b();
        return !He2(a2, c2);
      } catch (d) {
        return true;
      }
    }
    function fi2(a2) {
      var b = ih(a2, 1);
      null !== b && gi2(b, a2, 1, -1);
    }
    function hi(a2) {
      var b = Th();
      "function" === typeof a2 && (a2 = a2());
      b.memoizedState = b.baseState = a2;
      a2 = { pending: null, interleaved: null, lanes: 0, dispatch: null, lastRenderedReducer: Vh, lastRenderedState: a2 };
      b.queue = a2;
      a2 = a2.dispatch = ii2.bind(null, M2, a2);
      return [b.memoizedState, a2];
    }
    function bi2(a2, b, c2, d) {
      a2 = { tag: a2, create: b, destroy: c2, deps: d, next: null };
      b = M2.updateQueue;
      null === b ? (b = { lastEffect: null, stores: null }, M2.updateQueue = b, b.lastEffect = a2.next = a2) : (c2 = b.lastEffect, null === c2 ? b.lastEffect = a2.next = a2 : (d = c2.next, c2.next = a2, a2.next = d, b.lastEffect = a2));
      return a2;
    }
    function ji2() {
      return Uh().memoizedState;
    }
    function ki2(a2, b, c2, d) {
      var e = Th();
      M2.flags |= a2;
      e.memoizedState = bi2(1 | b, c2, void 0, void 0 === d ? null : d);
    }
    function li2(a2, b, c2, d) {
      var e = Uh();
      d = void 0 === d ? null : d;
      var f = void 0;
      if (null !== N) {
        var g = N.memoizedState;
        f = g.destroy;
        if (null !== d && Mh(d, g.deps)) {
          e.memoizedState = bi2(b, c2, f, d);
          return;
        }
      }
      M2.flags |= a2;
      e.memoizedState = bi2(1 | b, c2, f, d);
    }
    function mi2(a2, b) {
      return ki2(8390656, 8, a2, b);
    }
    function $h(a2, b) {
      return li2(2048, 8, a2, b);
    }
    function ni2(a2, b) {
      return li2(4, 2, a2, b);
    }
    function oi2(a2, b) {
      return li2(4, 4, a2, b);
    }
    function pi2(a2, b) {
      if ("function" === typeof b)
        return a2 = a2(), b(a2), function() {
          b(null);
        };
      if (null !== b && void 0 !== b)
        return a2 = a2(), b.current = a2, function() {
          b.current = null;
        };
    }
    function qi2(a2, b, c2) {
      c2 = null !== c2 && void 0 !== c2 ? c2.concat([a2]) : null;
      return li2(4, 4, pi2.bind(null, b, a2), c2);
    }
    function ri2() {
    }
    function si2(a2, b) {
      var c2 = Uh();
      b = void 0 === b ? null : b;
      var d = c2.memoizedState;
      if (null !== d && null !== b && Mh(b, d[1]))
        return d[0];
      c2.memoizedState = [a2, b];
      return a2;
    }
    function ti2(a2, b) {
      var c2 = Uh();
      b = void 0 === b ? null : b;
      var d = c2.memoizedState;
      if (null !== d && null !== b && Mh(b, d[1]))
        return d[0];
      a2 = a2();
      c2.memoizedState = [a2, b];
      return a2;
    }
    function ui2(a2, b, c2) {
      if (0 === (Hh & 21))
        return a2.baseState && (a2.baseState = false, dh = true), a2.memoizedState = c2;
      He2(c2, b) || (c2 = yc(), M2.lanes |= c2, rh |= c2, a2.baseState = true);
      return b;
    }
    function vi2(a2, b) {
      var c2 = C2;
      C2 = 0 !== c2 && 4 > c2 ? c2 : 4;
      a2(true);
      var d = Gh.transition;
      Gh.transition = {};
      try {
        a2(false), b();
      } finally {
        C2 = c2, Gh.transition = d;
      }
    }
    function wi2() {
      return Uh().memoizedState;
    }
    function xi2(a2, b, c2) {
      var d = yi2(a2);
      c2 = { lane: d, action: c2, hasEagerState: false, eagerState: null, next: null };
      if (zi2(a2))
        Ai2(b, c2);
      else if (c2 = hh(a2, b, c2, d), null !== c2) {
        var e = R();
        gi2(c2, a2, d, e);
        Bi2(c2, b, d);
      }
    }
    function ii2(a2, b, c2) {
      var d = yi2(a2), e = { lane: d, action: c2, hasEagerState: false, eagerState: null, next: null };
      if (zi2(a2))
        Ai2(b, e);
      else {
        var f = a2.alternate;
        if (0 === a2.lanes && (null === f || 0 === f.lanes) && (f = b.lastRenderedReducer, null !== f))
          try {
            var g = b.lastRenderedState, h = f(g, c2);
            e.hasEagerState = true;
            e.eagerState = h;
            if (He2(h, g)) {
              var k = b.interleaved;
              null === k ? (e.next = e, gh(b)) : (e.next = k.next, k.next = e);
              b.interleaved = e;
              return;
            }
          } catch (l) {
          } finally {
          }
        c2 = hh(a2, b, e, d);
        null !== c2 && (e = R(), gi2(c2, a2, d, e), Bi2(c2, b, d));
      }
    }
    function zi2(a2) {
      var b = a2.alternate;
      return a2 === M2 || null !== b && b === M2;
    }
    function Ai2(a2, b) {
      Jh = Ih = true;
      var c2 = a2.pending;
      null === c2 ? b.next = b : (b.next = c2.next, c2.next = b);
      a2.pending = b;
    }
    function Bi2(a2, b, c2) {
      if (0 !== (c2 & 4194240)) {
        var d = b.lanes;
        d &= a2.pendingLanes;
        c2 |= d;
        b.lanes = c2;
        Cc(a2, c2);
      }
    }
    var Rh = { readContext: eh, useCallback: P2, useContext: P2, useEffect: P2, useImperativeHandle: P2, useInsertionEffect: P2, useLayoutEffect: P2, useMemo: P2, useReducer: P2, useRef: P2, useState: P2, useDebugValue: P2, useDeferredValue: P2, useTransition: P2, useMutableSource: P2, useSyncExternalStore: P2, useId: P2, unstable_isNewReconciler: false }, Oh = { readContext: eh, useCallback: function(a2, b) {
      Th().memoizedState = [a2, void 0 === b ? null : b];
      return a2;
    }, useContext: eh, useEffect: mi2, useImperativeHandle: function(a2, b, c2) {
      c2 = null !== c2 && void 0 !== c2 ? c2.concat([a2]) : null;
      return ki2(
        4194308,
        4,
        pi2.bind(null, b, a2),
        c2
      );
    }, useLayoutEffect: function(a2, b) {
      return ki2(4194308, 4, a2, b);
    }, useInsertionEffect: function(a2, b) {
      return ki2(4, 2, a2, b);
    }, useMemo: function(a2, b) {
      var c2 = Th();
      b = void 0 === b ? null : b;
      a2 = a2();
      c2.memoizedState = [a2, b];
      return a2;
    }, useReducer: function(a2, b, c2) {
      var d = Th();
      b = void 0 !== c2 ? c2(b) : b;
      d.memoizedState = d.baseState = b;
      a2 = { pending: null, interleaved: null, lanes: 0, dispatch: null, lastRenderedReducer: a2, lastRenderedState: b };
      d.queue = a2;
      a2 = a2.dispatch = xi2.bind(null, M2, a2);
      return [d.memoizedState, a2];
    }, useRef: function(a2) {
      var b = Th();
      a2 = { current: a2 };
      return b.memoizedState = a2;
    }, useState: hi, useDebugValue: ri2, useDeferredValue: function(a2) {
      return Th().memoizedState = a2;
    }, useTransition: function() {
      var a2 = hi(false), b = a2[0];
      a2 = vi2.bind(null, a2[1]);
      Th().memoizedState = a2;
      return [b, a2];
    }, useMutableSource: function() {
    }, useSyncExternalStore: function(a2, b, c2) {
      var d = M2, e = Th();
      if (I) {
        if (void 0 === c2)
          throw Error(p2(407));
        c2 = c2();
      } else {
        c2 = b();
        if (null === Q2)
          throw Error(p2(349));
        0 !== (Hh & 30) || di2(d, b, c2);
      }
      e.memoizedState = c2;
      var f = { value: c2, getSnapshot: b };
      e.queue = f;
      mi2(ai2.bind(
        null,
        d,
        f,
        a2
      ), [a2]);
      d.flags |= 2048;
      bi2(9, ci2.bind(null, d, f, c2, b), void 0, null);
      return c2;
    }, useId: function() {
      var a2 = Th(), b = Q2.identifierPrefix;
      if (I) {
        var c2 = sg;
        var d = rg;
        c2 = (d & ~(1 << 32 - oc(d) - 1)).toString(32) + c2;
        b = ":" + b + "R" + c2;
        c2 = Kh++;
        0 < c2 && (b += "H" + c2.toString(32));
        b += ":";
      } else
        c2 = Lh++, b = ":" + b + "r" + c2.toString(32) + ":";
      return a2.memoizedState = b;
    }, unstable_isNewReconciler: false }, Ph = {
      readContext: eh,
      useCallback: si2,
      useContext: eh,
      useEffect: $h,
      useImperativeHandle: qi2,
      useInsertionEffect: ni2,
      useLayoutEffect: oi2,
      useMemo: ti2,
      useReducer: Wh,
      useRef: ji2,
      useState: function() {
        return Wh(Vh);
      },
      useDebugValue: ri2,
      useDeferredValue: function(a2) {
        var b = Uh();
        return ui2(b, N.memoizedState, a2);
      },
      useTransition: function() {
        var a2 = Wh(Vh)[0], b = Uh().memoizedState;
        return [a2, b];
      },
      useMutableSource: Yh,
      useSyncExternalStore: Zh,
      useId: wi2,
      unstable_isNewReconciler: false
    }, Qh = { readContext: eh, useCallback: si2, useContext: eh, useEffect: $h, useImperativeHandle: qi2, useInsertionEffect: ni2, useLayoutEffect: oi2, useMemo: ti2, useReducer: Xh, useRef: ji2, useState: function() {
      return Xh(Vh);
    }, useDebugValue: ri2, useDeferredValue: function(a2) {
      var b = Uh();
      return null === N ? b.memoizedState = a2 : ui2(b, N.memoizedState, a2);
    }, useTransition: function() {
      var a2 = Xh(Vh)[0], b = Uh().memoizedState;
      return [a2, b];
    }, useMutableSource: Yh, useSyncExternalStore: Zh, useId: wi2, unstable_isNewReconciler: false };
    function Ci2(a2, b) {
      if (a2 && a2.defaultProps) {
        b = A2({}, b);
        a2 = a2.defaultProps;
        for (var c2 in a2)
          void 0 === b[c2] && (b[c2] = a2[c2]);
        return b;
      }
      return b;
    }
    function Di2(a2, b, c2, d) {
      b = a2.memoizedState;
      c2 = c2(d, b);
      c2 = null === c2 || void 0 === c2 ? b : A2({}, b, c2);
      a2.memoizedState = c2;
      0 === a2.lanes && (a2.updateQueue.baseState = c2);
    }
    var Ei2 = { isMounted: function(a2) {
      return (a2 = a2._reactInternals) ? Vb(a2) === a2 : false;
    }, enqueueSetState: function(a2, b, c2) {
      a2 = a2._reactInternals;
      var d = R(), e = yi2(a2), f = mh(d, e);
      f.payload = b;
      void 0 !== c2 && null !== c2 && (f.callback = c2);
      b = nh(a2, f, e);
      null !== b && (gi2(b, a2, e, d), oh(b, a2, e));
    }, enqueueReplaceState: function(a2, b, c2) {
      a2 = a2._reactInternals;
      var d = R(), e = yi2(a2), f = mh(d, e);
      f.tag = 1;
      f.payload = b;
      void 0 !== c2 && null !== c2 && (f.callback = c2);
      b = nh(a2, f, e);
      null !== b && (gi2(b, a2, e, d), oh(b, a2, e));
    }, enqueueForceUpdate: function(a2, b) {
      a2 = a2._reactInternals;
      var c2 = R(), d = yi2(a2), e = mh(c2, d);
      e.tag = 2;
      void 0 !== b && null !== b && (e.callback = b);
      b = nh(a2, e, d);
      null !== b && (gi2(b, a2, d, c2), oh(b, a2, d));
    } };
    function Fi2(a2, b, c2, d, e, f, g) {
      a2 = a2.stateNode;
      return "function" === typeof a2.shouldComponentUpdate ? a2.shouldComponentUpdate(d, f, g) : b.prototype && b.prototype.isPureReactComponent ? !Ie2(c2, d) || !Ie2(e, f) : true;
    }
    function Gi2(a2, b, c2) {
      var d = false, e = Vf;
      var f = b.contextType;
      "object" === typeof f && null !== f ? f = eh(f) : (e = Zf(b) ? Xf : H2.current, d = b.contextTypes, f = (d = null !== d && void 0 !== d) ? Yf(a2, e) : Vf);
      b = new b(c2, f);
      a2.memoizedState = null !== b.state && void 0 !== b.state ? b.state : null;
      b.updater = Ei2;
      a2.stateNode = b;
      b._reactInternals = a2;
      d && (a2 = a2.stateNode, a2.__reactInternalMemoizedUnmaskedChildContext = e, a2.__reactInternalMemoizedMaskedChildContext = f);
      return b;
    }
    function Hi2(a2, b, c2, d) {
      a2 = b.state;
      "function" === typeof b.componentWillReceiveProps && b.componentWillReceiveProps(c2, d);
      "function" === typeof b.UNSAFE_componentWillReceiveProps && b.UNSAFE_componentWillReceiveProps(c2, d);
      b.state !== a2 && Ei2.enqueueReplaceState(b, b.state, null);
    }
    function Ii2(a2, b, c2, d) {
      var e = a2.stateNode;
      e.props = c2;
      e.state = a2.memoizedState;
      e.refs = {};
      kh(a2);
      var f = b.contextType;
      "object" === typeof f && null !== f ? e.context = eh(f) : (f = Zf(b) ? Xf : H2.current, e.context = Yf(a2, f));
      e.state = a2.memoizedState;
      f = b.getDerivedStateFromProps;
      "function" === typeof f && (Di2(a2, b, f, c2), e.state = a2.memoizedState);
      "function" === typeof b.getDerivedStateFromProps || "function" === typeof e.getSnapshotBeforeUpdate || "function" !== typeof e.UNSAFE_componentWillMount && "function" !== typeof e.componentWillMount || (b = e.state, "function" === typeof e.componentWillMount && e.componentWillMount(), "function" === typeof e.UNSAFE_componentWillMount && e.UNSAFE_componentWillMount(), b !== e.state && Ei2.enqueueReplaceState(e, e.state, null), qh(a2, c2, e, d), e.state = a2.memoizedState);
      "function" === typeof e.componentDidMount && (a2.flags |= 4194308);
    }
    function Ji2(a2, b) {
      try {
        var c2 = "", d = b;
        do
          c2 += Pa(d), d = d.return;
        while (d);
        var e = c2;
      } catch (f) {
        e = "\nError generating stack: " + f.message + "\n" + f.stack;
      }
      return { value: a2, source: b, stack: e, digest: null };
    }
    function Ki2(a2, b, c2) {
      return { value: a2, source: null, stack: null != c2 ? c2 : null, digest: null != b ? b : null };
    }
    function Li2(a2, b) {
      try {
        console.error(b.value);
      } catch (c2) {
        setTimeout(function() {
          throw c2;
        });
      }
    }
    var Mi2 = "function" === typeof WeakMap ? WeakMap : Map;
    function Ni2(a2, b, c2) {
      c2 = mh(-1, c2);
      c2.tag = 3;
      c2.payload = { element: null };
      var d = b.value;
      c2.callback = function() {
        Oi2 || (Oi2 = true, Pi2 = d);
        Li2(a2, b);
      };
      return c2;
    }
    function Qi2(a2, b, c2) {
      c2 = mh(-1, c2);
      c2.tag = 3;
      var d = a2.type.getDerivedStateFromError;
      if ("function" === typeof d) {
        var e = b.value;
        c2.payload = function() {
          return d(e);
        };
        c2.callback = function() {
          Li2(a2, b);
        };
      }
      var f = a2.stateNode;
      null !== f && "function" === typeof f.componentDidCatch && (c2.callback = function() {
        Li2(a2, b);
        "function" !== typeof d && (null === Ri2 ? Ri2 = /* @__PURE__ */ new Set([this]) : Ri2.add(this));
        var c3 = b.stack;
        this.componentDidCatch(b.value, { componentStack: null !== c3 ? c3 : "" });
      });
      return c2;
    }
    function Si2(a2, b, c2) {
      var d = a2.pingCache;
      if (null === d) {
        d = a2.pingCache = new Mi2();
        var e = /* @__PURE__ */ new Set();
        d.set(b, e);
      } else
        e = d.get(b), void 0 === e && (e = /* @__PURE__ */ new Set(), d.set(b, e));
      e.has(c2) || (e.add(c2), a2 = Ti2.bind(null, a2, b, c2), b.then(a2, a2));
    }
    function Ui2(a2) {
      do {
        var b;
        if (b = 13 === a2.tag)
          b = a2.memoizedState, b = null !== b ? null !== b.dehydrated ? true : false : true;
        if (b)
          return a2;
        a2 = a2.return;
      } while (null !== a2);
      return null;
    }
    function Vi2(a2, b, c2, d, e) {
      if (0 === (a2.mode & 1))
        return a2 === b ? a2.flags |= 65536 : (a2.flags |= 128, c2.flags |= 131072, c2.flags &= -52805, 1 === c2.tag && (null === c2.alternate ? c2.tag = 17 : (b = mh(-1, 1), b.tag = 2, nh(c2, b, 1))), c2.lanes |= 1), a2;
      a2.flags |= 65536;
      a2.lanes = e;
      return a2;
    }
    var Wi2 = ua.ReactCurrentOwner, dh = false;
    function Xi2(a2, b, c2, d) {
      b.child = null === a2 ? Vg(b, null, c2, d) : Ug(b, a2.child, c2, d);
    }
    function Yi2(a2, b, c2, d, e) {
      c2 = c2.render;
      var f = b.ref;
      ch(b, e);
      d = Nh(a2, b, c2, d, f, e);
      c2 = Sh();
      if (null !== a2 && !dh)
        return b.updateQueue = a2.updateQueue, b.flags &= -2053, a2.lanes &= ~e, Zi2(a2, b, e);
      I && c2 && vg(b);
      b.flags |= 1;
      Xi2(a2, b, d, e);
      return b.child;
    }
    function $i2(a2, b, c2, d, e) {
      if (null === a2) {
        var f = c2.type;
        if ("function" === typeof f && !aj(f) && void 0 === f.defaultProps && null === c2.compare && void 0 === c2.defaultProps)
          return b.tag = 15, b.type = f, bj(a2, b, f, d, e);
        a2 = Rg(c2.type, null, d, b, b.mode, e);
        a2.ref = b.ref;
        a2.return = b;
        return b.child = a2;
      }
      f = a2.child;
      if (0 === (a2.lanes & e)) {
        var g = f.memoizedProps;
        c2 = c2.compare;
        c2 = null !== c2 ? c2 : Ie2;
        if (c2(g, d) && a2.ref === b.ref)
          return Zi2(a2, b, e);
      }
      b.flags |= 1;
      a2 = Pg(f, d);
      a2.ref = b.ref;
      a2.return = b;
      return b.child = a2;
    }
    function bj(a2, b, c2, d, e) {
      if (null !== a2) {
        var f = a2.memoizedProps;
        if (Ie2(f, d) && a2.ref === b.ref)
          if (dh = false, b.pendingProps = d = f, 0 !== (a2.lanes & e))
            0 !== (a2.flags & 131072) && (dh = true);
          else
            return b.lanes = a2.lanes, Zi2(a2, b, e);
      }
      return cj(a2, b, c2, d, e);
    }
    function dj(a2, b, c2) {
      var d = b.pendingProps, e = d.children, f = null !== a2 ? a2.memoizedState : null;
      if ("hidden" === d.mode)
        if (0 === (b.mode & 1))
          b.memoizedState = { baseLanes: 0, cachePool: null, transitions: null }, G2(ej, fj), fj |= c2;
        else {
          if (0 === (c2 & 1073741824))
            return a2 = null !== f ? f.baseLanes | c2 : c2, b.lanes = b.childLanes = 1073741824, b.memoizedState = { baseLanes: a2, cachePool: null, transitions: null }, b.updateQueue = null, G2(ej, fj), fj |= a2, null;
          b.memoizedState = { baseLanes: 0, cachePool: null, transitions: null };
          d = null !== f ? f.baseLanes : c2;
          G2(ej, fj);
          fj |= d;
        }
      else
        null !== f ? (d = f.baseLanes | c2, b.memoizedState = null) : d = c2, G2(ej, fj), fj |= d;
      Xi2(a2, b, e, c2);
      return b.child;
    }
    function gj(a2, b) {
      var c2 = b.ref;
      if (null === a2 && null !== c2 || null !== a2 && a2.ref !== c2)
        b.flags |= 512, b.flags |= 2097152;
    }
    function cj(a2, b, c2, d, e) {
      var f = Zf(c2) ? Xf : H2.current;
      f = Yf(b, f);
      ch(b, e);
      c2 = Nh(a2, b, c2, d, f, e);
      d = Sh();
      if (null !== a2 && !dh)
        return b.updateQueue = a2.updateQueue, b.flags &= -2053, a2.lanes &= ~e, Zi2(a2, b, e);
      I && d && vg(b);
      b.flags |= 1;
      Xi2(a2, b, c2, e);
      return b.child;
    }
    function hj(a2, b, c2, d, e) {
      if (Zf(c2)) {
        var f = true;
        cg(b);
      } else
        f = false;
      ch(b, e);
      if (null === b.stateNode)
        ij(a2, b), Gi2(b, c2, d), Ii2(b, c2, d, e), d = true;
      else if (null === a2) {
        var g = b.stateNode, h = b.memoizedProps;
        g.props = h;
        var k = g.context, l = c2.contextType;
        "object" === typeof l && null !== l ? l = eh(l) : (l = Zf(c2) ? Xf : H2.current, l = Yf(b, l));
        var m2 = c2.getDerivedStateFromProps, q2 = "function" === typeof m2 || "function" === typeof g.getSnapshotBeforeUpdate;
        q2 || "function" !== typeof g.UNSAFE_componentWillReceiveProps && "function" !== typeof g.componentWillReceiveProps || (h !== d || k !== l) && Hi2(b, g, d, l);
        jh = false;
        var r2 = b.memoizedState;
        g.state = r2;
        qh(b, d, g, e);
        k = b.memoizedState;
        h !== d || r2 !== k || Wf.current || jh ? ("function" === typeof m2 && (Di2(b, c2, m2, d), k = b.memoizedState), (h = jh || Fi2(b, c2, h, d, r2, k, l)) ? (q2 || "function" !== typeof g.UNSAFE_componentWillMount && "function" !== typeof g.componentWillMount || ("function" === typeof g.componentWillMount && g.componentWillMount(), "function" === typeof g.UNSAFE_componentWillMount && g.UNSAFE_componentWillMount()), "function" === typeof g.componentDidMount && (b.flags |= 4194308)) : ("function" === typeof g.componentDidMount && (b.flags |= 4194308), b.memoizedProps = d, b.memoizedState = k), g.props = d, g.state = k, g.context = l, d = h) : ("function" === typeof g.componentDidMount && (b.flags |= 4194308), d = false);
      } else {
        g = b.stateNode;
        lh(a2, b);
        h = b.memoizedProps;
        l = b.type === b.elementType ? h : Ci2(b.type, h);
        g.props = l;
        q2 = b.pendingProps;
        r2 = g.context;
        k = c2.contextType;
        "object" === typeof k && null !== k ? k = eh(k) : (k = Zf(c2) ? Xf : H2.current, k = Yf(b, k));
        var y = c2.getDerivedStateFromProps;
        (m2 = "function" === typeof y || "function" === typeof g.getSnapshotBeforeUpdate) || "function" !== typeof g.UNSAFE_componentWillReceiveProps && "function" !== typeof g.componentWillReceiveProps || (h !== q2 || r2 !== k) && Hi2(b, g, d, k);
        jh = false;
        r2 = b.memoizedState;
        g.state = r2;
        qh(b, d, g, e);
        var n = b.memoizedState;
        h !== q2 || r2 !== n || Wf.current || jh ? ("function" === typeof y && (Di2(b, c2, y, d), n = b.memoizedState), (l = jh || Fi2(b, c2, l, d, r2, n, k) || false) ? (m2 || "function" !== typeof g.UNSAFE_componentWillUpdate && "function" !== typeof g.componentWillUpdate || ("function" === typeof g.componentWillUpdate && g.componentWillUpdate(d, n, k), "function" === typeof g.UNSAFE_componentWillUpdate && g.UNSAFE_componentWillUpdate(d, n, k)), "function" === typeof g.componentDidUpdate && (b.flags |= 4), "function" === typeof g.getSnapshotBeforeUpdate && (b.flags |= 1024)) : ("function" !== typeof g.componentDidUpdate || h === a2.memoizedProps && r2 === a2.memoizedState || (b.flags |= 4), "function" !== typeof g.getSnapshotBeforeUpdate || h === a2.memoizedProps && r2 === a2.memoizedState || (b.flags |= 1024), b.memoizedProps = d, b.memoizedState = n), g.props = d, g.state = n, g.context = k, d = l) : ("function" !== typeof g.componentDidUpdate || h === a2.memoizedProps && r2 === a2.memoizedState || (b.flags |= 4), "function" !== typeof g.getSnapshotBeforeUpdate || h === a2.memoizedProps && r2 === a2.memoizedState || (b.flags |= 1024), d = false);
      }
      return jj(a2, b, c2, d, f, e);
    }
    function jj(a2, b, c2, d, e, f) {
      gj(a2, b);
      var g = 0 !== (b.flags & 128);
      if (!d && !g)
        return e && dg(b, c2, false), Zi2(a2, b, f);
      d = b.stateNode;
      Wi2.current = b;
      var h = g && "function" !== typeof c2.getDerivedStateFromError ? null : d.render();
      b.flags |= 1;
      null !== a2 && g ? (b.child = Ug(b, a2.child, null, f), b.child = Ug(b, null, h, f)) : Xi2(a2, b, h, f);
      b.memoizedState = d.state;
      e && dg(b, c2, true);
      return b.child;
    }
    function kj(a2) {
      var b = a2.stateNode;
      b.pendingContext ? ag(a2, b.pendingContext, b.pendingContext !== b.context) : b.context && ag(a2, b.context, false);
      yh(a2, b.containerInfo);
    }
    function lj(a2, b, c2, d, e) {
      Ig();
      Jg(e);
      b.flags |= 256;
      Xi2(a2, b, c2, d);
      return b.child;
    }
    var mj = { dehydrated: null, treeContext: null, retryLane: 0 };
    function nj(a2) {
      return { baseLanes: a2, cachePool: null, transitions: null };
    }
    function oj(a2, b, c2) {
      var d = b.pendingProps, e = L2.current, f = false, g = 0 !== (b.flags & 128), h;
      (h = g) || (h = null !== a2 && null === a2.memoizedState ? false : 0 !== (e & 2));
      if (h)
        f = true, b.flags &= -129;
      else if (null === a2 || null !== a2.memoizedState)
        e |= 1;
      G2(L2, e & 1);
      if (null === a2) {
        Eg(b);
        a2 = b.memoizedState;
        if (null !== a2 && (a2 = a2.dehydrated, null !== a2))
          return 0 === (b.mode & 1) ? b.lanes = 1 : "$!" === a2.data ? b.lanes = 8 : b.lanes = 1073741824, null;
        g = d.children;
        a2 = d.fallback;
        return f ? (d = b.mode, f = b.child, g = { mode: "hidden", children: g }, 0 === (d & 1) && null !== f ? (f.childLanes = 0, f.pendingProps = g) : f = pj(g, d, 0, null), a2 = Tg(a2, d, c2, null), f.return = b, a2.return = b, f.sibling = a2, b.child = f, b.child.memoizedState = nj(c2), b.memoizedState = mj, a2) : qj(b, g);
      }
      e = a2.memoizedState;
      if (null !== e && (h = e.dehydrated, null !== h))
        return rj(a2, b, g, d, h, e, c2);
      if (f) {
        f = d.fallback;
        g = b.mode;
        e = a2.child;
        h = e.sibling;
        var k = { mode: "hidden", children: d.children };
        0 === (g & 1) && b.child !== e ? (d = b.child, d.childLanes = 0, d.pendingProps = k, b.deletions = null) : (d = Pg(e, k), d.subtreeFlags = e.subtreeFlags & 14680064);
        null !== h ? f = Pg(h, f) : (f = Tg(f, g, c2, null), f.flags |= 2);
        f.return = b;
        d.return = b;
        d.sibling = f;
        b.child = d;
        d = f;
        f = b.child;
        g = a2.child.memoizedState;
        g = null === g ? nj(c2) : { baseLanes: g.baseLanes | c2, cachePool: null, transitions: g.transitions };
        f.memoizedState = g;
        f.childLanes = a2.childLanes & ~c2;
        b.memoizedState = mj;
        return d;
      }
      f = a2.child;
      a2 = f.sibling;
      d = Pg(f, { mode: "visible", children: d.children });
      0 === (b.mode & 1) && (d.lanes = c2);
      d.return = b;
      d.sibling = null;
      null !== a2 && (c2 = b.deletions, null === c2 ? (b.deletions = [a2], b.flags |= 16) : c2.push(a2));
      b.child = d;
      b.memoizedState = null;
      return d;
    }
    function qj(a2, b) {
      b = pj({ mode: "visible", children: b }, a2.mode, 0, null);
      b.return = a2;
      return a2.child = b;
    }
    function sj(a2, b, c2, d) {
      null !== d && Jg(d);
      Ug(b, a2.child, null, c2);
      a2 = qj(b, b.pendingProps.children);
      a2.flags |= 2;
      b.memoizedState = null;
      return a2;
    }
    function rj(a2, b, c2, d, e, f, g) {
      if (c2) {
        if (b.flags & 256)
          return b.flags &= -257, d = Ki2(Error(p2(422))), sj(a2, b, g, d);
        if (null !== b.memoizedState)
          return b.child = a2.child, b.flags |= 128, null;
        f = d.fallback;
        e = b.mode;
        d = pj({ mode: "visible", children: d.children }, e, 0, null);
        f = Tg(f, e, g, null);
        f.flags |= 2;
        d.return = b;
        f.return = b;
        d.sibling = f;
        b.child = d;
        0 !== (b.mode & 1) && Ug(b, a2.child, null, g);
        b.child.memoizedState = nj(g);
        b.memoizedState = mj;
        return f;
      }
      if (0 === (b.mode & 1))
        return sj(a2, b, g, null);
      if ("$!" === e.data) {
        d = e.nextSibling && e.nextSibling.dataset;
        if (d)
          var h = d.dgst;
        d = h;
        f = Error(p2(419));
        d = Ki2(f, d, void 0);
        return sj(a2, b, g, d);
      }
      h = 0 !== (g & a2.childLanes);
      if (dh || h) {
        d = Q2;
        if (null !== d) {
          switch (g & -g) {
            case 4:
              e = 2;
              break;
            case 16:
              e = 8;
              break;
            case 64:
            case 128:
            case 256:
            case 512:
            case 1024:
            case 2048:
            case 4096:
            case 8192:
            case 16384:
            case 32768:
            case 65536:
            case 131072:
            case 262144:
            case 524288:
            case 1048576:
            case 2097152:
            case 4194304:
            case 8388608:
            case 16777216:
            case 33554432:
            case 67108864:
              e = 32;
              break;
            case 536870912:
              e = 268435456;
              break;
            default:
              e = 0;
          }
          e = 0 !== (e & (d.suspendedLanes | g)) ? 0 : e;
          0 !== e && e !== f.retryLane && (f.retryLane = e, ih(a2, e), gi2(d, a2, e, -1));
        }
        tj();
        d = Ki2(Error(p2(421)));
        return sj(a2, b, g, d);
      }
      if ("$?" === e.data)
        return b.flags |= 128, b.child = a2.child, b = uj.bind(null, a2), e._reactRetry = b, null;
      a2 = f.treeContext;
      yg = Lf(e.nextSibling);
      xg = b;
      I = true;
      zg = null;
      null !== a2 && (og[pg++] = rg, og[pg++] = sg, og[pg++] = qg, rg = a2.id, sg = a2.overflow, qg = b);
      b = qj(b, d.children);
      b.flags |= 4096;
      return b;
    }
    function vj(a2, b, c2) {
      a2.lanes |= b;
      var d = a2.alternate;
      null !== d && (d.lanes |= b);
      bh(a2.return, b, c2);
    }
    function wj(a2, b, c2, d, e) {
      var f = a2.memoizedState;
      null === f ? a2.memoizedState = { isBackwards: b, rendering: null, renderingStartTime: 0, last: d, tail: c2, tailMode: e } : (f.isBackwards = b, f.rendering = null, f.renderingStartTime = 0, f.last = d, f.tail = c2, f.tailMode = e);
    }
    function xj(a2, b, c2) {
      var d = b.pendingProps, e = d.revealOrder, f = d.tail;
      Xi2(a2, b, d.children, c2);
      d = L2.current;
      if (0 !== (d & 2))
        d = d & 1 | 2, b.flags |= 128;
      else {
        if (null !== a2 && 0 !== (a2.flags & 128))
          a:
            for (a2 = b.child; null !== a2; ) {
              if (13 === a2.tag)
                null !== a2.memoizedState && vj(a2, c2, b);
              else if (19 === a2.tag)
                vj(a2, c2, b);
              else if (null !== a2.child) {
                a2.child.return = a2;
                a2 = a2.child;
                continue;
              }
              if (a2 === b)
                break a;
              for (; null === a2.sibling; ) {
                if (null === a2.return || a2.return === b)
                  break a;
                a2 = a2.return;
              }
              a2.sibling.return = a2.return;
              a2 = a2.sibling;
            }
        d &= 1;
      }
      G2(L2, d);
      if (0 === (b.mode & 1))
        b.memoizedState = null;
      else
        switch (e) {
          case "forwards":
            c2 = b.child;
            for (e = null; null !== c2; )
              a2 = c2.alternate, null !== a2 && null === Ch(a2) && (e = c2), c2 = c2.sibling;
            c2 = e;
            null === c2 ? (e = b.child, b.child = null) : (e = c2.sibling, c2.sibling = null);
            wj(b, false, e, c2, f);
            break;
          case "backwards":
            c2 = null;
            e = b.child;
            for (b.child = null; null !== e; ) {
              a2 = e.alternate;
              if (null !== a2 && null === Ch(a2)) {
                b.child = e;
                break;
              }
              a2 = e.sibling;
              e.sibling = c2;
              c2 = e;
              e = a2;
            }
            wj(b, true, c2, null, f);
            break;
          case "together":
            wj(b, false, null, null, void 0);
            break;
          default:
            b.memoizedState = null;
        }
      return b.child;
    }
    function ij(a2, b) {
      0 === (b.mode & 1) && null !== a2 && (a2.alternate = null, b.alternate = null, b.flags |= 2);
    }
    function Zi2(a2, b, c2) {
      null !== a2 && (b.dependencies = a2.dependencies);
      rh |= b.lanes;
      if (0 === (c2 & b.childLanes))
        return null;
      if (null !== a2 && b.child !== a2.child)
        throw Error(p2(153));
      if (null !== b.child) {
        a2 = b.child;
        c2 = Pg(a2, a2.pendingProps);
        b.child = c2;
        for (c2.return = b; null !== a2.sibling; )
          a2 = a2.sibling, c2 = c2.sibling = Pg(a2, a2.pendingProps), c2.return = b;
        c2.sibling = null;
      }
      return b.child;
    }
    function yj(a2, b, c2) {
      switch (b.tag) {
        case 3:
          kj(b);
          Ig();
          break;
        case 5:
          Ah(b);
          break;
        case 1:
          Zf(b.type) && cg(b);
          break;
        case 4:
          yh(b, b.stateNode.containerInfo);
          break;
        case 10:
          var d = b.type._context, e = b.memoizedProps.value;
          G2(Wg, d._currentValue);
          d._currentValue = e;
          break;
        case 13:
          d = b.memoizedState;
          if (null !== d) {
            if (null !== d.dehydrated)
              return G2(L2, L2.current & 1), b.flags |= 128, null;
            if (0 !== (c2 & b.child.childLanes))
              return oj(a2, b, c2);
            G2(L2, L2.current & 1);
            a2 = Zi2(a2, b, c2);
            return null !== a2 ? a2.sibling : null;
          }
          G2(L2, L2.current & 1);
          break;
        case 19:
          d = 0 !== (c2 & b.childLanes);
          if (0 !== (a2.flags & 128)) {
            if (d)
              return xj(a2, b, c2);
            b.flags |= 128;
          }
          e = b.memoizedState;
          null !== e && (e.rendering = null, e.tail = null, e.lastEffect = null);
          G2(L2, L2.current);
          if (d)
            break;
          else
            return null;
        case 22:
        case 23:
          return b.lanes = 0, dj(a2, b, c2);
      }
      return Zi2(a2, b, c2);
    }
    var zj, Aj, Bj, Cj;
    zj = function(a2, b) {
      for (var c2 = b.child; null !== c2; ) {
        if (5 === c2.tag || 6 === c2.tag)
          a2.appendChild(c2.stateNode);
        else if (4 !== c2.tag && null !== c2.child) {
          c2.child.return = c2;
          c2 = c2.child;
          continue;
        }
        if (c2 === b)
          break;
        for (; null === c2.sibling; ) {
          if (null === c2.return || c2.return === b)
            return;
          c2 = c2.return;
        }
        c2.sibling.return = c2.return;
        c2 = c2.sibling;
      }
    };
    Aj = function() {
    };
    Bj = function(a2, b, c2, d) {
      var e = a2.memoizedProps;
      if (e !== d) {
        a2 = b.stateNode;
        xh(uh.current);
        var f = null;
        switch (c2) {
          case "input":
            e = Ya(a2, e);
            d = Ya(a2, d);
            f = [];
            break;
          case "select":
            e = A2({}, e, { value: void 0 });
            d = A2({}, d, { value: void 0 });
            f = [];
            break;
          case "textarea":
            e = gb(a2, e);
            d = gb(a2, d);
            f = [];
            break;
          default:
            "function" !== typeof e.onClick && "function" === typeof d.onClick && (a2.onclick = Bf);
        }
        ub(c2, d);
        var g;
        c2 = null;
        for (l in e)
          if (!d.hasOwnProperty(l) && e.hasOwnProperty(l) && null != e[l])
            if ("style" === l) {
              var h = e[l];
              for (g in h)
                h.hasOwnProperty(g) && (c2 || (c2 = {}), c2[g] = "");
            } else
              "dangerouslySetInnerHTML" !== l && "children" !== l && "suppressContentEditableWarning" !== l && "suppressHydrationWarning" !== l && "autoFocus" !== l && (ea.hasOwnProperty(l) ? f || (f = []) : (f = f || []).push(l, null));
        for (l in d) {
          var k = d[l];
          h = null != e ? e[l] : void 0;
          if (d.hasOwnProperty(l) && k !== h && (null != k || null != h))
            if ("style" === l)
              if (h) {
                for (g in h)
                  !h.hasOwnProperty(g) || k && k.hasOwnProperty(g) || (c2 || (c2 = {}), c2[g] = "");
                for (g in k)
                  k.hasOwnProperty(g) && h[g] !== k[g] && (c2 || (c2 = {}), c2[g] = k[g]);
              } else
                c2 || (f || (f = []), f.push(
                  l,
                  c2
                )), c2 = k;
            else
              "dangerouslySetInnerHTML" === l ? (k = k ? k.__html : void 0, h = h ? h.__html : void 0, null != k && h !== k && (f = f || []).push(l, k)) : "children" === l ? "string" !== typeof k && "number" !== typeof k || (f = f || []).push(l, "" + k) : "suppressContentEditableWarning" !== l && "suppressHydrationWarning" !== l && (ea.hasOwnProperty(l) ? (null != k && "onScroll" === l && D("scroll", a2), f || h === k || (f = [])) : (f = f || []).push(l, k));
        }
        c2 && (f = f || []).push("style", c2);
        var l = f;
        if (b.updateQueue = l)
          b.flags |= 4;
      }
    };
    Cj = function(a2, b, c2, d) {
      c2 !== d && (b.flags |= 4);
    };
    function Dj(a2, b) {
      if (!I)
        switch (a2.tailMode) {
          case "hidden":
            b = a2.tail;
            for (var c2 = null; null !== b; )
              null !== b.alternate && (c2 = b), b = b.sibling;
            null === c2 ? a2.tail = null : c2.sibling = null;
            break;
          case "collapsed":
            c2 = a2.tail;
            for (var d = null; null !== c2; )
              null !== c2.alternate && (d = c2), c2 = c2.sibling;
            null === d ? b || null === a2.tail ? a2.tail = null : a2.tail.sibling = null : d.sibling = null;
        }
    }
    function S(a2) {
      var b = null !== a2.alternate && a2.alternate.child === a2.child, c2 = 0, d = 0;
      if (b)
        for (var e = a2.child; null !== e; )
          c2 |= e.lanes | e.childLanes, d |= e.subtreeFlags & 14680064, d |= e.flags & 14680064, e.return = a2, e = e.sibling;
      else
        for (e = a2.child; null !== e; )
          c2 |= e.lanes | e.childLanes, d |= e.subtreeFlags, d |= e.flags, e.return = a2, e = e.sibling;
      a2.subtreeFlags |= d;
      a2.childLanes = c2;
      return b;
    }
    function Ej(a2, b, c2) {
      var d = b.pendingProps;
      wg(b);
      switch (b.tag) {
        case 2:
        case 16:
        case 15:
        case 0:
        case 11:
        case 7:
        case 8:
        case 12:
        case 9:
        case 14:
          return S(b), null;
        case 1:
          return Zf(b.type) && $f(), S(b), null;
        case 3:
          d = b.stateNode;
          zh();
          E2(Wf);
          E2(H2);
          Eh();
          d.pendingContext && (d.context = d.pendingContext, d.pendingContext = null);
          if (null === a2 || null === a2.child)
            Gg(b) ? b.flags |= 4 : null === a2 || a2.memoizedState.isDehydrated && 0 === (b.flags & 256) || (b.flags |= 1024, null !== zg && (Fj(zg), zg = null));
          Aj(a2, b);
          S(b);
          return null;
        case 5:
          Bh(b);
          var e = xh(wh.current);
          c2 = b.type;
          if (null !== a2 && null != b.stateNode)
            Bj(a2, b, c2, d, e), a2.ref !== b.ref && (b.flags |= 512, b.flags |= 2097152);
          else {
            if (!d) {
              if (null === b.stateNode)
                throw Error(p2(166));
              S(b);
              return null;
            }
            a2 = xh(uh.current);
            if (Gg(b)) {
              d = b.stateNode;
              c2 = b.type;
              var f = b.memoizedProps;
              d[Of] = b;
              d[Pf] = f;
              a2 = 0 !== (b.mode & 1);
              switch (c2) {
                case "dialog":
                  D("cancel", d);
                  D("close", d);
                  break;
                case "iframe":
                case "object":
                case "embed":
                  D("load", d);
                  break;
                case "video":
                case "audio":
                  for (e = 0; e < lf.length; e++)
                    D(lf[e], d);
                  break;
                case "source":
                  D("error", d);
                  break;
                case "img":
                case "image":
                case "link":
                  D(
                    "error",
                    d
                  );
                  D("load", d);
                  break;
                case "details":
                  D("toggle", d);
                  break;
                case "input":
                  Za(d, f);
                  D("invalid", d);
                  break;
                case "select":
                  d._wrapperState = { wasMultiple: !!f.multiple };
                  D("invalid", d);
                  break;
                case "textarea":
                  hb(d, f), D("invalid", d);
              }
              ub(c2, f);
              e = null;
              for (var g in f)
                if (f.hasOwnProperty(g)) {
                  var h = f[g];
                  "children" === g ? "string" === typeof h ? d.textContent !== h && (true !== f.suppressHydrationWarning && Af(d.textContent, h, a2), e = ["children", h]) : "number" === typeof h && d.textContent !== "" + h && (true !== f.suppressHydrationWarning && Af(
                    d.textContent,
                    h,
                    a2
                  ), e = ["children", "" + h]) : ea.hasOwnProperty(g) && null != h && "onScroll" === g && D("scroll", d);
                }
              switch (c2) {
                case "input":
                  Va(d);
                  db(d, f, true);
                  break;
                case "textarea":
                  Va(d);
                  jb(d);
                  break;
                case "select":
                case "option":
                  break;
                default:
                  "function" === typeof f.onClick && (d.onclick = Bf);
              }
              d = e;
              b.updateQueue = d;
              null !== d && (b.flags |= 4);
            } else {
              g = 9 === e.nodeType ? e : e.ownerDocument;
              "http://www.w3.org/1999/xhtml" === a2 && (a2 = kb(c2));
              "http://www.w3.org/1999/xhtml" === a2 ? "script" === c2 ? (a2 = g.createElement("div"), a2.innerHTML = "<script><\/script>", a2 = a2.removeChild(a2.firstChild)) : "string" === typeof d.is ? a2 = g.createElement(c2, { is: d.is }) : (a2 = g.createElement(c2), "select" === c2 && (g = a2, d.multiple ? g.multiple = true : d.size && (g.size = d.size))) : a2 = g.createElementNS(a2, c2);
              a2[Of] = b;
              a2[Pf] = d;
              zj(a2, b, false, false);
              b.stateNode = a2;
              a: {
                g = vb(c2, d);
                switch (c2) {
                  case "dialog":
                    D("cancel", a2);
                    D("close", a2);
                    e = d;
                    break;
                  case "iframe":
                  case "object":
                  case "embed":
                    D("load", a2);
                    e = d;
                    break;
                  case "video":
                  case "audio":
                    for (e = 0; e < lf.length; e++)
                      D(lf[e], a2);
                    e = d;
                    break;
                  case "source":
                    D("error", a2);
                    e = d;
                    break;
                  case "img":
                  case "image":
                  case "link":
                    D(
                      "error",
                      a2
                    );
                    D("load", a2);
                    e = d;
                    break;
                  case "details":
                    D("toggle", a2);
                    e = d;
                    break;
                  case "input":
                    Za(a2, d);
                    e = Ya(a2, d);
                    D("invalid", a2);
                    break;
                  case "option":
                    e = d;
                    break;
                  case "select":
                    a2._wrapperState = { wasMultiple: !!d.multiple };
                    e = A2({}, d, { value: void 0 });
                    D("invalid", a2);
                    break;
                  case "textarea":
                    hb(a2, d);
                    e = gb(a2, d);
                    D("invalid", a2);
                    break;
                  default:
                    e = d;
                }
                ub(c2, e);
                h = e;
                for (f in h)
                  if (h.hasOwnProperty(f)) {
                    var k = h[f];
                    "style" === f ? sb(a2, k) : "dangerouslySetInnerHTML" === f ? (k = k ? k.__html : void 0, null != k && nb(a2, k)) : "children" === f ? "string" === typeof k ? ("textarea" !== c2 || "" !== k) && ob(a2, k) : "number" === typeof k && ob(a2, "" + k) : "suppressContentEditableWarning" !== f && "suppressHydrationWarning" !== f && "autoFocus" !== f && (ea.hasOwnProperty(f) ? null != k && "onScroll" === f && D("scroll", a2) : null != k && ta(a2, f, k, g));
                  }
                switch (c2) {
                  case "input":
                    Va(a2);
                    db(a2, d, false);
                    break;
                  case "textarea":
                    Va(a2);
                    jb(a2);
                    break;
                  case "option":
                    null != d.value && a2.setAttribute("value", "" + Sa(d.value));
                    break;
                  case "select":
                    a2.multiple = !!d.multiple;
                    f = d.value;
                    null != f ? fb(a2, !!d.multiple, f, false) : null != d.defaultValue && fb(
                      a2,
                      !!d.multiple,
                      d.defaultValue,
                      true
                    );
                    break;
                  default:
                    "function" === typeof e.onClick && (a2.onclick = Bf);
                }
                switch (c2) {
                  case "button":
                  case "input":
                  case "select":
                  case "textarea":
                    d = !!d.autoFocus;
                    break a;
                  case "img":
                    d = true;
                    break a;
                  default:
                    d = false;
                }
              }
              d && (b.flags |= 4);
            }
            null !== b.ref && (b.flags |= 512, b.flags |= 2097152);
          }
          S(b);
          return null;
        case 6:
          if (a2 && null != b.stateNode)
            Cj(a2, b, a2.memoizedProps, d);
          else {
            if ("string" !== typeof d && null === b.stateNode)
              throw Error(p2(166));
            c2 = xh(wh.current);
            xh(uh.current);
            if (Gg(b)) {
              d = b.stateNode;
              c2 = b.memoizedProps;
              d[Of] = b;
              if (f = d.nodeValue !== c2) {
                if (a2 = xg, null !== a2)
                  switch (a2.tag) {
                    case 3:
                      Af(d.nodeValue, c2, 0 !== (a2.mode & 1));
                      break;
                    case 5:
                      true !== a2.memoizedProps.suppressHydrationWarning && Af(d.nodeValue, c2, 0 !== (a2.mode & 1));
                  }
              }
              f && (b.flags |= 4);
            } else
              d = (9 === c2.nodeType ? c2 : c2.ownerDocument).createTextNode(d), d[Of] = b, b.stateNode = d;
          }
          S(b);
          return null;
        case 13:
          E2(L2);
          d = b.memoizedState;
          if (null === a2 || null !== a2.memoizedState && null !== a2.memoizedState.dehydrated) {
            if (I && null !== yg && 0 !== (b.mode & 1) && 0 === (b.flags & 128))
              Hg(), Ig(), b.flags |= 98560, f = false;
            else if (f = Gg(b), null !== d && null !== d.dehydrated) {
              if (null === a2) {
                if (!f)
                  throw Error(p2(318));
                f = b.memoizedState;
                f = null !== f ? f.dehydrated : null;
                if (!f)
                  throw Error(p2(317));
                f[Of] = b;
              } else
                Ig(), 0 === (b.flags & 128) && (b.memoizedState = null), b.flags |= 4;
              S(b);
              f = false;
            } else
              null !== zg && (Fj(zg), zg = null), f = true;
            if (!f)
              return b.flags & 65536 ? b : null;
          }
          if (0 !== (b.flags & 128))
            return b.lanes = c2, b;
          d = null !== d;
          d !== (null !== a2 && null !== a2.memoizedState) && d && (b.child.flags |= 8192, 0 !== (b.mode & 1) && (null === a2 || 0 !== (L2.current & 1) ? 0 === T && (T = 3) : tj()));
          null !== b.updateQueue && (b.flags |= 4);
          S(b);
          return null;
        case 4:
          return zh(), Aj(a2, b), null === a2 && sf(b.stateNode.containerInfo), S(b), null;
        case 10:
          return ah(b.type._context), S(b), null;
        case 17:
          return Zf(b.type) && $f(), S(b), null;
        case 19:
          E2(L2);
          f = b.memoizedState;
          if (null === f)
            return S(b), null;
          d = 0 !== (b.flags & 128);
          g = f.rendering;
          if (null === g)
            if (d)
              Dj(f, false);
            else {
              if (0 !== T || null !== a2 && 0 !== (a2.flags & 128))
                for (a2 = b.child; null !== a2; ) {
                  g = Ch(a2);
                  if (null !== g) {
                    b.flags |= 128;
                    Dj(f, false);
                    d = g.updateQueue;
                    null !== d && (b.updateQueue = d, b.flags |= 4);
                    b.subtreeFlags = 0;
                    d = c2;
                    for (c2 = b.child; null !== c2; )
                      f = c2, a2 = d, f.flags &= 14680066, g = f.alternate, null === g ? (f.childLanes = 0, f.lanes = a2, f.child = null, f.subtreeFlags = 0, f.memoizedProps = null, f.memoizedState = null, f.updateQueue = null, f.dependencies = null, f.stateNode = null) : (f.childLanes = g.childLanes, f.lanes = g.lanes, f.child = g.child, f.subtreeFlags = 0, f.deletions = null, f.memoizedProps = g.memoizedProps, f.memoizedState = g.memoizedState, f.updateQueue = g.updateQueue, f.type = g.type, a2 = g.dependencies, f.dependencies = null === a2 ? null : { lanes: a2.lanes, firstContext: a2.firstContext }), c2 = c2.sibling;
                    G2(L2, L2.current & 1 | 2);
                    return b.child;
                  }
                  a2 = a2.sibling;
                }
              null !== f.tail && B() > Gj && (b.flags |= 128, d = true, Dj(f, false), b.lanes = 4194304);
            }
          else {
            if (!d)
              if (a2 = Ch(g), null !== a2) {
                if (b.flags |= 128, d = true, c2 = a2.updateQueue, null !== c2 && (b.updateQueue = c2, b.flags |= 4), Dj(f, true), null === f.tail && "hidden" === f.tailMode && !g.alternate && !I)
                  return S(b), null;
              } else
                2 * B() - f.renderingStartTime > Gj && 1073741824 !== c2 && (b.flags |= 128, d = true, Dj(f, false), b.lanes = 4194304);
            f.isBackwards ? (g.sibling = b.child, b.child = g) : (c2 = f.last, null !== c2 ? c2.sibling = g : b.child = g, f.last = g);
          }
          if (null !== f.tail)
            return b = f.tail, f.rendering = b, f.tail = b.sibling, f.renderingStartTime = B(), b.sibling = null, c2 = L2.current, G2(L2, d ? c2 & 1 | 2 : c2 & 1), b;
          S(b);
          return null;
        case 22:
        case 23:
          return Hj(), d = null !== b.memoizedState, null !== a2 && null !== a2.memoizedState !== d && (b.flags |= 8192), d && 0 !== (b.mode & 1) ? 0 !== (fj & 1073741824) && (S(b), b.subtreeFlags & 6 && (b.flags |= 8192)) : S(b), null;
        case 24:
          return null;
        case 25:
          return null;
      }
      throw Error(p2(156, b.tag));
    }
    function Ij(a2, b) {
      wg(b);
      switch (b.tag) {
        case 1:
          return Zf(b.type) && $f(), a2 = b.flags, a2 & 65536 ? (b.flags = a2 & -65537 | 128, b) : null;
        case 3:
          return zh(), E2(Wf), E2(H2), Eh(), a2 = b.flags, 0 !== (a2 & 65536) && 0 === (a2 & 128) ? (b.flags = a2 & -65537 | 128, b) : null;
        case 5:
          return Bh(b), null;
        case 13:
          E2(L2);
          a2 = b.memoizedState;
          if (null !== a2 && null !== a2.dehydrated) {
            if (null === b.alternate)
              throw Error(p2(340));
            Ig();
          }
          a2 = b.flags;
          return a2 & 65536 ? (b.flags = a2 & -65537 | 128, b) : null;
        case 19:
          return E2(L2), null;
        case 4:
          return zh(), null;
        case 10:
          return ah(b.type._context), null;
        case 22:
        case 23:
          return Hj(), null;
        case 24:
          return null;
        default:
          return null;
      }
    }
    var Jj = false, U2 = false, Kj = "function" === typeof WeakSet ? WeakSet : Set, V2 = null;
    function Lj(a2, b) {
      var c2 = a2.ref;
      if (null !== c2)
        if ("function" === typeof c2)
          try {
            c2(null);
          } catch (d) {
            W2(a2, b, d);
          }
        else
          c2.current = null;
    }
    function Mj(a2, b, c2) {
      try {
        c2();
      } catch (d) {
        W2(a2, b, d);
      }
    }
    var Nj = false;
    function Oj(a2, b) {
      Cf = dd;
      a2 = Me2();
      if (Ne2(a2)) {
        if ("selectionStart" in a2)
          var c2 = { start: a2.selectionStart, end: a2.selectionEnd };
        else {
          c2 = (c2 = a2.ownerDocument) && c2.defaultView || window;
          var d = c2.getSelection && c2.getSelection();
          if (d && 0 !== d.rangeCount) {
            c2 = d.anchorNode;
            var e = d.anchorOffset, f = d.focusNode;
            d = d.focusOffset;
            var g = 0, h = -1, k = -1, l = 0, m2 = 0, q2 = a2, r2 = null;
            b:
              for (; ; ) {
                for (var y; ; ) {
                  q2 !== c2 || 0 !== e && 3 !== q2.nodeType || (h = g + e);
                  q2 !== f || 0 !== d && 3 !== q2.nodeType || (k = g + d);
                  3 === q2.nodeType && (g += q2.nodeValue.length);
                  if (null === (y = q2.firstChild))
                    break;
                  r2 = q2;
                  q2 = y;
                }
                for (; ; ) {
                  if (q2 === a2)
                    break b;
                  r2 === c2 && ++l === e && (h = g);
                  r2 === f && ++m2 === d && (k = g);
                  if (null !== (y = q2.nextSibling))
                    break;
                  q2 = r2;
                  r2 = q2.parentNode;
                }
                q2 = y;
              }
            c2 = -1 === h || -1 === k ? null : { start: h, end: k };
          } else
            c2 = null;
        }
        c2 = c2 || { start: 0, end: 0 };
      } else
        c2 = null;
      Df = { focusedElem: a2, selectionRange: c2 };
      dd = false;
      for (V2 = b; null !== V2; )
        if (b = V2, a2 = b.child, 0 !== (b.subtreeFlags & 1028) && null !== a2)
          a2.return = b, V2 = a2;
        else
          for (; null !== V2; ) {
            b = V2;
            try {
              var n = b.alternate;
              if (0 !== (b.flags & 1024))
                switch (b.tag) {
                  case 0:
                  case 11:
                  case 15:
                    break;
                  case 1:
                    if (null !== n) {
                      var t2 = n.memoizedProps, J = n.memoizedState, x2 = b.stateNode, w = x2.getSnapshotBeforeUpdate(b.elementType === b.type ? t2 : Ci2(b.type, t2), J);
                      x2.__reactInternalSnapshotBeforeUpdate = w;
                    }
                    break;
                  case 3:
                    var u = b.stateNode.containerInfo;
                    1 === u.nodeType ? u.textContent = "" : 9 === u.nodeType && u.documentElement && u.removeChild(u.documentElement);
                    break;
                  case 5:
                  case 6:
                  case 4:
                  case 17:
                    break;
                  default:
                    throw Error(p2(163));
                }
            } catch (F) {
              W2(b, b.return, F);
            }
            a2 = b.sibling;
            if (null !== a2) {
              a2.return = b.return;
              V2 = a2;
              break;
            }
            V2 = b.return;
          }
      n = Nj;
      Nj = false;
      return n;
    }
    function Pj(a2, b, c2) {
      var d = b.updateQueue;
      d = null !== d ? d.lastEffect : null;
      if (null !== d) {
        var e = d = d.next;
        do {
          if ((e.tag & a2) === a2) {
            var f = e.destroy;
            e.destroy = void 0;
            void 0 !== f && Mj(b, c2, f);
          }
          e = e.next;
        } while (e !== d);
      }
    }
    function Qj(a2, b) {
      b = b.updateQueue;
      b = null !== b ? b.lastEffect : null;
      if (null !== b) {
        var c2 = b = b.next;
        do {
          if ((c2.tag & a2) === a2) {
            var d = c2.create;
            c2.destroy = d();
          }
          c2 = c2.next;
        } while (c2 !== b);
      }
    }
    function Rj(a2) {
      var b = a2.ref;
      if (null !== b) {
        var c2 = a2.stateNode;
        switch (a2.tag) {
          case 5:
            a2 = c2;
            break;
          default:
            a2 = c2;
        }
        "function" === typeof b ? b(a2) : b.current = a2;
      }
    }
    function Sj(a2) {
      var b = a2.alternate;
      null !== b && (a2.alternate = null, Sj(b));
      a2.child = null;
      a2.deletions = null;
      a2.sibling = null;
      5 === a2.tag && (b = a2.stateNode, null !== b && (delete b[Of], delete b[Pf], delete b[of], delete b[Qf], delete b[Rf]));
      a2.stateNode = null;
      a2.return = null;
      a2.dependencies = null;
      a2.memoizedProps = null;
      a2.memoizedState = null;
      a2.pendingProps = null;
      a2.stateNode = null;
      a2.updateQueue = null;
    }
    function Tj(a2) {
      return 5 === a2.tag || 3 === a2.tag || 4 === a2.tag;
    }
    function Uj(a2) {
      a:
        for (; ; ) {
          for (; null === a2.sibling; ) {
            if (null === a2.return || Tj(a2.return))
              return null;
            a2 = a2.return;
          }
          a2.sibling.return = a2.return;
          for (a2 = a2.sibling; 5 !== a2.tag && 6 !== a2.tag && 18 !== a2.tag; ) {
            if (a2.flags & 2)
              continue a;
            if (null === a2.child || 4 === a2.tag)
              continue a;
            else
              a2.child.return = a2, a2 = a2.child;
          }
          if (!(a2.flags & 2))
            return a2.stateNode;
        }
    }
    function Vj(a2, b, c2) {
      var d = a2.tag;
      if (5 === d || 6 === d)
        a2 = a2.stateNode, b ? 8 === c2.nodeType ? c2.parentNode.insertBefore(a2, b) : c2.insertBefore(a2, b) : (8 === c2.nodeType ? (b = c2.parentNode, b.insertBefore(a2, c2)) : (b = c2, b.appendChild(a2)), c2 = c2._reactRootContainer, null !== c2 && void 0 !== c2 || null !== b.onclick || (b.onclick = Bf));
      else if (4 !== d && (a2 = a2.child, null !== a2))
        for (Vj(a2, b, c2), a2 = a2.sibling; null !== a2; )
          Vj(a2, b, c2), a2 = a2.sibling;
    }
    function Wj(a2, b, c2) {
      var d = a2.tag;
      if (5 === d || 6 === d)
        a2 = a2.stateNode, b ? c2.insertBefore(a2, b) : c2.appendChild(a2);
      else if (4 !== d && (a2 = a2.child, null !== a2))
        for (Wj(a2, b, c2), a2 = a2.sibling; null !== a2; )
          Wj(a2, b, c2), a2 = a2.sibling;
    }
    var X2 = null, Xj = false;
    function Yj(a2, b, c2) {
      for (c2 = c2.child; null !== c2; )
        Zj(a2, b, c2), c2 = c2.sibling;
    }
    function Zj(a2, b, c2) {
      if (lc && "function" === typeof lc.onCommitFiberUnmount)
        try {
          lc.onCommitFiberUnmount(kc, c2);
        } catch (h) {
        }
      switch (c2.tag) {
        case 5:
          U2 || Lj(c2, b);
        case 6:
          var d = X2, e = Xj;
          X2 = null;
          Yj(a2, b, c2);
          X2 = d;
          Xj = e;
          null !== X2 && (Xj ? (a2 = X2, c2 = c2.stateNode, 8 === a2.nodeType ? a2.parentNode.removeChild(c2) : a2.removeChild(c2)) : X2.removeChild(c2.stateNode));
          break;
        case 18:
          null !== X2 && (Xj ? (a2 = X2, c2 = c2.stateNode, 8 === a2.nodeType ? Kf(a2.parentNode, c2) : 1 === a2.nodeType && Kf(a2, c2), bd(a2)) : Kf(X2, c2.stateNode));
          break;
        case 4:
          d = X2;
          e = Xj;
          X2 = c2.stateNode.containerInfo;
          Xj = true;
          Yj(a2, b, c2);
          X2 = d;
          Xj = e;
          break;
        case 0:
        case 11:
        case 14:
        case 15:
          if (!U2 && (d = c2.updateQueue, null !== d && (d = d.lastEffect, null !== d))) {
            e = d = d.next;
            do {
              var f = e, g = f.destroy;
              f = f.tag;
              void 0 !== g && (0 !== (f & 2) ? Mj(c2, b, g) : 0 !== (f & 4) && Mj(c2, b, g));
              e = e.next;
            } while (e !== d);
          }
          Yj(a2, b, c2);
          break;
        case 1:
          if (!U2 && (Lj(c2, b), d = c2.stateNode, "function" === typeof d.componentWillUnmount))
            try {
              d.props = c2.memoizedProps, d.state = c2.memoizedState, d.componentWillUnmount();
            } catch (h) {
              W2(c2, b, h);
            }
          Yj(a2, b, c2);
          break;
        case 21:
          Yj(a2, b, c2);
          break;
        case 22:
          c2.mode & 1 ? (U2 = (d = U2) || null !== c2.memoizedState, Yj(a2, b, c2), U2 = d) : Yj(a2, b, c2);
          break;
        default:
          Yj(a2, b, c2);
      }
    }
    function ak(a2) {
      var b = a2.updateQueue;
      if (null !== b) {
        a2.updateQueue = null;
        var c2 = a2.stateNode;
        null === c2 && (c2 = a2.stateNode = new Kj());
        b.forEach(function(b2) {
          var d = bk.bind(null, a2, b2);
          c2.has(b2) || (c2.add(b2), b2.then(d, d));
        });
      }
    }
    function ck(a2, b) {
      var c2 = b.deletions;
      if (null !== c2)
        for (var d = 0; d < c2.length; d++) {
          var e = c2[d];
          try {
            var f = a2, g = b, h = g;
            a:
              for (; null !== h; ) {
                switch (h.tag) {
                  case 5:
                    X2 = h.stateNode;
                    Xj = false;
                    break a;
                  case 3:
                    X2 = h.stateNode.containerInfo;
                    Xj = true;
                    break a;
                  case 4:
                    X2 = h.stateNode.containerInfo;
                    Xj = true;
                    break a;
                }
                h = h.return;
              }
            if (null === X2)
              throw Error(p2(160));
            Zj(f, g, e);
            X2 = null;
            Xj = false;
            var k = e.alternate;
            null !== k && (k.return = null);
            e.return = null;
          } catch (l) {
            W2(e, b, l);
          }
        }
      if (b.subtreeFlags & 12854)
        for (b = b.child; null !== b; )
          dk(b, a2), b = b.sibling;
    }
    function dk(a2, b) {
      var c2 = a2.alternate, d = a2.flags;
      switch (a2.tag) {
        case 0:
        case 11:
        case 14:
        case 15:
          ck(b, a2);
          ek(a2);
          if (d & 4) {
            try {
              Pj(3, a2, a2.return), Qj(3, a2);
            } catch (t2) {
              W2(a2, a2.return, t2);
            }
            try {
              Pj(5, a2, a2.return);
            } catch (t2) {
              W2(a2, a2.return, t2);
            }
          }
          break;
        case 1:
          ck(b, a2);
          ek(a2);
          d & 512 && null !== c2 && Lj(c2, c2.return);
          break;
        case 5:
          ck(b, a2);
          ek(a2);
          d & 512 && null !== c2 && Lj(c2, c2.return);
          if (a2.flags & 32) {
            var e = a2.stateNode;
            try {
              ob(e, "");
            } catch (t2) {
              W2(a2, a2.return, t2);
            }
          }
          if (d & 4 && (e = a2.stateNode, null != e)) {
            var f = a2.memoizedProps, g = null !== c2 ? c2.memoizedProps : f, h = a2.type, k = a2.updateQueue;
            a2.updateQueue = null;
            if (null !== k)
              try {
                "input" === h && "radio" === f.type && null != f.name && ab(e, f);
                vb(h, g);
                var l = vb(h, f);
                for (g = 0; g < k.length; g += 2) {
                  var m2 = k[g], q2 = k[g + 1];
                  "style" === m2 ? sb(e, q2) : "dangerouslySetInnerHTML" === m2 ? nb(e, q2) : "children" === m2 ? ob(e, q2) : ta(e, m2, q2, l);
                }
                switch (h) {
                  case "input":
                    bb(e, f);
                    break;
                  case "textarea":
                    ib(e, f);
                    break;
                  case "select":
                    var r2 = e._wrapperState.wasMultiple;
                    e._wrapperState.wasMultiple = !!f.multiple;
                    var y = f.value;
                    null != y ? fb(e, !!f.multiple, y, false) : r2 !== !!f.multiple && (null != f.defaultValue ? fb(
                      e,
                      !!f.multiple,
                      f.defaultValue,
                      true
                    ) : fb(e, !!f.multiple, f.multiple ? [] : "", false));
                }
                e[Pf] = f;
              } catch (t2) {
                W2(a2, a2.return, t2);
              }
          }
          break;
        case 6:
          ck(b, a2);
          ek(a2);
          if (d & 4) {
            if (null === a2.stateNode)
              throw Error(p2(162));
            e = a2.stateNode;
            f = a2.memoizedProps;
            try {
              e.nodeValue = f;
            } catch (t2) {
              W2(a2, a2.return, t2);
            }
          }
          break;
        case 3:
          ck(b, a2);
          ek(a2);
          if (d & 4 && null !== c2 && c2.memoizedState.isDehydrated)
            try {
              bd(b.containerInfo);
            } catch (t2) {
              W2(a2, a2.return, t2);
            }
          break;
        case 4:
          ck(b, a2);
          ek(a2);
          break;
        case 13:
          ck(b, a2);
          ek(a2);
          e = a2.child;
          e.flags & 8192 && (f = null !== e.memoizedState, e.stateNode.isHidden = f, !f || null !== e.alternate && null !== e.alternate.memoizedState || (fk = B()));
          d & 4 && ak(a2);
          break;
        case 22:
          m2 = null !== c2 && null !== c2.memoizedState;
          a2.mode & 1 ? (U2 = (l = U2) || m2, ck(b, a2), U2 = l) : ck(b, a2);
          ek(a2);
          if (d & 8192) {
            l = null !== a2.memoizedState;
            if ((a2.stateNode.isHidden = l) && !m2 && 0 !== (a2.mode & 1))
              for (V2 = a2, m2 = a2.child; null !== m2; ) {
                for (q2 = V2 = m2; null !== V2; ) {
                  r2 = V2;
                  y = r2.child;
                  switch (r2.tag) {
                    case 0:
                    case 11:
                    case 14:
                    case 15:
                      Pj(4, r2, r2.return);
                      break;
                    case 1:
                      Lj(r2, r2.return);
                      var n = r2.stateNode;
                      if ("function" === typeof n.componentWillUnmount) {
                        d = r2;
                        c2 = r2.return;
                        try {
                          b = d, n.props = b.memoizedProps, n.state = b.memoizedState, n.componentWillUnmount();
                        } catch (t2) {
                          W2(d, c2, t2);
                        }
                      }
                      break;
                    case 5:
                      Lj(r2, r2.return);
                      break;
                    case 22:
                      if (null !== r2.memoizedState) {
                        gk(q2);
                        continue;
                      }
                  }
                  null !== y ? (y.return = r2, V2 = y) : gk(q2);
                }
                m2 = m2.sibling;
              }
            a:
              for (m2 = null, q2 = a2; ; ) {
                if (5 === q2.tag) {
                  if (null === m2) {
                    m2 = q2;
                    try {
                      e = q2.stateNode, l ? (f = e.style, "function" === typeof f.setProperty ? f.setProperty("display", "none", "important") : f.display = "none") : (h = q2.stateNode, k = q2.memoizedProps.style, g = void 0 !== k && null !== k && k.hasOwnProperty("display") ? k.display : null, h.style.display = rb("display", g));
                    } catch (t2) {
                      W2(a2, a2.return, t2);
                    }
                  }
                } else if (6 === q2.tag) {
                  if (null === m2)
                    try {
                      q2.stateNode.nodeValue = l ? "" : q2.memoizedProps;
                    } catch (t2) {
                      W2(a2, a2.return, t2);
                    }
                } else if ((22 !== q2.tag && 23 !== q2.tag || null === q2.memoizedState || q2 === a2) && null !== q2.child) {
                  q2.child.return = q2;
                  q2 = q2.child;
                  continue;
                }
                if (q2 === a2)
                  break a;
                for (; null === q2.sibling; ) {
                  if (null === q2.return || q2.return === a2)
                    break a;
                  m2 === q2 && (m2 = null);
                  q2 = q2.return;
                }
                m2 === q2 && (m2 = null);
                q2.sibling.return = q2.return;
                q2 = q2.sibling;
              }
          }
          break;
        case 19:
          ck(b, a2);
          ek(a2);
          d & 4 && ak(a2);
          break;
        case 21:
          break;
        default:
          ck(
            b,
            a2
          ), ek(a2);
      }
    }
    function ek(a2) {
      var b = a2.flags;
      if (b & 2) {
        try {
          a: {
            for (var c2 = a2.return; null !== c2; ) {
              if (Tj(c2)) {
                var d = c2;
                break a;
              }
              c2 = c2.return;
            }
            throw Error(p2(160));
          }
          switch (d.tag) {
            case 5:
              var e = d.stateNode;
              d.flags & 32 && (ob(e, ""), d.flags &= -33);
              var f = Uj(a2);
              Wj(a2, f, e);
              break;
            case 3:
            case 4:
              var g = d.stateNode.containerInfo, h = Uj(a2);
              Vj(a2, h, g);
              break;
            default:
              throw Error(p2(161));
          }
        } catch (k) {
          W2(a2, a2.return, k);
        }
        a2.flags &= -3;
      }
      b & 4096 && (a2.flags &= -4097);
    }
    function hk(a2, b, c2) {
      V2 = a2;
      ik(a2);
    }
    function ik(a2, b, c2) {
      for (var d = 0 !== (a2.mode & 1); null !== V2; ) {
        var e = V2, f = e.child;
        if (22 === e.tag && d) {
          var g = null !== e.memoizedState || Jj;
          if (!g) {
            var h = e.alternate, k = null !== h && null !== h.memoizedState || U2;
            h = Jj;
            var l = U2;
            Jj = g;
            if ((U2 = k) && !l)
              for (V2 = e; null !== V2; )
                g = V2, k = g.child, 22 === g.tag && null !== g.memoizedState ? jk(e) : null !== k ? (k.return = g, V2 = k) : jk(e);
            for (; null !== f; )
              V2 = f, ik(f), f = f.sibling;
            V2 = e;
            Jj = h;
            U2 = l;
          }
          kk(a2);
        } else
          0 !== (e.subtreeFlags & 8772) && null !== f ? (f.return = e, V2 = f) : kk(a2);
      }
    }
    function kk(a2) {
      for (; null !== V2; ) {
        var b = V2;
        if (0 !== (b.flags & 8772)) {
          var c2 = b.alternate;
          try {
            if (0 !== (b.flags & 8772))
              switch (b.tag) {
                case 0:
                case 11:
                case 15:
                  U2 || Qj(5, b);
                  break;
                case 1:
                  var d = b.stateNode;
                  if (b.flags & 4 && !U2)
                    if (null === c2)
                      d.componentDidMount();
                    else {
                      var e = b.elementType === b.type ? c2.memoizedProps : Ci2(b.type, c2.memoizedProps);
                      d.componentDidUpdate(e, c2.memoizedState, d.__reactInternalSnapshotBeforeUpdate);
                    }
                  var f = b.updateQueue;
                  null !== f && sh(b, f, d);
                  break;
                case 3:
                  var g = b.updateQueue;
                  if (null !== g) {
                    c2 = null;
                    if (null !== b.child)
                      switch (b.child.tag) {
                        case 5:
                          c2 = b.child.stateNode;
                          break;
                        case 1:
                          c2 = b.child.stateNode;
                      }
                    sh(b, g, c2);
                  }
                  break;
                case 5:
                  var h = b.stateNode;
                  if (null === c2 && b.flags & 4) {
                    c2 = h;
                    var k = b.memoizedProps;
                    switch (b.type) {
                      case "button":
                      case "input":
                      case "select":
                      case "textarea":
                        k.autoFocus && c2.focus();
                        break;
                      case "img":
                        k.src && (c2.src = k.src);
                    }
                  }
                  break;
                case 6:
                  break;
                case 4:
                  break;
                case 12:
                  break;
                case 13:
                  if (null === b.memoizedState) {
                    var l = b.alternate;
                    if (null !== l) {
                      var m2 = l.memoizedState;
                      if (null !== m2) {
                        var q2 = m2.dehydrated;
                        null !== q2 && bd(q2);
                      }
                    }
                  }
                  break;
                case 19:
                case 17:
                case 21:
                case 22:
                case 23:
                case 25:
                  break;
                default:
                  throw Error(p2(163));
              }
            U2 || b.flags & 512 && Rj(b);
          } catch (r2) {
            W2(b, b.return, r2);
          }
        }
        if (b === a2) {
          V2 = null;
          break;
        }
        c2 = b.sibling;
        if (null !== c2) {
          c2.return = b.return;
          V2 = c2;
          break;
        }
        V2 = b.return;
      }
    }
    function gk(a2) {
      for (; null !== V2; ) {
        var b = V2;
        if (b === a2) {
          V2 = null;
          break;
        }
        var c2 = b.sibling;
        if (null !== c2) {
          c2.return = b.return;
          V2 = c2;
          break;
        }
        V2 = b.return;
      }
    }
    function jk(a2) {
      for (; null !== V2; ) {
        var b = V2;
        try {
          switch (b.tag) {
            case 0:
            case 11:
            case 15:
              var c2 = b.return;
              try {
                Qj(4, b);
              } catch (k) {
                W2(b, c2, k);
              }
              break;
            case 1:
              var d = b.stateNode;
              if ("function" === typeof d.componentDidMount) {
                var e = b.return;
                try {
                  d.componentDidMount();
                } catch (k) {
                  W2(b, e, k);
                }
              }
              var f = b.return;
              try {
                Rj(b);
              } catch (k) {
                W2(b, f, k);
              }
              break;
            case 5:
              var g = b.return;
              try {
                Rj(b);
              } catch (k) {
                W2(b, g, k);
              }
          }
        } catch (k) {
          W2(b, b.return, k);
        }
        if (b === a2) {
          V2 = null;
          break;
        }
        var h = b.sibling;
        if (null !== h) {
          h.return = b.return;
          V2 = h;
          break;
        }
        V2 = b.return;
      }
    }
    var lk = Math.ceil, mk = ua.ReactCurrentDispatcher, nk = ua.ReactCurrentOwner, ok = ua.ReactCurrentBatchConfig, K = 0, Q2 = null, Y2 = null, Z = 0, fj = 0, ej = Uf(0), T = 0, pk = null, rh = 0, qk = 0, rk = 0, sk = null, tk = null, fk = 0, Gj = Infinity, uk = null, Oi2 = false, Pi2 = null, Ri2 = null, vk = false, wk = null, xk = 0, yk = 0, zk = null, Ak = -1, Bk = 0;
    function R() {
      return 0 !== (K & 6) ? B() : -1 !== Ak ? Ak : Ak = B();
    }
    function yi2(a2) {
      if (0 === (a2.mode & 1))
        return 1;
      if (0 !== (K & 2) && 0 !== Z)
        return Z & -Z;
      if (null !== Kg.transition)
        return 0 === Bk && (Bk = yc()), Bk;
      a2 = C2;
      if (0 !== a2)
        return a2;
      a2 = window.event;
      a2 = void 0 === a2 ? 16 : jd(a2.type);
      return a2;
    }
    function gi2(a2, b, c2, d) {
      if (50 < yk)
        throw yk = 0, zk = null, Error(p2(185));
      Ac(a2, c2, d);
      if (0 === (K & 2) || a2 !== Q2)
        a2 === Q2 && (0 === (K & 2) && (qk |= c2), 4 === T && Ck(a2, Z)), Dk(a2, d), 1 === c2 && 0 === K && 0 === (b.mode & 1) && (Gj = B() + 500, fg && jg());
    }
    function Dk(a2, b) {
      var c2 = a2.callbackNode;
      wc(a2, b);
      var d = uc(a2, a2 === Q2 ? Z : 0);
      if (0 === d)
        null !== c2 && bc(c2), a2.callbackNode = null, a2.callbackPriority = 0;
      else if (b = d & -d, a2.callbackPriority !== b) {
        null != c2 && bc(c2);
        if (1 === b)
          0 === a2.tag ? ig(Ek.bind(null, a2)) : hg(Ek.bind(null, a2)), Jf(function() {
            0 === (K & 6) && jg();
          }), c2 = null;
        else {
          switch (Dc(d)) {
            case 1:
              c2 = fc;
              break;
            case 4:
              c2 = gc;
              break;
            case 16:
              c2 = hc;
              break;
            case 536870912:
              c2 = jc;
              break;
            default:
              c2 = hc;
          }
          c2 = Fk(c2, Gk.bind(null, a2));
        }
        a2.callbackPriority = b;
        a2.callbackNode = c2;
      }
    }
    function Gk(a2, b) {
      Ak = -1;
      Bk = 0;
      if (0 !== (K & 6))
        throw Error(p2(327));
      var c2 = a2.callbackNode;
      if (Hk() && a2.callbackNode !== c2)
        return null;
      var d = uc(a2, a2 === Q2 ? Z : 0);
      if (0 === d)
        return null;
      if (0 !== (d & 30) || 0 !== (d & a2.expiredLanes) || b)
        b = Ik(a2, d);
      else {
        b = d;
        var e = K;
        K |= 2;
        var f = Jk();
        if (Q2 !== a2 || Z !== b)
          uk = null, Gj = B() + 500, Kk(a2, b);
        do
          try {
            Lk();
            break;
          } catch (h) {
            Mk(a2, h);
          }
        while (1);
        $g();
        mk.current = f;
        K = e;
        null !== Y2 ? b = 0 : (Q2 = null, Z = 0, b = T);
      }
      if (0 !== b) {
        2 === b && (e = xc(a2), 0 !== e && (d = e, b = Nk(a2, e)));
        if (1 === b)
          throw c2 = pk, Kk(a2, 0), Ck(a2, d), Dk(a2, B()), c2;
        if (6 === b)
          Ck(a2, d);
        else {
          e = a2.current.alternate;
          if (0 === (d & 30) && !Ok(e) && (b = Ik(a2, d), 2 === b && (f = xc(a2), 0 !== f && (d = f, b = Nk(a2, f))), 1 === b))
            throw c2 = pk, Kk(a2, 0), Ck(a2, d), Dk(a2, B()), c2;
          a2.finishedWork = e;
          a2.finishedLanes = d;
          switch (b) {
            case 0:
            case 1:
              throw Error(p2(345));
            case 2:
              Pk(a2, tk, uk);
              break;
            case 3:
              Ck(a2, d);
              if ((d & 130023424) === d && (b = fk + 500 - B(), 10 < b)) {
                if (0 !== uc(a2, 0))
                  break;
                e = a2.suspendedLanes;
                if ((e & d) !== d) {
                  R();
                  a2.pingedLanes |= a2.suspendedLanes & e;
                  break;
                }
                a2.timeoutHandle = Ff(Pk.bind(null, a2, tk, uk), b);
                break;
              }
              Pk(a2, tk, uk);
              break;
            case 4:
              Ck(a2, d);
              if ((d & 4194240) === d)
                break;
              b = a2.eventTimes;
              for (e = -1; 0 < d; ) {
                var g = 31 - oc(d);
                f = 1 << g;
                g = b[g];
                g > e && (e = g);
                d &= ~f;
              }
              d = e;
              d = B() - d;
              d = (120 > d ? 120 : 480 > d ? 480 : 1080 > d ? 1080 : 1920 > d ? 1920 : 3e3 > d ? 3e3 : 4320 > d ? 4320 : 1960 * lk(d / 1960)) - d;
              if (10 < d) {
                a2.timeoutHandle = Ff(Pk.bind(null, a2, tk, uk), d);
                break;
              }
              Pk(a2, tk, uk);
              break;
            case 5:
              Pk(a2, tk, uk);
              break;
            default:
              throw Error(p2(329));
          }
        }
      }
      Dk(a2, B());
      return a2.callbackNode === c2 ? Gk.bind(null, a2) : null;
    }
    function Nk(a2, b) {
      var c2 = sk;
      a2.current.memoizedState.isDehydrated && (Kk(a2, b).flags |= 256);
      a2 = Ik(a2, b);
      2 !== a2 && (b = tk, tk = c2, null !== b && Fj(b));
      return a2;
    }
    function Fj(a2) {
      null === tk ? tk = a2 : tk.push.apply(tk, a2);
    }
    function Ok(a2) {
      for (var b = a2; ; ) {
        if (b.flags & 16384) {
          var c2 = b.updateQueue;
          if (null !== c2 && (c2 = c2.stores, null !== c2))
            for (var d = 0; d < c2.length; d++) {
              var e = c2[d], f = e.getSnapshot;
              e = e.value;
              try {
                if (!He2(f(), e))
                  return false;
              } catch (g) {
                return false;
              }
            }
        }
        c2 = b.child;
        if (b.subtreeFlags & 16384 && null !== c2)
          c2.return = b, b = c2;
        else {
          if (b === a2)
            break;
          for (; null === b.sibling; ) {
            if (null === b.return || b.return === a2)
              return true;
            b = b.return;
          }
          b.sibling.return = b.return;
          b = b.sibling;
        }
      }
      return true;
    }
    function Ck(a2, b) {
      b &= ~rk;
      b &= ~qk;
      a2.suspendedLanes |= b;
      a2.pingedLanes &= ~b;
      for (a2 = a2.expirationTimes; 0 < b; ) {
        var c2 = 31 - oc(b), d = 1 << c2;
        a2[c2] = -1;
        b &= ~d;
      }
    }
    function Ek(a2) {
      if (0 !== (K & 6))
        throw Error(p2(327));
      Hk();
      var b = uc(a2, 0);
      if (0 === (b & 1))
        return Dk(a2, B()), null;
      var c2 = Ik(a2, b);
      if (0 !== a2.tag && 2 === c2) {
        var d = xc(a2);
        0 !== d && (b = d, c2 = Nk(a2, d));
      }
      if (1 === c2)
        throw c2 = pk, Kk(a2, 0), Ck(a2, b), Dk(a2, B()), c2;
      if (6 === c2)
        throw Error(p2(345));
      a2.finishedWork = a2.current.alternate;
      a2.finishedLanes = b;
      Pk(a2, tk, uk);
      Dk(a2, B());
      return null;
    }
    function Qk(a2, b) {
      var c2 = K;
      K |= 1;
      try {
        return a2(b);
      } finally {
        K = c2, 0 === K && (Gj = B() + 500, fg && jg());
      }
    }
    function Rk(a2) {
      null !== wk && 0 === wk.tag && 0 === (K & 6) && Hk();
      var b = K;
      K |= 1;
      var c2 = ok.transition, d = C2;
      try {
        if (ok.transition = null, C2 = 1, a2)
          return a2();
      } finally {
        C2 = d, ok.transition = c2, K = b, 0 === (K & 6) && jg();
      }
    }
    function Hj() {
      fj = ej.current;
      E2(ej);
    }
    function Kk(a2, b) {
      a2.finishedWork = null;
      a2.finishedLanes = 0;
      var c2 = a2.timeoutHandle;
      -1 !== c2 && (a2.timeoutHandle = -1, Gf(c2));
      if (null !== Y2)
        for (c2 = Y2.return; null !== c2; ) {
          var d = c2;
          wg(d);
          switch (d.tag) {
            case 1:
              d = d.type.childContextTypes;
              null !== d && void 0 !== d && $f();
              break;
            case 3:
              zh();
              E2(Wf);
              E2(H2);
              Eh();
              break;
            case 5:
              Bh(d);
              break;
            case 4:
              zh();
              break;
            case 13:
              E2(L2);
              break;
            case 19:
              E2(L2);
              break;
            case 10:
              ah(d.type._context);
              break;
            case 22:
            case 23:
              Hj();
          }
          c2 = c2.return;
        }
      Q2 = a2;
      Y2 = a2 = Pg(a2.current, null);
      Z = fj = b;
      T = 0;
      pk = null;
      rk = qk = rh = 0;
      tk = sk = null;
      if (null !== fh) {
        for (b = 0; b < fh.length; b++)
          if (c2 = fh[b], d = c2.interleaved, null !== d) {
            c2.interleaved = null;
            var e = d.next, f = c2.pending;
            if (null !== f) {
              var g = f.next;
              f.next = e;
              d.next = g;
            }
            c2.pending = d;
          }
        fh = null;
      }
      return a2;
    }
    function Mk(a2, b) {
      do {
        var c2 = Y2;
        try {
          $g();
          Fh.current = Rh;
          if (Ih) {
            for (var d = M2.memoizedState; null !== d; ) {
              var e = d.queue;
              null !== e && (e.pending = null);
              d = d.next;
            }
            Ih = false;
          }
          Hh = 0;
          O = N = M2 = null;
          Jh = false;
          Kh = 0;
          nk.current = null;
          if (null === c2 || null === c2.return) {
            T = 1;
            pk = b;
            Y2 = null;
            break;
          }
          a: {
            var f = a2, g = c2.return, h = c2, k = b;
            b = Z;
            h.flags |= 32768;
            if (null !== k && "object" === typeof k && "function" === typeof k.then) {
              var l = k, m2 = h, q2 = m2.tag;
              if (0 === (m2.mode & 1) && (0 === q2 || 11 === q2 || 15 === q2)) {
                var r2 = m2.alternate;
                r2 ? (m2.updateQueue = r2.updateQueue, m2.memoizedState = r2.memoizedState, m2.lanes = r2.lanes) : (m2.updateQueue = null, m2.memoizedState = null);
              }
              var y = Ui2(g);
              if (null !== y) {
                y.flags &= -257;
                Vi2(y, g, h, f, b);
                y.mode & 1 && Si2(f, l, b);
                b = y;
                k = l;
                var n = b.updateQueue;
                if (null === n) {
                  var t2 = /* @__PURE__ */ new Set();
                  t2.add(k);
                  b.updateQueue = t2;
                } else
                  n.add(k);
                break a;
              } else {
                if (0 === (b & 1)) {
                  Si2(f, l, b);
                  tj();
                  break a;
                }
                k = Error(p2(426));
              }
            } else if (I && h.mode & 1) {
              var J = Ui2(g);
              if (null !== J) {
                0 === (J.flags & 65536) && (J.flags |= 256);
                Vi2(J, g, h, f, b);
                Jg(Ji2(k, h));
                break a;
              }
            }
            f = k = Ji2(k, h);
            4 !== T && (T = 2);
            null === sk ? sk = [f] : sk.push(f);
            f = g;
            do {
              switch (f.tag) {
                case 3:
                  f.flags |= 65536;
                  b &= -b;
                  f.lanes |= b;
                  var x2 = Ni2(f, k, b);
                  ph(f, x2);
                  break a;
                case 1:
                  h = k;
                  var w = f.type, u = f.stateNode;
                  if (0 === (f.flags & 128) && ("function" === typeof w.getDerivedStateFromError || null !== u && "function" === typeof u.componentDidCatch && (null === Ri2 || !Ri2.has(u)))) {
                    f.flags |= 65536;
                    b &= -b;
                    f.lanes |= b;
                    var F = Qi2(f, h, b);
                    ph(f, F);
                    break a;
                  }
              }
              f = f.return;
            } while (null !== f);
          }
          Sk(c2);
        } catch (na) {
          b = na;
          Y2 === c2 && null !== c2 && (Y2 = c2 = c2.return);
          continue;
        }
        break;
      } while (1);
    }
    function Jk() {
      var a2 = mk.current;
      mk.current = Rh;
      return null === a2 ? Rh : a2;
    }
    function tj() {
      if (0 === T || 3 === T || 2 === T)
        T = 4;
      null === Q2 || 0 === (rh & 268435455) && 0 === (qk & 268435455) || Ck(Q2, Z);
    }
    function Ik(a2, b) {
      var c2 = K;
      K |= 2;
      var d = Jk();
      if (Q2 !== a2 || Z !== b)
        uk = null, Kk(a2, b);
      do
        try {
          Tk();
          break;
        } catch (e) {
          Mk(a2, e);
        }
      while (1);
      $g();
      K = c2;
      mk.current = d;
      if (null !== Y2)
        throw Error(p2(261));
      Q2 = null;
      Z = 0;
      return T;
    }
    function Tk() {
      for (; null !== Y2; )
        Uk(Y2);
    }
    function Lk() {
      for (; null !== Y2 && !cc(); )
        Uk(Y2);
    }
    function Uk(a2) {
      var b = Vk(a2.alternate, a2, fj);
      a2.memoizedProps = a2.pendingProps;
      null === b ? Sk(a2) : Y2 = b;
      nk.current = null;
    }
    function Sk(a2) {
      var b = a2;
      do {
        var c2 = b.alternate;
        a2 = b.return;
        if (0 === (b.flags & 32768)) {
          if (c2 = Ej(c2, b, fj), null !== c2) {
            Y2 = c2;
            return;
          }
        } else {
          c2 = Ij(c2, b);
          if (null !== c2) {
            c2.flags &= 32767;
            Y2 = c2;
            return;
          }
          if (null !== a2)
            a2.flags |= 32768, a2.subtreeFlags = 0, a2.deletions = null;
          else {
            T = 6;
            Y2 = null;
            return;
          }
        }
        b = b.sibling;
        if (null !== b) {
          Y2 = b;
          return;
        }
        Y2 = b = a2;
      } while (null !== b);
      0 === T && (T = 5);
    }
    function Pk(a2, b, c2) {
      var d = C2, e = ok.transition;
      try {
        ok.transition = null, C2 = 1, Wk(a2, b, c2, d);
      } finally {
        ok.transition = e, C2 = d;
      }
      return null;
    }
    function Wk(a2, b, c2, d) {
      do
        Hk();
      while (null !== wk);
      if (0 !== (K & 6))
        throw Error(p2(327));
      c2 = a2.finishedWork;
      var e = a2.finishedLanes;
      if (null === c2)
        return null;
      a2.finishedWork = null;
      a2.finishedLanes = 0;
      if (c2 === a2.current)
        throw Error(p2(177));
      a2.callbackNode = null;
      a2.callbackPriority = 0;
      var f = c2.lanes | c2.childLanes;
      Bc(a2, f);
      a2 === Q2 && (Y2 = Q2 = null, Z = 0);
      0 === (c2.subtreeFlags & 2064) && 0 === (c2.flags & 2064) || vk || (vk = true, Fk(hc, function() {
        Hk();
        return null;
      }));
      f = 0 !== (c2.flags & 15990);
      if (0 !== (c2.subtreeFlags & 15990) || f) {
        f = ok.transition;
        ok.transition = null;
        var g = C2;
        C2 = 1;
        var h = K;
        K |= 4;
        nk.current = null;
        Oj(a2, c2);
        dk(c2, a2);
        Oe2(Df);
        dd = !!Cf;
        Df = Cf = null;
        a2.current = c2;
        hk(c2);
        dc();
        K = h;
        C2 = g;
        ok.transition = f;
      } else
        a2.current = c2;
      vk && (vk = false, wk = a2, xk = e);
      f = a2.pendingLanes;
      0 === f && (Ri2 = null);
      mc(c2.stateNode);
      Dk(a2, B());
      if (null !== b)
        for (d = a2.onRecoverableError, c2 = 0; c2 < b.length; c2++)
          e = b[c2], d(e.value, { componentStack: e.stack, digest: e.digest });
      if (Oi2)
        throw Oi2 = false, a2 = Pi2, Pi2 = null, a2;
      0 !== (xk & 1) && 0 !== a2.tag && Hk();
      f = a2.pendingLanes;
      0 !== (f & 1) ? a2 === zk ? yk++ : (yk = 0, zk = a2) : yk = 0;
      jg();
      return null;
    }
    function Hk() {
      if (null !== wk) {
        var a2 = Dc(xk), b = ok.transition, c2 = C2;
        try {
          ok.transition = null;
          C2 = 16 > a2 ? 16 : a2;
          if (null === wk)
            var d = false;
          else {
            a2 = wk;
            wk = null;
            xk = 0;
            if (0 !== (K & 6))
              throw Error(p2(331));
            var e = K;
            K |= 4;
            for (V2 = a2.current; null !== V2; ) {
              var f = V2, g = f.child;
              if (0 !== (V2.flags & 16)) {
                var h = f.deletions;
                if (null !== h) {
                  for (var k = 0; k < h.length; k++) {
                    var l = h[k];
                    for (V2 = l; null !== V2; ) {
                      var m2 = V2;
                      switch (m2.tag) {
                        case 0:
                        case 11:
                        case 15:
                          Pj(8, m2, f);
                      }
                      var q2 = m2.child;
                      if (null !== q2)
                        q2.return = m2, V2 = q2;
                      else
                        for (; null !== V2; ) {
                          m2 = V2;
                          var r2 = m2.sibling, y = m2.return;
                          Sj(m2);
                          if (m2 === l) {
                            V2 = null;
                            break;
                          }
                          if (null !== r2) {
                            r2.return = y;
                            V2 = r2;
                            break;
                          }
                          V2 = y;
                        }
                    }
                  }
                  var n = f.alternate;
                  if (null !== n) {
                    var t2 = n.child;
                    if (null !== t2) {
                      n.child = null;
                      do {
                        var J = t2.sibling;
                        t2.sibling = null;
                        t2 = J;
                      } while (null !== t2);
                    }
                  }
                  V2 = f;
                }
              }
              if (0 !== (f.subtreeFlags & 2064) && null !== g)
                g.return = f, V2 = g;
              else
                b:
                  for (; null !== V2; ) {
                    f = V2;
                    if (0 !== (f.flags & 2048))
                      switch (f.tag) {
                        case 0:
                        case 11:
                        case 15:
                          Pj(9, f, f.return);
                      }
                    var x2 = f.sibling;
                    if (null !== x2) {
                      x2.return = f.return;
                      V2 = x2;
                      break b;
                    }
                    V2 = f.return;
                  }
            }
            var w = a2.current;
            for (V2 = w; null !== V2; ) {
              g = V2;
              var u = g.child;
              if (0 !== (g.subtreeFlags & 2064) && null !== u)
                u.return = g, V2 = u;
              else
                b:
                  for (g = w; null !== V2; ) {
                    h = V2;
                    if (0 !== (h.flags & 2048))
                      try {
                        switch (h.tag) {
                          case 0:
                          case 11:
                          case 15:
                            Qj(9, h);
                        }
                      } catch (na) {
                        W2(h, h.return, na);
                      }
                    if (h === g) {
                      V2 = null;
                      break b;
                    }
                    var F = h.sibling;
                    if (null !== F) {
                      F.return = h.return;
                      V2 = F;
                      break b;
                    }
                    V2 = h.return;
                  }
            }
            K = e;
            jg();
            if (lc && "function" === typeof lc.onPostCommitFiberRoot)
              try {
                lc.onPostCommitFiberRoot(kc, a2);
              } catch (na) {
              }
            d = true;
          }
          return d;
        } finally {
          C2 = c2, ok.transition = b;
        }
      }
      return false;
    }
    function Xk(a2, b, c2) {
      b = Ji2(c2, b);
      b = Ni2(a2, b, 1);
      a2 = nh(a2, b, 1);
      b = R();
      null !== a2 && (Ac(a2, 1, b), Dk(a2, b));
    }
    function W2(a2, b, c2) {
      if (3 === a2.tag)
        Xk(a2, a2, c2);
      else
        for (; null !== b; ) {
          if (3 === b.tag) {
            Xk(b, a2, c2);
            break;
          } else if (1 === b.tag) {
            var d = b.stateNode;
            if ("function" === typeof b.type.getDerivedStateFromError || "function" === typeof d.componentDidCatch && (null === Ri2 || !Ri2.has(d))) {
              a2 = Ji2(c2, a2);
              a2 = Qi2(b, a2, 1);
              b = nh(b, a2, 1);
              a2 = R();
              null !== b && (Ac(b, 1, a2), Dk(b, a2));
              break;
            }
          }
          b = b.return;
        }
    }
    function Ti2(a2, b, c2) {
      var d = a2.pingCache;
      null !== d && d.delete(b);
      b = R();
      a2.pingedLanes |= a2.suspendedLanes & c2;
      Q2 === a2 && (Z & c2) === c2 && (4 === T || 3 === T && (Z & 130023424) === Z && 500 > B() - fk ? Kk(a2, 0) : rk |= c2);
      Dk(a2, b);
    }
    function Yk(a2, b) {
      0 === b && (0 === (a2.mode & 1) ? b = 1 : (b = sc, sc <<= 1, 0 === (sc & 130023424) && (sc = 4194304)));
      var c2 = R();
      a2 = ih(a2, b);
      null !== a2 && (Ac(a2, b, c2), Dk(a2, c2));
    }
    function uj(a2) {
      var b = a2.memoizedState, c2 = 0;
      null !== b && (c2 = b.retryLane);
      Yk(a2, c2);
    }
    function bk(a2, b) {
      var c2 = 0;
      switch (a2.tag) {
        case 13:
          var d = a2.stateNode;
          var e = a2.memoizedState;
          null !== e && (c2 = e.retryLane);
          break;
        case 19:
          d = a2.stateNode;
          break;
        default:
          throw Error(p2(314));
      }
      null !== d && d.delete(b);
      Yk(a2, c2);
    }
    var Vk;
    Vk = function(a2, b, c2) {
      if (null !== a2)
        if (a2.memoizedProps !== b.pendingProps || Wf.current)
          dh = true;
        else {
          if (0 === (a2.lanes & c2) && 0 === (b.flags & 128))
            return dh = false, yj(a2, b, c2);
          dh = 0 !== (a2.flags & 131072) ? true : false;
        }
      else
        dh = false, I && 0 !== (b.flags & 1048576) && ug(b, ng, b.index);
      b.lanes = 0;
      switch (b.tag) {
        case 2:
          var d = b.type;
          ij(a2, b);
          a2 = b.pendingProps;
          var e = Yf(b, H2.current);
          ch(b, c2);
          e = Nh(null, b, d, a2, e, c2);
          var f = Sh();
          b.flags |= 1;
          "object" === typeof e && null !== e && "function" === typeof e.render && void 0 === e.$$typeof ? (b.tag = 1, b.memoizedState = null, b.updateQueue = null, Zf(d) ? (f = true, cg(b)) : f = false, b.memoizedState = null !== e.state && void 0 !== e.state ? e.state : null, kh(b), e.updater = Ei2, b.stateNode = e, e._reactInternals = b, Ii2(b, d, a2, c2), b = jj(null, b, d, true, f, c2)) : (b.tag = 0, I && f && vg(b), Xi2(null, b, e, c2), b = b.child);
          return b;
        case 16:
          d = b.elementType;
          a: {
            ij(a2, b);
            a2 = b.pendingProps;
            e = d._init;
            d = e(d._payload);
            b.type = d;
            e = b.tag = Zk(d);
            a2 = Ci2(d, a2);
            switch (e) {
              case 0:
                b = cj(null, b, d, a2, c2);
                break a;
              case 1:
                b = hj(null, b, d, a2, c2);
                break a;
              case 11:
                b = Yi2(null, b, d, a2, c2);
                break a;
              case 14:
                b = $i2(null, b, d, Ci2(d.type, a2), c2);
                break a;
            }
            throw Error(p2(
              306,
              d,
              ""
            ));
          }
          return b;
        case 0:
          return d = b.type, e = b.pendingProps, e = b.elementType === d ? e : Ci2(d, e), cj(a2, b, d, e, c2);
        case 1:
          return d = b.type, e = b.pendingProps, e = b.elementType === d ? e : Ci2(d, e), hj(a2, b, d, e, c2);
        case 3:
          a: {
            kj(b);
            if (null === a2)
              throw Error(p2(387));
            d = b.pendingProps;
            f = b.memoizedState;
            e = f.element;
            lh(a2, b);
            qh(b, d, null, c2);
            var g = b.memoizedState;
            d = g.element;
            if (f.isDehydrated)
              if (f = { element: d, isDehydrated: false, cache: g.cache, pendingSuspenseBoundaries: g.pendingSuspenseBoundaries, transitions: g.transitions }, b.updateQueue.baseState = f, b.memoizedState = f, b.flags & 256) {
                e = Ji2(Error(p2(423)), b);
                b = lj(a2, b, d, c2, e);
                break a;
              } else if (d !== e) {
                e = Ji2(Error(p2(424)), b);
                b = lj(a2, b, d, c2, e);
                break a;
              } else
                for (yg = Lf(b.stateNode.containerInfo.firstChild), xg = b, I = true, zg = null, c2 = Vg(b, null, d, c2), b.child = c2; c2; )
                  c2.flags = c2.flags & -3 | 4096, c2 = c2.sibling;
            else {
              Ig();
              if (d === e) {
                b = Zi2(a2, b, c2);
                break a;
              }
              Xi2(a2, b, d, c2);
            }
            b = b.child;
          }
          return b;
        case 5:
          return Ah(b), null === a2 && Eg(b), d = b.type, e = b.pendingProps, f = null !== a2 ? a2.memoizedProps : null, g = e.children, Ef(d, e) ? g = null : null !== f && Ef(d, f) && (b.flags |= 32), gj(a2, b), Xi2(a2, b, g, c2), b.child;
        case 6:
          return null === a2 && Eg(b), null;
        case 13:
          return oj(a2, b, c2);
        case 4:
          return yh(b, b.stateNode.containerInfo), d = b.pendingProps, null === a2 ? b.child = Ug(b, null, d, c2) : Xi2(a2, b, d, c2), b.child;
        case 11:
          return d = b.type, e = b.pendingProps, e = b.elementType === d ? e : Ci2(d, e), Yi2(a2, b, d, e, c2);
        case 7:
          return Xi2(a2, b, b.pendingProps, c2), b.child;
        case 8:
          return Xi2(a2, b, b.pendingProps.children, c2), b.child;
        case 12:
          return Xi2(a2, b, b.pendingProps.children, c2), b.child;
        case 10:
          a: {
            d = b.type._context;
            e = b.pendingProps;
            f = b.memoizedProps;
            g = e.value;
            G2(Wg, d._currentValue);
            d._currentValue = g;
            if (null !== f)
              if (He2(f.value, g)) {
                if (f.children === e.children && !Wf.current) {
                  b = Zi2(a2, b, c2);
                  break a;
                }
              } else
                for (f = b.child, null !== f && (f.return = b); null !== f; ) {
                  var h = f.dependencies;
                  if (null !== h) {
                    g = f.child;
                    for (var k = h.firstContext; null !== k; ) {
                      if (k.context === d) {
                        if (1 === f.tag) {
                          k = mh(-1, c2 & -c2);
                          k.tag = 2;
                          var l = f.updateQueue;
                          if (null !== l) {
                            l = l.shared;
                            var m2 = l.pending;
                            null === m2 ? k.next = k : (k.next = m2.next, m2.next = k);
                            l.pending = k;
                          }
                        }
                        f.lanes |= c2;
                        k = f.alternate;
                        null !== k && (k.lanes |= c2);
                        bh(
                          f.return,
                          c2,
                          b
                        );
                        h.lanes |= c2;
                        break;
                      }
                      k = k.next;
                    }
                  } else if (10 === f.tag)
                    g = f.type === b.type ? null : f.child;
                  else if (18 === f.tag) {
                    g = f.return;
                    if (null === g)
                      throw Error(p2(341));
                    g.lanes |= c2;
                    h = g.alternate;
                    null !== h && (h.lanes |= c2);
                    bh(g, c2, b);
                    g = f.sibling;
                  } else
                    g = f.child;
                  if (null !== g)
                    g.return = f;
                  else
                    for (g = f; null !== g; ) {
                      if (g === b) {
                        g = null;
                        break;
                      }
                      f = g.sibling;
                      if (null !== f) {
                        f.return = g.return;
                        g = f;
                        break;
                      }
                      g = g.return;
                    }
                  f = g;
                }
            Xi2(a2, b, e.children, c2);
            b = b.child;
          }
          return b;
        case 9:
          return e = b.type, d = b.pendingProps.children, ch(b, c2), e = eh(e), d = d(e), b.flags |= 1, Xi2(a2, b, d, c2), b.child;
        case 14:
          return d = b.type, e = Ci2(d, b.pendingProps), e = Ci2(d.type, e), $i2(a2, b, d, e, c2);
        case 15:
          return bj(a2, b, b.type, b.pendingProps, c2);
        case 17:
          return d = b.type, e = b.pendingProps, e = b.elementType === d ? e : Ci2(d, e), ij(a2, b), b.tag = 1, Zf(d) ? (a2 = true, cg(b)) : a2 = false, ch(b, c2), Gi2(b, d, e), Ii2(b, d, e, c2), jj(null, b, d, true, a2, c2);
        case 19:
          return xj(a2, b, c2);
        case 22:
          return dj(a2, b, c2);
      }
      throw Error(p2(156, b.tag));
    };
    function Fk(a2, b) {
      return ac(a2, b);
    }
    function $k(a2, b, c2, d) {
      this.tag = a2;
      this.key = c2;
      this.sibling = this.child = this.return = this.stateNode = this.type = this.elementType = null;
      this.index = 0;
      this.ref = null;
      this.pendingProps = b;
      this.dependencies = this.memoizedState = this.updateQueue = this.memoizedProps = null;
      this.mode = d;
      this.subtreeFlags = this.flags = 0;
      this.deletions = null;
      this.childLanes = this.lanes = 0;
      this.alternate = null;
    }
    function Bg(a2, b, c2, d) {
      return new $k(a2, b, c2, d);
    }
    function aj(a2) {
      a2 = a2.prototype;
      return !(!a2 || !a2.isReactComponent);
    }
    function Zk(a2) {
      if ("function" === typeof a2)
        return aj(a2) ? 1 : 0;
      if (void 0 !== a2 && null !== a2) {
        a2 = a2.$$typeof;
        if (a2 === Da)
          return 11;
        if (a2 === Ga)
          return 14;
      }
      return 2;
    }
    function Pg(a2, b) {
      var c2 = a2.alternate;
      null === c2 ? (c2 = Bg(a2.tag, b, a2.key, a2.mode), c2.elementType = a2.elementType, c2.type = a2.type, c2.stateNode = a2.stateNode, c2.alternate = a2, a2.alternate = c2) : (c2.pendingProps = b, c2.type = a2.type, c2.flags = 0, c2.subtreeFlags = 0, c2.deletions = null);
      c2.flags = a2.flags & 14680064;
      c2.childLanes = a2.childLanes;
      c2.lanes = a2.lanes;
      c2.child = a2.child;
      c2.memoizedProps = a2.memoizedProps;
      c2.memoizedState = a2.memoizedState;
      c2.updateQueue = a2.updateQueue;
      b = a2.dependencies;
      c2.dependencies = null === b ? null : { lanes: b.lanes, firstContext: b.firstContext };
      c2.sibling = a2.sibling;
      c2.index = a2.index;
      c2.ref = a2.ref;
      return c2;
    }
    function Rg(a2, b, c2, d, e, f) {
      var g = 2;
      d = a2;
      if ("function" === typeof a2)
        aj(a2) && (g = 1);
      else if ("string" === typeof a2)
        g = 5;
      else
        a:
          switch (a2) {
            case ya:
              return Tg(c2.children, e, f, b);
            case za:
              g = 8;
              e |= 8;
              break;
            case Aa:
              return a2 = Bg(12, c2, b, e | 2), a2.elementType = Aa, a2.lanes = f, a2;
            case Ea:
              return a2 = Bg(13, c2, b, e), a2.elementType = Ea, a2.lanes = f, a2;
            case Fa:
              return a2 = Bg(19, c2, b, e), a2.elementType = Fa, a2.lanes = f, a2;
            case Ia:
              return pj(c2, e, f, b);
            default:
              if ("object" === typeof a2 && null !== a2)
                switch (a2.$$typeof) {
                  case Ba:
                    g = 10;
                    break a;
                  case Ca:
                    g = 9;
                    break a;
                  case Da:
                    g = 11;
                    break a;
                  case Ga:
                    g = 14;
                    break a;
                  case Ha:
                    g = 16;
                    d = null;
                    break a;
                }
              throw Error(p2(130, null == a2 ? a2 : typeof a2, ""));
          }
      b = Bg(g, c2, b, e);
      b.elementType = a2;
      b.type = d;
      b.lanes = f;
      return b;
    }
    function Tg(a2, b, c2, d) {
      a2 = Bg(7, a2, d, b);
      a2.lanes = c2;
      return a2;
    }
    function pj(a2, b, c2, d) {
      a2 = Bg(22, a2, d, b);
      a2.elementType = Ia;
      a2.lanes = c2;
      a2.stateNode = { isHidden: false };
      return a2;
    }
    function Qg(a2, b, c2) {
      a2 = Bg(6, a2, null, b);
      a2.lanes = c2;
      return a2;
    }
    function Sg(a2, b, c2) {
      b = Bg(4, null !== a2.children ? a2.children : [], a2.key, b);
      b.lanes = c2;
      b.stateNode = { containerInfo: a2.containerInfo, pendingChildren: null, implementation: a2.implementation };
      return b;
    }
    function al(a2, b, c2, d, e) {
      this.tag = b;
      this.containerInfo = a2;
      this.finishedWork = this.pingCache = this.current = this.pendingChildren = null;
      this.timeoutHandle = -1;
      this.callbackNode = this.pendingContext = this.context = null;
      this.callbackPriority = 0;
      this.eventTimes = zc(0);
      this.expirationTimes = zc(-1);
      this.entangledLanes = this.finishedLanes = this.mutableReadLanes = this.expiredLanes = this.pingedLanes = this.suspendedLanes = this.pendingLanes = 0;
      this.entanglements = zc(0);
      this.identifierPrefix = d;
      this.onRecoverableError = e;
      this.mutableSourceEagerHydrationData = null;
    }
    function bl(a2, b, c2, d, e, f, g, h, k) {
      a2 = new al(a2, b, c2, h, k);
      1 === b ? (b = 1, true === f && (b |= 8)) : b = 0;
      f = Bg(3, null, null, b);
      a2.current = f;
      f.stateNode = a2;
      f.memoizedState = { element: d, isDehydrated: c2, cache: null, transitions: null, pendingSuspenseBoundaries: null };
      kh(f);
      return a2;
    }
    function cl(a2, b, c2) {
      var d = 3 < arguments.length && void 0 !== arguments[3] ? arguments[3] : null;
      return { $$typeof: wa, key: null == d ? null : "" + d, children: a2, containerInfo: b, implementation: c2 };
    }
    function dl(a2) {
      if (!a2)
        return Vf;
      a2 = a2._reactInternals;
      a: {
        if (Vb(a2) !== a2 || 1 !== a2.tag)
          throw Error(p2(170));
        var b = a2;
        do {
          switch (b.tag) {
            case 3:
              b = b.stateNode.context;
              break a;
            case 1:
              if (Zf(b.type)) {
                b = b.stateNode.__reactInternalMemoizedMergedChildContext;
                break a;
              }
          }
          b = b.return;
        } while (null !== b);
        throw Error(p2(171));
      }
      if (1 === a2.tag) {
        var c2 = a2.type;
        if (Zf(c2))
          return bg(a2, c2, b);
      }
      return b;
    }
    function el(a2, b, c2, d, e, f, g, h, k) {
      a2 = bl(c2, d, true, a2, e, f, g, h, k);
      a2.context = dl(null);
      c2 = a2.current;
      d = R();
      e = yi2(c2);
      f = mh(d, e);
      f.callback = void 0 !== b && null !== b ? b : null;
      nh(c2, f, e);
      a2.current.lanes = e;
      Ac(a2, e, d);
      Dk(a2, d);
      return a2;
    }
    function fl(a2, b, c2, d) {
      var e = b.current, f = R(), g = yi2(e);
      c2 = dl(c2);
      null === b.context ? b.context = c2 : b.pendingContext = c2;
      b = mh(f, g);
      b.payload = { element: a2 };
      d = void 0 === d ? null : d;
      null !== d && (b.callback = d);
      a2 = nh(e, b, g);
      null !== a2 && (gi2(a2, e, g, f), oh(a2, e, g));
      return g;
    }
    function gl(a2) {
      a2 = a2.current;
      if (!a2.child)
        return null;
      switch (a2.child.tag) {
        case 5:
          return a2.child.stateNode;
        default:
          return a2.child.stateNode;
      }
    }
    function hl(a2, b) {
      a2 = a2.memoizedState;
      if (null !== a2 && null !== a2.dehydrated) {
        var c2 = a2.retryLane;
        a2.retryLane = 0 !== c2 && c2 < b ? c2 : b;
      }
    }
    function il(a2, b) {
      hl(a2, b);
      (a2 = a2.alternate) && hl(a2, b);
    }
    function jl() {
      return null;
    }
    var kl = "function" === typeof reportError ? reportError : function(a2) {
      console.error(a2);
    };
    function ll(a2) {
      this._internalRoot = a2;
    }
    ml.prototype.render = ll.prototype.render = function(a2) {
      var b = this._internalRoot;
      if (null === b)
        throw Error(p2(409));
      fl(a2, b, null, null);
    };
    ml.prototype.unmount = ll.prototype.unmount = function() {
      var a2 = this._internalRoot;
      if (null !== a2) {
        this._internalRoot = null;
        var b = a2.containerInfo;
        Rk(function() {
          fl(null, a2, null, null);
        });
        b[uf] = null;
      }
    };
    function ml(a2) {
      this._internalRoot = a2;
    }
    ml.prototype.unstable_scheduleHydration = function(a2) {
      if (a2) {
        var b = Hc();
        a2 = { blockedOn: null, target: a2, priority: b };
        for (var c2 = 0; c2 < Qc.length && 0 !== b && b < Qc[c2].priority; c2++)
          ;
        Qc.splice(c2, 0, a2);
        0 === c2 && Vc(a2);
      }
    };
    function nl(a2) {
      return !(!a2 || 1 !== a2.nodeType && 9 !== a2.nodeType && 11 !== a2.nodeType);
    }
    function ol(a2) {
      return !(!a2 || 1 !== a2.nodeType && 9 !== a2.nodeType && 11 !== a2.nodeType && (8 !== a2.nodeType || " react-mount-point-unstable " !== a2.nodeValue));
    }
    function pl() {
    }
    function ql(a2, b, c2, d, e) {
      if (e) {
        if ("function" === typeof d) {
          var f = d;
          d = function() {
            var a3 = gl(g);
            f.call(a3);
          };
        }
        var g = el(b, d, a2, 0, null, false, false, "", pl);
        a2._reactRootContainer = g;
        a2[uf] = g.current;
        sf(8 === a2.nodeType ? a2.parentNode : a2);
        Rk();
        return g;
      }
      for (; e = a2.lastChild; )
        a2.removeChild(e);
      if ("function" === typeof d) {
        var h = d;
        d = function() {
          var a3 = gl(k);
          h.call(a3);
        };
      }
      var k = bl(a2, 0, false, null, null, false, false, "", pl);
      a2._reactRootContainer = k;
      a2[uf] = k.current;
      sf(8 === a2.nodeType ? a2.parentNode : a2);
      Rk(function() {
        fl(b, k, c2, d);
      });
      return k;
    }
    function rl(a2, b, c2, d, e) {
      var f = c2._reactRootContainer;
      if (f) {
        var g = f;
        if ("function" === typeof e) {
          var h = e;
          e = function() {
            var a3 = gl(g);
            h.call(a3);
          };
        }
        fl(b, g, a2, e);
      } else
        g = ql(c2, b, a2, e, d);
      return gl(g);
    }
    Ec = function(a2) {
      switch (a2.tag) {
        case 3:
          var b = a2.stateNode;
          if (b.current.memoizedState.isDehydrated) {
            var c2 = tc(b.pendingLanes);
            0 !== c2 && (Cc(b, c2 | 1), Dk(b, B()), 0 === (K & 6) && (Gj = B() + 500, jg()));
          }
          break;
        case 13:
          Rk(function() {
            var b2 = ih(a2, 1);
            if (null !== b2) {
              var c3 = R();
              gi2(b2, a2, 1, c3);
            }
          }), il(a2, 1);
      }
    };
    Fc = function(a2) {
      if (13 === a2.tag) {
        var b = ih(a2, 134217728);
        if (null !== b) {
          var c2 = R();
          gi2(b, a2, 134217728, c2);
        }
        il(a2, 134217728);
      }
    };
    Gc = function(a2) {
      if (13 === a2.tag) {
        var b = yi2(a2), c2 = ih(a2, b);
        if (null !== c2) {
          var d = R();
          gi2(c2, a2, b, d);
        }
        il(a2, b);
      }
    };
    Hc = function() {
      return C2;
    };
    Ic = function(a2, b) {
      var c2 = C2;
      try {
        return C2 = a2, b();
      } finally {
        C2 = c2;
      }
    };
    yb = function(a2, b, c2) {
      switch (b) {
        case "input":
          bb(a2, c2);
          b = c2.name;
          if ("radio" === c2.type && null != b) {
            for (c2 = a2; c2.parentNode; )
              c2 = c2.parentNode;
            c2 = c2.querySelectorAll("input[name=" + JSON.stringify("" + b) + '][type="radio"]');
            for (b = 0; b < c2.length; b++) {
              var d = c2[b];
              if (d !== a2 && d.form === a2.form) {
                var e = Db(d);
                if (!e)
                  throw Error(p2(90));
                Wa(d);
                bb(d, e);
              }
            }
          }
          break;
        case "textarea":
          ib(a2, c2);
          break;
        case "select":
          b = c2.value, null != b && fb(a2, !!c2.multiple, b, false);
      }
    };
    Gb = Qk;
    Hb = Rk;
    var sl = { usingClientEntryPoint: false, Events: [Cb, ue2, Db, Eb, Fb, Qk] }, tl = { findFiberByHostInstance: Wc, bundleType: 0, version: "18.3.1", rendererPackageName: "react-dom" };
    var ul = { bundleType: tl.bundleType, version: tl.version, rendererPackageName: tl.rendererPackageName, rendererConfig: tl.rendererConfig, overrideHookState: null, overrideHookStateDeletePath: null, overrideHookStateRenamePath: null, overrideProps: null, overridePropsDeletePath: null, overridePropsRenamePath: null, setErrorHandler: null, setSuspenseHandler: null, scheduleUpdate: null, currentDispatcherRef: ua.ReactCurrentDispatcher, findHostInstanceByFiber: function(a2) {
      a2 = Zb(a2);
      return null === a2 ? null : a2.stateNode;
    }, findFiberByHostInstance: tl.findFiberByHostInstance || jl, findHostInstancesForRefresh: null, scheduleRefresh: null, scheduleRoot: null, setRefreshHandler: null, getCurrentFiber: null, reconcilerVersion: "18.3.1-next-f1338f8080-20240426" };
    if ("undefined" !== typeof __REACT_DEVTOOLS_GLOBAL_HOOK__) {
      var vl = __REACT_DEVTOOLS_GLOBAL_HOOK__;
      if (!vl.isDisabled && vl.supportsFiber)
        try {
          kc = vl.inject(ul), lc = vl;
        } catch (a2) {
        }
    }
    reactDom_production_min.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED = sl;
    reactDom_production_min.createPortal = function(a2, b) {
      var c2 = 2 < arguments.length && void 0 !== arguments[2] ? arguments[2] : null;
      if (!nl(b))
        throw Error(p2(200));
      return cl(a2, b, null, c2);
    };
    reactDom_production_min.createRoot = function(a2, b) {
      if (!nl(a2))
        throw Error(p2(299));
      var c2 = false, d = "", e = kl;
      null !== b && void 0 !== b && (true === b.unstable_strictMode && (c2 = true), void 0 !== b.identifierPrefix && (d = b.identifierPrefix), void 0 !== b.onRecoverableError && (e = b.onRecoverableError));
      b = bl(a2, 1, false, null, null, c2, false, d, e);
      a2[uf] = b.current;
      sf(8 === a2.nodeType ? a2.parentNode : a2);
      return new ll(b);
    };
    reactDom_production_min.findDOMNode = function(a2) {
      if (null == a2)
        return null;
      if (1 === a2.nodeType)
        return a2;
      var b = a2._reactInternals;
      if (void 0 === b) {
        if ("function" === typeof a2.render)
          throw Error(p2(188));
        a2 = Object.keys(a2).join(",");
        throw Error(p2(268, a2));
      }
      a2 = Zb(b);
      a2 = null === a2 ? null : a2.stateNode;
      return a2;
    };
    reactDom_production_min.flushSync = function(a2) {
      return Rk(a2);
    };
    reactDom_production_min.hydrate = function(a2, b, c2) {
      if (!ol(b))
        throw Error(p2(200));
      return rl(null, a2, b, true, c2);
    };
    reactDom_production_min.hydrateRoot = function(a2, b, c2) {
      if (!nl(a2))
        throw Error(p2(405));
      var d = null != c2 && c2.hydratedSources || null, e = false, f = "", g = kl;
      null !== c2 && void 0 !== c2 && (true === c2.unstable_strictMode && (e = true), void 0 !== c2.identifierPrefix && (f = c2.identifierPrefix), void 0 !== c2.onRecoverableError && (g = c2.onRecoverableError));
      b = el(b, null, a2, 1, null != c2 ? c2 : null, e, false, f, g);
      a2[uf] = b.current;
      sf(a2);
      if (d)
        for (a2 = 0; a2 < d.length; a2++)
          c2 = d[a2], e = c2._getVersion, e = e(c2._source), null == b.mutableSourceEagerHydrationData ? b.mutableSourceEagerHydrationData = [c2, e] : b.mutableSourceEagerHydrationData.push(
            c2,
            e
          );
      return new ml(b);
    };
    reactDom_production_min.render = function(a2, b, c2) {
      if (!ol(b))
        throw Error(p2(200));
      return rl(null, a2, b, false, c2);
    };
    reactDom_production_min.unmountComponentAtNode = function(a2) {
      if (!ol(a2))
        throw Error(p2(40));
      return a2._reactRootContainer ? (Rk(function() {
        rl(null, null, a2, false, function() {
          a2._reactRootContainer = null;
          a2[uf] = null;
        });
      }), true) : false;
    };
    reactDom_production_min.unstable_batchedUpdates = Qk;
    reactDom_production_min.unstable_renderSubtreeIntoContainer = function(a2, b, c2, d) {
      if (!ol(c2))
        throw Error(p2(200));
      if (null == a2 || void 0 === a2._reactInternals)
        throw Error(p2(38));
      return rl(a2, b, c2, false, d);
    };
    reactDom_production_min.version = "18.3.1-next-f1338f8080-20240426";
    return reactDom_production_min;
  }
  function checkDCE() {
    if (typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ === "undefined" || typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE !== "function") {
      return;
    }
    try {
      __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE(checkDCE);
    } catch (err) {
      console.error(err);
    }
  }
  {
    checkDCE();
    reactDom.exports = requireReactDom_production_min();
  }
  var reactDomExports = reactDom.exports;
  const ReactDOM = /* @__PURE__ */ getDefaultExportFromCjs(reactDomExports);
  var unstable_batchedUpdates = ReactDOM.unstable_batchedUpdates;
  notifyManager.setBatchNotifyFunction(unstable_batchedUpdates);
  var logger = console;
  setLogger(logger);
  var defaultContext = /* @__PURE__ */ React$1.createContext(void 0);
  var QueryClientSharingContext = /* @__PURE__ */ React$1.createContext(false);
  function getQueryClientContext(contextSharing) {
    if (contextSharing && typeof window !== "undefined") {
      if (!window.ReactQueryClientContext) {
        window.ReactQueryClientContext = defaultContext;
      }
      return window.ReactQueryClientContext;
    }
    return defaultContext;
  }
  var useQueryClient = function useQueryClient2() {
    var queryClient2 = React$1.useContext(getQueryClientContext(React$1.useContext(QueryClientSharingContext)));
    if (!queryClient2) {
      throw new Error("No QueryClient set, use QueryClientProvider to set one");
    }
    return queryClient2;
  };
  var QueryClientProvider = function QueryClientProvider2(_ref) {
    var client2 = _ref.client, _ref$contextSharing = _ref.contextSharing, contextSharing = _ref$contextSharing === void 0 ? false : _ref$contextSharing, children = _ref.children;
    React$1.useEffect(function() {
      client2.mount();
      return function() {
        client2.unmount();
      };
    }, [client2]);
    var Context = getQueryClientContext(contextSharing);
    return /* @__PURE__ */ React$1.createElement(QueryClientSharingContext.Provider, {
      value: contextSharing
    }, /* @__PURE__ */ React$1.createElement(Context.Provider, {
      value: client2
    }, children));
  };
  function createValue() {
    var _isReset = false;
    return {
      clearReset: function clearReset() {
        _isReset = false;
      },
      reset: function reset() {
        _isReset = true;
      },
      isReset: function isReset() {
        return _isReset;
      }
    };
  }
  var QueryErrorResetBoundaryContext = /* @__PURE__ */ React$1.createContext(createValue());
  var useQueryErrorResetBoundary = function useQueryErrorResetBoundary2() {
    return React$1.useContext(QueryErrorResetBoundaryContext);
  };
  function shouldThrowError(suspense, _useErrorBoundary, params) {
    if (typeof _useErrorBoundary === "function") {
      return _useErrorBoundary.apply(void 0, params);
    }
    if (typeof _useErrorBoundary === "boolean")
      return _useErrorBoundary;
    return !!suspense;
  }
  function useMutation(arg1, arg2, arg3) {
    var mountedRef = React$1.useRef(false);
    var _React$useState = React$1.useState(0), forceUpdate = _React$useState[1];
    var options = parseMutationArgs(arg1, arg2, arg3);
    var queryClient2 = useQueryClient();
    var obsRef = React$1.useRef();
    if (!obsRef.current) {
      obsRef.current = new MutationObserver$1(queryClient2, options);
    } else {
      obsRef.current.setOptions(options);
    }
    var currentResult = obsRef.current.getCurrentResult();
    React$1.useEffect(function() {
      mountedRef.current = true;
      var unsubscribe = obsRef.current.subscribe(notifyManager.batchCalls(function() {
        if (mountedRef.current) {
          forceUpdate(function(x2) {
            return x2 + 1;
          });
        }
      }));
      return function() {
        mountedRef.current = false;
        unsubscribe();
      };
    }, []);
    var mutate = React$1.useCallback(function(variables, mutateOptions) {
      obsRef.current.mutate(variables, mutateOptions).catch(noop$1);
    }, []);
    if (currentResult.error && shouldThrowError(void 0, obsRef.current.options.useErrorBoundary, [currentResult.error])) {
      throw currentResult.error;
    }
    return _extends$3({}, currentResult, {
      mutate,
      mutateAsync: currentResult.mutate
    });
  }
  function useBaseQuery(options, Observer) {
    var mountedRef = React$1.useRef(false);
    var _React$useState = React$1.useState(0), forceUpdate = _React$useState[1];
    var queryClient2 = useQueryClient();
    var errorResetBoundary = useQueryErrorResetBoundary();
    var defaultedOptions = queryClient2.defaultQueryObserverOptions(options);
    defaultedOptions.optimisticResults = true;
    if (defaultedOptions.onError) {
      defaultedOptions.onError = notifyManager.batchCalls(defaultedOptions.onError);
    }
    if (defaultedOptions.onSuccess) {
      defaultedOptions.onSuccess = notifyManager.batchCalls(defaultedOptions.onSuccess);
    }
    if (defaultedOptions.onSettled) {
      defaultedOptions.onSettled = notifyManager.batchCalls(defaultedOptions.onSettled);
    }
    if (defaultedOptions.suspense) {
      if (typeof defaultedOptions.staleTime !== "number") {
        defaultedOptions.staleTime = 1e3;
      }
      if (defaultedOptions.cacheTime === 0) {
        defaultedOptions.cacheTime = 1;
      }
    }
    if (defaultedOptions.suspense || defaultedOptions.useErrorBoundary) {
      if (!errorResetBoundary.isReset()) {
        defaultedOptions.retryOnMount = false;
      }
    }
    var _React$useState2 = React$1.useState(function() {
      return new Observer(queryClient2, defaultedOptions);
    }), observer = _React$useState2[0];
    var result = observer.getOptimisticResult(defaultedOptions);
    React$1.useEffect(function() {
      mountedRef.current = true;
      errorResetBoundary.clearReset();
      var unsubscribe = observer.subscribe(notifyManager.batchCalls(function() {
        if (mountedRef.current) {
          forceUpdate(function(x2) {
            return x2 + 1;
          });
        }
      }));
      observer.updateResult();
      return function() {
        mountedRef.current = false;
        unsubscribe();
      };
    }, [errorResetBoundary, observer]);
    React$1.useEffect(function() {
      observer.setOptions(defaultedOptions, {
        listeners: false
      });
    }, [defaultedOptions, observer]);
    if (defaultedOptions.suspense && result.isLoading) {
      throw observer.fetchOptimistic(defaultedOptions).then(function(_ref) {
        var data = _ref.data;
        defaultedOptions.onSuccess == null ? void 0 : defaultedOptions.onSuccess(data);
        defaultedOptions.onSettled == null ? void 0 : defaultedOptions.onSettled(data, null);
      }).catch(function(error) {
        errorResetBoundary.clearReset();
        defaultedOptions.onError == null ? void 0 : defaultedOptions.onError(error);
        defaultedOptions.onSettled == null ? void 0 : defaultedOptions.onSettled(void 0, error);
      });
    }
    if (result.isError && !errorResetBoundary.isReset() && !result.isFetching && shouldThrowError(defaultedOptions.suspense, defaultedOptions.useErrorBoundary, [result.error, observer.getCurrentQuery()])) {
      throw result.error;
    }
    if (defaultedOptions.notifyOnChangeProps === "tracked") {
      result = observer.trackResult(result, defaultedOptions);
    }
    return result;
  }
  function useQuery(arg1, arg2, arg3) {
    var parsedOptions = parseQueryArgs(arg1, arg2, arg3);
    return useBaseQuery(parsedOptions, QueryObserver);
  }
  const queryClient = new QueryClient({
    defaultOptions: {
      queries: {
        refetchOnWindowFocus: false,
        refetchOnReconnect: false,
        retry: false
      }
    }
  });
  const QueryContext = reactExports.createContext({});
  const QueryProvider = ({
    children,
    apiUrl,
    apiKey,
    projectId
  }) => {
    return /* @__PURE__ */ jsxRuntimeExports.jsx(QueryContext.Provider, { value: { apiUrl, apiKey, projectId }, children: /* @__PURE__ */ jsxRuntimeExports.jsx(QueryClientProvider, { client: queryClient, children }) });
  };
  let rangeFrom = [], rangeTo = [];
  (() => {
    let numbers = "lc,34,7n,7,7b,19,,,,2,,2,,,20,b,1c,l,g,,2t,7,2,6,2,2,,4,z,,u,r,2j,b,1m,9,9,,o,4,,9,,3,,5,17,3,3b,f,,w,1j,,,,4,8,4,,3,7,a,2,t,,1m,,,,2,4,8,,9,,a,2,q,,2,2,1l,,4,2,4,2,2,3,3,,u,2,3,,b,2,1l,,4,5,,2,4,,k,2,m,6,,,1m,,,2,,4,8,,7,3,a,2,u,,1n,,,,c,,9,,14,,3,,1l,3,5,3,,4,7,2,b,2,t,,1m,,2,,2,,3,,5,2,7,2,b,2,s,2,1l,2,,,2,4,8,,9,,a,2,t,,20,,4,,2,3,,,8,,29,,2,7,c,8,2q,,2,9,b,6,22,2,r,,,,,,1j,e,,5,,2,5,b,,10,9,,2u,4,,6,,2,2,2,p,2,4,3,g,4,d,,2,2,6,,f,,jj,3,qa,3,t,3,t,2,u,2,1s,2,,7,8,,2,b,9,,19,3,3b,2,y,,3a,3,4,2,9,,6,3,63,2,2,,1m,,,7,,,,,2,8,6,a,2,,1c,h,1r,4,1c,7,,,5,,14,9,c,2,w,4,2,2,,3,1k,,,2,3,,,3,1m,8,2,2,48,3,,d,,7,4,,6,,3,2,5i,1m,,5,ek,,5f,x,2da,3,3x,,2o,w,fe,6,2x,2,n9w,4,,a,w,2,28,2,7k,,3,,4,,p,2,5,,47,2,q,i,d,,12,8,p,b,1a,3,1c,,2,4,2,2,13,,1v,6,2,2,2,2,c,,8,,1b,,1f,,,3,2,2,5,2,,,16,2,8,,6m,,2,,4,,fn4,,kh,g,g,g,a6,2,gt,,6a,,45,5,1ae,3,,2,5,4,14,3,4,,4l,2,fx,4,ar,2,49,b,4w,,1i,f,1k,3,1d,4,2,2,1x,3,10,5,,8,1q,,c,2,1g,9,a,4,2,,2n,3,2,,,2,6,,4g,,3,8,l,2,1l,2,,,,,m,,e,7,3,5,5f,8,2,3,,,n,,29,,2,6,,,2,,,2,,2,6j,,2,4,6,2,,2,r,2,2d,8,2,,,2,2y,,,,2,6,,,2t,3,2,4,,5,77,9,,2,6t,,a,2,,,4,,40,4,2,2,4,,w,a,14,6,2,4,8,,9,6,2,3,1a,d,,2,ba,7,,6,,,2a,m,2,7,,2,,2,3e,6,3,,,2,,7,,,20,2,3,,,,9n,2,f0b,5,1n,7,t4,,1r,4,29,,f5k,2,43q,,,3,4,5,8,8,2,7,u,4,44,3,1iz,1j,4,1e,8,,e,,m,5,,f,11s,7,,h,2,7,,2,,5,79,7,c5,4,15s,7,31,7,240,5,gx7k,2o,3k,6o".split(",").map((s) => s ? parseInt(s, 36) : 1);
    for (let i2 = 0, n = 0; i2 < numbers.length; i2++)
      (i2 % 2 ? rangeTo : rangeFrom).push(n = n + numbers[i2]);
  })();
  function isExtendingChar(code2) {
    if (code2 < 768)
      return false;
    for (let from2 = 0, to = rangeFrom.length; ; ) {
      let mid = from2 + to >> 1;
      if (code2 < rangeFrom[mid])
        to = mid;
      else if (code2 >= rangeTo[mid])
        from2 = mid + 1;
      else
        return true;
      if (from2 == to)
        return false;
    }
  }
  function isRegionalIndicator(code2) {
    return code2 >= 127462 && code2 <= 127487;
  }
  const ZWJ = 8205;
  function findClusterBreak$1(str, pos, forward = true, includeExtending = true) {
    return (forward ? nextClusterBreak : prevClusterBreak)(str, pos, includeExtending);
  }
  function nextClusterBreak(str, pos, includeExtending) {
    if (pos == str.length)
      return pos;
    if (pos && surrogateLow$1(str.charCodeAt(pos)) && surrogateHigh$1(str.charCodeAt(pos - 1)))
      pos--;
    let prev2 = codePointAt$1(str, pos);
    pos += codePointSize$1(prev2);
    while (pos < str.length) {
      let next2 = codePointAt$1(str, pos);
      if (prev2 == ZWJ || next2 == ZWJ || includeExtending && isExtendingChar(next2)) {
        pos += codePointSize$1(next2);
        prev2 = next2;
      } else if (isRegionalIndicator(next2)) {
        let countBefore = 0, i2 = pos - 2;
        while (i2 >= 0 && isRegionalIndicator(codePointAt$1(str, i2))) {
          countBefore++;
          i2 -= 2;
        }
        if (countBefore % 2 == 0)
          break;
        else
          pos += 2;
      } else {
        break;
      }
    }
    return pos;
  }
  function prevClusterBreak(str, pos, includeExtending) {
    while (pos > 0) {
      let found = nextClusterBreak(str, pos - 2, includeExtending);
      if (found < pos)
        return found;
      pos--;
    }
    return 0;
  }
  function codePointAt$1(str, pos) {
    let code0 = str.charCodeAt(pos);
    if (!surrogateHigh$1(code0) || pos + 1 == str.length)
      return code0;
    let code1 = str.charCodeAt(pos + 1);
    if (!surrogateLow$1(code1))
      return code0;
    return (code0 - 55296 << 10) + (code1 - 56320) + 65536;
  }
  function surrogateLow$1(ch) {
    return ch >= 56320 && ch < 57344;
  }
  function surrogateHigh$1(ch) {
    return ch >= 55296 && ch < 56320;
  }
  function codePointSize$1(code2) {
    return code2 < 65536 ? 1 : 2;
  }
  class Text {
    /**
    Get the line description around the given position.
    */
    lineAt(pos) {
      if (pos < 0 || pos > this.length)
        throw new RangeError(`Invalid position ${pos} in document of length ${this.length}`);
      return this.lineInner(pos, false, 1, 0);
    }
    /**
    Get the description for the given (1-based) line number.
    */
    line(n) {
      if (n < 1 || n > this.lines)
        throw new RangeError(`Invalid line number ${n} in ${this.lines}-line document`);
      return this.lineInner(n, true, 1, 0);
    }
    /**
    Replace a range of the text with the given content.
    */
    replace(from2, to, text) {
      [from2, to] = clip(this, from2, to);
      let parts = [];
      this.decompose(
        0,
        from2,
        parts,
        2
        /* Open.To */
      );
      if (text.length)
        text.decompose(
          0,
          text.length,
          parts,
          1 | 2
          /* Open.To */
        );
      this.decompose(
        to,
        this.length,
        parts,
        1
        /* Open.From */
      );
      return TextNode.from(parts, this.length - (to - from2) + text.length);
    }
    /**
    Append another document to this one.
    */
    append(other) {
      return this.replace(this.length, this.length, other);
    }
    /**
    Retrieve the text between the given points.
    */
    slice(from2, to = this.length) {
      [from2, to] = clip(this, from2, to);
      let parts = [];
      this.decompose(from2, to, parts, 0);
      return TextNode.from(parts, to - from2);
    }
    /**
    Test whether this text is equal to another instance.
    */
    eq(other) {
      if (other == this)
        return true;
      if (other.length != this.length || other.lines != this.lines)
        return false;
      let start2 = this.scanIdentical(other, 1), end2 = this.length - this.scanIdentical(other, -1);
      let a2 = new RawTextCursor(this), b = new RawTextCursor(other);
      for (let skip = start2, pos = start2; ; ) {
        a2.next(skip);
        b.next(skip);
        skip = 0;
        if (a2.lineBreak != b.lineBreak || a2.done != b.done || a2.value != b.value)
          return false;
        pos += a2.value.length;
        if (a2.done || pos >= end2)
          return true;
      }
    }
    /**
    Iterate over the text. When `dir` is `-1`, iteration happens
    from end to start. This will return lines and the breaks between
    them as separate strings.
    */
    iter(dir = 1) {
      return new RawTextCursor(this, dir);
    }
    /**
    Iterate over a range of the text. When `from` > `to`, the
    iterator will run in reverse.
    */
    iterRange(from2, to = this.length) {
      return new PartialTextCursor(this, from2, to);
    }
    /**
    Return a cursor that iterates over the given range of lines,
    _without_ returning the line breaks between, and yielding empty
    strings for empty lines.
    
    When `from` and `to` are given, they should be 1-based line numbers.
    */
    iterLines(from2, to) {
      let inner;
      if (from2 == null) {
        inner = this.iter();
      } else {
        if (to == null)
          to = this.lines + 1;
        let start2 = this.line(from2).from;
        inner = this.iterRange(start2, Math.max(start2, to == this.lines + 1 ? this.length : to <= 1 ? 0 : this.line(to - 1).to));
      }
      return new LineCursor(inner);
    }
    /**
    Return the document as a string, using newline characters to
    separate lines.
    */
    toString() {
      return this.sliceString(0);
    }
    /**
    Convert the document to an array of lines (which can be
    deserialized again via [`Text.of`](https://codemirror.net/6/docs/ref/#state.Text^of)).
    */
    toJSON() {
      let lines = [];
      this.flatten(lines);
      return lines;
    }
    /**
    @internal
    */
    constructor() {
    }
    /**
    Create a `Text` instance for the given array of lines.
    */
    static of(text) {
      if (text.length == 0)
        throw new RangeError("A document must have at least one line");
      if (text.length == 1 && !text[0])
        return Text.empty;
      return text.length <= 32 ? new TextLeaf(text) : TextNode.from(TextLeaf.split(text, []));
    }
  }
  class TextLeaf extends Text {
    constructor(text, length2 = textLength(text)) {
      super();
      this.text = text;
      this.length = length2;
    }
    get lines() {
      return this.text.length;
    }
    get children() {
      return null;
    }
    lineInner(target, isLine, line2, offset2) {
      for (let i2 = 0; ; i2++) {
        let string2 = this.text[i2], end2 = offset2 + string2.length;
        if ((isLine ? line2 : end2) >= target)
          return new Line(offset2, end2, line2, string2);
        offset2 = end2 + 1;
        line2++;
      }
    }
    decompose(from2, to, target, open) {
      let text = from2 <= 0 && to >= this.length ? this : new TextLeaf(sliceText(this.text, from2, to), Math.min(to, this.length) - Math.max(0, from2));
      if (open & 1) {
        let prev2 = target.pop();
        let joined = appendText(text.text, prev2.text.slice(), 0, text.length);
        if (joined.length <= 32) {
          target.push(new TextLeaf(joined, prev2.length + text.length));
        } else {
          let mid = joined.length >> 1;
          target.push(new TextLeaf(joined.slice(0, mid)), new TextLeaf(joined.slice(mid)));
        }
      } else {
        target.push(text);
      }
    }
    replace(from2, to, text) {
      if (!(text instanceof TextLeaf))
        return super.replace(from2, to, text);
      [from2, to] = clip(this, from2, to);
      let lines = appendText(this.text, appendText(text.text, sliceText(this.text, 0, from2)), to);
      let newLen = this.length + text.length - (to - from2);
      if (lines.length <= 32)
        return new TextLeaf(lines, newLen);
      return TextNode.from(TextLeaf.split(lines, []), newLen);
    }
    sliceString(from2, to = this.length, lineSep = "\n") {
      [from2, to] = clip(this, from2, to);
      let result = "";
      for (let pos = 0, i2 = 0; pos <= to && i2 < this.text.length; i2++) {
        let line2 = this.text[i2], end2 = pos + line2.length;
        if (pos > from2 && i2)
          result += lineSep;
        if (from2 < end2 && to > pos)
          result += line2.slice(Math.max(0, from2 - pos), to - pos);
        pos = end2 + 1;
      }
      return result;
    }
    flatten(target) {
      for (let line2 of this.text)
        target.push(line2);
    }
    scanIdentical() {
      return 0;
    }
    static split(text, target) {
      let part = [], len = -1;
      for (let line2 of text) {
        part.push(line2);
        len += line2.length + 1;
        if (part.length == 32) {
          target.push(new TextLeaf(part, len));
          part = [];
          len = -1;
        }
      }
      if (len > -1)
        target.push(new TextLeaf(part, len));
      return target;
    }
  }
  class TextNode extends Text {
    constructor(children, length2) {
      super();
      this.children = children;
      this.length = length2;
      this.lines = 0;
      for (let child of children)
        this.lines += child.lines;
    }
    lineInner(target, isLine, line2, offset2) {
      for (let i2 = 0; ; i2++) {
        let child = this.children[i2], end2 = offset2 + child.length, endLine = line2 + child.lines - 1;
        if ((isLine ? endLine : end2) >= target)
          return child.lineInner(target, isLine, line2, offset2);
        offset2 = end2 + 1;
        line2 = endLine + 1;
      }
    }
    decompose(from2, to, target, open) {
      for (let i2 = 0, pos = 0; pos <= to && i2 < this.children.length; i2++) {
        let child = this.children[i2], end2 = pos + child.length;
        if (from2 <= end2 && to >= pos) {
          let childOpen = open & ((pos <= from2 ? 1 : 0) | (end2 >= to ? 2 : 0));
          if (pos >= from2 && end2 <= to && !childOpen)
            target.push(child);
          else
            child.decompose(from2 - pos, to - pos, target, childOpen);
        }
        pos = end2 + 1;
      }
    }
    replace(from2, to, text) {
      [from2, to] = clip(this, from2, to);
      if (text.lines < this.lines)
        for (let i2 = 0, pos = 0; i2 < this.children.length; i2++) {
          let child = this.children[i2], end2 = pos + child.length;
          if (from2 >= pos && to <= end2) {
            let updated = child.replace(from2 - pos, to - pos, text);
            let totalLines = this.lines - child.lines + updated.lines;
            if (updated.lines < totalLines >> 5 - 1 && updated.lines > totalLines >> 5 + 1) {
              let copy2 = this.children.slice();
              copy2[i2] = updated;
              return new TextNode(copy2, this.length - (to - from2) + text.length);
            }
            return super.replace(pos, end2, updated);
          }
          pos = end2 + 1;
        }
      return super.replace(from2, to, text);
    }
    sliceString(from2, to = this.length, lineSep = "\n") {
      [from2, to] = clip(this, from2, to);
      let result = "";
      for (let i2 = 0, pos = 0; i2 < this.children.length && pos <= to; i2++) {
        let child = this.children[i2], end2 = pos + child.length;
        if (pos > from2 && i2)
          result += lineSep;
        if (from2 < end2 && to > pos)
          result += child.sliceString(from2 - pos, to - pos, lineSep);
        pos = end2 + 1;
      }
      return result;
    }
    flatten(target) {
      for (let child of this.children)
        child.flatten(target);
    }
    scanIdentical(other, dir) {
      if (!(other instanceof TextNode))
        return 0;
      let length2 = 0;
      let [iA, iB, eA, eB] = dir > 0 ? [0, 0, this.children.length, other.children.length] : [this.children.length - 1, other.children.length - 1, -1, -1];
      for (; ; iA += dir, iB += dir) {
        if (iA == eA || iB == eB)
          return length2;
        let chA = this.children[iA], chB = other.children[iB];
        if (chA != chB)
          return length2 + chA.scanIdentical(chB, dir);
        length2 += chA.length + 1;
      }
    }
    static from(children, length2 = children.reduce((l, ch) => l + ch.length + 1, -1)) {
      let lines = 0;
      for (let ch of children)
        lines += ch.lines;
      if (lines < 32) {
        let flat = [];
        for (let ch of children)
          ch.flatten(flat);
        return new TextLeaf(flat, length2);
      }
      let chunk = Math.max(
        32,
        lines >> 5
        /* Tree.BranchShift */
      ), maxChunk = chunk << 1, minChunk = chunk >> 1;
      let chunked = [], currentLines = 0, currentLen = -1, currentChunk = [];
      function add(child) {
        let last;
        if (child.lines > maxChunk && child instanceof TextNode) {
          for (let node2 of child.children)
            add(node2);
        } else if (child.lines > minChunk && (currentLines > minChunk || !currentLines)) {
          flush();
          chunked.push(child);
        } else if (child instanceof TextLeaf && currentLines && (last = currentChunk[currentChunk.length - 1]) instanceof TextLeaf && child.lines + last.lines <= 32) {
          currentLines += child.lines;
          currentLen += child.length + 1;
          currentChunk[currentChunk.length - 1] = new TextLeaf(last.text.concat(child.text), last.length + 1 + child.length);
        } else {
          if (currentLines + child.lines > chunk)
            flush();
          currentLines += child.lines;
          currentLen += child.length + 1;
          currentChunk.push(child);
        }
      }
      function flush() {
        if (currentLines == 0)
          return;
        chunked.push(currentChunk.length == 1 ? currentChunk[0] : TextNode.from(currentChunk, currentLen));
        currentLen = -1;
        currentLines = currentChunk.length = 0;
      }
      for (let child of children)
        add(child);
      flush();
      return chunked.length == 1 ? chunked[0] : new TextNode(chunked, length2);
    }
  }
  Text.empty = /* @__PURE__ */ new TextLeaf([""], 0);
  function textLength(text) {
    let length2 = -1;
    for (let line2 of text)
      length2 += line2.length + 1;
    return length2;
  }
  function appendText(text, target, from2 = 0, to = 1e9) {
    for (let pos = 0, i2 = 0, first = true; i2 < text.length && pos <= to; i2++) {
      let line2 = text[i2], end2 = pos + line2.length;
      if (end2 >= from2) {
        if (end2 > to)
          line2 = line2.slice(0, to - pos);
        if (pos < from2)
          line2 = line2.slice(from2 - pos);
        if (first) {
          target[target.length - 1] += line2;
          first = false;
        } else
          target.push(line2);
      }
      pos = end2 + 1;
    }
    return target;
  }
  function sliceText(text, from2, to) {
    return appendText(text, [""], from2, to);
  }
  class RawTextCursor {
    constructor(text, dir = 1) {
      this.dir = dir;
      this.done = false;
      this.lineBreak = false;
      this.value = "";
      this.nodes = [text];
      this.offsets = [dir > 0 ? 1 : (text instanceof TextLeaf ? text.text.length : text.children.length) << 1];
    }
    nextInner(skip, dir) {
      this.done = this.lineBreak = false;
      for (; ; ) {
        let last = this.nodes.length - 1;
        let top2 = this.nodes[last], offsetValue = this.offsets[last], offset2 = offsetValue >> 1;
        let size = top2 instanceof TextLeaf ? top2.text.length : top2.children.length;
        if (offset2 == (dir > 0 ? size : 0)) {
          if (last == 0) {
            this.done = true;
            this.value = "";
            return this;
          }
          if (dir > 0)
            this.offsets[last - 1]++;
          this.nodes.pop();
          this.offsets.pop();
        } else if ((offsetValue & 1) == (dir > 0 ? 0 : 1)) {
          this.offsets[last] += dir;
          if (skip == 0) {
            this.lineBreak = true;
            this.value = "\n";
            return this;
          }
          skip--;
        } else if (top2 instanceof TextLeaf) {
          let next2 = top2.text[offset2 + (dir < 0 ? -1 : 0)];
          this.offsets[last] += dir;
          if (next2.length > Math.max(0, skip)) {
            this.value = skip == 0 ? next2 : dir > 0 ? next2.slice(skip) : next2.slice(0, next2.length - skip);
            return this;
          }
          skip -= next2.length;
        } else {
          let next2 = top2.children[offset2 + (dir < 0 ? -1 : 0)];
          if (skip > next2.length) {
            skip -= next2.length;
            this.offsets[last] += dir;
          } else {
            if (dir < 0)
              this.offsets[last]--;
            this.nodes.push(next2);
            this.offsets.push(dir > 0 ? 1 : (next2 instanceof TextLeaf ? next2.text.length : next2.children.length) << 1);
          }
        }
      }
    }
    next(skip = 0) {
      if (skip < 0) {
        this.nextInner(-skip, -this.dir);
        skip = this.value.length;
      }
      return this.nextInner(skip, this.dir);
    }
  }
  class PartialTextCursor {
    constructor(text, start2, end2) {
      this.value = "";
      this.done = false;
      this.cursor = new RawTextCursor(text, start2 > end2 ? -1 : 1);
      this.pos = start2 > end2 ? text.length : 0;
      this.from = Math.min(start2, end2);
      this.to = Math.max(start2, end2);
    }
    nextInner(skip, dir) {
      if (dir < 0 ? this.pos <= this.from : this.pos >= this.to) {
        this.value = "";
        this.done = true;
        return this;
      }
      skip += Math.max(0, dir < 0 ? this.pos - this.to : this.from - this.pos);
      let limit = dir < 0 ? this.pos - this.from : this.to - this.pos;
      if (skip > limit)
        skip = limit;
      limit -= skip;
      let { value } = this.cursor.next(skip);
      this.pos += (value.length + skip) * dir;
      this.value = value.length <= limit ? value : dir < 0 ? value.slice(value.length - limit) : value.slice(0, limit);
      this.done = !this.value;
      return this;
    }
    next(skip = 0) {
      if (skip < 0)
        skip = Math.max(skip, this.from - this.pos);
      else if (skip > 0)
        skip = Math.min(skip, this.to - this.pos);
      return this.nextInner(skip, this.cursor.dir);
    }
    get lineBreak() {
      return this.cursor.lineBreak && this.value != "";
    }
  }
  class LineCursor {
    constructor(inner) {
      this.inner = inner;
      this.afterBreak = true;
      this.value = "";
      this.done = false;
    }
    next(skip = 0) {
      let { done, lineBreak, value } = this.inner.next(skip);
      if (done && this.afterBreak) {
        this.value = "";
        this.afterBreak = false;
      } else if (done) {
        this.done = true;
        this.value = "";
      } else if (lineBreak) {
        if (this.afterBreak) {
          this.value = "";
        } else {
          this.afterBreak = true;
          this.next();
        }
      } else {
        this.value = value;
        this.afterBreak = false;
      }
      return this;
    }
    get lineBreak() {
      return false;
    }
  }
  if (typeof Symbol != "undefined") {
    Text.prototype[Symbol.iterator] = function() {
      return this.iter();
    };
    RawTextCursor.prototype[Symbol.iterator] = PartialTextCursor.prototype[Symbol.iterator] = LineCursor.prototype[Symbol.iterator] = function() {
      return this;
    };
  }
  class Line {
    /**
    @internal
    */
    constructor(from2, to, number2, text) {
      this.from = from2;
      this.to = to;
      this.number = number2;
      this.text = text;
    }
    /**
    The length of the line (not including any line break after it).
    */
    get length() {
      return this.to - this.from;
    }
  }
  function clip(text, from2, to) {
    from2 = Math.max(0, Math.min(text.length, from2));
    return [from2, Math.max(from2, Math.min(text.length, to))];
  }
  function findClusterBreak(str, pos, forward = true, includeExtending = true) {
    return findClusterBreak$1(str, pos, forward, includeExtending);
  }
  function surrogateLow(ch) {
    return ch >= 56320 && ch < 57344;
  }
  function surrogateHigh(ch) {
    return ch >= 55296 && ch < 56320;
  }
  function codePointAt(str, pos) {
    let code0 = str.charCodeAt(pos);
    if (!surrogateHigh(code0) || pos + 1 == str.length)
      return code0;
    let code1 = str.charCodeAt(pos + 1);
    if (!surrogateLow(code1))
      return code0;
    return (code0 - 55296 << 10) + (code1 - 56320) + 65536;
  }
  function fromCodePoint(code2) {
    if (code2 <= 65535)
      return String.fromCharCode(code2);
    code2 -= 65536;
    return String.fromCharCode((code2 >> 10) + 55296, (code2 & 1023) + 56320);
  }
  function codePointSize(code2) {
    return code2 < 65536 ? 1 : 2;
  }
  const DefaultSplit = /\r\n?|\n/;
  var MapMode = /* @__PURE__ */ function(MapMode2) {
    MapMode2[MapMode2["Simple"] = 0] = "Simple";
    MapMode2[MapMode2["TrackDel"] = 1] = "TrackDel";
    MapMode2[MapMode2["TrackBefore"] = 2] = "TrackBefore";
    MapMode2[MapMode2["TrackAfter"] = 3] = "TrackAfter";
    return MapMode2;
  }(MapMode || (MapMode = {}));
  class ChangeDesc {
    // Sections are encoded as pairs of integers. The first is the
    // length in the current document, and the second is -1 for
    // unaffected sections, and the length of the replacement content
    // otherwise. So an insertion would be (0, n>0), a deletion (n>0,
    // 0), and a replacement two positive numbers.
    /**
    @internal
    */
    constructor(sections) {
      this.sections = sections;
    }
    /**
    The length of the document before the change.
    */
    get length() {
      let result = 0;
      for (let i2 = 0; i2 < this.sections.length; i2 += 2)
        result += this.sections[i2];
      return result;
    }
    /**
    The length of the document after the change.
    */
    get newLength() {
      let result = 0;
      for (let i2 = 0; i2 < this.sections.length; i2 += 2) {
        let ins = this.sections[i2 + 1];
        result += ins < 0 ? this.sections[i2] : ins;
      }
      return result;
    }
    /**
    False when there are actual changes in this set.
    */
    get empty() {
      return this.sections.length == 0 || this.sections.length == 2 && this.sections[1] < 0;
    }
    /**
    Iterate over the unchanged parts left by these changes. `posA`
    provides the position of the range in the old document, `posB`
    the new position in the changed document.
    */
    iterGaps(f) {
      for (let i2 = 0, posA = 0, posB = 0; i2 < this.sections.length; ) {
        let len = this.sections[i2++], ins = this.sections[i2++];
        if (ins < 0) {
          f(posA, posB, len);
          posB += len;
        } else {
          posB += ins;
        }
        posA += len;
      }
    }
    /**
    Iterate over the ranges changed by these changes. (See
    [`ChangeSet.iterChanges`](https://codemirror.net/6/docs/ref/#state.ChangeSet.iterChanges) for a
    variant that also provides you with the inserted text.)
    `fromA`/`toA` provides the extent of the change in the starting
    document, `fromB`/`toB` the extent of the replacement in the
    changed document.
    
    When `individual` is true, adjacent changes (which are kept
    separate for [position mapping](https://codemirror.net/6/docs/ref/#state.ChangeDesc.mapPos)) are
    reported separately.
    */
    iterChangedRanges(f, individual = false) {
      iterChanges(this, f, individual);
    }
    /**
    Get a description of the inverted form of these changes.
    */
    get invertedDesc() {
      let sections = [];
      for (let i2 = 0; i2 < this.sections.length; ) {
        let len = this.sections[i2++], ins = this.sections[i2++];
        if (ins < 0)
          sections.push(len, ins);
        else
          sections.push(ins, len);
      }
      return new ChangeDesc(sections);
    }
    /**
    Compute the combined effect of applying another set of changes
    after this one. The length of the document after this set should
    match the length before `other`.
    */
    composeDesc(other) {
      return this.empty ? other : other.empty ? this : composeSets(this, other);
    }
    /**
    Map this description, which should start with the same document
    as `other`, over another set of changes, so that it can be
    applied after it. When `before` is true, map as if the changes
    in `this` happened before the ones in `other`.
    */
    mapDesc(other, before = false) {
      return other.empty ? this : mapSet(this, other, before);
    }
    mapPos(pos, assoc = -1, mode = MapMode.Simple) {
      let posA = 0, posB = 0;
      for (let i2 = 0; i2 < this.sections.length; ) {
        let len = this.sections[i2++], ins = this.sections[i2++], endA = posA + len;
        if (ins < 0) {
          if (endA > pos)
            return posB + (pos - posA);
          posB += len;
        } else {
          if (mode != MapMode.Simple && endA >= pos && (mode == MapMode.TrackDel && posA < pos && endA > pos || mode == MapMode.TrackBefore && posA < pos || mode == MapMode.TrackAfter && endA > pos))
            return null;
          if (endA > pos || endA == pos && assoc < 0 && !len)
            return pos == posA || assoc < 0 ? posB : posB + ins;
          posB += ins;
        }
        posA = endA;
      }
      if (pos > posA)
        throw new RangeError(`Position ${pos} is out of range for changeset of length ${posA}`);
      return posB;
    }
    /**
    Check whether these changes touch a given range. When one of the
    changes entirely covers the range, the string `"cover"` is
    returned.
    */
    touchesRange(from2, to = from2) {
      for (let i2 = 0, pos = 0; i2 < this.sections.length && pos <= to; ) {
        let len = this.sections[i2++], ins = this.sections[i2++], end2 = pos + len;
        if (ins >= 0 && pos <= to && end2 >= from2)
          return pos < from2 && end2 > to ? "cover" : true;
        pos = end2;
      }
      return false;
    }
    /**
    @internal
    */
    toString() {
      let result = "";
      for (let i2 = 0; i2 < this.sections.length; ) {
        let len = this.sections[i2++], ins = this.sections[i2++];
        result += (result ? " " : "") + len + (ins >= 0 ? ":" + ins : "");
      }
      return result;
    }
    /**
    Serialize this change desc to a JSON-representable value.
    */
    toJSON() {
      return this.sections;
    }
    /**
    Create a change desc from its JSON representation (as produced
    by [`toJSON`](https://codemirror.net/6/docs/ref/#state.ChangeDesc.toJSON).
    */
    static fromJSON(json) {
      if (!Array.isArray(json) || json.length % 2 || json.some((a2) => typeof a2 != "number"))
        throw new RangeError("Invalid JSON representation of ChangeDesc");
      return new ChangeDesc(json);
    }
    /**
    @internal
    */
    static create(sections) {
      return new ChangeDesc(sections);
    }
  }
  class ChangeSet extends ChangeDesc {
    constructor(sections, inserted) {
      super(sections);
      this.inserted = inserted;
    }
    /**
    Apply the changes to a document, returning the modified
    document.
    */
    apply(doc2) {
      if (this.length != doc2.length)
        throw new RangeError("Applying change set to a document with the wrong length");
      iterChanges(this, (fromA, toA, fromB, _toB, text) => doc2 = doc2.replace(fromB, fromB + (toA - fromA), text), false);
      return doc2;
    }
    mapDesc(other, before = false) {
      return mapSet(this, other, before, true);
    }
    /**
    Given the document as it existed _before_ the changes, return a
    change set that represents the inverse of this set, which could
    be used to go from the document created by the changes back to
    the document as it existed before the changes.
    */
    invert(doc2) {
      let sections = this.sections.slice(), inserted = [];
      for (let i2 = 0, pos = 0; i2 < sections.length; i2 += 2) {
        let len = sections[i2], ins = sections[i2 + 1];
        if (ins >= 0) {
          sections[i2] = ins;
          sections[i2 + 1] = len;
          let index = i2 >> 1;
          while (inserted.length < index)
            inserted.push(Text.empty);
          inserted.push(len ? doc2.slice(pos, pos + len) : Text.empty);
        }
        pos += len;
      }
      return new ChangeSet(sections, inserted);
    }
    /**
    Combine two subsequent change sets into a single set. `other`
    must start in the document produced by `this`. If `this` goes
    `docA` → `docB` and `other` represents `docB` → `docC`, the
    returned value will represent the change `docA` → `docC`.
    */
    compose(other) {
      return this.empty ? other : other.empty ? this : composeSets(this, other, true);
    }
    /**
    Given another change set starting in the same document, maps this
    change set over the other, producing a new change set that can be
    applied to the document produced by applying `other`. When
    `before` is `true`, order changes as if `this` comes before
    `other`, otherwise (the default) treat `other` as coming first.
    
    Given two changes `A` and `B`, `A.compose(B.map(A))` and
    `B.compose(A.map(B, true))` will produce the same document. This
    provides a basic form of [operational
    transformation](https://en.wikipedia.org/wiki/Operational_transformation),
    and can be used for collaborative editing.
    */
    map(other, before = false) {
      return other.empty ? this : mapSet(this, other, before, true);
    }
    /**
    Iterate over the changed ranges in the document, calling `f` for
    each, with the range in the original document (`fromA`-`toA`)
    and the range that replaces it in the new document
    (`fromB`-`toB`).
    
    When `individual` is true, adjacent changes are reported
    separately.
    */
    iterChanges(f, individual = false) {
      iterChanges(this, f, individual);
    }
    /**
    Get a [change description](https://codemirror.net/6/docs/ref/#state.ChangeDesc) for this change
    set.
    */
    get desc() {
      return ChangeDesc.create(this.sections);
    }
    /**
    @internal
    */
    filter(ranges) {
      let resultSections = [], resultInserted = [], filteredSections = [];
      let iter = new SectionIter(this);
      done:
        for (let i2 = 0, pos = 0; ; ) {
          let next2 = i2 == ranges.length ? 1e9 : ranges[i2++];
          while (pos < next2 || pos == next2 && iter.len == 0) {
            if (iter.done)
              break done;
            let len = Math.min(iter.len, next2 - pos);
            addSection(filteredSections, len, -1);
            let ins = iter.ins == -1 ? -1 : iter.off == 0 ? iter.ins : 0;
            addSection(resultSections, len, ins);
            if (ins > 0)
              addInsert(resultInserted, resultSections, iter.text);
            iter.forward(len);
            pos += len;
          }
          let end2 = ranges[i2++];
          while (pos < end2) {
            if (iter.done)
              break done;
            let len = Math.min(iter.len, end2 - pos);
            addSection(resultSections, len, -1);
            addSection(filteredSections, len, iter.ins == -1 ? -1 : iter.off == 0 ? iter.ins : 0);
            iter.forward(len);
            pos += len;
          }
        }
      return {
        changes: new ChangeSet(resultSections, resultInserted),
        filtered: ChangeDesc.create(filteredSections)
      };
    }
    /**
    Serialize this change set to a JSON-representable value.
    */
    toJSON() {
      let parts = [];
      for (let i2 = 0; i2 < this.sections.length; i2 += 2) {
        let len = this.sections[i2], ins = this.sections[i2 + 1];
        if (ins < 0)
          parts.push(len);
        else if (ins == 0)
          parts.push([len]);
        else
          parts.push([len].concat(this.inserted[i2 >> 1].toJSON()));
      }
      return parts;
    }
    /**
    Create a change set for the given changes, for a document of the
    given length, using `lineSep` as line separator.
    */
    static of(changes, length2, lineSep) {
      let sections = [], inserted = [], pos = 0;
      let total = null;
      function flush(force = false) {
        if (!force && !sections.length)
          return;
        if (pos < length2)
          addSection(sections, length2 - pos, -1);
        let set = new ChangeSet(sections, inserted);
        total = total ? total.compose(set.map(total)) : set;
        sections = [];
        inserted = [];
        pos = 0;
      }
      function process2(spec) {
        if (Array.isArray(spec)) {
          for (let sub of spec)
            process2(sub);
        } else if (spec instanceof ChangeSet) {
          if (spec.length != length2)
            throw new RangeError(`Mismatched change set length (got ${spec.length}, expected ${length2})`);
          flush();
          total = total ? total.compose(spec.map(total)) : spec;
        } else {
          let { from: from2, to = from2, insert: insert2 } = spec;
          if (from2 > to || from2 < 0 || to > length2)
            throw new RangeError(`Invalid change range ${from2} to ${to} (in doc of length ${length2})`);
          let insText = !insert2 ? Text.empty : typeof insert2 == "string" ? Text.of(insert2.split(lineSep || DefaultSplit)) : insert2;
          let insLen = insText.length;
          if (from2 == to && insLen == 0)
            return;
          if (from2 < pos)
            flush();
          if (from2 > pos)
            addSection(sections, from2 - pos, -1);
          addSection(sections, to - from2, insLen);
          addInsert(inserted, sections, insText);
          pos = to;
        }
      }
      process2(changes);
      flush(!total);
      return total;
    }
    /**
    Create an empty changeset of the given length.
    */
    static empty(length2) {
      return new ChangeSet(length2 ? [length2, -1] : [], []);
    }
    /**
    Create a changeset from its JSON representation (as produced by
    [`toJSON`](https://codemirror.net/6/docs/ref/#state.ChangeSet.toJSON).
    */
    static fromJSON(json) {
      if (!Array.isArray(json))
        throw new RangeError("Invalid JSON representation of ChangeSet");
      let sections = [], inserted = [];
      for (let i2 = 0; i2 < json.length; i2++) {
        let part = json[i2];
        if (typeof part == "number") {
          sections.push(part, -1);
        } else if (!Array.isArray(part) || typeof part[0] != "number" || part.some((e, i3) => i3 && typeof e != "string")) {
          throw new RangeError("Invalid JSON representation of ChangeSet");
        } else if (part.length == 1) {
          sections.push(part[0], 0);
        } else {
          while (inserted.length < i2)
            inserted.push(Text.empty);
          inserted[i2] = Text.of(part.slice(1));
          sections.push(part[0], inserted[i2].length);
        }
      }
      return new ChangeSet(sections, inserted);
    }
    /**
    @internal
    */
    static createSet(sections, inserted) {
      return new ChangeSet(sections, inserted);
    }
  }
  function addSection(sections, len, ins, forceJoin = false) {
    if (len == 0 && ins <= 0)
      return;
    let last = sections.length - 2;
    if (last >= 0 && ins <= 0 && ins == sections[last + 1])
      sections[last] += len;
    else if (last >= 0 && len == 0 && sections[last] == 0)
      sections[last + 1] += ins;
    else if (forceJoin) {
      sections[last] += len;
      sections[last + 1] += ins;
    } else
      sections.push(len, ins);
  }
  function addInsert(values2, sections, value) {
    if (value.length == 0)
      return;
    let index = sections.length - 2 >> 1;
    if (index < values2.length) {
      values2[values2.length - 1] = values2[values2.length - 1].append(value);
    } else {
      while (values2.length < index)
        values2.push(Text.empty);
      values2.push(value);
    }
  }
  function iterChanges(desc, f, individual) {
    let inserted = desc.inserted;
    for (let posA = 0, posB = 0, i2 = 0; i2 < desc.sections.length; ) {
      let len = desc.sections[i2++], ins = desc.sections[i2++];
      if (ins < 0) {
        posA += len;
        posB += len;
      } else {
        let endA = posA, endB = posB, text = Text.empty;
        for (; ; ) {
          endA += len;
          endB += ins;
          if (ins && inserted)
            text = text.append(inserted[i2 - 2 >> 1]);
          if (individual || i2 == desc.sections.length || desc.sections[i2 + 1] < 0)
            break;
          len = desc.sections[i2++];
          ins = desc.sections[i2++];
        }
        f(posA, endA, posB, endB, text);
        posA = endA;
        posB = endB;
      }
    }
  }
  function mapSet(setA, setB, before, mkSet = false) {
    let sections = [], insert2 = mkSet ? [] : null;
    let a2 = new SectionIter(setA), b = new SectionIter(setB);
    for (let inserted = -1; ; ) {
      if (a2.done && b.len || b.done && a2.len) {
        throw new Error("Mismatched change set lengths");
      } else if (a2.ins == -1 && b.ins == -1) {
        let len = Math.min(a2.len, b.len);
        addSection(sections, len, -1);
        a2.forward(len);
        b.forward(len);
      } else if (b.ins >= 0 && (a2.ins < 0 || inserted == a2.i || a2.off == 0 && (b.len < a2.len || b.len == a2.len && !before))) {
        let len = b.len;
        addSection(sections, b.ins, -1);
        while (len) {
          let piece = Math.min(a2.len, len);
          if (a2.ins >= 0 && inserted < a2.i && a2.len <= piece) {
            addSection(sections, 0, a2.ins);
            if (insert2)
              addInsert(insert2, sections, a2.text);
            inserted = a2.i;
          }
          a2.forward(piece);
          len -= piece;
        }
        b.next();
      } else if (a2.ins >= 0) {
        let len = 0, left2 = a2.len;
        while (left2) {
          if (b.ins == -1) {
            let piece = Math.min(left2, b.len);
            len += piece;
            left2 -= piece;
            b.forward(piece);
          } else if (b.ins == 0 && b.len < left2) {
            left2 -= b.len;
            b.next();
          } else {
            break;
          }
        }
        addSection(sections, len, inserted < a2.i ? a2.ins : 0);
        if (insert2 && inserted < a2.i)
          addInsert(insert2, sections, a2.text);
        inserted = a2.i;
        a2.forward(a2.len - left2);
      } else if (a2.done && b.done) {
        return insert2 ? ChangeSet.createSet(sections, insert2) : ChangeDesc.create(sections);
      } else {
        throw new Error("Mismatched change set lengths");
      }
    }
  }
  function composeSets(setA, setB, mkSet = false) {
    let sections = [];
    let insert2 = mkSet ? [] : null;
    let a2 = new SectionIter(setA), b = new SectionIter(setB);
    for (let open = false; ; ) {
      if (a2.done && b.done) {
        return insert2 ? ChangeSet.createSet(sections, insert2) : ChangeDesc.create(sections);
      } else if (a2.ins == 0) {
        addSection(sections, a2.len, 0, open);
        a2.next();
      } else if (b.len == 0 && !b.done) {
        addSection(sections, 0, b.ins, open);
        if (insert2)
          addInsert(insert2, sections, b.text);
        b.next();
      } else if (a2.done || b.done) {
        throw new Error("Mismatched change set lengths");
      } else {
        let len = Math.min(a2.len2, b.len), sectionLen = sections.length;
        if (a2.ins == -1) {
          let insB = b.ins == -1 ? -1 : b.off ? 0 : b.ins;
          addSection(sections, len, insB, open);
          if (insert2 && insB)
            addInsert(insert2, sections, b.text);
        } else if (b.ins == -1) {
          addSection(sections, a2.off ? 0 : a2.len, len, open);
          if (insert2)
            addInsert(insert2, sections, a2.textBit(len));
        } else {
          addSection(sections, a2.off ? 0 : a2.len, b.off ? 0 : b.ins, open);
          if (insert2 && !b.off)
            addInsert(insert2, sections, b.text);
        }
        open = (a2.ins > len || b.ins >= 0 && b.len > len) && (open || sections.length > sectionLen);
        a2.forward2(len);
        b.forward(len);
      }
    }
  }
  class SectionIter {
    constructor(set) {
      this.set = set;
      this.i = 0;
      this.next();
    }
    next() {
      let { sections } = this.set;
      if (this.i < sections.length) {
        this.len = sections[this.i++];
        this.ins = sections[this.i++];
      } else {
        this.len = 0;
        this.ins = -2;
      }
      this.off = 0;
    }
    get done() {
      return this.ins == -2;
    }
    get len2() {
      return this.ins < 0 ? this.len : this.ins;
    }
    get text() {
      let { inserted } = this.set, index = this.i - 2 >> 1;
      return index >= inserted.length ? Text.empty : inserted[index];
    }
    textBit(len) {
      let { inserted } = this.set, index = this.i - 2 >> 1;
      return index >= inserted.length && !len ? Text.empty : inserted[index].slice(this.off, len == null ? void 0 : this.off + len);
    }
    forward(len) {
      if (len == this.len)
        this.next();
      else {
        this.len -= len;
        this.off += len;
      }
    }
    forward2(len) {
      if (this.ins == -1)
        this.forward(len);
      else if (len == this.ins)
        this.next();
      else {
        this.ins -= len;
        this.off += len;
      }
    }
  }
  class SelectionRange {
    constructor(from2, to, flags) {
      this.from = from2;
      this.to = to;
      this.flags = flags;
    }
    /**
    The anchor of the range—the side that doesn't move when you
    extend it.
    */
    get anchor() {
      return this.flags & 32 ? this.to : this.from;
    }
    /**
    The head of the range, which is moved when the range is
    [extended](https://codemirror.net/6/docs/ref/#state.SelectionRange.extend).
    */
    get head() {
      return this.flags & 32 ? this.from : this.to;
    }
    /**
    True when `anchor` and `head` are at the same position.
    */
    get empty() {
      return this.from == this.to;
    }
    /**
    If this is a cursor that is explicitly associated with the
    character on one of its sides, this returns the side. -1 means
    the character before its position, 1 the character after, and 0
    means no association.
    */
    get assoc() {
      return this.flags & 8 ? -1 : this.flags & 16 ? 1 : 0;
    }
    /**
    The bidirectional text level associated with this cursor, if
    any.
    */
    get bidiLevel() {
      let level = this.flags & 7;
      return level == 7 ? null : level;
    }
    /**
    The goal column (stored vertical offset) associated with a
    cursor. This is used to preserve the vertical position when
    [moving](https://codemirror.net/6/docs/ref/#view.EditorView.moveVertically) across
    lines of different length.
    */
    get goalColumn() {
      let value = this.flags >> 6;
      return value == 16777215 ? void 0 : value;
    }
    /**
    Map this range through a change, producing a valid range in the
    updated document.
    */
    map(change, assoc = -1) {
      let from2, to;
      if (this.empty) {
        from2 = to = change.mapPos(this.from, assoc);
      } else {
        from2 = change.mapPos(this.from, 1);
        to = change.mapPos(this.to, -1);
      }
      return from2 == this.from && to == this.to ? this : new SelectionRange(from2, to, this.flags);
    }
    /**
    Extend this range to cover at least `from` to `to`.
    */
    extend(from2, to = from2) {
      if (from2 <= this.anchor && to >= this.anchor)
        return EditorSelection.range(from2, to);
      let head = Math.abs(from2 - this.anchor) > Math.abs(to - this.anchor) ? from2 : to;
      return EditorSelection.range(this.anchor, head);
    }
    /**
    Compare this range to another range.
    */
    eq(other, includeAssoc = false) {
      return this.anchor == other.anchor && this.head == other.head && (!includeAssoc || !this.empty || this.assoc == other.assoc);
    }
    /**
    Return a JSON-serializable object representing the range.
    */
    toJSON() {
      return { anchor: this.anchor, head: this.head };
    }
    /**
    Convert a JSON representation of a range to a `SelectionRange`
    instance.
    */
    static fromJSON(json) {
      if (!json || typeof json.anchor != "number" || typeof json.head != "number")
        throw new RangeError("Invalid JSON representation for SelectionRange");
      return EditorSelection.range(json.anchor, json.head);
    }
    /**
    @internal
    */
    static create(from2, to, flags) {
      return new SelectionRange(from2, to, flags);
    }
  }
  class EditorSelection {
    constructor(ranges, mainIndex) {
      this.ranges = ranges;
      this.mainIndex = mainIndex;
    }
    /**
    Map a selection through a change. Used to adjust the selection
    position for changes.
    */
    map(change, assoc = -1) {
      if (change.empty)
        return this;
      return EditorSelection.create(this.ranges.map((r2) => r2.map(change, assoc)), this.mainIndex);
    }
    /**
    Compare this selection to another selection. By default, ranges
    are compared only by position. When `includeAssoc` is true,
    cursor ranges must also have the same
    [`assoc`](https://codemirror.net/6/docs/ref/#state.SelectionRange.assoc) value.
    */
    eq(other, includeAssoc = false) {
      if (this.ranges.length != other.ranges.length || this.mainIndex != other.mainIndex)
        return false;
      for (let i2 = 0; i2 < this.ranges.length; i2++)
        if (!this.ranges[i2].eq(other.ranges[i2], includeAssoc))
          return false;
      return true;
    }
    /**
    Get the primary selection range. Usually, you should make sure
    your code applies to _all_ ranges, by using methods like
    [`changeByRange`](https://codemirror.net/6/docs/ref/#state.EditorState.changeByRange).
    */
    get main() {
      return this.ranges[this.mainIndex];
    }
    /**
    Make sure the selection only has one range. Returns a selection
    holding only the main range from this selection.
    */
    asSingle() {
      return this.ranges.length == 1 ? this : new EditorSelection([this.main], 0);
    }
    /**
    Extend this selection with an extra range.
    */
    addRange(range, main2 = true) {
      return EditorSelection.create([range].concat(this.ranges), main2 ? 0 : this.mainIndex + 1);
    }
    /**
    Replace a given range with another range, and then normalize the
    selection to merge and sort ranges if necessary.
    */
    replaceRange(range, which = this.mainIndex) {
      let ranges = this.ranges.slice();
      ranges[which] = range;
      return EditorSelection.create(ranges, this.mainIndex);
    }
    /**
    Convert this selection to an object that can be serialized to
    JSON.
    */
    toJSON() {
      return { ranges: this.ranges.map((r2) => r2.toJSON()), main: this.mainIndex };
    }
    /**
    Create a selection from a JSON representation.
    */
    static fromJSON(json) {
      if (!json || !Array.isArray(json.ranges) || typeof json.main != "number" || json.main >= json.ranges.length)
        throw new RangeError("Invalid JSON representation for EditorSelection");
      return new EditorSelection(json.ranges.map((r2) => SelectionRange.fromJSON(r2)), json.main);
    }
    /**
    Create a selection holding a single range.
    */
    static single(anchor, head = anchor) {
      return new EditorSelection([EditorSelection.range(anchor, head)], 0);
    }
    /**
    Sort and merge the given set of ranges, creating a valid
    selection.
    */
    static create(ranges, mainIndex = 0) {
      if (ranges.length == 0)
        throw new RangeError("A selection needs at least one range");
      for (let pos = 0, i2 = 0; i2 < ranges.length; i2++) {
        let range = ranges[i2];
        if (range.empty ? range.from <= pos : range.from < pos)
          return EditorSelection.normalized(ranges.slice(), mainIndex);
        pos = range.to;
      }
      return new EditorSelection(ranges, mainIndex);
    }
    /**
    Create a cursor selection range at the given position. You can
    safely ignore the optional arguments in most situations.
    */
    static cursor(pos, assoc = 0, bidiLevel, goalColumn) {
      return SelectionRange.create(pos, pos, (assoc == 0 ? 0 : assoc < 0 ? 8 : 16) | (bidiLevel == null ? 7 : Math.min(6, bidiLevel)) | (goalColumn !== null && goalColumn !== void 0 ? goalColumn : 16777215) << 6);
    }
    /**
    Create a selection range.
    */
    static range(anchor, head, goalColumn, bidiLevel) {
      let flags = (goalColumn !== null && goalColumn !== void 0 ? goalColumn : 16777215) << 6 | (bidiLevel == null ? 7 : Math.min(6, bidiLevel));
      return head < anchor ? SelectionRange.create(head, anchor, 32 | 16 | flags) : SelectionRange.create(anchor, head, (head > anchor ? 8 : 0) | flags);
    }
    /**
    @internal
    */
    static normalized(ranges, mainIndex = 0) {
      let main2 = ranges[mainIndex];
      ranges.sort((a2, b) => a2.from - b.from);
      mainIndex = ranges.indexOf(main2);
      for (let i2 = 1; i2 < ranges.length; i2++) {
        let range = ranges[i2], prev2 = ranges[i2 - 1];
        if (range.empty ? range.from <= prev2.to : range.from < prev2.to) {
          let from2 = prev2.from, to = Math.max(range.to, prev2.to);
          if (i2 <= mainIndex)
            mainIndex--;
          ranges.splice(--i2, 2, range.anchor > range.head ? EditorSelection.range(to, from2) : EditorSelection.range(from2, to));
        }
      }
      return new EditorSelection(ranges, mainIndex);
    }
  }
  function checkSelection(selection, docLength) {
    for (let range of selection.ranges)
      if (range.to > docLength)
        throw new RangeError("Selection points outside of document");
  }
  let nextID = 0;
  class Facet {
    constructor(combine2, compareInput, compare2, isStatic, enables) {
      this.combine = combine2;
      this.compareInput = compareInput;
      this.compare = compare2;
      this.isStatic = isStatic;
      this.id = nextID++;
      this.default = combine2([]);
      this.extensions = typeof enables == "function" ? enables(this) : enables;
    }
    /**
    Returns a facet reader for this facet, which can be used to
    [read](https://codemirror.net/6/docs/ref/#state.EditorState.facet) it but not to define values for it.
    */
    get reader() {
      return this;
    }
    /**
    Define a new facet.
    */
    static define(config2 = {}) {
      return new Facet(config2.combine || ((a2) => a2), config2.compareInput || ((a2, b) => a2 === b), config2.compare || (!config2.combine ? sameArray$1 : (a2, b) => a2 === b), !!config2.static, config2.enables);
    }
    /**
    Returns an extension that adds the given value to this facet.
    */
    of(value) {
      return new FacetProvider([], this, 0, value);
    }
    /**
    Create an extension that computes a value for the facet from a
    state. You must take care to declare the parts of the state that
    this value depends on, since your function is only called again
    for a new state when one of those parts changed.
    
    In cases where your value depends only on a single field, you'll
    want to use the [`from`](https://codemirror.net/6/docs/ref/#state.Facet.from) method instead.
    */
    compute(deps, get) {
      if (this.isStatic)
        throw new Error("Can't compute a static facet");
      return new FacetProvider(deps, this, 1, get);
    }
    /**
    Create an extension that computes zero or more values for this
    facet from a state.
    */
    computeN(deps, get) {
      if (this.isStatic)
        throw new Error("Can't compute a static facet");
      return new FacetProvider(deps, this, 2, get);
    }
    from(field, get) {
      if (!get)
        get = (x2) => x2;
      return this.compute([field], (state) => get(state.field(field)));
    }
  }
  function sameArray$1(a2, b) {
    return a2 == b || a2.length == b.length && a2.every((e, i2) => e === b[i2]);
  }
  class FacetProvider {
    constructor(dependencies, facet, type, value) {
      this.dependencies = dependencies;
      this.facet = facet;
      this.type = type;
      this.value = value;
      this.id = nextID++;
    }
    dynamicSlot(addresses) {
      var _a3;
      let getter = this.value;
      let compare2 = this.facet.compareInput;
      let id = this.id, idx = addresses[id] >> 1, multi = this.type == 2;
      let depDoc = false, depSel = false, depAddrs = [];
      for (let dep of this.dependencies) {
        if (dep == "doc")
          depDoc = true;
        else if (dep == "selection")
          depSel = true;
        else if ((((_a3 = addresses[dep.id]) !== null && _a3 !== void 0 ? _a3 : 1) & 1) == 0)
          depAddrs.push(addresses[dep.id]);
      }
      return {
        create(state) {
          state.values[idx] = getter(state);
          return 1;
        },
        update(state, tr2) {
          if (depDoc && tr2.docChanged || depSel && (tr2.docChanged || tr2.selection) || ensureAll(state, depAddrs)) {
            let newVal = getter(state);
            if (multi ? !compareArray(newVal, state.values[idx], compare2) : !compare2(newVal, state.values[idx])) {
              state.values[idx] = newVal;
              return 1;
            }
          }
          return 0;
        },
        reconfigure: (state, oldState) => {
          let newVal, oldAddr = oldState.config.address[id];
          if (oldAddr != null) {
            let oldVal = getAddr(oldState, oldAddr);
            if (this.dependencies.every((dep) => {
              return dep instanceof Facet ? oldState.facet(dep) === state.facet(dep) : dep instanceof StateField ? oldState.field(dep, false) == state.field(dep, false) : true;
            }) || (multi ? compareArray(newVal = getter(state), oldVal, compare2) : compare2(newVal = getter(state), oldVal))) {
              state.values[idx] = oldVal;
              return 0;
            }
          } else {
            newVal = getter(state);
          }
          state.values[idx] = newVal;
          return 1;
        }
      };
    }
  }
  function compareArray(a2, b, compare2) {
    if (a2.length != b.length)
      return false;
    for (let i2 = 0; i2 < a2.length; i2++)
      if (!compare2(a2[i2], b[i2]))
        return false;
    return true;
  }
  function ensureAll(state, addrs) {
    let changed = false;
    for (let addr of addrs)
      if (ensureAddr(state, addr) & 1)
        changed = true;
    return changed;
  }
  function dynamicFacetSlot(addresses, facet, providers) {
    let providerAddrs = providers.map((p2) => addresses[p2.id]);
    let providerTypes = providers.map((p2) => p2.type);
    let dynamic = providerAddrs.filter((p2) => !(p2 & 1));
    let idx = addresses[facet.id] >> 1;
    function get(state) {
      let values2 = [];
      for (let i2 = 0; i2 < providerAddrs.length; i2++) {
        let value = getAddr(state, providerAddrs[i2]);
        if (providerTypes[i2] == 2)
          for (let val of value)
            values2.push(val);
        else
          values2.push(value);
      }
      return facet.combine(values2);
    }
    return {
      create(state) {
        for (let addr of providerAddrs)
          ensureAddr(state, addr);
        state.values[idx] = get(state);
        return 1;
      },
      update(state, tr2) {
        if (!ensureAll(state, dynamic))
          return 0;
        let value = get(state);
        if (facet.compare(value, state.values[idx]))
          return 0;
        state.values[idx] = value;
        return 1;
      },
      reconfigure(state, oldState) {
        let depChanged = ensureAll(state, providerAddrs);
        let oldProviders = oldState.config.facets[facet.id], oldValue = oldState.facet(facet);
        if (oldProviders && !depChanged && sameArray$1(providers, oldProviders)) {
          state.values[idx] = oldValue;
          return 0;
        }
        let value = get(state);
        if (facet.compare(value, oldValue)) {
          state.values[idx] = oldValue;
          return 0;
        }
        state.values[idx] = value;
        return 1;
      }
    };
  }
  const initField = /* @__PURE__ */ Facet.define({ static: true });
  class StateField {
    constructor(id, createF, updateF, compareF, spec) {
      this.id = id;
      this.createF = createF;
      this.updateF = updateF;
      this.compareF = compareF;
      this.spec = spec;
      this.provides = void 0;
    }
    /**
    Define a state field.
    */
    static define(config2) {
      let field = new StateField(nextID++, config2.create, config2.update, config2.compare || ((a2, b) => a2 === b), config2);
      if (config2.provide)
        field.provides = config2.provide(field);
      return field;
    }
    create(state) {
      let init = state.facet(initField).find((i2) => i2.field == this);
      return ((init === null || init === void 0 ? void 0 : init.create) || this.createF)(state);
    }
    /**
    @internal
    */
    slot(addresses) {
      let idx = addresses[this.id] >> 1;
      return {
        create: (state) => {
          state.values[idx] = this.create(state);
          return 1;
        },
        update: (state, tr2) => {
          let oldVal = state.values[idx];
          let value = this.updateF(oldVal, tr2);
          if (this.compareF(oldVal, value))
            return 0;
          state.values[idx] = value;
          return 1;
        },
        reconfigure: (state, oldState) => {
          if (oldState.config.address[this.id] != null) {
            state.values[idx] = oldState.field(this);
            return 0;
          }
          state.values[idx] = this.create(state);
          return 1;
        }
      };
    }
    /**
    Returns an extension that enables this field and overrides the
    way it is initialized. Can be useful when you need to provide a
    non-default starting value for the field.
    */
    init(create) {
      return [this, initField.of({ field: this, create })];
    }
    /**
    State field instances can be used as
    [`Extension`](https://codemirror.net/6/docs/ref/#state.Extension) values to enable the field in a
    given state.
    */
    get extension() {
      return this;
    }
  }
  const Prec_ = { lowest: 4, low: 3, default: 2, high: 1, highest: 0 };
  function prec(value) {
    return (ext) => new PrecExtension(ext, value);
  }
  const Prec = {
    /**
    The highest precedence level, for extensions that should end up
    near the start of the precedence ordering.
    */
    highest: /* @__PURE__ */ prec(Prec_.highest),
    /**
    A higher-than-default precedence, for extensions that should
    come before those with default precedence.
    */
    high: /* @__PURE__ */ prec(Prec_.high),
    /**
    The default precedence, which is also used for extensions
    without an explicit precedence.
    */
    default: /* @__PURE__ */ prec(Prec_.default),
    /**
    A lower-than-default precedence.
    */
    low: /* @__PURE__ */ prec(Prec_.low),
    /**
    The lowest precedence level. Meant for things that should end up
    near the end of the extension order.
    */
    lowest: /* @__PURE__ */ prec(Prec_.lowest)
  };
  class PrecExtension {
    constructor(inner, prec2) {
      this.inner = inner;
      this.prec = prec2;
    }
  }
  class Compartment {
    /**
    Create an instance of this compartment to add to your [state
    configuration](https://codemirror.net/6/docs/ref/#state.EditorStateConfig.extensions).
    */
    of(ext) {
      return new CompartmentInstance(this, ext);
    }
    /**
    Create an [effect](https://codemirror.net/6/docs/ref/#state.TransactionSpec.effects) that
    reconfigures this compartment.
    */
    reconfigure(content2) {
      return Compartment.reconfigure.of({ compartment: this, extension: content2 });
    }
    /**
    Get the current content of the compartment in the state, or
    `undefined` if it isn't present.
    */
    get(state) {
      return state.config.compartments.get(this);
    }
  }
  class CompartmentInstance {
    constructor(compartment, inner) {
      this.compartment = compartment;
      this.inner = inner;
    }
  }
  class Configuration {
    constructor(base2, compartments, dynamicSlots, address, staticValues, facets) {
      this.base = base2;
      this.compartments = compartments;
      this.dynamicSlots = dynamicSlots;
      this.address = address;
      this.staticValues = staticValues;
      this.facets = facets;
      this.statusTemplate = [];
      while (this.statusTemplate.length < dynamicSlots.length)
        this.statusTemplate.push(
          0
          /* SlotStatus.Unresolved */
        );
    }
    staticFacet(facet) {
      let addr = this.address[facet.id];
      return addr == null ? facet.default : this.staticValues[addr >> 1];
    }
    static resolve(base2, compartments, oldState) {
      let fields = [];
      let facets = /* @__PURE__ */ Object.create(null);
      let newCompartments = /* @__PURE__ */ new Map();
      for (let ext of flatten(base2, compartments, newCompartments)) {
        if (ext instanceof StateField)
          fields.push(ext);
        else
          (facets[ext.facet.id] || (facets[ext.facet.id] = [])).push(ext);
      }
      let address = /* @__PURE__ */ Object.create(null);
      let staticValues = [];
      let dynamicSlots = [];
      for (let field of fields) {
        address[field.id] = dynamicSlots.length << 1;
        dynamicSlots.push((a2) => field.slot(a2));
      }
      let oldFacets = oldState === null || oldState === void 0 ? void 0 : oldState.config.facets;
      for (let id in facets) {
        let providers = facets[id], facet = providers[0].facet;
        let oldProviders = oldFacets && oldFacets[id] || [];
        if (providers.every(
          (p2) => p2.type == 0
          /* Provider.Static */
        )) {
          address[facet.id] = staticValues.length << 1 | 1;
          if (sameArray$1(oldProviders, providers)) {
            staticValues.push(oldState.facet(facet));
          } else {
            let value = facet.combine(providers.map((p2) => p2.value));
            staticValues.push(oldState && facet.compare(value, oldState.facet(facet)) ? oldState.facet(facet) : value);
          }
        } else {
          for (let p2 of providers) {
            if (p2.type == 0) {
              address[p2.id] = staticValues.length << 1 | 1;
              staticValues.push(p2.value);
            } else {
              address[p2.id] = dynamicSlots.length << 1;
              dynamicSlots.push((a2) => p2.dynamicSlot(a2));
            }
          }
          address[facet.id] = dynamicSlots.length << 1;
          dynamicSlots.push((a2) => dynamicFacetSlot(a2, facet, providers));
        }
      }
      let dynamic = dynamicSlots.map((f) => f(address));
      return new Configuration(base2, newCompartments, dynamic, address, staticValues, facets);
    }
  }
  function flatten(extension, compartments, newCompartments) {
    let result = [[], [], [], [], []];
    let seen = /* @__PURE__ */ new Map();
    function inner(ext, prec2) {
      let known = seen.get(ext);
      if (known != null) {
        if (known <= prec2)
          return;
        let found = result[known].indexOf(ext);
        if (found > -1)
          result[known].splice(found, 1);
        if (ext instanceof CompartmentInstance)
          newCompartments.delete(ext.compartment);
      }
      seen.set(ext, prec2);
      if (Array.isArray(ext)) {
        for (let e of ext)
          inner(e, prec2);
      } else if (ext instanceof CompartmentInstance) {
        if (newCompartments.has(ext.compartment))
          throw new RangeError(`Duplicate use of compartment in extensions`);
        let content2 = compartments.get(ext.compartment) || ext.inner;
        newCompartments.set(ext.compartment, content2);
        inner(content2, prec2);
      } else if (ext instanceof PrecExtension) {
        inner(ext.inner, ext.prec);
      } else if (ext instanceof StateField) {
        result[prec2].push(ext);
        if (ext.provides)
          inner(ext.provides, prec2);
      } else if (ext instanceof FacetProvider) {
        result[prec2].push(ext);
        if (ext.facet.extensions)
          inner(ext.facet.extensions, Prec_.default);
      } else {
        let content2 = ext.extension;
        if (!content2)
          throw new Error(`Unrecognized extension value in extension set (${ext}). This sometimes happens because multiple instances of @codemirror/state are loaded, breaking instanceof checks.`);
        inner(content2, prec2);
      }
    }
    inner(extension, Prec_.default);
    return result.reduce((a2, b) => a2.concat(b));
  }
  function ensureAddr(state, addr) {
    if (addr & 1)
      return 2;
    let idx = addr >> 1;
    let status = state.status[idx];
    if (status == 4)
      throw new Error("Cyclic dependency between fields and/or facets");
    if (status & 2)
      return status;
    state.status[idx] = 4;
    let changed = state.computeSlot(state, state.config.dynamicSlots[idx]);
    return state.status[idx] = 2 | changed;
  }
  function getAddr(state, addr) {
    return addr & 1 ? state.config.staticValues[addr >> 1] : state.values[addr >> 1];
  }
  const languageData = /* @__PURE__ */ Facet.define();
  const allowMultipleSelections = /* @__PURE__ */ Facet.define({
    combine: (values2) => values2.some((v2) => v2),
    static: true
  });
  const lineSeparator = /* @__PURE__ */ Facet.define({
    combine: (values2) => values2.length ? values2[0] : void 0,
    static: true
  });
  const changeFilter = /* @__PURE__ */ Facet.define();
  const transactionFilter = /* @__PURE__ */ Facet.define();
  const transactionExtender = /* @__PURE__ */ Facet.define();
  const readOnly = /* @__PURE__ */ Facet.define({
    combine: (values2) => values2.length ? values2[0] : false
  });
  class Annotation {
    /**
    @internal
    */
    constructor(type, value) {
      this.type = type;
      this.value = value;
    }
    /**
    Define a new type of annotation.
    */
    static define() {
      return new AnnotationType();
    }
  }
  class AnnotationType {
    /**
    Create an instance of this annotation.
    */
    of(value) {
      return new Annotation(this, value);
    }
  }
  class StateEffectType {
    /**
    @internal
    */
    constructor(map) {
      this.map = map;
    }
    /**
    Create a [state effect](https://codemirror.net/6/docs/ref/#state.StateEffect) instance of this
    type.
    */
    of(value) {
      return new StateEffect(this, value);
    }
  }
  class StateEffect {
    /**
    @internal
    */
    constructor(type, value) {
      this.type = type;
      this.value = value;
    }
    /**
    Map this effect through a position mapping. Will return
    `undefined` when that ends up deleting the effect.
    */
    map(mapping) {
      let mapped = this.type.map(this.value, mapping);
      return mapped === void 0 ? void 0 : mapped == this.value ? this : new StateEffect(this.type, mapped);
    }
    /**
    Tells you whether this effect object is of a given
    [type](https://codemirror.net/6/docs/ref/#state.StateEffectType).
    */
    is(type) {
      return this.type == type;
    }
    /**
    Define a new effect type. The type parameter indicates the type
    of values that his effect holds. It should be a type that
    doesn't include `undefined`, since that is used in
    [mapping](https://codemirror.net/6/docs/ref/#state.StateEffect.map) to indicate that an effect is
    removed.
    */
    static define(spec = {}) {
      return new StateEffectType(spec.map || ((v2) => v2));
    }
    /**
    Map an array of effects through a change set.
    */
    static mapEffects(effects, mapping) {
      if (!effects.length)
        return effects;
      let result = [];
      for (let effect2 of effects) {
        let mapped = effect2.map(mapping);
        if (mapped)
          result.push(mapped);
      }
      return result;
    }
  }
  StateEffect.reconfigure = /* @__PURE__ */ StateEffect.define();
  StateEffect.appendConfig = /* @__PURE__ */ StateEffect.define();
  class Transaction {
    constructor(startState, changes, selection, effects, annotations, scrollIntoView2) {
      this.startState = startState;
      this.changes = changes;
      this.selection = selection;
      this.effects = effects;
      this.annotations = annotations;
      this.scrollIntoView = scrollIntoView2;
      this._doc = null;
      this._state = null;
      if (selection)
        checkSelection(selection, changes.newLength);
      if (!annotations.some((a2) => a2.type == Transaction.time))
        this.annotations = annotations.concat(Transaction.time.of(Date.now()));
    }
    /**
    @internal
    */
    static create(startState, changes, selection, effects, annotations, scrollIntoView2) {
      return new Transaction(startState, changes, selection, effects, annotations, scrollIntoView2);
    }
    /**
    The new document produced by the transaction. Contrary to
    [`.state`](https://codemirror.net/6/docs/ref/#state.Transaction.state)`.doc`, accessing this won't
    force the entire new state to be computed right away, so it is
    recommended that [transaction
    filters](https://codemirror.net/6/docs/ref/#state.EditorState^transactionFilter) use this getter
    when they need to look at the new document.
    */
    get newDoc() {
      return this._doc || (this._doc = this.changes.apply(this.startState.doc));
    }
    /**
    The new selection produced by the transaction. If
    [`this.selection`](https://codemirror.net/6/docs/ref/#state.Transaction.selection) is undefined,
    this will [map](https://codemirror.net/6/docs/ref/#state.EditorSelection.map) the start state's
    current selection through the changes made by the transaction.
    */
    get newSelection() {
      return this.selection || this.startState.selection.map(this.changes);
    }
    /**
    The new state created by the transaction. Computed on demand
    (but retained for subsequent access), so it is recommended not to
    access it in [transaction
    filters](https://codemirror.net/6/docs/ref/#state.EditorState^transactionFilter) when possible.
    */
    get state() {
      if (!this._state)
        this.startState.applyTransaction(this);
      return this._state;
    }
    /**
    Get the value of the given annotation type, if any.
    */
    annotation(type) {
      for (let ann of this.annotations)
        if (ann.type == type)
          return ann.value;
      return void 0;
    }
    /**
    Indicates whether the transaction changed the document.
    */
    get docChanged() {
      return !this.changes.empty;
    }
    /**
    Indicates whether this transaction reconfigures the state
    (through a [configuration compartment](https://codemirror.net/6/docs/ref/#state.Compartment) or
    with a top-level configuration
    [effect](https://codemirror.net/6/docs/ref/#state.StateEffect^reconfigure).
    */
    get reconfigured() {
      return this.startState.config != this.state.config;
    }
    /**
    Returns true if the transaction has a [user
    event](https://codemirror.net/6/docs/ref/#state.Transaction^userEvent) annotation that is equal to
    or more specific than `event`. For example, if the transaction
    has `"select.pointer"` as user event, `"select"` and
    `"select.pointer"` will match it.
    */
    isUserEvent(event) {
      let e = this.annotation(Transaction.userEvent);
      return !!(e && (e == event || e.length > event.length && e.slice(0, event.length) == event && e[event.length] == "."));
    }
  }
  Transaction.time = /* @__PURE__ */ Annotation.define();
  Transaction.userEvent = /* @__PURE__ */ Annotation.define();
  Transaction.addToHistory = /* @__PURE__ */ Annotation.define();
  Transaction.remote = /* @__PURE__ */ Annotation.define();
  function joinRanges(a2, b) {
    let result = [];
    for (let iA = 0, iB = 0; ; ) {
      let from2, to;
      if (iA < a2.length && (iB == b.length || b[iB] >= a2[iA])) {
        from2 = a2[iA++];
        to = a2[iA++];
      } else if (iB < b.length) {
        from2 = b[iB++];
        to = b[iB++];
      } else
        return result;
      if (!result.length || result[result.length - 1] < from2)
        result.push(from2, to);
      else if (result[result.length - 1] < to)
        result[result.length - 1] = to;
    }
  }
  function mergeTransaction(a2, b, sequential) {
    var _a3;
    let mapForA, mapForB, changes;
    if (sequential) {
      mapForA = b.changes;
      mapForB = ChangeSet.empty(b.changes.length);
      changes = a2.changes.compose(b.changes);
    } else {
      mapForA = b.changes.map(a2.changes);
      mapForB = a2.changes.mapDesc(b.changes, true);
      changes = a2.changes.compose(mapForA);
    }
    return {
      changes,
      selection: b.selection ? b.selection.map(mapForB) : (_a3 = a2.selection) === null || _a3 === void 0 ? void 0 : _a3.map(mapForA),
      effects: StateEffect.mapEffects(a2.effects, mapForA).concat(StateEffect.mapEffects(b.effects, mapForB)),
      annotations: a2.annotations.length ? a2.annotations.concat(b.annotations) : b.annotations,
      scrollIntoView: a2.scrollIntoView || b.scrollIntoView
    };
  }
  function resolveTransactionInner(state, spec, docSize) {
    let sel = spec.selection, annotations = asArray(spec.annotations);
    if (spec.userEvent)
      annotations = annotations.concat(Transaction.userEvent.of(spec.userEvent));
    return {
      changes: spec.changes instanceof ChangeSet ? spec.changes : ChangeSet.of(spec.changes || [], docSize, state.facet(lineSeparator)),
      selection: sel && (sel instanceof EditorSelection ? sel : EditorSelection.single(sel.anchor, sel.head)),
      effects: asArray(spec.effects),
      annotations,
      scrollIntoView: !!spec.scrollIntoView
    };
  }
  function resolveTransaction(state, specs, filter) {
    let s = resolveTransactionInner(state, specs.length ? specs[0] : {}, state.doc.length);
    if (specs.length && specs[0].filter === false)
      filter = false;
    for (let i2 = 1; i2 < specs.length; i2++) {
      if (specs[i2].filter === false)
        filter = false;
      let seq = !!specs[i2].sequential;
      s = mergeTransaction(s, resolveTransactionInner(state, specs[i2], seq ? s.changes.newLength : state.doc.length), seq);
    }
    let tr2 = Transaction.create(state, s.changes, s.selection, s.effects, s.annotations, s.scrollIntoView);
    return extendTransaction(filter ? filterTransaction(tr2) : tr2);
  }
  function filterTransaction(tr2) {
    let state = tr2.startState;
    let result = true;
    for (let filter of state.facet(changeFilter)) {
      let value = filter(tr2);
      if (value === false) {
        result = false;
        break;
      }
      if (Array.isArray(value))
        result = result === true ? value : joinRanges(result, value);
    }
    if (result !== true) {
      let changes, back;
      if (result === false) {
        back = tr2.changes.invertedDesc;
        changes = ChangeSet.empty(state.doc.length);
      } else {
        let filtered = tr2.changes.filter(result);
        changes = filtered.changes;
        back = filtered.filtered.mapDesc(filtered.changes).invertedDesc;
      }
      tr2 = Transaction.create(state, changes, tr2.selection && tr2.selection.map(back), StateEffect.mapEffects(tr2.effects, back), tr2.annotations, tr2.scrollIntoView);
    }
    let filters = state.facet(transactionFilter);
    for (let i2 = filters.length - 1; i2 >= 0; i2--) {
      let filtered = filters[i2](tr2);
      if (filtered instanceof Transaction)
        tr2 = filtered;
      else if (Array.isArray(filtered) && filtered.length == 1 && filtered[0] instanceof Transaction)
        tr2 = filtered[0];
      else
        tr2 = resolveTransaction(state, asArray(filtered), false);
    }
    return tr2;
  }
  function extendTransaction(tr2) {
    let state = tr2.startState, extenders = state.facet(transactionExtender), spec = tr2;
    for (let i2 = extenders.length - 1; i2 >= 0; i2--) {
      let extension = extenders[i2](tr2);
      if (extension && Object.keys(extension).length)
        spec = mergeTransaction(spec, resolveTransactionInner(state, extension, tr2.changes.newLength), true);
    }
    return spec == tr2 ? tr2 : Transaction.create(state, tr2.changes, tr2.selection, spec.effects, spec.annotations, spec.scrollIntoView);
  }
  const none$1 = [];
  function asArray(value) {
    return value == null ? none$1 : Array.isArray(value) ? value : [value];
  }
  var CharCategory = /* @__PURE__ */ function(CharCategory2) {
    CharCategory2[CharCategory2["Word"] = 0] = "Word";
    CharCategory2[CharCategory2["Space"] = 1] = "Space";
    CharCategory2[CharCategory2["Other"] = 2] = "Other";
    return CharCategory2;
  }(CharCategory || (CharCategory = {}));
  const nonASCIISingleCaseWordChar = /[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;
  let wordChar;
  try {
    wordChar = /* @__PURE__ */ new RegExp("[\\p{Alphabetic}\\p{Number}_]", "u");
  } catch (_2) {
  }
  function hasWordChar(str) {
    if (wordChar)
      return wordChar.test(str);
    for (let i2 = 0; i2 < str.length; i2++) {
      let ch = str[i2];
      if (/\w/.test(ch) || ch > "" && (ch.toUpperCase() != ch.toLowerCase() || nonASCIISingleCaseWordChar.test(ch)))
        return true;
    }
    return false;
  }
  function makeCategorizer(wordChars) {
    return (char2) => {
      if (!/\S/.test(char2))
        return CharCategory.Space;
      if (hasWordChar(char2))
        return CharCategory.Word;
      for (let i2 = 0; i2 < wordChars.length; i2++)
        if (char2.indexOf(wordChars[i2]) > -1)
          return CharCategory.Word;
      return CharCategory.Other;
    };
  }
  class EditorState {
    constructor(config2, doc2, selection, values2, computeSlot, tr2) {
      this.config = config2;
      this.doc = doc2;
      this.selection = selection;
      this.values = values2;
      this.status = config2.statusTemplate.slice();
      this.computeSlot = computeSlot;
      if (tr2)
        tr2._state = this;
      for (let i2 = 0; i2 < this.config.dynamicSlots.length; i2++)
        ensureAddr(this, i2 << 1);
      this.computeSlot = null;
    }
    field(field, require2 = true) {
      let addr = this.config.address[field.id];
      if (addr == null) {
        if (require2)
          throw new RangeError("Field is not present in this state");
        return void 0;
      }
      ensureAddr(this, addr);
      return getAddr(this, addr);
    }
    /**
    Create a [transaction](https://codemirror.net/6/docs/ref/#state.Transaction) that updates this
    state. Any number of [transaction specs](https://codemirror.net/6/docs/ref/#state.TransactionSpec)
    can be passed. Unless
    [`sequential`](https://codemirror.net/6/docs/ref/#state.TransactionSpec.sequential) is set, the
    [changes](https://codemirror.net/6/docs/ref/#state.TransactionSpec.changes) (if any) of each spec
    are assumed to start in the _current_ document (not the document
    produced by previous specs), and its
    [selection](https://codemirror.net/6/docs/ref/#state.TransactionSpec.selection) and
    [effects](https://codemirror.net/6/docs/ref/#state.TransactionSpec.effects) are assumed to refer
    to the document created by its _own_ changes. The resulting
    transaction contains the combined effect of all the different
    specs. For [selection](https://codemirror.net/6/docs/ref/#state.TransactionSpec.selection), later
    specs take precedence over earlier ones.
    */
    update(...specs) {
      return resolveTransaction(this, specs, true);
    }
    /**
    @internal
    */
    applyTransaction(tr2) {
      let conf = this.config, { base: base2, compartments } = conf;
      for (let effect2 of tr2.effects) {
        if (effect2.is(Compartment.reconfigure)) {
          if (conf) {
            compartments = /* @__PURE__ */ new Map();
            conf.compartments.forEach((val, key) => compartments.set(key, val));
            conf = null;
          }
          compartments.set(effect2.value.compartment, effect2.value.extension);
        } else if (effect2.is(StateEffect.reconfigure)) {
          conf = null;
          base2 = effect2.value;
        } else if (effect2.is(StateEffect.appendConfig)) {
          conf = null;
          base2 = asArray(base2).concat(effect2.value);
        }
      }
      let startValues;
      if (!conf) {
        conf = Configuration.resolve(base2, compartments, this);
        let intermediateState = new EditorState(conf, this.doc, this.selection, conf.dynamicSlots.map(() => null), (state, slot) => slot.reconfigure(state, this), null);
        startValues = intermediateState.values;
      } else {
        startValues = tr2.startState.values.slice();
      }
      let selection = tr2.startState.facet(allowMultipleSelections) ? tr2.newSelection : tr2.newSelection.asSingle();
      new EditorState(conf, tr2.newDoc, selection, startValues, (state, slot) => slot.update(state, tr2), tr2);
    }
    /**
    Create a [transaction spec](https://codemirror.net/6/docs/ref/#state.TransactionSpec) that
    replaces every selection range with the given content.
    */
    replaceSelection(text) {
      if (typeof text == "string")
        text = this.toText(text);
      return this.changeByRange((range) => ({
        changes: { from: range.from, to: range.to, insert: text },
        range: EditorSelection.cursor(range.from + text.length)
      }));
    }
    /**
    Create a set of changes and a new selection by running the given
    function for each range in the active selection. The function
    can return an optional set of changes (in the coordinate space
    of the start document), plus an updated range (in the coordinate
    space of the document produced by the call's own changes). This
    method will merge all the changes and ranges into a single
    changeset and selection, and return it as a [transaction
    spec](https://codemirror.net/6/docs/ref/#state.TransactionSpec), which can be passed to
    [`update`](https://codemirror.net/6/docs/ref/#state.EditorState.update).
    */
    changeByRange(f) {
      let sel = this.selection;
      let result1 = f(sel.ranges[0]);
      let changes = this.changes(result1.changes), ranges = [result1.range];
      let effects = asArray(result1.effects);
      for (let i2 = 1; i2 < sel.ranges.length; i2++) {
        let result = f(sel.ranges[i2]);
        let newChanges = this.changes(result.changes), newMapped = newChanges.map(changes);
        for (let j = 0; j < i2; j++)
          ranges[j] = ranges[j].map(newMapped);
        let mapBy = changes.mapDesc(newChanges, true);
        ranges.push(result.range.map(mapBy));
        changes = changes.compose(newMapped);
        effects = StateEffect.mapEffects(effects, newMapped).concat(StateEffect.mapEffects(asArray(result.effects), mapBy));
      }
      return {
        changes,
        selection: EditorSelection.create(ranges, sel.mainIndex),
        effects
      };
    }
    /**
    Create a [change set](https://codemirror.net/6/docs/ref/#state.ChangeSet) from the given change
    description, taking the state's document length and line
    separator into account.
    */
    changes(spec = []) {
      if (spec instanceof ChangeSet)
        return spec;
      return ChangeSet.of(spec, this.doc.length, this.facet(EditorState.lineSeparator));
    }
    /**
    Using the state's [line
    separator](https://codemirror.net/6/docs/ref/#state.EditorState^lineSeparator), create a
    [`Text`](https://codemirror.net/6/docs/ref/#state.Text) instance from the given string.
    */
    toText(string2) {
      return Text.of(string2.split(this.facet(EditorState.lineSeparator) || DefaultSplit));
    }
    /**
    Return the given range of the document as a string.
    */
    sliceDoc(from2 = 0, to = this.doc.length) {
      return this.doc.sliceString(from2, to, this.lineBreak);
    }
    /**
    Get the value of a state [facet](https://codemirror.net/6/docs/ref/#state.Facet).
    */
    facet(facet) {
      let addr = this.config.address[facet.id];
      if (addr == null)
        return facet.default;
      ensureAddr(this, addr);
      return getAddr(this, addr);
    }
    /**
    Convert this state to a JSON-serializable object. When custom
    fields should be serialized, you can pass them in as an object
    mapping property names (in the resulting object, which should
    not use `doc` or `selection`) to fields.
    */
    toJSON(fields) {
      let result = {
        doc: this.sliceDoc(),
        selection: this.selection.toJSON()
      };
      if (fields)
        for (let prop in fields) {
          let value = fields[prop];
          if (value instanceof StateField && this.config.address[value.id] != null)
            result[prop] = value.spec.toJSON(this.field(fields[prop]), this);
        }
      return result;
    }
    /**
    Deserialize a state from its JSON representation. When custom
    fields should be deserialized, pass the same object you passed
    to [`toJSON`](https://codemirror.net/6/docs/ref/#state.EditorState.toJSON) when serializing as
    third argument.
    */
    static fromJSON(json, config2 = {}, fields) {
      if (!json || typeof json.doc != "string")
        throw new RangeError("Invalid JSON representation for EditorState");
      let fieldInit = [];
      if (fields)
        for (let prop in fields) {
          if (Object.prototype.hasOwnProperty.call(json, prop)) {
            let field = fields[prop], value = json[prop];
            fieldInit.push(field.init((state) => field.spec.fromJSON(value, state)));
          }
        }
      return EditorState.create({
        doc: json.doc,
        selection: EditorSelection.fromJSON(json.selection),
        extensions: config2.extensions ? fieldInit.concat([config2.extensions]) : fieldInit
      });
    }
    /**
    Create a new state. You'll usually only need this when
    initializing an editor—updated states are created by applying
    transactions.
    */
    static create(config2 = {}) {
      let configuration = Configuration.resolve(config2.extensions || [], /* @__PURE__ */ new Map());
      let doc2 = config2.doc instanceof Text ? config2.doc : Text.of((config2.doc || "").split(configuration.staticFacet(EditorState.lineSeparator) || DefaultSplit));
      let selection = !config2.selection ? EditorSelection.single(0) : config2.selection instanceof EditorSelection ? config2.selection : EditorSelection.single(config2.selection.anchor, config2.selection.head);
      checkSelection(selection, doc2.length);
      if (!configuration.staticFacet(allowMultipleSelections))
        selection = selection.asSingle();
      return new EditorState(configuration, doc2, selection, configuration.dynamicSlots.map(() => null), (state, slot) => slot.create(state), null);
    }
    /**
    The size (in columns) of a tab in the document, determined by
    the [`tabSize`](https://codemirror.net/6/docs/ref/#state.EditorState^tabSize) facet.
    */
    get tabSize() {
      return this.facet(EditorState.tabSize);
    }
    /**
    Get the proper [line-break](https://codemirror.net/6/docs/ref/#state.EditorState^lineSeparator)
    string for this state.
    */
    get lineBreak() {
      return this.facet(EditorState.lineSeparator) || "\n";
    }
    /**
    Returns true when the editor is
    [configured](https://codemirror.net/6/docs/ref/#state.EditorState^readOnly) to be read-only.
    */
    get readOnly() {
      return this.facet(readOnly);
    }
    /**
    Look up a translation for the given phrase (via the
    [`phrases`](https://codemirror.net/6/docs/ref/#state.EditorState^phrases) facet), or return the
    original string if no translation is found.
    
    If additional arguments are passed, they will be inserted in
    place of markers like `$1` (for the first value) and `$2`, etc.
    A single `$` is equivalent to `$1`, and `$$` will produce a
    literal dollar sign.
    */
    phrase(phrase, ...insert2) {
      for (let map of this.facet(EditorState.phrases))
        if (Object.prototype.hasOwnProperty.call(map, phrase)) {
          phrase = map[phrase];
          break;
        }
      if (insert2.length)
        phrase = phrase.replace(/\$(\$|\d*)/g, (m2, i2) => {
          if (i2 == "$")
            return "$";
          let n = +(i2 || 1);
          return !n || n > insert2.length ? m2 : insert2[n - 1];
        });
      return phrase;
    }
    /**
    Find the values for a given language data field, provided by the
    the [`languageData`](https://codemirror.net/6/docs/ref/#state.EditorState^languageData) facet.
    
    Examples of language data fields are...
    
    - [`"commentTokens"`](https://codemirror.net/6/docs/ref/#commands.CommentTokens) for specifying
      comment syntax.
    - [`"autocomplete"`](https://codemirror.net/6/docs/ref/#autocomplete.autocompletion^config.override)
      for providing language-specific completion sources.
    - [`"wordChars"`](https://codemirror.net/6/docs/ref/#state.EditorState.charCategorizer) for adding
      characters that should be considered part of words in this
      language.
    - [`"closeBrackets"`](https://codemirror.net/6/docs/ref/#autocomplete.CloseBracketConfig) controls
      bracket closing behavior.
    */
    languageDataAt(name2, pos, side = -1) {
      let values2 = [];
      for (let provider of this.facet(languageData)) {
        for (let result of provider(this, pos, side)) {
          if (Object.prototype.hasOwnProperty.call(result, name2))
            values2.push(result[name2]);
        }
      }
      return values2;
    }
    /**
    Return a function that can categorize strings (expected to
    represent a single [grapheme cluster](https://codemirror.net/6/docs/ref/#state.findClusterBreak))
    into one of:
    
     - Word (contains an alphanumeric character or a character
       explicitly listed in the local language's `"wordChars"`
       language data, which should be a string)
     - Space (contains only whitespace)
     - Other (anything else)
    */
    charCategorizer(at2) {
      return makeCategorizer(this.languageDataAt("wordChars", at2).join(""));
    }
    /**
    Find the word at the given position, meaning the range
    containing all [word](https://codemirror.net/6/docs/ref/#state.CharCategory.Word) characters
    around it. If no word characters are adjacent to the position,
    this returns null.
    */
    wordAt(pos) {
      let { text, from: from2, length: length2 } = this.doc.lineAt(pos);
      let cat = this.charCategorizer(pos);
      let start2 = pos - from2, end2 = pos - from2;
      while (start2 > 0) {
        let prev2 = findClusterBreak(text, start2, false);
        if (cat(text.slice(prev2, start2)) != CharCategory.Word)
          break;
        start2 = prev2;
      }
      while (end2 < length2) {
        let next2 = findClusterBreak(text, end2);
        if (cat(text.slice(end2, next2)) != CharCategory.Word)
          break;
        end2 = next2;
      }
      return start2 == end2 ? null : EditorSelection.range(start2 + from2, end2 + from2);
    }
  }
  EditorState.allowMultipleSelections = allowMultipleSelections;
  EditorState.tabSize = /* @__PURE__ */ Facet.define({
    combine: (values2) => values2.length ? values2[0] : 4
  });
  EditorState.lineSeparator = lineSeparator;
  EditorState.readOnly = readOnly;
  EditorState.phrases = /* @__PURE__ */ Facet.define({
    compare(a2, b) {
      let kA = Object.keys(a2), kB = Object.keys(b);
      return kA.length == kB.length && kA.every((k) => a2[k] == b[k]);
    }
  });
  EditorState.languageData = languageData;
  EditorState.changeFilter = changeFilter;
  EditorState.transactionFilter = transactionFilter;
  EditorState.transactionExtender = transactionExtender;
  Compartment.reconfigure = /* @__PURE__ */ StateEffect.define();
  function combineConfig(configs, defaults, combine2 = {}) {
    let result = {};
    for (let config2 of configs)
      for (let key of Object.keys(config2)) {
        let value = config2[key], current = result[key];
        if (current === void 0)
          result[key] = value;
        else if (current === value || value === void 0)
          ;
        else if (Object.hasOwnProperty.call(combine2, key))
          result[key] = combine2[key](current, value);
        else
          throw new Error("Config merge conflict for field " + key);
      }
    for (let key in defaults)
      if (result[key] === void 0)
        result[key] = defaults[key];
    return result;
  }
  class RangeValue {
    /**
    Compare this value with another value. Used when comparing
    rangesets. The default implementation compares by identity.
    Unless you are only creating a fixed number of unique instances
    of your value type, it is a good idea to implement this
    properly.
    */
    eq(other) {
      return this == other;
    }
    /**
    Create a [range](https://codemirror.net/6/docs/ref/#state.Range) with this value.
    */
    range(from2, to = from2) {
      return Range$1.create(from2, to, this);
    }
  }
  RangeValue.prototype.startSide = RangeValue.prototype.endSide = 0;
  RangeValue.prototype.point = false;
  RangeValue.prototype.mapMode = MapMode.TrackDel;
  let Range$1 = class Range2 {
    constructor(from2, to, value) {
      this.from = from2;
      this.to = to;
      this.value = value;
    }
    /**
    @internal
    */
    static create(from2, to, value) {
      return new Range2(from2, to, value);
    }
  };
  function cmpRange(a2, b) {
    return a2.from - b.from || a2.value.startSide - b.value.startSide;
  }
  class Chunk {
    constructor(from2, to, value, maxPoint) {
      this.from = from2;
      this.to = to;
      this.value = value;
      this.maxPoint = maxPoint;
    }
    get length() {
      return this.to[this.to.length - 1];
    }
    // Find the index of the given position and side. Use the ranges'
    // `from` pos when `end == false`, `to` when `end == true`.
    findIndex(pos, side, end2, startAt = 0) {
      let arr = end2 ? this.to : this.from;
      for (let lo = startAt, hi = arr.length; ; ) {
        if (lo == hi)
          return lo;
        let mid = lo + hi >> 1;
        let diff = arr[mid] - pos || (end2 ? this.value[mid].endSide : this.value[mid].startSide) - side;
        if (mid == lo)
          return diff >= 0 ? lo : hi;
        if (diff >= 0)
          hi = mid;
        else
          lo = mid + 1;
      }
    }
    between(offset2, from2, to, f) {
      for (let i2 = this.findIndex(from2, -1e9, true), e = this.findIndex(to, 1e9, false, i2); i2 < e; i2++)
        if (f(this.from[i2] + offset2, this.to[i2] + offset2, this.value[i2]) === false)
          return false;
    }
    map(offset2, changes) {
      let value = [], from2 = [], to = [], newPos = -1, maxPoint = -1;
      for (let i2 = 0; i2 < this.value.length; i2++) {
        let val = this.value[i2], curFrom = this.from[i2] + offset2, curTo = this.to[i2] + offset2, newFrom, newTo;
        if (curFrom == curTo) {
          let mapped = changes.mapPos(curFrom, val.startSide, val.mapMode);
          if (mapped == null)
            continue;
          newFrom = newTo = mapped;
          if (val.startSide != val.endSide) {
            newTo = changes.mapPos(curFrom, val.endSide);
            if (newTo < newFrom)
              continue;
          }
        } else {
          newFrom = changes.mapPos(curFrom, val.startSide);
          newTo = changes.mapPos(curTo, val.endSide);
          if (newFrom > newTo || newFrom == newTo && val.startSide > 0 && val.endSide <= 0)
            continue;
        }
        if ((newTo - newFrom || val.endSide - val.startSide) < 0)
          continue;
        if (newPos < 0)
          newPos = newFrom;
        if (val.point)
          maxPoint = Math.max(maxPoint, newTo - newFrom);
        value.push(val);
        from2.push(newFrom - newPos);
        to.push(newTo - newPos);
      }
      return { mapped: value.length ? new Chunk(from2, to, value, maxPoint) : null, pos: newPos };
    }
  }
  class RangeSet {
    constructor(chunkPos, chunk, nextLayer, maxPoint) {
      this.chunkPos = chunkPos;
      this.chunk = chunk;
      this.nextLayer = nextLayer;
      this.maxPoint = maxPoint;
    }
    /**
    @internal
    */
    static create(chunkPos, chunk, nextLayer, maxPoint) {
      return new RangeSet(chunkPos, chunk, nextLayer, maxPoint);
    }
    /**
    @internal
    */
    get length() {
      let last = this.chunk.length - 1;
      return last < 0 ? 0 : Math.max(this.chunkEnd(last), this.nextLayer.length);
    }
    /**
    The number of ranges in the set.
    */
    get size() {
      if (this.isEmpty)
        return 0;
      let size = this.nextLayer.size;
      for (let chunk of this.chunk)
        size += chunk.value.length;
      return size;
    }
    /**
    @internal
    */
    chunkEnd(index) {
      return this.chunkPos[index] + this.chunk[index].length;
    }
    /**
    Update the range set, optionally adding new ranges or filtering
    out existing ones.
    
    (Note: The type parameter is just there as a kludge to work
    around TypeScript variance issues that prevented `RangeSet<X>`
    from being a subtype of `RangeSet<Y>` when `X` is a subtype of
    `Y`.)
    */
    update(updateSpec) {
      let { add = [], sort = false, filterFrom = 0, filterTo = this.length } = updateSpec;
      let filter = updateSpec.filter;
      if (add.length == 0 && !filter)
        return this;
      if (sort)
        add = add.slice().sort(cmpRange);
      if (this.isEmpty)
        return add.length ? RangeSet.of(add) : this;
      let cur = new LayerCursor(this, null, -1).goto(0), i2 = 0, spill = [];
      let builder = new RangeSetBuilder();
      while (cur.value || i2 < add.length) {
        if (i2 < add.length && (cur.from - add[i2].from || cur.startSide - add[i2].value.startSide) >= 0) {
          let range = add[i2++];
          if (!builder.addInner(range.from, range.to, range.value))
            spill.push(range);
        } else if (cur.rangeIndex == 1 && cur.chunkIndex < this.chunk.length && (i2 == add.length || this.chunkEnd(cur.chunkIndex) < add[i2].from) && (!filter || filterFrom > this.chunkEnd(cur.chunkIndex) || filterTo < this.chunkPos[cur.chunkIndex]) && builder.addChunk(this.chunkPos[cur.chunkIndex], this.chunk[cur.chunkIndex])) {
          cur.nextChunk();
        } else {
          if (!filter || filterFrom > cur.to || filterTo < cur.from || filter(cur.from, cur.to, cur.value)) {
            if (!builder.addInner(cur.from, cur.to, cur.value))
              spill.push(Range$1.create(cur.from, cur.to, cur.value));
          }
          cur.next();
        }
      }
      return builder.finishInner(this.nextLayer.isEmpty && !spill.length ? RangeSet.empty : this.nextLayer.update({ add: spill, filter, filterFrom, filterTo }));
    }
    /**
    Map this range set through a set of changes, return the new set.
    */
    map(changes) {
      if (changes.empty || this.isEmpty)
        return this;
      let chunks = [], chunkPos = [], maxPoint = -1;
      for (let i2 = 0; i2 < this.chunk.length; i2++) {
        let start2 = this.chunkPos[i2], chunk = this.chunk[i2];
        let touch = changes.touchesRange(start2, start2 + chunk.length);
        if (touch === false) {
          maxPoint = Math.max(maxPoint, chunk.maxPoint);
          chunks.push(chunk);
          chunkPos.push(changes.mapPos(start2));
        } else if (touch === true) {
          let { mapped, pos } = chunk.map(start2, changes);
          if (mapped) {
            maxPoint = Math.max(maxPoint, mapped.maxPoint);
            chunks.push(mapped);
            chunkPos.push(pos);
          }
        }
      }
      let next2 = this.nextLayer.map(changes);
      return chunks.length == 0 ? next2 : new RangeSet(chunkPos, chunks, next2 || RangeSet.empty, maxPoint);
    }
    /**
    Iterate over the ranges that touch the region `from` to `to`,
    calling `f` for each. There is no guarantee that the ranges will
    be reported in any specific order. When the callback returns
    `false`, iteration stops.
    */
    between(from2, to, f) {
      if (this.isEmpty)
        return;
      for (let i2 = 0; i2 < this.chunk.length; i2++) {
        let start2 = this.chunkPos[i2], chunk = this.chunk[i2];
        if (to >= start2 && from2 <= start2 + chunk.length && chunk.between(start2, from2 - start2, to - start2, f) === false)
          return;
      }
      this.nextLayer.between(from2, to, f);
    }
    /**
    Iterate over the ranges in this set, in order, including all
    ranges that end at or after `from`.
    */
    iter(from2 = 0) {
      return HeapCursor.from([this]).goto(from2);
    }
    /**
    @internal
    */
    get isEmpty() {
      return this.nextLayer == this;
    }
    /**
    Iterate over the ranges in a collection of sets, in order,
    starting from `from`.
    */
    static iter(sets, from2 = 0) {
      return HeapCursor.from(sets).goto(from2);
    }
    /**
    Iterate over two groups of sets, calling methods on `comparator`
    to notify it of possible differences.
    */
    static compare(oldSets, newSets, textDiff, comparator, minPointSize = -1) {
      let a2 = oldSets.filter((set) => set.maxPoint > 0 || !set.isEmpty && set.maxPoint >= minPointSize);
      let b = newSets.filter((set) => set.maxPoint > 0 || !set.isEmpty && set.maxPoint >= minPointSize);
      let sharedChunks = findSharedChunks(a2, b, textDiff);
      let sideA = new SpanCursor(a2, sharedChunks, minPointSize);
      let sideB = new SpanCursor(b, sharedChunks, minPointSize);
      textDiff.iterGaps((fromA, fromB, length2) => compare(sideA, fromA, sideB, fromB, length2, comparator));
      if (textDiff.empty && textDiff.length == 0)
        compare(sideA, 0, sideB, 0, 0, comparator);
    }
    /**
    Compare the contents of two groups of range sets, returning true
    if they are equivalent in the given range.
    */
    static eq(oldSets, newSets, from2 = 0, to) {
      if (to == null)
        to = 1e9 - 1;
      let a2 = oldSets.filter((set) => !set.isEmpty && newSets.indexOf(set) < 0);
      let b = newSets.filter((set) => !set.isEmpty && oldSets.indexOf(set) < 0);
      if (a2.length != b.length)
        return false;
      if (!a2.length)
        return true;
      let sharedChunks = findSharedChunks(a2, b);
      let sideA = new SpanCursor(a2, sharedChunks, 0).goto(from2), sideB = new SpanCursor(b, sharedChunks, 0).goto(from2);
      for (; ; ) {
        if (sideA.to != sideB.to || !sameValues(sideA.active, sideB.active) || sideA.point && (!sideB.point || !sideA.point.eq(sideB.point)))
          return false;
        if (sideA.to > to)
          return true;
        sideA.next();
        sideB.next();
      }
    }
    /**
    Iterate over a group of range sets at the same time, notifying
    the iterator about the ranges covering every given piece of
    content. Returns the open count (see
    [`SpanIterator.span`](https://codemirror.net/6/docs/ref/#state.SpanIterator.span)) at the end
    of the iteration.
    */
    static spans(sets, from2, to, iterator, minPointSize = -1) {
      let cursor2 = new SpanCursor(sets, null, minPointSize).goto(from2), pos = from2;
      let openRanges = cursor2.openStart;
      for (; ; ) {
        let curTo = Math.min(cursor2.to, to);
        if (cursor2.point) {
          let active = cursor2.activeForPoint(cursor2.to);
          let openCount = cursor2.pointFrom < from2 ? active.length + 1 : cursor2.point.startSide < 0 ? active.length : Math.min(active.length, openRanges);
          iterator.point(pos, curTo, cursor2.point, active, openCount, cursor2.pointRank);
          openRanges = Math.min(cursor2.openEnd(curTo), active.length);
        } else if (curTo > pos) {
          iterator.span(pos, curTo, cursor2.active, openRanges);
          openRanges = cursor2.openEnd(curTo);
        }
        if (cursor2.to > to)
          return openRanges + (cursor2.point && cursor2.to > to ? 1 : 0);
        pos = cursor2.to;
        cursor2.next();
      }
    }
    /**
    Create a range set for the given range or array of ranges. By
    default, this expects the ranges to be _sorted_ (by start
    position and, if two start at the same position,
    `value.startSide`). You can pass `true` as second argument to
    cause the method to sort them.
    */
    static of(ranges, sort = false) {
      let build = new RangeSetBuilder();
      for (let range of ranges instanceof Range$1 ? [ranges] : sort ? lazySort(ranges) : ranges)
        build.add(range.from, range.to, range.value);
      return build.finish();
    }
    /**
    Join an array of range sets into a single set.
    */
    static join(sets) {
      if (!sets.length)
        return RangeSet.empty;
      let result = sets[sets.length - 1];
      for (let i2 = sets.length - 2; i2 >= 0; i2--) {
        for (let layer2 = sets[i2]; layer2 != RangeSet.empty; layer2 = layer2.nextLayer)
          result = new RangeSet(layer2.chunkPos, layer2.chunk, result, Math.max(layer2.maxPoint, result.maxPoint));
      }
      return result;
    }
  }
  RangeSet.empty = /* @__PURE__ */ new RangeSet([], [], null, -1);
  function lazySort(ranges) {
    if (ranges.length > 1)
      for (let prev2 = ranges[0], i2 = 1; i2 < ranges.length; i2++) {
        let cur = ranges[i2];
        if (cmpRange(prev2, cur) > 0)
          return ranges.slice().sort(cmpRange);
        prev2 = cur;
      }
    return ranges;
  }
  RangeSet.empty.nextLayer = RangeSet.empty;
  class RangeSetBuilder {
    finishChunk(newArrays) {
      this.chunks.push(new Chunk(this.from, this.to, this.value, this.maxPoint));
      this.chunkPos.push(this.chunkStart);
      this.chunkStart = -1;
      this.setMaxPoint = Math.max(this.setMaxPoint, this.maxPoint);
      this.maxPoint = -1;
      if (newArrays) {
        this.from = [];
        this.to = [];
        this.value = [];
      }
    }
    /**
    Create an empty builder.
    */
    constructor() {
      this.chunks = [];
      this.chunkPos = [];
      this.chunkStart = -1;
      this.last = null;
      this.lastFrom = -1e9;
      this.lastTo = -1e9;
      this.from = [];
      this.to = [];
      this.value = [];
      this.maxPoint = -1;
      this.setMaxPoint = -1;
      this.nextLayer = null;
    }
    /**
    Add a range. Ranges should be added in sorted (by `from` and
    `value.startSide`) order.
    */
    add(from2, to, value) {
      if (!this.addInner(from2, to, value))
        (this.nextLayer || (this.nextLayer = new RangeSetBuilder())).add(from2, to, value);
    }
    /**
    @internal
    */
    addInner(from2, to, value) {
      let diff = from2 - this.lastTo || value.startSide - this.last.endSide;
      if (diff <= 0 && (from2 - this.lastFrom || value.startSide - this.last.startSide) < 0)
        throw new Error("Ranges must be added sorted by `from` position and `startSide`");
      if (diff < 0)
        return false;
      if (this.from.length == 250)
        this.finishChunk(true);
      if (this.chunkStart < 0)
        this.chunkStart = from2;
      this.from.push(from2 - this.chunkStart);
      this.to.push(to - this.chunkStart);
      this.last = value;
      this.lastFrom = from2;
      this.lastTo = to;
      this.value.push(value);
      if (value.point)
        this.maxPoint = Math.max(this.maxPoint, to - from2);
      return true;
    }
    /**
    @internal
    */
    addChunk(from2, chunk) {
      if ((from2 - this.lastTo || chunk.value[0].startSide - this.last.endSide) < 0)
        return false;
      if (this.from.length)
        this.finishChunk(true);
      this.setMaxPoint = Math.max(this.setMaxPoint, chunk.maxPoint);
      this.chunks.push(chunk);
      this.chunkPos.push(from2);
      let last = chunk.value.length - 1;
      this.last = chunk.value[last];
      this.lastFrom = chunk.from[last] + from2;
      this.lastTo = chunk.to[last] + from2;
      return true;
    }
    /**
    Finish the range set. Returns the new set. The builder can't be
    used anymore after this has been called.
    */
    finish() {
      return this.finishInner(RangeSet.empty);
    }
    /**
    @internal
    */
    finishInner(next2) {
      if (this.from.length)
        this.finishChunk(false);
      if (this.chunks.length == 0)
        return next2;
      let result = RangeSet.create(this.chunkPos, this.chunks, this.nextLayer ? this.nextLayer.finishInner(next2) : next2, this.setMaxPoint);
      this.from = null;
      return result;
    }
  }
  function findSharedChunks(a2, b, textDiff) {
    let inA = /* @__PURE__ */ new Map();
    for (let set of a2)
      for (let i2 = 0; i2 < set.chunk.length; i2++)
        if (set.chunk[i2].maxPoint <= 0)
          inA.set(set.chunk[i2], set.chunkPos[i2]);
    let shared = /* @__PURE__ */ new Set();
    for (let set of b)
      for (let i2 = 0; i2 < set.chunk.length; i2++) {
        let known = inA.get(set.chunk[i2]);
        if (known != null && (textDiff ? textDiff.mapPos(known) : known) == set.chunkPos[i2] && !(textDiff === null || textDiff === void 0 ? void 0 : textDiff.touchesRange(known, known + set.chunk[i2].length)))
          shared.add(set.chunk[i2]);
      }
    return shared;
  }
  class LayerCursor {
    constructor(layer2, skip, minPoint, rank = 0) {
      this.layer = layer2;
      this.skip = skip;
      this.minPoint = minPoint;
      this.rank = rank;
    }
    get startSide() {
      return this.value ? this.value.startSide : 0;
    }
    get endSide() {
      return this.value ? this.value.endSide : 0;
    }
    goto(pos, side = -1e9) {
      this.chunkIndex = this.rangeIndex = 0;
      this.gotoInner(pos, side, false);
      return this;
    }
    gotoInner(pos, side, forward) {
      while (this.chunkIndex < this.layer.chunk.length) {
        let next2 = this.layer.chunk[this.chunkIndex];
        if (!(this.skip && this.skip.has(next2) || this.layer.chunkEnd(this.chunkIndex) < pos || next2.maxPoint < this.minPoint))
          break;
        this.chunkIndex++;
        forward = false;
      }
      if (this.chunkIndex < this.layer.chunk.length) {
        let rangeIndex = this.layer.chunk[this.chunkIndex].findIndex(pos - this.layer.chunkPos[this.chunkIndex], side, true);
        if (!forward || this.rangeIndex < rangeIndex)
          this.setRangeIndex(rangeIndex);
      }
      this.next();
    }
    forward(pos, side) {
      if ((this.to - pos || this.endSide - side) < 0)
        this.gotoInner(pos, side, true);
    }
    next() {
      for (; ; ) {
        if (this.chunkIndex == this.layer.chunk.length) {
          this.from = this.to = 1e9;
          this.value = null;
          break;
        } else {
          let chunkPos = this.layer.chunkPos[this.chunkIndex], chunk = this.layer.chunk[this.chunkIndex];
          let from2 = chunkPos + chunk.from[this.rangeIndex];
          this.from = from2;
          this.to = chunkPos + chunk.to[this.rangeIndex];
          this.value = chunk.value[this.rangeIndex];
          this.setRangeIndex(this.rangeIndex + 1);
          if (this.minPoint < 0 || this.value.point && this.to - this.from >= this.minPoint)
            break;
        }
      }
    }
    setRangeIndex(index) {
      if (index == this.layer.chunk[this.chunkIndex].value.length) {
        this.chunkIndex++;
        if (this.skip) {
          while (this.chunkIndex < this.layer.chunk.length && this.skip.has(this.layer.chunk[this.chunkIndex]))
            this.chunkIndex++;
        }
        this.rangeIndex = 0;
      } else {
        this.rangeIndex = index;
      }
    }
    nextChunk() {
      this.chunkIndex++;
      this.rangeIndex = 0;
      this.next();
    }
    compare(other) {
      return this.from - other.from || this.startSide - other.startSide || this.rank - other.rank || this.to - other.to || this.endSide - other.endSide;
    }
  }
  class HeapCursor {
    constructor(heap) {
      this.heap = heap;
    }
    static from(sets, skip = null, minPoint = -1) {
      let heap = [];
      for (let i2 = 0; i2 < sets.length; i2++) {
        for (let cur = sets[i2]; !cur.isEmpty; cur = cur.nextLayer) {
          if (cur.maxPoint >= minPoint)
            heap.push(new LayerCursor(cur, skip, minPoint, i2));
        }
      }
      return heap.length == 1 ? heap[0] : new HeapCursor(heap);
    }
    get startSide() {
      return this.value ? this.value.startSide : 0;
    }
    goto(pos, side = -1e9) {
      for (let cur of this.heap)
        cur.goto(pos, side);
      for (let i2 = this.heap.length >> 1; i2 >= 0; i2--)
        heapBubble(this.heap, i2);
      this.next();
      return this;
    }
    forward(pos, side) {
      for (let cur of this.heap)
        cur.forward(pos, side);
      for (let i2 = this.heap.length >> 1; i2 >= 0; i2--)
        heapBubble(this.heap, i2);
      if ((this.to - pos || this.value.endSide - side) < 0)
        this.next();
    }
    next() {
      if (this.heap.length == 0) {
        this.from = this.to = 1e9;
        this.value = null;
        this.rank = -1;
      } else {
        let top2 = this.heap[0];
        this.from = top2.from;
        this.to = top2.to;
        this.value = top2.value;
        this.rank = top2.rank;
        if (top2.value)
          top2.next();
        heapBubble(this.heap, 0);
      }
    }
  }
  function heapBubble(heap, index) {
    for (let cur = heap[index]; ; ) {
      let childIndex = (index << 1) + 1;
      if (childIndex >= heap.length)
        break;
      let child = heap[childIndex];
      if (childIndex + 1 < heap.length && child.compare(heap[childIndex + 1]) >= 0) {
        child = heap[childIndex + 1];
        childIndex++;
      }
      if (cur.compare(child) < 0)
        break;
      heap[childIndex] = cur;
      heap[index] = child;
      index = childIndex;
    }
  }
  class SpanCursor {
    constructor(sets, skip, minPoint) {
      this.minPoint = minPoint;
      this.active = [];
      this.activeTo = [];
      this.activeRank = [];
      this.minActive = -1;
      this.point = null;
      this.pointFrom = 0;
      this.pointRank = 0;
      this.to = -1e9;
      this.endSide = 0;
      this.openStart = -1;
      this.cursor = HeapCursor.from(sets, skip, minPoint);
    }
    goto(pos, side = -1e9) {
      this.cursor.goto(pos, side);
      this.active.length = this.activeTo.length = this.activeRank.length = 0;
      this.minActive = -1;
      this.to = pos;
      this.endSide = side;
      this.openStart = -1;
      this.next();
      return this;
    }
    forward(pos, side) {
      while (this.minActive > -1 && (this.activeTo[this.minActive] - pos || this.active[this.minActive].endSide - side) < 0)
        this.removeActive(this.minActive);
      this.cursor.forward(pos, side);
    }
    removeActive(index) {
      remove(this.active, index);
      remove(this.activeTo, index);
      remove(this.activeRank, index);
      this.minActive = findMinIndex(this.active, this.activeTo);
    }
    addActive(trackOpen) {
      let i2 = 0, { value, to, rank } = this.cursor;
      while (i2 < this.activeRank.length && (rank - this.activeRank[i2] || to - this.activeTo[i2]) > 0)
        i2++;
      insert(this.active, i2, value);
      insert(this.activeTo, i2, to);
      insert(this.activeRank, i2, rank);
      if (trackOpen)
        insert(trackOpen, i2, this.cursor.from);
      this.minActive = findMinIndex(this.active, this.activeTo);
    }
    // After calling this, if `this.point` != null, the next range is a
    // point. Otherwise, it's a regular range, covered by `this.active`.
    next() {
      let from2 = this.to, wasPoint = this.point;
      this.point = null;
      let trackOpen = this.openStart < 0 ? [] : null;
      for (; ; ) {
        let a2 = this.minActive;
        if (a2 > -1 && (this.activeTo[a2] - this.cursor.from || this.active[a2].endSide - this.cursor.startSide) < 0) {
          if (this.activeTo[a2] > from2) {
            this.to = this.activeTo[a2];
            this.endSide = this.active[a2].endSide;
            break;
          }
          this.removeActive(a2);
          if (trackOpen)
            remove(trackOpen, a2);
        } else if (!this.cursor.value) {
          this.to = this.endSide = 1e9;
          break;
        } else if (this.cursor.from > from2) {
          this.to = this.cursor.from;
          this.endSide = this.cursor.startSide;
          break;
        } else {
          let nextVal = this.cursor.value;
          if (!nextVal.point) {
            this.addActive(trackOpen);
            this.cursor.next();
          } else if (wasPoint && this.cursor.to == this.to && this.cursor.from < this.cursor.to) {
            this.cursor.next();
          } else {
            this.point = nextVal;
            this.pointFrom = this.cursor.from;
            this.pointRank = this.cursor.rank;
            this.to = this.cursor.to;
            this.endSide = nextVal.endSide;
            this.cursor.next();
            this.forward(this.to, this.endSide);
            break;
          }
        }
      }
      if (trackOpen) {
        this.openStart = 0;
        for (let i2 = trackOpen.length - 1; i2 >= 0 && trackOpen[i2] < from2; i2--)
          this.openStart++;
      }
    }
    activeForPoint(to) {
      if (!this.active.length)
        return this.active;
      let active = [];
      for (let i2 = this.active.length - 1; i2 >= 0; i2--) {
        if (this.activeRank[i2] < this.pointRank)
          break;
        if (this.activeTo[i2] > to || this.activeTo[i2] == to && this.active[i2].endSide >= this.point.endSide)
          active.push(this.active[i2]);
      }
      return active.reverse();
    }
    openEnd(to) {
      let open = 0;
      for (let i2 = this.activeTo.length - 1; i2 >= 0 && this.activeTo[i2] > to; i2--)
        open++;
      return open;
    }
  }
  function compare(a2, startA, b, startB, length2, comparator) {
    a2.goto(startA);
    b.goto(startB);
    let endB = startB + length2;
    let pos = startB, dPos = startB - startA;
    for (; ; ) {
      let dEnd = a2.to + dPos - b.to, diff = dEnd || a2.endSide - b.endSide;
      let end2 = diff < 0 ? a2.to + dPos : b.to, clipEnd = Math.min(end2, endB);
      if (a2.point || b.point) {
        if (!(a2.point && b.point && (a2.point == b.point || a2.point.eq(b.point)) && sameValues(a2.activeForPoint(a2.to), b.activeForPoint(b.to))))
          comparator.comparePoint(pos, clipEnd, a2.point, b.point);
      } else {
        if (clipEnd > pos && !sameValues(a2.active, b.active))
          comparator.compareRange(pos, clipEnd, a2.active, b.active);
      }
      if (end2 > endB)
        break;
      if ((dEnd || a2.openEnd != b.openEnd) && comparator.boundChange)
        comparator.boundChange(end2);
      pos = end2;
      if (diff <= 0)
        a2.next();
      if (diff >= 0)
        b.next();
    }
  }
  function sameValues(a2, b) {
    if (a2.length != b.length)
      return false;
    for (let i2 = 0; i2 < a2.length; i2++)
      if (a2[i2] != b[i2] && !a2[i2].eq(b[i2]))
        return false;
    return true;
  }
  function remove(array, index) {
    for (let i2 = index, e = array.length - 1; i2 < e; i2++)
      array[i2] = array[i2 + 1];
    array.pop();
  }
  function insert(array, index, value) {
    for (let i2 = array.length - 1; i2 >= index; i2--)
      array[i2 + 1] = array[i2];
    array[index] = value;
  }
  function findMinIndex(value, array) {
    let found = -1, foundPos = 1e9;
    for (let i2 = 0; i2 < array.length; i2++)
      if ((array[i2] - foundPos || value[i2].endSide - value[found].endSide) < 0) {
        found = i2;
        foundPos = array[i2];
      }
    return found;
  }
  function countColumn(string2, tabSize, to = string2.length) {
    let n = 0;
    for (let i2 = 0; i2 < to; ) {
      if (string2.charCodeAt(i2) == 9) {
        n += tabSize - n % tabSize;
        i2++;
      } else {
        n++;
        i2 = findClusterBreak(string2, i2);
      }
    }
    return n;
  }
  function findColumn(string2, col, tabSize, strict) {
    for (let i2 = 0, n = 0; ; ) {
      if (n >= col)
        return i2;
      if (i2 == string2.length)
        break;
      n += string2.charCodeAt(i2) == 9 ? tabSize - n % tabSize : 1;
      i2 = findClusterBreak(string2, i2);
    }
    return strict === true ? -1 : string2.length;
  }
  const C = "ͼ";
  const COUNT = typeof Symbol == "undefined" ? "__" + C : Symbol.for(C);
  const SET = typeof Symbol == "undefined" ? "__styleSet" + Math.floor(Math.random() * 1e8) : Symbol("styleSet");
  const top$1 = typeof globalThis != "undefined" ? globalThis : typeof window != "undefined" ? window : {};
  class StyleModule {
    // :: (Object<Style>, ?{finish: ?(string) → string})
    // Create a style module from the given spec.
    //
    // When `finish` is given, it is called on regular (non-`@`)
    // selectors (after `&` expansion) to compute the final selector.
    constructor(spec, options) {
      this.rules = [];
      let { finish } = options || {};
      function splitSelector(selector) {
        return /^@/.test(selector) ? [selector] : selector.split(/,\s*/);
      }
      function render(selectors, spec2, target, isKeyframes) {
        let local = [], isAt = /^@(\w+)\b/.exec(selectors[0]), keyframes2 = isAt && isAt[1] == "keyframes";
        if (isAt && spec2 == null)
          return target.push(selectors[0] + ";");
        for (let prop in spec2) {
          let value = spec2[prop];
          if (/&/.test(prop)) {
            render(
              prop.split(/,\s*/).map((part) => selectors.map((sel) => part.replace(/&/, sel))).reduce((a2, b) => a2.concat(b)),
              value,
              target
            );
          } else if (value && typeof value == "object") {
            if (!isAt)
              throw new RangeError("The value of a property (" + prop + ") should be a primitive value.");
            render(splitSelector(prop), value, local, keyframes2);
          } else if (value != null) {
            local.push(prop.replace(/_.*/, "").replace(/[A-Z]/g, (l) => "-" + l.toLowerCase()) + ": " + value + ";");
          }
        }
        if (local.length || keyframes2) {
          target.push((finish && !isAt && !isKeyframes ? selectors.map(finish) : selectors).join(", ") + " {" + local.join(" ") + "}");
        }
      }
      for (let prop in spec)
        render(splitSelector(prop), spec[prop], this.rules);
    }
    // :: () → string
    // Returns a string containing the module's CSS rules.
    getRules() {
      return this.rules.join("\n");
    }
    // :: () → string
    // Generate a new unique CSS class name.
    static newName() {
      let id = top$1[COUNT] || 1;
      top$1[COUNT] = id + 1;
      return C + id.toString(36);
    }
    // :: (union<Document, ShadowRoot>, union<[StyleModule], StyleModule>, ?{nonce: ?string})
    //
    // Mount the given set of modules in the given DOM root, which ensures
    // that the CSS rules defined by the module are available in that
    // context.
    //
    // Rules are only added to the document once per root.
    //
    // Rule order will follow the order of the modules, so that rules from
    // modules later in the array take precedence of those from earlier
    // modules. If you call this function multiple times for the same root
    // in a way that changes the order of already mounted modules, the old
    // order will be changed.
    //
    // If a Content Security Policy nonce is provided, it is added to
    // the `<style>` tag generated by the library.
    static mount(root, modules, options) {
      let set = root[SET], nonce = options && options.nonce;
      if (!set)
        set = new StyleSet(root, nonce);
      else if (nonce)
        set.setNonce(nonce);
      set.mount(Array.isArray(modules) ? modules : [modules], root);
    }
  }
  let adoptedSet = /* @__PURE__ */ new Map();
  class StyleSet {
    constructor(root, nonce) {
      let doc2 = root.ownerDocument || root, win = doc2.defaultView;
      if (!root.head && root.adoptedStyleSheets && win.CSSStyleSheet) {
        let adopted = adoptedSet.get(doc2);
        if (adopted)
          return root[SET] = adopted;
        this.sheet = new win.CSSStyleSheet();
        adoptedSet.set(doc2, this);
      } else {
        this.styleTag = doc2.createElement("style");
        if (nonce)
          this.styleTag.setAttribute("nonce", nonce);
      }
      this.modules = [];
      root[SET] = this;
    }
    mount(modules, root) {
      let sheet = this.sheet;
      let pos = 0, j = 0;
      for (let i2 = 0; i2 < modules.length; i2++) {
        let mod = modules[i2], index = this.modules.indexOf(mod);
        if (index < j && index > -1) {
          this.modules.splice(index, 1);
          j--;
          index = -1;
        }
        if (index == -1) {
          this.modules.splice(j++, 0, mod);
          if (sheet)
            for (let k = 0; k < mod.rules.length; k++)
              sheet.insertRule(mod.rules[k], pos++);
        } else {
          while (j < index)
            pos += this.modules[j++].rules.length;
          pos += mod.rules.length;
          j++;
        }
      }
      if (sheet) {
        if (root.adoptedStyleSheets.indexOf(this.sheet) < 0)
          root.adoptedStyleSheets = [this.sheet, ...root.adoptedStyleSheets];
      } else {
        let text = "";
        for (let i2 = 0; i2 < this.modules.length; i2++)
          text += this.modules[i2].getRules() + "\n";
        this.styleTag.textContent = text;
        let target = root.head || root;
        if (this.styleTag.parentNode != target)
          target.insertBefore(this.styleTag, target.firstChild);
      }
    }
    setNonce(nonce) {
      if (this.styleTag && this.styleTag.getAttribute("nonce") != nonce)
        this.styleTag.setAttribute("nonce", nonce);
    }
  }
  var base = {
    8: "Backspace",
    9: "Tab",
    10: "Enter",
    12: "NumLock",
    13: "Enter",
    16: "Shift",
    17: "Control",
    18: "Alt",
    20: "CapsLock",
    27: "Escape",
    32: " ",
    33: "PageUp",
    34: "PageDown",
    35: "End",
    36: "Home",
    37: "ArrowLeft",
    38: "ArrowUp",
    39: "ArrowRight",
    40: "ArrowDown",
    44: "PrintScreen",
    45: "Insert",
    46: "Delete",
    59: ";",
    61: "=",
    91: "Meta",
    92: "Meta",
    106: "*",
    107: "+",
    108: ",",
    109: "-",
    110: ".",
    111: "/",
    144: "NumLock",
    145: "ScrollLock",
    160: "Shift",
    161: "Shift",
    162: "Control",
    163: "Control",
    164: "Alt",
    165: "Alt",
    173: "-",
    186: ";",
    187: "=",
    188: ",",
    189: "-",
    190: ".",
    191: "/",
    192: "`",
    219: "[",
    220: "\\",
    221: "]",
    222: "'"
  };
  var shift = {
    48: ")",
    49: "!",
    50: "@",
    51: "#",
    52: "$",
    53: "%",
    54: "^",
    55: "&",
    56: "*",
    57: "(",
    59: ":",
    61: "+",
    173: "_",
    186: ":",
    187: "+",
    188: "<",
    189: "_",
    190: ">",
    191: "?",
    192: "~",
    219: "{",
    220: "|",
    221: "}",
    222: '"'
  };
  var mac = typeof navigator != "undefined" && /Mac/.test(navigator.platform);
  var ie$3 = typeof navigator != "undefined" && /MSIE \d|Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(navigator.userAgent);
  for (var i$1 = 0; i$1 < 10; i$1++)
    base[48 + i$1] = base[96 + i$1] = String(i$1);
  for (var i$1 = 1; i$1 <= 24; i$1++)
    base[i$1 + 111] = "F" + i$1;
  for (var i$1 = 65; i$1 <= 90; i$1++) {
    base[i$1] = String.fromCharCode(i$1 + 32);
    shift[i$1] = String.fromCharCode(i$1);
  }
  for (var code in base)
    if (!shift.hasOwnProperty(code))
      shift[code] = base[code];
  function keyName(event) {
    var ignoreKey = mac && event.metaKey && event.shiftKey && !event.ctrlKey && !event.altKey || ie$3 && event.shiftKey && event.key && event.key.length == 1 || event.key == "Unidentified";
    var name2 = !ignoreKey && event.key || (event.shiftKey ? shift : base)[event.keyCode] || event.key || "Unidentified";
    if (name2 == "Esc")
      name2 = "Escape";
    if (name2 == "Del")
      name2 = "Delete";
    if (name2 == "Left")
      name2 = "ArrowLeft";
    if (name2 == "Up")
      name2 = "ArrowUp";
    if (name2 == "Right")
      name2 = "ArrowRight";
    if (name2 == "Down")
      name2 = "ArrowDown";
    return name2;
  }
  function getSelection$2(root) {
    let target;
    if (root.nodeType == 11) {
      target = root.getSelection ? root : root.ownerDocument;
    } else {
      target = root;
    }
    return target.getSelection();
  }
  function contains$2(dom, node2) {
    return node2 ? dom == node2 || dom.contains(node2.nodeType != 1 ? node2.parentNode : node2) : false;
  }
  function hasSelection$1(dom, selection) {
    if (!selection.anchorNode)
      return false;
    try {
      return contains$2(dom, selection.anchorNode);
    } catch (_2) {
      return false;
    }
  }
  function clientRectsFor$1(dom) {
    if (dom.nodeType == 3)
      return textRange$1(dom, 0, dom.nodeValue.length).getClientRects();
    else if (dom.nodeType == 1)
      return dom.getClientRects();
    else
      return [];
  }
  function isEquivalentPosition$1(node2, off, targetNode, targetOff) {
    return targetNode ? scanFor$1(node2, off, targetNode, targetOff, -1) || scanFor$1(node2, off, targetNode, targetOff, 1) : false;
  }
  function domIndex$1(node2) {
    for (var index = 0; ; index++) {
      node2 = node2.previousSibling;
      if (!node2)
        return index;
    }
  }
  function isBlockElement$1(node2) {
    return node2.nodeType == 1 && /^(DIV|P|LI|UL|OL|BLOCKQUOTE|DD|DT|H\d|SECTION|PRE)$/.test(node2.nodeName);
  }
  function scanFor$1(node2, off, targetNode, targetOff, dir) {
    for (; ; ) {
      if (node2 == targetNode && off == targetOff)
        return true;
      if (off == (dir < 0 ? 0 : maxOffset$1(node2))) {
        if (node2.nodeName == "DIV")
          return false;
        let parent = node2.parentNode;
        if (!parent || parent.nodeType != 1)
          return false;
        off = domIndex$1(node2) + (dir < 0 ? 0 : 1);
        node2 = parent;
      } else if (node2.nodeType == 1) {
        node2 = node2.childNodes[off + (dir < 0 ? -1 : 0)];
        if (node2.nodeType == 1 && node2.contentEditable == "false")
          return false;
        off = dir < 0 ? maxOffset$1(node2) : 0;
      } else {
        return false;
      }
    }
  }
  function maxOffset$1(node2) {
    return node2.nodeType == 3 ? node2.nodeValue.length : node2.childNodes.length;
  }
  function flattenRect$1(rect, left2) {
    let x2 = left2 ? rect.left : rect.right;
    return { left: x2, right: x2, top: rect.top, bottom: rect.bottom };
  }
  function windowRect$1(win) {
    let vp = win.visualViewport;
    if (vp)
      return {
        left: 0,
        right: vp.width,
        top: 0,
        bottom: vp.height
      };
    return {
      left: 0,
      right: win.innerWidth,
      top: 0,
      bottom: win.innerHeight
    };
  }
  function getScale$2(elt, rect) {
    let scaleX = rect.width / elt.offsetWidth;
    let scaleY = rect.height / elt.offsetHeight;
    if (scaleX > 0.995 && scaleX < 1.005 || !isFinite(scaleX) || Math.abs(rect.width - elt.offsetWidth) < 1)
      scaleX = 1;
    if (scaleY > 0.995 && scaleY < 1.005 || !isFinite(scaleY) || Math.abs(rect.height - elt.offsetHeight) < 1)
      scaleY = 1;
    return { scaleX, scaleY };
  }
  function scrollRectIntoView$1(dom, rect, side, x2, y, xMargin, yMargin, ltr) {
    let doc2 = dom.ownerDocument, win = doc2.defaultView || window;
    for (let cur = dom, stop = false; cur && !stop; ) {
      if (cur.nodeType == 1) {
        let bounding, top2 = cur == doc2.body;
        let scaleX = 1, scaleY = 1;
        if (top2) {
          bounding = windowRect$1(win);
        } else {
          if (/^(fixed|sticky)$/.test(getComputedStyle(cur).position))
            stop = true;
          if (cur.scrollHeight <= cur.clientHeight && cur.scrollWidth <= cur.clientWidth) {
            cur = cur.assignedSlot || cur.parentNode;
            continue;
          }
          let rect2 = cur.getBoundingClientRect();
          ({ scaleX, scaleY } = getScale$2(cur, rect2));
          bounding = {
            left: rect2.left,
            right: rect2.left + cur.clientWidth * scaleX,
            top: rect2.top,
            bottom: rect2.top + cur.clientHeight * scaleY
          };
        }
        let moveX = 0, moveY = 0;
        if (y == "nearest") {
          if (rect.top < bounding.top) {
            moveY = -(bounding.top - rect.top + yMargin);
            if (side > 0 && rect.bottom > bounding.bottom + moveY)
              moveY = rect.bottom - bounding.bottom + moveY + yMargin;
          } else if (rect.bottom > bounding.bottom) {
            moveY = rect.bottom - bounding.bottom + yMargin;
            if (side < 0 && rect.top - moveY < bounding.top)
              moveY = -(bounding.top + moveY - rect.top + yMargin);
          }
        } else {
          let rectHeight = rect.bottom - rect.top, boundingHeight = bounding.bottom - bounding.top;
          let targetTop = y == "center" && rectHeight <= boundingHeight ? rect.top + rectHeight / 2 - boundingHeight / 2 : y == "start" || y == "center" && side < 0 ? rect.top - yMargin : rect.bottom - boundingHeight + yMargin;
          moveY = targetTop - bounding.top;
        }
        if (x2 == "nearest") {
          if (rect.left < bounding.left) {
            moveX = -(bounding.left - rect.left + xMargin);
            if (side > 0 && rect.right > bounding.right + moveX)
              moveX = rect.right - bounding.right + moveX + xMargin;
          } else if (rect.right > bounding.right) {
            moveX = rect.right - bounding.right + xMargin;
            if (side < 0 && rect.left < bounding.left + moveX)
              moveX = -(bounding.left + moveX - rect.left + xMargin);
          }
        } else {
          let targetLeft = x2 == "center" ? rect.left + (rect.right - rect.left) / 2 - (bounding.right - bounding.left) / 2 : x2 == "start" == ltr ? rect.left - xMargin : rect.right - (bounding.right - bounding.left) + xMargin;
          moveX = targetLeft - bounding.left;
        }
        if (moveX || moveY) {
          if (top2) {
            win.scrollBy(moveX, moveY);
          } else {
            let movedX = 0, movedY = 0;
            if (moveY) {
              let start2 = cur.scrollTop;
              cur.scrollTop += moveY / scaleY;
              movedY = (cur.scrollTop - start2) * scaleY;
            }
            if (moveX) {
              let start2 = cur.scrollLeft;
              cur.scrollLeft += moveX / scaleX;
              movedX = (cur.scrollLeft - start2) * scaleX;
            }
            rect = {
              left: rect.left - movedX,
              top: rect.top - movedY,
              right: rect.right - movedX,
              bottom: rect.bottom - movedY
            };
            if (movedX && Math.abs(movedX - moveX) < 1)
              x2 = "nearest";
            if (movedY && Math.abs(movedY - moveY) < 1)
              y = "nearest";
          }
        }
        if (top2)
          break;
        cur = cur.assignedSlot || cur.parentNode;
      } else if (cur.nodeType == 11) {
        cur = cur.host;
      } else {
        break;
      }
    }
  }
  function scrollableParents$1(dom) {
    let doc2 = dom.ownerDocument, x2, y;
    for (let cur = dom.parentNode; cur; ) {
      if (cur == doc2.body || x2 && y) {
        break;
      } else if (cur.nodeType == 1) {
        if (!y && cur.scrollHeight > cur.clientHeight)
          y = cur;
        if (!x2 && cur.scrollWidth > cur.clientWidth)
          x2 = cur;
        cur = cur.assignedSlot || cur.parentNode;
      } else if (cur.nodeType == 11) {
        cur = cur.host;
      } else {
        break;
      }
    }
    return { x: x2, y };
  }
  let DOMSelectionState$1 = class DOMSelectionState {
    constructor() {
      this.anchorNode = null;
      this.anchorOffset = 0;
      this.focusNode = null;
      this.focusOffset = 0;
    }
    eq(domSel) {
      return this.anchorNode == domSel.anchorNode && this.anchorOffset == domSel.anchorOffset && this.focusNode == domSel.focusNode && this.focusOffset == domSel.focusOffset;
    }
    setRange(range) {
      let { anchorNode, focusNode } = range;
      this.set(anchorNode, Math.min(range.anchorOffset, anchorNode ? maxOffset$1(anchorNode) : 0), focusNode, Math.min(range.focusOffset, focusNode ? maxOffset$1(focusNode) : 0));
    }
    set(anchorNode, anchorOffset, focusNode, focusOffset) {
      this.anchorNode = anchorNode;
      this.anchorOffset = anchorOffset;
      this.focusNode = focusNode;
      this.focusOffset = focusOffset;
    }
  };
  let preventScrollSupported$1 = null;
  function focusPreventScroll$1(dom) {
    if (dom.setActive)
      return dom.setActive();
    if (preventScrollSupported$1)
      return dom.focus(preventScrollSupported$1);
    let stack = [];
    for (let cur = dom; cur; cur = cur.parentNode) {
      stack.push(cur, cur.scrollTop, cur.scrollLeft);
      if (cur == cur.ownerDocument)
        break;
    }
    dom.focus(preventScrollSupported$1 == null ? {
      get preventScroll() {
        preventScrollSupported$1 = { preventScroll: true };
        return true;
      }
    } : void 0);
    if (!preventScrollSupported$1) {
      preventScrollSupported$1 = false;
      for (let i2 = 0; i2 < stack.length; ) {
        let elt = stack[i2++], top2 = stack[i2++], left2 = stack[i2++];
        if (elt.scrollTop != top2)
          elt.scrollTop = top2;
        if (elt.scrollLeft != left2)
          elt.scrollLeft = left2;
      }
    }
  }
  let scratchRange$1;
  function textRange$1(node2, from2, to = from2) {
    let range = scratchRange$1 || (scratchRange$1 = document.createRange());
    range.setEnd(node2, to);
    range.setStart(node2, from2);
    return range;
  }
  function dispatchKey$1(elt, name2, code2, mods) {
    let options = { key: name2, code: name2, keyCode: code2, which: code2, cancelable: true };
    if (mods)
      ({ altKey: options.altKey, ctrlKey: options.ctrlKey, shiftKey: options.shiftKey, metaKey: options.metaKey } = mods);
    let down = new KeyboardEvent("keydown", options);
    down.synthetic = true;
    elt.dispatchEvent(down);
    let up = new KeyboardEvent("keyup", options);
    up.synthetic = true;
    elt.dispatchEvent(up);
    return down.defaultPrevented || up.defaultPrevented;
  }
  function getRoot$1(node2) {
    while (node2) {
      if (node2 && (node2.nodeType == 9 || node2.nodeType == 11 && node2.host))
        return node2;
      node2 = node2.assignedSlot || node2.parentNode;
    }
    return null;
  }
  function clearAttributes$1(node2) {
    while (node2.attributes.length)
      node2.removeAttributeNode(node2.attributes[0]);
  }
  function atElementStart$1(doc2, selection) {
    let node2 = selection.focusNode, offset2 = selection.focusOffset;
    if (!node2 || selection.anchorNode != node2 || selection.anchorOffset != offset2)
      return false;
    offset2 = Math.min(offset2, maxOffset$1(node2));
    for (; ; ) {
      if (offset2) {
        if (node2.nodeType != 1)
          return false;
        let prev2 = node2.childNodes[offset2 - 1];
        if (prev2.contentEditable == "false")
          offset2--;
        else {
          node2 = prev2;
          offset2 = maxOffset$1(node2);
        }
      } else if (node2 == doc2) {
        return true;
      } else {
        offset2 = domIndex$1(node2);
        node2 = node2.parentNode;
      }
    }
  }
  function isScrolledToBottom$1(elt) {
    return elt.scrollTop > Math.max(1, elt.scrollHeight - elt.clientHeight - 4);
  }
  function textNodeBefore$1(startNode, startOffset) {
    for (let node2 = startNode, offset2 = startOffset; ; ) {
      if (node2.nodeType == 3 && offset2 > 0) {
        return { node: node2, offset: offset2 };
      } else if (node2.nodeType == 1 && offset2 > 0) {
        if (node2.contentEditable == "false")
          return null;
        node2 = node2.childNodes[offset2 - 1];
        offset2 = maxOffset$1(node2);
      } else if (node2.parentNode && !isBlockElement$1(node2)) {
        offset2 = domIndex$1(node2);
        node2 = node2.parentNode;
      } else {
        return null;
      }
    }
  }
  function textNodeAfter$1(startNode, startOffset) {
    for (let node2 = startNode, offset2 = startOffset; ; ) {
      if (node2.nodeType == 3 && offset2 < node2.nodeValue.length) {
        return { node: node2, offset: offset2 };
      } else if (node2.nodeType == 1 && offset2 < node2.childNodes.length) {
        if (node2.contentEditable == "false")
          return null;
        node2 = node2.childNodes[offset2];
        offset2 = 0;
      } else if (node2.parentNode && !isBlockElement$1(node2)) {
        offset2 = domIndex$1(node2) + 1;
        node2 = node2.parentNode;
      } else {
        return null;
      }
    }
  }
  let DOMPos$1 = class DOMPos2 {
    constructor(node2, offset2, precise = true) {
      this.node = node2;
      this.offset = offset2;
      this.precise = precise;
    }
    static before(dom, precise) {
      return new DOMPos2(dom.parentNode, domIndex$1(dom), precise);
    }
    static after(dom, precise) {
      return new DOMPos2(dom.parentNode, domIndex$1(dom) + 1, precise);
    }
  };
  const noChildren$1 = [];
  let ContentView$1 = class ContentView2 {
    constructor() {
      this.parent = null;
      this.dom = null;
      this.flags = 2;
    }
    get overrideDOMText() {
      return null;
    }
    get posAtStart() {
      return this.parent ? this.parent.posBefore(this) : 0;
    }
    get posAtEnd() {
      return this.posAtStart + this.length;
    }
    posBefore(view) {
      let pos = this.posAtStart;
      for (let child of this.children) {
        if (child == view)
          return pos;
        pos += child.length + child.breakAfter;
      }
      throw new RangeError("Invalid child in posBefore");
    }
    posAfter(view) {
      return this.posBefore(view) + view.length;
    }
    sync(view, track) {
      if (this.flags & 2) {
        let parent = this.dom;
        let prev2 = null, next2;
        for (let child of this.children) {
          if (child.flags & 7) {
            if (!child.dom && (next2 = prev2 ? prev2.nextSibling : parent.firstChild)) {
              let contentView = ContentView2.get(next2);
              if (!contentView || !contentView.parent && contentView.canReuseDOM(child))
                child.reuseDOM(next2);
            }
            child.sync(view, track);
            child.flags &= ~7;
          }
          next2 = prev2 ? prev2.nextSibling : parent.firstChild;
          if (track && !track.written && track.node == parent && next2 != child.dom)
            track.written = true;
          if (child.dom.parentNode == parent) {
            while (next2 && next2 != child.dom)
              next2 = rm$1$1(next2);
          } else {
            parent.insertBefore(child.dom, next2);
          }
          prev2 = child.dom;
        }
        next2 = prev2 ? prev2.nextSibling : parent.firstChild;
        if (next2 && track && track.node == parent)
          track.written = true;
        while (next2)
          next2 = rm$1$1(next2);
      } else if (this.flags & 1) {
        for (let child of this.children)
          if (child.flags & 7) {
            child.sync(view, track);
            child.flags &= ~7;
          }
      }
    }
    reuseDOM(_dom) {
    }
    localPosFromDOM(node2, offset2) {
      let after;
      if (node2 == this.dom) {
        after = this.dom.childNodes[offset2];
      } else {
        let bias = maxOffset$1(node2) == 0 ? 0 : offset2 == 0 ? -1 : 1;
        for (; ; ) {
          let parent = node2.parentNode;
          if (parent == this.dom)
            break;
          if (bias == 0 && parent.firstChild != parent.lastChild) {
            if (node2 == parent.firstChild)
              bias = -1;
            else
              bias = 1;
          }
          node2 = parent;
        }
        if (bias < 0)
          after = node2;
        else
          after = node2.nextSibling;
      }
      if (after == this.dom.firstChild)
        return 0;
      while (after && !ContentView2.get(after))
        after = after.nextSibling;
      if (!after)
        return this.length;
      for (let i2 = 0, pos = 0; ; i2++) {
        let child = this.children[i2];
        if (child.dom == after)
          return pos;
        pos += child.length + child.breakAfter;
      }
    }
    domBoundsAround(from2, to, offset2 = 0) {
      let fromI = -1, fromStart = -1, toI = -1, toEnd = -1;
      for (let i2 = 0, pos = offset2, prevEnd = offset2; i2 < this.children.length; i2++) {
        let child = this.children[i2], end2 = pos + child.length;
        if (pos < from2 && end2 > to)
          return child.domBoundsAround(from2, to, pos);
        if (end2 >= from2 && fromI == -1) {
          fromI = i2;
          fromStart = pos;
        }
        if (pos > to && child.dom.parentNode == this.dom) {
          toI = i2;
          toEnd = prevEnd;
          break;
        }
        prevEnd = end2;
        pos = end2 + child.breakAfter;
      }
      return {
        from: fromStart,
        to: toEnd < 0 ? offset2 + this.length : toEnd,
        startDOM: (fromI ? this.children[fromI - 1].dom.nextSibling : null) || this.dom.firstChild,
        endDOM: toI < this.children.length && toI >= 0 ? this.children[toI].dom : null
      };
    }
    markDirty(andParent = false) {
      this.flags |= 2;
      this.markParentsDirty(andParent);
    }
    markParentsDirty(childList) {
      for (let parent = this.parent; parent; parent = parent.parent) {
        if (childList)
          parent.flags |= 2;
        if (parent.flags & 1)
          return;
        parent.flags |= 1;
        childList = false;
      }
    }
    setParent(parent) {
      if (this.parent != parent) {
        this.parent = parent;
        if (this.flags & 7)
          this.markParentsDirty(true);
      }
    }
    setDOM(dom) {
      if (this.dom == dom)
        return;
      if (this.dom)
        this.dom.cmView = null;
      this.dom = dom;
      dom.cmView = this;
    }
    get rootView() {
      for (let v2 = this; ; ) {
        let parent = v2.parent;
        if (!parent)
          return v2;
        v2 = parent;
      }
    }
    replaceChildren(from2, to, children = noChildren$1) {
      this.markDirty();
      for (let i2 = from2; i2 < to; i2++) {
        let child = this.children[i2];
        if (child.parent == this && children.indexOf(child) < 0)
          child.destroy();
      }
      if (children.length < 250)
        this.children.splice(from2, to - from2, ...children);
      else
        this.children = [].concat(this.children.slice(0, from2), children, this.children.slice(to));
      for (let i2 = 0; i2 < children.length; i2++)
        children[i2].setParent(this);
    }
    ignoreMutation(_rec) {
      return false;
    }
    ignoreEvent(_event) {
      return false;
    }
    childCursor(pos = this.length) {
      return new ChildCursor$1(this.children, pos, this.children.length);
    }
    childPos(pos, bias = 1) {
      return this.childCursor().findPos(pos, bias);
    }
    toString() {
      let name2 = this.constructor.name.replace("View", "");
      return name2 + (this.children.length ? "(" + this.children.join() + ")" : this.length ? "[" + (name2 == "Text" ? this.text : this.length) + "]" : "") + (this.breakAfter ? "#" : "");
    }
    static get(node2) {
      return node2.cmView;
    }
    get isEditable() {
      return true;
    }
    get isWidget() {
      return false;
    }
    get isHidden() {
      return false;
    }
    merge(from2, to, source, hasStart, openStart, openEnd) {
      return false;
    }
    become(other) {
      return false;
    }
    canReuseDOM(other) {
      return other.constructor == this.constructor && !((this.flags | other.flags) & 8);
    }
    // When this is a zero-length view with a side, this should return a
    // number <= 0 to indicate it is before its position, or a
    // number > 0 when after its position.
    getSide() {
      return 0;
    }
    destroy() {
      for (let child of this.children)
        if (child.parent == this)
          child.destroy();
      this.parent = null;
    }
  };
  ContentView$1.prototype.breakAfter = 0;
  function rm$1$1(dom) {
    let next2 = dom.nextSibling;
    dom.parentNode.removeChild(dom);
    return next2;
  }
  let ChildCursor$1 = class ChildCursor {
    constructor(children, pos, i2) {
      this.children = children;
      this.pos = pos;
      this.i = i2;
      this.off = 0;
    }
    findPos(pos, bias = 1) {
      for (; ; ) {
        if (pos > this.pos || pos == this.pos && (bias > 0 || this.i == 0 || this.children[this.i - 1].breakAfter)) {
          this.off = pos - this.pos;
          return this;
        }
        let next2 = this.children[--this.i];
        this.pos -= next2.length + next2.breakAfter;
      }
    }
  };
  function replaceRange$1(parent, fromI, fromOff, toI, toOff, insert2, breakAtStart, openStart, openEnd) {
    let { children } = parent;
    let before = children.length ? children[fromI] : null;
    let last = insert2.length ? insert2[insert2.length - 1] : null;
    let breakAtEnd = last ? last.breakAfter : breakAtStart;
    if (fromI == toI && before && !breakAtStart && !breakAtEnd && insert2.length < 2 && before.merge(fromOff, toOff, insert2.length ? last : null, fromOff == 0, openStart, openEnd))
      return;
    if (toI < children.length) {
      let after = children[toI];
      if (after && (toOff < after.length || after.breakAfter && (last === null || last === void 0 ? void 0 : last.breakAfter))) {
        if (fromI == toI) {
          after = after.split(toOff);
          toOff = 0;
        }
        if (!breakAtEnd && last && after.merge(0, toOff, last, true, 0, openEnd)) {
          insert2[insert2.length - 1] = after;
        } else {
          if (toOff || after.children.length && !after.children[0].length)
            after.merge(0, toOff, null, false, 0, openEnd);
          insert2.push(after);
        }
      } else if (after === null || after === void 0 ? void 0 : after.breakAfter) {
        if (last)
          last.breakAfter = 1;
        else
          breakAtStart = 1;
      }
      toI++;
    }
    if (before) {
      before.breakAfter = breakAtStart;
      if (fromOff > 0) {
        if (!breakAtStart && insert2.length && before.merge(fromOff, before.length, insert2[0], false, openStart, 0)) {
          before.breakAfter = insert2.shift().breakAfter;
        } else if (fromOff < before.length || before.children.length && before.children[before.children.length - 1].length == 0) {
          before.merge(fromOff, before.length, null, false, openStart, 0);
        }
        fromI++;
      }
    }
    while (fromI < toI && insert2.length) {
      if (children[toI - 1].become(insert2[insert2.length - 1])) {
        toI--;
        insert2.pop();
        openEnd = insert2.length ? 0 : openStart;
      } else if (children[fromI].become(insert2[0])) {
        fromI++;
        insert2.shift();
        openStart = insert2.length ? 0 : openEnd;
      } else {
        break;
      }
    }
    if (!insert2.length && fromI && toI < children.length && !children[fromI - 1].breakAfter && children[toI].merge(0, 0, children[fromI - 1], false, openStart, openEnd))
      fromI--;
    if (fromI < toI || insert2.length)
      parent.replaceChildren(fromI, toI, insert2);
  }
  function mergeChildrenInto$1(parent, from2, to, insert2, openStart, openEnd) {
    let cur = parent.childCursor();
    let { i: toI, off: toOff } = cur.findPos(to, 1);
    let { i: fromI, off: fromOff } = cur.findPos(from2, -1);
    let dLen = from2 - to;
    for (let view of insert2)
      dLen += view.length;
    parent.length += dLen;
    replaceRange$1(parent, fromI, fromOff, toI, toOff, insert2, 0, openStart, openEnd);
  }
  let nav$1 = typeof navigator != "undefined" ? navigator : { userAgent: "", vendor: "", platform: "" };
  let doc$1 = typeof document != "undefined" ? document : { documentElement: { style: {} } };
  const ie_edge$1 = /* @__PURE__ */ /Edge\/(\d+)/.exec(nav$1.userAgent);
  const ie_upto10$1 = /* @__PURE__ */ /MSIE \d/.test(nav$1.userAgent);
  const ie_11up$1 = /* @__PURE__ */ /Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(nav$1.userAgent);
  const ie$2 = !!(ie_upto10$1 || ie_11up$1 || ie_edge$1);
  const gecko$1 = !ie$2 && /* @__PURE__ */ /gecko\/(\d+)/i.test(nav$1.userAgent);
  const chrome$1 = !ie$2 && /* @__PURE__ */ /Chrome\/(\d+)/.exec(nav$1.userAgent);
  const webkit$1 = "webkitFontSmoothing" in doc$1.documentElement.style;
  const safari$1 = !ie$2 && /* @__PURE__ */ /Apple Computer/.test(nav$1.vendor);
  const ios$1 = safari$1 && (/* @__PURE__ */ /Mobile\/\w+/.test(nav$1.userAgent) || nav$1.maxTouchPoints > 2);
  var browser$1 = {
    mac: ios$1 || /* @__PURE__ */ /Mac/.test(nav$1.platform),
    windows: /* @__PURE__ */ /Win/.test(nav$1.platform),
    linux: /* @__PURE__ */ /Linux|X11/.test(nav$1.platform),
    ie: ie$2,
    ie_version: ie_upto10$1 ? doc$1.documentMode || 6 : ie_11up$1 ? +ie_11up$1[1] : ie_edge$1 ? +ie_edge$1[1] : 0,
    gecko: gecko$1,
    gecko_version: gecko$1 ? +(/* @__PURE__ */ /Firefox\/(\d+)/.exec(nav$1.userAgent) || [0, 0])[1] : 0,
    chrome: !!chrome$1,
    chrome_version: chrome$1 ? +chrome$1[1] : 0,
    ios: ios$1,
    android: /* @__PURE__ */ /Android\b/.test(nav$1.userAgent),
    webkit: webkit$1,
    safari: safari$1,
    webkit_version: webkit$1 ? +(/* @__PURE__ */ /\bAppleWebKit\/(\d+)/.exec(nav$1.userAgent) || [0, 0])[1] : 0,
    tabSize: doc$1.documentElement.style.tabSize != null ? "tab-size" : "-moz-tab-size"
  };
  const MaxJoinLen$1 = 256;
  let TextView$1 = class TextView2 extends ContentView$1 {
    constructor(text) {
      super();
      this.text = text;
    }
    get length() {
      return this.text.length;
    }
    createDOM(textDOM) {
      this.setDOM(textDOM || document.createTextNode(this.text));
    }
    sync(view, track) {
      if (!this.dom)
        this.createDOM();
      if (this.dom.nodeValue != this.text) {
        if (track && track.node == this.dom)
          track.written = true;
        this.dom.nodeValue = this.text;
      }
    }
    reuseDOM(dom) {
      if (dom.nodeType == 3)
        this.createDOM(dom);
    }
    merge(from2, to, source) {
      if (this.flags & 8 || source && (!(source instanceof TextView2) || this.length - (to - from2) + source.length > MaxJoinLen$1 || source.flags & 8))
        return false;
      this.text = this.text.slice(0, from2) + (source ? source.text : "") + this.text.slice(to);
      this.markDirty();
      return true;
    }
    split(from2) {
      let result = new TextView2(this.text.slice(from2));
      this.text = this.text.slice(0, from2);
      this.markDirty();
      result.flags |= this.flags & 8;
      return result;
    }
    localPosFromDOM(node2, offset2) {
      return node2 == this.dom ? offset2 : offset2 ? this.text.length : 0;
    }
    domAtPos(pos) {
      return new DOMPos$1(this.dom, pos);
    }
    domBoundsAround(_from, _to, offset2) {
      return { from: offset2, to: offset2 + this.length, startDOM: this.dom, endDOM: this.dom.nextSibling };
    }
    coordsAt(pos, side) {
      return textCoords$1(this.dom, pos, side);
    }
  };
  let MarkView$1 = class MarkView2 extends ContentView$1 {
    constructor(mark, children = [], length2 = 0) {
      super();
      this.mark = mark;
      this.children = children;
      this.length = length2;
      for (let ch of children)
        ch.setParent(this);
    }
    setAttrs(dom) {
      clearAttributes$1(dom);
      if (this.mark.class)
        dom.className = this.mark.class;
      if (this.mark.attrs)
        for (let name2 in this.mark.attrs)
          dom.setAttribute(name2, this.mark.attrs[name2]);
      return dom;
    }
    canReuseDOM(other) {
      return super.canReuseDOM(other) && !((this.flags | other.flags) & 8);
    }
    reuseDOM(node2) {
      if (node2.nodeName == this.mark.tagName.toUpperCase()) {
        this.setDOM(node2);
        this.flags |= 4 | 2;
      }
    }
    sync(view, track) {
      if (!this.dom)
        this.setDOM(this.setAttrs(document.createElement(this.mark.tagName)));
      else if (this.flags & 4)
        this.setAttrs(this.dom);
      super.sync(view, track);
    }
    merge(from2, to, source, _hasStart, openStart, openEnd) {
      if (source && (!(source instanceof MarkView2 && source.mark.eq(this.mark)) || from2 && openStart <= 0 || to < this.length && openEnd <= 0))
        return false;
      mergeChildrenInto$1(this, from2, to, source ? source.children.slice() : [], openStart - 1, openEnd - 1);
      this.markDirty();
      return true;
    }
    split(from2) {
      let result = [], off = 0, detachFrom = -1, i2 = 0;
      for (let elt of this.children) {
        let end2 = off + elt.length;
        if (end2 > from2)
          result.push(off < from2 ? elt.split(from2 - off) : elt);
        if (detachFrom < 0 && off >= from2)
          detachFrom = i2;
        off = end2;
        i2++;
      }
      let length2 = this.length - from2;
      this.length = from2;
      if (detachFrom > -1) {
        this.children.length = detachFrom;
        this.markDirty();
      }
      return new MarkView2(this.mark, result, length2);
    }
    domAtPos(pos) {
      return inlineDOMAtPos$1(this, pos);
    }
    coordsAt(pos, side) {
      return coordsInChildren$1(this, pos, side);
    }
  };
  function textCoords$1(text, pos, side) {
    let length2 = text.nodeValue.length;
    if (pos > length2)
      pos = length2;
    let from2 = pos, to = pos, flatten2 = 0;
    if (pos == 0 && side < 0 || pos == length2 && side >= 0) {
      if (!(browser$1.chrome || browser$1.gecko)) {
        if (pos) {
          from2--;
          flatten2 = 1;
        } else if (to < length2) {
          to++;
          flatten2 = -1;
        }
      }
    } else {
      if (side < 0)
        from2--;
      else if (to < length2)
        to++;
    }
    let rects = textRange$1(text, from2, to).getClientRects();
    if (!rects.length)
      return null;
    let rect = rects[(flatten2 ? flatten2 < 0 : side >= 0) ? 0 : rects.length - 1];
    if (browser$1.safari && !flatten2 && rect.width == 0)
      rect = Array.prototype.find.call(rects, (r2) => r2.width) || rect;
    return flatten2 ? flattenRect$1(rect, flatten2 < 0) : rect || null;
  }
  let WidgetView$1 = class WidgetView2 extends ContentView$1 {
    static create(widget, length2, side) {
      return new WidgetView2(widget, length2, side);
    }
    constructor(widget, length2, side) {
      super();
      this.widget = widget;
      this.length = length2;
      this.side = side;
      this.prevWidget = null;
    }
    split(from2) {
      let result = WidgetView2.create(this.widget, this.length - from2, this.side);
      this.length -= from2;
      return result;
    }
    sync(view) {
      if (!this.dom || !this.widget.updateDOM(this.dom, view)) {
        if (this.dom && this.prevWidget)
          this.prevWidget.destroy(this.dom);
        this.prevWidget = null;
        this.setDOM(this.widget.toDOM(view));
        if (!this.widget.editable)
          this.dom.contentEditable = "false";
      }
    }
    getSide() {
      return this.side;
    }
    merge(from2, to, source, hasStart, openStart, openEnd) {
      if (source && (!(source instanceof WidgetView2) || !this.widget.compare(source.widget) || from2 > 0 && openStart <= 0 || to < this.length && openEnd <= 0))
        return false;
      this.length = from2 + (source ? source.length : 0) + (this.length - to);
      return true;
    }
    become(other) {
      if (other instanceof WidgetView2 && other.side == this.side && this.widget.constructor == other.widget.constructor) {
        if (!this.widget.compare(other.widget))
          this.markDirty(true);
        if (this.dom && !this.prevWidget)
          this.prevWidget = this.widget;
        this.widget = other.widget;
        this.length = other.length;
        return true;
      }
      return false;
    }
    ignoreMutation() {
      return true;
    }
    ignoreEvent(event) {
      return this.widget.ignoreEvent(event);
    }
    get overrideDOMText() {
      if (this.length == 0)
        return Text.empty;
      let top2 = this;
      while (top2.parent)
        top2 = top2.parent;
      let { view } = top2, text = view && view.state.doc, start2 = this.posAtStart;
      return text ? text.slice(start2, start2 + this.length) : Text.empty;
    }
    domAtPos(pos) {
      return (this.length ? pos == 0 : this.side > 0) ? DOMPos$1.before(this.dom) : DOMPos$1.after(this.dom, pos == this.length);
    }
    domBoundsAround() {
      return null;
    }
    coordsAt(pos, side) {
      let custom = this.widget.coordsAt(this.dom, pos, side);
      if (custom)
        return custom;
      let rects = this.dom.getClientRects(), rect = null;
      if (!rects.length)
        return null;
      let fromBack = this.side ? this.side < 0 : pos > 0;
      for (let i2 = fromBack ? rects.length - 1 : 0; ; i2 += fromBack ? -1 : 1) {
        rect = rects[i2];
        if (pos > 0 ? i2 == 0 : i2 == rects.length - 1 || rect.top < rect.bottom)
          break;
      }
      return flattenRect$1(rect, !fromBack);
    }
    get isEditable() {
      return false;
    }
    get isWidget() {
      return true;
    }
    get isHidden() {
      return this.widget.isHidden;
    }
    destroy() {
      super.destroy();
      if (this.dom)
        this.widget.destroy(this.dom);
    }
  };
  let WidgetBufferView$1 = class WidgetBufferView2 extends ContentView$1 {
    constructor(side) {
      super();
      this.side = side;
    }
    get length() {
      return 0;
    }
    merge() {
      return false;
    }
    become(other) {
      return other instanceof WidgetBufferView2 && other.side == this.side;
    }
    split() {
      return new WidgetBufferView2(this.side);
    }
    sync() {
      if (!this.dom) {
        let dom = document.createElement("img");
        dom.className = "cm-widgetBuffer";
        dom.setAttribute("aria-hidden", "true");
        this.setDOM(dom);
      }
    }
    getSide() {
      return this.side;
    }
    domAtPos(pos) {
      return this.side > 0 ? DOMPos$1.before(this.dom) : DOMPos$1.after(this.dom);
    }
    localPosFromDOM() {
      return 0;
    }
    domBoundsAround() {
      return null;
    }
    coordsAt(pos) {
      return this.dom.getBoundingClientRect();
    }
    get overrideDOMText() {
      return Text.empty;
    }
    get isHidden() {
      return true;
    }
  };
  TextView$1.prototype.children = WidgetView$1.prototype.children = WidgetBufferView$1.prototype.children = noChildren$1;
  function inlineDOMAtPos$1(parent, pos) {
    let dom = parent.dom, { children } = parent, i2 = 0;
    for (let off = 0; i2 < children.length; i2++) {
      let child = children[i2], end2 = off + child.length;
      if (end2 == off && child.getSide() <= 0)
        continue;
      if (pos > off && pos < end2 && child.dom.parentNode == dom)
        return child.domAtPos(pos - off);
      if (pos <= off)
        break;
      off = end2;
    }
    for (let j = i2; j > 0; j--) {
      let prev2 = children[j - 1];
      if (prev2.dom.parentNode == dom)
        return prev2.domAtPos(prev2.length);
    }
    for (let j = i2; j < children.length; j++) {
      let next2 = children[j];
      if (next2.dom.parentNode == dom)
        return next2.domAtPos(0);
    }
    return new DOMPos$1(dom, 0);
  }
  function joinInlineInto$1(parent, view, open) {
    let last, { children } = parent;
    if (open > 0 && view instanceof MarkView$1 && children.length && (last = children[children.length - 1]) instanceof MarkView$1 && last.mark.eq(view.mark)) {
      joinInlineInto$1(last, view.children[0], open - 1);
    } else {
      children.push(view);
      view.setParent(parent);
    }
    parent.length += view.length;
  }
  function coordsInChildren$1(view, pos, side) {
    let before = null, beforePos = -1, after = null, afterPos = -1;
    function scan(view2, pos2) {
      for (let i2 = 0, off = 0; i2 < view2.children.length && off <= pos2; i2++) {
        let child = view2.children[i2], end2 = off + child.length;
        if (end2 >= pos2) {
          if (child.children.length) {
            scan(child, pos2 - off);
          } else if ((!after || after.isHidden && side > 0) && (end2 > pos2 || off == end2 && child.getSide() > 0)) {
            after = child;
            afterPos = pos2 - off;
          } else if (off < pos2 || off == end2 && child.getSide() < 0 && !child.isHidden) {
            before = child;
            beforePos = pos2 - off;
          }
        }
        off = end2;
      }
    }
    scan(view, pos);
    let target = (side < 0 ? before : after) || before || after;
    if (target)
      return target.coordsAt(Math.max(0, target == before ? beforePos : afterPos), side);
    return fallbackRect$1(view);
  }
  function fallbackRect$1(view) {
    let last = view.dom.lastChild;
    if (!last)
      return view.dom.getBoundingClientRect();
    let rects = clientRectsFor$1(last);
    return rects[rects.length - 1] || null;
  }
  function combineAttrs$1(source, target) {
    for (let name2 in source) {
      if (name2 == "class" && target.class)
        target.class += " " + source.class;
      else if (name2 == "style" && target.style)
        target.style += ";" + source.style;
      else
        target[name2] = source[name2];
    }
    return target;
  }
  const noAttrs$1 = /* @__PURE__ */ Object.create(null);
  function attrsEq$1(a2, b, ignore) {
    if (a2 == b)
      return true;
    if (!a2)
      a2 = noAttrs$1;
    if (!b)
      b = noAttrs$1;
    let keysA = Object.keys(a2), keysB = Object.keys(b);
    if (keysA.length - (ignore && keysA.indexOf(ignore) > -1 ? 1 : 0) != keysB.length - (ignore && keysB.indexOf(ignore) > -1 ? 1 : 0))
      return false;
    for (let key of keysA) {
      if (key != ignore && (keysB.indexOf(key) == -1 || a2[key] !== b[key]))
        return false;
    }
    return true;
  }
  function updateAttrs$1(dom, prev2, attrs) {
    let changed = false;
    if (prev2) {
      for (let name2 in prev2)
        if (!(attrs && name2 in attrs)) {
          changed = true;
          if (name2 == "style")
            dom.style.cssText = "";
          else
            dom.removeAttribute(name2);
        }
    }
    if (attrs) {
      for (let name2 in attrs)
        if (!(prev2 && prev2[name2] == attrs[name2])) {
          changed = true;
          if (name2 == "style")
            dom.style.cssText = attrs[name2];
          else
            dom.setAttribute(name2, attrs[name2]);
        }
    }
    return changed;
  }
  function getAttrs$1(dom) {
    let attrs = /* @__PURE__ */ Object.create(null);
    for (let i2 = 0; i2 < dom.attributes.length; i2++) {
      let attr = dom.attributes[i2];
      attrs[attr.name] = attr.value;
    }
    return attrs;
  }
  let WidgetType$1 = class WidgetType {
    /**
    Compare this instance to another instance of the same type.
    (TypeScript can't express this, but only instances of the same
    specific class will be passed to this method.) This is used to
    avoid redrawing widgets when they are replaced by a new
    decoration of the same type. The default implementation just
    returns `false`, which will cause new instances of the widget to
    always be redrawn.
    */
    eq(widget) {
      return false;
    }
    /**
    Update a DOM element created by a widget of the same type (but
    different, non-`eq` content) to reflect this widget. May return
    true to indicate that it could update, false to indicate it
    couldn't (in which case the widget will be redrawn). The default
    implementation just returns false.
    */
    updateDOM(dom, view) {
      return false;
    }
    /**
    @internal
    */
    compare(other) {
      return this == other || this.constructor == other.constructor && this.eq(other);
    }
    /**
    The estimated height this widget will have, to be used when
    estimating the height of content that hasn't been drawn. May
    return -1 to indicate you don't know. The default implementation
    returns -1.
    */
    get estimatedHeight() {
      return -1;
    }
    /**
    For inline widgets that are displayed inline (as opposed to
    `inline-block`) and introduce line breaks (through `<br>` tags
    or textual newlines), this must indicate the amount of line
    breaks they introduce. Defaults to 0.
    */
    get lineBreaks() {
      return 0;
    }
    /**
    Can be used to configure which kinds of events inside the widget
    should be ignored by the editor. The default is to ignore all
    events.
    */
    ignoreEvent(event) {
      return true;
    }
    /**
    Override the way screen coordinates for positions at/in the
    widget are found. `pos` will be the offset into the widget, and
    `side` the side of the position that is being queried—less than
    zero for before, greater than zero for after, and zero for
    directly at that position.
    */
    coordsAt(dom, pos, side) {
      return null;
    }
    /**
    @internal
    */
    get isHidden() {
      return false;
    }
    /**
    @internal
    */
    get editable() {
      return false;
    }
    /**
    This is called when the an instance of the widget is removed
    from the editor view.
    */
    destroy(dom) {
    }
  };
  var BlockType$1 = /* @__PURE__ */ function(BlockType2) {
    BlockType2[BlockType2["Text"] = 0] = "Text";
    BlockType2[BlockType2["WidgetBefore"] = 1] = "WidgetBefore";
    BlockType2[BlockType2["WidgetAfter"] = 2] = "WidgetAfter";
    BlockType2[BlockType2["WidgetRange"] = 3] = "WidgetRange";
    return BlockType2;
  }(BlockType$1 || (BlockType$1 = {}));
  let Decoration$1 = class Decoration extends RangeValue {
    constructor(startSide, endSide, widget, spec) {
      super();
      this.startSide = startSide;
      this.endSide = endSide;
      this.widget = widget;
      this.spec = spec;
    }
    /**
    @internal
    */
    get heightRelevant() {
      return false;
    }
    /**
    Create a mark decoration, which influences the styling of the
    content in its range. Nested mark decorations will cause nested
    DOM elements to be created. Nesting order is determined by
    precedence of the [facet](https://codemirror.net/6/docs/ref/#view.EditorView^decorations), with
    the higher-precedence decorations creating the inner DOM nodes.
    Such elements are split on line boundaries and on the boundaries
    of lower-precedence decorations.
    */
    static mark(spec) {
      return new MarkDecoration$1(spec);
    }
    /**
    Create a widget decoration, which displays a DOM element at the
    given position.
    */
    static widget(spec) {
      let side = Math.max(-1e4, Math.min(1e4, spec.side || 0)), block = !!spec.block;
      side += block && !spec.inlineOrder ? side > 0 ? 3e8 : -4e8 : side > 0 ? 1e8 : -1e8;
      return new PointDecoration$1(spec, side, side, block, spec.widget || null, false);
    }
    /**
    Create a replace decoration which replaces the given range with
    a widget, or simply hides it.
    */
    static replace(spec) {
      let block = !!spec.block, startSide, endSide;
      if (spec.isBlockGap) {
        startSide = -5e8;
        endSide = 4e8;
      } else {
        let { start: start2, end: end2 } = getInclusive$1(spec, block);
        startSide = (start2 ? block ? -3e8 : -1 : 5e8) - 1;
        endSide = (end2 ? block ? 2e8 : 1 : -6e8) + 1;
      }
      return new PointDecoration$1(spec, startSide, endSide, block, spec.widget || null, true);
    }
    /**
    Create a line decoration, which can add DOM attributes to the
    line starting at the given position.
    */
    static line(spec) {
      return new LineDecoration$1(spec);
    }
    /**
    Build a [`DecorationSet`](https://codemirror.net/6/docs/ref/#view.DecorationSet) from the given
    decorated range or ranges. If the ranges aren't already sorted,
    pass `true` for `sort` to make the library sort them for you.
    */
    static set(of, sort = false) {
      return RangeSet.of(of, sort);
    }
    /**
    @internal
    */
    hasHeight() {
      return this.widget ? this.widget.estimatedHeight > -1 : false;
    }
  };
  Decoration$1.none = RangeSet.empty;
  let MarkDecoration$1 = class MarkDecoration2 extends Decoration$1 {
    constructor(spec) {
      let { start: start2, end: end2 } = getInclusive$1(spec);
      super(start2 ? -1 : 5e8, end2 ? 1 : -6e8, null, spec);
      this.tagName = spec.tagName || "span";
      this.class = spec.class || "";
      this.attrs = spec.attributes || null;
    }
    eq(other) {
      var _a3, _b;
      return this == other || other instanceof MarkDecoration2 && this.tagName == other.tagName && (this.class || ((_a3 = this.attrs) === null || _a3 === void 0 ? void 0 : _a3.class)) == (other.class || ((_b = other.attrs) === null || _b === void 0 ? void 0 : _b.class)) && attrsEq$1(this.attrs, other.attrs, "class");
    }
    range(from2, to = from2) {
      if (from2 >= to)
        throw new RangeError("Mark decorations may not be empty");
      return super.range(from2, to);
    }
  };
  MarkDecoration$1.prototype.point = false;
  let LineDecoration$1 = class LineDecoration2 extends Decoration$1 {
    constructor(spec) {
      super(-2e8, -2e8, null, spec);
    }
    eq(other) {
      return other instanceof LineDecoration2 && this.spec.class == other.spec.class && attrsEq$1(this.spec.attributes, other.spec.attributes);
    }
    range(from2, to = from2) {
      if (to != from2)
        throw new RangeError("Line decoration ranges must be zero-length");
      return super.range(from2, to);
    }
  };
  LineDecoration$1.prototype.mapMode = MapMode.TrackBefore;
  LineDecoration$1.prototype.point = true;
  let PointDecoration$1 = class PointDecoration2 extends Decoration$1 {
    constructor(spec, startSide, endSide, block, widget, isReplace) {
      super(startSide, endSide, widget, spec);
      this.block = block;
      this.isReplace = isReplace;
      this.mapMode = !block ? MapMode.TrackDel : startSide <= 0 ? MapMode.TrackBefore : MapMode.TrackAfter;
    }
    // Only relevant when this.block == true
    get type() {
      return this.startSide != this.endSide ? BlockType$1.WidgetRange : this.startSide <= 0 ? BlockType$1.WidgetBefore : BlockType$1.WidgetAfter;
    }
    get heightRelevant() {
      return this.block || !!this.widget && (this.widget.estimatedHeight >= 5 || this.widget.lineBreaks > 0);
    }
    eq(other) {
      return other instanceof PointDecoration2 && widgetsEq$1(this.widget, other.widget) && this.block == other.block && this.startSide == other.startSide && this.endSide == other.endSide;
    }
    range(from2, to = from2) {
      if (this.isReplace && (from2 > to || from2 == to && this.startSide > 0 && this.endSide <= 0))
        throw new RangeError("Invalid range for replacement decoration");
      if (!this.isReplace && to != from2)
        throw new RangeError("Widget decorations can only have zero-length ranges");
      return super.range(from2, to);
    }
  };
  PointDecoration$1.prototype.point = true;
  function getInclusive$1(spec, block = false) {
    let { inclusiveStart: start2, inclusiveEnd: end2 } = spec;
    if (start2 == null)
      start2 = spec.inclusive;
    if (end2 == null)
      end2 = spec.inclusive;
    return { start: start2 !== null && start2 !== void 0 ? start2 : block, end: end2 !== null && end2 !== void 0 ? end2 : block };
  }
  function widgetsEq$1(a2, b) {
    return a2 == b || !!(a2 && b && a2.compare(b));
  }
  function addRange$1(from2, to, ranges, margin2 = 0) {
    let last = ranges.length - 1;
    if (last >= 0 && ranges[last] + margin2 >= from2)
      ranges[last] = Math.max(ranges[last], to);
    else
      ranges.push(from2, to);
  }
  let LineView$1 = class LineView2 extends ContentView$1 {
    constructor() {
      super(...arguments);
      this.children = [];
      this.length = 0;
      this.prevAttrs = void 0;
      this.attrs = null;
      this.breakAfter = 0;
    }
    // Consumes source
    merge(from2, to, source, hasStart, openStart, openEnd) {
      if (source) {
        if (!(source instanceof LineView2))
          return false;
        if (!this.dom)
          source.transferDOM(this);
      }
      if (hasStart)
        this.setDeco(source ? source.attrs : null);
      mergeChildrenInto$1(this, from2, to, source ? source.children.slice() : [], openStart, openEnd);
      return true;
    }
    split(at2) {
      let end2 = new LineView2();
      end2.breakAfter = this.breakAfter;
      if (this.length == 0)
        return end2;
      let { i: i2, off } = this.childPos(at2);
      if (off) {
        end2.append(this.children[i2].split(off), 0);
        this.children[i2].merge(off, this.children[i2].length, null, false, 0, 0);
        i2++;
      }
      for (let j = i2; j < this.children.length; j++)
        end2.append(this.children[j], 0);
      while (i2 > 0 && this.children[i2 - 1].length == 0)
        this.children[--i2].destroy();
      this.children.length = i2;
      this.markDirty();
      this.length = at2;
      return end2;
    }
    transferDOM(other) {
      if (!this.dom)
        return;
      this.markDirty();
      other.setDOM(this.dom);
      other.prevAttrs = this.prevAttrs === void 0 ? this.attrs : this.prevAttrs;
      this.prevAttrs = void 0;
      this.dom = null;
    }
    setDeco(attrs) {
      if (!attrsEq$1(this.attrs, attrs)) {
        if (this.dom) {
          this.prevAttrs = this.attrs;
          this.markDirty();
        }
        this.attrs = attrs;
      }
    }
    append(child, openStart) {
      joinInlineInto$1(this, child, openStart);
    }
    // Only called when building a line view in ContentBuilder
    addLineDeco(deco) {
      let attrs = deco.spec.attributes, cls = deco.spec.class;
      if (attrs)
        this.attrs = combineAttrs$1(attrs, this.attrs || {});
      if (cls)
        this.attrs = combineAttrs$1({ class: cls }, this.attrs || {});
    }
    domAtPos(pos) {
      return inlineDOMAtPos$1(this, pos);
    }
    reuseDOM(node2) {
      if (node2.nodeName == "DIV") {
        this.setDOM(node2);
        this.flags |= 4 | 2;
      }
    }
    sync(view, track) {
      var _a3;
      if (!this.dom) {
        this.setDOM(document.createElement("div"));
        this.dom.className = "cm-line";
        this.prevAttrs = this.attrs ? null : void 0;
      } else if (this.flags & 4) {
        clearAttributes$1(this.dom);
        this.dom.className = "cm-line";
        this.prevAttrs = this.attrs ? null : void 0;
      }
      if (this.prevAttrs !== void 0) {
        updateAttrs$1(this.dom, this.prevAttrs, this.attrs);
        this.dom.classList.add("cm-line");
        this.prevAttrs = void 0;
      }
      super.sync(view, track);
      let last = this.dom.lastChild;
      while (last && ContentView$1.get(last) instanceof MarkView$1)
        last = last.lastChild;
      if (!last || !this.length || last.nodeName != "BR" && ((_a3 = ContentView$1.get(last)) === null || _a3 === void 0 ? void 0 : _a3.isEditable) == false && (!browser$1.ios || !this.children.some((ch) => ch instanceof TextView$1))) {
        let hack = document.createElement("BR");
        hack.cmIgnore = true;
        this.dom.appendChild(hack);
      }
    }
    measureTextSize() {
      if (this.children.length == 0 || this.length > 20)
        return null;
      let totalWidth = 0, textHeight;
      for (let child of this.children) {
        if (!(child instanceof TextView$1) || /[^ -~]/.test(child.text))
          return null;
        let rects = clientRectsFor$1(child.dom);
        if (rects.length != 1)
          return null;
        totalWidth += rects[0].width;
        textHeight = rects[0].height;
      }
      return !totalWidth ? null : {
        lineHeight: this.dom.getBoundingClientRect().height,
        charWidth: totalWidth / this.length,
        textHeight
      };
    }
    coordsAt(pos, side) {
      let rect = coordsInChildren$1(this, pos, side);
      if (!this.children.length && rect && this.parent) {
        let { heightOracle } = this.parent.view.viewState, height2 = rect.bottom - rect.top;
        if (Math.abs(height2 - heightOracle.lineHeight) < 2 && heightOracle.textHeight < height2) {
          let dist2 = (height2 - heightOracle.textHeight) / 2;
          return { top: rect.top + dist2, bottom: rect.bottom - dist2, left: rect.left, right: rect.left };
        }
      }
      return rect;
    }
    become(other) {
      return other instanceof LineView2 && this.children.length == 0 && other.children.length == 0 && attrsEq$1(this.attrs, other.attrs) && this.breakAfter == other.breakAfter;
    }
    covers() {
      return true;
    }
    static find(docView, pos) {
      for (let i2 = 0, off = 0; i2 < docView.children.length; i2++) {
        let block = docView.children[i2], end2 = off + block.length;
        if (end2 >= pos) {
          if (block instanceof LineView2)
            return block;
          if (end2 > pos)
            break;
        }
        off = end2 + block.breakAfter;
      }
      return null;
    }
  };
  let BlockWidgetView$1 = class BlockWidgetView2 extends ContentView$1 {
    constructor(widget, length2, deco) {
      super();
      this.widget = widget;
      this.length = length2;
      this.deco = deco;
      this.breakAfter = 0;
      this.prevWidget = null;
    }
    merge(from2, to, source, _takeDeco, openStart, openEnd) {
      if (source && (!(source instanceof BlockWidgetView2) || !this.widget.compare(source.widget) || from2 > 0 && openStart <= 0 || to < this.length && openEnd <= 0))
        return false;
      this.length = from2 + (source ? source.length : 0) + (this.length - to);
      return true;
    }
    domAtPos(pos) {
      return pos == 0 ? DOMPos$1.before(this.dom) : DOMPos$1.after(this.dom, pos == this.length);
    }
    split(at2) {
      let len = this.length - at2;
      this.length = at2;
      let end2 = new BlockWidgetView2(this.widget, len, this.deco);
      end2.breakAfter = this.breakAfter;
      return end2;
    }
    get children() {
      return noChildren$1;
    }
    sync(view) {
      if (!this.dom || !this.widget.updateDOM(this.dom, view)) {
        if (this.dom && this.prevWidget)
          this.prevWidget.destroy(this.dom);
        this.prevWidget = null;
        this.setDOM(this.widget.toDOM(view));
        if (!this.widget.editable)
          this.dom.contentEditable = "false";
      }
    }
    get overrideDOMText() {
      return this.parent ? this.parent.view.state.doc.slice(this.posAtStart, this.posAtEnd) : Text.empty;
    }
    domBoundsAround() {
      return null;
    }
    become(other) {
      if (other instanceof BlockWidgetView2 && other.widget.constructor == this.widget.constructor) {
        if (!other.widget.compare(this.widget))
          this.markDirty(true);
        if (this.dom && !this.prevWidget)
          this.prevWidget = this.widget;
        this.widget = other.widget;
        this.length = other.length;
        this.deco = other.deco;
        this.breakAfter = other.breakAfter;
        return true;
      }
      return false;
    }
    ignoreMutation() {
      return true;
    }
    ignoreEvent(event) {
      return this.widget.ignoreEvent(event);
    }
    get isEditable() {
      return false;
    }
    get isWidget() {
      return true;
    }
    coordsAt(pos, side) {
      let custom = this.widget.coordsAt(this.dom, pos, side);
      if (custom)
        return custom;
      if (this.widget instanceof BlockGapWidget$1)
        return null;
      return flattenRect$1(this.dom.getBoundingClientRect(), this.length ? pos == 0 : side <= 0);
    }
    destroy() {
      super.destroy();
      if (this.dom)
        this.widget.destroy(this.dom);
    }
    covers(side) {
      let { startSide, endSide } = this.deco;
      return startSide == endSide ? false : side < 0 ? startSide < 0 : endSide > 0;
    }
  };
  let BlockGapWidget$1 = class BlockGapWidget extends WidgetType$1 {
    constructor(height2) {
      super();
      this.height = height2;
    }
    toDOM() {
      let elt = document.createElement("div");
      elt.className = "cm-gap";
      this.updateDOM(elt);
      return elt;
    }
    eq(other) {
      return other.height == this.height;
    }
    updateDOM(elt) {
      elt.style.height = this.height + "px";
      return true;
    }
    get editable() {
      return true;
    }
    get estimatedHeight() {
      return this.height;
    }
    ignoreEvent() {
      return false;
    }
  };
  let ContentBuilder$1 = class ContentBuilder2 {
    constructor(doc2, pos, end2, disallowBlockEffectsFor) {
      this.doc = doc2;
      this.pos = pos;
      this.end = end2;
      this.disallowBlockEffectsFor = disallowBlockEffectsFor;
      this.content = [];
      this.curLine = null;
      this.breakAtStart = 0;
      this.pendingBuffer = 0;
      this.bufferMarks = [];
      this.atCursorPos = true;
      this.openStart = -1;
      this.openEnd = -1;
      this.text = "";
      this.textOff = 0;
      this.cursor = doc2.iter();
      this.skip = pos;
    }
    posCovered() {
      if (this.content.length == 0)
        return !this.breakAtStart && this.doc.lineAt(this.pos).from != this.pos;
      let last = this.content[this.content.length - 1];
      return !(last.breakAfter || last instanceof BlockWidgetView$1 && last.deco.endSide < 0);
    }
    getLine() {
      if (!this.curLine) {
        this.content.push(this.curLine = new LineView$1());
        this.atCursorPos = true;
      }
      return this.curLine;
    }
    flushBuffer(active = this.bufferMarks) {
      if (this.pendingBuffer) {
        this.curLine.append(wrapMarks$1(new WidgetBufferView$1(-1), active), active.length);
        this.pendingBuffer = 0;
      }
    }
    addBlockWidget(view) {
      this.flushBuffer();
      this.curLine = null;
      this.content.push(view);
    }
    finish(openEnd) {
      if (this.pendingBuffer && openEnd <= this.bufferMarks.length)
        this.flushBuffer();
      else
        this.pendingBuffer = 0;
      if (!this.posCovered() && !(openEnd && this.content.length && this.content[this.content.length - 1] instanceof BlockWidgetView$1))
        this.getLine();
    }
    buildText(length2, active, openStart) {
      while (length2 > 0) {
        if (this.textOff == this.text.length) {
          let { value, lineBreak, done } = this.cursor.next(this.skip);
          this.skip = 0;
          if (done)
            throw new Error("Ran out of text content when drawing inline views");
          if (lineBreak) {
            if (!this.posCovered())
              this.getLine();
            if (this.content.length)
              this.content[this.content.length - 1].breakAfter = 1;
            else
              this.breakAtStart = 1;
            this.flushBuffer();
            this.curLine = null;
            this.atCursorPos = true;
            length2--;
            continue;
          } else {
            this.text = value;
            this.textOff = 0;
          }
        }
        let take = Math.min(
          this.text.length - this.textOff,
          length2,
          512
          /* T.Chunk */
        );
        this.flushBuffer(active.slice(active.length - openStart));
        this.getLine().append(wrapMarks$1(new TextView$1(this.text.slice(this.textOff, this.textOff + take)), active), openStart);
        this.atCursorPos = true;
        this.textOff += take;
        length2 -= take;
        openStart = 0;
      }
    }
    span(from2, to, active, openStart) {
      this.buildText(to - from2, active, openStart);
      this.pos = to;
      if (this.openStart < 0)
        this.openStart = openStart;
    }
    point(from2, to, deco, active, openStart, index) {
      if (this.disallowBlockEffectsFor[index] && deco instanceof PointDecoration$1) {
        if (deco.block)
          throw new RangeError("Block decorations may not be specified via plugins");
        if (to > this.doc.lineAt(this.pos).to)
          throw new RangeError("Decorations that replace line breaks may not be specified via plugins");
      }
      let len = to - from2;
      if (deco instanceof PointDecoration$1) {
        if (deco.block) {
          if (deco.startSide > 0 && !this.posCovered())
            this.getLine();
          this.addBlockWidget(new BlockWidgetView$1(deco.widget || NullWidget$1.block, len, deco));
        } else {
          let view = WidgetView$1.create(deco.widget || NullWidget$1.inline, len, len ? 0 : deco.startSide);
          let cursorBefore = this.atCursorPos && !view.isEditable && openStart <= active.length && (from2 < to || deco.startSide > 0);
          let cursorAfter = !view.isEditable && (from2 < to || openStart > active.length || deco.startSide <= 0);
          let line2 = this.getLine();
          if (this.pendingBuffer == 2 && !cursorBefore && !view.isEditable)
            this.pendingBuffer = 0;
          this.flushBuffer(active);
          if (cursorBefore) {
            line2.append(wrapMarks$1(new WidgetBufferView$1(1), active), openStart);
            openStart = active.length + Math.max(0, openStart - active.length);
          }
          line2.append(wrapMarks$1(view, active), openStart);
          this.atCursorPos = cursorAfter;
          this.pendingBuffer = !cursorAfter ? 0 : from2 < to || openStart > active.length ? 1 : 2;
          if (this.pendingBuffer)
            this.bufferMarks = active.slice();
        }
      } else if (this.doc.lineAt(this.pos).from == this.pos) {
        this.getLine().addLineDeco(deco);
      }
      if (len) {
        if (this.textOff + len <= this.text.length) {
          this.textOff += len;
        } else {
          this.skip += len - (this.text.length - this.textOff);
          this.text = "";
          this.textOff = 0;
        }
        this.pos = to;
      }
      if (this.openStart < 0)
        this.openStart = openStart;
    }
    static build(text, from2, to, decorations2, dynamicDecorationMap) {
      let builder = new ContentBuilder2(text, from2, to, dynamicDecorationMap);
      builder.openEnd = RangeSet.spans(decorations2, from2, to, builder);
      if (builder.openStart < 0)
        builder.openStart = builder.openEnd;
      builder.finish(builder.openEnd);
      return builder;
    }
  };
  function wrapMarks$1(view, active) {
    for (let mark of active)
      view = new MarkView$1(mark, [view], view.length);
    return view;
  }
  let NullWidget$1 = class NullWidget extends WidgetType$1 {
    constructor(tag) {
      super();
      this.tag = tag;
    }
    eq(other) {
      return other.tag == this.tag;
    }
    toDOM() {
      return document.createElement(this.tag);
    }
    updateDOM(elt) {
      return elt.nodeName.toLowerCase() == this.tag;
    }
    get isHidden() {
      return true;
    }
  };
  NullWidget$1.inline = /* @__PURE__ */ new NullWidget$1("span");
  NullWidget$1.block = /* @__PURE__ */ new NullWidget$1("div");
  var Direction$1 = /* @__PURE__ */ function(Direction2) {
    Direction2[Direction2["LTR"] = 0] = "LTR";
    Direction2[Direction2["RTL"] = 1] = "RTL";
    return Direction2;
  }(Direction$1 || (Direction$1 = {}));
  const LTR$1 = Direction$1.LTR, RTL$1 = Direction$1.RTL;
  function dec$1(str) {
    let result = [];
    for (let i2 = 0; i2 < str.length; i2++)
      result.push(1 << +str[i2]);
    return result;
  }
  const LowTypes$1 = /* @__PURE__ */ dec$1("88888888888888888888888888888888888666888888787833333333337888888000000000000000000000000008888880000000000000000000000000088888888888888888888888888888888888887866668888088888663380888308888800000000000000000000000800000000000000000000000000000008");
  const ArabicTypes$1 = /* @__PURE__ */ dec$1("4444448826627288999999999992222222222222222222222222222222222222222222222229999999999999999999994444444444644222822222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222999999949999999229989999223333333333");
  const Brackets$1 = /* @__PURE__ */ Object.create(null), BracketStack$1 = [];
  for (let p2 of ["()", "[]", "{}"]) {
    let l = /* @__PURE__ */ p2.charCodeAt(0), r2 = /* @__PURE__ */ p2.charCodeAt(1);
    Brackets$1[l] = r2;
    Brackets$1[r2] = -l;
  }
  function charType$1(ch) {
    return ch <= 247 ? LowTypes$1[ch] : 1424 <= ch && ch <= 1524 ? 2 : 1536 <= ch && ch <= 1785 ? ArabicTypes$1[ch - 1536] : 1774 <= ch && ch <= 2220 ? 4 : 8192 <= ch && ch <= 8204 ? 256 : 64336 <= ch && ch <= 65023 ? 4 : 1;
  }
  const BidiRE$1 = /[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\ufb50-\ufdff]/;
  let BidiSpan$1 = class BidiSpan {
    /**
    The direction of this span.
    */
    get dir() {
      return this.level % 2 ? RTL$1 : LTR$1;
    }
    /**
    @internal
    */
    constructor(from2, to, level) {
      this.from = from2;
      this.to = to;
      this.level = level;
    }
    /**
    @internal
    */
    side(end2, dir) {
      return this.dir == dir == end2 ? this.to : this.from;
    }
    /**
    @internal
    */
    forward(forward, dir) {
      return forward == (this.dir == dir);
    }
    /**
    @internal
    */
    static find(order2, index, level, assoc) {
      let maybe = -1;
      for (let i2 = 0; i2 < order2.length; i2++) {
        let span = order2[i2];
        if (span.from <= index && span.to >= index) {
          if (span.level == level)
            return i2;
          if (maybe < 0 || (assoc != 0 ? assoc < 0 ? span.from < index : span.to > index : order2[maybe].level > span.level))
            maybe = i2;
        }
      }
      if (maybe < 0)
        throw new RangeError("Index out of range");
      return maybe;
    }
  };
  function isolatesEq$1(a2, b) {
    if (a2.length != b.length)
      return false;
    for (let i2 = 0; i2 < a2.length; i2++) {
      let iA = a2[i2], iB = b[i2];
      if (iA.from != iB.from || iA.to != iB.to || iA.direction != iB.direction || !isolatesEq$1(iA.inner, iB.inner))
        return false;
    }
    return true;
  }
  const types$1 = [];
  function computeCharTypes$1(line2, rFrom, rTo, isolates, outerType) {
    for (let iI = 0; iI <= isolates.length; iI++) {
      let from2 = iI ? isolates[iI - 1].to : rFrom, to = iI < isolates.length ? isolates[iI].from : rTo;
      let prevType = iI ? 256 : outerType;
      for (let i2 = from2, prev2 = prevType, prevStrong = prevType; i2 < to; i2++) {
        let type = charType$1(line2.charCodeAt(i2));
        if (type == 512)
          type = prev2;
        else if (type == 8 && prevStrong == 4)
          type = 16;
        types$1[i2] = type == 4 ? 2 : type;
        if (type & 7)
          prevStrong = type;
        prev2 = type;
      }
      for (let i2 = from2, prev2 = prevType, prevStrong = prevType; i2 < to; i2++) {
        let type = types$1[i2];
        if (type == 128) {
          if (i2 < to - 1 && prev2 == types$1[i2 + 1] && prev2 & 24)
            type = types$1[i2] = prev2;
          else
            types$1[i2] = 256;
        } else if (type == 64) {
          let end2 = i2 + 1;
          while (end2 < to && types$1[end2] == 64)
            end2++;
          let replace2 = i2 && prev2 == 8 || end2 < rTo && types$1[end2] == 8 ? prevStrong == 1 ? 1 : 8 : 256;
          for (let j = i2; j < end2; j++)
            types$1[j] = replace2;
          i2 = end2 - 1;
        } else if (type == 8 && prevStrong == 1) {
          types$1[i2] = 1;
        }
        prev2 = type;
        if (type & 7)
          prevStrong = type;
      }
    }
  }
  function processBracketPairs$1(line2, rFrom, rTo, isolates, outerType) {
    let oppositeType = outerType == 1 ? 2 : 1;
    for (let iI = 0, sI = 0, context = 0; iI <= isolates.length; iI++) {
      let from2 = iI ? isolates[iI - 1].to : rFrom, to = iI < isolates.length ? isolates[iI].from : rTo;
      for (let i2 = from2, ch, br, type; i2 < to; i2++) {
        if (br = Brackets$1[ch = line2.charCodeAt(i2)]) {
          if (br < 0) {
            for (let sJ = sI - 3; sJ >= 0; sJ -= 3) {
              if (BracketStack$1[sJ + 1] == -br) {
                let flags = BracketStack$1[sJ + 2];
                let type2 = flags & 2 ? outerType : !(flags & 4) ? 0 : flags & 1 ? oppositeType : outerType;
                if (type2)
                  types$1[i2] = types$1[BracketStack$1[sJ]] = type2;
                sI = sJ;
                break;
              }
            }
          } else if (BracketStack$1.length == 189) {
            break;
          } else {
            BracketStack$1[sI++] = i2;
            BracketStack$1[sI++] = ch;
            BracketStack$1[sI++] = context;
          }
        } else if ((type = types$1[i2]) == 2 || type == 1) {
          let embed = type == outerType;
          context = embed ? 0 : 1;
          for (let sJ = sI - 3; sJ >= 0; sJ -= 3) {
            let cur = BracketStack$1[sJ + 2];
            if (cur & 2)
              break;
            if (embed) {
              BracketStack$1[sJ + 2] |= 2;
            } else {
              if (cur & 4)
                break;
              BracketStack$1[sJ + 2] |= 4;
            }
          }
        }
      }
    }
  }
  function processNeutrals$1(rFrom, rTo, isolates, outerType) {
    for (let iI = 0, prev2 = outerType; iI <= isolates.length; iI++) {
      let from2 = iI ? isolates[iI - 1].to : rFrom, to = iI < isolates.length ? isolates[iI].from : rTo;
      for (let i2 = from2; i2 < to; ) {
        let type = types$1[i2];
        if (type == 256) {
          let end2 = i2 + 1;
          for (; ; ) {
            if (end2 == to) {
              if (iI == isolates.length)
                break;
              end2 = isolates[iI++].to;
              to = iI < isolates.length ? isolates[iI].from : rTo;
            } else if (types$1[end2] == 256) {
              end2++;
            } else {
              break;
            }
          }
          let beforeL = prev2 == 1;
          let afterL = (end2 < rTo ? types$1[end2] : outerType) == 1;
          let replace2 = beforeL == afterL ? beforeL ? 1 : 2 : outerType;
          for (let j = end2, jI = iI, fromJ = jI ? isolates[jI - 1].to : rFrom; j > i2; ) {
            if (j == fromJ) {
              j = isolates[--jI].from;
              fromJ = jI ? isolates[jI - 1].to : rFrom;
            }
            types$1[--j] = replace2;
          }
          i2 = end2;
        } else {
          prev2 = type;
          i2++;
        }
      }
    }
  }
  function emitSpans$1(line2, from2, to, level, baseLevel, isolates, order2) {
    let ourType = level % 2 ? 2 : 1;
    if (level % 2 == baseLevel % 2) {
      for (let iCh = from2, iI = 0; iCh < to; ) {
        let sameDir = true, isNum = false;
        if (iI == isolates.length || iCh < isolates[iI].from) {
          let next2 = types$1[iCh];
          if (next2 != ourType) {
            sameDir = false;
            isNum = next2 == 16;
          }
        }
        let recurse = !sameDir && ourType == 1 ? [] : null;
        let localLevel = sameDir ? level : level + 1;
        let iScan = iCh;
        run:
          for (; ; ) {
            if (iI < isolates.length && iScan == isolates[iI].from) {
              if (isNum)
                break run;
              let iso = isolates[iI];
              if (!sameDir)
                for (let upto = iso.to, jI = iI + 1; ; ) {
                  if (upto == to)
                    break run;
                  if (jI < isolates.length && isolates[jI].from == upto)
                    upto = isolates[jI++].to;
                  else if (types$1[upto] == ourType)
                    break run;
                  else
                    break;
                }
              iI++;
              if (recurse) {
                recurse.push(iso);
              } else {
                if (iso.from > iCh)
                  order2.push(new BidiSpan$1(iCh, iso.from, localLevel));
                let dirSwap = iso.direction == LTR$1 != !(localLevel % 2);
                computeSectionOrder$1(line2, dirSwap ? level + 1 : level, baseLevel, iso.inner, iso.from, iso.to, order2);
                iCh = iso.to;
              }
              iScan = iso.to;
            } else if (iScan == to || (sameDir ? types$1[iScan] != ourType : types$1[iScan] == ourType)) {
              break;
            } else {
              iScan++;
            }
          }
        if (recurse)
          emitSpans$1(line2, iCh, iScan, level + 1, baseLevel, recurse, order2);
        else if (iCh < iScan)
          order2.push(new BidiSpan$1(iCh, iScan, localLevel));
        iCh = iScan;
      }
    } else {
      for (let iCh = to, iI = isolates.length; iCh > from2; ) {
        let sameDir = true, isNum = false;
        if (!iI || iCh > isolates[iI - 1].to) {
          let next2 = types$1[iCh - 1];
          if (next2 != ourType) {
            sameDir = false;
            isNum = next2 == 16;
          }
        }
        let recurse = !sameDir && ourType == 1 ? [] : null;
        let localLevel = sameDir ? level : level + 1;
        let iScan = iCh;
        run:
          for (; ; ) {
            if (iI && iScan == isolates[iI - 1].to) {
              if (isNum)
                break run;
              let iso = isolates[--iI];
              if (!sameDir)
                for (let upto = iso.from, jI = iI; ; ) {
                  if (upto == from2)
                    break run;
                  if (jI && isolates[jI - 1].to == upto)
                    upto = isolates[--jI].from;
                  else if (types$1[upto - 1] == ourType)
                    break run;
                  else
                    break;
                }
              if (recurse) {
                recurse.push(iso);
              } else {
                if (iso.to < iCh)
                  order2.push(new BidiSpan$1(iso.to, iCh, localLevel));
                let dirSwap = iso.direction == LTR$1 != !(localLevel % 2);
                computeSectionOrder$1(line2, dirSwap ? level + 1 : level, baseLevel, iso.inner, iso.from, iso.to, order2);
                iCh = iso.from;
              }
              iScan = iso.from;
            } else if (iScan == from2 || (sameDir ? types$1[iScan - 1] != ourType : types$1[iScan - 1] == ourType)) {
              break;
            } else {
              iScan--;
            }
          }
        if (recurse)
          emitSpans$1(line2, iScan, iCh, level + 1, baseLevel, recurse, order2);
        else if (iScan < iCh)
          order2.push(new BidiSpan$1(iScan, iCh, localLevel));
        iCh = iScan;
      }
    }
  }
  function computeSectionOrder$1(line2, level, baseLevel, isolates, from2, to, order2) {
    let outerType = level % 2 ? 2 : 1;
    computeCharTypes$1(line2, from2, to, isolates, outerType);
    processBracketPairs$1(line2, from2, to, isolates, outerType);
    processNeutrals$1(from2, to, isolates, outerType);
    emitSpans$1(line2, from2, to, level, baseLevel, isolates, order2);
  }
  function computeOrder$1(line2, direction, isolates) {
    if (!line2)
      return [new BidiSpan$1(0, 0, direction == RTL$1 ? 1 : 0)];
    if (direction == LTR$1 && !isolates.length && !BidiRE$1.test(line2))
      return trivialOrder$1(line2.length);
    if (isolates.length)
      while (line2.length > types$1.length)
        types$1[types$1.length] = 256;
    let order2 = [], level = direction == LTR$1 ? 0 : 1;
    computeSectionOrder$1(line2, level, level, isolates, 0, line2.length, order2);
    return order2;
  }
  function trivialOrder$1(length2) {
    return [new BidiSpan$1(0, length2, 0)];
  }
  let movedOver$1 = "";
  function moveVisually$1(line2, order2, dir, start2, forward) {
    var _a3;
    let startIndex = start2.head - line2.from;
    let spanI = BidiSpan$1.find(order2, startIndex, (_a3 = start2.bidiLevel) !== null && _a3 !== void 0 ? _a3 : -1, start2.assoc);
    let span = order2[spanI], spanEnd = span.side(forward, dir);
    if (startIndex == spanEnd) {
      let nextI = spanI += forward ? 1 : -1;
      if (nextI < 0 || nextI >= order2.length)
        return null;
      span = order2[spanI = nextI];
      startIndex = span.side(!forward, dir);
      spanEnd = span.side(forward, dir);
    }
    let nextIndex = findClusterBreak(line2.text, startIndex, span.forward(forward, dir));
    if (nextIndex < span.from || nextIndex > span.to)
      nextIndex = spanEnd;
    movedOver$1 = line2.text.slice(Math.min(startIndex, nextIndex), Math.max(startIndex, nextIndex));
    let nextSpan = spanI == (forward ? order2.length - 1 : 0) ? null : order2[spanI + (forward ? 1 : -1)];
    if (nextSpan && nextIndex == spanEnd && nextSpan.level + (forward ? 0 : 1) < span.level)
      return EditorSelection.cursor(nextSpan.side(!forward, dir) + line2.from, nextSpan.forward(forward, dir) ? 1 : -1, nextSpan.level);
    return EditorSelection.cursor(nextIndex + line2.from, span.forward(forward, dir) ? -1 : 1, span.level);
  }
  function autoDirection$1(text, from2, to) {
    for (let i2 = from2; i2 < to; i2++) {
      let type = charType$1(text.charCodeAt(i2));
      if (type == 1)
        return LTR$1;
      if (type == 2 || type == 4)
        return RTL$1;
    }
    return LTR$1;
  }
  const clickAddsSelectionRange$1 = /* @__PURE__ */ Facet.define();
  const dragMovesSelection$1$1 = /* @__PURE__ */ Facet.define();
  const mouseSelectionStyle$1 = /* @__PURE__ */ Facet.define();
  const exceptionSink$1 = /* @__PURE__ */ Facet.define();
  const updateListener$1 = /* @__PURE__ */ Facet.define();
  const inputHandler$1 = /* @__PURE__ */ Facet.define();
  const focusChangeEffect$1 = /* @__PURE__ */ Facet.define();
  const clipboardInputFilter$1 = /* @__PURE__ */ Facet.define();
  const clipboardOutputFilter$1 = /* @__PURE__ */ Facet.define();
  const perLineTextDirection$1 = /* @__PURE__ */ Facet.define({
    combine: (values2) => values2.some((x2) => x2)
  });
  const nativeSelectionHidden$1 = /* @__PURE__ */ Facet.define({
    combine: (values2) => values2.some((x2) => x2)
  });
  const scrollHandler$1 = /* @__PURE__ */ Facet.define();
  let ScrollTarget$1 = class ScrollTarget2 {
    constructor(range, y = "nearest", x2 = "nearest", yMargin = 5, xMargin = 5, isSnapshot = false) {
      this.range = range;
      this.y = y;
      this.x = x2;
      this.yMargin = yMargin;
      this.xMargin = xMargin;
      this.isSnapshot = isSnapshot;
    }
    map(changes) {
      return changes.empty ? this : new ScrollTarget2(this.range.map(changes), this.y, this.x, this.yMargin, this.xMargin, this.isSnapshot);
    }
    clip(state) {
      return this.range.to <= state.doc.length ? this : new ScrollTarget2(EditorSelection.cursor(state.doc.length), this.y, this.x, this.yMargin, this.xMargin, this.isSnapshot);
    }
  };
  const scrollIntoView$1 = /* @__PURE__ */ StateEffect.define({ map: (t2, ch) => t2.map(ch) });
  const setEditContextFormatting$1 = /* @__PURE__ */ StateEffect.define();
  function logException$1(state, exception, context) {
    let handler = state.facet(exceptionSink$1);
    if (handler.length)
      handler[0](exception);
    else if (window.onerror)
      window.onerror(String(exception), context, void 0, void 0, exception);
    else if (context)
      console.error(context + ":", exception);
    else
      console.error(exception);
  }
  const editable$1 = /* @__PURE__ */ Facet.define({ combine: (values2) => values2.length ? values2[0] : true });
  let nextPluginID$1 = 0;
  const viewPlugin$1 = /* @__PURE__ */ Facet.define();
  let ViewPlugin$1 = class ViewPlugin2 {
    constructor(id, create, domEventHandlers, domEventObservers, buildExtensions) {
      this.id = id;
      this.create = create;
      this.domEventHandlers = domEventHandlers;
      this.domEventObservers = domEventObservers;
      this.extension = buildExtensions(this);
    }
    /**
    Define a plugin from a constructor function that creates the
    plugin's value, given an editor view.
    */
    static define(create, spec) {
      const { eventHandlers, eventObservers, provide, decorations: deco } = spec || {};
      return new ViewPlugin2(nextPluginID$1++, create, eventHandlers, eventObservers, (plugin) => {
        let ext = [viewPlugin$1.of(plugin)];
        if (deco)
          ext.push(decorations$1.of((view) => {
            let pluginInst = view.plugin(plugin);
            return pluginInst ? deco(pluginInst) : Decoration$1.none;
          }));
        if (provide)
          ext.push(provide(plugin));
        return ext;
      });
    }
    /**
    Create a plugin for a class whose constructor takes a single
    editor view as argument.
    */
    static fromClass(cls, spec) {
      return ViewPlugin2.define((view) => new cls(view), spec);
    }
  };
  let PluginInstance$1 = class PluginInstance {
    constructor(spec) {
      this.spec = spec;
      this.mustUpdate = null;
      this.value = null;
    }
    update(view) {
      if (!this.value) {
        if (this.spec) {
          try {
            this.value = this.spec.create(view);
          } catch (e) {
            logException$1(view.state, e, "CodeMirror plugin crashed");
            this.deactivate();
          }
        }
      } else if (this.mustUpdate) {
        let update = this.mustUpdate;
        this.mustUpdate = null;
        if (this.value.update) {
          try {
            this.value.update(update);
          } catch (e) {
            logException$1(update.state, e, "CodeMirror plugin crashed");
            if (this.value.destroy)
              try {
                this.value.destroy();
              } catch (_2) {
              }
            this.deactivate();
          }
        }
      }
      return this;
    }
    destroy(view) {
      var _a3;
      if ((_a3 = this.value) === null || _a3 === void 0 ? void 0 : _a3.destroy) {
        try {
          this.value.destroy();
        } catch (e) {
          logException$1(view.state, e, "CodeMirror plugin crashed");
        }
      }
    }
    deactivate() {
      this.spec = this.value = null;
    }
  };
  const editorAttributes$1 = /* @__PURE__ */ Facet.define();
  const contentAttributes$1 = /* @__PURE__ */ Facet.define();
  const decorations$1 = /* @__PURE__ */ Facet.define();
  const outerDecorations$1 = /* @__PURE__ */ Facet.define();
  const atomicRanges$1 = /* @__PURE__ */ Facet.define();
  const bidiIsolatedRanges$1 = /* @__PURE__ */ Facet.define();
  function getIsolatedRanges$1(view, line2) {
    let isolates = view.state.facet(bidiIsolatedRanges$1);
    if (!isolates.length)
      return isolates;
    let sets = isolates.map((i2) => i2 instanceof Function ? i2(view) : i2);
    let result = [];
    RangeSet.spans(sets, line2.from, line2.to, {
      point() {
      },
      span(fromDoc, toDoc, active, open) {
        let from2 = fromDoc - line2.from, to = toDoc - line2.from;
        let level = result;
        for (let i2 = active.length - 1; i2 >= 0; i2--, open--) {
          let direction = active[i2].spec.bidiIsolate, update;
          if (direction == null)
            direction = autoDirection$1(line2.text, from2, to);
          if (open > 0 && level.length && (update = level[level.length - 1]).to == from2 && update.direction == direction) {
            update.to = to;
            level = update.inner;
          } else {
            let add = { from: from2, to, direction, inner: [] };
            level.push(add);
            level = add.inner;
          }
        }
      }
    });
    return result;
  }
  const scrollMargins$1 = /* @__PURE__ */ Facet.define();
  function getScrollMargins$1(view) {
    let left2 = 0, right2 = 0, top2 = 0, bottom2 = 0;
    for (let source of view.state.facet(scrollMargins$1)) {
      let m2 = source(view);
      if (m2) {
        if (m2.left != null)
          left2 = Math.max(left2, m2.left);
        if (m2.right != null)
          right2 = Math.max(right2, m2.right);
        if (m2.top != null)
          top2 = Math.max(top2, m2.top);
        if (m2.bottom != null)
          bottom2 = Math.max(bottom2, m2.bottom);
      }
    }
    return { left: left2, right: right2, top: top2, bottom: bottom2 };
  }
  const styleModule$1 = /* @__PURE__ */ Facet.define();
  let ChangedRange$1 = class ChangedRange2 {
    constructor(fromA, toA, fromB, toB) {
      this.fromA = fromA;
      this.toA = toA;
      this.fromB = fromB;
      this.toB = toB;
    }
    join(other) {
      return new ChangedRange2(Math.min(this.fromA, other.fromA), Math.max(this.toA, other.toA), Math.min(this.fromB, other.fromB), Math.max(this.toB, other.toB));
    }
    addToSet(set) {
      let i2 = set.length, me2 = this;
      for (; i2 > 0; i2--) {
        let range = set[i2 - 1];
        if (range.fromA > me2.toA)
          continue;
        if (range.toA < me2.fromA)
          break;
        me2 = me2.join(range);
        set.splice(i2 - 1, 1);
      }
      set.splice(i2, 0, me2);
      return set;
    }
    static extendWithRanges(diff, ranges) {
      if (ranges.length == 0)
        return diff;
      let result = [];
      for (let dI = 0, rI = 0, posA = 0, posB = 0; ; dI++) {
        let next2 = dI == diff.length ? null : diff[dI], off = posA - posB;
        let end2 = next2 ? next2.fromB : 1e9;
        while (rI < ranges.length && ranges[rI] < end2) {
          let from2 = ranges[rI], to = ranges[rI + 1];
          let fromB = Math.max(posB, from2), toB = Math.min(end2, to);
          if (fromB <= toB)
            new ChangedRange2(fromB + off, toB + off, fromB, toB).addToSet(result);
          if (to > end2)
            break;
          else
            rI += 2;
        }
        if (!next2)
          return result;
        new ChangedRange2(next2.fromA, next2.toA, next2.fromB, next2.toB).addToSet(result);
        posA = next2.toA;
        posB = next2.toB;
      }
    }
  };
  let ViewUpdate$1 = class ViewUpdate2 {
    constructor(view, state, transactions) {
      this.view = view;
      this.state = state;
      this.transactions = transactions;
      this.flags = 0;
      this.startState = view.state;
      this.changes = ChangeSet.empty(this.startState.doc.length);
      for (let tr2 of transactions)
        this.changes = this.changes.compose(tr2.changes);
      let changedRanges = [];
      this.changes.iterChangedRanges((fromA, toA, fromB, toB) => changedRanges.push(new ChangedRange$1(fromA, toA, fromB, toB)));
      this.changedRanges = changedRanges;
    }
    /**
    @internal
    */
    static create(view, state, transactions) {
      return new ViewUpdate2(view, state, transactions);
    }
    /**
    Tells you whether the [viewport](https://codemirror.net/6/docs/ref/#view.EditorView.viewport) or
    [visible ranges](https://codemirror.net/6/docs/ref/#view.EditorView.visibleRanges) changed in this
    update.
    */
    get viewportChanged() {
      return (this.flags & 4) > 0;
    }
    /**
    Returns true when
    [`viewportChanged`](https://codemirror.net/6/docs/ref/#view.ViewUpdate.viewportChanged) is true
    and the viewport change is not just the result of mapping it in
    response to document changes.
    */
    get viewportMoved() {
      return (this.flags & 8) > 0;
    }
    /**
    Indicates whether the height of a block element in the editor
    changed in this update.
    */
    get heightChanged() {
      return (this.flags & 2) > 0;
    }
    /**
    Returns true when the document was modified or the size of the
    editor, or elements within the editor, changed.
    */
    get geometryChanged() {
      return this.docChanged || (this.flags & (16 | 2)) > 0;
    }
    /**
    True when this update indicates a focus change.
    */
    get focusChanged() {
      return (this.flags & 1) > 0;
    }
    /**
    Whether the document changed in this update.
    */
    get docChanged() {
      return !this.changes.empty;
    }
    /**
    Whether the selection was explicitly set in this update.
    */
    get selectionSet() {
      return this.transactions.some((tr2) => tr2.selection);
    }
    /**
    @internal
    */
    get empty() {
      return this.flags == 0 && this.transactions.length == 0;
    }
  };
  let DocView$1 = class DocView extends ContentView$1 {
    get length() {
      return this.view.state.doc.length;
    }
    constructor(view) {
      super();
      this.view = view;
      this.decorations = [];
      this.dynamicDecorationMap = [false];
      this.domChanged = null;
      this.hasComposition = null;
      this.markedForComposition = /* @__PURE__ */ new Set();
      this.editContextFormatting = Decoration$1.none;
      this.lastCompositionAfterCursor = false;
      this.minWidth = 0;
      this.minWidthFrom = 0;
      this.minWidthTo = 0;
      this.impreciseAnchor = null;
      this.impreciseHead = null;
      this.forceSelection = false;
      this.lastUpdate = Date.now();
      this.setDOM(view.contentDOM);
      this.children = [new LineView$1()];
      this.children[0].setParent(this);
      this.updateDeco();
      this.updateInner([new ChangedRange$1(0, 0, 0, view.state.doc.length)], 0, null);
    }
    // Update the document view to a given state.
    update(update) {
      var _a3;
      let changedRanges = update.changedRanges;
      if (this.minWidth > 0 && changedRanges.length) {
        if (!changedRanges.every(({ fromA, toA }) => toA < this.minWidthFrom || fromA > this.minWidthTo)) {
          this.minWidth = this.minWidthFrom = this.minWidthTo = 0;
        } else {
          this.minWidthFrom = update.changes.mapPos(this.minWidthFrom, 1);
          this.minWidthTo = update.changes.mapPos(this.minWidthTo, 1);
        }
      }
      this.updateEditContextFormatting(update);
      let readCompositionAt = -1;
      if (this.view.inputState.composing >= 0 && !this.view.observer.editContext) {
        if ((_a3 = this.domChanged) === null || _a3 === void 0 ? void 0 : _a3.newSel)
          readCompositionAt = this.domChanged.newSel.head;
        else if (!touchesComposition$1(update.changes, this.hasComposition) && !update.selectionSet)
          readCompositionAt = update.state.selection.main.head;
      }
      let composition = readCompositionAt > -1 ? findCompositionRange$1(this.view, update.changes, readCompositionAt) : null;
      this.domChanged = null;
      if (this.hasComposition) {
        this.markedForComposition.clear();
        let { from: from2, to } = this.hasComposition;
        changedRanges = new ChangedRange$1(from2, to, update.changes.mapPos(from2, -1), update.changes.mapPos(to, 1)).addToSet(changedRanges.slice());
      }
      this.hasComposition = composition ? { from: composition.range.fromB, to: composition.range.toB } : null;
      if ((browser$1.ie || browser$1.chrome) && !composition && update && update.state.doc.lines != update.startState.doc.lines)
        this.forceSelection = true;
      let prevDeco = this.decorations, deco = this.updateDeco();
      let decoDiff = findChangedDeco$1(prevDeco, deco, update.changes);
      changedRanges = ChangedRange$1.extendWithRanges(changedRanges, decoDiff);
      if (!(this.flags & 7) && changedRanges.length == 0) {
        return false;
      } else {
        this.updateInner(changedRanges, update.startState.doc.length, composition);
        if (update.transactions.length)
          this.lastUpdate = Date.now();
        return true;
      }
    }
    // Used by update and the constructor do perform the actual DOM
    // update
    updateInner(changes, oldLength, composition) {
      this.view.viewState.mustMeasureContent = true;
      this.updateChildren(changes, oldLength, composition);
      let { observer } = this.view;
      observer.ignore(() => {
        this.dom.style.height = this.view.viewState.contentHeight / this.view.scaleY + "px";
        this.dom.style.flexBasis = this.minWidth ? this.minWidth + "px" : "";
        let track = browser$1.chrome || browser$1.ios ? { node: observer.selectionRange.focusNode, written: false } : void 0;
        this.sync(this.view, track);
        this.flags &= ~7;
        if (track && (track.written || observer.selectionRange.focusNode != track.node))
          this.forceSelection = true;
        this.dom.style.height = "";
      });
      this.markedForComposition.forEach(
        (cView) => cView.flags &= ~8
        /* ViewFlag.Composition */
      );
      let gaps = [];
      if (this.view.viewport.from || this.view.viewport.to < this.view.state.doc.length) {
        for (let child of this.children)
          if (child instanceof BlockWidgetView$1 && child.widget instanceof BlockGapWidget$1)
            gaps.push(child.dom);
      }
      observer.updateGaps(gaps);
    }
    updateChildren(changes, oldLength, composition) {
      let ranges = composition ? composition.range.addToSet(changes.slice()) : changes;
      let cursor2 = this.childCursor(oldLength);
      for (let i2 = ranges.length - 1; ; i2--) {
        let next2 = i2 >= 0 ? ranges[i2] : null;
        if (!next2)
          break;
        let { fromA, toA, fromB, toB } = next2, content2, breakAtStart, openStart, openEnd;
        if (composition && composition.range.fromB < toB && composition.range.toB > fromB) {
          let before = ContentBuilder$1.build(this.view.state.doc, fromB, composition.range.fromB, this.decorations, this.dynamicDecorationMap);
          let after = ContentBuilder$1.build(this.view.state.doc, composition.range.toB, toB, this.decorations, this.dynamicDecorationMap);
          breakAtStart = before.breakAtStart;
          openStart = before.openStart;
          openEnd = after.openEnd;
          let compLine = this.compositionView(composition);
          if (after.breakAtStart) {
            compLine.breakAfter = 1;
          } else if (after.content.length && compLine.merge(compLine.length, compLine.length, after.content[0], false, after.openStart, 0)) {
            compLine.breakAfter = after.content[0].breakAfter;
            after.content.shift();
          }
          if (before.content.length && compLine.merge(0, 0, before.content[before.content.length - 1], true, 0, before.openEnd)) {
            before.content.pop();
          }
          content2 = before.content.concat(compLine).concat(after.content);
        } else {
          ({ content: content2, breakAtStart, openStart, openEnd } = ContentBuilder$1.build(this.view.state.doc, fromB, toB, this.decorations, this.dynamicDecorationMap));
        }
        let { i: toI, off: toOff } = cursor2.findPos(toA, 1);
        let { i: fromI, off: fromOff } = cursor2.findPos(fromA, -1);
        replaceRange$1(this, fromI, fromOff, toI, toOff, content2, breakAtStart, openStart, openEnd);
      }
      if (composition)
        this.fixCompositionDOM(composition);
    }
    updateEditContextFormatting(update) {
      this.editContextFormatting = this.editContextFormatting.map(update.changes);
      for (let tr2 of update.transactions)
        for (let effect2 of tr2.effects)
          if (effect2.is(setEditContextFormatting$1)) {
            this.editContextFormatting = effect2.value;
          }
    }
    compositionView(composition) {
      let cur = new TextView$1(composition.text.nodeValue);
      cur.flags |= 8;
      for (let { deco } of composition.marks)
        cur = new MarkView$1(deco, [cur], cur.length);
      let line2 = new LineView$1();
      line2.append(cur, 0);
      return line2;
    }
    fixCompositionDOM(composition) {
      let fix = (dom, cView2) => {
        cView2.flags |= 8 | (cView2.children.some(
          (c2) => c2.flags & 7
          /* ViewFlag.Dirty */
        ) ? 1 : 0);
        this.markedForComposition.add(cView2);
        let prev2 = ContentView$1.get(dom);
        if (prev2 && prev2 != cView2)
          prev2.dom = null;
        cView2.setDOM(dom);
      };
      let pos = this.childPos(composition.range.fromB, 1);
      let cView = this.children[pos.i];
      fix(composition.line, cView);
      for (let i2 = composition.marks.length - 1; i2 >= -1; i2--) {
        pos = cView.childPos(pos.off, 1);
        cView = cView.children[pos.i];
        fix(i2 >= 0 ? composition.marks[i2].node : composition.text, cView);
      }
    }
    // Sync the DOM selection to this.state.selection
    updateSelection(mustRead = false, fromPointer = false) {
      if (mustRead || !this.view.observer.selectionRange.focusNode)
        this.view.observer.readSelectionRange();
      let activeElt = this.view.root.activeElement, focused = activeElt == this.dom;
      let selectionNotFocus = !focused && !(this.view.state.facet(editable$1) || this.dom.tabIndex > -1) && hasSelection$1(this.dom, this.view.observer.selectionRange) && !(activeElt && this.dom.contains(activeElt));
      if (!(focused || fromPointer || selectionNotFocus))
        return;
      let force = this.forceSelection;
      this.forceSelection = false;
      let main2 = this.view.state.selection.main;
      let anchor = this.moveToLine(this.domAtPos(main2.anchor));
      let head = main2.empty ? anchor : this.moveToLine(this.domAtPos(main2.head));
      if (browser$1.gecko && main2.empty && !this.hasComposition && betweenUneditable$1(anchor)) {
        let dummy = document.createTextNode("");
        this.view.observer.ignore(() => anchor.node.insertBefore(dummy, anchor.node.childNodes[anchor.offset] || null));
        anchor = head = new DOMPos$1(dummy, 0);
        force = true;
      }
      let domSel = this.view.observer.selectionRange;
      if (force || !domSel.focusNode || (!isEquivalentPosition$1(anchor.node, anchor.offset, domSel.anchorNode, domSel.anchorOffset) || !isEquivalentPosition$1(head.node, head.offset, domSel.focusNode, domSel.focusOffset)) && !this.suppressWidgetCursorChange(domSel, main2)) {
        this.view.observer.ignore(() => {
          if (browser$1.android && browser$1.chrome && this.dom.contains(domSel.focusNode) && inUneditable$1(domSel.focusNode, this.dom)) {
            this.dom.blur();
            this.dom.focus({ preventScroll: true });
          }
          let rawSel = getSelection$2(this.view.root);
          if (!rawSel)
            ;
          else if (main2.empty) {
            if (browser$1.gecko) {
              let nextTo = nextToUneditable$1(anchor.node, anchor.offset);
              if (nextTo && nextTo != (1 | 2)) {
                let text = (nextTo == 1 ? textNodeBefore$1 : textNodeAfter$1)(anchor.node, anchor.offset);
                if (text)
                  anchor = new DOMPos$1(text.node, text.offset);
              }
            }
            rawSel.collapse(anchor.node, anchor.offset);
            if (main2.bidiLevel != null && rawSel.caretBidiLevel !== void 0)
              rawSel.caretBidiLevel = main2.bidiLevel;
          } else if (rawSel.extend) {
            rawSel.collapse(anchor.node, anchor.offset);
            try {
              rawSel.extend(head.node, head.offset);
            } catch (_2) {
            }
          } else {
            let range = document.createRange();
            if (main2.anchor > main2.head)
              [anchor, head] = [head, anchor];
            range.setEnd(head.node, head.offset);
            range.setStart(anchor.node, anchor.offset);
            rawSel.removeAllRanges();
            rawSel.addRange(range);
          }
          if (selectionNotFocus && this.view.root.activeElement == this.dom) {
            this.dom.blur();
            if (activeElt)
              activeElt.focus();
          }
        });
        this.view.observer.setSelectionRange(anchor, head);
      }
      this.impreciseAnchor = anchor.precise ? null : new DOMPos$1(domSel.anchorNode, domSel.anchorOffset);
      this.impreciseHead = head.precise ? null : new DOMPos$1(domSel.focusNode, domSel.focusOffset);
    }
    // If a zero-length widget is inserted next to the cursor during
    // composition, avoid moving it across it and disrupting the
    // composition.
    suppressWidgetCursorChange(sel, cursor2) {
      return this.hasComposition && cursor2.empty && isEquivalentPosition$1(sel.focusNode, sel.focusOffset, sel.anchorNode, sel.anchorOffset) && this.posFromDOM(sel.focusNode, sel.focusOffset) == cursor2.head;
    }
    enforceCursorAssoc() {
      if (this.hasComposition)
        return;
      let { view } = this, cursor2 = view.state.selection.main;
      let sel = getSelection$2(view.root);
      let { anchorNode, anchorOffset } = view.observer.selectionRange;
      if (!sel || !cursor2.empty || !cursor2.assoc || !sel.modify)
        return;
      let line2 = LineView$1.find(this, cursor2.head);
      if (!line2)
        return;
      let lineStart = line2.posAtStart;
      if (cursor2.head == lineStart || cursor2.head == lineStart + line2.length)
        return;
      let before = this.coordsAt(cursor2.head, -1), after = this.coordsAt(cursor2.head, 1);
      if (!before || !after || before.bottom > after.top)
        return;
      let dom = this.domAtPos(cursor2.head + cursor2.assoc);
      sel.collapse(dom.node, dom.offset);
      sel.modify("move", cursor2.assoc < 0 ? "forward" : "backward", "lineboundary");
      view.observer.readSelectionRange();
      let newRange = view.observer.selectionRange;
      if (view.docView.posFromDOM(newRange.anchorNode, newRange.anchorOffset) != cursor2.from)
        sel.collapse(anchorNode, anchorOffset);
    }
    // If a position is in/near a block widget, move it to a nearby text
    // line, since we don't want the cursor inside a block widget.
    moveToLine(pos) {
      let dom = this.dom, newPos;
      if (pos.node != dom)
        return pos;
      for (let i2 = pos.offset; !newPos && i2 < dom.childNodes.length; i2++) {
        let view = ContentView$1.get(dom.childNodes[i2]);
        if (view instanceof LineView$1)
          newPos = view.domAtPos(0);
      }
      for (let i2 = pos.offset - 1; !newPos && i2 >= 0; i2--) {
        let view = ContentView$1.get(dom.childNodes[i2]);
        if (view instanceof LineView$1)
          newPos = view.domAtPos(view.length);
      }
      return newPos ? new DOMPos$1(newPos.node, newPos.offset, true) : pos;
    }
    nearest(dom) {
      for (let cur = dom; cur; ) {
        let domView = ContentView$1.get(cur);
        if (domView && domView.rootView == this)
          return domView;
        cur = cur.parentNode;
      }
      return null;
    }
    posFromDOM(node2, offset2) {
      let view = this.nearest(node2);
      if (!view)
        throw new RangeError("Trying to find position for a DOM position outside of the document");
      return view.localPosFromDOM(node2, offset2) + view.posAtStart;
    }
    domAtPos(pos) {
      let { i: i2, off } = this.childCursor().findPos(pos, -1);
      for (; i2 < this.children.length - 1; ) {
        let child = this.children[i2];
        if (off < child.length || child instanceof LineView$1)
          break;
        i2++;
        off = 0;
      }
      return this.children[i2].domAtPos(off);
    }
    coordsAt(pos, side) {
      let best = null, bestPos = 0;
      for (let off = this.length, i2 = this.children.length - 1; i2 >= 0; i2--) {
        let child = this.children[i2], end2 = off - child.breakAfter, start2 = end2 - child.length;
        if (end2 < pos)
          break;
        if (start2 <= pos && (start2 < pos || child.covers(-1)) && (end2 > pos || child.covers(1)) && (!best || child instanceof LineView$1 && !(best instanceof LineView$1 && side >= 0))) {
          best = child;
          bestPos = start2;
        } else if (best && start2 == pos && end2 == pos && child instanceof BlockWidgetView$1 && Math.abs(side) < 2) {
          if (child.deco.startSide < 0)
            break;
          else if (i2)
            best = null;
        }
        off = start2;
      }
      return best ? best.coordsAt(pos - bestPos, side) : null;
    }
    coordsForChar(pos) {
      let { i: i2, off } = this.childPos(pos, 1), child = this.children[i2];
      if (!(child instanceof LineView$1))
        return null;
      while (child.children.length) {
        let { i: i3, off: childOff } = child.childPos(off, 1);
        for (; ; i3++) {
          if (i3 == child.children.length)
            return null;
          if ((child = child.children[i3]).length)
            break;
        }
        off = childOff;
      }
      if (!(child instanceof TextView$1))
        return null;
      let end2 = findClusterBreak(child.text, off);
      if (end2 == off)
        return null;
      let rects = textRange$1(child.dom, off, end2).getClientRects();
      for (let i3 = 0; i3 < rects.length; i3++) {
        let rect = rects[i3];
        if (i3 == rects.length - 1 || rect.top < rect.bottom && rect.left < rect.right)
          return rect;
      }
      return null;
    }
    measureVisibleLineHeights(viewport2) {
      let result = [], { from: from2, to } = viewport2;
      let contentWidth = this.view.contentDOM.clientWidth;
      let isWider = contentWidth > Math.max(this.view.scrollDOM.clientWidth, this.minWidth) + 1;
      let widest = -1, ltr = this.view.textDirection == Direction$1.LTR;
      for (let pos = 0, i2 = 0; i2 < this.children.length; i2++) {
        let child = this.children[i2], end2 = pos + child.length;
        if (end2 > to)
          break;
        if (pos >= from2) {
          let childRect = child.dom.getBoundingClientRect();
          result.push(childRect.height);
          if (isWider) {
            let last = child.dom.lastChild;
            let rects = last ? clientRectsFor$1(last) : [];
            if (rects.length) {
              let rect = rects[rects.length - 1];
              let width2 = ltr ? rect.right - childRect.left : childRect.right - rect.left;
              if (width2 > widest) {
                widest = width2;
                this.minWidth = contentWidth;
                this.minWidthFrom = pos;
                this.minWidthTo = end2;
              }
            }
          }
        }
        pos = end2 + child.breakAfter;
      }
      return result;
    }
    textDirectionAt(pos) {
      let { i: i2 } = this.childPos(pos, 1);
      return getComputedStyle(this.children[i2].dom).direction == "rtl" ? Direction$1.RTL : Direction$1.LTR;
    }
    measureTextSize() {
      for (let child of this.children) {
        if (child instanceof LineView$1) {
          let measure = child.measureTextSize();
          if (measure)
            return measure;
        }
      }
      let dummy = document.createElement("div"), lineHeight, charWidth, textHeight;
      dummy.className = "cm-line";
      dummy.style.width = "99999px";
      dummy.style.position = "absolute";
      dummy.textContent = "abc def ghi jkl mno pqr stu";
      this.view.observer.ignore(() => {
        this.dom.appendChild(dummy);
        let rect = clientRectsFor$1(dummy.firstChild)[0];
        lineHeight = dummy.getBoundingClientRect().height;
        charWidth = rect ? rect.width / 27 : 7;
        textHeight = rect ? rect.height : lineHeight;
        dummy.remove();
      });
      return { lineHeight, charWidth, textHeight };
    }
    childCursor(pos = this.length) {
      let i2 = this.children.length;
      if (i2)
        pos -= this.children[--i2].length;
      return new ChildCursor$1(this.children, pos, i2);
    }
    computeBlockGapDeco() {
      let deco = [], vs2 = this.view.viewState;
      for (let pos = 0, i2 = 0; ; i2++) {
        let next2 = i2 == vs2.viewports.length ? null : vs2.viewports[i2];
        let end2 = next2 ? next2.from - 1 : this.length;
        if (end2 > pos) {
          let height2 = (vs2.lineBlockAt(end2).bottom - vs2.lineBlockAt(pos).top) / this.view.scaleY;
          deco.push(Decoration$1.replace({
            widget: new BlockGapWidget$1(height2),
            block: true,
            inclusive: true,
            isBlockGap: true
          }).range(pos, end2));
        }
        if (!next2)
          break;
        pos = next2.to + 1;
      }
      return Decoration$1.set(deco);
    }
    updateDeco() {
      let i2 = 1;
      let allDeco = this.view.state.facet(decorations$1).map((d) => {
        let dynamic = this.dynamicDecorationMap[i2++] = typeof d == "function";
        return dynamic ? d(this.view) : d;
      });
      let dynamicOuter = false, outerDeco = this.view.state.facet(outerDecorations$1).map((d, i3) => {
        let dynamic = typeof d == "function";
        if (dynamic)
          dynamicOuter = true;
        return dynamic ? d(this.view) : d;
      });
      if (outerDeco.length) {
        this.dynamicDecorationMap[i2++] = dynamicOuter;
        allDeco.push(RangeSet.join(outerDeco));
      }
      this.decorations = [
        this.editContextFormatting,
        ...allDeco,
        this.computeBlockGapDeco(),
        this.view.viewState.lineGapDeco
      ];
      while (i2 < this.decorations.length)
        this.dynamicDecorationMap[i2++] = false;
      return this.decorations;
    }
    scrollIntoView(target) {
      if (target.isSnapshot) {
        let ref = this.view.viewState.lineBlockAt(target.range.head);
        this.view.scrollDOM.scrollTop = ref.top - target.yMargin;
        this.view.scrollDOM.scrollLeft = target.xMargin;
        return;
      }
      for (let handler of this.view.state.facet(scrollHandler$1)) {
        try {
          if (handler(this.view, target.range, target))
            return true;
        } catch (e) {
          logException$1(this.view.state, e, "scroll handler");
        }
      }
      let { range } = target;
      let rect = this.coordsAt(range.head, range.empty ? range.assoc : range.head > range.anchor ? -1 : 1), other;
      if (!rect)
        return;
      if (!range.empty && (other = this.coordsAt(range.anchor, range.anchor > range.head ? -1 : 1)))
        rect = {
          left: Math.min(rect.left, other.left),
          top: Math.min(rect.top, other.top),
          right: Math.max(rect.right, other.right),
          bottom: Math.max(rect.bottom, other.bottom)
        };
      let margins = getScrollMargins$1(this.view);
      let targetRect = {
        left: rect.left - margins.left,
        top: rect.top - margins.top,
        right: rect.right + margins.right,
        bottom: rect.bottom + margins.bottom
      };
      let { offsetWidth, offsetHeight } = this.view.scrollDOM;
      scrollRectIntoView$1(this.view.scrollDOM, targetRect, range.head < range.anchor ? -1 : 1, target.x, target.y, Math.max(Math.min(target.xMargin, offsetWidth), -offsetWidth), Math.max(Math.min(target.yMargin, offsetHeight), -offsetHeight), this.view.textDirection == Direction$1.LTR);
    }
  };
  function betweenUneditable$1(pos) {
    return pos.node.nodeType == 1 && pos.node.firstChild && (pos.offset == 0 || pos.node.childNodes[pos.offset - 1].contentEditable == "false") && (pos.offset == pos.node.childNodes.length || pos.node.childNodes[pos.offset].contentEditable == "false");
  }
  function findCompositionNode$1(view, headPos) {
    let sel = view.observer.selectionRange;
    if (!sel.focusNode)
      return null;
    let textBefore = textNodeBefore$1(sel.focusNode, sel.focusOffset);
    let textAfter = textNodeAfter$1(sel.focusNode, sel.focusOffset);
    let textNode = textBefore || textAfter;
    if (textAfter && textBefore && textAfter.node != textBefore.node) {
      let descAfter = ContentView$1.get(textAfter.node);
      if (!descAfter || descAfter instanceof TextView$1 && descAfter.text != textAfter.node.nodeValue) {
        textNode = textAfter;
      } else if (view.docView.lastCompositionAfterCursor) {
        let descBefore = ContentView$1.get(textBefore.node);
        if (!(!descBefore || descBefore instanceof TextView$1 && descBefore.text != textBefore.node.nodeValue))
          textNode = textAfter;
      }
    }
    view.docView.lastCompositionAfterCursor = textNode != textBefore;
    if (!textNode)
      return null;
    let from2 = headPos - textNode.offset;
    return { from: from2, to: from2 + textNode.node.nodeValue.length, node: textNode.node };
  }
  function findCompositionRange$1(view, changes, headPos) {
    let found = findCompositionNode$1(view, headPos);
    if (!found)
      return null;
    let { node: textNode, from: from2, to } = found, text = textNode.nodeValue;
    if (/[\n\r]/.test(text))
      return null;
    if (view.state.doc.sliceString(found.from, found.to) != text)
      return null;
    let inv = changes.invertedDesc;
    let range = new ChangedRange$1(inv.mapPos(from2), inv.mapPos(to), from2, to);
    let marks = [];
    for (let parent = textNode.parentNode; ; parent = parent.parentNode) {
      let parentView = ContentView$1.get(parent);
      if (parentView instanceof MarkView$1)
        marks.push({ node: parent, deco: parentView.mark });
      else if (parentView instanceof LineView$1 || parent.nodeName == "DIV" && parent.parentNode == view.contentDOM)
        return { range, text: textNode, marks, line: parent };
      else if (parent != view.contentDOM)
        marks.push({ node: parent, deco: new MarkDecoration$1({
          inclusive: true,
          attributes: getAttrs$1(parent),
          tagName: parent.tagName.toLowerCase()
        }) });
      else
        return null;
    }
  }
  function nextToUneditable$1(node2, offset2) {
    if (node2.nodeType != 1)
      return 0;
    return (offset2 && node2.childNodes[offset2 - 1].contentEditable == "false" ? 1 : 0) | (offset2 < node2.childNodes.length && node2.childNodes[offset2].contentEditable == "false" ? 2 : 0);
  }
  let DecorationComparator$1$1 = class DecorationComparator {
    constructor() {
      this.changes = [];
    }
    compareRange(from2, to) {
      addRange$1(from2, to, this.changes);
    }
    comparePoint(from2, to) {
      addRange$1(from2, to, this.changes);
    }
    boundChange(pos) {
      addRange$1(pos, pos, this.changes);
    }
  };
  function findChangedDeco$1(a2, b, diff) {
    let comp = new DecorationComparator$1$1();
    RangeSet.compare(a2, b, diff, comp);
    return comp.changes;
  }
  function inUneditable$1(node2, inside2) {
    for (let cur = node2; cur && cur != inside2; cur = cur.assignedSlot || cur.parentNode) {
      if (cur.nodeType == 1 && cur.contentEditable == "false") {
        return true;
      }
    }
    return false;
  }
  function touchesComposition$1(changes, composition) {
    let touched = false;
    if (composition)
      changes.iterChangedRanges((from2, to) => {
        if (from2 < composition.to && to > composition.from)
          touched = true;
      });
    return touched;
  }
  function groupAt$1(state, pos, bias = 1) {
    let categorize = state.charCategorizer(pos);
    let line2 = state.doc.lineAt(pos), linePos = pos - line2.from;
    if (line2.length == 0)
      return EditorSelection.cursor(pos);
    if (linePos == 0)
      bias = 1;
    else if (linePos == line2.length)
      bias = -1;
    let from2 = linePos, to = linePos;
    if (bias < 0)
      from2 = findClusterBreak(line2.text, linePos, false);
    else
      to = findClusterBreak(line2.text, linePos);
    let cat = categorize(line2.text.slice(from2, to));
    while (from2 > 0) {
      let prev2 = findClusterBreak(line2.text, from2, false);
      if (categorize(line2.text.slice(prev2, from2)) != cat)
        break;
      from2 = prev2;
    }
    while (to < line2.length) {
      let next2 = findClusterBreak(line2.text, to);
      if (categorize(line2.text.slice(to, next2)) != cat)
        break;
      to = next2;
    }
    return EditorSelection.range(from2 + line2.from, to + line2.from);
  }
  function getdx$1(x2, rect) {
    return rect.left > x2 ? rect.left - x2 : Math.max(0, x2 - rect.right);
  }
  function getdy$1(y, rect) {
    return rect.top > y ? rect.top - y : Math.max(0, y - rect.bottom);
  }
  function yOverlap$1(a2, b) {
    return a2.top < b.bottom - 1 && a2.bottom > b.top + 1;
  }
  function upTop$1(rect, top2) {
    return top2 < rect.top ? { top: top2, left: rect.left, right: rect.right, bottom: rect.bottom } : rect;
  }
  function upBot$1(rect, bottom2) {
    return bottom2 > rect.bottom ? { top: rect.top, left: rect.left, right: rect.right, bottom: bottom2 } : rect;
  }
  function domPosAtCoords$1(parent, x2, y) {
    let closest, closestRect, closestX, closestY, closestOverlap = false;
    let above, below, aboveRect, belowRect;
    for (let child = parent.firstChild; child; child = child.nextSibling) {
      let rects = clientRectsFor$1(child);
      for (let i2 = 0; i2 < rects.length; i2++) {
        let rect = rects[i2];
        if (closestRect && yOverlap$1(closestRect, rect))
          rect = upTop$1(upBot$1(rect, closestRect.bottom), closestRect.top);
        let dx = getdx$1(x2, rect), dy = getdy$1(y, rect);
        if (dx == 0 && dy == 0)
          return child.nodeType == 3 ? domPosInText$1(child, x2, y) : domPosAtCoords$1(child, x2, y);
        if (!closest || closestY > dy || closestY == dy && closestX > dx) {
          closest = child;
          closestRect = rect;
          closestX = dx;
          closestY = dy;
          let side = dy ? y < rect.top ? -1 : 1 : dx ? x2 < rect.left ? -1 : 1 : 0;
          closestOverlap = !side || (side > 0 ? i2 < rects.length - 1 : i2 > 0);
        }
        if (dx == 0) {
          if (y > rect.bottom && (!aboveRect || aboveRect.bottom < rect.bottom)) {
            above = child;
            aboveRect = rect;
          } else if (y < rect.top && (!belowRect || belowRect.top > rect.top)) {
            below = child;
            belowRect = rect;
          }
        } else if (aboveRect && yOverlap$1(aboveRect, rect)) {
          aboveRect = upBot$1(aboveRect, rect.bottom);
        } else if (belowRect && yOverlap$1(belowRect, rect)) {
          belowRect = upTop$1(belowRect, rect.top);
        }
      }
    }
    if (aboveRect && aboveRect.bottom >= y) {
      closest = above;
      closestRect = aboveRect;
    } else if (belowRect && belowRect.top <= y) {
      closest = below;
      closestRect = belowRect;
    }
    if (!closest)
      return { node: parent, offset: 0 };
    let clipX = Math.max(closestRect.left, Math.min(closestRect.right, x2));
    if (closest.nodeType == 3)
      return domPosInText$1(closest, clipX, y);
    if (closestOverlap && closest.contentEditable != "false")
      return domPosAtCoords$1(closest, clipX, y);
    let offset2 = Array.prototype.indexOf.call(parent.childNodes, closest) + (x2 >= (closestRect.left + closestRect.right) / 2 ? 1 : 0);
    return { node: parent, offset: offset2 };
  }
  function domPosInText$1(node2, x2, y) {
    let len = node2.nodeValue.length;
    let closestOffset = -1, closestDY = 1e9, generalSide = 0;
    for (let i2 = 0; i2 < len; i2++) {
      let rects = textRange$1(node2, i2, i2 + 1).getClientRects();
      for (let j = 0; j < rects.length; j++) {
        let rect = rects[j];
        if (rect.top == rect.bottom)
          continue;
        if (!generalSide)
          generalSide = x2 - rect.left;
        let dy = (rect.top > y ? rect.top - y : y - rect.bottom) - 1;
        if (rect.left - 1 <= x2 && rect.right + 1 >= x2 && dy < closestDY) {
          let right2 = x2 >= (rect.left + rect.right) / 2, after = right2;
          if (browser$1.chrome || browser$1.gecko) {
            let rectBefore = textRange$1(node2, i2).getBoundingClientRect();
            if (rectBefore.left == rect.right)
              after = !right2;
          }
          if (dy <= 0)
            return { node: node2, offset: i2 + (after ? 1 : 0) };
          closestOffset = i2 + (after ? 1 : 0);
          closestDY = dy;
        }
      }
    }
    return { node: node2, offset: closestOffset > -1 ? closestOffset : generalSide > 0 ? node2.nodeValue.length : 0 };
  }
  function posAtCoords$1(view, coords, precise, bias = -1) {
    var _a3, _b;
    let content2 = view.contentDOM.getBoundingClientRect(), docTop = content2.top + view.viewState.paddingTop;
    let block, { docHeight } = view.viewState;
    let { x: x2, y } = coords, yOffset = y - docTop;
    if (yOffset < 0)
      return 0;
    if (yOffset > docHeight)
      return view.state.doc.length;
    for (let halfLine = view.viewState.heightOracle.textHeight / 2, bounced = false; ; ) {
      block = view.elementAtHeight(yOffset);
      if (block.type == BlockType$1.Text)
        break;
      for (; ; ) {
        yOffset = bias > 0 ? block.bottom + halfLine : block.top - halfLine;
        if (yOffset >= 0 && yOffset <= docHeight)
          break;
        if (bounced)
          return precise ? null : 0;
        bounced = true;
        bias = -bias;
      }
    }
    y = docTop + yOffset;
    let lineStart = block.from;
    if (lineStart < view.viewport.from)
      return view.viewport.from == 0 ? 0 : precise ? null : posAtCoordsImprecise$1(view, content2, block, x2, y);
    if (lineStart > view.viewport.to)
      return view.viewport.to == view.state.doc.length ? view.state.doc.length : precise ? null : posAtCoordsImprecise$1(view, content2, block, x2, y);
    let doc2 = view.dom.ownerDocument;
    let root = view.root.elementFromPoint ? view.root : doc2;
    let element = root.elementFromPoint(x2, y);
    if (element && !view.contentDOM.contains(element))
      element = null;
    if (!element) {
      x2 = Math.max(content2.left + 1, Math.min(content2.right - 1, x2));
      element = root.elementFromPoint(x2, y);
      if (element && !view.contentDOM.contains(element))
        element = null;
    }
    let node2, offset2 = -1;
    if (element && ((_a3 = view.docView.nearest(element)) === null || _a3 === void 0 ? void 0 : _a3.isEditable) != false) {
      if (doc2.caretPositionFromPoint) {
        let pos = doc2.caretPositionFromPoint(x2, y);
        if (pos)
          ({ offsetNode: node2, offset: offset2 } = pos);
      } else if (doc2.caretRangeFromPoint) {
        let range = doc2.caretRangeFromPoint(x2, y);
        if (range) {
          ({ startContainer: node2, startOffset: offset2 } = range);
          if (!view.contentDOM.contains(node2) || browser$1.safari && isSuspiciousSafariCaretResult$1(node2, offset2, x2) || browser$1.chrome && isSuspiciousChromeCaretResult$1(node2, offset2, x2))
            node2 = void 0;
        }
      }
      if (node2)
        offset2 = Math.min(maxOffset$1(node2), offset2);
    }
    if (!node2 || !view.docView.dom.contains(node2)) {
      let line2 = LineView$1.find(view.docView, lineStart);
      if (!line2)
        return yOffset > block.top + block.height / 2 ? block.to : block.from;
      ({ node: node2, offset: offset2 } = domPosAtCoords$1(line2.dom, x2, y));
    }
    let nearest = view.docView.nearest(node2);
    if (!nearest)
      return null;
    if (nearest.isWidget && ((_b = nearest.dom) === null || _b === void 0 ? void 0 : _b.nodeType) == 1) {
      let rect = nearest.dom.getBoundingClientRect();
      return coords.y < rect.top || coords.y <= rect.bottom && coords.x <= (rect.left + rect.right) / 2 ? nearest.posAtStart : nearest.posAtEnd;
    } else {
      return nearest.localPosFromDOM(node2, offset2) + nearest.posAtStart;
    }
  }
  function posAtCoordsImprecise$1(view, contentRect, block, x2, y) {
    let into = Math.round((x2 - contentRect.left) * view.defaultCharacterWidth);
    if (view.lineWrapping && block.height > view.defaultLineHeight * 1.5) {
      let textHeight = view.viewState.heightOracle.textHeight;
      let line2 = Math.floor((y - block.top - (view.defaultLineHeight - textHeight) * 0.5) / textHeight);
      into += line2 * view.viewState.heightOracle.lineLength;
    }
    let content2 = view.state.sliceDoc(block.from, block.to);
    return block.from + findColumn(content2, into, view.state.tabSize);
  }
  function isSuspiciousSafariCaretResult$1(node2, offset2, x2) {
    let len;
    if (node2.nodeType != 3 || offset2 != (len = node2.nodeValue.length))
      return false;
    for (let next2 = node2.nextSibling; next2; next2 = next2.nextSibling)
      if (next2.nodeType != 1 || next2.nodeName != "BR")
        return false;
    return textRange$1(node2, len - 1, len).getBoundingClientRect().left > x2;
  }
  function isSuspiciousChromeCaretResult$1(node2, offset2, x2) {
    if (offset2 != 0)
      return false;
    for (let cur = node2; ; ) {
      let parent = cur.parentNode;
      if (!parent || parent.nodeType != 1 || parent.firstChild != cur)
        return false;
      if (parent.classList.contains("cm-line"))
        break;
      cur = parent;
    }
    let rect = node2.nodeType == 1 ? node2.getBoundingClientRect() : textRange$1(node2, 0, Math.max(node2.nodeValue.length, 1)).getBoundingClientRect();
    return x2 - rect.left > 5;
  }
  function blockAt$1(view, pos) {
    let line2 = view.lineBlockAt(pos);
    if (Array.isArray(line2.type))
      for (let l of line2.type) {
        if (l.to > pos || l.to == pos && (l.to == line2.to || l.type == BlockType$1.Text))
          return l;
      }
    return line2;
  }
  function moveToLineBoundary$1(view, start2, forward, includeWrap) {
    let line2 = blockAt$1(view, start2.head);
    let coords = !includeWrap || line2.type != BlockType$1.Text || !(view.lineWrapping || line2.widgetLineBreaks) ? null : view.coordsAtPos(start2.assoc < 0 && start2.head > line2.from ? start2.head - 1 : start2.head);
    if (coords) {
      let editorRect = view.dom.getBoundingClientRect();
      let direction = view.textDirectionAt(line2.from);
      let pos = view.posAtCoords({
        x: forward == (direction == Direction$1.LTR) ? editorRect.right - 1 : editorRect.left + 1,
        y: (coords.top + coords.bottom) / 2
      });
      if (pos != null)
        return EditorSelection.cursor(pos, forward ? -1 : 1);
    }
    return EditorSelection.cursor(forward ? line2.to : line2.from, forward ? -1 : 1);
  }
  function moveByChar$1(view, start2, forward, by) {
    let line2 = view.state.doc.lineAt(start2.head), spans = view.bidiSpans(line2);
    let direction = view.textDirectionAt(line2.from);
    for (let cur = start2, check = null; ; ) {
      let next2 = moveVisually$1(line2, spans, direction, cur, forward), char2 = movedOver$1;
      if (!next2) {
        if (line2.number == (forward ? view.state.doc.lines : 1))
          return cur;
        char2 = "\n";
        line2 = view.state.doc.line(line2.number + (forward ? 1 : -1));
        spans = view.bidiSpans(line2);
        next2 = view.visualLineSide(line2, !forward);
      }
      if (!check) {
        if (!by)
          return next2;
        check = by(char2);
      } else if (!check(char2)) {
        return cur;
      }
      cur = next2;
    }
  }
  function byGroup$1(view, pos, start2) {
    let categorize = view.state.charCategorizer(pos);
    let cat = categorize(start2);
    return (next2) => {
      let nextCat = categorize(next2);
      if (cat == CharCategory.Space)
        cat = nextCat;
      return cat == nextCat;
    };
  }
  function moveVertically$1(view, start2, forward, distance) {
    let startPos = start2.head, dir = forward ? 1 : -1;
    if (startPos == (forward ? view.state.doc.length : 0))
      return EditorSelection.cursor(startPos, start2.assoc);
    let goal = start2.goalColumn, startY;
    let rect = view.contentDOM.getBoundingClientRect();
    let startCoords = view.coordsAtPos(startPos, start2.assoc || -1), docTop = view.documentTop;
    if (startCoords) {
      if (goal == null)
        goal = startCoords.left - rect.left;
      startY = dir < 0 ? startCoords.top : startCoords.bottom;
    } else {
      let line2 = view.viewState.lineBlockAt(startPos);
      if (goal == null)
        goal = Math.min(rect.right - rect.left, view.defaultCharacterWidth * (startPos - line2.from));
      startY = (dir < 0 ? line2.top : line2.bottom) + docTop;
    }
    let resolvedGoal = rect.left + goal;
    let dist2 = distance !== null && distance !== void 0 ? distance : view.viewState.heightOracle.textHeight >> 1;
    for (let extra = 0; ; extra += 10) {
      let curY = startY + (dist2 + extra) * dir;
      let pos = posAtCoords$1(view, { x: resolvedGoal, y: curY }, false, dir);
      if (curY < rect.top || curY > rect.bottom || (dir < 0 ? pos < startPos : pos > startPos)) {
        let charRect = view.docView.coordsForChar(pos);
        let assoc = !charRect || curY < charRect.top ? -1 : 1;
        return EditorSelection.cursor(pos, assoc, void 0, goal);
      }
    }
  }
  function skipAtomicRanges$1(atoms, pos, bias) {
    for (; ; ) {
      let moved = 0;
      for (let set of atoms) {
        set.between(pos - 1, pos + 1, (from2, to, value) => {
          if (pos > from2 && pos < to) {
            let side = moved || bias || (pos - from2 < to - pos ? -1 : 1);
            pos = side < 0 ? from2 : to;
            moved = side;
          }
        });
      }
      if (!moved)
        return pos;
    }
  }
  function skipAtoms$1(view, oldPos, pos) {
    let newPos = skipAtomicRanges$1(view.state.facet(atomicRanges$1).map((f) => f(view)), pos.from, oldPos.head > pos.from ? -1 : 1);
    return newPos == pos.from ? pos : EditorSelection.cursor(newPos, newPos < pos.from ? 1 : -1);
  }
  const LineBreakPlaceholder$1 = "￿";
  let DOMReader$1 = class DOMReader {
    constructor(points, state) {
      this.points = points;
      this.text = "";
      this.lineSeparator = state.facet(EditorState.lineSeparator);
    }
    append(text) {
      this.text += text;
    }
    lineBreak() {
      this.text += LineBreakPlaceholder$1;
    }
    readRange(start2, end2) {
      if (!start2)
        return this;
      let parent = start2.parentNode;
      for (let cur = start2; ; ) {
        this.findPointBefore(parent, cur);
        let oldLen = this.text.length;
        this.readNode(cur);
        let next2 = cur.nextSibling;
        if (next2 == end2)
          break;
        let view = ContentView$1.get(cur), nextView = ContentView$1.get(next2);
        if (view && nextView ? view.breakAfter : (view ? view.breakAfter : isBlockElement$1(cur)) || isBlockElement$1(next2) && (cur.nodeName != "BR" || cur.cmIgnore) && this.text.length > oldLen)
          this.lineBreak();
        cur = next2;
      }
      this.findPointBefore(parent, end2);
      return this;
    }
    readTextNode(node2) {
      let text = node2.nodeValue;
      for (let point of this.points)
        if (point.node == node2)
          point.pos = this.text.length + Math.min(point.offset, text.length);
      for (let off = 0, re2 = this.lineSeparator ? null : /\r\n?|\n/g; ; ) {
        let nextBreak = -1, breakSize = 1, m2;
        if (this.lineSeparator) {
          nextBreak = text.indexOf(this.lineSeparator, off);
          breakSize = this.lineSeparator.length;
        } else if (m2 = re2.exec(text)) {
          nextBreak = m2.index;
          breakSize = m2[0].length;
        }
        this.append(text.slice(off, nextBreak < 0 ? text.length : nextBreak));
        if (nextBreak < 0)
          break;
        this.lineBreak();
        if (breakSize > 1) {
          for (let point of this.points)
            if (point.node == node2 && point.pos > this.text.length)
              point.pos -= breakSize - 1;
        }
        off = nextBreak + breakSize;
      }
    }
    readNode(node2) {
      if (node2.cmIgnore)
        return;
      let view = ContentView$1.get(node2);
      let fromView = view && view.overrideDOMText;
      if (fromView != null) {
        this.findPointInside(node2, fromView.length);
        for (let i2 = fromView.iter(); !i2.next().done; ) {
          if (i2.lineBreak)
            this.lineBreak();
          else
            this.append(i2.value);
        }
      } else if (node2.nodeType == 3) {
        this.readTextNode(node2);
      } else if (node2.nodeName == "BR") {
        if (node2.nextSibling)
          this.lineBreak();
      } else if (node2.nodeType == 1) {
        this.readRange(node2.firstChild, null);
      }
    }
    findPointBefore(node2, next2) {
      for (let point of this.points)
        if (point.node == node2 && node2.childNodes[point.offset] == next2)
          point.pos = this.text.length;
    }
    findPointInside(node2, length2) {
      for (let point of this.points)
        if (node2.nodeType == 3 ? point.node == node2 : node2.contains(point.node))
          point.pos = this.text.length + (isAtEnd$1(node2, point.node, point.offset) ? length2 : 0);
    }
  };
  function isAtEnd$1(parent, node2, offset2) {
    for (; ; ) {
      if (!node2 || offset2 < maxOffset$1(node2))
        return false;
      if (node2 == parent)
        return true;
      offset2 = domIndex$1(node2) + 1;
      node2 = node2.parentNode;
    }
  }
  let DOMPoint$1 = class DOMPoint {
    constructor(node2, offset2) {
      this.node = node2;
      this.offset = offset2;
      this.pos = -1;
    }
  };
  let DOMChange$1 = class DOMChange {
    constructor(view, start2, end2, typeOver) {
      this.typeOver = typeOver;
      this.bounds = null;
      this.text = "";
      this.domChanged = start2 > -1;
      let { impreciseHead: iHead, impreciseAnchor: iAnchor } = view.docView;
      if (view.state.readOnly && start2 > -1) {
        this.newSel = null;
      } else if (start2 > -1 && (this.bounds = view.docView.domBoundsAround(start2, end2, 0))) {
        let selPoints = iHead || iAnchor ? [] : selectionPoints$1(view);
        let reader = new DOMReader$1(selPoints, view.state);
        reader.readRange(this.bounds.startDOM, this.bounds.endDOM);
        this.text = reader.text;
        this.newSel = selectionFromPoints$1(selPoints, this.bounds.from);
      } else {
        let domSel = view.observer.selectionRange;
        let head = iHead && iHead.node == domSel.focusNode && iHead.offset == domSel.focusOffset || !contains$2(view.contentDOM, domSel.focusNode) ? view.state.selection.main.head : view.docView.posFromDOM(domSel.focusNode, domSel.focusOffset);
        let anchor = iAnchor && iAnchor.node == domSel.anchorNode && iAnchor.offset == domSel.anchorOffset || !contains$2(view.contentDOM, domSel.anchorNode) ? view.state.selection.main.anchor : view.docView.posFromDOM(domSel.anchorNode, domSel.anchorOffset);
        let vp = view.viewport;
        if ((browser$1.ios || browser$1.chrome) && view.state.selection.main.empty && head != anchor && (vp.from > 0 || vp.to < view.state.doc.length)) {
          let from2 = Math.min(head, anchor), to = Math.max(head, anchor);
          let offFrom = vp.from - from2, offTo = vp.to - to;
          if ((offFrom == 0 || offFrom == 1 || from2 == 0) && (offTo == 0 || offTo == -1 || to == view.state.doc.length)) {
            head = 0;
            anchor = view.state.doc.length;
          }
        }
        this.newSel = EditorSelection.single(anchor, head);
      }
    }
  };
  function applyDOMChange$1(view, domChange) {
    let change;
    let { newSel } = domChange, sel = view.state.selection.main;
    let lastKey = view.inputState.lastKeyTime > Date.now() - 100 ? view.inputState.lastKeyCode : -1;
    if (domChange.bounds) {
      let { from: from2, to } = domChange.bounds;
      let preferredPos = sel.from, preferredSide = null;
      if (lastKey === 8 || browser$1.android && domChange.text.length < to - from2) {
        preferredPos = sel.to;
        preferredSide = "end";
      }
      let diff = findDiff$1(view.state.doc.sliceString(from2, to, LineBreakPlaceholder$1), domChange.text, preferredPos - from2, preferredSide);
      if (diff) {
        if (browser$1.chrome && lastKey == 13 && diff.toB == diff.from + 2 && domChange.text.slice(diff.from, diff.toB) == LineBreakPlaceholder$1 + LineBreakPlaceholder$1)
          diff.toB--;
        change = {
          from: from2 + diff.from,
          to: from2 + diff.toA,
          insert: Text.of(domChange.text.slice(diff.from, diff.toB).split(LineBreakPlaceholder$1))
        };
      }
    } else if (newSel && (!view.hasFocus && view.state.facet(editable$1) || newSel.main.eq(sel))) {
      newSel = null;
    }
    if (!change && !newSel)
      return false;
    if (!change && domChange.typeOver && !sel.empty && newSel && newSel.main.empty) {
      change = { from: sel.from, to: sel.to, insert: view.state.doc.slice(sel.from, sel.to) };
    } else if (change && change.from >= sel.from && change.to <= sel.to && (change.from != sel.from || change.to != sel.to) && sel.to - sel.from - (change.to - change.from) <= 4) {
      change = {
        from: sel.from,
        to: sel.to,
        insert: view.state.doc.slice(sel.from, change.from).append(change.insert).append(view.state.doc.slice(change.to, sel.to))
      };
    } else if ((browser$1.mac || browser$1.android) && change && change.from == change.to && change.from == sel.head - 1 && /^\. ?$/.test(change.insert.toString()) && view.contentDOM.getAttribute("autocorrect") == "off") {
      if (newSel && change.insert.length == 2)
        newSel = EditorSelection.single(newSel.main.anchor - 1, newSel.main.head - 1);
      change = { from: sel.from, to: sel.to, insert: Text.of([" "]) };
    } else if (browser$1.chrome && change && change.from == change.to && change.from == sel.head && change.insert.toString() == "\n " && view.lineWrapping) {
      if (newSel)
        newSel = EditorSelection.single(newSel.main.anchor - 1, newSel.main.head - 1);
      change = { from: sel.from, to: sel.to, insert: Text.of([" "]) };
    }
    if (change) {
      return applyDOMChangeInner$1(view, change, newSel, lastKey);
    } else if (newSel && !newSel.main.eq(sel)) {
      let scrollIntoView2 = false, userEvent = "select";
      if (view.inputState.lastSelectionTime > Date.now() - 50) {
        if (view.inputState.lastSelectionOrigin == "select")
          scrollIntoView2 = true;
        userEvent = view.inputState.lastSelectionOrigin;
      }
      view.dispatch({ selection: newSel, scrollIntoView: scrollIntoView2, userEvent });
      return true;
    } else {
      return false;
    }
  }
  function applyDOMChangeInner$1(view, change, newSel, lastKey = -1) {
    if (browser$1.ios && view.inputState.flushIOSKey(change))
      return true;
    let sel = view.state.selection.main;
    if (browser$1.android && (change.to == sel.to && // GBoard will sometimes remove a space it just inserted
    // after a completion when you press enter
    (change.from == sel.from || change.from == sel.from - 1 && view.state.sliceDoc(change.from, sel.from) == " ") && change.insert.length == 1 && change.insert.lines == 2 && dispatchKey$1(view.contentDOM, "Enter", 13) || (change.from == sel.from - 1 && change.to == sel.to && change.insert.length == 0 || lastKey == 8 && change.insert.length < change.to - change.from && change.to > sel.head) && dispatchKey$1(view.contentDOM, "Backspace", 8) || change.from == sel.from && change.to == sel.to + 1 && change.insert.length == 0 && dispatchKey$1(view.contentDOM, "Delete", 46)))
      return true;
    let text = change.insert.toString();
    if (view.inputState.composing >= 0)
      view.inputState.composing++;
    let defaultTr;
    let defaultInsert = () => defaultTr || (defaultTr = applyDefaultInsert$1(view, change, newSel));
    if (!view.state.facet(inputHandler$1).some((h) => h(view, change.from, change.to, text, defaultInsert)))
      view.dispatch(defaultInsert());
    return true;
  }
  function applyDefaultInsert$1(view, change, newSel) {
    let tr2, startState = view.state, sel = startState.selection.main;
    if (change.from >= sel.from && change.to <= sel.to && change.to - change.from >= (sel.to - sel.from) / 3 && (!newSel || newSel.main.empty && newSel.main.from == change.from + change.insert.length) && view.inputState.composing < 0) {
      let before = sel.from < change.from ? startState.sliceDoc(sel.from, change.from) : "";
      let after = sel.to > change.to ? startState.sliceDoc(change.to, sel.to) : "";
      tr2 = startState.replaceSelection(view.state.toText(before + change.insert.sliceString(0, void 0, view.state.lineBreak) + after));
    } else {
      let changes = startState.changes(change);
      let mainSel = newSel && newSel.main.to <= changes.newLength ? newSel.main : void 0;
      if (startState.selection.ranges.length > 1 && view.inputState.composing >= 0 && change.to <= sel.to && change.to >= sel.to - 10) {
        let replaced = view.state.sliceDoc(change.from, change.to);
        let compositionRange, composition = newSel && findCompositionNode$1(view, newSel.main.head);
        if (composition) {
          let dLen = change.insert.length - (change.to - change.from);
          compositionRange = { from: composition.from, to: composition.to - dLen };
        } else {
          compositionRange = view.state.doc.lineAt(sel.head);
        }
        let offset2 = sel.to - change.to, size = sel.to - sel.from;
        tr2 = startState.changeByRange((range) => {
          if (range.from == sel.from && range.to == sel.to)
            return { changes, range: mainSel || range.map(changes) };
          let to = range.to - offset2, from2 = to - replaced.length;
          if (range.to - range.from != size || view.state.sliceDoc(from2, to) != replaced || // Unfortunately, there's no way to make multiple
          // changes in the same node work without aborting
          // composition, so cursors in the composition range are
          // ignored.
          range.to >= compositionRange.from && range.from <= compositionRange.to)
            return { range };
          let rangeChanges = startState.changes({ from: from2, to, insert: change.insert }), selOff = range.to - sel.to;
          return {
            changes: rangeChanges,
            range: !mainSel ? range.map(rangeChanges) : EditorSelection.range(Math.max(0, mainSel.anchor + selOff), Math.max(0, mainSel.head + selOff))
          };
        });
      } else {
        tr2 = {
          changes,
          selection: mainSel && startState.selection.replaceRange(mainSel)
        };
      }
    }
    let userEvent = "input.type";
    if (view.composing || view.inputState.compositionPendingChange && view.inputState.compositionEndedAt > Date.now() - 50) {
      view.inputState.compositionPendingChange = false;
      userEvent += ".compose";
      if (view.inputState.compositionFirstChange) {
        userEvent += ".start";
        view.inputState.compositionFirstChange = false;
      }
    }
    return startState.update(tr2, { userEvent, scrollIntoView: true });
  }
  function findDiff$1(a2, b, preferredPos, preferredSide) {
    let minLen = Math.min(a2.length, b.length);
    let from2 = 0;
    while (from2 < minLen && a2.charCodeAt(from2) == b.charCodeAt(from2))
      from2++;
    if (from2 == minLen && a2.length == b.length)
      return null;
    let toA = a2.length, toB = b.length;
    while (toA > 0 && toB > 0 && a2.charCodeAt(toA - 1) == b.charCodeAt(toB - 1)) {
      toA--;
      toB--;
    }
    if (preferredSide == "end") {
      let adjust = Math.max(0, from2 - Math.min(toA, toB));
      preferredPos -= toA + adjust - from2;
    }
    if (toA < from2 && a2.length < b.length) {
      let move = preferredPos <= from2 && preferredPos >= toA ? from2 - preferredPos : 0;
      from2 -= move;
      toB = from2 + (toB - toA);
      toA = from2;
    } else if (toB < from2) {
      let move = preferredPos <= from2 && preferredPos >= toB ? from2 - preferredPos : 0;
      from2 -= move;
      toA = from2 + (toA - toB);
      toB = from2;
    }
    return { from: from2, toA, toB };
  }
  function selectionPoints$1(view) {
    let result = [];
    if (view.root.activeElement != view.contentDOM)
      return result;
    let { anchorNode, anchorOffset, focusNode, focusOffset } = view.observer.selectionRange;
    if (anchorNode) {
      result.push(new DOMPoint$1(anchorNode, anchorOffset));
      if (focusNode != anchorNode || focusOffset != anchorOffset)
        result.push(new DOMPoint$1(focusNode, focusOffset));
    }
    return result;
  }
  function selectionFromPoints$1(points, base2) {
    if (points.length == 0)
      return null;
    let anchor = points[0].pos, head = points.length == 2 ? points[1].pos : anchor;
    return anchor > -1 && head > -1 ? EditorSelection.single(anchor + base2, head + base2) : null;
  }
  let InputState$1 = class InputState {
    setSelectionOrigin(origin) {
      this.lastSelectionOrigin = origin;
      this.lastSelectionTime = Date.now();
    }
    constructor(view) {
      this.view = view;
      this.lastKeyCode = 0;
      this.lastKeyTime = 0;
      this.lastTouchTime = 0;
      this.lastFocusTime = 0;
      this.lastScrollTop = 0;
      this.lastScrollLeft = 0;
      this.pendingIOSKey = void 0;
      this.tabFocusMode = -1;
      this.lastSelectionOrigin = null;
      this.lastSelectionTime = 0;
      this.lastContextMenu = 0;
      this.scrollHandlers = [];
      this.handlers = /* @__PURE__ */ Object.create(null);
      this.composing = -1;
      this.compositionFirstChange = null;
      this.compositionEndedAt = 0;
      this.compositionPendingKey = false;
      this.compositionPendingChange = false;
      this.mouseSelection = null;
      this.draggedContent = null;
      this.handleEvent = this.handleEvent.bind(this);
      this.notifiedFocused = view.hasFocus;
      if (browser$1.safari)
        view.contentDOM.addEventListener("input", () => null);
      if (browser$1.gecko)
        firefoxCopyCutHack$1(view.contentDOM.ownerDocument);
    }
    handleEvent(event) {
      if (!eventBelongsToEditor$1(this.view, event) || this.ignoreDuringComposition(event))
        return;
      if (event.type == "keydown" && this.keydown(event))
        return;
      this.runHandlers(event.type, event);
    }
    runHandlers(type, event) {
      let handlers2 = this.handlers[type];
      if (handlers2) {
        for (let observer of handlers2.observers)
          observer(this.view, event);
        for (let handler of handlers2.handlers) {
          if (event.defaultPrevented)
            break;
          if (handler(this.view, event)) {
            event.preventDefault();
            break;
          }
        }
      }
    }
    ensureHandlers(plugins) {
      let handlers2 = computeHandlers$1(plugins), prev2 = this.handlers, dom = this.view.contentDOM;
      for (let type in handlers2)
        if (type != "scroll") {
          let passive2 = !handlers2[type].handlers.length;
          let exists = prev2[type];
          if (exists && passive2 != !exists.handlers.length) {
            dom.removeEventListener(type, this.handleEvent);
            exists = null;
          }
          if (!exists)
            dom.addEventListener(type, this.handleEvent, { passive: passive2 });
        }
      for (let type in prev2)
        if (type != "scroll" && !handlers2[type])
          dom.removeEventListener(type, this.handleEvent);
      this.handlers = handlers2;
    }
    keydown(event) {
      this.lastKeyCode = event.keyCode;
      this.lastKeyTime = Date.now();
      if (event.keyCode == 9 && this.tabFocusMode > -1 && (!this.tabFocusMode || Date.now() <= this.tabFocusMode))
        return true;
      if (this.tabFocusMode > 0 && event.keyCode != 27 && modifierCodes$1.indexOf(event.keyCode) < 0)
        this.tabFocusMode = -1;
      if (browser$1.android && browser$1.chrome && !event.synthetic && (event.keyCode == 13 || event.keyCode == 8)) {
        this.view.observer.delayAndroidKey(event.key, event.keyCode);
        return true;
      }
      let pending;
      if (browser$1.ios && !event.synthetic && !event.altKey && !event.metaKey && ((pending = PendingKeys$1.find((key) => key.keyCode == event.keyCode)) && !event.ctrlKey || EmacsyPendingKeys$1.indexOf(event.key) > -1 && event.ctrlKey && !event.shiftKey)) {
        this.pendingIOSKey = pending || event;
        setTimeout(() => this.flushIOSKey(), 250);
        return true;
      }
      if (event.keyCode != 229)
        this.view.observer.forceFlush();
      return false;
    }
    flushIOSKey(change) {
      let key = this.pendingIOSKey;
      if (!key)
        return false;
      if (key.key == "Enter" && change && change.from < change.to && /^\S+$/.test(change.insert.toString()))
        return false;
      this.pendingIOSKey = void 0;
      return dispatchKey$1(this.view.contentDOM, key.key, key.keyCode, key instanceof KeyboardEvent ? key : void 0);
    }
    ignoreDuringComposition(event) {
      if (!/^key/.test(event.type))
        return false;
      if (this.composing > 0)
        return true;
      if (browser$1.safari && !browser$1.ios && this.compositionPendingKey && Date.now() - this.compositionEndedAt < 100) {
        this.compositionPendingKey = false;
        return true;
      }
      return false;
    }
    startMouseSelection(mouseSelection) {
      if (this.mouseSelection)
        this.mouseSelection.destroy();
      this.mouseSelection = mouseSelection;
    }
    update(update) {
      this.view.observer.update(update);
      if (this.mouseSelection)
        this.mouseSelection.update(update);
      if (this.draggedContent && update.docChanged)
        this.draggedContent = this.draggedContent.map(update.changes);
      if (update.transactions.length)
        this.lastKeyCode = this.lastSelectionTime = 0;
    }
    destroy() {
      if (this.mouseSelection)
        this.mouseSelection.destroy();
    }
  };
  function bindHandler$1(plugin, handler) {
    return (view, event) => {
      try {
        return handler.call(plugin, event, view);
      } catch (e) {
        logException$1(view.state, e);
      }
    };
  }
  function computeHandlers$1(plugins) {
    let result = /* @__PURE__ */ Object.create(null);
    function record(type) {
      return result[type] || (result[type] = { observers: [], handlers: [] });
    }
    for (let plugin of plugins) {
      let spec = plugin.spec;
      if (spec && spec.domEventHandlers)
        for (let type in spec.domEventHandlers) {
          let f = spec.domEventHandlers[type];
          if (f)
            record(type).handlers.push(bindHandler$1(plugin.value, f));
        }
      if (spec && spec.domEventObservers)
        for (let type in spec.domEventObservers) {
          let f = spec.domEventObservers[type];
          if (f)
            record(type).observers.push(bindHandler$1(plugin.value, f));
        }
    }
    for (let type in handlers$1)
      record(type).handlers.push(handlers$1[type]);
    for (let type in observers$1)
      record(type).observers.push(observers$1[type]);
    return result;
  }
  const PendingKeys$1 = [
    { key: "Backspace", keyCode: 8, inputType: "deleteContentBackward" },
    { key: "Enter", keyCode: 13, inputType: "insertParagraph" },
    { key: "Enter", keyCode: 13, inputType: "insertLineBreak" },
    { key: "Delete", keyCode: 46, inputType: "deleteContentForward" }
  ];
  const EmacsyPendingKeys$1 = "dthko";
  const modifierCodes$1 = [16, 17, 18, 20, 91, 92, 224, 225];
  const dragScrollMargin$1 = 6;
  function dragScrollSpeed$1(dist2) {
    return Math.max(0, dist2) * 0.7 + 8;
  }
  function dist$1(a2, b) {
    return Math.max(Math.abs(a2.clientX - b.clientX), Math.abs(a2.clientY - b.clientY));
  }
  let MouseSelection$1 = class MouseSelection {
    constructor(view, startEvent, style2, mustSelect) {
      this.view = view;
      this.startEvent = startEvent;
      this.style = style2;
      this.mustSelect = mustSelect;
      this.scrollSpeed = { x: 0, y: 0 };
      this.scrolling = -1;
      this.lastEvent = startEvent;
      this.scrollParents = scrollableParents$1(view.contentDOM);
      this.atoms = view.state.facet(atomicRanges$1).map((f) => f(view));
      let doc2 = view.contentDOM.ownerDocument;
      doc2.addEventListener("mousemove", this.move = this.move.bind(this));
      doc2.addEventListener("mouseup", this.up = this.up.bind(this));
      this.extend = startEvent.shiftKey;
      this.multiple = view.state.facet(EditorState.allowMultipleSelections) && addsSelectionRange$1(view, startEvent);
      this.dragging = isInPrimarySelection$1(view, startEvent) && getClickType$1(startEvent) == 1 ? null : false;
    }
    start(event) {
      if (this.dragging === false)
        this.select(event);
    }
    move(event) {
      if (event.buttons == 0)
        return this.destroy();
      if (this.dragging || this.dragging == null && dist$1(this.startEvent, event) < 10)
        return;
      this.select(this.lastEvent = event);
      let sx = 0, sy = 0;
      let left2 = 0, top2 = 0, right2 = this.view.win.innerWidth, bottom2 = this.view.win.innerHeight;
      if (this.scrollParents.x)
        ({ left: left2, right: right2 } = this.scrollParents.x.getBoundingClientRect());
      if (this.scrollParents.y)
        ({ top: top2, bottom: bottom2 } = this.scrollParents.y.getBoundingClientRect());
      let margins = getScrollMargins$1(this.view);
      if (event.clientX - margins.left <= left2 + dragScrollMargin$1)
        sx = -dragScrollSpeed$1(left2 - event.clientX);
      else if (event.clientX + margins.right >= right2 - dragScrollMargin$1)
        sx = dragScrollSpeed$1(event.clientX - right2);
      if (event.clientY - margins.top <= top2 + dragScrollMargin$1)
        sy = -dragScrollSpeed$1(top2 - event.clientY);
      else if (event.clientY + margins.bottom >= bottom2 - dragScrollMargin$1)
        sy = dragScrollSpeed$1(event.clientY - bottom2);
      this.setScrollSpeed(sx, sy);
    }
    up(event) {
      if (this.dragging == null)
        this.select(this.lastEvent);
      if (!this.dragging)
        event.preventDefault();
      this.destroy();
    }
    destroy() {
      this.setScrollSpeed(0, 0);
      let doc2 = this.view.contentDOM.ownerDocument;
      doc2.removeEventListener("mousemove", this.move);
      doc2.removeEventListener("mouseup", this.up);
      this.view.inputState.mouseSelection = this.view.inputState.draggedContent = null;
    }
    setScrollSpeed(sx, sy) {
      this.scrollSpeed = { x: sx, y: sy };
      if (sx || sy) {
        if (this.scrolling < 0)
          this.scrolling = setInterval(() => this.scroll(), 50);
      } else if (this.scrolling > -1) {
        clearInterval(this.scrolling);
        this.scrolling = -1;
      }
    }
    scroll() {
      let { x: x2, y } = this.scrollSpeed;
      if (x2 && this.scrollParents.x) {
        this.scrollParents.x.scrollLeft += x2;
        x2 = 0;
      }
      if (y && this.scrollParents.y) {
        this.scrollParents.y.scrollTop += y;
        y = 0;
      }
      if (x2 || y)
        this.view.win.scrollBy(x2, y);
      if (this.dragging === false)
        this.select(this.lastEvent);
    }
    skipAtoms(sel) {
      let ranges = null;
      for (let i2 = 0; i2 < sel.ranges.length; i2++) {
        let range = sel.ranges[i2], updated = null;
        if (range.empty) {
          let pos = skipAtomicRanges$1(this.atoms, range.from, 0);
          if (pos != range.from)
            updated = EditorSelection.cursor(pos, -1);
        } else {
          let from2 = skipAtomicRanges$1(this.atoms, range.from, -1);
          let to = skipAtomicRanges$1(this.atoms, range.to, 1);
          if (from2 != range.from || to != range.to)
            updated = EditorSelection.range(range.from == range.anchor ? from2 : to, range.from == range.head ? from2 : to);
        }
        if (updated) {
          if (!ranges)
            ranges = sel.ranges.slice();
          ranges[i2] = updated;
        }
      }
      return ranges ? EditorSelection.create(ranges, sel.mainIndex) : sel;
    }
    select(event) {
      let { view } = this, selection = this.skipAtoms(this.style.get(event, this.extend, this.multiple));
      if (this.mustSelect || !selection.eq(view.state.selection, this.dragging === false))
        this.view.dispatch({
          selection,
          userEvent: "select.pointer"
        });
      this.mustSelect = false;
    }
    update(update) {
      if (update.transactions.some((tr2) => tr2.isUserEvent("input.type")))
        this.destroy();
      else if (this.style.update(update))
        setTimeout(() => this.select(this.lastEvent), 20);
    }
  };
  function addsSelectionRange$1(view, event) {
    let facet = view.state.facet(clickAddsSelectionRange$1);
    return facet.length ? facet[0](event) : browser$1.mac ? event.metaKey : event.ctrlKey;
  }
  function dragMovesSelection$2(view, event) {
    let facet = view.state.facet(dragMovesSelection$1$1);
    return facet.length ? facet[0](event) : browser$1.mac ? !event.altKey : !event.ctrlKey;
  }
  function isInPrimarySelection$1(view, event) {
    let { main: main2 } = view.state.selection;
    if (main2.empty)
      return false;
    let sel = getSelection$2(view.root);
    if (!sel || sel.rangeCount == 0)
      return true;
    let rects = sel.getRangeAt(0).getClientRects();
    for (let i2 = 0; i2 < rects.length; i2++) {
      let rect = rects[i2];
      if (rect.left <= event.clientX && rect.right >= event.clientX && rect.top <= event.clientY && rect.bottom >= event.clientY)
        return true;
    }
    return false;
  }
  function eventBelongsToEditor$1(view, event) {
    if (!event.bubbles)
      return true;
    if (event.defaultPrevented)
      return false;
    for (let node2 = event.target, cView; node2 != view.contentDOM; node2 = node2.parentNode)
      if (!node2 || node2.nodeType == 11 || (cView = ContentView$1.get(node2)) && cView.ignoreEvent(event))
        return false;
    return true;
  }
  const handlers$1 = /* @__PURE__ */ Object.create(null);
  const observers$1 = /* @__PURE__ */ Object.create(null);
  const brokenClipboardAPI$1 = browser$1.ie && browser$1.ie_version < 15 || browser$1.ios && browser$1.webkit_version < 604;
  function capturePaste$1(view) {
    let parent = view.dom.parentNode;
    if (!parent)
      return;
    let target = parent.appendChild(document.createElement("textarea"));
    target.style.cssText = "position: fixed; left: -10000px; top: 10px";
    target.focus();
    setTimeout(() => {
      view.focus();
      target.remove();
      doPaste$1(view, target.value);
    }, 50);
  }
  function textFilter$1(state, facet, text) {
    for (let filter of state.facet(facet))
      text = filter(text, state);
    return text;
  }
  function doPaste$1(view, input) {
    input = textFilter$1(view.state, clipboardInputFilter$1, input);
    let { state } = view, changes, i2 = 1, text = state.toText(input);
    let byLine = text.lines == state.selection.ranges.length;
    let linewise = lastLinewiseCopy$1 != null && state.selection.ranges.every((r2) => r2.empty) && lastLinewiseCopy$1 == text.toString();
    if (linewise) {
      let lastLine = -1;
      changes = state.changeByRange((range) => {
        let line2 = state.doc.lineAt(range.from);
        if (line2.from == lastLine)
          return { range };
        lastLine = line2.from;
        let insert2 = state.toText((byLine ? text.line(i2++).text : input) + state.lineBreak);
        return {
          changes: { from: line2.from, insert: insert2 },
          range: EditorSelection.cursor(range.from + insert2.length)
        };
      });
    } else if (byLine) {
      changes = state.changeByRange((range) => {
        let line2 = text.line(i2++);
        return {
          changes: { from: range.from, to: range.to, insert: line2.text },
          range: EditorSelection.cursor(range.from + line2.length)
        };
      });
    } else {
      changes = state.replaceSelection(text);
    }
    view.dispatch(changes, {
      userEvent: "input.paste",
      scrollIntoView: true
    });
  }
  observers$1.scroll = (view) => {
    view.inputState.lastScrollTop = view.scrollDOM.scrollTop;
    view.inputState.lastScrollLeft = view.scrollDOM.scrollLeft;
  };
  handlers$1.keydown = (view, event) => {
    view.inputState.setSelectionOrigin("select");
    if (event.keyCode == 27 && view.inputState.tabFocusMode != 0)
      view.inputState.tabFocusMode = Date.now() + 2e3;
    return false;
  };
  observers$1.touchstart = (view, e) => {
    view.inputState.lastTouchTime = Date.now();
    view.inputState.setSelectionOrigin("select.pointer");
  };
  observers$1.touchmove = (view) => {
    view.inputState.setSelectionOrigin("select.pointer");
  };
  handlers$1.mousedown = (view, event) => {
    view.observer.flush();
    if (view.inputState.lastTouchTime > Date.now() - 2e3)
      return false;
    let style2 = null;
    for (let makeStyle of view.state.facet(mouseSelectionStyle$1)) {
      style2 = makeStyle(view, event);
      if (style2)
        break;
    }
    if (!style2 && event.button == 0)
      style2 = basicMouseSelection$1(view, event);
    if (style2) {
      let mustFocus = !view.hasFocus;
      view.inputState.startMouseSelection(new MouseSelection$1(view, event, style2, mustFocus));
      if (mustFocus)
        view.observer.ignore(() => {
          focusPreventScroll$1(view.contentDOM);
          let active = view.root.activeElement;
          if (active && !active.contains(view.contentDOM))
            active.blur();
        });
      let mouseSel = view.inputState.mouseSelection;
      if (mouseSel) {
        mouseSel.start(event);
        return mouseSel.dragging === false;
      }
    }
    return false;
  };
  function rangeForClick$1(view, pos, bias, type) {
    if (type == 1) {
      return EditorSelection.cursor(pos, bias);
    } else if (type == 2) {
      return groupAt$1(view.state, pos, bias);
    } else {
      let visual = LineView$1.find(view.docView, pos), line2 = view.state.doc.lineAt(visual ? visual.posAtEnd : pos);
      let from2 = visual ? visual.posAtStart : line2.from, to = visual ? visual.posAtEnd : line2.to;
      if (to < view.state.doc.length && to == line2.to)
        to++;
      return EditorSelection.range(from2, to);
    }
  }
  let inside$1 = (x2, y, rect) => y >= rect.top && y <= rect.bottom && x2 >= rect.left && x2 <= rect.right;
  function findPositionSide$1(view, pos, x2, y) {
    let line2 = LineView$1.find(view.docView, pos);
    if (!line2)
      return 1;
    let off = pos - line2.posAtStart;
    if (off == 0)
      return 1;
    if (off == line2.length)
      return -1;
    let before = line2.coordsAt(off, -1);
    if (before && inside$1(x2, y, before))
      return -1;
    let after = line2.coordsAt(off, 1);
    if (after && inside$1(x2, y, after))
      return 1;
    return before && before.bottom >= y ? -1 : 1;
  }
  function queryPos$1(view, event) {
    let pos = view.posAtCoords({ x: event.clientX, y: event.clientY }, false);
    return { pos, bias: findPositionSide$1(view, pos, event.clientX, event.clientY) };
  }
  const BadMouseDetail$1 = browser$1.ie && browser$1.ie_version <= 11;
  let lastMouseDown$1 = null, lastMouseDownCount$1 = 0, lastMouseDownTime$1 = 0;
  function getClickType$1(event) {
    if (!BadMouseDetail$1)
      return event.detail;
    let last = lastMouseDown$1, lastTime = lastMouseDownTime$1;
    lastMouseDown$1 = event;
    lastMouseDownTime$1 = Date.now();
    return lastMouseDownCount$1 = !last || lastTime > Date.now() - 400 && Math.abs(last.clientX - event.clientX) < 2 && Math.abs(last.clientY - event.clientY) < 2 ? (lastMouseDownCount$1 + 1) % 3 : 1;
  }
  function basicMouseSelection$1(view, event) {
    let start2 = queryPos$1(view, event), type = getClickType$1(event);
    let startSel = view.state.selection;
    return {
      update(update) {
        if (update.docChanged) {
          start2.pos = update.changes.mapPos(start2.pos);
          startSel = startSel.map(update.changes);
        }
      },
      get(event2, extend, multiple) {
        let cur = queryPos$1(view, event2), removed;
        let range = rangeForClick$1(view, cur.pos, cur.bias, type);
        if (start2.pos != cur.pos && !extend) {
          let startRange = rangeForClick$1(view, start2.pos, start2.bias, type);
          let from2 = Math.min(startRange.from, range.from), to = Math.max(startRange.to, range.to);
          range = from2 < range.from ? EditorSelection.range(from2, to) : EditorSelection.range(to, from2);
        }
        if (extend)
          return startSel.replaceRange(startSel.main.extend(range.from, range.to));
        else if (multiple && type == 1 && startSel.ranges.length > 1 && (removed = removeRangeAround$1(startSel, cur.pos)))
          return removed;
        else if (multiple)
          return startSel.addRange(range);
        else
          return EditorSelection.create([range]);
      }
    };
  }
  function removeRangeAround$1(sel, pos) {
    for (let i2 = 0; i2 < sel.ranges.length; i2++) {
      let { from: from2, to } = sel.ranges[i2];
      if (from2 <= pos && to >= pos)
        return EditorSelection.create(sel.ranges.slice(0, i2).concat(sel.ranges.slice(i2 + 1)), sel.mainIndex == i2 ? 0 : sel.mainIndex - (sel.mainIndex > i2 ? 1 : 0));
    }
    return null;
  }
  handlers$1.dragstart = (view, event) => {
    let { selection: { main: range } } = view.state;
    if (event.target.draggable) {
      let cView = view.docView.nearest(event.target);
      if (cView && cView.isWidget) {
        let from2 = cView.posAtStart, to = from2 + cView.length;
        if (from2 >= range.to || to <= range.from)
          range = EditorSelection.range(from2, to);
      }
    }
    let { inputState } = view;
    if (inputState.mouseSelection)
      inputState.mouseSelection.dragging = true;
    inputState.draggedContent = range;
    if (event.dataTransfer) {
      event.dataTransfer.setData("Text", textFilter$1(view.state, clipboardOutputFilter$1, view.state.sliceDoc(range.from, range.to)));
      event.dataTransfer.effectAllowed = "copyMove";
    }
    return false;
  };
  handlers$1.dragend = (view) => {
    view.inputState.draggedContent = null;
    return false;
  };
  function dropText$1(view, event, text, direct) {
    text = textFilter$1(view.state, clipboardInputFilter$1, text);
    if (!text)
      return;
    let dropPos = view.posAtCoords({ x: event.clientX, y: event.clientY }, false);
    let { draggedContent } = view.inputState;
    let del = direct && draggedContent && dragMovesSelection$2(view, event) ? { from: draggedContent.from, to: draggedContent.to } : null;
    let ins = { from: dropPos, insert: text };
    let changes = view.state.changes(del ? [del, ins] : ins);
    view.focus();
    view.dispatch({
      changes,
      selection: { anchor: changes.mapPos(dropPos, -1), head: changes.mapPos(dropPos, 1) },
      userEvent: del ? "move.drop" : "input.drop"
    });
    view.inputState.draggedContent = null;
  }
  handlers$1.drop = (view, event) => {
    if (!event.dataTransfer)
      return false;
    if (view.state.readOnly)
      return true;
    let files = event.dataTransfer.files;
    if (files && files.length) {
      let text = Array(files.length), read2 = 0;
      let finishFile = () => {
        if (++read2 == files.length)
          dropText$1(view, event, text.filter((s) => s != null).join(view.state.lineBreak), false);
      };
      for (let i2 = 0; i2 < files.length; i2++) {
        let reader = new FileReader();
        reader.onerror = finishFile;
        reader.onload = () => {
          if (!/[\x00-\x08\x0e-\x1f]{2}/.test(reader.result))
            text[i2] = reader.result;
          finishFile();
        };
        reader.readAsText(files[i2]);
      }
      return true;
    } else {
      let text = event.dataTransfer.getData("Text");
      if (text) {
        dropText$1(view, event, text, true);
        return true;
      }
    }
    return false;
  };
  handlers$1.paste = (view, event) => {
    if (view.state.readOnly)
      return true;
    view.observer.flush();
    let data = brokenClipboardAPI$1 ? null : event.clipboardData;
    if (data) {
      doPaste$1(view, data.getData("text/plain") || data.getData("text/uri-list"));
      return true;
    } else {
      capturePaste$1(view);
      return false;
    }
  };
  function captureCopy$1(view, text) {
    let parent = view.dom.parentNode;
    if (!parent)
      return;
    let target = parent.appendChild(document.createElement("textarea"));
    target.style.cssText = "position: fixed; left: -10000px; top: 10px";
    target.value = text;
    target.focus();
    target.selectionEnd = text.length;
    target.selectionStart = 0;
    setTimeout(() => {
      target.remove();
      view.focus();
    }, 50);
  }
  function copiedRange$1(state) {
    let content2 = [], ranges = [], linewise = false;
    for (let range of state.selection.ranges)
      if (!range.empty) {
        content2.push(state.sliceDoc(range.from, range.to));
        ranges.push(range);
      }
    if (!content2.length) {
      let upto = -1;
      for (let { from: from2 } of state.selection.ranges) {
        let line2 = state.doc.lineAt(from2);
        if (line2.number > upto) {
          content2.push(line2.text);
          ranges.push({ from: line2.from, to: Math.min(state.doc.length, line2.to + 1) });
        }
        upto = line2.number;
      }
      linewise = true;
    }
    return { text: textFilter$1(state, clipboardOutputFilter$1, content2.join(state.lineBreak)), ranges, linewise };
  }
  let lastLinewiseCopy$1 = null;
  handlers$1.copy = handlers$1.cut = (view, event) => {
    let { text, ranges, linewise } = copiedRange$1(view.state);
    if (!text && !linewise)
      return false;
    lastLinewiseCopy$1 = linewise ? text : null;
    if (event.type == "cut" && !view.state.readOnly)
      view.dispatch({
        changes: ranges,
        scrollIntoView: true,
        userEvent: "delete.cut"
      });
    let data = brokenClipboardAPI$1 ? null : event.clipboardData;
    if (data) {
      data.clearData();
      data.setData("text/plain", text);
      return true;
    } else {
      captureCopy$1(view, text);
      return false;
    }
  };
  const isFocusChange$1 = /* @__PURE__ */ Annotation.define();
  function focusChangeTransaction$1(state, focus) {
    let effects = [];
    for (let getEffect of state.facet(focusChangeEffect$1)) {
      let effect2 = getEffect(state, focus);
      if (effect2)
        effects.push(effect2);
    }
    return effects ? state.update({ effects, annotations: isFocusChange$1.of(true) }) : null;
  }
  function updateForFocusChange$1(view) {
    setTimeout(() => {
      let focus = view.hasFocus;
      if (focus != view.inputState.notifiedFocused) {
        let tr2 = focusChangeTransaction$1(view.state, focus);
        if (tr2)
          view.dispatch(tr2);
        else
          view.update([]);
      }
    }, 10);
  }
  observers$1.focus = (view) => {
    view.inputState.lastFocusTime = Date.now();
    if (!view.scrollDOM.scrollTop && (view.inputState.lastScrollTop || view.inputState.lastScrollLeft)) {
      view.scrollDOM.scrollTop = view.inputState.lastScrollTop;
      view.scrollDOM.scrollLeft = view.inputState.lastScrollLeft;
    }
    updateForFocusChange$1(view);
  };
  observers$1.blur = (view) => {
    view.observer.clearSelectionRange();
    updateForFocusChange$1(view);
  };
  observers$1.compositionstart = observers$1.compositionupdate = (view) => {
    if (view.observer.editContext)
      return;
    if (view.inputState.compositionFirstChange == null)
      view.inputState.compositionFirstChange = true;
    if (view.inputState.composing < 0) {
      view.inputState.composing = 0;
    }
  };
  observers$1.compositionend = (view) => {
    if (view.observer.editContext)
      return;
    view.inputState.composing = -1;
    view.inputState.compositionEndedAt = Date.now();
    view.inputState.compositionPendingKey = true;
    view.inputState.compositionPendingChange = view.observer.pendingRecords().length > 0;
    view.inputState.compositionFirstChange = null;
    if (browser$1.chrome && browser$1.android) {
      view.observer.flushSoon();
    } else if (view.inputState.compositionPendingChange) {
      Promise.resolve().then(() => view.observer.flush());
    } else {
      setTimeout(() => {
        if (view.inputState.composing < 0 && view.docView.hasComposition)
          view.update([]);
      }, 50);
    }
  };
  observers$1.contextmenu = (view) => {
    view.inputState.lastContextMenu = Date.now();
  };
  handlers$1.beforeinput = (view, event) => {
    var _a3, _b;
    if (event.inputType == "insertReplacementText" && view.observer.editContext) {
      let text = (_a3 = event.dataTransfer) === null || _a3 === void 0 ? void 0 : _a3.getData("text/plain"), ranges = event.getTargetRanges();
      if (text && ranges.length) {
        let r2 = ranges[0];
        let from2 = view.posAtDOM(r2.startContainer, r2.startOffset), to = view.posAtDOM(r2.endContainer, r2.endOffset);
        applyDOMChangeInner$1(view, { from: from2, to, insert: view.state.toText(text) }, null);
        return true;
      }
    }
    let pending;
    if (browser$1.chrome && browser$1.android && (pending = PendingKeys$1.find((key) => key.inputType == event.inputType))) {
      view.observer.delayAndroidKey(pending.key, pending.keyCode);
      if (pending.key == "Backspace" || pending.key == "Delete") {
        let startViewHeight = ((_b = window.visualViewport) === null || _b === void 0 ? void 0 : _b.height) || 0;
        setTimeout(() => {
          var _a4;
          if ((((_a4 = window.visualViewport) === null || _a4 === void 0 ? void 0 : _a4.height) || 0) > startViewHeight + 10 && view.hasFocus) {
            view.contentDOM.blur();
            view.focus();
          }
        }, 100);
      }
    }
    if (browser$1.ios && event.inputType == "deleteContentForward") {
      view.observer.flushSoon();
    }
    if (browser$1.safari && event.inputType == "insertText" && view.inputState.composing >= 0) {
      setTimeout(() => observers$1.compositionend(view, event), 20);
    }
    return false;
  };
  const appliedFirefoxHack$1 = /* @__PURE__ */ new Set();
  function firefoxCopyCutHack$1(doc2) {
    if (!appliedFirefoxHack$1.has(doc2)) {
      appliedFirefoxHack$1.add(doc2);
      doc2.addEventListener("copy", () => {
      });
      doc2.addEventListener("cut", () => {
      });
    }
  }
  const wrappingWhiteSpace$1 = ["pre-wrap", "normal", "pre-line", "break-spaces"];
  let heightChangeFlag$1 = false;
  function clearHeightChangeFlag$1() {
    heightChangeFlag$1 = false;
  }
  let HeightOracle$1 = class HeightOracle {
    constructor(lineWrapping) {
      this.lineWrapping = lineWrapping;
      this.doc = Text.empty;
      this.heightSamples = {};
      this.lineHeight = 14;
      this.charWidth = 7;
      this.textHeight = 14;
      this.lineLength = 30;
    }
    heightForGap(from2, to) {
      let lines = this.doc.lineAt(to).number - this.doc.lineAt(from2).number + 1;
      if (this.lineWrapping)
        lines += Math.max(0, Math.ceil((to - from2 - lines * this.lineLength * 0.5) / this.lineLength));
      return this.lineHeight * lines;
    }
    heightForLine(length2) {
      if (!this.lineWrapping)
        return this.lineHeight;
      let lines = 1 + Math.max(0, Math.ceil((length2 - this.lineLength) / (this.lineLength - 5)));
      return lines * this.lineHeight;
    }
    setDoc(doc2) {
      this.doc = doc2;
      return this;
    }
    mustRefreshForWrapping(whiteSpace) {
      return wrappingWhiteSpace$1.indexOf(whiteSpace) > -1 != this.lineWrapping;
    }
    mustRefreshForHeights(lineHeights) {
      let newHeight = false;
      for (let i2 = 0; i2 < lineHeights.length; i2++) {
        let h = lineHeights[i2];
        if (h < 0) {
          i2++;
        } else if (!this.heightSamples[Math.floor(h * 10)]) {
          newHeight = true;
          this.heightSamples[Math.floor(h * 10)] = true;
        }
      }
      return newHeight;
    }
    refresh(whiteSpace, lineHeight, charWidth, textHeight, lineLength, knownHeights) {
      let lineWrapping = wrappingWhiteSpace$1.indexOf(whiteSpace) > -1;
      let changed = Math.round(lineHeight) != Math.round(this.lineHeight) || this.lineWrapping != lineWrapping;
      this.lineWrapping = lineWrapping;
      this.lineHeight = lineHeight;
      this.charWidth = charWidth;
      this.textHeight = textHeight;
      this.lineLength = lineLength;
      if (changed) {
        this.heightSamples = {};
        for (let i2 = 0; i2 < knownHeights.length; i2++) {
          let h = knownHeights[i2];
          if (h < 0)
            i2++;
          else
            this.heightSamples[Math.floor(h * 10)] = true;
        }
      }
      return changed;
    }
  };
  let MeasuredHeights$1 = class MeasuredHeights {
    constructor(from2, heights) {
      this.from = from2;
      this.heights = heights;
      this.index = 0;
    }
    get more() {
      return this.index < this.heights.length;
    }
  };
  let BlockInfo$1 = class BlockInfo2 {
    /**
    @internal
    */
    constructor(from2, length2, top2, height2, _content) {
      this.from = from2;
      this.length = length2;
      this.top = top2;
      this.height = height2;
      this._content = _content;
    }
    /**
    The type of element this is. When querying lines, this may be
    an array of all the blocks that make up the line.
    */
    get type() {
      return typeof this._content == "number" ? BlockType$1.Text : Array.isArray(this._content) ? this._content : this._content.type;
    }
    /**
    The end of the element as a document position.
    */
    get to() {
      return this.from + this.length;
    }
    /**
    The bottom position of the element.
    */
    get bottom() {
      return this.top + this.height;
    }
    /**
    If this is a widget block, this will return the widget
    associated with it.
    */
    get widget() {
      return this._content instanceof PointDecoration$1 ? this._content.widget : null;
    }
    /**
    If this is a textblock, this holds the number of line breaks
    that appear in widgets inside the block.
    */
    get widgetLineBreaks() {
      return typeof this._content == "number" ? this._content : 0;
    }
    /**
    @internal
    */
    join(other) {
      let content2 = (Array.isArray(this._content) ? this._content : [this]).concat(Array.isArray(other._content) ? other._content : [other]);
      return new BlockInfo2(this.from, this.length + other.length, this.top, this.height + other.height, content2);
    }
  };
  var QueryType$1 = /* @__PURE__ */ function(QueryType2) {
    QueryType2[QueryType2["ByPos"] = 0] = "ByPos";
    QueryType2[QueryType2["ByHeight"] = 1] = "ByHeight";
    QueryType2[QueryType2["ByPosNoHeight"] = 2] = "ByPosNoHeight";
    return QueryType2;
  }(QueryType$1 || (QueryType$1 = {}));
  const Epsilon$1 = 1e-3;
  let HeightMap$1 = class HeightMap2 {
    constructor(length2, height2, flags = 2) {
      this.length = length2;
      this.height = height2;
      this.flags = flags;
    }
    get outdated() {
      return (this.flags & 2) > 0;
    }
    set outdated(value) {
      this.flags = (value ? 2 : 0) | this.flags & ~2;
    }
    setHeight(height2) {
      if (this.height != height2) {
        if (Math.abs(this.height - height2) > Epsilon$1)
          heightChangeFlag$1 = true;
        this.height = height2;
      }
    }
    // Base case is to replace a leaf node, which simply builds a tree
    // from the new nodes and returns that (HeightMapBranch and
    // HeightMapGap override this to actually use from/to)
    replace(_from, _to, nodes) {
      return HeightMap2.of(nodes);
    }
    // Again, these are base cases, and are overridden for branch and gap nodes.
    decomposeLeft(_to, result) {
      result.push(this);
    }
    decomposeRight(_from, result) {
      result.push(this);
    }
    applyChanges(decorations2, oldDoc, oracle, changes) {
      let me2 = this, doc2 = oracle.doc;
      for (let i2 = changes.length - 1; i2 >= 0; i2--) {
        let { fromA, toA, fromB, toB } = changes[i2];
        let start2 = me2.lineAt(fromA, QueryType$1.ByPosNoHeight, oracle.setDoc(oldDoc), 0, 0);
        let end2 = start2.to >= toA ? start2 : me2.lineAt(toA, QueryType$1.ByPosNoHeight, oracle, 0, 0);
        toB += end2.to - toA;
        toA = end2.to;
        while (i2 > 0 && start2.from <= changes[i2 - 1].toA) {
          fromA = changes[i2 - 1].fromA;
          fromB = changes[i2 - 1].fromB;
          i2--;
          if (fromA < start2.from)
            start2 = me2.lineAt(fromA, QueryType$1.ByPosNoHeight, oracle, 0, 0);
        }
        fromB += start2.from - fromA;
        fromA = start2.from;
        let nodes = NodeBuilder$1.build(oracle.setDoc(doc2), decorations2, fromB, toB);
        me2 = replace$2(me2, me2.replace(fromA, toA, nodes));
      }
      return me2.updateHeight(oracle, 0);
    }
    static empty() {
      return new HeightMapText$1(0, 0);
    }
    // nodes uses null values to indicate the position of line breaks.
    // There are never line breaks at the start or end of the array, or
    // two line breaks next to each other, and the array isn't allowed
    // to be empty (same restrictions as return value from the builder).
    static of(nodes) {
      if (nodes.length == 1)
        return nodes[0];
      let i2 = 0, j = nodes.length, before = 0, after = 0;
      for (; ; ) {
        if (i2 == j) {
          if (before > after * 2) {
            let split = nodes[i2 - 1];
            if (split.break)
              nodes.splice(--i2, 1, split.left, null, split.right);
            else
              nodes.splice(--i2, 1, split.left, split.right);
            j += 1 + split.break;
            before -= split.size;
          } else if (after > before * 2) {
            let split = nodes[j];
            if (split.break)
              nodes.splice(j, 1, split.left, null, split.right);
            else
              nodes.splice(j, 1, split.left, split.right);
            j += 2 + split.break;
            after -= split.size;
          } else {
            break;
          }
        } else if (before < after) {
          let next2 = nodes[i2++];
          if (next2)
            before += next2.size;
        } else {
          let next2 = nodes[--j];
          if (next2)
            after += next2.size;
        }
      }
      let brk = 0;
      if (nodes[i2 - 1] == null) {
        brk = 1;
        i2--;
      } else if (nodes[i2] == null) {
        brk = 1;
        j++;
      }
      return new HeightMapBranch$1(HeightMap2.of(nodes.slice(0, i2)), brk, HeightMap2.of(nodes.slice(j)));
    }
  };
  function replace$2(old, val) {
    if (old == val)
      return old;
    if (old.constructor != val.constructor)
      heightChangeFlag$1 = true;
    return val;
  }
  HeightMap$1.prototype.size = 1;
  let HeightMapBlock$1 = class HeightMapBlock extends HeightMap$1 {
    constructor(length2, height2, deco) {
      super(length2, height2);
      this.deco = deco;
    }
    blockAt(_height, _oracle, top2, offset2) {
      return new BlockInfo$1(offset2, this.length, top2, this.height, this.deco || 0);
    }
    lineAt(_value, _type, oracle, top2, offset2) {
      return this.blockAt(0, oracle, top2, offset2);
    }
    forEachLine(from2, to, oracle, top2, offset2, f) {
      if (from2 <= offset2 + this.length && to >= offset2)
        f(this.blockAt(0, oracle, top2, offset2));
    }
    updateHeight(oracle, offset2 = 0, _force = false, measured) {
      if (measured && measured.from <= offset2 && measured.more)
        this.setHeight(measured.heights[measured.index++]);
      this.outdated = false;
      return this;
    }
    toString() {
      return `block(${this.length})`;
    }
  };
  let HeightMapText$1 = class HeightMapText2 extends HeightMapBlock$1 {
    constructor(length2, height2) {
      super(length2, height2, null);
      this.collapsed = 0;
      this.widgetHeight = 0;
      this.breaks = 0;
    }
    blockAt(_height, _oracle, top2, offset2) {
      return new BlockInfo$1(offset2, this.length, top2, this.height, this.breaks);
    }
    replace(_from, _to, nodes) {
      let node2 = nodes[0];
      if (nodes.length == 1 && (node2 instanceof HeightMapText2 || node2 instanceof HeightMapGap$1 && node2.flags & 4) && Math.abs(this.length - node2.length) < 10) {
        if (node2 instanceof HeightMapGap$1)
          node2 = new HeightMapText2(node2.length, this.height);
        else
          node2.height = this.height;
        if (!this.outdated)
          node2.outdated = false;
        return node2;
      } else {
        return HeightMap$1.of(nodes);
      }
    }
    updateHeight(oracle, offset2 = 0, force = false, measured) {
      if (measured && measured.from <= offset2 && measured.more)
        this.setHeight(measured.heights[measured.index++]);
      else if (force || this.outdated)
        this.setHeight(Math.max(this.widgetHeight, oracle.heightForLine(this.length - this.collapsed)) + this.breaks * oracle.lineHeight);
      this.outdated = false;
      return this;
    }
    toString() {
      return `line(${this.length}${this.collapsed ? -this.collapsed : ""}${this.widgetHeight ? ":" + this.widgetHeight : ""})`;
    }
  };
  let HeightMapGap$1 = class HeightMapGap2 extends HeightMap$1 {
    constructor(length2) {
      super(length2, 0);
    }
    heightMetrics(oracle, offset2) {
      let firstLine = oracle.doc.lineAt(offset2).number, lastLine = oracle.doc.lineAt(offset2 + this.length).number;
      let lines = lastLine - firstLine + 1;
      let perLine, perChar = 0;
      if (oracle.lineWrapping) {
        let totalPerLine = Math.min(this.height, oracle.lineHeight * lines);
        perLine = totalPerLine / lines;
        if (this.length > lines + 1)
          perChar = (this.height - totalPerLine) / (this.length - lines - 1);
      } else {
        perLine = this.height / lines;
      }
      return { firstLine, lastLine, perLine, perChar };
    }
    blockAt(height2, oracle, top2, offset2) {
      let { firstLine, lastLine, perLine, perChar } = this.heightMetrics(oracle, offset2);
      if (oracle.lineWrapping) {
        let guess = offset2 + (height2 < oracle.lineHeight ? 0 : Math.round(Math.max(0, Math.min(1, (height2 - top2) / this.height)) * this.length));
        let line2 = oracle.doc.lineAt(guess), lineHeight = perLine + line2.length * perChar;
        let lineTop = Math.max(top2, height2 - lineHeight / 2);
        return new BlockInfo$1(line2.from, line2.length, lineTop, lineHeight, 0);
      } else {
        let line2 = Math.max(0, Math.min(lastLine - firstLine, Math.floor((height2 - top2) / perLine)));
        let { from: from2, length: length2 } = oracle.doc.line(firstLine + line2);
        return new BlockInfo$1(from2, length2, top2 + perLine * line2, perLine, 0);
      }
    }
    lineAt(value, type, oracle, top2, offset2) {
      if (type == QueryType$1.ByHeight)
        return this.blockAt(value, oracle, top2, offset2);
      if (type == QueryType$1.ByPosNoHeight) {
        let { from: from2, to } = oracle.doc.lineAt(value);
        return new BlockInfo$1(from2, to - from2, 0, 0, 0);
      }
      let { firstLine, perLine, perChar } = this.heightMetrics(oracle, offset2);
      let line2 = oracle.doc.lineAt(value), lineHeight = perLine + line2.length * perChar;
      let linesAbove = line2.number - firstLine;
      let lineTop = top2 + perLine * linesAbove + perChar * (line2.from - offset2 - linesAbove);
      return new BlockInfo$1(line2.from, line2.length, Math.max(top2, Math.min(lineTop, top2 + this.height - lineHeight)), lineHeight, 0);
    }
    forEachLine(from2, to, oracle, top2, offset2, f) {
      from2 = Math.max(from2, offset2);
      to = Math.min(to, offset2 + this.length);
      let { firstLine, perLine, perChar } = this.heightMetrics(oracle, offset2);
      for (let pos = from2, lineTop = top2; pos <= to; ) {
        let line2 = oracle.doc.lineAt(pos);
        if (pos == from2) {
          let linesAbove = line2.number - firstLine;
          lineTop += perLine * linesAbove + perChar * (from2 - offset2 - linesAbove);
        }
        let lineHeight = perLine + perChar * line2.length;
        f(new BlockInfo$1(line2.from, line2.length, lineTop, lineHeight, 0));
        lineTop += lineHeight;
        pos = line2.to + 1;
      }
    }
    replace(from2, to, nodes) {
      let after = this.length - to;
      if (after > 0) {
        let last = nodes[nodes.length - 1];
        if (last instanceof HeightMapGap2)
          nodes[nodes.length - 1] = new HeightMapGap2(last.length + after);
        else
          nodes.push(null, new HeightMapGap2(after - 1));
      }
      if (from2 > 0) {
        let first = nodes[0];
        if (first instanceof HeightMapGap2)
          nodes[0] = new HeightMapGap2(from2 + first.length);
        else
          nodes.unshift(new HeightMapGap2(from2 - 1), null);
      }
      return HeightMap$1.of(nodes);
    }
    decomposeLeft(to, result) {
      result.push(new HeightMapGap2(to - 1), null);
    }
    decomposeRight(from2, result) {
      result.push(null, new HeightMapGap2(this.length - from2 - 1));
    }
    updateHeight(oracle, offset2 = 0, force = false, measured) {
      let end2 = offset2 + this.length;
      if (measured && measured.from <= offset2 + this.length && measured.more) {
        let nodes = [], pos = Math.max(offset2, measured.from), singleHeight = -1;
        if (measured.from > offset2)
          nodes.push(new HeightMapGap2(measured.from - offset2 - 1).updateHeight(oracle, offset2));
        while (pos <= end2 && measured.more) {
          let len = oracle.doc.lineAt(pos).length;
          if (nodes.length)
            nodes.push(null);
          let height2 = measured.heights[measured.index++];
          if (singleHeight == -1)
            singleHeight = height2;
          else if (Math.abs(height2 - singleHeight) >= Epsilon$1)
            singleHeight = -2;
          let line2 = new HeightMapText$1(len, height2);
          line2.outdated = false;
          nodes.push(line2);
          pos += len + 1;
        }
        if (pos <= end2)
          nodes.push(null, new HeightMapGap2(end2 - pos).updateHeight(oracle, pos));
        let result = HeightMap$1.of(nodes);
        if (singleHeight < 0 || Math.abs(result.height - this.height) >= Epsilon$1 || Math.abs(singleHeight - this.heightMetrics(oracle, offset2).perLine) >= Epsilon$1)
          heightChangeFlag$1 = true;
        return replace$2(this, result);
      } else if (force || this.outdated) {
        this.setHeight(oracle.heightForGap(offset2, offset2 + this.length));
        this.outdated = false;
      }
      return this;
    }
    toString() {
      return `gap(${this.length})`;
    }
  };
  let HeightMapBranch$1 = class HeightMapBranch extends HeightMap$1 {
    constructor(left2, brk, right2) {
      super(left2.length + brk + right2.length, left2.height + right2.height, brk | (left2.outdated || right2.outdated ? 2 : 0));
      this.left = left2;
      this.right = right2;
      this.size = left2.size + right2.size;
    }
    get break() {
      return this.flags & 1;
    }
    blockAt(height2, oracle, top2, offset2) {
      let mid = top2 + this.left.height;
      return height2 < mid ? this.left.blockAt(height2, oracle, top2, offset2) : this.right.blockAt(height2, oracle, mid, offset2 + this.left.length + this.break);
    }
    lineAt(value, type, oracle, top2, offset2) {
      let rightTop = top2 + this.left.height, rightOffset = offset2 + this.left.length + this.break;
      let left2 = type == QueryType$1.ByHeight ? value < rightTop : value < rightOffset;
      let base2 = left2 ? this.left.lineAt(value, type, oracle, top2, offset2) : this.right.lineAt(value, type, oracle, rightTop, rightOffset);
      if (this.break || (left2 ? base2.to < rightOffset : base2.from > rightOffset))
        return base2;
      let subQuery = type == QueryType$1.ByPosNoHeight ? QueryType$1.ByPosNoHeight : QueryType$1.ByPos;
      if (left2)
        return base2.join(this.right.lineAt(rightOffset, subQuery, oracle, rightTop, rightOffset));
      else
        return this.left.lineAt(rightOffset, subQuery, oracle, top2, offset2).join(base2);
    }
    forEachLine(from2, to, oracle, top2, offset2, f) {
      let rightTop = top2 + this.left.height, rightOffset = offset2 + this.left.length + this.break;
      if (this.break) {
        if (from2 < rightOffset)
          this.left.forEachLine(from2, to, oracle, top2, offset2, f);
        if (to >= rightOffset)
          this.right.forEachLine(from2, to, oracle, rightTop, rightOffset, f);
      } else {
        let mid = this.lineAt(rightOffset, QueryType$1.ByPos, oracle, top2, offset2);
        if (from2 < mid.from)
          this.left.forEachLine(from2, mid.from - 1, oracle, top2, offset2, f);
        if (mid.to >= from2 && mid.from <= to)
          f(mid);
        if (to > mid.to)
          this.right.forEachLine(mid.to + 1, to, oracle, rightTop, rightOffset, f);
      }
    }
    replace(from2, to, nodes) {
      let rightStart = this.left.length + this.break;
      if (to < rightStart)
        return this.balanced(this.left.replace(from2, to, nodes), this.right);
      if (from2 > this.left.length)
        return this.balanced(this.left, this.right.replace(from2 - rightStart, to - rightStart, nodes));
      let result = [];
      if (from2 > 0)
        this.decomposeLeft(from2, result);
      let left2 = result.length;
      for (let node2 of nodes)
        result.push(node2);
      if (from2 > 0)
        mergeGaps$1(result, left2 - 1);
      if (to < this.length) {
        let right2 = result.length;
        this.decomposeRight(to, result);
        mergeGaps$1(result, right2);
      }
      return HeightMap$1.of(result);
    }
    decomposeLeft(to, result) {
      let left2 = this.left.length;
      if (to <= left2)
        return this.left.decomposeLeft(to, result);
      result.push(this.left);
      if (this.break) {
        left2++;
        if (to >= left2)
          result.push(null);
      }
      if (to > left2)
        this.right.decomposeLeft(to - left2, result);
    }
    decomposeRight(from2, result) {
      let left2 = this.left.length, right2 = left2 + this.break;
      if (from2 >= right2)
        return this.right.decomposeRight(from2 - right2, result);
      if (from2 < left2)
        this.left.decomposeRight(from2, result);
      if (this.break && from2 < right2)
        result.push(null);
      result.push(this.right);
    }
    balanced(left2, right2) {
      if (left2.size > 2 * right2.size || right2.size > 2 * left2.size)
        return HeightMap$1.of(this.break ? [left2, null, right2] : [left2, right2]);
      this.left = replace$2(this.left, left2);
      this.right = replace$2(this.right, right2);
      this.setHeight(left2.height + right2.height);
      this.outdated = left2.outdated || right2.outdated;
      this.size = left2.size + right2.size;
      this.length = left2.length + this.break + right2.length;
      return this;
    }
    updateHeight(oracle, offset2 = 0, force = false, measured) {
      let { left: left2, right: right2 } = this, rightStart = offset2 + left2.length + this.break, rebalance = null;
      if (measured && measured.from <= offset2 + left2.length && measured.more)
        rebalance = left2 = left2.updateHeight(oracle, offset2, force, measured);
      else
        left2.updateHeight(oracle, offset2, force);
      if (measured && measured.from <= rightStart + right2.length && measured.more)
        rebalance = right2 = right2.updateHeight(oracle, rightStart, force, measured);
      else
        right2.updateHeight(oracle, rightStart, force);
      if (rebalance)
        return this.balanced(left2, right2);
      this.height = this.left.height + this.right.height;
      this.outdated = false;
      return this;
    }
    toString() {
      return this.left + (this.break ? " " : "-") + this.right;
    }
  };
  function mergeGaps$1(nodes, around) {
    let before, after;
    if (nodes[around] == null && (before = nodes[around - 1]) instanceof HeightMapGap$1 && (after = nodes[around + 1]) instanceof HeightMapGap$1)
      nodes.splice(around - 1, 3, new HeightMapGap$1(before.length + 1 + after.length));
  }
  const relevantWidgetHeight$1 = 5;
  let NodeBuilder$1 = class NodeBuilder2 {
    constructor(pos, oracle) {
      this.pos = pos;
      this.oracle = oracle;
      this.nodes = [];
      this.lineStart = -1;
      this.lineEnd = -1;
      this.covering = null;
      this.writtenTo = pos;
    }
    get isCovered() {
      return this.covering && this.nodes[this.nodes.length - 1] == this.covering;
    }
    span(_from, to) {
      if (this.lineStart > -1) {
        let end2 = Math.min(to, this.lineEnd), last = this.nodes[this.nodes.length - 1];
        if (last instanceof HeightMapText$1)
          last.length += end2 - this.pos;
        else if (end2 > this.pos || !this.isCovered)
          this.nodes.push(new HeightMapText$1(end2 - this.pos, -1));
        this.writtenTo = end2;
        if (to > end2) {
          this.nodes.push(null);
          this.writtenTo++;
          this.lineStart = -1;
        }
      }
      this.pos = to;
    }
    point(from2, to, deco) {
      if (from2 < to || deco.heightRelevant) {
        let height2 = deco.widget ? deco.widget.estimatedHeight : 0;
        let breaks = deco.widget ? deco.widget.lineBreaks : 0;
        if (height2 < 0)
          height2 = this.oracle.lineHeight;
        let len = to - from2;
        if (deco.block) {
          this.addBlock(new HeightMapBlock$1(len, height2, deco));
        } else if (len || breaks || height2 >= relevantWidgetHeight$1) {
          this.addLineDeco(height2, breaks, len);
        }
      } else if (to > from2) {
        this.span(from2, to);
      }
      if (this.lineEnd > -1 && this.lineEnd < this.pos)
        this.lineEnd = this.oracle.doc.lineAt(this.pos).to;
    }
    enterLine() {
      if (this.lineStart > -1)
        return;
      let { from: from2, to } = this.oracle.doc.lineAt(this.pos);
      this.lineStart = from2;
      this.lineEnd = to;
      if (this.writtenTo < from2) {
        if (this.writtenTo < from2 - 1 || this.nodes[this.nodes.length - 1] == null)
          this.nodes.push(this.blankContent(this.writtenTo, from2 - 1));
        this.nodes.push(null);
      }
      if (this.pos > from2)
        this.nodes.push(new HeightMapText$1(this.pos - from2, -1));
      this.writtenTo = this.pos;
    }
    blankContent(from2, to) {
      let gap2 = new HeightMapGap$1(to - from2);
      if (this.oracle.doc.lineAt(from2).to == to)
        gap2.flags |= 4;
      return gap2;
    }
    ensureLine() {
      this.enterLine();
      let last = this.nodes.length ? this.nodes[this.nodes.length - 1] : null;
      if (last instanceof HeightMapText$1)
        return last;
      let line2 = new HeightMapText$1(0, -1);
      this.nodes.push(line2);
      return line2;
    }
    addBlock(block) {
      this.enterLine();
      let deco = block.deco;
      if (deco && deco.startSide > 0 && !this.isCovered)
        this.ensureLine();
      this.nodes.push(block);
      this.writtenTo = this.pos = this.pos + block.length;
      if (deco && deco.endSide > 0)
        this.covering = block;
    }
    addLineDeco(height2, breaks, length2) {
      let line2 = this.ensureLine();
      line2.length += length2;
      line2.collapsed += length2;
      line2.widgetHeight = Math.max(line2.widgetHeight, height2);
      line2.breaks += breaks;
      this.writtenTo = this.pos = this.pos + length2;
    }
    finish(from2) {
      let last = this.nodes.length == 0 ? null : this.nodes[this.nodes.length - 1];
      if (this.lineStart > -1 && !(last instanceof HeightMapText$1) && !this.isCovered)
        this.nodes.push(new HeightMapText$1(0, -1));
      else if (this.writtenTo < this.pos || last == null)
        this.nodes.push(this.blankContent(this.writtenTo, this.pos));
      let pos = from2;
      for (let node2 of this.nodes) {
        if (node2 instanceof HeightMapText$1)
          node2.updateHeight(this.oracle, pos);
        pos += node2 ? node2.length : 1;
      }
      return this.nodes;
    }
    // Always called with a region that on both sides either stretches
    // to a line break or the end of the document.
    // The returned array uses null to indicate line breaks, but never
    // starts or ends in a line break, or has multiple line breaks next
    // to each other.
    static build(oracle, decorations2, from2, to) {
      let builder = new NodeBuilder2(from2, oracle);
      RangeSet.spans(decorations2, from2, to, builder, 0);
      return builder.finish(from2);
    }
  };
  function heightRelevantDecoChanges$1(a2, b, diff) {
    let comp = new DecorationComparator$2();
    RangeSet.compare(a2, b, diff, comp, 0);
    return comp.changes;
  }
  let DecorationComparator$2 = class DecorationComparator {
    constructor() {
      this.changes = [];
    }
    compareRange() {
    }
    comparePoint(from2, to, a2, b) {
      if (from2 < to || a2 && a2.heightRelevant || b && b.heightRelevant)
        addRange$1(from2, to, this.changes, 5);
    }
  };
  function visiblePixelRange$1(dom, paddingTop) {
    let rect = dom.getBoundingClientRect();
    let doc2 = dom.ownerDocument, win = doc2.defaultView || window;
    let left2 = Math.max(0, rect.left), right2 = Math.min(win.innerWidth, rect.right);
    let top2 = Math.max(0, rect.top), bottom2 = Math.min(win.innerHeight, rect.bottom);
    for (let parent = dom.parentNode; parent && parent != doc2.body; ) {
      if (parent.nodeType == 1) {
        let elt = parent;
        let style2 = window.getComputedStyle(elt);
        if ((elt.scrollHeight > elt.clientHeight || elt.scrollWidth > elt.clientWidth) && style2.overflow != "visible") {
          let parentRect = elt.getBoundingClientRect();
          left2 = Math.max(left2, parentRect.left);
          right2 = Math.min(right2, parentRect.right);
          top2 = Math.max(top2, parentRect.top);
          bottom2 = Math.min(parent == dom.parentNode ? win.innerHeight : bottom2, parentRect.bottom);
        }
        parent = style2.position == "absolute" || style2.position == "fixed" ? elt.offsetParent : elt.parentNode;
      } else if (parent.nodeType == 11) {
        parent = parent.host;
      } else {
        break;
      }
    }
    return {
      left: left2 - rect.left,
      right: Math.max(left2, right2) - rect.left,
      top: top2 - (rect.top + paddingTop),
      bottom: Math.max(top2, bottom2) - (rect.top + paddingTop)
    };
  }
  function fullPixelRange$1(dom, paddingTop) {
    let rect = dom.getBoundingClientRect();
    return {
      left: 0,
      right: rect.right - rect.left,
      top: paddingTop,
      bottom: rect.bottom - (rect.top + paddingTop)
    };
  }
  let LineGap$1 = class LineGap {
    constructor(from2, to, size, displaySize) {
      this.from = from2;
      this.to = to;
      this.size = size;
      this.displaySize = displaySize;
    }
    static same(a2, b) {
      if (a2.length != b.length)
        return false;
      for (let i2 = 0; i2 < a2.length; i2++) {
        let gA = a2[i2], gB = b[i2];
        if (gA.from != gB.from || gA.to != gB.to || gA.size != gB.size)
          return false;
      }
      return true;
    }
    draw(viewState, wrapping) {
      return Decoration$1.replace({
        widget: new LineGapWidget$1(this.displaySize * (wrapping ? viewState.scaleY : viewState.scaleX), wrapping)
      }).range(this.from, this.to);
    }
  };
  let LineGapWidget$1 = class LineGapWidget extends WidgetType$1 {
    constructor(size, vertical) {
      super();
      this.size = size;
      this.vertical = vertical;
    }
    eq(other) {
      return other.size == this.size && other.vertical == this.vertical;
    }
    toDOM() {
      let elt = document.createElement("div");
      if (this.vertical) {
        elt.style.height = this.size + "px";
      } else {
        elt.style.width = this.size + "px";
        elt.style.height = "2px";
        elt.style.display = "inline-block";
      }
      return elt;
    }
    get estimatedHeight() {
      return this.vertical ? this.size : -1;
    }
  };
  let ViewState$1 = class ViewState {
    constructor(state) {
      this.state = state;
      this.pixelViewport = { left: 0, right: window.innerWidth, top: 0, bottom: 0 };
      this.inView = true;
      this.paddingTop = 0;
      this.paddingBottom = 0;
      this.contentDOMWidth = 0;
      this.contentDOMHeight = 0;
      this.editorHeight = 0;
      this.editorWidth = 0;
      this.scrollTop = 0;
      this.scrolledToBottom = false;
      this.scaleX = 1;
      this.scaleY = 1;
      this.scrollAnchorPos = 0;
      this.scrollAnchorHeight = -1;
      this.scaler = IdScaler$1;
      this.scrollTarget = null;
      this.printing = false;
      this.mustMeasureContent = true;
      this.defaultTextDirection = Direction$1.LTR;
      this.visibleRanges = [];
      this.mustEnforceCursorAssoc = false;
      let guessWrapping = state.facet(contentAttributes$1).some((v2) => typeof v2 != "function" && v2.class == "cm-lineWrapping");
      this.heightOracle = new HeightOracle$1(guessWrapping);
      this.stateDeco = state.facet(decorations$1).filter((d) => typeof d != "function");
      this.heightMap = HeightMap$1.empty().applyChanges(this.stateDeco, Text.empty, this.heightOracle.setDoc(state.doc), [new ChangedRange$1(0, 0, 0, state.doc.length)]);
      for (let i2 = 0; i2 < 2; i2++) {
        this.viewport = this.getViewport(0, null);
        if (!this.updateForViewport())
          break;
      }
      this.updateViewportLines();
      this.lineGaps = this.ensureLineGaps([]);
      this.lineGapDeco = Decoration$1.set(this.lineGaps.map((gap2) => gap2.draw(this, false)));
      this.computeVisibleRanges();
    }
    updateForViewport() {
      let viewports = [this.viewport], { main: main2 } = this.state.selection;
      for (let i2 = 0; i2 <= 1; i2++) {
        let pos = i2 ? main2.head : main2.anchor;
        if (!viewports.some(({ from: from2, to }) => pos >= from2 && pos <= to)) {
          let { from: from2, to } = this.lineBlockAt(pos);
          viewports.push(new Viewport$1(from2, to));
        }
      }
      this.viewports = viewports.sort((a2, b) => a2.from - b.from);
      return this.updateScaler();
    }
    updateScaler() {
      let scaler = this.scaler;
      this.scaler = this.heightMap.height <= 7e6 ? IdScaler$1 : new BigScaler$1(this.heightOracle, this.heightMap, this.viewports);
      return scaler.eq(this.scaler) ? 0 : 2;
    }
    updateViewportLines() {
      this.viewportLines = [];
      this.heightMap.forEachLine(this.viewport.from, this.viewport.to, this.heightOracle.setDoc(this.state.doc), 0, 0, (block) => {
        this.viewportLines.push(scaleBlock$1(block, this.scaler));
      });
    }
    update(update, scrollTarget = null) {
      this.state = update.state;
      let prevDeco = this.stateDeco;
      this.stateDeco = this.state.facet(decorations$1).filter((d) => typeof d != "function");
      let contentChanges = update.changedRanges;
      let heightChanges = ChangedRange$1.extendWithRanges(contentChanges, heightRelevantDecoChanges$1(prevDeco, this.stateDeco, update ? update.changes : ChangeSet.empty(this.state.doc.length)));
      let prevHeight = this.heightMap.height;
      let scrollAnchor = this.scrolledToBottom ? null : this.scrollAnchorAt(this.scrollTop);
      clearHeightChangeFlag$1();
      this.heightMap = this.heightMap.applyChanges(this.stateDeco, update.startState.doc, this.heightOracle.setDoc(this.state.doc), heightChanges);
      if (this.heightMap.height != prevHeight || heightChangeFlag$1)
        update.flags |= 2;
      if (scrollAnchor) {
        this.scrollAnchorPos = update.changes.mapPos(scrollAnchor.from, -1);
        this.scrollAnchorHeight = scrollAnchor.top;
      } else {
        this.scrollAnchorPos = -1;
        this.scrollAnchorHeight = this.heightMap.height;
      }
      let viewport2 = heightChanges.length ? this.mapViewport(this.viewport, update.changes) : this.viewport;
      if (scrollTarget && (scrollTarget.range.head < viewport2.from || scrollTarget.range.head > viewport2.to) || !this.viewportIsAppropriate(viewport2))
        viewport2 = this.getViewport(0, scrollTarget);
      let viewportChange = viewport2.from != this.viewport.from || viewport2.to != this.viewport.to;
      this.viewport = viewport2;
      update.flags |= this.updateForViewport();
      if (viewportChange || !update.changes.empty || update.flags & 2)
        this.updateViewportLines();
      if (this.lineGaps.length || this.viewport.to - this.viewport.from > 2e3 << 1)
        this.updateLineGaps(this.ensureLineGaps(this.mapLineGaps(this.lineGaps, update.changes)));
      update.flags |= this.computeVisibleRanges(update.changes);
      if (scrollTarget)
        this.scrollTarget = scrollTarget;
      if (!this.mustEnforceCursorAssoc && update.selectionSet && update.view.lineWrapping && update.state.selection.main.empty && update.state.selection.main.assoc && !update.state.facet(nativeSelectionHidden$1))
        this.mustEnforceCursorAssoc = true;
    }
    measure(view) {
      let dom = view.contentDOM, style2 = window.getComputedStyle(dom);
      let oracle = this.heightOracle;
      let whiteSpace = style2.whiteSpace;
      this.defaultTextDirection = style2.direction == "rtl" ? Direction$1.RTL : Direction$1.LTR;
      let refresh = this.heightOracle.mustRefreshForWrapping(whiteSpace);
      let domRect = dom.getBoundingClientRect();
      let measureContent = refresh || this.mustMeasureContent || this.contentDOMHeight != domRect.height;
      this.contentDOMHeight = domRect.height;
      this.mustMeasureContent = false;
      let result = 0, bias = 0;
      if (domRect.width && domRect.height) {
        let { scaleX, scaleY } = getScale$2(dom, domRect);
        if (scaleX > 5e-3 && Math.abs(this.scaleX - scaleX) > 5e-3 || scaleY > 5e-3 && Math.abs(this.scaleY - scaleY) > 5e-3) {
          this.scaleX = scaleX;
          this.scaleY = scaleY;
          result |= 16;
          refresh = measureContent = true;
        }
      }
      let paddingTop = (parseInt(style2.paddingTop) || 0) * this.scaleY;
      let paddingBottom = (parseInt(style2.paddingBottom) || 0) * this.scaleY;
      if (this.paddingTop != paddingTop || this.paddingBottom != paddingBottom) {
        this.paddingTop = paddingTop;
        this.paddingBottom = paddingBottom;
        result |= 16 | 2;
      }
      if (this.editorWidth != view.scrollDOM.clientWidth) {
        if (oracle.lineWrapping)
          measureContent = true;
        this.editorWidth = view.scrollDOM.clientWidth;
        result |= 16;
      }
      let scrollTop = view.scrollDOM.scrollTop * this.scaleY;
      if (this.scrollTop != scrollTop) {
        this.scrollAnchorHeight = -1;
        this.scrollTop = scrollTop;
      }
      this.scrolledToBottom = isScrolledToBottom$1(view.scrollDOM);
      let pixelViewport = (this.printing ? fullPixelRange$1 : visiblePixelRange$1)(dom, this.paddingTop);
      let dTop = pixelViewport.top - this.pixelViewport.top, dBottom = pixelViewport.bottom - this.pixelViewport.bottom;
      this.pixelViewport = pixelViewport;
      let inView = this.pixelViewport.bottom > this.pixelViewport.top && this.pixelViewport.right > this.pixelViewport.left;
      if (inView != this.inView) {
        this.inView = inView;
        if (inView)
          measureContent = true;
      }
      if (!this.inView && !this.scrollTarget)
        return 0;
      let contentWidth = domRect.width;
      if (this.contentDOMWidth != contentWidth || this.editorHeight != view.scrollDOM.clientHeight) {
        this.contentDOMWidth = domRect.width;
        this.editorHeight = view.scrollDOM.clientHeight;
        result |= 16;
      }
      if (measureContent) {
        let lineHeights = view.docView.measureVisibleLineHeights(this.viewport);
        if (oracle.mustRefreshForHeights(lineHeights))
          refresh = true;
        if (refresh || oracle.lineWrapping && Math.abs(contentWidth - this.contentDOMWidth) > oracle.charWidth) {
          let { lineHeight, charWidth, textHeight } = view.docView.measureTextSize();
          refresh = lineHeight > 0 && oracle.refresh(whiteSpace, lineHeight, charWidth, textHeight, contentWidth / charWidth, lineHeights);
          if (refresh) {
            view.docView.minWidth = 0;
            result |= 16;
          }
        }
        if (dTop > 0 && dBottom > 0)
          bias = Math.max(dTop, dBottom);
        else if (dTop < 0 && dBottom < 0)
          bias = Math.min(dTop, dBottom);
        clearHeightChangeFlag$1();
        for (let vp of this.viewports) {
          let heights = vp.from == this.viewport.from ? lineHeights : view.docView.measureVisibleLineHeights(vp);
          this.heightMap = (refresh ? HeightMap$1.empty().applyChanges(this.stateDeco, Text.empty, this.heightOracle, [new ChangedRange$1(0, 0, 0, view.state.doc.length)]) : this.heightMap).updateHeight(oracle, 0, refresh, new MeasuredHeights$1(vp.from, heights));
        }
        if (heightChangeFlag$1)
          result |= 2;
      }
      let viewportChange = !this.viewportIsAppropriate(this.viewport, bias) || this.scrollTarget && (this.scrollTarget.range.head < this.viewport.from || this.scrollTarget.range.head > this.viewport.to);
      if (viewportChange) {
        if (result & 2)
          result |= this.updateScaler();
        this.viewport = this.getViewport(bias, this.scrollTarget);
        result |= this.updateForViewport();
      }
      if (result & 2 || viewportChange)
        this.updateViewportLines();
      if (this.lineGaps.length || this.viewport.to - this.viewport.from > 2e3 << 1)
        this.updateLineGaps(this.ensureLineGaps(refresh ? [] : this.lineGaps, view));
      result |= this.computeVisibleRanges();
      if (this.mustEnforceCursorAssoc) {
        this.mustEnforceCursorAssoc = false;
        view.docView.enforceCursorAssoc();
      }
      return result;
    }
    get visibleTop() {
      return this.scaler.fromDOM(this.pixelViewport.top);
    }
    get visibleBottom() {
      return this.scaler.fromDOM(this.pixelViewport.bottom);
    }
    getViewport(bias, scrollTarget) {
      let marginTop = 0.5 - Math.max(-0.5, Math.min(0.5, bias / 1e3 / 2));
      let map = this.heightMap, oracle = this.heightOracle;
      let { visibleTop, visibleBottom } = this;
      let viewport2 = new Viewport$1(map.lineAt(visibleTop - marginTop * 1e3, QueryType$1.ByHeight, oracle, 0, 0).from, map.lineAt(visibleBottom + (1 - marginTop) * 1e3, QueryType$1.ByHeight, oracle, 0, 0).to);
      if (scrollTarget) {
        let { head } = scrollTarget.range;
        if (head < viewport2.from || head > viewport2.to) {
          let viewHeight = Math.min(this.editorHeight, this.pixelViewport.bottom - this.pixelViewport.top);
          let block = map.lineAt(head, QueryType$1.ByPos, oracle, 0, 0), topPos;
          if (scrollTarget.y == "center")
            topPos = (block.top + block.bottom) / 2 - viewHeight / 2;
          else if (scrollTarget.y == "start" || scrollTarget.y == "nearest" && head < viewport2.from)
            topPos = block.top;
          else
            topPos = block.bottom - viewHeight;
          viewport2 = new Viewport$1(map.lineAt(topPos - 1e3 / 2, QueryType$1.ByHeight, oracle, 0, 0).from, map.lineAt(topPos + viewHeight + 1e3 / 2, QueryType$1.ByHeight, oracle, 0, 0).to);
        }
      }
      return viewport2;
    }
    mapViewport(viewport2, changes) {
      let from2 = changes.mapPos(viewport2.from, -1), to = changes.mapPos(viewport2.to, 1);
      return new Viewport$1(this.heightMap.lineAt(from2, QueryType$1.ByPos, this.heightOracle, 0, 0).from, this.heightMap.lineAt(to, QueryType$1.ByPos, this.heightOracle, 0, 0).to);
    }
    // Checks if a given viewport covers the visible part of the
    // document and not too much beyond that.
    viewportIsAppropriate({ from: from2, to }, bias = 0) {
      if (!this.inView)
        return true;
      let { top: top2 } = this.heightMap.lineAt(from2, QueryType$1.ByPos, this.heightOracle, 0, 0);
      let { bottom: bottom2 } = this.heightMap.lineAt(to, QueryType$1.ByPos, this.heightOracle, 0, 0);
      let { visibleTop, visibleBottom } = this;
      return (from2 == 0 || top2 <= visibleTop - Math.max(10, Math.min(
        -bias,
        250
        /* VP.MaxCoverMargin */
      ))) && (to == this.state.doc.length || bottom2 >= visibleBottom + Math.max(10, Math.min(
        bias,
        250
        /* VP.MaxCoverMargin */
      ))) && (top2 > visibleTop - 2 * 1e3 && bottom2 < visibleBottom + 2 * 1e3);
    }
    mapLineGaps(gaps, changes) {
      if (!gaps.length || changes.empty)
        return gaps;
      let mapped = [];
      for (let gap2 of gaps)
        if (!changes.touchesRange(gap2.from, gap2.to))
          mapped.push(new LineGap$1(changes.mapPos(gap2.from), changes.mapPos(gap2.to), gap2.size, gap2.displaySize));
      return mapped;
    }
    // Computes positions in the viewport where the start or end of a
    // line should be hidden, trying to reuse existing line gaps when
    // appropriate to avoid unneccesary redraws.
    // Uses crude character-counting for the positioning and sizing,
    // since actual DOM coordinates aren't always available and
    // predictable. Relies on generous margins (see LG.Margin) to hide
    // the artifacts this might produce from the user.
    ensureLineGaps(current, mayMeasure) {
      let wrapping = this.heightOracle.lineWrapping;
      let margin2 = wrapping ? 1e4 : 2e3, halfMargin = margin2 >> 1, doubleMargin = margin2 << 1;
      if (this.defaultTextDirection != Direction$1.LTR && !wrapping)
        return [];
      let gaps = [];
      let addGap = (from2, to, line2, structure) => {
        if (to - from2 < halfMargin)
          return;
        let sel = this.state.selection.main, avoid = [sel.from];
        if (!sel.empty)
          avoid.push(sel.to);
        for (let pos of avoid) {
          if (pos > from2 && pos < to) {
            addGap(from2, pos - 10, line2, structure);
            addGap(pos + 10, to, line2, structure);
            return;
          }
        }
        let gap2 = find$1(current, (gap3) => gap3.from >= line2.from && gap3.to <= line2.to && Math.abs(gap3.from - from2) < halfMargin && Math.abs(gap3.to - to) < halfMargin && !avoid.some((pos) => gap3.from < pos && gap3.to > pos));
        if (!gap2) {
          if (to < line2.to && mayMeasure && wrapping && mayMeasure.visibleRanges.some((r2) => r2.from <= to && r2.to >= to)) {
            let lineStart = mayMeasure.moveToLineBoundary(EditorSelection.cursor(to), false, true).head;
            if (lineStart > from2)
              to = lineStart;
          }
          let size = this.gapSize(line2, from2, to, structure);
          let displaySize = wrapping || size < 2e6 ? size : 2e6;
          gap2 = new LineGap$1(from2, to, size, displaySize);
        }
        gaps.push(gap2);
      };
      let checkLine = (line2) => {
        if (line2.length < doubleMargin || line2.type != BlockType$1.Text)
          return;
        let structure = lineStructure$1(line2.from, line2.to, this.stateDeco);
        if (structure.total < doubleMargin)
          return;
        let target = this.scrollTarget ? this.scrollTarget.range.head : null;
        let viewFrom, viewTo;
        if (wrapping) {
          let marginHeight = margin2 / this.heightOracle.lineLength * this.heightOracle.lineHeight;
          let top2, bot;
          if (target != null) {
            let targetFrac = findFraction$1(structure, target);
            let spaceFrac = ((this.visibleBottom - this.visibleTop) / 2 + marginHeight) / line2.height;
            top2 = targetFrac - spaceFrac;
            bot = targetFrac + spaceFrac;
          } else {
            top2 = (this.visibleTop - line2.top - marginHeight) / line2.height;
            bot = (this.visibleBottom - line2.top + marginHeight) / line2.height;
          }
          viewFrom = findPosition$1(structure, top2);
          viewTo = findPosition$1(structure, bot);
        } else {
          let totalWidth = structure.total * this.heightOracle.charWidth;
          let marginWidth = margin2 * this.heightOracle.charWidth;
          let horizOffset = 0;
          if (totalWidth > 2e6)
            for (let old of current) {
              if (old.from >= line2.from && old.from < line2.to && old.size != old.displaySize && old.from * this.heightOracle.charWidth + horizOffset < this.pixelViewport.left)
                horizOffset = old.size - old.displaySize;
            }
          let pxLeft = this.pixelViewport.left + horizOffset, pxRight = this.pixelViewport.right + horizOffset;
          let left2, right2;
          if (target != null) {
            let targetFrac = findFraction$1(structure, target);
            let spaceFrac = ((pxRight - pxLeft) / 2 + marginWidth) / totalWidth;
            left2 = targetFrac - spaceFrac;
            right2 = targetFrac + spaceFrac;
          } else {
            left2 = (pxLeft - marginWidth) / totalWidth;
            right2 = (pxRight + marginWidth) / totalWidth;
          }
          viewFrom = findPosition$1(structure, left2);
          viewTo = findPosition$1(structure, right2);
        }
        if (viewFrom > line2.from)
          addGap(line2.from, viewFrom, line2, structure);
        if (viewTo < line2.to)
          addGap(viewTo, line2.to, line2, structure);
      };
      for (let line2 of this.viewportLines) {
        if (Array.isArray(line2.type))
          line2.type.forEach(checkLine);
        else
          checkLine(line2);
      }
      return gaps;
    }
    gapSize(line2, from2, to, structure) {
      let fraction = findFraction$1(structure, to) - findFraction$1(structure, from2);
      if (this.heightOracle.lineWrapping) {
        return line2.height * fraction;
      } else {
        return structure.total * this.heightOracle.charWidth * fraction;
      }
    }
    updateLineGaps(gaps) {
      if (!LineGap$1.same(gaps, this.lineGaps)) {
        this.lineGaps = gaps;
        this.lineGapDeco = Decoration$1.set(gaps.map((gap2) => gap2.draw(this, this.heightOracle.lineWrapping)));
      }
    }
    computeVisibleRanges(changes) {
      let deco = this.stateDeco;
      if (this.lineGaps.length)
        deco = deco.concat(this.lineGapDeco);
      let ranges = [];
      RangeSet.spans(deco, this.viewport.from, this.viewport.to, {
        span(from2, to) {
          ranges.push({ from: from2, to });
        },
        point() {
        }
      }, 20);
      let changed = 0;
      if (ranges.length != this.visibleRanges.length) {
        changed = 8 | 4;
      } else {
        for (let i2 = 0; i2 < ranges.length && !(changed & 8); i2++) {
          let old = this.visibleRanges[i2], nw = ranges[i2];
          if (old.from != nw.from || old.to != nw.to) {
            changed |= 4;
            if (!(changes && changes.mapPos(old.from, -1) == nw.from && changes.mapPos(old.to, 1) == nw.to))
              changed |= 8;
          }
        }
      }
      this.visibleRanges = ranges;
      return changed;
    }
    lineBlockAt(pos) {
      return pos >= this.viewport.from && pos <= this.viewport.to && this.viewportLines.find((b) => b.from <= pos && b.to >= pos) || scaleBlock$1(this.heightMap.lineAt(pos, QueryType$1.ByPos, this.heightOracle, 0, 0), this.scaler);
    }
    lineBlockAtHeight(height2) {
      return height2 >= this.viewportLines[0].top && height2 <= this.viewportLines[this.viewportLines.length - 1].bottom && this.viewportLines.find((l) => l.top <= height2 && l.bottom >= height2) || scaleBlock$1(this.heightMap.lineAt(this.scaler.fromDOM(height2), QueryType$1.ByHeight, this.heightOracle, 0, 0), this.scaler);
    }
    scrollAnchorAt(scrollTop) {
      let block = this.lineBlockAtHeight(scrollTop + 8);
      return block.from >= this.viewport.from || this.viewportLines[0].top - scrollTop > 200 ? block : this.viewportLines[0];
    }
    elementAtHeight(height2) {
      return scaleBlock$1(this.heightMap.blockAt(this.scaler.fromDOM(height2), this.heightOracle, 0, 0), this.scaler);
    }
    get docHeight() {
      return this.scaler.toDOM(this.heightMap.height);
    }
    get contentHeight() {
      return this.docHeight + this.paddingTop + this.paddingBottom;
    }
  };
  let Viewport$1 = class Viewport {
    constructor(from2, to) {
      this.from = from2;
      this.to = to;
    }
  };
  function lineStructure$1(from2, to, stateDeco) {
    let ranges = [], pos = from2, total = 0;
    RangeSet.spans(stateDeco, from2, to, {
      span() {
      },
      point(from3, to2) {
        if (from3 > pos) {
          ranges.push({ from: pos, to: from3 });
          total += from3 - pos;
        }
        pos = to2;
      }
    }, 20);
    if (pos < to) {
      ranges.push({ from: pos, to });
      total += to - pos;
    }
    return { total, ranges };
  }
  function findPosition$1({ total, ranges }, ratio) {
    if (ratio <= 0)
      return ranges[0].from;
    if (ratio >= 1)
      return ranges[ranges.length - 1].to;
    let dist2 = Math.floor(total * ratio);
    for (let i2 = 0; ; i2++) {
      let { from: from2, to } = ranges[i2], size = to - from2;
      if (dist2 <= size)
        return from2 + dist2;
      dist2 -= size;
    }
  }
  function findFraction$1(structure, pos) {
    let counted = 0;
    for (let { from: from2, to } of structure.ranges) {
      if (pos <= to) {
        counted += pos - from2;
        break;
      }
      counted += to - from2;
    }
    return counted / structure.total;
  }
  function find$1(array, f) {
    for (let val of array)
      if (f(val))
        return val;
    return void 0;
  }
  const IdScaler$1 = {
    toDOM(n) {
      return n;
    },
    fromDOM(n) {
      return n;
    },
    scale: 1,
    eq(other) {
      return other == this;
    }
  };
  let BigScaler$1 = class BigScaler2 {
    constructor(oracle, heightMap, viewports) {
      let vpHeight = 0, base2 = 0, domBase = 0;
      this.viewports = viewports.map(({ from: from2, to }) => {
        let top2 = heightMap.lineAt(from2, QueryType$1.ByPos, oracle, 0, 0).top;
        let bottom2 = heightMap.lineAt(to, QueryType$1.ByPos, oracle, 0, 0).bottom;
        vpHeight += bottom2 - top2;
        return { from: from2, to, top: top2, bottom: bottom2, domTop: 0, domBottom: 0 };
      });
      this.scale = (7e6 - vpHeight) / (heightMap.height - vpHeight);
      for (let obj of this.viewports) {
        obj.domTop = domBase + (obj.top - base2) * this.scale;
        domBase = obj.domBottom = obj.domTop + (obj.bottom - obj.top);
        base2 = obj.bottom;
      }
    }
    toDOM(n) {
      for (let i2 = 0, base2 = 0, domBase = 0; ; i2++) {
        let vp = i2 < this.viewports.length ? this.viewports[i2] : null;
        if (!vp || n < vp.top)
          return domBase + (n - base2) * this.scale;
        if (n <= vp.bottom)
          return vp.domTop + (n - vp.top);
        base2 = vp.bottom;
        domBase = vp.domBottom;
      }
    }
    fromDOM(n) {
      for (let i2 = 0, base2 = 0, domBase = 0; ; i2++) {
        let vp = i2 < this.viewports.length ? this.viewports[i2] : null;
        if (!vp || n < vp.domTop)
          return base2 + (n - domBase) / this.scale;
        if (n <= vp.domBottom)
          return vp.top + (n - vp.domTop);
        base2 = vp.bottom;
        domBase = vp.domBottom;
      }
    }
    eq(other) {
      if (!(other instanceof BigScaler2))
        return false;
      return this.scale == other.scale && this.viewports.length == other.viewports.length && this.viewports.every((vp, i2) => vp.from == other.viewports[i2].from && vp.to == other.viewports[i2].to);
    }
  };
  function scaleBlock$1(block, scaler) {
    if (scaler.scale == 1)
      return block;
    let bTop = scaler.toDOM(block.top), bBottom = scaler.toDOM(block.bottom);
    return new BlockInfo$1(block.from, block.length, bTop, bBottom - bTop, Array.isArray(block._content) ? block._content.map((b) => scaleBlock$1(b, scaler)) : block._content);
  }
  const theme$2 = /* @__PURE__ */ Facet.define({ combine: (strs) => strs.join(" ") });
  const darkTheme$1 = /* @__PURE__ */ Facet.define({ combine: (values2) => values2.indexOf(true) > -1 });
  const baseThemeID$1 = /* @__PURE__ */ StyleModule.newName(), baseLightID$1 = /* @__PURE__ */ StyleModule.newName(), baseDarkID$1 = /* @__PURE__ */ StyleModule.newName();
  const lightDarkIDs$1 = { "&light": "." + baseLightID$1, "&dark": "." + baseDarkID$1 };
  function buildTheme$1(main2, spec, scopes) {
    return new StyleModule(spec, {
      finish(sel) {
        return /&/.test(sel) ? sel.replace(/&\w*/, (m2) => {
          if (m2 == "&")
            return main2;
          if (!scopes || !scopes[m2])
            throw new RangeError(`Unsupported selector: ${m2}`);
          return scopes[m2];
        }) : main2 + " " + sel;
      }
    });
  }
  const baseTheme$1$1 = /* @__PURE__ */ buildTheme$1("." + baseThemeID$1, {
    "&": {
      position: "relative !important",
      boxSizing: "border-box",
      "&.cm-focused": {
        // Provide a simple default outline to make sure a focused
        // editor is visually distinct. Can't leave the default behavior
        // because that will apply to the content element, which is
        // inside the scrollable container and doesn't include the
        // gutters. We also can't use an 'auto' outline, since those
        // are, for some reason, drawn behind the element content, which
        // will cause things like the active line background to cover
        // the outline (#297).
        outline: "1px dotted #212121"
      },
      display: "flex !important",
      flexDirection: "column"
    },
    ".cm-scroller": {
      display: "flex !important",
      alignItems: "flex-start !important",
      fontFamily: "monospace",
      lineHeight: 1.4,
      height: "100%",
      overflowX: "auto",
      position: "relative",
      zIndex: 0,
      overflowAnchor: "none"
    },
    ".cm-content": {
      margin: 0,
      flexGrow: 2,
      flexShrink: 0,
      display: "block",
      whiteSpace: "pre",
      wordWrap: "normal",
      // https://github.com/codemirror/dev/issues/456
      boxSizing: "border-box",
      minHeight: "100%",
      padding: "4px 0",
      outline: "none",
      "&[contenteditable=true]": {
        WebkitUserModify: "read-write-plaintext-only"
      }
    },
    ".cm-lineWrapping": {
      whiteSpace_fallback: "pre-wrap",
      // For IE
      whiteSpace: "break-spaces",
      wordBreak: "break-word",
      // For Safari, which doesn't support overflow-wrap: anywhere
      overflowWrap: "anywhere",
      flexShrink: 1
    },
    "&light .cm-content": { caretColor: "black" },
    "&dark .cm-content": { caretColor: "white" },
    ".cm-line": {
      display: "block",
      padding: "0 2px 0 6px"
    },
    ".cm-layer": {
      position: "absolute",
      left: 0,
      top: 0,
      contain: "size style",
      "& > *": {
        position: "absolute"
      }
    },
    "&light .cm-selectionBackground": {
      background: "#d9d9d9"
    },
    "&dark .cm-selectionBackground": {
      background: "#222"
    },
    "&light.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground": {
      background: "#d7d4f0"
    },
    "&dark.cm-focused > .cm-scroller > .cm-selectionLayer .cm-selectionBackground": {
      background: "#233"
    },
    ".cm-cursorLayer": {
      pointerEvents: "none"
    },
    "&.cm-focused > .cm-scroller > .cm-cursorLayer": {
      animation: "steps(1) cm-blink 1.2s infinite"
    },
    // Two animations defined so that we can switch between them to
    // restart the animation without forcing another style
    // recomputation.
    "@keyframes cm-blink": { "0%": {}, "50%": { opacity: 0 }, "100%": {} },
    "@keyframes cm-blink2": { "0%": {}, "50%": { opacity: 0 }, "100%": {} },
    ".cm-cursor, .cm-dropCursor": {
      borderLeft: "1.2px solid black",
      marginLeft: "-0.6px",
      pointerEvents: "none"
    },
    ".cm-cursor": {
      display: "none"
    },
    "&dark .cm-cursor": {
      borderLeftColor: "#ddd"
    },
    ".cm-dropCursor": {
      position: "absolute"
    },
    "&.cm-focused > .cm-scroller > .cm-cursorLayer .cm-cursor": {
      display: "block"
    },
    ".cm-iso": {
      unicodeBidi: "isolate"
    },
    ".cm-announced": {
      position: "fixed",
      top: "-10000px"
    },
    "@media print": {
      ".cm-announced": { display: "none" }
    },
    "&light .cm-activeLine": { backgroundColor: "#cceeff44" },
    "&dark .cm-activeLine": { backgroundColor: "#99eeff33" },
    "&light .cm-specialChar": { color: "red" },
    "&dark .cm-specialChar": { color: "#f78" },
    ".cm-gutters": {
      flexShrink: 0,
      display: "flex",
      height: "100%",
      boxSizing: "border-box",
      insetInlineStart: 0,
      zIndex: 200
    },
    "&light .cm-gutters": {
      backgroundColor: "#f5f5f5",
      color: "#6c6c6c",
      borderRight: "1px solid #ddd"
    },
    "&dark .cm-gutters": {
      backgroundColor: "#333338",
      color: "#ccc"
    },
    ".cm-gutter": {
      display: "flex !important",
      // Necessary -- prevents margin collapsing
      flexDirection: "column",
      flexShrink: 0,
      boxSizing: "border-box",
      minHeight: "100%",
      overflow: "hidden"
    },
    ".cm-gutterElement": {
      boxSizing: "border-box"
    },
    ".cm-lineNumbers .cm-gutterElement": {
      padding: "0 3px 0 5px",
      minWidth: "20px",
      textAlign: "right",
      whiteSpace: "nowrap"
    },
    "&light .cm-activeLineGutter": {
      backgroundColor: "#e2f2ff"
    },
    "&dark .cm-activeLineGutter": {
      backgroundColor: "#222227"
    },
    ".cm-panels": {
      boxSizing: "border-box",
      position: "sticky",
      left: 0,
      right: 0,
      zIndex: 300
    },
    "&light .cm-panels": {
      backgroundColor: "#f5f5f5",
      color: "black"
    },
    "&light .cm-panels-top": {
      borderBottom: "1px solid #ddd"
    },
    "&light .cm-panels-bottom": {
      borderTop: "1px solid #ddd"
    },
    "&dark .cm-panels": {
      backgroundColor: "#333338",
      color: "white"
    },
    ".cm-tab": {
      display: "inline-block",
      overflow: "hidden",
      verticalAlign: "bottom"
    },
    ".cm-widgetBuffer": {
      verticalAlign: "text-top",
      height: "1em",
      width: 0,
      display: "inline"
    },
    ".cm-placeholder": {
      color: "#888",
      display: "inline-block",
      verticalAlign: "top"
    },
    ".cm-highlightSpace": {
      backgroundImage: "radial-gradient(circle at 50% 55%, #aaa 20%, transparent 5%)",
      backgroundPosition: "center"
    },
    ".cm-highlightTab": {
      backgroundImage: `url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" width="200" height="20"><path stroke="%23888" stroke-width="1" fill="none" d="M1 10H196L190 5M190 15L196 10M197 4L197 16"/></svg>')`,
      backgroundSize: "auto 100%",
      backgroundPosition: "right 90%",
      backgroundRepeat: "no-repeat"
    },
    ".cm-trailingSpace": {
      backgroundColor: "#ff332255"
    },
    ".cm-button": {
      verticalAlign: "middle",
      color: "inherit",
      fontSize: "70%",
      padding: ".2em 1em",
      borderRadius: "1px"
    },
    "&light .cm-button": {
      backgroundImage: "linear-gradient(#eff1f5, #d9d9df)",
      border: "1px solid #888",
      "&:active": {
        backgroundImage: "linear-gradient(#b4b4b4, #d0d3d6)"
      }
    },
    "&dark .cm-button": {
      backgroundImage: "linear-gradient(#393939, #111)",
      border: "1px solid #888",
      "&:active": {
        backgroundImage: "linear-gradient(#111, #333)"
      }
    },
    ".cm-textfield": {
      verticalAlign: "middle",
      color: "inherit",
      fontSize: "70%",
      border: "1px solid silver",
      padding: ".2em .5em"
    },
    "&light .cm-textfield": {
      backgroundColor: "white"
    },
    "&dark .cm-textfield": {
      border: "1px solid #555",
      backgroundColor: "inherit"
    }
  }, lightDarkIDs$1);
  const observeOptions$1 = {
    childList: true,
    characterData: true,
    subtree: true,
    attributes: true,
    characterDataOldValue: true
  };
  const useCharData$1 = browser$1.ie && browser$1.ie_version <= 11;
  let DOMObserver$1 = class DOMObserver {
    constructor(view) {
      this.view = view;
      this.active = false;
      this.editContext = null;
      this.selectionRange = new DOMSelectionState$1();
      this.selectionChanged = false;
      this.delayedFlush = -1;
      this.resizeTimeout = -1;
      this.queue = [];
      this.delayedAndroidKey = null;
      this.flushingAndroidKey = -1;
      this.lastChange = 0;
      this.scrollTargets = [];
      this.intersection = null;
      this.resizeScroll = null;
      this.intersecting = false;
      this.gapIntersection = null;
      this.gaps = [];
      this.printQuery = null;
      this.parentCheck = -1;
      this.dom = view.contentDOM;
      this.observer = new MutationObserver((mutations) => {
        for (let mut of mutations)
          this.queue.push(mut);
        if ((browser$1.ie && browser$1.ie_version <= 11 || browser$1.ios && view.composing) && mutations.some((m2) => m2.type == "childList" && m2.removedNodes.length || m2.type == "characterData" && m2.oldValue.length > m2.target.nodeValue.length))
          this.flushSoon();
        else
          this.flush();
      });
      if (window.EditContext && view.constructor.EDIT_CONTEXT !== false && // Chrome <126 doesn't support inverted selections in edit context (#1392)
      !(browser$1.chrome && browser$1.chrome_version < 126)) {
        this.editContext = new EditContextManager$1(view);
        if (view.state.facet(editable$1))
          view.contentDOM.editContext = this.editContext.editContext;
      }
      if (useCharData$1)
        this.onCharData = (event) => {
          this.queue.push({
            target: event.target,
            type: "characterData",
            oldValue: event.prevValue
          });
          this.flushSoon();
        };
      this.onSelectionChange = this.onSelectionChange.bind(this);
      this.onResize = this.onResize.bind(this);
      this.onPrint = this.onPrint.bind(this);
      this.onScroll = this.onScroll.bind(this);
      if (window.matchMedia)
        this.printQuery = window.matchMedia("print");
      if (typeof ResizeObserver == "function") {
        this.resizeScroll = new ResizeObserver(() => {
          var _a3;
          if (((_a3 = this.view.docView) === null || _a3 === void 0 ? void 0 : _a3.lastUpdate) < Date.now() - 75)
            this.onResize();
        });
        this.resizeScroll.observe(view.scrollDOM);
      }
      this.addWindowListeners(this.win = view.win);
      this.start();
      if (typeof IntersectionObserver == "function") {
        this.intersection = new IntersectionObserver((entries) => {
          if (this.parentCheck < 0)
            this.parentCheck = setTimeout(this.listenForScroll.bind(this), 1e3);
          if (entries.length > 0 && entries[entries.length - 1].intersectionRatio > 0 != this.intersecting) {
            this.intersecting = !this.intersecting;
            if (this.intersecting != this.view.inView)
              this.onScrollChanged(document.createEvent("Event"));
          }
        }, { threshold: [0, 1e-3] });
        this.intersection.observe(this.dom);
        this.gapIntersection = new IntersectionObserver((entries) => {
          if (entries.length > 0 && entries[entries.length - 1].intersectionRatio > 0)
            this.onScrollChanged(document.createEvent("Event"));
        }, {});
      }
      this.listenForScroll();
      this.readSelectionRange();
    }
    onScrollChanged(e) {
      this.view.inputState.runHandlers("scroll", e);
      if (this.intersecting)
        this.view.measure();
    }
    onScroll(e) {
      if (this.intersecting)
        this.flush(false);
      if (this.editContext)
        this.view.requestMeasure(this.editContext.measureReq);
      this.onScrollChanged(e);
    }
    onResize() {
      if (this.resizeTimeout < 0)
        this.resizeTimeout = setTimeout(() => {
          this.resizeTimeout = -1;
          this.view.requestMeasure();
        }, 50);
    }
    onPrint(event) {
      if ((event.type == "change" || !event.type) && !event.matches)
        return;
      this.view.viewState.printing = true;
      this.view.measure();
      setTimeout(() => {
        this.view.viewState.printing = false;
        this.view.requestMeasure();
      }, 500);
    }
    updateGaps(gaps) {
      if (this.gapIntersection && (gaps.length != this.gaps.length || this.gaps.some((g, i2) => g != gaps[i2]))) {
        this.gapIntersection.disconnect();
        for (let gap2 of gaps)
          this.gapIntersection.observe(gap2);
        this.gaps = gaps;
      }
    }
    onSelectionChange(event) {
      let wasChanged = this.selectionChanged;
      if (!this.readSelectionRange() || this.delayedAndroidKey)
        return;
      let { view } = this, sel = this.selectionRange;
      if (view.state.facet(editable$1) ? view.root.activeElement != this.dom : !hasSelection$1(this.dom, sel))
        return;
      let context = sel.anchorNode && view.docView.nearest(sel.anchorNode);
      if (context && context.ignoreEvent(event)) {
        if (!wasChanged)
          this.selectionChanged = false;
        return;
      }
      if ((browser$1.ie && browser$1.ie_version <= 11 || browser$1.android && browser$1.chrome) && !view.state.selection.main.empty && // (Selection.isCollapsed isn't reliable on IE)
      sel.focusNode && isEquivalentPosition$1(sel.focusNode, sel.focusOffset, sel.anchorNode, sel.anchorOffset))
        this.flushSoon();
      else
        this.flush(false);
    }
    readSelectionRange() {
      let { view } = this;
      let selection = getSelection$2(view.root);
      if (!selection)
        return false;
      let range = browser$1.safari && view.root.nodeType == 11 && view.root.activeElement == this.dom && safariSelectionRangeHack$1(this.view, selection) || selection;
      if (!range || this.selectionRange.eq(range))
        return false;
      let local = hasSelection$1(this.dom, range);
      if (local && !this.selectionChanged && view.inputState.lastFocusTime > Date.now() - 200 && view.inputState.lastTouchTime < Date.now() - 300 && atElementStart$1(this.dom, range)) {
        this.view.inputState.lastFocusTime = 0;
        view.docView.updateSelection();
        return false;
      }
      this.selectionRange.setRange(range);
      if (local)
        this.selectionChanged = true;
      return true;
    }
    setSelectionRange(anchor, head) {
      this.selectionRange.set(anchor.node, anchor.offset, head.node, head.offset);
      this.selectionChanged = false;
    }
    clearSelectionRange() {
      this.selectionRange.set(null, 0, null, 0);
    }
    listenForScroll() {
      this.parentCheck = -1;
      let i2 = 0, changed = null;
      for (let dom = this.dom; dom; ) {
        if (dom.nodeType == 1) {
          if (!changed && i2 < this.scrollTargets.length && this.scrollTargets[i2] == dom)
            i2++;
          else if (!changed)
            changed = this.scrollTargets.slice(0, i2);
          if (changed)
            changed.push(dom);
          dom = dom.assignedSlot || dom.parentNode;
        } else if (dom.nodeType == 11) {
          dom = dom.host;
        } else {
          break;
        }
      }
      if (i2 < this.scrollTargets.length && !changed)
        changed = this.scrollTargets.slice(0, i2);
      if (changed) {
        for (let dom of this.scrollTargets)
          dom.removeEventListener("scroll", this.onScroll);
        for (let dom of this.scrollTargets = changed)
          dom.addEventListener("scroll", this.onScroll);
      }
    }
    ignore(f) {
      if (!this.active)
        return f();
      try {
        this.stop();
        return f();
      } finally {
        this.start();
        this.clear();
      }
    }
    start() {
      if (this.active)
        return;
      this.observer.observe(this.dom, observeOptions$1);
      if (useCharData$1)
        this.dom.addEventListener("DOMCharacterDataModified", this.onCharData);
      this.active = true;
    }
    stop() {
      if (!this.active)
        return;
      this.active = false;
      this.observer.disconnect();
      if (useCharData$1)
        this.dom.removeEventListener("DOMCharacterDataModified", this.onCharData);
    }
    // Throw away any pending changes
    clear() {
      this.processRecords();
      this.queue.length = 0;
      this.selectionChanged = false;
    }
    // Chrome Android, especially in combination with GBoard, not only
    // doesn't reliably fire regular key events, but also often
    // surrounds the effect of enter or backspace with a bunch of
    // composition events that, when interrupted, cause text duplication
    // or other kinds of corruption. This hack makes the editor back off
    // from handling DOM changes for a moment when such a key is
    // detected (via beforeinput or keydown), and then tries to flush
    // them or, if that has no effect, dispatches the given key.
    delayAndroidKey(key, keyCode) {
      var _a3;
      if (!this.delayedAndroidKey) {
        let flush = () => {
          let key2 = this.delayedAndroidKey;
          if (key2) {
            this.clearDelayedAndroidKey();
            this.view.inputState.lastKeyCode = key2.keyCode;
            this.view.inputState.lastKeyTime = Date.now();
            let flushed = this.flush();
            if (!flushed && key2.force)
              dispatchKey$1(this.dom, key2.key, key2.keyCode);
          }
        };
        this.flushingAndroidKey = this.view.win.requestAnimationFrame(flush);
      }
      if (!this.delayedAndroidKey || key == "Enter")
        this.delayedAndroidKey = {
          key,
          keyCode,
          // Only run the key handler when no changes are detected if
          // this isn't coming right after another change, in which case
          // it is probably part of a weird chain of updates, and should
          // be ignored if it returns the DOM to its previous state.
          force: this.lastChange < Date.now() - 50 || !!((_a3 = this.delayedAndroidKey) === null || _a3 === void 0 ? void 0 : _a3.force)
        };
    }
    clearDelayedAndroidKey() {
      this.win.cancelAnimationFrame(this.flushingAndroidKey);
      this.delayedAndroidKey = null;
      this.flushingAndroidKey = -1;
    }
    flushSoon() {
      if (this.delayedFlush < 0)
        this.delayedFlush = this.view.win.requestAnimationFrame(() => {
          this.delayedFlush = -1;
          this.flush();
        });
    }
    forceFlush() {
      if (this.delayedFlush >= 0) {
        this.view.win.cancelAnimationFrame(this.delayedFlush);
        this.delayedFlush = -1;
      }
      this.flush();
    }
    pendingRecords() {
      for (let mut of this.observer.takeRecords())
        this.queue.push(mut);
      return this.queue;
    }
    processRecords() {
      let records = this.pendingRecords();
      if (records.length)
        this.queue = [];
      let from2 = -1, to = -1, typeOver = false;
      for (let record of records) {
        let range = this.readMutation(record);
        if (!range)
          continue;
        if (range.typeOver)
          typeOver = true;
        if (from2 == -1) {
          ({ from: from2, to } = range);
        } else {
          from2 = Math.min(range.from, from2);
          to = Math.max(range.to, to);
        }
      }
      return { from: from2, to, typeOver };
    }
    readChange() {
      let { from: from2, to, typeOver } = this.processRecords();
      let newSel = this.selectionChanged && hasSelection$1(this.dom, this.selectionRange);
      if (from2 < 0 && !newSel)
        return null;
      if (from2 > -1)
        this.lastChange = Date.now();
      this.view.inputState.lastFocusTime = 0;
      this.selectionChanged = false;
      let change = new DOMChange$1(this.view, from2, to, typeOver);
      this.view.docView.domChanged = { newSel: change.newSel ? change.newSel.main : null };
      return change;
    }
    // Apply pending changes, if any
    flush(readSelection = true) {
      if (this.delayedFlush >= 0 || this.delayedAndroidKey)
        return false;
      if (readSelection)
        this.readSelectionRange();
      let domChange = this.readChange();
      if (!domChange) {
        this.view.requestMeasure();
        return false;
      }
      let startState = this.view.state;
      let handled = applyDOMChange$1(this.view, domChange);
      if (this.view.state == startState && (domChange.domChanged || domChange.newSel && !domChange.newSel.main.eq(this.view.state.selection.main)))
        this.view.update([]);
      return handled;
    }
    readMutation(rec) {
      let cView = this.view.docView.nearest(rec.target);
      if (!cView || cView.ignoreMutation(rec))
        return null;
      cView.markDirty(rec.type == "attributes");
      if (rec.type == "attributes")
        cView.flags |= 4;
      if (rec.type == "childList") {
        let childBefore = findChild$1(cView, rec.previousSibling || rec.target.previousSibling, -1);
        let childAfter = findChild$1(cView, rec.nextSibling || rec.target.nextSibling, 1);
        return {
          from: childBefore ? cView.posAfter(childBefore) : cView.posAtStart,
          to: childAfter ? cView.posBefore(childAfter) : cView.posAtEnd,
          typeOver: false
        };
      } else if (rec.type == "characterData") {
        return { from: cView.posAtStart, to: cView.posAtEnd, typeOver: rec.target.nodeValue == rec.oldValue };
      } else {
        return null;
      }
    }
    setWindow(win) {
      if (win != this.win) {
        this.removeWindowListeners(this.win);
        this.win = win;
        this.addWindowListeners(this.win);
      }
    }
    addWindowListeners(win) {
      win.addEventListener("resize", this.onResize);
      if (this.printQuery) {
        if (this.printQuery.addEventListener)
          this.printQuery.addEventListener("change", this.onPrint);
        else
          this.printQuery.addListener(this.onPrint);
      } else
        win.addEventListener("beforeprint", this.onPrint);
      win.addEventListener("scroll", this.onScroll);
      win.document.addEventListener("selectionchange", this.onSelectionChange);
    }
    removeWindowListeners(win) {
      win.removeEventListener("scroll", this.onScroll);
      win.removeEventListener("resize", this.onResize);
      if (this.printQuery) {
        if (this.printQuery.removeEventListener)
          this.printQuery.removeEventListener("change", this.onPrint);
        else
          this.printQuery.removeListener(this.onPrint);
      } else
        win.removeEventListener("beforeprint", this.onPrint);
      win.document.removeEventListener("selectionchange", this.onSelectionChange);
    }
    update(update) {
      if (this.editContext) {
        this.editContext.update(update);
        if (update.startState.facet(editable$1) != update.state.facet(editable$1))
          update.view.contentDOM.editContext = update.state.facet(editable$1) ? this.editContext.editContext : null;
      }
    }
    destroy() {
      var _a3, _b, _c;
      this.stop();
      (_a3 = this.intersection) === null || _a3 === void 0 ? void 0 : _a3.disconnect();
      (_b = this.gapIntersection) === null || _b === void 0 ? void 0 : _b.disconnect();
      (_c = this.resizeScroll) === null || _c === void 0 ? void 0 : _c.disconnect();
      for (let dom of this.scrollTargets)
        dom.removeEventListener("scroll", this.onScroll);
      this.removeWindowListeners(this.win);
      clearTimeout(this.parentCheck);
      clearTimeout(this.resizeTimeout);
      this.win.cancelAnimationFrame(this.delayedFlush);
      this.win.cancelAnimationFrame(this.flushingAndroidKey);
      if (this.editContext) {
        this.view.contentDOM.editContext = null;
        this.editContext.destroy();
      }
    }
  };
  function findChild$1(cView, dom, dir) {
    while (dom) {
      let curView = ContentView$1.get(dom);
      if (curView && curView.parent == cView)
        return curView;
      let parent = dom.parentNode;
      dom = parent != cView.dom ? parent : dir > 0 ? dom.nextSibling : dom.previousSibling;
    }
    return null;
  }
  function buildSelectionRangeFromRange$1(view, range) {
    let anchorNode = range.startContainer, anchorOffset = range.startOffset;
    let focusNode = range.endContainer, focusOffset = range.endOffset;
    let curAnchor = view.docView.domAtPos(view.state.selection.main.anchor);
    if (isEquivalentPosition$1(curAnchor.node, curAnchor.offset, focusNode, focusOffset))
      [anchorNode, anchorOffset, focusNode, focusOffset] = [focusNode, focusOffset, anchorNode, anchorOffset];
    return { anchorNode, anchorOffset, focusNode, focusOffset };
  }
  function safariSelectionRangeHack$1(view, selection) {
    if (selection.getComposedRanges) {
      let range = selection.getComposedRanges(view.root)[0];
      if (range)
        return buildSelectionRangeFromRange$1(view, range);
    }
    let found = null;
    function read2(event) {
      event.preventDefault();
      event.stopImmediatePropagation();
      found = event.getTargetRanges()[0];
    }
    view.contentDOM.addEventListener("beforeinput", read2, true);
    view.dom.ownerDocument.execCommand("indent");
    view.contentDOM.removeEventListener("beforeinput", read2, true);
    return found ? buildSelectionRangeFromRange$1(view, found) : null;
  }
  let EditContextManager$1 = class EditContextManager {
    constructor(view) {
      this.from = 0;
      this.to = 0;
      this.pendingContextChange = null;
      this.handlers = /* @__PURE__ */ Object.create(null);
      this.composing = null;
      this.resetRange(view.state);
      let context = this.editContext = new window.EditContext({
        text: view.state.doc.sliceString(this.from, this.to),
        selectionStart: this.toContextPos(Math.max(this.from, Math.min(this.to, view.state.selection.main.anchor))),
        selectionEnd: this.toContextPos(view.state.selection.main.head)
      });
      this.handlers.textupdate = (e) => {
        let { anchor } = view.state.selection.main;
        let from2 = this.toEditorPos(e.updateRangeStart), to = this.toEditorPos(e.updateRangeEnd);
        if (view.inputState.composing >= 0 && !this.composing)
          this.composing = { contextBase: e.updateRangeStart, editorBase: from2, drifted: false };
        let change = { from: from2, to, insert: Text.of(e.text.split("\n")) };
        if (change.from == this.from && anchor < this.from)
          change.from = anchor;
        else if (change.to == this.to && anchor > this.to)
          change.to = anchor;
        if (change.from == change.to && !change.insert.length)
          return;
        this.pendingContextChange = change;
        if (!view.state.readOnly) {
          let newLen = this.to - this.from + (change.to - change.from + change.insert.length);
          applyDOMChangeInner$1(view, change, EditorSelection.single(this.toEditorPos(e.selectionStart, newLen), this.toEditorPos(e.selectionEnd, newLen)));
        }
        if (this.pendingContextChange) {
          this.revertPending(view.state);
          this.setSelection(view.state);
        }
      };
      this.handlers.characterboundsupdate = (e) => {
        let rects = [], prev2 = null;
        for (let i2 = this.toEditorPos(e.rangeStart), end2 = this.toEditorPos(e.rangeEnd); i2 < end2; i2++) {
          let rect = view.coordsForChar(i2);
          prev2 = rect && new DOMRect(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top) || prev2 || new DOMRect();
          rects.push(prev2);
        }
        context.updateCharacterBounds(e.rangeStart, rects);
      };
      this.handlers.textformatupdate = (e) => {
        let deco = [];
        for (let format of e.getTextFormats()) {
          let lineStyle = format.underlineStyle, thickness = format.underlineThickness;
          if (lineStyle != "None" && thickness != "None") {
            let from2 = this.toEditorPos(format.rangeStart), to = this.toEditorPos(format.rangeEnd);
            if (from2 < to) {
              let style2 = `text-decoration: underline ${lineStyle == "Dashed" ? "dashed " : lineStyle == "Squiggle" ? "wavy " : ""}${thickness == "Thin" ? 1 : 2}px`;
              deco.push(Decoration$1.mark({ attributes: { style: style2 } }).range(from2, to));
            }
          }
        }
        view.dispatch({ effects: setEditContextFormatting$1.of(Decoration$1.set(deco)) });
      };
      this.handlers.compositionstart = () => {
        if (view.inputState.composing < 0) {
          view.inputState.composing = 0;
          view.inputState.compositionFirstChange = true;
        }
      };
      this.handlers.compositionend = () => {
        view.inputState.composing = -1;
        view.inputState.compositionFirstChange = null;
        if (this.composing) {
          let { drifted } = this.composing;
          this.composing = null;
          if (drifted)
            this.reset(view.state);
        }
      };
      for (let event in this.handlers)
        context.addEventListener(event, this.handlers[event]);
      this.measureReq = { read: (view2) => {
        this.editContext.updateControlBounds(view2.contentDOM.getBoundingClientRect());
        let sel = getSelection$2(view2.root);
        if (sel && sel.rangeCount)
          this.editContext.updateSelectionBounds(sel.getRangeAt(0).getBoundingClientRect());
      } };
    }
    applyEdits(update) {
      let off = 0, abort = false, pending = this.pendingContextChange;
      update.changes.iterChanges((fromA, toA, _fromB, _toB, insert2) => {
        if (abort)
          return;
        let dLen = insert2.length - (toA - fromA);
        if (pending && toA >= pending.to) {
          if (pending.from == fromA && pending.to == toA && pending.insert.eq(insert2)) {
            pending = this.pendingContextChange = null;
            off += dLen;
            this.to += dLen;
            return;
          } else {
            pending = null;
            this.revertPending(update.state);
          }
        }
        fromA += off;
        toA += off;
        if (toA <= this.from) {
          this.from += dLen;
          this.to += dLen;
        } else if (fromA < this.to) {
          if (fromA < this.from || toA > this.to || this.to - this.from + insert2.length > 3e4) {
            abort = true;
            return;
          }
          this.editContext.updateText(this.toContextPos(fromA), this.toContextPos(toA), insert2.toString());
          this.to += dLen;
        }
        off += dLen;
      });
      if (pending && !abort)
        this.revertPending(update.state);
      return !abort;
    }
    update(update) {
      let reverted = this.pendingContextChange;
      if (this.composing && (this.composing.drifted || update.transactions.some((tr2) => !tr2.isUserEvent("input.type") && tr2.changes.touchesRange(this.from, this.to)))) {
        this.composing.drifted = true;
        this.composing.editorBase = update.changes.mapPos(this.composing.editorBase);
      } else if (!this.applyEdits(update) || !this.rangeIsValid(update.state)) {
        this.pendingContextChange = null;
        this.reset(update.state);
      } else if (update.docChanged || update.selectionSet || reverted) {
        this.setSelection(update.state);
      }
      if (update.geometryChanged || update.docChanged || update.selectionSet)
        update.view.requestMeasure(this.measureReq);
    }
    resetRange(state) {
      let { head } = state.selection.main;
      this.from = Math.max(
        0,
        head - 1e4
        /* CxVp.Margin */
      );
      this.to = Math.min(
        state.doc.length,
        head + 1e4
        /* CxVp.Margin */
      );
    }
    reset(state) {
      this.resetRange(state);
      this.editContext.updateText(0, this.editContext.text.length, state.doc.sliceString(this.from, this.to));
      this.setSelection(state);
    }
    revertPending(state) {
      let pending = this.pendingContextChange;
      this.pendingContextChange = null;
      this.editContext.updateText(this.toContextPos(pending.from), this.toContextPos(pending.from + pending.insert.length), state.doc.sliceString(pending.from, pending.to));
    }
    setSelection(state) {
      let { main: main2 } = state.selection;
      let start2 = this.toContextPos(Math.max(this.from, Math.min(this.to, main2.anchor)));
      let end2 = this.toContextPos(main2.head);
      if (this.editContext.selectionStart != start2 || this.editContext.selectionEnd != end2)
        this.editContext.updateSelection(start2, end2);
    }
    rangeIsValid(state) {
      let { head } = state.selection.main;
      return !(this.from > 0 && head - this.from < 500 || this.to < state.doc.length && this.to - head < 500 || this.to - this.from > 1e4 * 3);
    }
    toEditorPos(contextPos, clipLen = this.to - this.from) {
      contextPos = Math.min(contextPos, clipLen);
      let c2 = this.composing;
      return c2 && c2.drifted ? c2.editorBase + (contextPos - c2.contextBase) : contextPos + this.from;
    }
    toContextPos(editorPos) {
      let c2 = this.composing;
      return c2 && c2.drifted ? c2.contextBase + (editorPos - c2.editorBase) : editorPos - this.from;
    }
    destroy() {
      for (let event in this.handlers)
        this.editContext.removeEventListener(event, this.handlers[event]);
    }
  };
  let EditorView$1 = class EditorView2 {
    /**
    The current editor state.
    */
    get state() {
      return this.viewState.state;
    }
    /**
    To be able to display large documents without consuming too much
    memory or overloading the browser, CodeMirror only draws the
    code that is visible (plus a margin around it) to the DOM. This
    property tells you the extent of the current drawn viewport, in
    document positions.
    */
    get viewport() {
      return this.viewState.viewport;
    }
    /**
    When there are, for example, large collapsed ranges in the
    viewport, its size can be a lot bigger than the actual visible
    content. Thus, if you are doing something like styling the
    content in the viewport, it is preferable to only do so for
    these ranges, which are the subset of the viewport that is
    actually drawn.
    */
    get visibleRanges() {
      return this.viewState.visibleRanges;
    }
    /**
    Returns false when the editor is entirely scrolled out of view
    or otherwise hidden.
    */
    get inView() {
      return this.viewState.inView;
    }
    /**
    Indicates whether the user is currently composing text via
    [IME](https://en.wikipedia.org/wiki/Input_method), and at least
    one change has been made in the current composition.
    */
    get composing() {
      return this.inputState.composing > 0;
    }
    /**
    Indicates whether the user is currently in composing state. Note
    that on some platforms, like Android, this will be the case a
    lot, since just putting the cursor on a word starts a
    composition there.
    */
    get compositionStarted() {
      return this.inputState.composing >= 0;
    }
    /**
    The document or shadow root that the view lives in.
    */
    get root() {
      return this._root;
    }
    /**
    @internal
    */
    get win() {
      return this.dom.ownerDocument.defaultView || window;
    }
    /**
    Construct a new view. You'll want to either provide a `parent`
    option, or put `view.dom` into your document after creating a
    view, so that the user can see the editor.
    */
    constructor(config2 = {}) {
      var _a3;
      this.plugins = [];
      this.pluginMap = /* @__PURE__ */ new Map();
      this.editorAttrs = {};
      this.contentAttrs = {};
      this.bidiCache = [];
      this.destroyed = false;
      this.updateState = 2;
      this.measureScheduled = -1;
      this.measureRequests = [];
      this.contentDOM = document.createElement("div");
      this.scrollDOM = document.createElement("div");
      this.scrollDOM.tabIndex = -1;
      this.scrollDOM.className = "cm-scroller";
      this.scrollDOM.appendChild(this.contentDOM);
      this.announceDOM = document.createElement("div");
      this.announceDOM.className = "cm-announced";
      this.announceDOM.setAttribute("aria-live", "polite");
      this.dom = document.createElement("div");
      this.dom.appendChild(this.announceDOM);
      this.dom.appendChild(this.scrollDOM);
      if (config2.parent)
        config2.parent.appendChild(this.dom);
      let { dispatch } = config2;
      this.dispatchTransactions = config2.dispatchTransactions || dispatch && ((trs) => trs.forEach((tr2) => dispatch(tr2, this))) || ((trs) => this.update(trs));
      this.dispatch = this.dispatch.bind(this);
      this._root = config2.root || getRoot$1(config2.parent) || document;
      this.viewState = new ViewState$1(config2.state || EditorState.create(config2));
      if (config2.scrollTo && config2.scrollTo.is(scrollIntoView$1))
        this.viewState.scrollTarget = config2.scrollTo.value.clip(this.viewState.state);
      this.plugins = this.state.facet(viewPlugin$1).map((spec) => new PluginInstance$1(spec));
      for (let plugin of this.plugins)
        plugin.update(this);
      this.observer = new DOMObserver$1(this);
      this.inputState = new InputState$1(this);
      this.inputState.ensureHandlers(this.plugins);
      this.docView = new DocView$1(this);
      this.mountStyles();
      this.updateAttrs();
      this.updateState = 0;
      this.requestMeasure();
      if ((_a3 = document.fonts) === null || _a3 === void 0 ? void 0 : _a3.ready)
        document.fonts.ready.then(() => this.requestMeasure());
    }
    dispatch(...input) {
      let trs = input.length == 1 && input[0] instanceof Transaction ? input : input.length == 1 && Array.isArray(input[0]) ? input[0] : [this.state.update(...input)];
      this.dispatchTransactions(trs, this);
    }
    /**
    Update the view for the given array of transactions. This will
    update the visible document and selection to match the state
    produced by the transactions, and notify view plugins of the
    change. You should usually call
    [`dispatch`](https://codemirror.net/6/docs/ref/#view.EditorView.dispatch) instead, which uses this
    as a primitive.
    */
    update(transactions) {
      if (this.updateState != 0)
        throw new Error("Calls to EditorView.update are not allowed while an update is in progress");
      let redrawn = false, attrsChanged = false, update;
      let state = this.state;
      for (let tr2 of transactions) {
        if (tr2.startState != state)
          throw new RangeError("Trying to update state with a transaction that doesn't start from the previous state.");
        state = tr2.state;
      }
      if (this.destroyed) {
        this.viewState.state = state;
        return;
      }
      let focus = this.hasFocus, focusFlag = 0, dispatchFocus = null;
      if (transactions.some((tr2) => tr2.annotation(isFocusChange$1))) {
        this.inputState.notifiedFocused = focus;
        focusFlag = 1;
      } else if (focus != this.inputState.notifiedFocused) {
        this.inputState.notifiedFocused = focus;
        dispatchFocus = focusChangeTransaction$1(state, focus);
        if (!dispatchFocus)
          focusFlag = 1;
      }
      let pendingKey = this.observer.delayedAndroidKey, domChange = null;
      if (pendingKey) {
        this.observer.clearDelayedAndroidKey();
        domChange = this.observer.readChange();
        if (domChange && !this.state.doc.eq(state.doc) || !this.state.selection.eq(state.selection))
          domChange = null;
      } else {
        this.observer.clear();
      }
      if (state.facet(EditorState.phrases) != this.state.facet(EditorState.phrases))
        return this.setState(state);
      update = ViewUpdate$1.create(this, state, transactions);
      update.flags |= focusFlag;
      let scrollTarget = this.viewState.scrollTarget;
      try {
        this.updateState = 2;
        for (let tr2 of transactions) {
          if (scrollTarget)
            scrollTarget = scrollTarget.map(tr2.changes);
          if (tr2.scrollIntoView) {
            let { main: main2 } = tr2.state.selection;
            scrollTarget = new ScrollTarget$1(main2.empty ? main2 : EditorSelection.cursor(main2.head, main2.head > main2.anchor ? -1 : 1));
          }
          for (let e of tr2.effects)
            if (e.is(scrollIntoView$1))
              scrollTarget = e.value.clip(this.state);
        }
        this.viewState.update(update, scrollTarget);
        this.bidiCache = CachedOrder$1.update(this.bidiCache, update.changes);
        if (!update.empty) {
          this.updatePlugins(update);
          this.inputState.update(update);
        }
        redrawn = this.docView.update(update);
        if (this.state.facet(styleModule$1) != this.styleModules)
          this.mountStyles();
        attrsChanged = this.updateAttrs();
        this.showAnnouncements(transactions);
        this.docView.updateSelection(redrawn, transactions.some((tr2) => tr2.isUserEvent("select.pointer")));
      } finally {
        this.updateState = 0;
      }
      if (update.startState.facet(theme$2) != update.state.facet(theme$2))
        this.viewState.mustMeasureContent = true;
      if (redrawn || attrsChanged || scrollTarget || this.viewState.mustEnforceCursorAssoc || this.viewState.mustMeasureContent)
        this.requestMeasure();
      if (redrawn)
        this.docViewUpdate();
      if (!update.empty)
        for (let listener of this.state.facet(updateListener$1)) {
          try {
            listener(update);
          } catch (e) {
            logException$1(this.state, e, "update listener");
          }
        }
      if (dispatchFocus || domChange)
        Promise.resolve().then(() => {
          if (dispatchFocus && this.state == dispatchFocus.startState)
            this.dispatch(dispatchFocus);
          if (domChange) {
            if (!applyDOMChange$1(this, domChange) && pendingKey.force)
              dispatchKey$1(this.contentDOM, pendingKey.key, pendingKey.keyCode);
          }
        });
    }
    /**
    Reset the view to the given state. (This will cause the entire
    document to be redrawn and all view plugins to be reinitialized,
    so you should probably only use it when the new state isn't
    derived from the old state. Otherwise, use
    [`dispatch`](https://codemirror.net/6/docs/ref/#view.EditorView.dispatch) instead.)
    */
    setState(newState) {
      if (this.updateState != 0)
        throw new Error("Calls to EditorView.setState are not allowed while an update is in progress");
      if (this.destroyed) {
        this.viewState.state = newState;
        return;
      }
      this.updateState = 2;
      let hadFocus = this.hasFocus;
      try {
        for (let plugin of this.plugins)
          plugin.destroy(this);
        this.viewState = new ViewState$1(newState);
        this.plugins = newState.facet(viewPlugin$1).map((spec) => new PluginInstance$1(spec));
        this.pluginMap.clear();
        for (let plugin of this.plugins)
          plugin.update(this);
        this.docView.destroy();
        this.docView = new DocView$1(this);
        this.inputState.ensureHandlers(this.plugins);
        this.mountStyles();
        this.updateAttrs();
        this.bidiCache = [];
      } finally {
        this.updateState = 0;
      }
      if (hadFocus)
        this.focus();
      this.requestMeasure();
    }
    updatePlugins(update) {
      let prevSpecs = update.startState.facet(viewPlugin$1), specs = update.state.facet(viewPlugin$1);
      if (prevSpecs != specs) {
        let newPlugins = [];
        for (let spec of specs) {
          let found = prevSpecs.indexOf(spec);
          if (found < 0) {
            newPlugins.push(new PluginInstance$1(spec));
          } else {
            let plugin = this.plugins[found];
            plugin.mustUpdate = update;
            newPlugins.push(plugin);
          }
        }
        for (let plugin of this.plugins)
          if (plugin.mustUpdate != update)
            plugin.destroy(this);
        this.plugins = newPlugins;
        this.pluginMap.clear();
      } else {
        for (let p2 of this.plugins)
          p2.mustUpdate = update;
      }
      for (let i2 = 0; i2 < this.plugins.length; i2++)
        this.plugins[i2].update(this);
      if (prevSpecs != specs)
        this.inputState.ensureHandlers(this.plugins);
    }
    docViewUpdate() {
      for (let plugin of this.plugins) {
        let val = plugin.value;
        if (val && val.docViewUpdate) {
          try {
            val.docViewUpdate(this);
          } catch (e) {
            logException$1(this.state, e, "doc view update listener");
          }
        }
      }
    }
    /**
    @internal
    */
    measure(flush = true) {
      if (this.destroyed)
        return;
      if (this.measureScheduled > -1)
        this.win.cancelAnimationFrame(this.measureScheduled);
      if (this.observer.delayedAndroidKey) {
        this.measureScheduled = -1;
        this.requestMeasure();
        return;
      }
      this.measureScheduled = 0;
      if (flush)
        this.observer.forceFlush();
      let updated = null;
      let sDOM = this.scrollDOM, scrollTop = sDOM.scrollTop * this.scaleY;
      let { scrollAnchorPos, scrollAnchorHeight } = this.viewState;
      if (Math.abs(scrollTop - this.viewState.scrollTop) > 1)
        scrollAnchorHeight = -1;
      this.viewState.scrollAnchorHeight = -1;
      try {
        for (let i2 = 0; ; i2++) {
          if (scrollAnchorHeight < 0) {
            if (isScrolledToBottom$1(sDOM)) {
              scrollAnchorPos = -1;
              scrollAnchorHeight = this.viewState.heightMap.height;
            } else {
              let block = this.viewState.scrollAnchorAt(scrollTop);
              scrollAnchorPos = block.from;
              scrollAnchorHeight = block.top;
            }
          }
          this.updateState = 1;
          let changed = this.viewState.measure(this);
          if (!changed && !this.measureRequests.length && this.viewState.scrollTarget == null)
            break;
          if (i2 > 5) {
            console.warn(this.measureRequests.length ? "Measure loop restarted more than 5 times" : "Viewport failed to stabilize");
            break;
          }
          let measuring = [];
          if (!(changed & 4))
            [this.measureRequests, measuring] = [measuring, this.measureRequests];
          let measured = measuring.map((m2) => {
            try {
              return m2.read(this);
            } catch (e) {
              logException$1(this.state, e);
              return BadMeasure$1;
            }
          });
          let update = ViewUpdate$1.create(this, this.state, []), redrawn = false;
          update.flags |= changed;
          if (!updated)
            updated = update;
          else
            updated.flags |= changed;
          this.updateState = 2;
          if (!update.empty) {
            this.updatePlugins(update);
            this.inputState.update(update);
            this.updateAttrs();
            redrawn = this.docView.update(update);
            if (redrawn)
              this.docViewUpdate();
          }
          for (let i3 = 0; i3 < measuring.length; i3++)
            if (measured[i3] != BadMeasure$1) {
              try {
                let m2 = measuring[i3];
                if (m2.write)
                  m2.write(measured[i3], this);
              } catch (e) {
                logException$1(this.state, e);
              }
            }
          if (redrawn)
            this.docView.updateSelection(true);
          if (!update.viewportChanged && this.measureRequests.length == 0) {
            if (this.viewState.editorHeight) {
              if (this.viewState.scrollTarget) {
                this.docView.scrollIntoView(this.viewState.scrollTarget);
                this.viewState.scrollTarget = null;
                scrollAnchorHeight = -1;
                continue;
              } else {
                let newAnchorHeight = scrollAnchorPos < 0 ? this.viewState.heightMap.height : this.viewState.lineBlockAt(scrollAnchorPos).top;
                let diff = newAnchorHeight - scrollAnchorHeight;
                if (diff > 1 || diff < -1) {
                  scrollTop = scrollTop + diff;
                  sDOM.scrollTop = scrollTop / this.scaleY;
                  scrollAnchorHeight = -1;
                  continue;
                }
              }
            }
            break;
          }
        }
      } finally {
        this.updateState = 0;
        this.measureScheduled = -1;
      }
      if (updated && !updated.empty)
        for (let listener of this.state.facet(updateListener$1))
          listener(updated);
    }
    /**
    Get the CSS classes for the currently active editor themes.
    */
    get themeClasses() {
      return baseThemeID$1 + " " + (this.state.facet(darkTheme$1) ? baseDarkID$1 : baseLightID$1) + " " + this.state.facet(theme$2);
    }
    updateAttrs() {
      let editorAttrs = attrsFromFacet$1(this, editorAttributes$1, {
        class: "cm-editor" + (this.hasFocus ? " cm-focused " : " ") + this.themeClasses
      });
      let contentAttrs = {
        spellcheck: "false",
        autocorrect: "off",
        autocapitalize: "off",
        writingsuggestions: "false",
        translate: "no",
        contenteditable: !this.state.facet(editable$1) ? "false" : "true",
        class: "cm-content",
        style: `${browser$1.tabSize}: ${this.state.tabSize}`,
        role: "textbox",
        "aria-multiline": "true"
      };
      if (this.state.readOnly)
        contentAttrs["aria-readonly"] = "true";
      attrsFromFacet$1(this, contentAttributes$1, contentAttrs);
      let changed = this.observer.ignore(() => {
        let changedContent = updateAttrs$1(this.contentDOM, this.contentAttrs, contentAttrs);
        let changedEditor = updateAttrs$1(this.dom, this.editorAttrs, editorAttrs);
        return changedContent || changedEditor;
      });
      this.editorAttrs = editorAttrs;
      this.contentAttrs = contentAttrs;
      return changed;
    }
    showAnnouncements(trs) {
      let first = true;
      for (let tr2 of trs)
        for (let effect2 of tr2.effects)
          if (effect2.is(EditorView2.announce)) {
            if (first)
              this.announceDOM.textContent = "";
            first = false;
            let div = this.announceDOM.appendChild(document.createElement("div"));
            div.textContent = effect2.value;
          }
    }
    mountStyles() {
      this.styleModules = this.state.facet(styleModule$1);
      let nonce = this.state.facet(EditorView2.cspNonce);
      StyleModule.mount(this.root, this.styleModules.concat(baseTheme$1$1).reverse(), nonce ? { nonce } : void 0);
    }
    readMeasured() {
      if (this.updateState == 2)
        throw new Error("Reading the editor layout isn't allowed during an update");
      if (this.updateState == 0 && this.measureScheduled > -1)
        this.measure(false);
    }
    /**
    Schedule a layout measurement, optionally providing callbacks to
    do custom DOM measuring followed by a DOM write phase. Using
    this is preferable reading DOM layout directly from, for
    example, an event handler, because it'll make sure measuring and
    drawing done by other components is synchronized, avoiding
    unnecessary DOM layout computations.
    */
    requestMeasure(request) {
      if (this.measureScheduled < 0)
        this.measureScheduled = this.win.requestAnimationFrame(() => this.measure());
      if (request) {
        if (this.measureRequests.indexOf(request) > -1)
          return;
        if (request.key != null)
          for (let i2 = 0; i2 < this.measureRequests.length; i2++) {
            if (this.measureRequests[i2].key === request.key) {
              this.measureRequests[i2] = request;
              return;
            }
          }
        this.measureRequests.push(request);
      }
    }
    /**
    Get the value of a specific plugin, if present. Note that
    plugins that crash can be dropped from a view, so even when you
    know you registered a given plugin, it is recommended to check
    the return value of this method.
    */
    plugin(plugin) {
      let known = this.pluginMap.get(plugin);
      if (known === void 0 || known && known.spec != plugin)
        this.pluginMap.set(plugin, known = this.plugins.find((p2) => p2.spec == plugin) || null);
      return known && known.update(this).value;
    }
    /**
    The top position of the document, in screen coordinates. This
    may be negative when the editor is scrolled down. Points
    directly to the top of the first line, not above the padding.
    */
    get documentTop() {
      return this.contentDOM.getBoundingClientRect().top + this.viewState.paddingTop;
    }
    /**
    Reports the padding above and below the document.
    */
    get documentPadding() {
      return { top: this.viewState.paddingTop, bottom: this.viewState.paddingBottom };
    }
    /**
    If the editor is transformed with CSS, this provides the scale
    along the X axis. Otherwise, it will just be 1. Note that
    transforms other than translation and scaling are not supported.
    */
    get scaleX() {
      return this.viewState.scaleX;
    }
    /**
    Provide the CSS transformed scale along the Y axis.
    */
    get scaleY() {
      return this.viewState.scaleY;
    }
    /**
    Find the text line or block widget at the given vertical
    position (which is interpreted as relative to the [top of the
    document](https://codemirror.net/6/docs/ref/#view.EditorView.documentTop)).
    */
    elementAtHeight(height2) {
      this.readMeasured();
      return this.viewState.elementAtHeight(height2);
    }
    /**
    Find the line block (see
    [`lineBlockAt`](https://codemirror.net/6/docs/ref/#view.EditorView.lineBlockAt) at the given
    height, again interpreted relative to the [top of the
    document](https://codemirror.net/6/docs/ref/#view.EditorView.documentTop).
    */
    lineBlockAtHeight(height2) {
      this.readMeasured();
      return this.viewState.lineBlockAtHeight(height2);
    }
    /**
    Get the extent and vertical position of all [line
    blocks](https://codemirror.net/6/docs/ref/#view.EditorView.lineBlockAt) in the viewport. Positions
    are relative to the [top of the
    document](https://codemirror.net/6/docs/ref/#view.EditorView.documentTop);
    */
    get viewportLineBlocks() {
      return this.viewState.viewportLines;
    }
    /**
    Find the line block around the given document position. A line
    block is a range delimited on both sides by either a
    non-[hidden](https://codemirror.net/6/docs/ref/#view.Decoration^replace) line break, or the
    start/end of the document. It will usually just hold a line of
    text, but may be broken into multiple textblocks by block
    widgets.
    */
    lineBlockAt(pos) {
      return this.viewState.lineBlockAt(pos);
    }
    /**
    The editor's total content height.
    */
    get contentHeight() {
      return this.viewState.contentHeight;
    }
    /**
    Move a cursor position by [grapheme
    cluster](https://codemirror.net/6/docs/ref/#state.findClusterBreak). `forward` determines whether
    the motion is away from the line start, or towards it. In
    bidirectional text, the line is traversed in visual order, using
    the editor's [text direction](https://codemirror.net/6/docs/ref/#view.EditorView.textDirection).
    When the start position was the last one on the line, the
    returned position will be across the line break. If there is no
    further line, the original position is returned.
    
    By default, this method moves over a single cluster. The
    optional `by` argument can be used to move across more. It will
    be called with the first cluster as argument, and should return
    a predicate that determines, for each subsequent cluster,
    whether it should also be moved over.
    */
    moveByChar(start2, forward, by) {
      return skipAtoms$1(this, start2, moveByChar$1(this, start2, forward, by));
    }
    /**
    Move a cursor position across the next group of either
    [letters](https://codemirror.net/6/docs/ref/#state.EditorState.charCategorizer) or non-letter
    non-whitespace characters.
    */
    moveByGroup(start2, forward) {
      return skipAtoms$1(this, start2, moveByChar$1(this, start2, forward, (initial) => byGroup$1(this, start2.head, initial)));
    }
    /**
    Get the cursor position visually at the start or end of a line.
    Note that this may differ from the _logical_ position at its
    start or end (which is simply at `line.from`/`line.to`) if text
    at the start or end goes against the line's base text direction.
    */
    visualLineSide(line2, end2) {
      let order2 = this.bidiSpans(line2), dir = this.textDirectionAt(line2.from);
      let span = order2[end2 ? order2.length - 1 : 0];
      return EditorSelection.cursor(span.side(end2, dir) + line2.from, span.forward(!end2, dir) ? 1 : -1);
    }
    /**
    Move to the next line boundary in the given direction. If
    `includeWrap` is true, line wrapping is on, and there is a
    further wrap point on the current line, the wrap point will be
    returned. Otherwise this function will return the start or end
    of the line.
    */
    moveToLineBoundary(start2, forward, includeWrap = true) {
      return moveToLineBoundary$1(this, start2, forward, includeWrap);
    }
    /**
    Move a cursor position vertically. When `distance` isn't given,
    it defaults to moving to the next line (including wrapped
    lines). Otherwise, `distance` should provide a positive distance
    in pixels.
    
    When `start` has a
    [`goalColumn`](https://codemirror.net/6/docs/ref/#state.SelectionRange.goalColumn), the vertical
    motion will use that as a target horizontal position. Otherwise,
    the cursor's own horizontal position is used. The returned
    cursor will have its goal column set to whichever column was
    used.
    */
    moveVertically(start2, forward, distance) {
      return skipAtoms$1(this, start2, moveVertically$1(this, start2, forward, distance));
    }
    /**
    Find the DOM parent node and offset (child offset if `node` is
    an element, character offset when it is a text node) at the
    given document position.
    
    Note that for positions that aren't currently in
    `visibleRanges`, the resulting DOM position isn't necessarily
    meaningful (it may just point before or after a placeholder
    element).
    */
    domAtPos(pos) {
      return this.docView.domAtPos(pos);
    }
    /**
    Find the document position at the given DOM node. Can be useful
    for associating positions with DOM events. Will raise an error
    when `node` isn't part of the editor content.
    */
    posAtDOM(node2, offset2 = 0) {
      return this.docView.posFromDOM(node2, offset2);
    }
    posAtCoords(coords, precise = true) {
      this.readMeasured();
      return posAtCoords$1(this, coords, precise);
    }
    /**
    Get the screen coordinates at the given document position.
    `side` determines whether the coordinates are based on the
    element before (-1) or after (1) the position (if no element is
    available on the given side, the method will transparently use
    another strategy to get reasonable coordinates).
    */
    coordsAtPos(pos, side = 1) {
      this.readMeasured();
      let rect = this.docView.coordsAt(pos, side);
      if (!rect || rect.left == rect.right)
        return rect;
      let line2 = this.state.doc.lineAt(pos), order2 = this.bidiSpans(line2);
      let span = order2[BidiSpan$1.find(order2, pos - line2.from, -1, side)];
      return flattenRect$1(rect, span.dir == Direction$1.LTR == side > 0);
    }
    /**
    Return the rectangle around a given character. If `pos` does not
    point in front of a character that is in the viewport and
    rendered (i.e. not replaced, not a line break), this will return
    null. For space characters that are a line wrap point, this will
    return the position before the line break.
    */
    coordsForChar(pos) {
      this.readMeasured();
      return this.docView.coordsForChar(pos);
    }
    /**
    The default width of a character in the editor. May not
    accurately reflect the width of all characters (given variable
    width fonts or styling of invididual ranges).
    */
    get defaultCharacterWidth() {
      return this.viewState.heightOracle.charWidth;
    }
    /**
    The default height of a line in the editor. May not be accurate
    for all lines.
    */
    get defaultLineHeight() {
      return this.viewState.heightOracle.lineHeight;
    }
    /**
    The text direction
    ([`direction`](https://developer.mozilla.org/en-US/docs/Web/CSS/direction)
    CSS property) of the editor's content element.
    */
    get textDirection() {
      return this.viewState.defaultTextDirection;
    }
    /**
    Find the text direction of the block at the given position, as
    assigned by CSS. If
    [`perLineTextDirection`](https://codemirror.net/6/docs/ref/#view.EditorView^perLineTextDirection)
    isn't enabled, or the given position is outside of the viewport,
    this will always return the same as
    [`textDirection`](https://codemirror.net/6/docs/ref/#view.EditorView.textDirection). Note that
    this may trigger a DOM layout.
    */
    textDirectionAt(pos) {
      let perLine = this.state.facet(perLineTextDirection$1);
      if (!perLine || pos < this.viewport.from || pos > this.viewport.to)
        return this.textDirection;
      this.readMeasured();
      return this.docView.textDirectionAt(pos);
    }
    /**
    Whether this editor [wraps lines](https://codemirror.net/6/docs/ref/#view.EditorView.lineWrapping)
    (as determined by the
    [`white-space`](https://developer.mozilla.org/en-US/docs/Web/CSS/white-space)
    CSS property of its content element).
    */
    get lineWrapping() {
      return this.viewState.heightOracle.lineWrapping;
    }
    /**
    Returns the bidirectional text structure of the given line
    (which should be in the current document) as an array of span
    objects. The order of these spans matches the [text
    direction](https://codemirror.net/6/docs/ref/#view.EditorView.textDirection)—if that is
    left-to-right, the leftmost spans come first, otherwise the
    rightmost spans come first.
    */
    bidiSpans(line2) {
      if (line2.length > MaxBidiLine$1)
        return trivialOrder$1(line2.length);
      let dir = this.textDirectionAt(line2.from), isolates;
      for (let entry of this.bidiCache) {
        if (entry.from == line2.from && entry.dir == dir && (entry.fresh || isolatesEq$1(entry.isolates, isolates = getIsolatedRanges$1(this, line2))))
          return entry.order;
      }
      if (!isolates)
        isolates = getIsolatedRanges$1(this, line2);
      let order2 = computeOrder$1(line2.text, dir, isolates);
      this.bidiCache.push(new CachedOrder$1(line2.from, line2.to, dir, isolates, true, order2));
      return order2;
    }
    /**
    Check whether the editor has focus.
    */
    get hasFocus() {
      var _a3;
      return (this.dom.ownerDocument.hasFocus() || browser$1.safari && ((_a3 = this.inputState) === null || _a3 === void 0 ? void 0 : _a3.lastContextMenu) > Date.now() - 3e4) && this.root.activeElement == this.contentDOM;
    }
    /**
    Put focus on the editor.
    */
    focus() {
      this.observer.ignore(() => {
        focusPreventScroll$1(this.contentDOM);
        this.docView.updateSelection();
      });
    }
    /**
    Update the [root](https://codemirror.net/6/docs/ref/##view.EditorViewConfig.root) in which the editor lives. This is only
    necessary when moving the editor's existing DOM to a new window or shadow root.
    */
    setRoot(root) {
      if (this._root != root) {
        this._root = root;
        this.observer.setWindow((root.nodeType == 9 ? root : root.ownerDocument).defaultView || window);
        this.mountStyles();
      }
    }
    /**
    Clean up this editor view, removing its element from the
    document, unregistering event handlers, and notifying
    plugins. The view instance can no longer be used after
    calling this.
    */
    destroy() {
      if (this.root.activeElement == this.contentDOM)
        this.contentDOM.blur();
      for (let plugin of this.plugins)
        plugin.destroy(this);
      this.plugins = [];
      this.inputState.destroy();
      this.docView.destroy();
      this.dom.remove();
      this.observer.destroy();
      if (this.measureScheduled > -1)
        this.win.cancelAnimationFrame(this.measureScheduled);
      this.destroyed = true;
    }
    /**
    Returns an effect that can be
    [added](https://codemirror.net/6/docs/ref/#state.TransactionSpec.effects) to a transaction to
    cause it to scroll the given position or range into view.
    */
    static scrollIntoView(pos, options = {}) {
      return scrollIntoView$1.of(new ScrollTarget$1(typeof pos == "number" ? EditorSelection.cursor(pos) : pos, options.y, options.x, options.yMargin, options.xMargin));
    }
    /**
    Return an effect that resets the editor to its current (at the
    time this method was called) scroll position. Note that this
    only affects the editor's own scrollable element, not parents.
    See also
    [`EditorViewConfig.scrollTo`](https://codemirror.net/6/docs/ref/#view.EditorViewConfig.scrollTo).
    
    The effect should be used with a document identical to the one
    it was created for. Failing to do so is not an error, but may
    not scroll to the expected position. You can
    [map](https://codemirror.net/6/docs/ref/#state.StateEffect.map) the effect to account for changes.
    */
    scrollSnapshot() {
      let { scrollTop, scrollLeft } = this.scrollDOM;
      let ref = this.viewState.scrollAnchorAt(scrollTop);
      return scrollIntoView$1.of(new ScrollTarget$1(EditorSelection.cursor(ref.from), "start", "start", ref.top - scrollTop, scrollLeft, true));
    }
    /**
    Enable or disable tab-focus mode, which disables key bindings
    for Tab and Shift-Tab, letting the browser's default
    focus-changing behavior go through instead. This is useful to
    prevent trapping keyboard users in your editor.
    
    Without argument, this toggles the mode. With a boolean, it
    enables (true) or disables it (false). Given a number, it
    temporarily enables the mode until that number of milliseconds
    have passed or another non-Tab key is pressed.
    */
    setTabFocusMode(to) {
      if (to == null)
        this.inputState.tabFocusMode = this.inputState.tabFocusMode < 0 ? 0 : -1;
      else if (typeof to == "boolean")
        this.inputState.tabFocusMode = to ? 0 : -1;
      else if (this.inputState.tabFocusMode != 0)
        this.inputState.tabFocusMode = Date.now() + to;
    }
    /**
    Returns an extension that can be used to add DOM event handlers.
    The value should be an object mapping event names to handler
    functions. For any given event, such functions are ordered by
    extension precedence, and the first handler to return true will
    be assumed to have handled that event, and no other handlers or
    built-in behavior will be activated for it. These are registered
    on the [content element](https://codemirror.net/6/docs/ref/#view.EditorView.contentDOM), except
    for `scroll` handlers, which will be called any time the
    editor's [scroll element](https://codemirror.net/6/docs/ref/#view.EditorView.scrollDOM) or one of
    its parent nodes is scrolled.
    */
    static domEventHandlers(handlers2) {
      return ViewPlugin$1.define(() => ({}), { eventHandlers: handlers2 });
    }
    /**
    Create an extension that registers DOM event observers. Contrary
    to event [handlers](https://codemirror.net/6/docs/ref/#view.EditorView^domEventHandlers),
    observers can't be prevented from running by a higher-precedence
    handler returning true. They also don't prevent other handlers
    and observers from running when they return true, and should not
    call `preventDefault`.
    */
    static domEventObservers(observers2) {
      return ViewPlugin$1.define(() => ({}), { eventObservers: observers2 });
    }
    /**
    Create a theme extension. The first argument can be a
    [`style-mod`](https://github.com/marijnh/style-mod#documentation)
    style spec providing the styles for the theme. These will be
    prefixed with a generated class for the style.
    
    Because the selectors will be prefixed with a scope class, rule
    that directly match the editor's [wrapper
    element](https://codemirror.net/6/docs/ref/#view.EditorView.dom)—to which the scope class will be
    added—need to be explicitly differentiated by adding an `&` to
    the selector for that element—for example
    `&.cm-focused`.
    
    When `dark` is set to true, the theme will be marked as dark,
    which will cause the `&dark` rules from [base
    themes](https://codemirror.net/6/docs/ref/#view.EditorView^baseTheme) to be used (as opposed to
    `&light` when a light theme is active).
    */
    static theme(spec, options) {
      let prefix2 = StyleModule.newName();
      let result = [theme$2.of(prefix2), styleModule$1.of(buildTheme$1(`.${prefix2}`, spec))];
      if (options && options.dark)
        result.push(darkTheme$1.of(true));
      return result;
    }
    /**
    Create an extension that adds styles to the base theme. Like
    with [`theme`](https://codemirror.net/6/docs/ref/#view.EditorView^theme), use `&` to indicate the
    place of the editor wrapper element when directly targeting
    that. You can also use `&dark` or `&light` instead to only
    target editors with a dark or light theme.
    */
    static baseTheme(spec) {
      return Prec.lowest(styleModule$1.of(buildTheme$1("." + baseThemeID$1, spec, lightDarkIDs$1)));
    }
    /**
    Retrieve an editor view instance from the view's DOM
    representation.
    */
    static findFromDOM(dom) {
      var _a3;
      let content2 = dom.querySelector(".cm-content");
      let cView = content2 && ContentView$1.get(content2) || ContentView$1.get(dom);
      return ((_a3 = cView === null || cView === void 0 ? void 0 : cView.rootView) === null || _a3 === void 0 ? void 0 : _a3.view) || null;
    }
  };
  EditorView$1.styleModule = styleModule$1;
  EditorView$1.inputHandler = inputHandler$1;
  EditorView$1.clipboardInputFilter = clipboardInputFilter$1;
  EditorView$1.clipboardOutputFilter = clipboardOutputFilter$1;
  EditorView$1.scrollHandler = scrollHandler$1;
  EditorView$1.focusChangeEffect = focusChangeEffect$1;
  EditorView$1.perLineTextDirection = perLineTextDirection$1;
  EditorView$1.exceptionSink = exceptionSink$1;
  EditorView$1.updateListener = updateListener$1;
  EditorView$1.editable = editable$1;
  EditorView$1.mouseSelectionStyle = mouseSelectionStyle$1;
  EditorView$1.dragMovesSelection = dragMovesSelection$1$1;
  EditorView$1.clickAddsSelectionRange = clickAddsSelectionRange$1;
  EditorView$1.decorations = decorations$1;
  EditorView$1.outerDecorations = outerDecorations$1;
  EditorView$1.atomicRanges = atomicRanges$1;
  EditorView$1.bidiIsolatedRanges = bidiIsolatedRanges$1;
  EditorView$1.scrollMargins = scrollMargins$1;
  EditorView$1.darkTheme = darkTheme$1;
  EditorView$1.cspNonce = /* @__PURE__ */ Facet.define({ combine: (values2) => values2.length ? values2[0] : "" });
  EditorView$1.contentAttributes = contentAttributes$1;
  EditorView$1.editorAttributes = editorAttributes$1;
  EditorView$1.lineWrapping = /* @__PURE__ */ EditorView$1.contentAttributes.of({ "class": "cm-lineWrapping" });
  EditorView$1.announce = /* @__PURE__ */ StateEffect.define();
  const MaxBidiLine$1 = 4096;
  const BadMeasure$1 = {};
  let CachedOrder$1 = class CachedOrder2 {
    constructor(from2, to, dir, isolates, fresh, order2) {
      this.from = from2;
      this.to = to;
      this.dir = dir;
      this.isolates = isolates;
      this.fresh = fresh;
      this.order = order2;
    }
    static update(cache2, changes) {
      if (changes.empty && !cache2.some((c2) => c2.fresh))
        return cache2;
      let result = [], lastDir = cache2.length ? cache2[cache2.length - 1].dir : Direction$1.LTR;
      for (let i2 = Math.max(0, cache2.length - 10); i2 < cache2.length; i2++) {
        let entry = cache2[i2];
        if (entry.dir == lastDir && !changes.touchesRange(entry.from, entry.to))
          result.push(new CachedOrder2(changes.mapPos(entry.from, 1), changes.mapPos(entry.to, -1), entry.dir, entry.isolates, false, entry.order));
      }
      return result;
    }
  };
  function attrsFromFacet$1(view, facet, base2) {
    for (let sources = view.state.facet(facet), i2 = sources.length - 1; i2 >= 0; i2--) {
      let source = sources[i2], value = typeof source == "function" ? source(view) : source;
      if (value)
        combineAttrs$1(value, base2);
    }
    return base2;
  }
  const currentPlatform$1 = browser$1.mac ? "mac" : browser$1.windows ? "win" : browser$1.linux ? "linux" : "key";
  function normalizeKeyName$1(name2, platform) {
    const parts = name2.split(/-(?!$)/);
    let result = parts[parts.length - 1];
    if (result == "Space")
      result = " ";
    let alt, ctrl, shift2, meta2;
    for (let i2 = 0; i2 < parts.length - 1; ++i2) {
      const mod = parts[i2];
      if (/^(cmd|meta|m)$/i.test(mod))
        meta2 = true;
      else if (/^a(lt)?$/i.test(mod))
        alt = true;
      else if (/^(c|ctrl|control)$/i.test(mod))
        ctrl = true;
      else if (/^s(hift)?$/i.test(mod))
        shift2 = true;
      else if (/^mod$/i.test(mod)) {
        if (platform == "mac")
          meta2 = true;
        else
          ctrl = true;
      } else
        throw new Error("Unrecognized modifier name: " + mod);
    }
    if (alt)
      result = "Alt-" + result;
    if (ctrl)
      result = "Ctrl-" + result;
    if (meta2)
      result = "Meta-" + result;
    if (shift2)
      result = "Shift-" + result;
    return result;
  }
  function modifiers$1(name2, event, shift2) {
    if (event.altKey)
      name2 = "Alt-" + name2;
    if (event.ctrlKey)
      name2 = "Ctrl-" + name2;
    if (event.metaKey)
      name2 = "Meta-" + name2;
    if (shift2 !== false && event.shiftKey)
      name2 = "Shift-" + name2;
    return name2;
  }
  const handleKeyEvents$1 = /* @__PURE__ */ Prec.default(/* @__PURE__ */ EditorView$1.domEventHandlers({
    keydown(event, view) {
      return runHandlers$1(getKeymap$1(view.state), event, view, "editor");
    }
  }));
  const keymap$1 = /* @__PURE__ */ Facet.define({ enables: handleKeyEvents$1 });
  const Keymaps$1 = /* @__PURE__ */ new WeakMap();
  function getKeymap$1(state) {
    let bindings = state.facet(keymap$1);
    let map = Keymaps$1.get(bindings);
    if (!map)
      Keymaps$1.set(bindings, map = buildKeymap$1(bindings.reduce((a2, b) => a2.concat(b), [])));
    return map;
  }
  let storedPrefix$1 = null;
  const PrefixTimeout$1 = 4e3;
  function buildKeymap$1(bindings, platform = currentPlatform$1) {
    let bound = /* @__PURE__ */ Object.create(null);
    let isPrefix = /* @__PURE__ */ Object.create(null);
    let checkPrefix = (name2, is2) => {
      let current = isPrefix[name2];
      if (current == null)
        isPrefix[name2] = is2;
      else if (current != is2)
        throw new Error("Key binding " + name2 + " is used both as a regular binding and as a multi-stroke prefix");
    };
    let add = (scope, key, command2, preventDefault, stopPropagation) => {
      var _a3, _b;
      let scopeObj = bound[scope] || (bound[scope] = /* @__PURE__ */ Object.create(null));
      let parts = key.split(/ (?!$)/).map((k) => normalizeKeyName$1(k, platform));
      for (let i2 = 1; i2 < parts.length; i2++) {
        let prefix2 = parts.slice(0, i2).join(" ");
        checkPrefix(prefix2, true);
        if (!scopeObj[prefix2])
          scopeObj[prefix2] = {
            preventDefault: true,
            stopPropagation: false,
            run: [(view) => {
              let ourObj = storedPrefix$1 = { view, prefix: prefix2, scope };
              setTimeout(() => {
                if (storedPrefix$1 == ourObj)
                  storedPrefix$1 = null;
              }, PrefixTimeout$1);
              return true;
            }]
          };
      }
      let full = parts.join(" ");
      checkPrefix(full, false);
      let binding = scopeObj[full] || (scopeObj[full] = {
        preventDefault: false,
        stopPropagation: false,
        run: ((_b = (_a3 = scopeObj._any) === null || _a3 === void 0 ? void 0 : _a3.run) === null || _b === void 0 ? void 0 : _b.slice()) || []
      });
      if (command2)
        binding.run.push(command2);
      if (preventDefault)
        binding.preventDefault = true;
      if (stopPropagation)
        binding.stopPropagation = true;
    };
    for (let b of bindings) {
      let scopes = b.scope ? b.scope.split(" ") : ["editor"];
      if (b.any)
        for (let scope of scopes) {
          let scopeObj = bound[scope] || (bound[scope] = /* @__PURE__ */ Object.create(null));
          if (!scopeObj._any)
            scopeObj._any = { preventDefault: false, stopPropagation: false, run: [] };
          let { any } = b;
          for (let key in scopeObj)
            scopeObj[key].run.push((view) => any(view, currentKeyEvent$1));
        }
      let name2 = b[platform] || b.key;
      if (!name2)
        continue;
      for (let scope of scopes) {
        add(scope, name2, b.run, b.preventDefault, b.stopPropagation);
        if (b.shift)
          add(scope, "Shift-" + name2, b.shift, b.preventDefault, b.stopPropagation);
      }
    }
    return bound;
  }
  let currentKeyEvent$1 = null;
  function runHandlers$1(map, event, view, scope) {
    currentKeyEvent$1 = event;
    let name2 = keyName(event);
    let charCode = codePointAt(name2, 0), isChar = codePointSize(charCode) == name2.length && name2 != " ";
    let prefix2 = "", handled = false, prevented = false, stopPropagation = false;
    if (storedPrefix$1 && storedPrefix$1.view == view && storedPrefix$1.scope == scope) {
      prefix2 = storedPrefix$1.prefix + " ";
      if (modifierCodes$1.indexOf(event.keyCode) < 0) {
        prevented = true;
        storedPrefix$1 = null;
      }
    }
    let ran = /* @__PURE__ */ new Set();
    let runFor = (binding) => {
      if (binding) {
        for (let cmd2 of binding.run)
          if (!ran.has(cmd2)) {
            ran.add(cmd2);
            if (cmd2(view)) {
              if (binding.stopPropagation)
                stopPropagation = true;
              return true;
            }
          }
        if (binding.preventDefault) {
          if (binding.stopPropagation)
            stopPropagation = true;
          prevented = true;
        }
      }
      return false;
    };
    let scopeObj = map[scope], baseName, shiftName;
    if (scopeObj) {
      if (runFor(scopeObj[prefix2 + modifiers$1(name2, event, !isChar)])) {
        handled = true;
      } else if (isChar && (event.altKey || event.metaKey || event.ctrlKey) && // Ctrl-Alt may be used for AltGr on Windows
      !(browser$1.windows && event.ctrlKey && event.altKey) && (baseName = base[event.keyCode]) && baseName != name2) {
        if (runFor(scopeObj[prefix2 + modifiers$1(baseName, event, true)])) {
          handled = true;
        } else if (event.shiftKey && (shiftName = shift[event.keyCode]) != name2 && shiftName != baseName && runFor(scopeObj[prefix2 + modifiers$1(shiftName, event, false)])) {
          handled = true;
        }
      } else if (isChar && event.shiftKey && runFor(scopeObj[prefix2 + modifiers$1(name2, event, true)])) {
        handled = true;
      }
      if (!handled && runFor(scopeObj._any))
        handled = true;
    }
    if (prevented)
      handled = true;
    if (handled && stopPropagation)
      event.stopPropagation();
    currentKeyEvent$1 = null;
    return handled;
  }
  const CanHidePrimary$1 = !(browser$1.ios && browser$1.webkit && browser$1.webkit_version < 534);
  const themeSpec$1 = {
    ".cm-line": {
      "& ::selection, &::selection": { backgroundColor: "transparent !important" }
    },
    ".cm-content": {
      "& :focus": {
        caretColor: "initial !important",
        "&::selection, & ::selection": {
          backgroundColor: "Highlight !important"
        }
      }
    }
  };
  if (CanHidePrimary$1)
    themeSpec$1[".cm-line"].caretColor = themeSpec$1[".cm-content"].caretColor = "transparent !important";
  const Outside = "-10000px";
  class TooltipViewManager {
    constructor(view, facet, createTooltipView, removeTooltipView) {
      this.facet = facet;
      this.createTooltipView = createTooltipView;
      this.removeTooltipView = removeTooltipView;
      this.input = view.state.facet(facet);
      this.tooltips = this.input.filter((t2) => t2);
      let prev2 = null;
      this.tooltipViews = this.tooltips.map((t2) => prev2 = createTooltipView(t2, prev2));
    }
    update(update, above) {
      var _a3;
      let input = update.state.facet(this.facet);
      let tooltips = input.filter((x2) => x2);
      if (input === this.input) {
        for (let t2 of this.tooltipViews)
          if (t2.update)
            t2.update(update);
        return false;
      }
      let tooltipViews = [], newAbove = above ? [] : null;
      for (let i2 = 0; i2 < tooltips.length; i2++) {
        let tip = tooltips[i2], known = -1;
        if (!tip)
          continue;
        for (let i3 = 0; i3 < this.tooltips.length; i3++) {
          let other = this.tooltips[i3];
          if (other && other.create == tip.create)
            known = i3;
        }
        if (known < 0) {
          tooltipViews[i2] = this.createTooltipView(tip, i2 ? tooltipViews[i2 - 1] : null);
          if (newAbove)
            newAbove[i2] = !!tip.above;
        } else {
          let tooltipView = tooltipViews[i2] = this.tooltipViews[known];
          if (newAbove)
            newAbove[i2] = above[known];
          if (tooltipView.update)
            tooltipView.update(update);
        }
      }
      for (let t2 of this.tooltipViews)
        if (tooltipViews.indexOf(t2) < 0) {
          this.removeTooltipView(t2);
          (_a3 = t2.destroy) === null || _a3 === void 0 ? void 0 : _a3.call(t2);
        }
      if (above) {
        newAbove.forEach((val, i2) => above[i2] = val);
        above.length = newAbove.length;
      }
      this.input = input;
      this.tooltips = tooltips;
      this.tooltipViews = tooltipViews;
      return true;
    }
  }
  function windowSpace(view) {
    let { win } = view;
    return { top: 0, left: 0, bottom: win.innerHeight, right: win.innerWidth };
  }
  const tooltipConfig = /* @__PURE__ */ Facet.define({
    combine: (values2) => {
      var _a3, _b, _c;
      return {
        position: browser$1.ios ? "absolute" : ((_a3 = values2.find((conf) => conf.position)) === null || _a3 === void 0 ? void 0 : _a3.position) || "fixed",
        parent: ((_b = values2.find((conf) => conf.parent)) === null || _b === void 0 ? void 0 : _b.parent) || null,
        tooltipSpace: ((_c = values2.find((conf) => conf.tooltipSpace)) === null || _c === void 0 ? void 0 : _c.tooltipSpace) || windowSpace
      };
    }
  });
  const knownHeight = /* @__PURE__ */ new WeakMap();
  const tooltipPlugin = /* @__PURE__ */ ViewPlugin$1.fromClass(class {
    constructor(view) {
      this.view = view;
      this.above = [];
      this.inView = true;
      this.madeAbsolute = false;
      this.lastTransaction = 0;
      this.measureTimeout = -1;
      let config2 = view.state.facet(tooltipConfig);
      this.position = config2.position;
      this.parent = config2.parent;
      this.classes = view.themeClasses;
      this.createContainer();
      this.measureReq = { read: this.readMeasure.bind(this), write: this.writeMeasure.bind(this), key: this };
      this.resizeObserver = typeof ResizeObserver == "function" ? new ResizeObserver(() => this.measureSoon()) : null;
      this.manager = new TooltipViewManager(view, showTooltip, (t2, p2) => this.createTooltip(t2, p2), (t2) => {
        if (this.resizeObserver)
          this.resizeObserver.unobserve(t2.dom);
        t2.dom.remove();
      });
      this.above = this.manager.tooltips.map((t2) => !!t2.above);
      this.intersectionObserver = typeof IntersectionObserver == "function" ? new IntersectionObserver((entries) => {
        if (Date.now() > this.lastTransaction - 50 && entries.length > 0 && entries[entries.length - 1].intersectionRatio < 1)
          this.measureSoon();
      }, { threshold: [1] }) : null;
      this.observeIntersection();
      view.win.addEventListener("resize", this.measureSoon = this.measureSoon.bind(this));
      this.maybeMeasure();
    }
    createContainer() {
      if (this.parent) {
        this.container = document.createElement("div");
        this.container.style.position = "relative";
        this.container.className = this.view.themeClasses;
        this.parent.appendChild(this.container);
      } else {
        this.container = this.view.dom;
      }
    }
    observeIntersection() {
      if (this.intersectionObserver) {
        this.intersectionObserver.disconnect();
        for (let tooltip of this.manager.tooltipViews)
          this.intersectionObserver.observe(tooltip.dom);
      }
    }
    measureSoon() {
      if (this.measureTimeout < 0)
        this.measureTimeout = setTimeout(() => {
          this.measureTimeout = -1;
          this.maybeMeasure();
        }, 50);
    }
    update(update) {
      if (update.transactions.length)
        this.lastTransaction = Date.now();
      let updated = this.manager.update(update, this.above);
      if (updated)
        this.observeIntersection();
      let shouldMeasure = updated || update.geometryChanged;
      let newConfig = update.state.facet(tooltipConfig);
      if (newConfig.position != this.position && !this.madeAbsolute) {
        this.position = newConfig.position;
        for (let t2 of this.manager.tooltipViews)
          t2.dom.style.position = this.position;
        shouldMeasure = true;
      }
      if (newConfig.parent != this.parent) {
        if (this.parent)
          this.container.remove();
        this.parent = newConfig.parent;
        this.createContainer();
        for (let t2 of this.manager.tooltipViews)
          this.container.appendChild(t2.dom);
        shouldMeasure = true;
      } else if (this.parent && this.view.themeClasses != this.classes) {
        this.classes = this.container.className = this.view.themeClasses;
      }
      if (shouldMeasure)
        this.maybeMeasure();
    }
    createTooltip(tooltip, prev2) {
      let tooltipView = tooltip.create(this.view);
      let before = prev2 ? prev2.dom : null;
      tooltipView.dom.classList.add("cm-tooltip");
      if (tooltip.arrow && !tooltipView.dom.querySelector(".cm-tooltip > .cm-tooltip-arrow")) {
        let arrow2 = document.createElement("div");
        arrow2.className = "cm-tooltip-arrow";
        tooltipView.dom.appendChild(arrow2);
      }
      tooltipView.dom.style.position = this.position;
      tooltipView.dom.style.top = Outside;
      tooltipView.dom.style.left = "0px";
      this.container.insertBefore(tooltipView.dom, before);
      if (tooltipView.mount)
        tooltipView.mount(this.view);
      if (this.resizeObserver)
        this.resizeObserver.observe(tooltipView.dom);
      return tooltipView;
    }
    destroy() {
      var _a3, _b, _c;
      this.view.win.removeEventListener("resize", this.measureSoon);
      for (let tooltipView of this.manager.tooltipViews) {
        tooltipView.dom.remove();
        (_a3 = tooltipView.destroy) === null || _a3 === void 0 ? void 0 : _a3.call(tooltipView);
      }
      if (this.parent)
        this.container.remove();
      (_b = this.resizeObserver) === null || _b === void 0 ? void 0 : _b.disconnect();
      (_c = this.intersectionObserver) === null || _c === void 0 ? void 0 : _c.disconnect();
      clearTimeout(this.measureTimeout);
    }
    readMeasure() {
      let scaleX = 1, scaleY = 1, makeAbsolute = false;
      if (this.position == "fixed" && this.manager.tooltipViews.length) {
        let { dom } = this.manager.tooltipViews[0];
        if (browser$1.gecko) {
          makeAbsolute = dom.offsetParent != this.container.ownerDocument.body;
        } else if (dom.style.top == Outside && dom.style.left == "0px") {
          let rect = dom.getBoundingClientRect();
          makeAbsolute = Math.abs(rect.top + 1e4) > 1 || Math.abs(rect.left) > 1;
        }
      }
      if (makeAbsolute || this.position == "absolute") {
        if (this.parent) {
          let rect = this.parent.getBoundingClientRect();
          if (rect.width && rect.height) {
            scaleX = rect.width / this.parent.offsetWidth;
            scaleY = rect.height / this.parent.offsetHeight;
          }
        } else {
          ({ scaleX, scaleY } = this.view.viewState);
        }
      }
      let visible = this.view.scrollDOM.getBoundingClientRect(), margins = getScrollMargins$1(this.view);
      return {
        visible: {
          left: visible.left + margins.left,
          top: visible.top + margins.top,
          right: visible.right - margins.right,
          bottom: visible.bottom - margins.bottom
        },
        parent: this.parent ? this.container.getBoundingClientRect() : this.view.dom.getBoundingClientRect(),
        pos: this.manager.tooltips.map((t2, i2) => {
          let tv = this.manager.tooltipViews[i2];
          return tv.getCoords ? tv.getCoords(t2.pos) : this.view.coordsAtPos(t2.pos);
        }),
        size: this.manager.tooltipViews.map(({ dom }) => dom.getBoundingClientRect()),
        space: this.view.state.facet(tooltipConfig).tooltipSpace(this.view),
        scaleX,
        scaleY,
        makeAbsolute
      };
    }
    writeMeasure(measured) {
      var _a3;
      if (measured.makeAbsolute) {
        this.madeAbsolute = true;
        this.position = "absolute";
        for (let t2 of this.manager.tooltipViews)
          t2.dom.style.position = "absolute";
      }
      let { visible, space, scaleX, scaleY } = measured;
      let others = [];
      for (let i2 = 0; i2 < this.manager.tooltips.length; i2++) {
        let tooltip = this.manager.tooltips[i2], tView = this.manager.tooltipViews[i2], { dom } = tView;
        let pos = measured.pos[i2], size = measured.size[i2];
        if (!pos || tooltip.clip !== false && (pos.bottom <= Math.max(visible.top, space.top) || pos.top >= Math.min(visible.bottom, space.bottom) || pos.right < Math.max(visible.left, space.left) - 0.1 || pos.left > Math.min(visible.right, space.right) + 0.1)) {
          dom.style.top = Outside;
          continue;
        }
        let arrow2 = tooltip.arrow ? tView.dom.querySelector(".cm-tooltip-arrow") : null;
        let arrowHeight = arrow2 ? 7 : 0;
        let width2 = size.right - size.left, height2 = (_a3 = knownHeight.get(tView)) !== null && _a3 !== void 0 ? _a3 : size.bottom - size.top;
        let offset2 = tView.offset || noOffset, ltr = this.view.textDirection == Direction$1.LTR;
        let left2 = size.width > space.right - space.left ? ltr ? space.left : space.right - size.width : ltr ? Math.max(space.left, Math.min(pos.left - (arrow2 ? 14 : 0) + offset2.x, space.right - width2)) : Math.min(Math.max(space.left, pos.left - width2 + (arrow2 ? 14 : 0) - offset2.x), space.right - width2);
        let above = this.above[i2];
        if (!tooltip.strictSide && (above ? pos.top - height2 - arrowHeight - offset2.y < space.top : pos.bottom + height2 + arrowHeight + offset2.y > space.bottom) && above == space.bottom - pos.bottom > pos.top - space.top)
          above = this.above[i2] = !above;
        let spaceVert = (above ? pos.top - space.top : space.bottom - pos.bottom) - arrowHeight;
        if (spaceVert < height2 && tView.resize !== false) {
          if (spaceVert < this.view.defaultLineHeight) {
            dom.style.top = Outside;
            continue;
          }
          knownHeight.set(tView, height2);
          dom.style.height = (height2 = spaceVert) / scaleY + "px";
        } else if (dom.style.height) {
          dom.style.height = "";
        }
        let top2 = above ? pos.top - height2 - arrowHeight - offset2.y : pos.bottom + arrowHeight + offset2.y;
        let right2 = left2 + width2;
        if (tView.overlap !== true) {
          for (let r2 of others)
            if (r2.left < right2 && r2.right > left2 && r2.top < top2 + height2 && r2.bottom > top2)
              top2 = above ? r2.top - height2 - 2 - arrowHeight : r2.bottom + arrowHeight + 2;
        }
        if (this.position == "absolute") {
          dom.style.top = (top2 - measured.parent.top) / scaleY + "px";
          setLeftStyle(dom, (left2 - measured.parent.left) / scaleX);
        } else {
          dom.style.top = top2 / scaleY + "px";
          setLeftStyle(dom, left2 / scaleX);
        }
        if (arrow2) {
          let arrowLeft = pos.left + (ltr ? offset2.x : -offset2.x) - (left2 + 14 - 7);
          arrow2.style.left = arrowLeft / scaleX + "px";
        }
        if (tView.overlap !== true)
          others.push({ left: left2, top: top2, right: right2, bottom: top2 + height2 });
        dom.classList.toggle("cm-tooltip-above", above);
        dom.classList.toggle("cm-tooltip-below", !above);
        if (tView.positioned)
          tView.positioned(measured.space);
      }
    }
    maybeMeasure() {
      if (this.manager.tooltips.length) {
        if (this.view.inView)
          this.view.requestMeasure(this.measureReq);
        if (this.inView != this.view.inView) {
          this.inView = this.view.inView;
          if (!this.inView)
            for (let tv of this.manager.tooltipViews)
              tv.dom.style.top = Outside;
        }
      }
    }
  }, {
    eventObservers: {
      scroll() {
        this.maybeMeasure();
      }
    }
  });
  function setLeftStyle(elt, value) {
    let current = parseInt(elt.style.left, 10);
    if (isNaN(current) || Math.abs(value - current) > 1)
      elt.style.left = value + "px";
  }
  const baseTheme = /* @__PURE__ */ EditorView$1.baseTheme({
    ".cm-tooltip": {
      zIndex: 500,
      boxSizing: "border-box"
    },
    "&light .cm-tooltip": {
      border: "1px solid #bbb",
      backgroundColor: "#f5f5f5"
    },
    "&light .cm-tooltip-section:not(:first-child)": {
      borderTop: "1px solid #bbb"
    },
    "&dark .cm-tooltip": {
      backgroundColor: "#333338",
      color: "white"
    },
    ".cm-tooltip-arrow": {
      height: `${7}px`,
      width: `${7 * 2}px`,
      position: "absolute",
      zIndex: -1,
      overflow: "hidden",
      "&:before, &:after": {
        content: "''",
        position: "absolute",
        width: 0,
        height: 0,
        borderLeft: `${7}px solid transparent`,
        borderRight: `${7}px solid transparent`
      },
      ".cm-tooltip-above &": {
        bottom: `-${7}px`,
        "&:before": {
          borderTop: `${7}px solid #bbb`
        },
        "&:after": {
          borderTop: `${7}px solid #f5f5f5`,
          bottom: "1px"
        }
      },
      ".cm-tooltip-below &": {
        top: `-${7}px`,
        "&:before": {
          borderBottom: `${7}px solid #bbb`
        },
        "&:after": {
          borderBottom: `${7}px solid #f5f5f5`,
          top: "1px"
        }
      }
    },
    "&dark .cm-tooltip .cm-tooltip-arrow": {
      "&:before": {
        borderTopColor: "#333338",
        borderBottomColor: "#333338"
      },
      "&:after": {
        borderTopColor: "transparent",
        borderBottomColor: "transparent"
      }
    }
  });
  const noOffset = { x: 0, y: 0 };
  const showTooltip = /* @__PURE__ */ Facet.define({
    enables: [tooltipPlugin, baseTheme]
  });
  const showHoverTooltip = /* @__PURE__ */ Facet.define({
    combine: (inputs) => inputs.reduce((a2, i2) => a2.concat(i2), [])
  });
  class HoverTooltipHost {
    // Needs to be static so that host tooltip instances always match
    static create(view) {
      return new HoverTooltipHost(view);
    }
    constructor(view) {
      this.view = view;
      this.mounted = false;
      this.dom = document.createElement("div");
      this.dom.classList.add("cm-tooltip-hover");
      this.manager = new TooltipViewManager(view, showHoverTooltip, (t2, p2) => this.createHostedView(t2, p2), (t2) => t2.dom.remove());
    }
    createHostedView(tooltip, prev2) {
      let hostedView = tooltip.create(this.view);
      hostedView.dom.classList.add("cm-tooltip-section");
      this.dom.insertBefore(hostedView.dom, prev2 ? prev2.dom.nextSibling : this.dom.firstChild);
      if (this.mounted && hostedView.mount)
        hostedView.mount(this.view);
      return hostedView;
    }
    mount(view) {
      for (let hostedView of this.manager.tooltipViews) {
        if (hostedView.mount)
          hostedView.mount(view);
      }
      this.mounted = true;
    }
    positioned(space) {
      for (let hostedView of this.manager.tooltipViews) {
        if (hostedView.positioned)
          hostedView.positioned(space);
      }
    }
    update(update) {
      this.manager.update(update);
    }
    destroy() {
      var _a3;
      for (let t2 of this.manager.tooltipViews)
        (_a3 = t2.destroy) === null || _a3 === void 0 ? void 0 : _a3.call(t2);
    }
    passProp(name2) {
      let value = void 0;
      for (let view of this.manager.tooltipViews) {
        let given = view[name2];
        if (given !== void 0) {
          if (value === void 0)
            value = given;
          else if (value !== given)
            return void 0;
        }
      }
      return value;
    }
    get offset() {
      return this.passProp("offset");
    }
    get getCoords() {
      return this.passProp("getCoords");
    }
    get overlap() {
      return this.passProp("overlap");
    }
    get resize() {
      return this.passProp("resize");
    }
  }
  const showHoverTooltipHost = /* @__PURE__ */ showTooltip.compute([showHoverTooltip], (state) => {
    let tooltips = state.facet(showHoverTooltip);
    if (tooltips.length === 0)
      return null;
    return {
      pos: Math.min(...tooltips.map((t2) => t2.pos)),
      end: Math.max(...tooltips.map((t2) => {
        var _a3;
        return (_a3 = t2.end) !== null && _a3 !== void 0 ? _a3 : t2.pos;
      })),
      create: HoverTooltipHost.create,
      above: tooltips[0].above,
      arrow: tooltips.some((t2) => t2.arrow)
    };
  });
  class HoverPlugin {
    constructor(view, source, field, setHover, hoverTime) {
      this.view = view;
      this.source = source;
      this.field = field;
      this.setHover = setHover;
      this.hoverTime = hoverTime;
      this.hoverTimeout = -1;
      this.restartTimeout = -1;
      this.pending = null;
      this.lastMove = { x: 0, y: 0, target: view.dom, time: 0 };
      this.checkHover = this.checkHover.bind(this);
      view.dom.addEventListener("mouseleave", this.mouseleave = this.mouseleave.bind(this));
      view.dom.addEventListener("mousemove", this.mousemove = this.mousemove.bind(this));
    }
    update() {
      if (this.pending) {
        this.pending = null;
        clearTimeout(this.restartTimeout);
        this.restartTimeout = setTimeout(() => this.startHover(), 20);
      }
    }
    get active() {
      return this.view.state.field(this.field);
    }
    checkHover() {
      this.hoverTimeout = -1;
      if (this.active.length)
        return;
      let hovered = Date.now() - this.lastMove.time;
      if (hovered < this.hoverTime)
        this.hoverTimeout = setTimeout(this.checkHover, this.hoverTime - hovered);
      else
        this.startHover();
    }
    startHover() {
      clearTimeout(this.restartTimeout);
      let { view, lastMove } = this;
      let desc = view.docView.nearest(lastMove.target);
      if (!desc)
        return;
      let pos, side = 1;
      if (desc instanceof WidgetView$1) {
        pos = desc.posAtStart;
      } else {
        pos = view.posAtCoords(lastMove);
        if (pos == null)
          return;
        let posCoords = view.coordsAtPos(pos);
        if (!posCoords || lastMove.y < posCoords.top || lastMove.y > posCoords.bottom || lastMove.x < posCoords.left - view.defaultCharacterWidth || lastMove.x > posCoords.right + view.defaultCharacterWidth)
          return;
        let bidi = view.bidiSpans(view.state.doc.lineAt(pos)).find((s) => s.from <= pos && s.to >= pos);
        let rtl = bidi && bidi.dir == Direction$1.RTL ? -1 : 1;
        side = lastMove.x < posCoords.left ? -rtl : rtl;
      }
      let open = this.source(view, pos, side);
      if (open === null || open === void 0 ? void 0 : open.then) {
        let pending = this.pending = { pos };
        open.then((result) => {
          if (this.pending == pending) {
            this.pending = null;
            if (result && !(Array.isArray(result) && !result.length))
              view.dispatch({ effects: this.setHover.of(Array.isArray(result) ? result : [result]) });
          }
        }, (e) => logException$1(view.state, e, "hover tooltip"));
      } else if (open && !(Array.isArray(open) && !open.length)) {
        view.dispatch({ effects: this.setHover.of(Array.isArray(open) ? open : [open]) });
      }
    }
    get tooltip() {
      let plugin = this.view.plugin(tooltipPlugin);
      let index = plugin ? plugin.manager.tooltips.findIndex((t2) => t2.create == HoverTooltipHost.create) : -1;
      return index > -1 ? plugin.manager.tooltipViews[index] : null;
    }
    mousemove(event) {
      var _a3, _b;
      this.lastMove = { x: event.clientX, y: event.clientY, target: event.target, time: Date.now() };
      if (this.hoverTimeout < 0)
        this.hoverTimeout = setTimeout(this.checkHover, this.hoverTime);
      let { active, tooltip } = this;
      if (active.length && tooltip && !isInTooltip(tooltip.dom, event) || this.pending) {
        let { pos } = active[0] || this.pending, end2 = (_b = (_a3 = active[0]) === null || _a3 === void 0 ? void 0 : _a3.end) !== null && _b !== void 0 ? _b : pos;
        if (pos == end2 ? this.view.posAtCoords(this.lastMove) != pos : !isOverRange(this.view, pos, end2, event.clientX, event.clientY)) {
          this.view.dispatch({ effects: this.setHover.of([]) });
          this.pending = null;
        }
      }
    }
    mouseleave(event) {
      clearTimeout(this.hoverTimeout);
      this.hoverTimeout = -1;
      let { active } = this;
      if (active.length) {
        let { tooltip } = this;
        let inTooltip = tooltip && tooltip.dom.contains(event.relatedTarget);
        if (!inTooltip)
          this.view.dispatch({ effects: this.setHover.of([]) });
        else
          this.watchTooltipLeave(tooltip.dom);
      }
    }
    watchTooltipLeave(tooltip) {
      let watch = (event) => {
        tooltip.removeEventListener("mouseleave", watch);
        if (this.active.length && !this.view.dom.contains(event.relatedTarget))
          this.view.dispatch({ effects: this.setHover.of([]) });
      };
      tooltip.addEventListener("mouseleave", watch);
    }
    destroy() {
      clearTimeout(this.hoverTimeout);
      this.view.dom.removeEventListener("mouseleave", this.mouseleave);
      this.view.dom.removeEventListener("mousemove", this.mousemove);
    }
  }
  const tooltipMargin = 4;
  function isInTooltip(tooltip, event) {
    let { left: left2, right: right2, top: top2, bottom: bottom2 } = tooltip.getBoundingClientRect(), arrow2;
    if (arrow2 = tooltip.querySelector(".cm-tooltip-arrow")) {
      let arrowRect = arrow2.getBoundingClientRect();
      top2 = Math.min(arrowRect.top, top2);
      bottom2 = Math.max(arrowRect.bottom, bottom2);
    }
    return event.clientX >= left2 - tooltipMargin && event.clientX <= right2 + tooltipMargin && event.clientY >= top2 - tooltipMargin && event.clientY <= bottom2 + tooltipMargin;
  }
  function isOverRange(view, from2, to, x2, y, margin2) {
    let rect = view.scrollDOM.getBoundingClientRect();
    let docBottom = view.documentTop + view.documentPadding.top + view.contentHeight;
    if (rect.left > x2 || rect.right < x2 || rect.top > y || Math.min(rect.bottom, docBottom) < y)
      return false;
    let pos = view.posAtCoords({ x: x2, y }, false);
    return pos >= from2 && pos <= to;
  }
  function hoverTooltip(source, options = {}) {
    let setHover = StateEffect.define();
    let hoverState = StateField.define({
      create() {
        return [];
      },
      update(value, tr2) {
        if (value.length) {
          if (options.hideOnChange && (tr2.docChanged || tr2.selection))
            value = [];
          else if (options.hideOn)
            value = value.filter((v2) => !options.hideOn(tr2, v2));
          if (tr2.docChanged) {
            let mapped = [];
            for (let tooltip of value) {
              let newPos = tr2.changes.mapPos(tooltip.pos, -1, MapMode.TrackDel);
              if (newPos != null) {
                let copy2 = Object.assign(/* @__PURE__ */ Object.create(null), tooltip);
                copy2.pos = newPos;
                if (copy2.end != null)
                  copy2.end = tr2.changes.mapPos(copy2.end);
                mapped.push(copy2);
              }
            }
            value = mapped;
          }
        }
        for (let effect2 of tr2.effects) {
          if (effect2.is(setHover))
            value = effect2.value;
          if (effect2.is(closeHoverTooltipEffect))
            value = [];
        }
        return value;
      },
      provide: (f) => showHoverTooltip.from(f)
    });
    return {
      active: hoverState,
      extension: [
        hoverState,
        ViewPlugin$1.define((view) => new HoverPlugin(
          view,
          source,
          hoverState,
          setHover,
          options.hoverTime || 300
          /* Hover.Time */
        )),
        showHoverTooltipHost
      ]
    };
  }
  const closeHoverTooltipEffect = /* @__PURE__ */ StateEffect.define();
  let GutterMarker$1 = class GutterMarker extends RangeValue {
    /**
    @internal
    */
    compare(other) {
      return this == other || this.constructor == other.constructor && this.eq(other);
    }
    /**
    Compare this marker to another marker of the same type.
    */
    eq(other) {
      return false;
    }
    /**
    Called if the marker has a `toDOM` method and its representation
    was removed from a gutter.
    */
    destroy(dom) {
    }
  };
  GutterMarker$1.prototype.elementClass = "";
  GutterMarker$1.prototype.toDOM = void 0;
  GutterMarker$1.prototype.mapMode = MapMode.TrackBefore;
  GutterMarker$1.prototype.startSide = GutterMarker$1.prototype.endSide = -1;
  GutterMarker$1.prototype.point = true;
  var Cs = Object.defineProperty;
  var qs = (r2, t2, e) => t2 in r2 ? Cs(r2, t2, { enumerable: true, configurable: true, writable: true, value: e }) : r2[t2] = e;
  var Vt = (r2, t2, e) => (qs(r2, typeof t2 != "symbol" ? t2 + "" : t2, e), e);
  const Ss = 1024;
  let Bs = 0;
  let ie$1 = class ie {
    constructor(t2, e) {
      this.from = t2, this.to = e;
    }
  };
  class x {
    /**
    Create a new node prop type.
    */
    constructor(t2 = {}) {
      this.id = Bs++, this.perNode = !!t2.perNode, this.deserialize = t2.deserialize || (() => {
        throw new Error("This node type doesn't define a deserialize function");
      });
    }
    /**
    This is meant to be used with
    [`NodeSet.extend`](#common.NodeSet.extend) or
    [`LRParser.configure`](#lr.ParserConfig.props) to compute
    prop values for each node type in the set. Takes a [match
    object](#common.NodeType^match) or function that returns undefined
    if the node type doesn't get this prop, and the prop's value if
    it does.
    */
    add(t2) {
      if (this.perNode)
        throw new RangeError("Can't add per-node props to node types");
      return typeof t2 != "function" && (t2 = W.match(t2)), (e) => {
        let s = t2(e);
        return s === void 0 ? null : [this, s];
      };
    }
  }
  x.closedBy = new x({ deserialize: (r2) => r2.split(" ") });
  x.openedBy = new x({ deserialize: (r2) => r2.split(" ") });
  x.group = new x({ deserialize: (r2) => r2.split(" ") });
  x.isolate = new x({ deserialize: (r2) => {
    if (r2 && r2 != "rtl" && r2 != "ltr" && r2 != "auto")
      throw new RangeError("Invalid value for isolate: " + r2);
    return r2 || "auto";
  } });
  x.contextHash = new x({ perNode: true });
  x.lookAhead = new x({ perNode: true });
  x.mounted = new x({ perNode: true });
  class Bt {
    constructor(t2, e, s) {
      this.tree = t2, this.overlay = e, this.parser = s;
    }
    /**
    @internal
    */
    static get(t2) {
      return t2 && t2.props && t2.props[x.mounted.id];
    }
  }
  const Xs = /* @__PURE__ */ Object.create(null);
  class W {
    /**
    @internal
    */
    constructor(t2, e, s, i2 = 0) {
      this.name = t2, this.props = e, this.id = s, this.flags = i2;
    }
    /**
    Define a node type.
    */
    static define(t2) {
      let e = t2.props && t2.props.length ? /* @__PURE__ */ Object.create(null) : Xs, s = (t2.top ? 1 : 0) | (t2.skipped ? 2 : 0) | (t2.error ? 4 : 0) | (t2.name == null ? 8 : 0), i2 = new W(t2.name || "", e, t2.id, s);
      if (t2.props) {
        for (let n of t2.props)
          if (Array.isArray(n) || (n = n(i2)), n) {
            if (n[0].perNode)
              throw new RangeError("Can't store a per-node prop on a node type");
            e[n[0].id] = n[1];
          }
      }
      return i2;
    }
    /**
    Retrieves a node prop for this type. Will return `undefined` if
    the prop isn't present on this node.
    */
    prop(t2) {
      return this.props[t2.id];
    }
    /**
    True when this is the top node of a grammar.
    */
    get isTop() {
      return (this.flags & 1) > 0;
    }
    /**
    True when this node is produced by a skip rule.
    */
    get isSkipped() {
      return (this.flags & 2) > 0;
    }
    /**
    Indicates whether this is an error node.
    */
    get isError() {
      return (this.flags & 4) > 0;
    }
    /**
    When true, this node type doesn't correspond to a user-declared
    named node, for example because it is used to cache repetition.
    */
    get isAnonymous() {
      return (this.flags & 8) > 0;
    }
    /**
    Returns true when this node's name or one of its
    [groups](#common.NodeProp^group) matches the given string.
    */
    is(t2) {
      if (typeof t2 == "string") {
        if (this.name == t2)
          return true;
        let e = this.prop(x.group);
        return e ? e.indexOf(t2) > -1 : false;
      }
      return this.id == t2;
    }
    /**
    Create a function from node types to arbitrary values by
    specifying an object whose property names are node or
    [group](#common.NodeProp^group) names. Often useful with
    [`NodeProp.add`](#common.NodeProp.add). You can put multiple
    names, separated by spaces, in a single property name to map
    multiple node names to a single value.
    */
    static match(t2) {
      let e = /* @__PURE__ */ Object.create(null);
      for (let s in t2)
        for (let i2 of s.split(" "))
          e[i2] = t2[s];
      return (s) => {
        for (let i2 = s.prop(x.group), n = -1; n < (i2 ? i2.length : 0); n++) {
          let o2 = e[n < 0 ? s.name : i2[n]];
          if (o2)
            return o2;
        }
      };
    }
  }
  W.none = new W(
    "",
    /* @__PURE__ */ Object.create(null),
    0,
    8
    /* NodeFlag.Anonymous */
  );
  class Fe {
    /**
    Create a set with the given types. The `id` property of each
    type should correspond to its position within the array.
    */
    constructor(t2) {
      this.types = t2;
      for (let e = 0; e < t2.length; e++)
        if (t2[e].id != e)
          throw new RangeError("Node type ids should correspond to array positions when creating a node set");
    }
    /**
    Create a copy of this set with some node properties added. The
    arguments to this method can be created with
    [`NodeProp.add`](#common.NodeProp.add).
    */
    extend(...t2) {
      let e = [];
      for (let s of this.types) {
        let i2 = null;
        for (let n of t2) {
          let o2 = n(s);
          o2 && (i2 || (i2 = Object.assign({}, s.props)), i2[o2[0].id] = o2[1]);
        }
        e.push(i2 ? new W(s.name, i2, s.id, s.flags) : s);
      }
      return new Fe(e);
    }
  }
  const vt = /* @__PURE__ */ new WeakMap(), Pe = /* @__PURE__ */ new WeakMap();
  var v;
  (function(r2) {
    r2[r2.ExcludeBuffers = 1] = "ExcludeBuffers", r2[r2.IncludeAnonymous = 2] = "IncludeAnonymous", r2[r2.IgnoreMounts = 4] = "IgnoreMounts", r2[r2.IgnoreOverlays = 8] = "IgnoreOverlays";
  })(v || (v = {}));
  class V {
    /**
    Construct a new tree. See also [`Tree.build`](#common.Tree^build).
    */
    constructor(t2, e, s, i2, n) {
      if (this.type = t2, this.children = e, this.positions = s, this.length = i2, this.props = null, n && n.length) {
        this.props = /* @__PURE__ */ Object.create(null);
        for (let [o2, l] of n)
          this.props[typeof o2 == "number" ? o2 : o2.id] = l;
      }
    }
    /**
    @internal
    */
    toString() {
      let t2 = Bt.get(this);
      if (t2 && !t2.overlay)
        return t2.tree.toString();
      let e = "";
      for (let s of this.children) {
        let i2 = s.toString();
        i2 && (e && (e += ","), e += i2);
      }
      return this.type.name ? (/\W/.test(this.type.name) && !this.type.isError ? JSON.stringify(this.type.name) : this.type.name) + (e.length ? "(" + e + ")" : "") : e;
    }
    /**
    Get a [tree cursor](#common.TreeCursor) positioned at the top of
    the tree. Mode can be used to [control](#common.IterMode) which
    nodes the cursor visits.
    */
    cursor(t2 = 0) {
      return new xe(this.topNode, t2);
    }
    /**
    Get a [tree cursor](#common.TreeCursor) pointing into this tree
    at the given position and side (see
    [`moveTo`](#common.TreeCursor.moveTo).
    */
    cursorAt(t2, e = 0, s = 0) {
      let i2 = vt.get(this) || this.topNode, n = new xe(i2);
      return n.moveTo(t2, e), vt.set(this, n._tree), n;
    }
    /**
    Get a [syntax node](#common.SyntaxNode) object for the top of the
    tree.
    */
    get topNode() {
      return new E(this, 0, 0, null);
    }
    /**
    Get the [syntax node](#common.SyntaxNode) at the given position.
    If `side` is -1, this will move into nodes that end at the
    position. If 1, it'll move into nodes that start at the
    position. With 0, it'll only enter nodes that cover the position
    from both sides.
    
    Note that this will not enter
    [overlays](#common.MountedTree.overlay), and you often want
    [`resolveInner`](#common.Tree.resolveInner) instead.
    */
    resolve(t2, e = 0) {
      let s = Tt(vt.get(this) || this.topNode, t2, e, false);
      return vt.set(this, s), s;
    }
    /**
    Like [`resolve`](#common.Tree.resolve), but will enter
    [overlaid](#common.MountedTree.overlay) nodes, producing a syntax node
    pointing into the innermost overlaid tree at the given position
    (with parent links going through all parent structure, including
    the host trees).
    */
    resolveInner(t2, e = 0) {
      let s = Tt(Pe.get(this) || this.topNode, t2, e, true);
      return Pe.set(this, s), s;
    }
    /**
    In some situations, it can be useful to iterate through all
    nodes around a position, including those in overlays that don't
    directly cover the position. This method gives you an iterator
    that will produce all nodes, from small to big, around the given
    position.
    */
    resolveStack(t2, e = 0) {
      return Qs(this, t2, e);
    }
    /**
    Iterate over the tree and its children, calling `enter` for any
    node that touches the `from`/`to` region (if given) before
    running over such a node's children, and `leave` (if given) when
    leaving the node. When `enter` returns `false`, that node will
    not have its children iterated over (or `leave` called).
    */
    iterate(t2) {
      let { enter: e, leave: s, from: i2 = 0, to: n = this.length } = t2, o2 = t2.mode || 0, l = (o2 & v.IncludeAnonymous) > 0;
      for (let a2 = this.cursor(o2 | v.IncludeAnonymous); ; ) {
        let h = false;
        if (a2.from <= n && a2.to >= i2 && (!l && a2.type.isAnonymous || e(a2) !== false)) {
          if (a2.firstChild())
            continue;
          h = true;
        }
        for (; h && s && (l || !a2.type.isAnonymous) && s(a2), !a2.nextSibling(); ) {
          if (!a2.parent())
            return;
          h = true;
        }
      }
    }
    /**
    Get the value of the given [node prop](#common.NodeProp) for this
    node. Works with both per-node and per-type props.
    */
    prop(t2) {
      return t2.perNode ? this.props ? this.props[t2.id] : void 0 : this.type.prop(t2);
    }
    /**
    Returns the node's [per-node props](#common.NodeProp.perNode) in a
    format that can be passed to the [`Tree`](#common.Tree)
    constructor.
    */
    get propValues() {
      let t2 = [];
      if (this.props)
        for (let e in this.props)
          t2.push([+e, this.props[e]]);
      return t2;
    }
    /**
    Balance the direct children of this tree, producing a copy of
    which may have children grouped into subtrees with type
    [`NodeType.none`](#common.NodeType^none).
    */
    balance(t2 = {}) {
      return this.children.length <= 8 ? this : ve(W.none, this.children, this.positions, 0, this.children.length, 0, this.length, (e, s, i2) => new V(this.type, e, s, i2, this.propValues), t2.makeTree || ((e, s, i2) => new V(W.none, e, s, i2)));
    }
    /**
    Build a tree from a postfix-ordered buffer of node information,
    or a cursor over such a buffer.
    */
    static build(t2) {
      return Ks(t2);
    }
  }
  V.empty = new V(W.none, [], [], 0);
  class Re {
    constructor(t2, e) {
      this.buffer = t2, this.index = e;
    }
    get id() {
      return this.buffer[this.index - 4];
    }
    get start() {
      return this.buffer[this.index - 3];
    }
    get end() {
      return this.buffer[this.index - 2];
    }
    get size() {
      return this.buffer[this.index - 1];
    }
    get pos() {
      return this.index;
    }
    next() {
      this.index -= 4;
    }
    fork() {
      return new Re(this.buffer, this.index);
    }
  }
  class st {
    /**
    Create a tree buffer.
    */
    constructor(t2, e, s) {
      this.buffer = t2, this.length = e, this.set = s;
    }
    /**
    @internal
    */
    get type() {
      return W.none;
    }
    /**
    @internal
    */
    toString() {
      let t2 = [];
      for (let e = 0; e < this.buffer.length; )
        t2.push(this.childString(e)), e = this.buffer[e + 3];
      return t2.join(",");
    }
    /**
    @internal
    */
    childString(t2) {
      let e = this.buffer[t2], s = this.buffer[t2 + 3], i2 = this.set.types[e], n = i2.name;
      if (/\W/.test(n) && !i2.isError && (n = JSON.stringify(n)), t2 += 4, s == t2)
        return n;
      let o2 = [];
      for (; t2 < s; )
        o2.push(this.childString(t2)), t2 = this.buffer[t2 + 3];
      return n + "(" + o2.join(",") + ")";
    }
    /**
    @internal
    */
    findChild(t2, e, s, i2, n) {
      let { buffer: o2 } = this, l = -1;
      for (let a2 = t2; a2 != e && !(bs(n, i2, o2[a2 + 1], o2[a2 + 2]) && (l = a2, s > 0)); a2 = o2[a2 + 3])
        ;
      return l;
    }
    /**
    @internal
    */
    slice(t2, e, s) {
      let i2 = this.buffer, n = new Uint16Array(e - t2), o2 = 0;
      for (let l = t2, a2 = 0; l < e; ) {
        n[a2++] = i2[l++], n[a2++] = i2[l++] - s;
        let h = n[a2++] = i2[l++] - s;
        n[a2++] = i2[l++] - t2, o2 = Math.max(o2, h);
      }
      return new st(n, o2, this.set);
    }
  }
  function bs(r2, t2, e, s) {
    switch (r2) {
      case -2:
        return e < t2;
      case -1:
        return s >= t2 && e < t2;
      case 0:
        return e < t2 && s > t2;
      case 1:
        return e <= t2 && s > t2;
      case 2:
        return s > t2;
      case 4:
        return true;
    }
  }
  function Tt(r2, t2, e, s) {
    for (var i2; r2.from == r2.to || (e < 1 ? r2.from >= t2 : r2.from > t2) || (e > -1 ? r2.to <= t2 : r2.to < t2); ) {
      let o2 = !s && r2 instanceof E && r2.index < 0 ? null : r2.parent;
      if (!o2)
        return r2;
      r2 = o2;
    }
    let n = s ? 0 : v.IgnoreOverlays;
    if (s)
      for (let o2 = r2, l = o2.parent; l; o2 = l, l = o2.parent)
        o2 instanceof E && o2.index < 0 && ((i2 = l.enter(t2, e, n)) === null || i2 === void 0 ? void 0 : i2.from) != o2.from && (r2 = l);
    for (; ; ) {
      let o2 = r2.enter(t2, e, n);
      if (!o2)
        return r2;
      r2 = o2;
    }
  }
  class xs {
    cursor(t2 = 0) {
      return new xe(this, t2);
    }
    getChild(t2, e = null, s = null) {
      let i2 = Ce(this, t2, e, s);
      return i2.length ? i2[0] : null;
    }
    getChildren(t2, e = null, s = null) {
      return Ce(this, t2, e, s);
    }
    resolve(t2, e = 0) {
      return Tt(this, t2, e, false);
    }
    resolveInner(t2, e = 0) {
      return Tt(this, t2, e, true);
    }
    matchContext(t2) {
      return be(this, t2);
    }
    enterUnfinishedNodesBefore(t2) {
      let e = this.childBefore(t2), s = this;
      for (; e; ) {
        let i2 = e.lastChild;
        if (!i2 || i2.to != e.to)
          break;
        i2.type.isError && i2.from == i2.to ? (s = e, e = i2.prevSibling) : e = i2;
      }
      return s;
    }
    get node() {
      return this;
    }
    get next() {
      return this.parent;
    }
  }
  class E extends xs {
    constructor(t2, e, s, i2) {
      super(), this._tree = t2, this.from = e, this.index = s, this._parent = i2;
    }
    get type() {
      return this._tree.type;
    }
    get name() {
      return this._tree.type.name;
    }
    get to() {
      return this.from + this._tree.length;
    }
    nextChild(t2, e, s, i2, n = 0) {
      for (let o2 = this; ; ) {
        for (let { children: l, positions: a2 } = o2._tree, h = e > 0 ? l.length : -1; t2 != h; t2 += e) {
          let u = l[t2], $ = a2[t2] + o2.from;
          if (bs(i2, s, $, $ + u.length)) {
            if (u instanceof st) {
              if (n & v.ExcludeBuffers)
                continue;
              let f = u.findChild(0, u.buffer.length, e, s - $, i2);
              if (f > -1)
                return new et(new _s(o2, u, t2, $), null, f);
            } else if (n & v.IncludeAnonymous || !u.type.isAnonymous || Ve(u)) {
              let f;
              if (!(n & v.IgnoreMounts) && (f = Bt.get(u)) && !f.overlay)
                return new E(f.tree, $, t2, o2);
              let c2 = new E(u, $, t2, o2);
              return n & v.IncludeAnonymous || !c2.type.isAnonymous ? c2 : c2.nextChild(e < 0 ? u.children.length - 1 : 0, e, s, i2);
            }
          }
        }
        if (n & v.IncludeAnonymous || !o2.type.isAnonymous || (o2.index >= 0 ? t2 = o2.index + e : t2 = e < 0 ? -1 : o2._parent._tree.children.length, o2 = o2._parent, !o2))
          return null;
      }
    }
    get firstChild() {
      return this.nextChild(
        0,
        1,
        0,
        4
        /* Side.DontCare */
      );
    }
    get lastChild() {
      return this.nextChild(
        this._tree.children.length - 1,
        -1,
        0,
        4
        /* Side.DontCare */
      );
    }
    childAfter(t2) {
      return this.nextChild(
        0,
        1,
        t2,
        2
        /* Side.After */
      );
    }
    childBefore(t2) {
      return this.nextChild(
        this._tree.children.length - 1,
        -1,
        t2,
        -2
        /* Side.Before */
      );
    }
    enter(t2, e, s = 0) {
      let i2;
      if (!(s & v.IgnoreOverlays) && (i2 = Bt.get(this._tree)) && i2.overlay) {
        let n = t2 - this.from;
        for (let { from: o2, to: l } of i2.overlay)
          if ((e > 0 ? o2 <= n : o2 < n) && (e < 0 ? l >= n : l > n))
            return new E(i2.tree, i2.overlay[0].from + this.from, -1, this);
      }
      return this.nextChild(0, 1, t2, e, s);
    }
    nextSignificantParent() {
      let t2 = this;
      for (; t2.type.isAnonymous && t2._parent; )
        t2 = t2._parent;
      return t2;
    }
    get parent() {
      return this._parent ? this._parent.nextSignificantParent() : null;
    }
    get nextSibling() {
      return this._parent && this.index >= 0 ? this._parent.nextChild(
        this.index + 1,
        1,
        0,
        4
        /* Side.DontCare */
      ) : null;
    }
    get prevSibling() {
      return this._parent && this.index >= 0 ? this._parent.nextChild(
        this.index - 1,
        -1,
        0,
        4
        /* Side.DontCare */
      ) : null;
    }
    get tree() {
      return this._tree;
    }
    toTree() {
      return this._tree;
    }
    /**
    @internal
    */
    toString() {
      return this._tree.toString();
    }
  }
  function Ce(r2, t2, e, s) {
    let i2 = r2.cursor(), n = [];
    if (!i2.firstChild())
      return n;
    if (e != null) {
      for (; !i2.type.is(e); )
        if (!i2.nextSibling())
          return n;
    }
    for (; ; ) {
      if (s != null && i2.type.is(s))
        return n;
      if (i2.type.is(t2) && n.push(i2.node), !i2.nextSibling())
        return s == null ? n : [];
    }
  }
  function be(r2, t2, e = t2.length - 1) {
    for (let s = r2.parent; e >= 0; s = s.parent) {
      if (!s)
        return false;
      if (!s.type.isAnonymous) {
        if (t2[e] && t2[e] != s.name)
          return false;
        e--;
      }
    }
    return true;
  }
  class _s {
    constructor(t2, e, s, i2) {
      this.parent = t2, this.buffer = e, this.index = s, this.start = i2;
    }
  }
  class et extends xs {
    get name() {
      return this.type.name;
    }
    get from() {
      return this.context.start + this.context.buffer.buffer[this.index + 1];
    }
    get to() {
      return this.context.start + this.context.buffer.buffer[this.index + 2];
    }
    constructor(t2, e, s) {
      super(), this.context = t2, this._parent = e, this.index = s, this.type = t2.buffer.set.types[t2.buffer.buffer[s]];
    }
    child(t2, e, s) {
      let { buffer: i2 } = this.context, n = i2.findChild(this.index + 4, i2.buffer[this.index + 3], t2, e - this.context.start, s);
      return n < 0 ? null : new et(this.context, this, n);
    }
    get firstChild() {
      return this.child(
        1,
        0,
        4
        /* Side.DontCare */
      );
    }
    get lastChild() {
      return this.child(
        -1,
        0,
        4
        /* Side.DontCare */
      );
    }
    childAfter(t2) {
      return this.child(
        1,
        t2,
        2
        /* Side.After */
      );
    }
    childBefore(t2) {
      return this.child(
        -1,
        t2,
        -2
        /* Side.Before */
      );
    }
    enter(t2, e, s = 0) {
      if (s & v.ExcludeBuffers)
        return null;
      let { buffer: i2 } = this.context, n = i2.findChild(this.index + 4, i2.buffer[this.index + 3], e > 0 ? 1 : -1, t2 - this.context.start, e);
      return n < 0 ? null : new et(this.context, this, n);
    }
    get parent() {
      return this._parent || this.context.parent.nextSignificantParent();
    }
    externalSibling(t2) {
      return this._parent ? null : this.context.parent.nextChild(
        this.context.index + t2,
        t2,
        0,
        4
        /* Side.DontCare */
      );
    }
    get nextSibling() {
      let { buffer: t2 } = this.context, e = t2.buffer[this.index + 3];
      return e < (this._parent ? t2.buffer[this._parent.index + 3] : t2.buffer.length) ? new et(this.context, this._parent, e) : this.externalSibling(1);
    }
    get prevSibling() {
      let { buffer: t2 } = this.context, e = this._parent ? this._parent.index + 4 : 0;
      return this.index == e ? this.externalSibling(-1) : new et(this.context, this._parent, t2.findChild(
        e,
        this.index,
        -1,
        0,
        4
        /* Side.DontCare */
      ));
    }
    get tree() {
      return null;
    }
    toTree() {
      let t2 = [], e = [], { buffer: s } = this.context, i2 = this.index + 4, n = s.buffer[this.index + 3];
      if (n > i2) {
        let o2 = s.buffer[this.index + 1];
        t2.push(s.slice(i2, n, o2)), e.push(0);
      }
      return new V(this.type, t2, e, this.to - this.from);
    }
    /**
    @internal
    */
    toString() {
      return this.context.buffer.childString(this.index);
    }
  }
  function ks(r2) {
    if (!r2.length)
      return null;
    let t2 = 0, e = r2[0];
    for (let n = 1; n < r2.length; n++) {
      let o2 = r2[n];
      (o2.from > e.from || o2.to < e.to) && (e = o2, t2 = n);
    }
    let s = e instanceof E && e.index < 0 ? null : e.parent, i2 = r2.slice();
    return s ? i2[t2] = s : i2.splice(t2, 1), new Ys(i2, e);
  }
  class Ys {
    constructor(t2, e) {
      this.heads = t2, this.node = e;
    }
    get next() {
      return ks(this.heads);
    }
  }
  function Qs(r2, t2, e) {
    let s = r2.resolveInner(t2, e), i2 = null;
    for (let n = s instanceof E ? s : s.context.parent; n; n = n.parent)
      if (n.index < 0) {
        let o2 = n.parent;
        (i2 || (i2 = [s])).push(o2.resolve(t2, e)), n = o2;
      } else {
        let o2 = Bt.get(n.tree);
        if (o2 && o2.overlay && o2.overlay[0].from <= t2 && o2.overlay[o2.overlay.length - 1].to >= t2) {
          let l = new E(o2.tree, o2.overlay[0].from + n.from, -1, n);
          (i2 || (i2 = [s])).push(Tt(l, t2, e, false));
        }
      }
    return i2 ? ks(i2) : s;
  }
  class xe {
    /**
    Shorthand for `.type.name`.
    */
    get name() {
      return this.type.name;
    }
    /**
    @internal
    */
    constructor(t2, e = 0) {
      if (this.mode = e, this.buffer = null, this.stack = [], this.index = 0, this.bufferNode = null, t2 instanceof E)
        this.yieldNode(t2);
      else {
        this._tree = t2.context.parent, this.buffer = t2.context;
        for (let s = t2._parent; s; s = s._parent)
          this.stack.unshift(s.index);
        this.bufferNode = t2, this.yieldBuf(t2.index);
      }
    }
    yieldNode(t2) {
      return t2 ? (this._tree = t2, this.type = t2.type, this.from = t2.from, this.to = t2.to, true) : false;
    }
    yieldBuf(t2, e) {
      this.index = t2;
      let { start: s, buffer: i2 } = this.buffer;
      return this.type = e || i2.set.types[i2.buffer[t2]], this.from = s + i2.buffer[t2 + 1], this.to = s + i2.buffer[t2 + 2], true;
    }
    /**
    @internal
    */
    yield(t2) {
      return t2 ? t2 instanceof E ? (this.buffer = null, this.yieldNode(t2)) : (this.buffer = t2.context, this.yieldBuf(t2.index, t2.type)) : false;
    }
    /**
    @internal
    */
    toString() {
      return this.buffer ? this.buffer.buffer.childString(this.index) : this._tree.toString();
    }
    /**
    @internal
    */
    enterChild(t2, e, s) {
      if (!this.buffer)
        return this.yield(this._tree.nextChild(t2 < 0 ? this._tree._tree.children.length - 1 : 0, t2, e, s, this.mode));
      let { buffer: i2 } = this.buffer, n = i2.findChild(this.index + 4, i2.buffer[this.index + 3], t2, e - this.buffer.start, s);
      return n < 0 ? false : (this.stack.push(this.index), this.yieldBuf(n));
    }
    /**
    Move the cursor to this node's first child. When this returns
    false, the node has no child, and the cursor has not been moved.
    */
    firstChild() {
      return this.enterChild(
        1,
        0,
        4
        /* Side.DontCare */
      );
    }
    /**
    Move the cursor to this node's last child.
    */
    lastChild() {
      return this.enterChild(
        -1,
        0,
        4
        /* Side.DontCare */
      );
    }
    /**
    Move the cursor to the first child that ends after `pos`.
    */
    childAfter(t2) {
      return this.enterChild(
        1,
        t2,
        2
        /* Side.After */
      );
    }
    /**
    Move to the last child that starts before `pos`.
    */
    childBefore(t2) {
      return this.enterChild(
        -1,
        t2,
        -2
        /* Side.Before */
      );
    }
    /**
    Move the cursor to the child around `pos`. If side is -1 the
    child may end at that position, when 1 it may start there. This
    will also enter [overlaid](#common.MountedTree.overlay)
    [mounted](#common.NodeProp^mounted) trees unless `overlays` is
    set to false.
    */
    enter(t2, e, s = this.mode) {
      return this.buffer ? s & v.ExcludeBuffers ? false : this.enterChild(1, t2, e) : this.yield(this._tree.enter(t2, e, s));
    }
    /**
    Move to the node's parent node, if this isn't the top node.
    */
    parent() {
      if (!this.buffer)
        return this.yieldNode(this.mode & v.IncludeAnonymous ? this._tree._parent : this._tree.parent);
      if (this.stack.length)
        return this.yieldBuf(this.stack.pop());
      let t2 = this.mode & v.IncludeAnonymous ? this.buffer.parent : this.buffer.parent.nextSignificantParent();
      return this.buffer = null, this.yieldNode(t2);
    }
    /**
    @internal
    */
    sibling(t2) {
      if (!this.buffer)
        return this._tree._parent ? this.yield(this._tree.index < 0 ? null : this._tree._parent.nextChild(this._tree.index + t2, t2, 0, 4, this.mode)) : false;
      let { buffer: e } = this.buffer, s = this.stack.length - 1;
      if (t2 < 0) {
        let i2 = s < 0 ? 0 : this.stack[s] + 4;
        if (this.index != i2)
          return this.yieldBuf(e.findChild(
            i2,
            this.index,
            -1,
            0,
            4
            /* Side.DontCare */
          ));
      } else {
        let i2 = e.buffer[this.index + 3];
        if (i2 < (s < 0 ? e.buffer.length : e.buffer[this.stack[s] + 3]))
          return this.yieldBuf(i2);
      }
      return s < 0 ? this.yield(this.buffer.parent.nextChild(this.buffer.index + t2, t2, 0, 4, this.mode)) : false;
    }
    /**
    Move to this node's next sibling, if any.
    */
    nextSibling() {
      return this.sibling(1);
    }
    /**
    Move to this node's previous sibling, if any.
    */
    prevSibling() {
      return this.sibling(-1);
    }
    atLastNode(t2) {
      let e, s, { buffer: i2 } = this;
      if (i2) {
        if (t2 > 0) {
          if (this.index < i2.buffer.buffer.length)
            return false;
        } else
          for (let n = 0; n < this.index; n++)
            if (i2.buffer.buffer[n + 3] < this.index)
              return false;
        ({ index: e, parent: s } = i2);
      } else
        ({ index: e, _parent: s } = this._tree);
      for (; s; { index: e, _parent: s } = s)
        if (e > -1)
          for (let n = e + t2, o2 = t2 < 0 ? -1 : s._tree.children.length; n != o2; n += t2) {
            let l = s._tree.children[n];
            if (this.mode & v.IncludeAnonymous || l instanceof st || !l.type.isAnonymous || Ve(l))
              return false;
          }
      return true;
    }
    move(t2, e) {
      if (e && this.enterChild(
        t2,
        0,
        4
        /* Side.DontCare */
      ))
        return true;
      for (; ; ) {
        if (this.sibling(t2))
          return true;
        if (this.atLastNode(t2) || !this.parent())
          return false;
      }
    }
    /**
    Move to the next node in a
    [pre-order](https://en.wikipedia.org/wiki/Tree_traversal#Pre-order,_NLR)
    traversal, going from a node to its first child or, if the
    current node is empty or `enter` is false, its next sibling or
    the next sibling of the first parent node that has one.
    */
    next(t2 = true) {
      return this.move(1, t2);
    }
    /**
    Move to the next node in a last-to-first pre-order traveral. A
    node is followed by its last child or, if it has none, its
    previous sibling or the previous sibling of the first parent
    node that has one.
    */
    prev(t2 = true) {
      return this.move(-1, t2);
    }
    /**
    Move the cursor to the innermost node that covers `pos`. If
    `side` is -1, it will enter nodes that end at `pos`. If it is 1,
    it will enter nodes that start at `pos`.
    */
    moveTo(t2, e = 0) {
      for (; (this.from == this.to || (e < 1 ? this.from >= t2 : this.from > t2) || (e > -1 ? this.to <= t2 : this.to < t2)) && this.parent(); )
        ;
      for (; this.enterChild(1, t2, e); )
        ;
      return this;
    }
    /**
    Get a [syntax node](#common.SyntaxNode) at the cursor's current
    position.
    */
    get node() {
      if (!this.buffer)
        return this._tree;
      let t2 = this.bufferNode, e = null, s = 0;
      if (t2 && t2.context == this.buffer)
        t:
          for (let i2 = this.index, n = this.stack.length; n >= 0; ) {
            for (let o2 = t2; o2; o2 = o2._parent)
              if (o2.index == i2) {
                if (i2 == this.index)
                  return o2;
                e = o2, s = n + 1;
                break t;
              }
            i2 = this.stack[--n];
          }
      for (let i2 = s; i2 < this.stack.length; i2++)
        e = new et(this.buffer, e, this.stack[i2]);
      return this.bufferNode = new et(this.buffer, e, this.index);
    }
    /**
    Get the [tree](#common.Tree) that represents the current node, if
    any. Will return null when the node is in a [tree
    buffer](#common.TreeBuffer).
    */
    get tree() {
      return this.buffer ? null : this._tree._tree;
    }
    /**
    Iterate over the current node and all its descendants, calling
    `enter` when entering a node and `leave`, if given, when leaving
    one. When `enter` returns `false`, any children of that node are
    skipped, and `leave` isn't called for it.
    */
    iterate(t2, e) {
      for (let s = 0; ; ) {
        let i2 = false;
        if (this.type.isAnonymous || t2(this) !== false) {
          if (this.firstChild()) {
            s++;
            continue;
          }
          this.type.isAnonymous || (i2 = true);
        }
        for (; i2 && e && e(this), i2 = this.type.isAnonymous, !this.nextSibling(); ) {
          if (!s)
            return;
          this.parent(), s--, i2 = true;
        }
      }
    }
    /**
    Test whether the current node matches a given context—a sequence
    of direct parent node names. Empty strings in the context array
    are treated as wildcards.
    */
    matchContext(t2) {
      if (!this.buffer)
        return be(this.node, t2);
      let { buffer: e } = this.buffer, { types: s } = e.set;
      for (let i2 = t2.length - 1, n = this.stack.length - 1; i2 >= 0; n--) {
        if (n < 0)
          return be(this.node, t2, i2);
        let o2 = s[e.buffer[this.stack[n]]];
        if (!o2.isAnonymous) {
          if (t2[i2] && t2[i2] != o2.name)
            return false;
          i2--;
        }
      }
      return true;
    }
  }
  function Ve(r2) {
    return r2.children.some((t2) => t2 instanceof st || !t2.type.isAnonymous || Ve(t2));
  }
  function Ks(r2) {
    var t2;
    let { buffer: e, nodeSet: s, maxBufferLength: i2 = Ss, reused: n = [], minRepeatType: o2 = s.types.length } = r2, l = Array.isArray(e) ? new Re(e, e.length) : e, a2 = s.types, h = 0, u = 0;
    function $(S, y, j, T, k, b) {
      let { id: g, start: O, end: F, size: w } = l, D = u;
      for (; w < 0; )
        if (l.next(), w == -1) {
          let Z = n[g];
          j.push(Z), T.push(O - S);
          return;
        } else if (w == -3) {
          h = g;
          return;
        } else if (w == -4) {
          u = g;
          return;
        } else
          throw new RangeError(`Unrecognized record size: ${w}`);
      let it = a2[g], $t, rt, De = O - S;
      if (F - O <= i2 && (rt = R(l.pos - y, k))) {
        let Z = new Uint16Array(rt.size - rt.skip), C2 = l.pos - rt.size, B = Z.length;
        for (; l.pos > C2; )
          B = I(rt.start, Z, B);
        $t = new st(Z, F - rt.start, s), De = rt.start - S;
      } else {
        let Z = l.pos - w;
        l.next();
        let C2 = [], B = [], nt = g >= o2 ? g : -1, ft = 0, Rt = F;
        for (; l.pos > Z; )
          nt >= 0 && l.id == nt && l.size >= 0 ? (l.end <= Rt - i2 && (d(C2, B, O, ft, l.end, Rt, nt, D), ft = C2.length, Rt = l.end), l.next()) : b > 2500 ? f(O, Z, C2, B) : $(O, Z, C2, B, nt, b + 1);
        if (nt >= 0 && ft > 0 && ft < C2.length && d(C2, B, O, ft, O, Rt, nt, D), C2.reverse(), B.reverse(), nt > -1 && ft > 0) {
          let We = c2(it);
          $t = ve(it, C2, B, 0, C2.length, 0, F - O, We, We);
        } else
          $t = m2(it, C2, B, F - O, D - F);
      }
      j.push($t), T.push(De);
    }
    function f(S, y, j, T) {
      let k = [], b = 0, g = -1;
      for (; l.pos > y; ) {
        let { id: O, start: F, end: w, size: D } = l;
        if (D > 4)
          l.next();
        else {
          if (g > -1 && F < g)
            break;
          g < 0 && (g = w - i2), k.push(O, F, w), b++, l.next();
        }
      }
      if (b) {
        let O = new Uint16Array(b * 4), F = k[k.length - 2];
        for (let w = k.length - 3, D = 0; w >= 0; w -= 3)
          O[D++] = k[w], O[D++] = k[w + 1] - F, O[D++] = k[w + 2] - F, O[D++] = D;
        j.push(new st(O, k[2] - F, s)), T.push(F - S);
      }
    }
    function c2(S) {
      return (y, j, T) => {
        let k = 0, b = y.length - 1, g, O;
        if (b >= 0 && (g = y[b]) instanceof V) {
          if (!b && g.type == S && g.length == T)
            return g;
          (O = g.prop(x.lookAhead)) && (k = j[b] + g.length + O);
        }
        return m2(S, y, j, T, k);
      };
    }
    function d(S, y, j, T, k, b, g, O) {
      let F = [], w = [];
      for (; S.length > T; )
        F.push(S.pop()), w.push(y.pop() + j - k);
      S.push(m2(s.types[g], F, w, b - k, O - b)), y.push(k - j);
    }
    function m2(S, y, j, T, k = 0, b) {
      if (h) {
        let g = [x.contextHash, h];
        b = b ? [g].concat(b) : [g];
      }
      if (k > 25) {
        let g = [x.lookAhead, k];
        b = b ? [g].concat(b) : [g];
      }
      return new V(S, y, j, T, b);
    }
    function R(S, y) {
      let j = l.fork(), T = 0, k = 0, b = 0, g = j.end - i2, O = { size: 0, start: 0, skip: 0 };
      t:
        for (let F = j.pos - S; j.pos > F; ) {
          let w = j.size;
          if (j.id == y && w >= 0) {
            O.size = T, O.start = k, O.skip = b, b += 4, T += 4, j.next();
            continue;
          }
          let D = j.pos - w;
          if (w < 0 || D < F || j.start < g)
            break;
          let it = j.id >= o2 ? 4 : 0, $t = j.start;
          for (j.next(); j.pos > D; ) {
            if (j.size < 0)
              if (j.size == -3)
                it += 4;
              else
                break t;
            else
              j.id >= o2 && (it += 4);
            j.next();
          }
          k = $t, T += w, b += it;
        }
      return (y < 0 || T == S) && (O.size = T, O.start = k, O.skip = b), O.size > 4 ? O : void 0;
    }
    function I(S, y, j) {
      let { id: T, start: k, end: b, size: g } = l;
      if (l.next(), g >= 0 && T < o2) {
        let O = j;
        if (g > 4) {
          let F = l.pos - (g - 4);
          for (; l.pos > F; )
            j = I(S, y, j);
        }
        y[--j] = O, y[--j] = b - S, y[--j] = k - S, y[--j] = T;
      } else
        g == -3 ? h = T : g == -4 && (u = T);
      return j;
    }
    let z = [], J = [];
    for (; l.pos > 0; )
      $(r2.start || 0, r2.bufferStart || 0, z, J, -1, 0);
    let N = (t2 = r2.length) !== null && t2 !== void 0 ? t2 : z.length ? J[0] + z[0].length : 0;
    return new V(a2[r2.topID], z.reverse(), J.reverse(), N);
  }
  const qe = /* @__PURE__ */ new WeakMap();
  function At(r2, t2) {
    if (!r2.isAnonymous || t2 instanceof st || t2.type != r2)
      return 1;
    let e = qe.get(t2);
    if (e == null) {
      e = 1;
      for (let s of t2.children) {
        if (s.type != r2 || !(s instanceof V)) {
          e = 1;
          break;
        }
        e += At(r2, s);
      }
      qe.set(t2, e);
    }
    return e;
  }
  function ve(r2, t2, e, s, i2, n, o2, l, a2) {
    let h = 0;
    for (let d = s; d < i2; d++)
      h += At(r2, t2[d]);
    let u = Math.ceil(
      h * 1.5 / 8
      /* Balance.BranchFactor */
    ), $ = [], f = [];
    function c2(d, m2, R, I, z) {
      for (let J = R; J < I; ) {
        let N = J, S = m2[J], y = At(r2, d[J]);
        for (J++; J < I; J++) {
          let j = At(r2, d[J]);
          if (y + j >= u)
            break;
          y += j;
        }
        if (J == N + 1) {
          if (y > u) {
            let j = d[N];
            c2(j.children, j.positions, 0, j.children.length, m2[N] + z);
            continue;
          }
          $.push(d[N]);
        } else {
          let j = m2[J - 1] + d[J - 1].length - S;
          $.push(ve(r2, d, m2, N, J, S, j, null, a2));
        }
        f.push(S + z - n);
      }
    }
    return c2(t2, e, s, i2, 0), (l || a2)($, f, o2);
  }
  class ut {
    /**
    Construct a tree fragment. You'll usually want to use
    [`addTree`](#common.TreeFragment^addTree) and
    [`applyChanges`](#common.TreeFragment^applyChanges) instead of
    calling this directly.
    */
    constructor(t2, e, s, i2, n = false, o2 = false) {
      this.from = t2, this.to = e, this.tree = s, this.offset = i2, this.open = (n ? 1 : 0) | (o2 ? 2 : 0);
    }
    /**
    Whether the start of the fragment represents the start of a
    parse, or the end of a change. (In the second case, it may not
    be safe to reuse some nodes at the start, depending on the
    parsing algorithm.)
    */
    get openStart() {
      return (this.open & 1) > 0;
    }
    /**
    Whether the end of the fragment represents the end of a
    full-document parse, or the start of a change.
    */
    get openEnd() {
      return (this.open & 2) > 0;
    }
    /**
    Create a set of fragments from a freshly parsed tree, or update
    an existing set of fragments by replacing the ones that overlap
    with a tree with content from the new tree. When `partial` is
    true, the parse is treated as incomplete, and the resulting
    fragment has [`openEnd`](#common.TreeFragment.openEnd) set to
    true.
    */
    static addTree(t2, e = [], s = false) {
      let i2 = [new ut(0, t2.length, t2, 0, false, s)];
      for (let n of e)
        n.to > t2.length && i2.push(n);
      return i2;
    }
    /**
    Apply a set of edits to an array of fragments, removing or
    splitting fragments as necessary to remove edited ranges, and
    adjusting offsets for fragments that moved.
    */
    static applyChanges(t2, e, s = 128) {
      if (!e.length)
        return t2;
      let i2 = [], n = 1, o2 = t2.length ? t2[0] : null;
      for (let l = 0, a2 = 0, h = 0; ; l++) {
        let u = l < e.length ? e[l] : null, $ = u ? u.fromA : 1e9;
        if ($ - a2 >= s)
          for (; o2 && o2.from < $; ) {
            let f = o2;
            if (a2 >= f.from || $ <= f.to || h) {
              let c2 = Math.max(f.from, a2) - h, d = Math.min(f.to, $) - h;
              f = c2 >= d ? null : new ut(c2, d, f.tree, f.offset + h, l > 0, !!u);
            }
            if (f && i2.push(f), o2.to > $)
              break;
            o2 = n < t2.length ? t2[n++] : null;
          }
        if (!u)
          break;
        a2 = u.toA, h = u.toA - u.toB;
      }
      return i2;
    }
  }
  class ys {
    /**
    Start a parse, returning a [partial parse](#common.PartialParse)
    object. [`fragments`](#common.TreeFragment) can be passed in to
    make the parse incremental.
    
    By default, the entire input is parsed. You can pass `ranges`,
    which should be a sorted array of non-empty, non-overlapping
    ranges, to parse only those ranges. The tree returned in that
    case will start at `ranges[0].from`.
    */
    startParse(t2, e, s) {
      return typeof t2 == "string" && (t2 = new Zs(t2)), s = s ? s.length ? s.map((i2) => new ie$1(i2.from, i2.to)) : [new ie$1(0, 0)] : [new ie$1(0, t2.length)], this.createParse(t2, e || [], s);
    }
    /**
    Run a full parse, returning the resulting tree.
    */
    parse(t2, e, s) {
      let i2 = this.startParse(t2, e, s);
      for (; ; ) {
        let n = i2.advance();
        if (n)
          return n;
      }
    }
  }
  class Zs {
    constructor(t2) {
      this.string = t2;
    }
    get length() {
      return this.string.length;
    }
    chunk(t2) {
      return this.string.slice(t2);
    }
    get lineChunks() {
      return false;
    }
    read(t2, e) {
      return this.string.slice(t2, e);
    }
  }
  new x({ perNode: true });
  class Xt {
    /**
    @internal
    */
    constructor(t2, e, s, i2, n, o2, l, a2, h, u = 0, $) {
      this.p = t2, this.stack = e, this.state = s, this.reducePos = i2, this.pos = n, this.score = o2, this.buffer = l, this.bufferBase = a2, this.curContext = h, this.lookAhead = u, this.parent = $;
    }
    /**
    @internal
    */
    toString() {
      return `[${this.stack.filter((t2, e) => e % 3 == 0).concat(this.state)}]@${this.pos}${this.score ? "!" + this.score : ""}`;
    }
    // Start an empty stack
    /**
    @internal
    */
    static start(t2, e, s = 0) {
      let i2 = t2.parser.context;
      return new Xt(t2, [], e, s, s, 0, [], 0, i2 ? new Ee(i2, i2.start) : null, 0, null);
    }
    /**
    The stack's current [context](#lr.ContextTracker) value, if
    any. Its type will depend on the context tracker's type
    parameter, or it will be `null` if there is no context
    tracker.
    */
    get context() {
      return this.curContext ? this.curContext.context : null;
    }
    // Push a state onto the stack, tracking its start position as well
    // as the buffer base at that point.
    /**
    @internal
    */
    pushState(t2, e) {
      this.stack.push(this.state, e, this.bufferBase + this.buffer.length), this.state = t2;
    }
    // Apply a reduce action
    /**
    @internal
    */
    reduce(t2) {
      var e;
      let s = t2 >> 19, i2 = t2 & 65535, { parser: n } = this.p, o2 = n.dynamicPrecedence(i2);
      if (o2 && (this.score += o2), s == 0) {
        this.pushState(n.getGoto(this.state, i2, true), this.reducePos), i2 < n.minRepeatTerm && this.storeNode(i2, this.reducePos, this.reducePos, 4, true), this.reduceContext(i2, this.reducePos);
        return;
      }
      let l = this.stack.length - (s - 1) * 3 - (t2 & 262144 ? 6 : 0), a2 = l ? this.stack[l - 2] : this.p.ranges[0].from, h = this.reducePos - a2;
      h >= 2e3 && !(!((e = this.p.parser.nodeSet.types[i2]) === null || e === void 0) && e.isAnonymous) && (a2 == this.p.lastBigReductionStart ? (this.p.bigReductionCount++, this.p.lastBigReductionSize = h) : this.p.lastBigReductionSize < h && (this.p.bigReductionCount = 1, this.p.lastBigReductionStart = a2, this.p.lastBigReductionSize = h));
      let u = l ? this.stack[l - 1] : 0, $ = this.bufferBase + this.buffer.length - u;
      if (i2 < n.minRepeatTerm || t2 & 131072) {
        let f = n.stateFlag(
          this.state,
          1
          /* StateFlag.Skipped */
        ) ? this.pos : this.reducePos;
        this.storeNode(i2, a2, f, $ + 4, true);
      }
      if (t2 & 262144)
        this.state = this.stack[l];
      else {
        let f = this.stack[l - 3];
        this.state = n.getGoto(f, i2, true);
      }
      for (; this.stack.length > l; )
        this.stack.pop();
      this.reduceContext(i2, a2);
    }
    // Shift a value into the buffer
    /**
    @internal
    */
    storeNode(t2, e, s, i2 = 4, n = false) {
      if (t2 == 0 && (!this.stack.length || this.stack[this.stack.length - 1] < this.buffer.length + this.bufferBase)) {
        let o2 = this, l = this.buffer.length;
        if (l == 0 && o2.parent && (l = o2.bufferBase - o2.parent.bufferBase, o2 = o2.parent), l > 0 && o2.buffer[l - 4] == 0 && o2.buffer[l - 1] > -1) {
          if (e == s)
            return;
          if (o2.buffer[l - 2] >= e) {
            o2.buffer[l - 2] = s;
            return;
          }
        }
      }
      if (!n || this.pos == s)
        this.buffer.push(t2, e, s, i2);
      else {
        let o2 = this.buffer.length;
        if (o2 > 0 && this.buffer[o2 - 4] != 0)
          for (; o2 > 0 && this.buffer[o2 - 2] > s; )
            this.buffer[o2] = this.buffer[o2 - 4], this.buffer[o2 + 1] = this.buffer[o2 - 3], this.buffer[o2 + 2] = this.buffer[o2 - 2], this.buffer[o2 + 3] = this.buffer[o2 - 1], o2 -= 4, i2 > 4 && (i2 -= 4);
        this.buffer[o2] = t2, this.buffer[o2 + 1] = e, this.buffer[o2 + 2] = s, this.buffer[o2 + 3] = i2;
      }
    }
    // Apply a shift action
    /**
    @internal
    */
    shift(t2, e, s, i2) {
      if (t2 & 131072)
        this.pushState(t2 & 65535, this.pos);
      else if (t2 & 262144)
        this.pos = i2, this.shiftContext(e, s), e <= this.p.parser.maxNode && this.buffer.push(e, s, i2, 4);
      else {
        let n = t2, { parser: o2 } = this.p;
        (i2 > this.pos || e <= o2.maxNode) && (this.pos = i2, o2.stateFlag(
          n,
          1
          /* StateFlag.Skipped */
        ) || (this.reducePos = i2)), this.pushState(n, s), this.shiftContext(e, s), e <= o2.maxNode && this.buffer.push(e, s, i2, 4);
      }
    }
    // Apply an action
    /**
    @internal
    */
    apply(t2, e, s, i2) {
      t2 & 65536 ? this.reduce(t2) : this.shift(t2, e, s, i2);
    }
    // Add a prebuilt (reused) node into the buffer.
    /**
    @internal
    */
    useNode(t2, e) {
      let s = this.p.reused.length - 1;
      (s < 0 || this.p.reused[s] != t2) && (this.p.reused.push(t2), s++);
      let i2 = this.pos;
      this.reducePos = this.pos = i2 + t2.length, this.pushState(e, i2), this.buffer.push(
        s,
        i2,
        this.reducePos,
        -1
        /* size == -1 means this is a reused value */
      ), this.curContext && this.updateContext(this.curContext.tracker.reuse(this.curContext.context, t2, this, this.p.stream.reset(this.pos - t2.length)));
    }
    // Split the stack. Due to the buffer sharing and the fact
    // that `this.stack` tends to stay quite shallow, this isn't very
    // expensive.
    /**
    @internal
    */
    split() {
      let t2 = this, e = t2.buffer.length;
      for (; e > 0 && t2.buffer[e - 2] > t2.reducePos; )
        e -= 4;
      let s = t2.buffer.slice(e), i2 = t2.bufferBase + e;
      for (; t2 && i2 == t2.bufferBase; )
        t2 = t2.parent;
      return new Xt(this.p, this.stack.slice(), this.state, this.reducePos, this.pos, this.score, s, i2, this.curContext, this.lookAhead, t2);
    }
    // Try to recover from an error by 'deleting' (ignoring) one token.
    /**
    @internal
    */
    recoverByDelete(t2, e) {
      let s = t2 <= this.p.parser.maxNode;
      s && this.storeNode(t2, this.pos, e, 4), this.storeNode(0, this.pos, e, s ? 8 : 4), this.pos = this.reducePos = e, this.score -= 190;
    }
    /**
    Check if the given term would be able to be shifted (optionally
    after some reductions) on this stack. This can be useful for
    external tokenizers that want to make sure they only provide a
    given token when it applies.
    */
    canShift(t2) {
      for (let e = new Ls(this); ; ) {
        let s = this.p.parser.stateSlot(
          e.state,
          4
          /* ParseState.DefaultReduce */
        ) || this.p.parser.hasAction(e.state, t2);
        if (s == 0)
          return false;
        if (!(s & 65536))
          return true;
        e.reduce(s);
      }
    }
    // Apply up to Recover.MaxNext recovery actions that conceptually
    // inserts some missing token or rule.
    /**
    @internal
    */
    recoverByInsert(t2) {
      if (this.stack.length >= 300)
        return [];
      let e = this.p.parser.nextStates(this.state);
      if (e.length > 8 || this.stack.length >= 120) {
        let i2 = [];
        for (let n = 0, o2; n < e.length; n += 2)
          (o2 = e[n + 1]) != this.state && this.p.parser.hasAction(o2, t2) && i2.push(e[n], o2);
        if (this.stack.length < 120)
          for (let n = 0; i2.length < 8 && n < e.length; n += 2) {
            let o2 = e[n + 1];
            i2.some((l, a2) => a2 & 1 && l == o2) || i2.push(e[n], o2);
          }
        e = i2;
      }
      let s = [];
      for (let i2 = 0; i2 < e.length && s.length < 4; i2 += 2) {
        let n = e[i2 + 1];
        if (n == this.state)
          continue;
        let o2 = this.split();
        o2.pushState(n, this.pos), o2.storeNode(0, o2.pos, o2.pos, 4, true), o2.shiftContext(e[i2], this.pos), o2.reducePos = this.pos, o2.score -= 200, s.push(o2);
      }
      return s;
    }
    // Force a reduce, if possible. Return false if that can't
    // be done.
    /**
    @internal
    */
    forceReduce() {
      let { parser: t2 } = this.p, e = t2.stateSlot(
        this.state,
        5
        /* ParseState.ForcedReduce */
      );
      if (!(e & 65536))
        return false;
      if (!t2.validAction(this.state, e)) {
        let s = e >> 19, i2 = e & 65535, n = this.stack.length - s * 3;
        if (n < 0 || t2.getGoto(this.stack[n], i2, false) < 0) {
          let o2 = this.findForcedReduction();
          if (o2 == null)
            return false;
          e = o2;
        }
        this.storeNode(0, this.pos, this.pos, 4, true), this.score -= 100;
      }
      return this.reducePos = this.pos, this.reduce(e), true;
    }
    /**
    Try to scan through the automaton to find some kind of reduction
    that can be applied. Used when the regular ForcedReduce field
    isn't a valid action. @internal
    */
    findForcedReduction() {
      let { parser: t2 } = this.p, e = [], s = (i2, n) => {
        if (!e.includes(i2))
          return e.push(i2), t2.allActions(i2, (o2) => {
            if (!(o2 & 393216))
              if (o2 & 65536) {
                let l = (o2 >> 19) - n;
                if (l > 1) {
                  let a2 = o2 & 65535, h = this.stack.length - l * 3;
                  if (h >= 0 && t2.getGoto(this.stack[h], a2, false) >= 0)
                    return l << 19 | 65536 | a2;
                }
              } else {
                let l = s(o2, n + 1);
                if (l != null)
                  return l;
              }
          });
      };
      return s(this.state, 0);
    }
    /**
    @internal
    */
    forceAll() {
      for (; !this.p.parser.stateFlag(
        this.state,
        2
        /* StateFlag.Accepting */
      ); )
        if (!this.forceReduce()) {
          this.storeNode(0, this.pos, this.pos, 4, true);
          break;
        }
      return this;
    }
    /**
    Check whether this state has no further actions (assumed to be a direct descendant of the
    top state, since any other states must be able to continue
    somehow). @internal
    */
    get deadEnd() {
      if (this.stack.length != 3)
        return false;
      let { parser: t2 } = this.p;
      return t2.data[t2.stateSlot(
        this.state,
        1
        /* ParseState.Actions */
      )] == 65535 && !t2.stateSlot(
        this.state,
        4
        /* ParseState.DefaultReduce */
      );
    }
    /**
    Restart the stack (put it back in its start state). Only safe
    when this.stack.length == 3 (state is directly below the top
    state). @internal
    */
    restart() {
      this.storeNode(0, this.pos, this.pos, 4, true), this.state = this.stack[0], this.stack.length = 0;
    }
    /**
    @internal
    */
    sameState(t2) {
      if (this.state != t2.state || this.stack.length != t2.stack.length)
        return false;
      for (let e = 0; e < this.stack.length; e += 3)
        if (this.stack[e] != t2.stack[e])
          return false;
      return true;
    }
    /**
    Get the parser used by this stack.
    */
    get parser() {
      return this.p.parser;
    }
    /**
    Test whether a given dialect (by numeric ID, as exported from
    the terms file) is enabled.
    */
    dialectEnabled(t2) {
      return this.p.parser.dialect.flags[t2];
    }
    shiftContext(t2, e) {
      this.curContext && this.updateContext(this.curContext.tracker.shift(this.curContext.context, t2, this, this.p.stream.reset(e)));
    }
    reduceContext(t2, e) {
      this.curContext && this.updateContext(this.curContext.tracker.reduce(this.curContext.context, t2, this, this.p.stream.reset(e)));
    }
    /**
    @internal
    */
    emitContext() {
      let t2 = this.buffer.length - 1;
      (t2 < 0 || this.buffer[t2] != -3) && this.buffer.push(this.curContext.hash, this.pos, this.pos, -3);
    }
    /**
    @internal
    */
    emitLookAhead() {
      let t2 = this.buffer.length - 1;
      (t2 < 0 || this.buffer[t2] != -4) && this.buffer.push(this.lookAhead, this.pos, this.pos, -4);
    }
    updateContext(t2) {
      if (t2 != this.curContext.context) {
        let e = new Ee(this.curContext.tracker, t2);
        e.hash != this.curContext.hash && this.emitContext(), this.curContext = e;
      }
    }
    /**
    @internal
    */
    setLookAhead(t2) {
      t2 > this.lookAhead && (this.emitLookAhead(), this.lookAhead = t2);
    }
    /**
    @internal
    */
    close() {
      this.curContext && this.curContext.tracker.strict && this.emitContext(), this.lookAhead > 0 && this.emitLookAhead();
    }
  }
  class Ee {
    constructor(t2, e) {
      this.tracker = t2, this.context = e, this.hash = t2.strict ? t2.hash(e) : 0;
    }
  }
  class Ls {
    constructor(t2) {
      this.start = t2, this.state = t2.state, this.stack = t2.stack, this.base = this.stack.length;
    }
    reduce(t2) {
      let e = t2 & 65535, s = t2 >> 19;
      s == 0 ? (this.stack == this.start.stack && (this.stack = this.stack.slice()), this.stack.push(this.state, 0, 0), this.base += 3) : this.base -= (s - 1) * 3;
      let i2 = this.start.p.parser.getGoto(this.stack[this.base - 3], e, true);
      this.state = i2;
    }
  }
  let _t$2 = class _t5 {
    constructor(t2, e, s) {
      this.stack = t2, this.pos = e, this.index = s, this.buffer = t2.buffer, this.index == 0 && this.maybeNext();
    }
    static create(t2, e = t2.bufferBase + t2.buffer.length) {
      return new _t5(t2, e, e - t2.bufferBase);
    }
    maybeNext() {
      let t2 = this.stack.parent;
      t2 != null && (this.index = this.stack.bufferBase - t2.bufferBase, this.stack = t2, this.buffer = t2.buffer);
    }
    get id() {
      return this.buffer[this.index - 4];
    }
    get start() {
      return this.buffer[this.index - 3];
    }
    get end() {
      return this.buffer[this.index - 2];
    }
    get size() {
      return this.buffer[this.index - 1];
    }
    next() {
      this.index -= 4, this.pos -= 4, this.index == 0 && this.maybeNext();
    }
    fork() {
      return new _t5(this.stack, this.pos, this.index);
    }
  };
  function It(r2, t2 = Uint16Array) {
    if (typeof r2 != "string")
      return r2;
    let e = null;
    for (let s = 0, i2 = 0; s < r2.length; ) {
      let n = 0;
      for (; ; ) {
        let o2 = r2.charCodeAt(s++), l = false;
        if (o2 == 126) {
          n = 65535;
          break;
        }
        o2 >= 92 && o2--, o2 >= 34 && o2--;
        let a2 = o2 - 32;
        if (a2 >= 46 && (a2 -= 46, l = true), n += a2, l)
          break;
        n *= 46;
      }
      e ? e[i2++] = n : e = new t2(n);
    }
    return e;
  }
  class Gt {
    constructor() {
      this.start = -1, this.value = -1, this.end = -1, this.extended = -1, this.lookAhead = 0, this.mask = 0, this.context = 0;
    }
  }
  const Ae = new Gt();
  class Ms {
    /**
    @internal
    */
    constructor(t2, e) {
      this.input = t2, this.ranges = e, this.chunk = "", this.chunkOff = 0, this.chunk2 = "", this.chunk2Pos = 0, this.next = -1, this.token = Ae, this.rangeIndex = 0, this.pos = this.chunkPos = e[0].from, this.range = e[0], this.end = e[e.length - 1].to, this.readNext();
    }
    /**
    @internal
    */
    resolveOffset(t2, e) {
      let s = this.range, i2 = this.rangeIndex, n = this.pos + t2;
      for (; n < s.from; ) {
        if (!i2)
          return null;
        let o2 = this.ranges[--i2];
        n -= s.from - o2.to, s = o2;
      }
      for (; e < 0 ? n > s.to : n >= s.to; ) {
        if (i2 == this.ranges.length - 1)
          return null;
        let o2 = this.ranges[++i2];
        n += o2.from - s.to, s = o2;
      }
      return n;
    }
    /**
    @internal
    */
    clipPos(t2) {
      if (t2 >= this.range.from && t2 < this.range.to)
        return t2;
      for (let e of this.ranges)
        if (e.to > t2)
          return Math.max(t2, e.from);
      return this.end;
    }
    /**
    Look at a code unit near the stream position. `.peek(0)` equals
    `.next`, `.peek(-1)` gives you the previous character, and so
    on.
    
    Note that looking around during tokenizing creates dependencies
    on potentially far-away content, which may reduce the
    effectiveness incremental parsing—when looking forward—or even
    cause invalid reparses when looking backward more than 25 code
    units, since the library does not track lookbehind.
    */
    peek(t2) {
      let e = this.chunkOff + t2, s, i2;
      if (e >= 0 && e < this.chunk.length)
        s = this.pos + t2, i2 = this.chunk.charCodeAt(e);
      else {
        let n = this.resolveOffset(t2, 1);
        if (n == null)
          return -1;
        if (s = n, s >= this.chunk2Pos && s < this.chunk2Pos + this.chunk2.length)
          i2 = this.chunk2.charCodeAt(s - this.chunk2Pos);
        else {
          let o2 = this.rangeIndex, l = this.range;
          for (; l.to <= s; )
            l = this.ranges[++o2];
          this.chunk2 = this.input.chunk(this.chunk2Pos = s), s + this.chunk2.length > l.to && (this.chunk2 = this.chunk2.slice(0, l.to - s)), i2 = this.chunk2.charCodeAt(0);
        }
      }
      return s >= this.token.lookAhead && (this.token.lookAhead = s + 1), i2;
    }
    /**
    Accept a token. By default, the end of the token is set to the
    current stream position, but you can pass an offset (relative to
    the stream position) to change that.
    */
    acceptToken(t2, e = 0) {
      let s = e ? this.resolveOffset(e, -1) : this.pos;
      if (s == null || s < this.token.start)
        throw new RangeError("Token end out of bounds");
      this.token.value = t2, this.token.end = s;
    }
    getChunk() {
      if (this.pos >= this.chunk2Pos && this.pos < this.chunk2Pos + this.chunk2.length) {
        let { chunk: t2, chunkPos: e } = this;
        this.chunk = this.chunk2, this.chunkPos = this.chunk2Pos, this.chunk2 = t2, this.chunk2Pos = e, this.chunkOff = this.pos - this.chunkPos;
      } else {
        this.chunk2 = this.chunk, this.chunk2Pos = this.chunkPos;
        let t2 = this.input.chunk(this.pos), e = this.pos + t2.length;
        this.chunk = e > this.range.to ? t2.slice(0, this.range.to - this.pos) : t2, this.chunkPos = this.pos, this.chunkOff = 0;
      }
    }
    readNext() {
      return this.chunkOff >= this.chunk.length && (this.getChunk(), this.chunkOff == this.chunk.length) ? this.next = -1 : this.next = this.chunk.charCodeAt(this.chunkOff);
    }
    /**
    Move the stream forward N (defaults to 1) code units. Returns
    the new value of [`next`](#lr.InputStream.next).
    */
    advance(t2 = 1) {
      for (this.chunkOff += t2; this.pos + t2 >= this.range.to; ) {
        if (this.rangeIndex == this.ranges.length - 1)
          return this.setDone();
        t2 -= this.range.to - this.pos, this.range = this.ranges[++this.rangeIndex], this.pos = this.range.from;
      }
      return this.pos += t2, this.pos >= this.token.lookAhead && (this.token.lookAhead = this.pos + 1), this.readNext();
    }
    setDone() {
      return this.pos = this.chunkPos = this.end, this.range = this.ranges[this.rangeIndex = this.ranges.length - 1], this.chunk = "", this.next = -1;
    }
    /**
    @internal
    */
    reset(t2, e) {
      if (e ? (this.token = e, e.start = t2, e.lookAhead = t2 + 1, e.value = e.extended = -1) : this.token = Ae, this.pos != t2) {
        if (this.pos = t2, t2 == this.end)
          return this.setDone(), this;
        for (; t2 < this.range.from; )
          this.range = this.ranges[--this.rangeIndex];
        for (; t2 >= this.range.to; )
          this.range = this.ranges[++this.rangeIndex];
        t2 >= this.chunkPos && t2 < this.chunkPos + this.chunk.length ? this.chunkOff = t2 - this.chunkPos : (this.chunk = "", this.chunkOff = 0), this.readNext();
      }
      return this;
    }
    /**
    @internal
    */
    read(t2, e) {
      if (t2 >= this.chunkPos && e <= this.chunkPos + this.chunk.length)
        return this.chunk.slice(t2 - this.chunkPos, e - this.chunkPos);
      if (t2 >= this.chunk2Pos && e <= this.chunk2Pos + this.chunk2.length)
        return this.chunk2.slice(t2 - this.chunk2Pos, e - this.chunk2Pos);
      if (t2 >= this.range.from && e <= this.range.to)
        return this.input.read(t2, e);
      let s = "";
      for (let i2 of this.ranges) {
        if (i2.from >= e)
          break;
        i2.to > t2 && (s += this.input.read(Math.max(i2.from, t2), Math.min(i2.to, e)));
      }
      return s;
    }
  }
  class dt {
    constructor(t2, e) {
      this.data = t2, this.id = e;
    }
    token(t2, e) {
      let { parser: s } = e.p;
      Hs(this.data, t2, e, this.id, s.data, s.tokenPrecTable);
    }
  }
  dt.prototype.contextual = dt.prototype.fallback = dt.prototype.extend = false;
  dt.prototype.fallback = dt.prototype.extend = false;
  class Js {
    /**
    Create a tokenizer. The first argument is the function that,
    given an input stream, scans for the types of tokens it
    recognizes at the stream's position, and calls
    [`acceptToken`](#lr.InputStream.acceptToken) when it finds
    one.
    */
    constructor(t2, e = {}) {
      this.token = t2, this.contextual = !!e.contextual, this.fallback = !!e.fallback, this.extend = !!e.extend;
    }
  }
  function Hs(r2, t2, e, s, i2, n) {
    let o2 = 0, l = 1 << s, { dialect: a2 } = e.p.parser;
    t:
      for (; l & r2[o2]; ) {
        let h = r2[o2 + 1];
        for (let c2 = o2 + 3; c2 < h; c2 += 2)
          if ((r2[c2 + 1] & l) > 0) {
            let d = r2[c2];
            if (a2.allows(d) && (t2.token.value == -1 || t2.token.value == d || ti(d, t2.token.value, i2, n))) {
              t2.acceptToken(d);
              break;
            }
          }
        let u = t2.next, $ = 0, f = r2[o2 + 2];
        if (t2.next < 0 && f > $ && r2[h + f * 3 - 3] == 65535) {
          o2 = r2[h + f * 3 - 1];
          continue t;
        }
        for (; $ < f; ) {
          let c2 = $ + f >> 1, d = h + c2 + (c2 << 1), m2 = r2[d], R = r2[d + 1] || 65536;
          if (u < m2)
            f = c2;
          else if (u >= R)
            $ = c2 + 1;
          else {
            o2 = r2[d + 2], t2.advance();
            continue t;
          }
        }
        break;
      }
  }
  function Ge(r2, t2, e) {
    for (let s = t2, i2; (i2 = r2[s]) != 65535; s++)
      if (i2 == e)
        return s - t2;
    return -1;
  }
  function ti(r2, t2, e, s) {
    let i2 = Ge(e, s, t2);
    return i2 < 0 || Ge(e, s, r2) < i2;
  }
  const P = typeof process < "u" && process.env && /\bparse\b/.test(process.env.LOG);
  let re = null;
  function Ne(r2, t2, e) {
    let s = r2.cursor(v.IncludeAnonymous);
    for (s.moveTo(t2); ; )
      if (!(e < 0 ? s.childBefore(t2) : s.childAfter(t2)))
        for (; ; ) {
          if ((e < 0 ? s.to < t2 : s.from > t2) && !s.type.isError)
            return e < 0 ? Math.max(0, Math.min(
              s.to - 1,
              t2 - 25
              /* Safety.Margin */
            )) : Math.min(r2.length, Math.max(
              s.from + 1,
              t2 + 25
              /* Safety.Margin */
            ));
          if (e < 0 ? s.prevSibling() : s.nextSibling())
            break;
          if (!s.parent())
            return e < 0 ? 0 : r2.length;
        }
  }
  class ei {
    constructor(t2, e) {
      this.fragments = t2, this.nodeSet = e, this.i = 0, this.fragment = null, this.safeFrom = -1, this.safeTo = -1, this.trees = [], this.start = [], this.index = [], this.nextFragment();
    }
    nextFragment() {
      let t2 = this.fragment = this.i == this.fragments.length ? null : this.fragments[this.i++];
      if (t2) {
        for (this.safeFrom = t2.openStart ? Ne(t2.tree, t2.from + t2.offset, 1) - t2.offset : t2.from, this.safeTo = t2.openEnd ? Ne(t2.tree, t2.to + t2.offset, -1) - t2.offset : t2.to; this.trees.length; )
          this.trees.pop(), this.start.pop(), this.index.pop();
        this.trees.push(t2.tree), this.start.push(-t2.offset), this.index.push(0), this.nextStart = this.safeFrom;
      } else
        this.nextStart = 1e9;
    }
    // `pos` must be >= any previously given `pos` for this cursor
    nodeAt(t2) {
      if (t2 < this.nextStart)
        return null;
      for (; this.fragment && this.safeTo <= t2; )
        this.nextFragment();
      if (!this.fragment)
        return null;
      for (; ; ) {
        let e = this.trees.length - 1;
        if (e < 0)
          return this.nextFragment(), null;
        let s = this.trees[e], i2 = this.index[e];
        if (i2 == s.children.length) {
          this.trees.pop(), this.start.pop(), this.index.pop();
          continue;
        }
        let n = s.children[i2], o2 = this.start[e] + s.positions[i2];
        if (o2 > t2)
          return this.nextStart = o2, null;
        if (n instanceof V) {
          if (o2 == t2) {
            if (o2 < this.safeFrom)
              return null;
            let l = o2 + n.length;
            if (l <= this.safeTo) {
              let a2 = n.prop(x.lookAhead);
              if (!a2 || l + a2 < this.fragment.to)
                return n;
            }
          }
          this.index[e]++, o2 + n.length >= Math.max(this.safeFrom, t2) && (this.trees.push(n), this.start.push(o2), this.index.push(0));
        } else
          this.index[e]++, this.nextStart = o2 + n.length;
      }
    }
  }
  class si {
    constructor(t2, e) {
      this.stream = e, this.tokens = [], this.mainToken = null, this.actions = [], this.tokens = t2.tokenizers.map((s) => new Gt());
    }
    getActions(t2) {
      let e = 0, s = null, { parser: i2 } = t2.p, { tokenizers: n } = i2, o2 = i2.stateSlot(
        t2.state,
        3
        /* ParseState.TokenizerMask */
      ), l = t2.curContext ? t2.curContext.hash : 0, a2 = 0;
      for (let h = 0; h < n.length; h++) {
        if (!(1 << h & o2))
          continue;
        let u = n[h], $ = this.tokens[h];
        if (!(s && !u.fallback) && ((u.contextual || $.start != t2.pos || $.mask != o2 || $.context != l) && (this.updateCachedToken($, u, t2), $.mask = o2, $.context = l), $.lookAhead > $.end + 25 && (a2 = Math.max($.lookAhead, a2)), $.value != 0)) {
          let f = e;
          if ($.extended > -1 && (e = this.addActions(t2, $.extended, $.end, e)), e = this.addActions(t2, $.value, $.end, e), !u.extend && (s = $, e > f))
            break;
        }
      }
      for (; this.actions.length > e; )
        this.actions.pop();
      return a2 && t2.setLookAhead(a2), !s && t2.pos == this.stream.end && (s = new Gt(), s.value = t2.p.parser.eofTerm, s.start = s.end = t2.pos, e = this.addActions(t2, s.value, s.end, e)), this.mainToken = s, this.actions;
    }
    getMainToken(t2) {
      if (this.mainToken)
        return this.mainToken;
      let e = new Gt(), { pos: s, p: i2 } = t2;
      return e.start = s, e.end = Math.min(s + 1, i2.stream.end), e.value = s == i2.stream.end ? i2.parser.eofTerm : 0, e;
    }
    updateCachedToken(t2, e, s) {
      let i2 = this.stream.clipPos(s.pos);
      if (e.token(this.stream.reset(i2, t2), s), t2.value > -1) {
        let { parser: n } = s.p;
        for (let o2 = 0; o2 < n.specialized.length; o2++)
          if (n.specialized[o2] == t2.value) {
            let l = n.specializers[o2](this.stream.read(t2.start, t2.end), s);
            if (l >= 0 && s.p.parser.dialect.allows(l >> 1)) {
              l & 1 ? t2.extended = l >> 1 : t2.value = l >> 1;
              break;
            }
          }
      } else
        t2.value = 0, t2.end = this.stream.clipPos(i2 + 1);
    }
    putAction(t2, e, s, i2) {
      for (let n = 0; n < i2; n += 3)
        if (this.actions[n] == t2)
          return i2;
      return this.actions[i2++] = t2, this.actions[i2++] = e, this.actions[i2++] = s, i2;
    }
    addActions(t2, e, s, i2) {
      let { state: n } = t2, { parser: o2 } = t2.p, { data: l } = o2;
      for (let a2 = 0; a2 < 2; a2++)
        for (let h = o2.stateSlot(
          n,
          a2 ? 2 : 1
          /* ParseState.Actions */
        ); ; h += 3) {
          if (l[h] == 65535)
            if (l[h + 1] == 1)
              h = L(l, h + 2);
            else {
              i2 == 0 && l[h + 1] == 2 && (i2 = this.putAction(L(l, h + 2), e, s, i2));
              break;
            }
          l[h] == e && (i2 = this.putAction(L(l, h + 1), e, s, i2));
        }
      return i2;
    }
  }
  class ii {
    constructor(t2, e, s, i2) {
      this.parser = t2, this.input = e, this.ranges = i2, this.recovering = 0, this.nextStackID = 9812, this.minStackPos = 0, this.reused = [], this.stoppedAt = null, this.lastBigReductionStart = -1, this.lastBigReductionSize = 0, this.bigReductionCount = 0, this.stream = new Ms(e, i2), this.tokens = new si(t2, this.stream), this.topTerm = t2.top[1];
      let { from: n } = i2[0];
      this.stacks = [Xt.start(this, t2.top[0], n)], this.fragments = s.length && this.stream.end - n > t2.bufferLength * 4 ? new ei(s, t2.nodeSet) : null;
    }
    get parsedPos() {
      return this.minStackPos;
    }
    // Move the parser forward. This will process all parse stacks at
    // `this.pos` and try to advance them to a further position. If no
    // stack for such a position is found, it'll start error-recovery.
    //
    // When the parse is finished, this will return a syntax tree. When
    // not, it returns `null`.
    advance() {
      let t2 = this.stacks, e = this.minStackPos, s = this.stacks = [], i2, n;
      if (this.bigReductionCount > 300 && t2.length == 1) {
        let [o2] = t2;
        for (; o2.forceReduce() && o2.stack.length && o2.stack[o2.stack.length - 2] >= this.lastBigReductionStart; )
          ;
        this.bigReductionCount = this.lastBigReductionSize = 0;
      }
      for (let o2 = 0; o2 < t2.length; o2++) {
        let l = t2[o2];
        for (; ; ) {
          if (this.tokens.mainToken = null, l.pos > e)
            s.push(l);
          else {
            if (this.advanceStack(l, s, t2))
              continue;
            {
              i2 || (i2 = [], n = []), i2.push(l);
              let a2 = this.tokens.getMainToken(l);
              n.push(a2.value, a2.end);
            }
          }
          break;
        }
      }
      if (!s.length) {
        let o2 = i2 && ni(i2);
        if (o2)
          return P && console.log("Finish with " + this.stackID(o2)), this.stackToTree(o2);
        if (this.parser.strict)
          throw P && i2 && console.log("Stuck with token " + (this.tokens.mainToken ? this.parser.getName(this.tokens.mainToken.value) : "none")), new SyntaxError("No parse at " + e);
        this.recovering || (this.recovering = 5);
      }
      if (this.recovering && i2) {
        let o2 = this.stoppedAt != null && i2[0].pos > this.stoppedAt ? i2[0] : this.runRecovery(i2, n, s);
        if (o2)
          return P && console.log("Force-finish " + this.stackID(o2)), this.stackToTree(o2.forceAll());
      }
      if (this.recovering) {
        let o2 = this.recovering == 1 ? 1 : this.recovering * 3;
        if (s.length > o2)
          for (s.sort((l, a2) => a2.score - l.score); s.length > o2; )
            s.pop();
        s.some((l) => l.reducePos > e) && this.recovering--;
      } else if (s.length > 1) {
        t:
          for (let o2 = 0; o2 < s.length - 1; o2++) {
            let l = s[o2];
            for (let a2 = o2 + 1; a2 < s.length; a2++) {
              let h = s[a2];
              if (l.sameState(h) || l.buffer.length > 500 && h.buffer.length > 500)
                if ((l.score - h.score || l.buffer.length - h.buffer.length) > 0)
                  s.splice(a2--, 1);
                else {
                  s.splice(o2--, 1);
                  continue t;
                }
            }
          }
        s.length > 12 && s.splice(
          12,
          s.length - 12
          /* Rec.MaxStackCount */
        )