import { getContext } from 'svelte';
import { getGlobalContext } from './GlobalContextPlugin';
/**
 * Returns Tolgee context.
 * @throws Error when context is not defined.
 */
export const getTolgeeContext = () => {
    const context = (getContext('tolgeeContext') || getGlobalContext());
    if (context === undefined) {
        throw Error('Tolgee context is undefined. Trying to use getTranslate method or T component outside TolgeeProvider?');
    }
    return context;
};
