import { CacheDescriptor, CacheDescriptorInternal, DevCredentials, LanguageEvent, NsFallback, NsType, PendingLanguageEvent, RunningEvent } from '../../types';
import { EventEmitterInstance } from '../Events/EventEmitter';
import { TolgeeOptions } from './initState';
export declare function State(onLanguageChange: EventEmitterInstance<LanguageEvent>, onPendingLanguageChange: EventEmitterInstance<PendingLanguageEvent>, onRunningChange: EventEmitterInstance<RunningEvent>): Readonly<{
    init(options?: Partial<TolgeeOptions>): void;
    isRunning(): boolean;
    setRunning(value: boolean): void;
    isInitialLoading(): boolean;
    setInitialLoading(value: boolean): void;
    getLanguage(): string | undefined;
    setLanguage(language: string): void;
    getPendingLanguage(): string | undefined;
    setPendingLanguage(language: string): void;
    getInitialOptions(): {
        apiUrl?: string | undefined;
        apiKey?: string | undefined;
        projectId?: string | number | undefined;
        language?: string | undefined;
        defaultLanguage?: string | undefined;
        availableLanguages?: string[] | undefined;
        fallbackLanguage?: import("../../types").FallbackLanguageOption;
        ns?: string[] | undefined;
        fallbackNs?: import("../../types").FallbackGeneral;
        defaultNs?: string | undefined;
        availableNs?: string[] | undefined;
        staticData?: import("./initState").TolgeeStaticDataProp | undefined;
        observerType: "invisible" | "text";
        observerOptions: import("./observerOptions").ObserverOptionsInternal;
        onFormatError: import("../../types").OnFormatError;
        onTranslationMissing: import("../../types").MissingTranslationHandler;
        fetch: import("../../types").FetchFn;
        tagNewKeys?: string[] | undefined;
        filterTag?: string[] | undefined;
        autoLoadRequiredData: boolean;
    };
    addActiveNs(ns: NsFallback): void;
    removeActiveNs(ns: NsFallback): void;
    getRequiredNamespaces(): string[];
    getFallbackLangs(lang?: string): string[];
    getFallbackNs(): string[];
    getNs(): string[];
    getDefaultNs(ns?: NsType): string;
    getAvailableLanguages(): string[] | undefined;
    getAvailableNs(): string[] | undefined;
    withDefaultNs(descriptor: CacheDescriptor): CacheDescriptorInternal;
    overrideCredentials(credentials: DevCredentials): void;
}>;
export type StateInstance = ReturnType<typeof State>;
